# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BulkRecipientsSummaryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, bulk_recipients=None, bulk_recipients_count=None, bulk_recipients_uri=None, error_details=None):
        """
        BulkRecipientsSummaryResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'bulk_recipients': 'list[BulkRecipient]',
            'bulk_recipients_count': 'str',
            'bulk_recipients_uri': 'str',
            'error_details': 'list[ErrorDetails]'
        }

        self.attribute_map = {
            'bulk_recipients': 'bulkRecipients',
            'bulk_recipients_count': 'bulkRecipientsCount',
            'bulk_recipients_uri': 'bulkRecipientsUri',
            'error_details': 'errorDetails'
        }

        self._bulk_recipients = bulk_recipients
        self._bulk_recipients_count = bulk_recipients_count
        self._bulk_recipients_uri = bulk_recipients_uri
        self._error_details = error_details

    @property
    def bulk_recipients(self):
        """
        Gets the bulk_recipients of this BulkRecipientsSummaryResponse.
        A complex type containing information about the bulk recipients in the response.

        :return: The bulk_recipients of this BulkRecipientsSummaryResponse.
        :rtype: list[BulkRecipient]
        """
        return self._bulk_recipients

    @bulk_recipients.setter
    def bulk_recipients(self, bulk_recipients):
        """
        Sets the bulk_recipients of this BulkRecipientsSummaryResponse.
        A complex type containing information about the bulk recipients in the response.

        :param bulk_recipients: The bulk_recipients of this BulkRecipientsSummaryResponse.
        :type: list[BulkRecipient]
        """

        self._bulk_recipients = bulk_recipients

    @property
    def bulk_recipients_count(self):
        """
        Gets the bulk_recipients_count of this BulkRecipientsSummaryResponse.
        The number of items returned in this response.

        :return: The bulk_recipients_count of this BulkRecipientsSummaryResponse.
        :rtype: str
        """
        return self._bulk_recipients_count

    @bulk_recipients_count.setter
    def bulk_recipients_count(self, bulk_recipients_count):
        """
        Sets the bulk_recipients_count of this BulkRecipientsSummaryResponse.
        The number of items returned in this response.

        :param bulk_recipients_count: The bulk_recipients_count of this BulkRecipientsSummaryResponse.
        :type: str
        """

        self._bulk_recipients_count = bulk_recipients_count

    @property
    def bulk_recipients_uri(self):
        """
        Gets the bulk_recipients_uri of this BulkRecipientsSummaryResponse.
        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.

        :return: The bulk_recipients_uri of this BulkRecipientsSummaryResponse.
        :rtype: str
        """
        return self._bulk_recipients_uri

    @bulk_recipients_uri.setter
    def bulk_recipients_uri(self, bulk_recipients_uri):
        """
        Sets the bulk_recipients_uri of this BulkRecipientsSummaryResponse.
        Contains a URI for an endpoint that allows you to easily retrieve bulk recipient information.

        :param bulk_recipients_uri: The bulk_recipients_uri of this BulkRecipientsSummaryResponse.
        :type: str
        """

        self._bulk_recipients_uri = bulk_recipients_uri

    @property
    def error_details(self):
        """
        Gets the error_details of this BulkRecipientsSummaryResponse.
        Array or errors.

        :return: The error_details of this BulkRecipientsSummaryResponse.
        :rtype: list[ErrorDetails]
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this BulkRecipientsSummaryResponse.
        Array or errors.

        :param error_details: The error_details of this BulkRecipientsSummaryResponse.
        :type: list[ErrorDetails]
        """

        self._error_details = error_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
