# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class AddressInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, city=None, country=None, fax=None, phone=None, state=None, street1=None, street2=None, zip=None):
        """
        AddressInformation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'city': 'str',
            'country': 'str',
            'fax': 'str',
            'phone': 'str',
            'state': 'str',
            'street1': 'str',
            'street2': 'str',
            'zip': 'str'
        }

        self.attribute_map = {
            'city': 'city',
            'country': 'country',
            'fax': 'fax',
            'phone': 'phone',
            'state': 'state',
            'street1': 'street1',
            'street2': 'street2',
            'zip': 'zip'
        }

        self._city = city
        self._country = country
        self._fax = fax
        self._phone = phone
        self._state = state
        self._street1 = street1
        self._street2 = street2
        self._zip = zip

    @property
    def city(self):
        """
        Gets the city of this AddressInformation.
        The city associated with the address.

        :return: The city of this AddressInformation.
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """
        Sets the city of this AddressInformation.
        The city associated with the address.

        :param city: The city of this AddressInformation.
        :type: str
        """

        self._city = city

    @property
    def country(self):
        """
        Gets the country of this AddressInformation.
        Specifies the country associated with the address.

        :return: The country of this AddressInformation.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """
        Sets the country of this AddressInformation.
        Specifies the country associated with the address.

        :param country: The country of this AddressInformation.
        :type: str
        """

        self._country = country

    @property
    def fax(self):
        """
        Gets the fax of this AddressInformation.
        A Fax number associated with the address if one is available.

        :return: The fax of this AddressInformation.
        :rtype: str
        """
        return self._fax

    @fax.setter
    def fax(self, fax):
        """
        Sets the fax of this AddressInformation.
        A Fax number associated with the address if one is available.

        :param fax: The fax of this AddressInformation.
        :type: str
        """

        self._fax = fax

    @property
    def phone(self):
        """
        Gets the phone of this AddressInformation.
        A phone number associated with the address.

        :return: The phone of this AddressInformation.
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """
        Sets the phone of this AddressInformation.
        A phone number associated with the address.

        :param phone: The phone of this AddressInformation.
        :type: str
        """

        self._phone = phone

    @property
    def state(self):
        """
        Gets the state of this AddressInformation.
        The state or province associated with the address.

        :return: The state of this AddressInformation.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this AddressInformation.
        The state or province associated with the address.

        :param state: The state of this AddressInformation.
        :type: str
        """

        self._state = state

    @property
    def street1(self):
        """
        Gets the street1 of this AddressInformation.
        The first line of the address.

        :return: The street1 of this AddressInformation.
        :rtype: str
        """
        return self._street1

    @street1.setter
    def street1(self, street1):
        """
        Sets the street1 of this AddressInformation.
        The first line of the address.

        :param street1: The street1 of this AddressInformation.
        :type: str
        """

        self._street1 = street1

    @property
    def street2(self):
        """
        Gets the street2 of this AddressInformation.
        The second line of the address (optional).

        :return: The street2 of this AddressInformation.
        :rtype: str
        """
        return self._street2

    @street2.setter
    def street2(self, street2):
        """
        Sets the street2 of this AddressInformation.
        The second line of the address (optional).

        :param street2: The street2 of this AddressInformation.
        :type: str
        """

        self._street2 = street2

    @property
    def zip(self):
        """
        Gets the zip of this AddressInformation.
        The zip or postal code associated with the address.

        :return: The zip of this AddressInformation.
        :rtype: str
        """
        return self._zip

    @zip.setter
    def zip(self, zip):
        """
        Sets the zip of this AddressInformation.
        The zip or postal code associated with the address.

        :param zip: The zip of this AddressInformation.
        :type: str
        """

        self._zip = zip

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
