# coding: utf-8

# (C) Copyright IBM Corp. 2022.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# IBM OpenAPI SDK Code Generator Version: 3.46.1-a5569134-20220316-164819
 
"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)

API Version: 1.0
"""

from datetime import datetime
from enum import Enum
from typing import BinaryIO, Dict, List
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import convert_model, datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################

class EventNotificationsV1(BaseService):
    """The Event Notifications V1 service."""

    DEFAULT_SERVICE_URL = 'https://us-south.event-notifications.cloud.ibm.com/event-notifications'
    DEFAULT_SERVICE_NAME = 'event_notifications'

    @classmethod
    def new_instance(cls,
                     service_name: str = DEFAULT_SERVICE_NAME,
                    ) -> 'EventNotificationsV1':
        """
        Return a new client for the Event Notifications service using the specified
               parameters and external configuration.
        """
        authenticator = get_authenticator_from_environment(service_name)
        service = cls(
            authenticator
            )
        service.configure_service(service_name)
        return service

    def __init__(self,
                 authenticator: Authenticator = None,
                ) -> None:
        """
        Construct a new client for the Event Notifications service.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/main/README.md
               about initializing the authenticator of your choice.
        """
        BaseService.__init__(self,
                             service_url=self.DEFAULT_SERVICE_URL,
                             authenticator=authenticator)


    #########################
    # Send Notifications
    #########################


    def send_notifications(self,
        instance_id: str,
        *,
        body: 'NotificationCreate' = None,
        ce_ibmenseverity: str = None,
        ce_ibmendefaultshort: str = None,
        ce_ibmendefaultlong: str = None,
        ce_ibmenfcmbody: str = None,
        ce_ibmenapnsbody: str = None,
        ce_ibmenpushto: str = None,
        ce_ibmenapnsheaders: str = None,
        ce_ibmenchromebody: str = None,
        ce_ibmenfirefoxbody: str = None,
        ce_ibmenchromeheaders: str = None,
        ce_ibmenfirefoxheaders: str = None,
        ce_ibmensourceid: str = None,
        ce_id: str = None,
        ce_source: str = None,
        ce_type: str = None,
        ce_specversion: str = None,
        ce_time: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Send a notification.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param NotificationCreate body: (optional)
        :param str ce_ibmenseverity: (optional) The Notification severity.
        :param str ce_ibmendefaultshort: (optional) The Notification default short
               text.
        :param str ce_ibmendefaultlong: (optional) The Notification default long
               text.
        :param str ce_ibmenfcmbody: (optional) The FCM Notification body.
        :param str ce_ibmenapnsbody: (optional) The APNS Notification body.
        :param str ce_ibmenpushto: (optional) Push Notifications Targets.
        :param str ce_ibmenapnsheaders: (optional) Push Notifications APNS Headers.
        :param str ce_ibmenchromebody: (optional) Push Notifications Chrome body.
        :param str ce_ibmenfirefoxbody: (optional) Push Notifications Firefox body.
        :param str ce_ibmenchromeheaders: (optional) Push Notifications Chrome
               Headers.
        :param str ce_ibmenfirefoxheaders: (optional) Push Notifications Firefox
               Headers.
        :param str ce_ibmensourceid: (optional) Event Notifications Target source
               ID.
        :param str ce_id: (optional) custom ID to track notifications from client
               side (Mandatory identifier for the binary mode).
        :param str ce_source: (optional) custom source odentifier from the client
               side.
        :param str ce_type: (optional) Type identifier for source filters.
        :param str ce_specversion: (optional) Version of the Cloud Event
               specification (Mandatory header to make the request Binary Mode).
        :param str ce_time: (optional) The time of the notification.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `NotificationResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if  body is not None and isinstance(body, NotificationCreate):
            body = convert_model(body)
        headers = {
            'ce-ibmenseverity': ce_ibmenseverity,
            'ce-ibmendefaultshort': ce_ibmendefaultshort,
            'ce-ibmendefaultlong': ce_ibmendefaultlong,
            'ce-ibmenfcmbody': ce_ibmenfcmbody,
            'ce-ibmenapnsbody': ce_ibmenapnsbody,
            'ce-ibmenpushto': ce_ibmenpushto,
            'ce-ibmenapnsheaders': ce_ibmenapnsheaders,
            'ce-ibmenchromebody': ce_ibmenchromebody,
            'ce-ibmenfirefoxbody': ce_ibmenfirefoxbody,
            'ce-ibmenchromeheaders': ce_ibmenchromeheaders,
            'ce-ibmenfirefoxheaders': ce_ibmenfirefoxheaders,
            'ce-ibmensourceid': ce_ibmensourceid,
            'ce-id': ce_id,
            'ce-source': ce_source,
            'ce-type': ce_type,
            'ce-specversion': ce_specversion,
            'ce-time': ce_time
        }
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='send_notifications')
        headers.update(sdk_headers)

        data = json.dumps(body)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/notifications'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Sources
    #########################


    def create_sources(self,
        instance_id: str,
        name: str,
        description: str,
        *,
        enabled: bool = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new API Source.

        Create a new API Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param bool enabled: (optional) Whether the source is enabled or not.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SourceResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if description is None:
            raise ValueError('description must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_sources')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'enabled': enabled
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_sources(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Sources.

        List all Sources.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SourceList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_sources')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_source(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get a Source.

        Get a Sources.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Source` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_source')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def delete_source(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Source.

        Delete a Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_source')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_source(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        enabled: bool = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Source.

        Update details of a Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param str name: (optional) Name of the source.
        :param str description: (optional) Description of the source.
        :param bool enabled: (optional) Whether the source is enabled or not.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Source` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_source')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'enabled': enabled
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Topics
    #########################


    def create_topic(self,
        instance_id: str,
        name: str,
        *,
        description: str = None,
        sources: List['TopicUpdateSourcesItem'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Topic.

        Create a new Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Name of the topic.
        :param str description: (optional) Description of the topic.
        :param List[TopicUpdateSourcesItem] sources: (optional) List of sources.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TopicResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if sources is not None:
            sources = [convert_model(x) for x in sources]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_topic')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'sources': sources
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_topics(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Topics.

        List all Topics.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TopicList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_topics')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_topic(self,
        instance_id: str,
        id: str,
        *,
        include: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Topic.

        Get details of a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param str include: (optional) Include sub topics.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Topic` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_topic')
        headers.update(sdk_headers)

        params = {
            'include': include
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def replace_topic(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        sources: List['TopicUpdateSourcesItem'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Topic.

        Update details of a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param str name: (optional) Name of the topic.
        :param str description: (optional) Description of the topic.
        :param List[TopicUpdateSourcesItem] sources: (optional) List of sources.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Topic` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if sources is not None:
            sources = [convert_model(x) for x in sources]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='replace_topic')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'sources': sources
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def delete_topic(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Topic.

        Delete a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_topic')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Destinations
    #########################


    def create_destination(self,
        instance_id: str,
        name: str,
        type: str,
        *,
        description: str = None,
        config: 'DestinationConfig' = None,
        certificate: BinaryIO = None,
        certificate_content_type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Destination.

        Create a new Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: The Destintion name.
        :param str type: The type of Destination Webhook.
        :param str description: (optional) The Destination description.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        :param BinaryIO certificate: (optional) Certificate for APNS.
        :param str certificate_content_type: (optional) The content type of
               certificate.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if type is None:
            raise ValueError('type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_destination')
        headers.update(sdk_headers)

        form_data = []
        form_data.append(('name', (None, name, 'text/plain')))
        form_data.append(('type', (None, type, 'text/plain')))
        if description:
            form_data.append(('description', (None, description, 'text/plain')))
        if config:
            form_data.append(('config', (None, json.dumps(config), 'application/json')))
        if certificate:
            form_data.append(('certificate', (None, certificate, certificate_content_type or 'application/octet-stream')))

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       files=form_data)

        response = self.send(request, **kwargs)
        return response


    def list_destinations(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Destinations.

        List all Destinations.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_destinations')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_destination(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Destination.

        Get details of a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Destination` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_destination')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_destination(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        config: 'DestinationConfig' = None,
        certificate: BinaryIO = None,
        certificate_content_type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Destination.

        Update details of a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str name: (optional) Destination name.
        :param str description: (optional) Destination description.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        :param BinaryIO certificate: (optional) Certificate for APNS.
        :param str certificate_content_type: (optional) The content type of
               certificate.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Destination` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_destination')
        headers.update(sdk_headers)

        form_data = []
        if name:
            form_data.append(('name', (None, name, 'text/plain')))
        if description:
            form_data.append(('description', (None, description, 'text/plain')))
        if config:
            form_data.append(('config', (None, json.dumps(config), 'application/json')))
        if certificate:
            form_data.append(('certificate', (None, certificate, certificate_content_type or 'application/octet-stream')))

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       files=form_data)

        response = self.send(request, **kwargs)
        return response


    def delete_destination(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Destination.

        Delete a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_destination')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Destinations Push Devices
    #########################


    def list_destination_devices(self,
        instance_id: str,
        id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Get list of Destination devices.

        Get list of Destination devices.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationDevicesList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_destination_devices')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/devices'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_destination_devices_report(self,
        instance_id: str,
        id: str,
        *,
        days: int = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Retrieves report of destination devices registered.

        Retrieves report of destination devices registered.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param int days: (optional) Number of days report has to be generated from
               * `Note :` Max value is 90
               * Min or default value is 1.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationDevicesReport` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_destination_devices_report')
        headers.update(sdk_headers)

        params = {
            'days': days
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/devices/report'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Destination tags subscriptions
    #########################


    def list_tags_subscriptions_device(self,
        instance_id: str,
        id: str,
        device_id: str,
        *,
        tag_name: str = None,
        limit: int = None,
        offset: int = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Tag Subscriptions for a device.

        List all Tag Subscriptions for a device.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: DeviceID of the destination.
        :param str tag_name: (optional) TagName of the subscription.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TagsSubscriptionList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if device_id is None:
            raise ValueError('device_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_tags_subscriptions_device')
        headers.update(sdk_headers)

        params = {
            'tag_name': tag_name,
            'limit': limit,
            'offset': offset
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id', 'device_id']
        path_param_values = self.encode_path_vars(instance_id, id, device_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions/devices/{device_id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def list_tags_subscription(self,
        instance_id: str,
        id: str,
        *,
        device_id: str = None,
        user_id: str = None,
        tag_name: str = None,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Tag Subscriptions.

        List all Tag Subscriptions.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: (optional) DeviceID of the destination
               tagsubscription.
        :param str user_id: (optional) UserID of the destination.
        :param str tag_name: (optional) TagName of the subscription.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TagsSubscriptionList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_tags_subscription')
        headers.update(sdk_headers)

        params = {
            'device_id': device_id,
            'user_id': user_id,
            'tag_name': tag_name,
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def create_tags_subscription(self,
        instance_id: str,
        id: str,
        device_id: str,
        tag_name: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Tag subscription.

        Create a new Tag subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationTagsSubscriptionResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if device_id is None:
            raise ValueError('device_id must be provided')
        if tag_name is None:
            raise ValueError('tag_name must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_tags_subscription')
        headers.update(sdk_headers)

        data = {
            'device_id': device_id,
            'tag_name': tag_name
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def delete_tags_subscription(self,
        instance_id: str,
        id: str,
        *,
        device_id: str = None,
        tag_name: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Tag subcription.

        Delete a Tag subcription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: (optional) DeviceID of the destination
               tagsubscription.
        :param str tag_name: (optional) TagName of the subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_tags_subscription')
        headers.update(sdk_headers)

        params = {
            'device_id': device_id,
            'tag_name': tag_name
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Subscriptions
    #########################


    def create_subscription(self,
        instance_id: str,
        name: str,
        destination_id: str,
        topic_id: str,
        *,
        description: str = None,
        attributes: 'SubscriptionCreateAttributes' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Subscription.

        Create a new Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Subscription name.
        :param str destination_id: Destination ID.
        :param str topic_id: Topic ID.
        :param str description: (optional) Subscription description.
        :param SubscriptionCreateAttributes attributes: (optional)
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if destination_id is None:
            raise ValueError('destination_id must be provided')
        if topic_id is None:
            raise ValueError('topic_id must be provided')
        if attributes is not None:
            attributes = convert_model(attributes)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_subscription')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'destination_id': destination_id,
            'topic_id': topic_id,
            'description': description,
            'attributes': attributes
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_subscriptions(self,
        instance_id: str,
        *,
        offset: int = None,
        limit: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Subscriptions.

        List all Subscriptions.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int offset: (optional) offset for paginated results.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SubscriptionList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_subscriptions')
        headers.update(sdk_headers)

        params = {
            'offset': offset,
            'limit': limit,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_subscription(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Subscription.

        Get details of a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_subscription')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def delete_subscription(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Subscription.

        Delete a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_subscription')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_subscription(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        attributes: 'SubscriptionUpdateAttributes' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Subscription.

        Update details of a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param str name: (optional) Name of the subscription.
        :param str description: (optional) Description of the subscription.
        :param SubscriptionUpdateAttributes attributes: (optional)
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if attributes is not None:
            attributes = convert_model(attributes)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_subscription')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'attributes': attributes
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


class CreateDestinationEnums:
    """
    Enums for create_destination parameters.
    """

    class Type(str, Enum):
        """
        The type of Destination Webhook.
        """
        WEBHOOK = 'webhook'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        PUSH_CHROME = 'push_chrome'
        PUSH_FIREFOX = 'push_firefox'


##############################################################################
# Models
##############################################################################


class Destination():
    """
    Payload describing a destination get request.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type Email/SMS/Webhook/FCM.
    :attr DestinationConfig config: (optional) Payload describing a destination
          configuration.
    :attr datetime updated_at: Last updated time.
    :attr int subscription_count: Number of subscriptions.
    :attr List[str] subscription_names: List of subscriptions.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 updated_at: datetime,
                 subscription_count: int,
                 subscription_names: List[str],
                 *,
                 config: 'DestinationConfig' = None) -> None:
        """
        Initialize a Destination object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type Email/SMS/Webhook/FCM.
        :param datetime updated_at: Last updated time.
        :param int subscription_count: Number of subscriptions.
        :param List[str] subscription_names: List of subscriptions.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.config = config
        self.updated_at = updated_at
        self.subscription_count = subscription_count
        self.subscription_names = subscription_names

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Destination':
        """Initialize a Destination object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Destination JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Destination JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Destination JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in Destination JSON')
        if 'config' in _dict:
            args['config'] = DestinationConfig.from_dict(_dict.get('config'))
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in Destination JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in Destination JSON')
        if 'subscription_names' in _dict:
            args['subscription_names'] = _dict.get('subscription_names')
        else:
            raise ValueError('Required property \'subscription_names\' not present in Destination JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Destination object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'config') and self.config is not None:
            _dict['config'] = self.config.to_dict()
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscription_names') and self.subscription_names is not None:
            _dict['subscription_names'] = self.subscription_names
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Destination object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Destination') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Destination') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type Email/SMS/Webhook/FCM.
        """
        WEBHOOK = 'webhook'
        SMTP_IBM = 'smtp_ibm'
        SMS_IBM = 'sms_ibm'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'


class DestinationConfig():
    """
    Payload describing a destination configuration.

    :attr DestinationConfigParams params:
    """

    def __init__(self,
                 params: 'DestinationConfigParams') -> None:
        """
        Initialize a DestinationConfig object.

        :param DestinationConfigParams params:
        """
        self.params = params

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfig':
        """Initialize a DestinationConfig object from a json dictionary."""
        args = {}
        if 'params' in _dict:
            args['params'] = _dict.get('params')
        else:
            raise ValueError('Required property \'params\' not present in DestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'params') and self.params is not None:
            if isinstance(self.params, dict):
                _dict['params'] = self.params
            else:
                _dict['params'] = self.params.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParams():
    """
    DestinationConfigParams.

    """

    def __init__(self) -> None:
        """
        Initialize a DestinationConfigParams object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['DestinationConfigParamsWebhookDestinationConfig', 'DestinationConfigParamsFCMDestinationConfig', 'DestinationConfigParamsIOSDestinationConfig', 'DestinationConfigParamsChromeDestinationConfig', 'DestinationConfigParamsFirefoxDestinationConfig']))
        raise Exception(msg)

class DestinationDevicesList():
    """
    Payload describing a destination devices list request.

    :attr int total_count: Total number of destination devices.
    :attr int offset: Current offset.
    :attr int limit: limit to show destination devices.
    :attr List[DestinationDevicesListItem] devices: List of devices.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 devices: List['DestinationDevicesListItem']) -> None:
        """
        Initialize a DestinationDevicesList object.

        :param int total_count: Total number of destination devices.
        :param int offset: Current offset.
        :param int limit: limit to show destination devices.
        :param List[DestinationDevicesListItem] devices: List of devices.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.devices = devices

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationDevicesList':
        """Initialize a DestinationDevicesList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in DestinationDevicesList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in DestinationDevicesList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in DestinationDevicesList JSON')
        if 'devices' in _dict:
            args['devices'] = [DestinationDevicesListItem.from_dict(x) for x in _dict.get('devices')]
        else:
            raise ValueError('Required property \'devices\' not present in DestinationDevicesList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationDevicesList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'devices') and self.devices is not None:
            _dict['devices'] = [x.to_dict() for x in self.devices]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationDevicesList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationDevicesList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationDevicesList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationDevicesListItem():
    """
    device object.

    :attr str id: device ID.
    :attr str user_id: (optional) user ID.
    :attr str platform: Destination platform.
    :attr str token: Destination device token.
    :attr datetime updated_at: Updated at.
    """

    def __init__(self,
                 id: str,
                 platform: str,
                 token: str,
                 updated_at: datetime,
                 *,
                 user_id: str = None) -> None:
        """
        Initialize a DestinationDevicesListItem object.

        :param str id: device ID.
        :param str platform: Destination platform.
        :param str token: Destination device token.
        :param datetime updated_at: Updated at.
        :param str user_id: (optional) user ID.
        """
        self.id = id
        self.user_id = user_id
        self.platform = platform
        self.token = token
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationDevicesListItem':
        """Initialize a DestinationDevicesListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationDevicesListItem JSON')
        if 'user_id' in _dict:
            args['user_id'] = _dict.get('user_id')
        if 'platform' in _dict:
            args['platform'] = _dict.get('platform')
        else:
            raise ValueError('Required property \'platform\' not present in DestinationDevicesListItem JSON')
        if 'token' in _dict:
            args['token'] = _dict.get('token')
        else:
            raise ValueError('Required property \'token\' not present in DestinationDevicesListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in DestinationDevicesListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationDevicesListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        if hasattr(self, 'platform') and self.platform is not None:
            _dict['platform'] = self.platform
        if hasattr(self, 'token') and self.token is not None:
            _dict['token'] = self.token
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationDevicesListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationDevicesListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationDevicesListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationDevicesReport():
    """
    Payload describing a destination devices report.

    :attr int android: Android Devices Registered.
    :attr int ios: ios Devices Registered.
    :attr int chrome: chrome web Devices Registered.
    :attr int firefox: firefox web Devices Registered.
    :attr int safari: safari web Devices Registered.
    :attr int chrome_app_ext: chromeAppExt Devices Registered.
    :attr int all: Total Devices Registered.
    """

    def __init__(self,
                 android: int,
                 ios: int,
                 chrome: int,
                 firefox: int,
                 safari: int,
                 chrome_app_ext: int,
                 all: int) -> None:
        """
        Initialize a DestinationDevicesReport object.

        :param int android: Android Devices Registered.
        :param int ios: ios Devices Registered.
        :param int chrome: chrome web Devices Registered.
        :param int firefox: firefox web Devices Registered.
        :param int safari: safari web Devices Registered.
        :param int chrome_app_ext: chromeAppExt Devices Registered.
        :param int all: Total Devices Registered.
        """
        self.android = android
        self.ios = ios
        self.chrome = chrome
        self.firefox = firefox
        self.safari = safari
        self.chrome_app_ext = chrome_app_ext
        self.all = all

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationDevicesReport':
        """Initialize a DestinationDevicesReport object from a json dictionary."""
        args = {}
        if 'android' in _dict:
            args['android'] = _dict.get('android')
        else:
            raise ValueError('Required property \'android\' not present in DestinationDevicesReport JSON')
        if 'ios' in _dict:
            args['ios'] = _dict.get('ios')
        else:
            raise ValueError('Required property \'ios\' not present in DestinationDevicesReport JSON')
        if 'chrome' in _dict:
            args['chrome'] = _dict.get('chrome')
        else:
            raise ValueError('Required property \'chrome\' not present in DestinationDevicesReport JSON')
        if 'firefox' in _dict:
            args['firefox'] = _dict.get('firefox')
        else:
            raise ValueError('Required property \'firefox\' not present in DestinationDevicesReport JSON')
        if 'safari' in _dict:
            args['safari'] = _dict.get('safari')
        else:
            raise ValueError('Required property \'safari\' not present in DestinationDevicesReport JSON')
        if 'chromeAppExt' in _dict:
            args['chrome_app_ext'] = _dict.get('chromeAppExt')
        else:
            raise ValueError('Required property \'chromeAppExt\' not present in DestinationDevicesReport JSON')
        if 'all' in _dict:
            args['all'] = _dict.get('all')
        else:
            raise ValueError('Required property \'all\' not present in DestinationDevicesReport JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationDevicesReport object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'android') and self.android is not None:
            _dict['android'] = self.android
        if hasattr(self, 'ios') and self.ios is not None:
            _dict['ios'] = self.ios
        if hasattr(self, 'chrome') and self.chrome is not None:
            _dict['chrome'] = self.chrome
        if hasattr(self, 'firefox') and self.firefox is not None:
            _dict['firefox'] = self.firefox
        if hasattr(self, 'safari') and self.safari is not None:
            _dict['safari'] = self.safari
        if hasattr(self, 'chrome_app_ext') and self.chrome_app_ext is not None:
            _dict['chromeAppExt'] = self.chrome_app_ext
        if hasattr(self, 'all') and self.all is not None:
            _dict['all'] = self.all
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationDevicesReport object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationDevicesReport') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationDevicesReport') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationList():
    """
    Payload describing a destination list request.

    :attr int total_count: Total number of destinations.
    :attr int offset: Current offset.
    :attr int limit: limit to show destinations.
    :attr List[DestinationListItem] destinations: List of destinations.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 destinations: List['DestinationListItem']) -> None:
        """
        Initialize a DestinationList object.

        :param int total_count: Total number of destinations.
        :param int offset: Current offset.
        :param int limit: limit to show destinations.
        :param List[DestinationListItem] destinations: List of destinations.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.destinations = destinations

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationList':
        """Initialize a DestinationList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in DestinationList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in DestinationList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in DestinationList JSON')
        if 'destinations' in _dict:
            args['destinations'] = [DestinationListItem.from_dict(x) for x in _dict.get('destinations')]
        else:
            raise ValueError('Required property \'destinations\' not present in DestinationList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'destinations') and self.destinations is not None:
            _dict['destinations'] = [x.to_dict() for x in self.destinations]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationListItem():
    """
    Destination object.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type Email/SMS/Webhook.
    :attr int subscription_count: Subscription count.
    :attr List[str] subscription_names: Names of subscriptions.
    :attr datetime updated_at: Updated at.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 subscription_count: int,
                 subscription_names: List[str],
                 updated_at: datetime) -> None:
        """
        Initialize a DestinationListItem object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type Email/SMS/Webhook.
        :param int subscription_count: Subscription count.
        :param List[str] subscription_names: Names of subscriptions.
        :param datetime updated_at: Updated at.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.subscription_count = subscription_count
        self.subscription_names = subscription_names
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationListItem':
        """Initialize a DestinationListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in DestinationListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in DestinationListItem JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in DestinationListItem JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in DestinationListItem JSON')
        if 'subscription_names' in _dict:
            args['subscription_names'] = _dict.get('subscription_names')
        else:
            raise ValueError('Required property \'subscription_names\' not present in DestinationListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in DestinationListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscription_names') and self.subscription_names is not None:
            _dict['subscription_names'] = self.subscription_names
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type Email/SMS/Webhook.
        """
        WEBHOOK = 'webhook'
        SMTP_IBM = 'smtp_ibm'
        SMS_IBM = 'sms_ibm'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'


class DestinationResponse():
    """
    Payload describing a destination get request.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type Email/SMS/Webhook.
    :attr DestinationConfig config: Payload describing a destination configuration.
    :attr datetime created_at: Last updated time.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 config: 'DestinationConfig',
                 created_at: datetime) -> None:
        """
        Initialize a DestinationResponse object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type Email/SMS/Webhook.
        :param DestinationConfig config: Payload describing a destination
               configuration.
        :param datetime created_at: Last updated time.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.config = config
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationResponse':
        """Initialize a DestinationResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in DestinationResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in DestinationResponse JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in DestinationResponse JSON')
        if 'config' in _dict:
            args['config'] = DestinationConfig.from_dict(_dict.get('config'))
        else:
            raise ValueError('Required property \'config\' not present in DestinationResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in DestinationResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'config') and self.config is not None:
            _dict['config'] = self.config.to_dict()
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type Email/SMS/Webhook.
        """
        WEBHOOK = 'webhook'


class DestinationTagsSubscriptionResponse():
    """
    Payload describing a destination get request.

    :attr str id: Subscription Tag ID.
    :attr str device_id: Unique identifier of the device.
    :attr str tag_name: The name of the tag its subscribed.
    :attr str user_id: (optional) The user identifier for the the device
          registration.
    :attr datetime created_at: Last updated time.
    """

    def __init__(self,
                 id: str,
                 device_id: str,
                 tag_name: str,
                 created_at: datetime,
                 *,
                 user_id: str = None) -> None:
        """
        Initialize a DestinationTagsSubscriptionResponse object.

        :param str id: Subscription Tag ID.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param datetime created_at: Last updated time.
        :param str user_id: (optional) The user identifier for the the device
               registration.
        """
        self.id = id
        self.device_id = device_id
        self.tag_name = tag_name
        self.user_id = user_id
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationTagsSubscriptionResponse':
        """Initialize a DestinationTagsSubscriptionResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'device_id' in _dict:
            args['device_id'] = _dict.get('device_id')
        else:
            raise ValueError('Required property \'device_id\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'tag_name' in _dict:
            args['tag_name'] = _dict.get('tag_name')
        else:
            raise ValueError('Required property \'tag_name\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'user_id' in _dict:
            args['user_id'] = _dict.get('user_id')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in DestinationTagsSubscriptionResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationTagsSubscriptionResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'device_id') and self.device_id is not None:
            _dict['device_id'] = self.device_id
        if hasattr(self, 'tag_name') and self.tag_name is not None:
            _dict['tag_name'] = self.tag_name
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationTagsSubscriptionResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationTagsSubscriptionResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationTagsSubscriptionResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class EmailUpdateAttributesTo():
    """
    The email ids.

    :attr List[str] add: (optional) The email ids.
    :attr List[str] remove: (optional) The email ids for removal.
    """

    def __init__(self,
                 *,
                 add: List[str] = None,
                 remove: List[str] = None) -> None:
        """
        Initialize a EmailUpdateAttributesTo object.

        :param List[str] add: (optional) The email ids.
        :param List[str] remove: (optional) The email ids for removal.
        """
        self.add = add
        self.remove = remove

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EmailUpdateAttributesTo':
        """Initialize a EmailUpdateAttributesTo object from a json dictionary."""
        args = {}
        if 'add' in _dict:
            args['add'] = _dict.get('add')
        if 'remove' in _dict:
            args['remove'] = _dict.get('remove')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EmailUpdateAttributesTo object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'add') and self.add is not None:
            _dict['add'] = self.add
        if hasattr(self, 'remove') and self.remove is not None:
            _dict['remove'] = self.remove
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EmailUpdateAttributesTo object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EmailUpdateAttributesTo') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EmailUpdateAttributesTo') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class EmailUpdateAttributesUnsubscribed():
    """
    The email ids.

    :attr List[str] remove: (optional) The email ids unsubscribed.
    """

    def __init__(self,
                 *,
                 remove: List[str] = None) -> None:
        """
        Initialize a EmailUpdateAttributesUnsubscribed object.

        :param List[str] remove: (optional) The email ids unsubscribed.
        """
        self.remove = remove

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EmailUpdateAttributesUnsubscribed':
        """Initialize a EmailUpdateAttributesUnsubscribed object from a json dictionary."""
        args = {}
        if 'remove' in _dict:
            args['remove'] = _dict.get('remove')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EmailUpdateAttributesUnsubscribed object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'remove') and self.remove is not None:
            _dict['remove'] = self.remove
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EmailUpdateAttributesUnsubscribed object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EmailUpdateAttributesUnsubscribed') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EmailUpdateAttributesUnsubscribed') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class NotificationCreate():
    """
    Payload describing a notification create request.

    :attr dict data: (optional) The Notifications data for webhook.
    :attr str ibmenseverity: (optional) The Notifications id.
    :attr str ibmenfcmbody: (optional) The Notifications FCM body.
    :attr str ibmenapnsbody: (optional) The Notifications APNS body.
    :attr str ibmenpushto: (optional) Payload describing a FCM Notifications
          targets.
    :attr str ibmenapnsheaders: (optional) Headers for an APNs notification.
    :attr str ibmendefaultshort: (optional) Default short text for the message.
    :attr str ibmendefaultlong: (optional) Default long text for the message.
    :attr str ibmenchromebody: (optional) The Notifications Chrome body.
    :attr str ibmenfirefoxbody: (optional) The Notifications Firefox body.
    :attr str ibmenchromeheaders: (optional) Headers for a Chrome notification.
    :attr str ibmenfirefoxheaders: (optional) Headers for an FireFox notification.
    :attr str ibmensourceid: (optional) The Event Notifications source id.
    :attr str datacontenttype: (optional) The Notifications content type.
    :attr str subject: (optional) The Notifications subject.
    :attr str id: (optional) The Notifications id.
    :attr str source: (optional) The source of Notifications.
    :attr str type: (optional) The Notifications type.
    :attr str specversion: (optional) The Notifications specversion.
    :attr str time: (optional) The Notifications time.
    """

    # The set of defined properties for the class
    _properties = frozenset(['data', 'ibmenseverity', 'ibmenfcmbody', 'ibmenapnsbody', 'ibmenpushto', 'ibmenapnsheaders', 'ibmendefaultshort', 'ibmendefaultlong', 'ibmenchromebody', 'ibmenfirefoxbody', 'ibmenchromeheaders', 'ibmenfirefoxheaders', 'ibmensourceid', 'datacontenttype', 'subject', 'id', 'source', 'type', 'specversion', 'time'])

    def __init__(self,
                 *,
                 data: dict = None,
                 ibmenseverity: str = None,
                 ibmenfcmbody: str = None,
                 ibmenapnsbody: str = None,
                 ibmenpushto: str = None,
                 ibmenapnsheaders: str = None,
                 ibmendefaultshort: str = None,
                 ibmendefaultlong: str = None,
                 ibmenchromebody: str = None,
                 ibmenfirefoxbody: str = None,
                 ibmenchromeheaders: str = None,
                 ibmenfirefoxheaders: str = None,
                 ibmensourceid: str = None,
                 datacontenttype: str = None,
                 subject: str = None,
                 id: str = None,
                 source: str = None,
                 type: str = None,
                 specversion: str = None,
                 time: str = None,
                 **kwargs) -> None:
        """
        Initialize a NotificationCreate object.

        :param dict data: (optional) The Notifications data for webhook.
        :param str ibmenseverity: (optional) The Notifications id.
        :param str ibmenfcmbody: (optional) The Notifications FCM body.
        :param str ibmenapnsbody: (optional) The Notifications APNS body.
        :param str ibmenpushto: (optional) Payload describing a FCM Notifications
               targets.
        :param str ibmenapnsheaders: (optional) Headers for an APNs notification.
        :param str ibmendefaultshort: (optional) Default short text for the
               message.
        :param str ibmendefaultlong: (optional) Default long text for the message.
        :param str ibmenchromebody: (optional) The Notifications Chrome body.
        :param str ibmenfirefoxbody: (optional) The Notifications Firefox body.
        :param str ibmenchromeheaders: (optional) Headers for a Chrome
               notification.
        :param str ibmenfirefoxheaders: (optional) Headers for an FireFox
               notification.
        :param str ibmensourceid: (optional) The Event Notifications source id.
        :param str datacontenttype: (optional) The Notifications content type.
        :param str subject: (optional) The Notifications subject.
        :param str id: (optional) The Notifications id.
        :param str source: (optional) The source of Notifications.
        :param str type: (optional) The Notifications type.
        :param str specversion: (optional) The Notifications specversion.
        :param str time: (optional) The Notifications time.
        :param **kwargs: (optional) Any additional properties.
        """
        self.data = data
        self.ibmenseverity = ibmenseverity
        self.ibmenfcmbody = ibmenfcmbody
        self.ibmenapnsbody = ibmenapnsbody
        self.ibmenpushto = ibmenpushto
        self.ibmenapnsheaders = ibmenapnsheaders
        self.ibmendefaultshort = ibmendefaultshort
        self.ibmendefaultlong = ibmendefaultlong
        self.ibmenchromebody = ibmenchromebody
        self.ibmenfirefoxbody = ibmenfirefoxbody
        self.ibmenchromeheaders = ibmenchromeheaders
        self.ibmenfirefoxheaders = ibmenfirefoxheaders
        self.ibmensourceid = ibmensourceid
        self.datacontenttype = datacontenttype
        self.subject = subject
        self.id = id
        self.source = source
        self.type = type
        self.specversion = specversion
        self.time = time
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'NotificationCreate':
        """Initialize a NotificationCreate object from a json dictionary."""
        args = {}
        if 'data' in _dict:
            args['data'] = _dict.get('data')
        if 'ibmenseverity' in _dict:
            args['ibmenseverity'] = _dict.get('ibmenseverity')
        if 'ibmenfcmbody' in _dict:
            args['ibmenfcmbody'] = _dict.get('ibmenfcmbody')
        if 'ibmenapnsbody' in _dict:
            args['ibmenapnsbody'] = _dict.get('ibmenapnsbody')
        if 'ibmenpushto' in _dict:
            args['ibmenpushto'] = _dict.get('ibmenpushto')
        if 'ibmenapnsheaders' in _dict:
            args['ibmenapnsheaders'] = _dict.get('ibmenapnsheaders')
        if 'ibmendefaultshort' in _dict:
            args['ibmendefaultshort'] = _dict.get('ibmendefaultshort')
        if 'ibmendefaultlong' in _dict:
            args['ibmendefaultlong'] = _dict.get('ibmendefaultlong')
        if 'ibmenchromebody' in _dict:
            args['ibmenchromebody'] = _dict.get('ibmenchromebody')
        if 'ibmenfirefoxbody' in _dict:
            args['ibmenfirefoxbody'] = _dict.get('ibmenfirefoxbody')
        if 'ibmenchromeheaders' in _dict:
            args['ibmenchromeheaders'] = _dict.get('ibmenchromeheaders')
        if 'ibmenfirefoxheaders' in _dict:
            args['ibmenfirefoxheaders'] = _dict.get('ibmenfirefoxheaders')
        if 'ibmensourceid' in _dict:
            args['ibmensourceid'] = _dict.get('ibmensourceid')
        if 'datacontenttype' in _dict:
            args['datacontenttype'] = _dict.get('datacontenttype')
        if 'subject' in _dict:
            args['subject'] = _dict.get('subject')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        if 'source' in _dict:
            args['source'] = _dict.get('source')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        if 'specversion' in _dict:
            args['specversion'] = _dict.get('specversion')
        if 'time' in _dict:
            args['time'] = _dict.get('time')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a NotificationCreate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'data') and self.data is not None:
            _dict['data'] = self.data
        if hasattr(self, 'ibmenseverity') and self.ibmenseverity is not None:
            _dict['ibmenseverity'] = self.ibmenseverity
        if hasattr(self, 'ibmenfcmbody') and self.ibmenfcmbody is not None:
            _dict['ibmenfcmbody'] = self.ibmenfcmbody
        if hasattr(self, 'ibmenapnsbody') and self.ibmenapnsbody is not None:
            _dict['ibmenapnsbody'] = self.ibmenapnsbody
        if hasattr(self, 'ibmenpushto') and self.ibmenpushto is not None:
            _dict['ibmenpushto'] = self.ibmenpushto
        if hasattr(self, 'ibmenapnsheaders') and self.ibmenapnsheaders is not None:
            _dict['ibmenapnsheaders'] = self.ibmenapnsheaders
        if hasattr(self, 'ibmendefaultshort') and self.ibmendefaultshort is not None:
            _dict['ibmendefaultshort'] = self.ibmendefaultshort
        if hasattr(self, 'ibmendefaultlong') and self.ibmendefaultlong is not None:
            _dict['ibmendefaultlong'] = self.ibmendefaultlong
        if hasattr(self, 'ibmenchromebody') and self.ibmenchromebody is not None:
            _dict['ibmenchromebody'] = self.ibmenchromebody
        if hasattr(self, 'ibmenfirefoxbody') and self.ibmenfirefoxbody is not None:
            _dict['ibmenfirefoxbody'] = self.ibmenfirefoxbody
        if hasattr(self, 'ibmenchromeheaders') and self.ibmenchromeheaders is not None:
            _dict['ibmenchromeheaders'] = self.ibmenchromeheaders
        if hasattr(self, 'ibmenfirefoxheaders') and self.ibmenfirefoxheaders is not None:
            _dict['ibmenfirefoxheaders'] = self.ibmenfirefoxheaders
        if hasattr(self, 'ibmensourceid') and self.ibmensourceid is not None:
            _dict['ibmensourceid'] = self.ibmensourceid
        if hasattr(self, 'datacontenttype') and self.datacontenttype is not None:
            _dict['datacontenttype'] = self.datacontenttype
        if hasattr(self, 'subject') and self.subject is not None:
            _dict['subject'] = self.subject
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'source') and self.source is not None:
            _dict['source'] = self.source
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'specversion') and self.specversion is not None:
            _dict['specversion'] = self.specversion
        if hasattr(self, 'time') and self.time is not None:
            _dict['time'] = self.time
        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of NotificationCreate"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of NotificationCreate"""
        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in NotificationCreate._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this NotificationCreate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'NotificationCreate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'NotificationCreate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class NotificationResponse():
    """
    Payload describing a notifications response.

    :attr str notification_id: (optional) Notification ID.
    """

    def __init__(self,
                 *,
                 notification_id: str = None) -> None:
        """
        Initialize a NotificationResponse object.

        :param str notification_id: (optional) Notification ID.
        """
        self.notification_id = notification_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'NotificationResponse':
        """Initialize a NotificationResponse object from a json dictionary."""
        args = {}
        if 'notification_id' in _dict:
            args['notification_id'] = _dict.get('notification_id')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a NotificationResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'notification_id') and self.notification_id is not None:
            _dict['notification_id'] = self.notification_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this NotificationResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'NotificationResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'NotificationResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Rules():
    """
    Rule object.

    :attr bool enabled: (optional) Whether the rule is enabled or not.
    :attr str event_type_filter: Event type filter.
    :attr str notification_filter: (optional) Notification filter.
    """

    def __init__(self,
                 event_type_filter: str,
                 *,
                 enabled: bool = None,
                 notification_filter: str = None) -> None:
        """
        Initialize a Rules object.

        :param str event_type_filter: Event type filter.
        :param bool enabled: (optional) Whether the rule is enabled or not.
        :param str notification_filter: (optional) Notification filter.
        """
        self.enabled = enabled
        self.event_type_filter = event_type_filter
        self.notification_filter = notification_filter

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Rules':
        """Initialize a Rules object from a json dictionary."""
        args = {}
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        if 'event_type_filter' in _dict:
            args['event_type_filter'] = _dict.get('event_type_filter')
        else:
            raise ValueError('Required property \'event_type_filter\' not present in Rules JSON')
        if 'notification_filter' in _dict:
            args['notification_filter'] = _dict.get('notification_filter')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Rules object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'event_type_filter') and self.event_type_filter is not None:
            _dict['event_type_filter'] = self.event_type_filter
        if hasattr(self, 'notification_filter') and self.notification_filter is not None:
            _dict['notification_filter'] = self.notification_filter
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Rules object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Rules') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Rules') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RulesGet():
    """
    Rule object.

    :attr bool enabled: Whether the rule is enabled or not.
    :attr str event_type_filter: Event type filter.
    :attr str notification_filter: Notification filter.
    :attr str updated_at: Last time the topic was updated.
    :attr str id: Autogenerated rule ID.
    """

    def __init__(self,
                 enabled: bool,
                 event_type_filter: str,
                 notification_filter: str,
                 updated_at: str,
                 id: str) -> None:
        """
        Initialize a RulesGet object.

        :param bool enabled: Whether the rule is enabled or not.
        :param str event_type_filter: Event type filter.
        :param str notification_filter: Notification filter.
        :param str updated_at: Last time the topic was updated.
        :param str id: Autogenerated rule ID.
        """
        self.enabled = enabled
        self.event_type_filter = event_type_filter
        self.notification_filter = notification_filter
        self.updated_at = updated_at
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RulesGet':
        """Initialize a RulesGet object from a json dictionary."""
        args = {}
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in RulesGet JSON')
        if 'event_type_filter' in _dict:
            args['event_type_filter'] = _dict.get('event_type_filter')
        else:
            raise ValueError('Required property \'event_type_filter\' not present in RulesGet JSON')
        if 'notification_filter' in _dict:
            args['notification_filter'] = _dict.get('notification_filter')
        else:
            raise ValueError('Required property \'notification_filter\' not present in RulesGet JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in RulesGet JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in RulesGet JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RulesGet object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'event_type_filter') and self.event_type_filter is not None:
            _dict['event_type_filter'] = self.event_type_filter
        if hasattr(self, 'notification_filter') and self.notification_filter is not None:
            _dict['notification_filter'] = self.notification_filter
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RulesGet object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RulesGet') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RulesGet') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Source():
    """
    Payload describing a source generate request.

    :attr str id: The id of the source.
    :attr str name: The name of the source.
    :attr str description: The description of the source.
    :attr bool enabled: The status of the source.
    :attr str type: Type of the source.
    :attr datetime updated_at: The last updated time of the source.
    :attr int topic_count: The number of topics.
    :attr List[str] topic_names: The names of the topics.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 enabled: bool,
                 type: str,
                 updated_at: datetime,
                 topic_count: int,
                 topic_names: List[str]) -> None:
        """
        Initialize a Source object.

        :param str id: The id of the source.
        :param str name: The name of the source.
        :param str description: The description of the source.
        :param bool enabled: The status of the source.
        :param str type: Type of the source.
        :param datetime updated_at: The last updated time of the source.
        :param int topic_count: The number of topics.
        :param List[str] topic_names: The names of the topics.
        """
        self.id = id
        self.name = name
        self.description = description
        self.enabled = enabled
        self.type = type
        self.updated_at = updated_at
        self.topic_count = topic_count
        self.topic_names = topic_names

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Source':
        """Initialize a Source object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Source JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Source JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Source JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in Source JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in Source JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in Source JSON')
        if 'topic_count' in _dict:
            args['topic_count'] = _dict.get('topic_count')
        else:
            raise ValueError('Required property \'topic_count\' not present in Source JSON')
        if 'topic_names' in _dict:
            args['topic_names'] = _dict.get('topic_names')
        else:
            raise ValueError('Required property \'topic_names\' not present in Source JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Source object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'topic_count') and self.topic_count is not None:
            _dict['topic_count'] = self.topic_count
        if hasattr(self, 'topic_names') and self.topic_names is not None:
            _dict['topic_names'] = self.topic_names
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Source object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Source') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Source') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceList():
    """
    Payload describing a source list request.

    :attr int total_count: Number of sources.
    :attr int offset: Current offset.
    :attr int limit: limit to show sources.
    :attr List[SourceListItem] sources: List of sources.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 sources: List['SourceListItem']) -> None:
        """
        Initialize a SourceList object.

        :param int total_count: Number of sources.
        :param int offset: Current offset.
        :param int limit: limit to show sources.
        :param List[SourceListItem] sources: List of sources.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.sources = sources

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceList':
        """Initialize a SourceList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in SourceList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in SourceList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in SourceList JSON')
        if 'sources' in _dict:
            args['sources'] = [SourceListItem.from_dict(x) for x in _dict.get('sources')]
        else:
            raise ValueError('Required property \'sources\' not present in SourceList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'sources') and self.sources is not None:
            _dict['sources'] = [x.to_dict() for x in self.sources]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceListItem():
    """
    Payload describing a source list item.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr str description: Description of the source.
    :attr str type: Type of the source.
    :attr bool enabled: Whether the source is enabled or not.
    :attr datetime updated_at: Time of the last update.
    :attr int topic_count: Number of topics.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 enabled: bool,
                 updated_at: datetime,
                 topic_count: int) -> None:
        """
        Initialize a SourceListItem object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param str type: Type of the source.
        :param bool enabled: Whether the source is enabled or not.
        :param datetime updated_at: Time of the last update.
        :param int topic_count: Number of topics.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.enabled = enabled
        self.updated_at = updated_at
        self.topic_count = topic_count

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceListItem':
        """Initialize a SourceListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourceListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourceListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SourceListItem JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in SourceListItem JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in SourceListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in SourceListItem JSON')
        if 'topic_count' in _dict:
            args['topic_count'] = _dict.get('topic_count')
        else:
            raise ValueError('Required property \'topic_count\' not present in SourceListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'topic_count') and self.topic_count is not None:
            _dict['topic_count'] = self.topic_count
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceResponse():
    """
    Payload describing a source.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr str description: Description of the source.
    :attr bool enabled: Whether the source is enabled or not.
    :attr datetime created_at: Time of the created.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 enabled: bool,
                 created_at: datetime) -> None:
        """
        Initialize a SourceResponse object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param bool enabled: Whether the source is enabled or not.
        :param datetime created_at: Time of the created.
        """
        self.id = id
        self.name = name
        self.description = description
        self.enabled = enabled
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceResponse':
        """Initialize a SourceResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourceResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourceResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SourceResponse JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in SourceResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in SourceResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourcesListItem():
    """
    SourcesListItem.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr List[RulesGet] rules: List of rules.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 rules: List['RulesGet']) -> None:
        """
        Initialize a SourcesListItem object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param List[RulesGet] rules: List of rules.
        """
        self.id = id
        self.name = name
        self.rules = rules

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourcesListItem':
        """Initialize a SourcesListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourcesListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourcesListItem JSON')
        if 'rules' in _dict:
            args['rules'] = [RulesGet.from_dict(x) for x in _dict.get('rules')]
        else:
            raise ValueError('Required property \'rules\' not present in SourcesListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourcesListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'rules') and self.rules is not None:
            _dict['rules'] = [x.to_dict() for x in self.rules]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourcesListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourcesListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourcesListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Subscription():
    """
    Subscription object.

    :attr str id: Subscription ID.
    :attr str name: Subscription name.
    :attr str description: Subscription description.
    :attr str updated_at: Last updated time.
    :attr str from_: (optional) From Email ID (it will be displayed only in case of
          smtp_ibm destination type).
    :attr str destination_type: The type of destination.
    :attr str destination_id: The destination ID.
    :attr str destination_name: The destination name.
    :attr str topic_id: Topic ID.
    :attr str topic_name: Topic name.
    :attr SubscriptionAttributes attributes: (optional)
    """

    # The set of defined properties for the class
    _properties = frozenset(['id', 'name', 'description', 'updated_at', 'from_', 'from', 'destination_type', 'destination_id', 'destination_name', 'topic_id', 'topic_name', 'attributes'])

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 updated_at: str,
                 destination_type: str,
                 destination_id: str,
                 destination_name: str,
                 topic_id: str,
                 topic_name: str,
                 *,
                 from_: str = None,
                 attributes: 'SubscriptionAttributes' = None,
                 **kwargs) -> None:
        """
        Initialize a Subscription object.

        :param str id: Subscription ID.
        :param str name: Subscription name.
        :param str description: Subscription description.
        :param str updated_at: Last updated time.
        :param str destination_type: The type of destination.
        :param str destination_id: The destination ID.
        :param str destination_name: The destination name.
        :param str topic_id: Topic ID.
        :param str topic_name: Topic name.
        :param str from_: (optional) From Email ID (it will be displayed only in
               case of smtp_ibm destination type).
        :param SubscriptionAttributes attributes: (optional)
        :param **kwargs: (optional) Any additional properties.
        """
        self.id = id
        self.name = name
        self.description = description
        self.updated_at = updated_at
        self.from_ = from_
        self.destination_type = destination_type
        self.destination_id = destination_id
        self.destination_name = destination_name
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.attributes = attributes
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Subscription':
        """Initialize a Subscription object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Subscription JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Subscription JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Subscription JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in Subscription JSON')
        if 'from' in _dict:
            args['from_'] = _dict.get('from')
        if 'destination_type' in _dict:
            args['destination_type'] = _dict.get('destination_type')
        else:
            raise ValueError('Required property \'destination_type\' not present in Subscription JSON')
        if 'destination_id' in _dict:
            args['destination_id'] = _dict.get('destination_id')
        else:
            raise ValueError('Required property \'destination_id\' not present in Subscription JSON')
        if 'destination_name' in _dict:
            args['destination_name'] = _dict.get('destination_name')
        else:
            raise ValueError('Required property \'destination_name\' not present in Subscription JSON')
        if 'topic_id' in _dict:
            args['topic_id'] = _dict.get('topic_id')
        else:
            raise ValueError('Required property \'topic_id\' not present in Subscription JSON')
        if 'topic_name' in _dict:
            args['topic_name'] = _dict.get('topic_name')
        else:
            raise ValueError('Required property \'topic_name\' not present in Subscription JSON')
        if 'attributes' in _dict:
            args['attributes'] = _dict.get('attributes')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Subscription object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'from_') and self.from_ is not None:
            _dict['from'] = self.from_
        if hasattr(self, 'destination_type') and self.destination_type is not None:
            _dict['destination_type'] = self.destination_type
        if hasattr(self, 'destination_id') and self.destination_id is not None:
            _dict['destination_id'] = self.destination_id
        if hasattr(self, 'destination_name') and self.destination_name is not None:
            _dict['destination_name'] = self.destination_name
        if hasattr(self, 'topic_id') and self.topic_id is not None:
            _dict['topic_id'] = self.topic_id
        if hasattr(self, 'topic_name') and self.topic_name is not None:
            _dict['topic_name'] = self.topic_name
        if hasattr(self, 'attributes') and self.attributes is not None:
            if isinstance(self.attributes, dict):
                _dict['attributes'] = self.attributes
            else:
                _dict['attributes'] = self.attributes.to_dict()
        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of Subscription"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of Subscription"""
        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in Subscription._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this Subscription object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Subscription') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Subscription') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class DestinationTypeEnum(str, Enum):
        """
        The type of destination.
        """
        SMS_IBM = 'sms_ibm'
        SMTP_IBM = 'smtp_ibm'
        WEBHOOK = 'webhook'


class SubscriptionAttributes():
    """
    SubscriptionAttributes.

    """

    def __init__(self,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributes object.

        :param **kwargs: (optional) Any additional properties.
        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionAttributesSMSAttributesResponse', 'SubscriptionAttributesEmailAttributesResponse', 'SubscriptionAttributesWebhookAttributesResponse']))
        raise Exception(msg)

class SubscriptionCreateAttributes():
    """
    SubscriptionCreateAttributes.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionCreateAttributes object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionCreateAttributesSMSAttributes', 'SubscriptionCreateAttributesEmailAttributes', 'SubscriptionCreateAttributesWebhookAttributes', 'SubscriptionCreateAttributesFCMAttributes']))
        raise Exception(msg)

class SubscriptionList():
    """
    Subscription list object.

    :attr int total_count: Number of subscriptions.
    :attr int offset: Current offset.
    :attr int limit: limit to show subscriptions.
    :attr List[SubscriptionListItem] subscriptions: List of subscriptions.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 subscriptions: List['SubscriptionListItem']) -> None:
        """
        Initialize a SubscriptionList object.

        :param int total_count: Number of subscriptions.
        :param int offset: Current offset.
        :param int limit: limit to show subscriptions.
        :param List[SubscriptionListItem] subscriptions: List of subscriptions.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.subscriptions = subscriptions

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionList':
        """Initialize a SubscriptionList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in SubscriptionList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in SubscriptionList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in SubscriptionList JSON')
        if 'subscriptions' in _dict:
            args['subscriptions'] = [SubscriptionListItem.from_dict(x) for x in _dict.get('subscriptions')]
        else:
            raise ValueError('Required property \'subscriptions\' not present in SubscriptionList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'subscriptions') and self.subscriptions is not None:
            _dict['subscriptions'] = [x.to_dict() for x in self.subscriptions]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionListItem():
    """
    Subscription list item.

    :attr str id: ID of the subscription.
    :attr str name: Name of the subscription.
    :attr str description: Description of the subscription.
    :attr str destination_id: ID of the destination.
    :attr str destination_name: (optional) Name of the destination.
    :attr str destination_type: The type of destination.
    :attr str topic_id: ID of the topic.
    :attr str topic_name: (optional) Name of the topic.
    :attr datetime updated_at: Last updated time of the subscription.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 destination_id: str,
                 destination_type: str,
                 topic_id: str,
                 updated_at: datetime,
                 *,
                 destination_name: str = None,
                 topic_name: str = None) -> None:
        """
        Initialize a SubscriptionListItem object.

        :param str id: ID of the subscription.
        :param str name: Name of the subscription.
        :param str description: Description of the subscription.
        :param str destination_id: ID of the destination.
        :param str destination_type: The type of destination.
        :param str topic_id: ID of the topic.
        :param datetime updated_at: Last updated time of the subscription.
        :param str destination_name: (optional) Name of the destination.
        :param str topic_name: (optional) Name of the topic.
        """
        self.id = id
        self.name = name
        self.description = description
        self.destination_id = destination_id
        self.destination_name = destination_name
        self.destination_type = destination_type
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionListItem':
        """Initialize a SubscriptionListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SubscriptionListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SubscriptionListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SubscriptionListItem JSON')
        if 'destination_id' in _dict:
            args['destination_id'] = _dict.get('destination_id')
        else:
            raise ValueError('Required property \'destination_id\' not present in SubscriptionListItem JSON')
        if 'destination_name' in _dict:
            args['destination_name'] = _dict.get('destination_name')
        if 'destination_type' in _dict:
            args['destination_type'] = _dict.get('destination_type')
        else:
            raise ValueError('Required property \'destination_type\' not present in SubscriptionListItem JSON')
        if 'topic_id' in _dict:
            args['topic_id'] = _dict.get('topic_id')
        else:
            raise ValueError('Required property \'topic_id\' not present in SubscriptionListItem JSON')
        if 'topic_name' in _dict:
            args['topic_name'] = _dict.get('topic_name')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in SubscriptionListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'destination_id') and self.destination_id is not None:
            _dict['destination_id'] = self.destination_id
        if hasattr(self, 'destination_name') and self.destination_name is not None:
            _dict['destination_name'] = self.destination_name
        if hasattr(self, 'destination_type') and self.destination_type is not None:
            _dict['destination_type'] = self.destination_type
        if hasattr(self, 'topic_id') and self.topic_id is not None:
            _dict['topic_id'] = self.topic_id
        if hasattr(self, 'topic_name') and self.topic_name is not None:
            _dict['topic_name'] = self.topic_name
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class DestinationTypeEnum(str, Enum):
        """
        The type of destination.
        """
        SMS_IBM = 'sms_ibm'
        SMTP_IBM = 'smtp_ibm'
        WEBHOOK = 'webhook'


class SubscriptionUpdateAttributes():
    """
    SubscriptionUpdateAttributes.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionUpdateAttributes object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionUpdateAttributesSMSAttributes', 'SubscriptionUpdateAttributesEmailUpdateAttributes', 'SubscriptionUpdateAttributesWebhookAttributes']))
        raise Exception(msg)

class TagsSubscriptionList():
    """
    Payload describing a tags list request.

    :attr int total_count: Total number of tags.
    :attr int offset: Current offset.
    :attr int limit: limit to show tags.
    :attr List[TagsSubscriptionListItem] tag_subscriptions: List of tags.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 tag_subscriptions: List['TagsSubscriptionListItem']) -> None:
        """
        Initialize a TagsSubscriptionList object.

        :param int total_count: Total number of tags.
        :param int offset: Current offset.
        :param int limit: limit to show tags.
        :param List[TagsSubscriptionListItem] tag_subscriptions: List of tags.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.tag_subscriptions = tag_subscriptions

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TagsSubscriptionList':
        """Initialize a TagsSubscriptionList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in TagsSubscriptionList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in TagsSubscriptionList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in TagsSubscriptionList JSON')
        if 'tag_subscriptions' in _dict:
            args['tag_subscriptions'] = [TagsSubscriptionListItem.from_dict(x) for x in _dict.get('tag_subscriptions')]
        else:
            raise ValueError('Required property \'tag_subscriptions\' not present in TagsSubscriptionList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TagsSubscriptionList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'tag_subscriptions') and self.tag_subscriptions is not None:
            _dict['tag_subscriptions'] = [x.to_dict() for x in self.tag_subscriptions]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TagsSubscriptionList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TagsSubscriptionList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TagsSubscriptionList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TagsSubscriptionListItem():
    """
    Tags subscription object.

    :attr str id: Subscription Tag ID.
    :attr str device_id: Unique identifier of the device.
    :attr str tag_name: The name of the tag its subscribed.
    :attr str user_id: (optional) The user identifier for the the device
          registration.
    :attr datetime updated_at: Updated at.
    """

    def __init__(self,
                 id: str,
                 device_id: str,
                 tag_name: str,
                 updated_at: datetime,
                 *,
                 user_id: str = None) -> None:
        """
        Initialize a TagsSubscriptionListItem object.

        :param str id: Subscription Tag ID.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param datetime updated_at: Updated at.
        :param str user_id: (optional) The user identifier for the the device
               registration.
        """
        self.id = id
        self.device_id = device_id
        self.tag_name = tag_name
        self.user_id = user_id
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TagsSubscriptionListItem':
        """Initialize a TagsSubscriptionListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TagsSubscriptionListItem JSON')
        if 'device_id' in _dict:
            args['device_id'] = _dict.get('device_id')
        else:
            raise ValueError('Required property \'device_id\' not present in TagsSubscriptionListItem JSON')
        if 'tag_name' in _dict:
            args['tag_name'] = _dict.get('tag_name')
        else:
            raise ValueError('Required property \'tag_name\' not present in TagsSubscriptionListItem JSON')
        if 'user_id' in _dict:
            args['user_id'] = _dict.get('user_id')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in TagsSubscriptionListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TagsSubscriptionListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'device_id') and self.device_id is not None:
            _dict['device_id'] = self.device_id
        if hasattr(self, 'tag_name') and self.tag_name is not None:
            _dict['tag_name'] = self.tag_name
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TagsSubscriptionListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TagsSubscriptionListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TagsSubscriptionListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Topic():
    """
    Topic object.

    :attr str id: Autogenerated topic ID.
    :attr str description: Description of the topic.
    :attr str name: Name of the topic.
    :attr str updated_at: Last time the topic was updated.
    :attr int source_count: Number of sources.
    :attr List[SourcesListItem] sources: List of sources.
    :attr int subscription_count: Number of subscriptions.
    :attr List[SubscriptionListItem] subscriptions: List of subscriptions.
    """

    def __init__(self,
                 id: str,
                 description: str,
                 name: str,
                 updated_at: str,
                 source_count: int,
                 sources: List['SourcesListItem'],
                 subscription_count: int,
                 subscriptions: List['SubscriptionListItem']) -> None:
        """
        Initialize a Topic object.

        :param str id: Autogenerated topic ID.
        :param str description: Description of the topic.
        :param str name: Name of the topic.
        :param str updated_at: Last time the topic was updated.
        :param int source_count: Number of sources.
        :param List[SourcesListItem] sources: List of sources.
        :param int subscription_count: Number of subscriptions.
        :param List[SubscriptionListItem] subscriptions: List of subscriptions.
        """
        self.id = id
        self.description = description
        self.name = name
        self.updated_at = updated_at
        self.source_count = source_count
        self.sources = sources
        self.subscription_count = subscription_count
        self.subscriptions = subscriptions

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Topic':
        """Initialize a Topic object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Topic JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Topic JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Topic JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in Topic JSON')
        if 'source_count' in _dict:
            args['source_count'] = _dict.get('source_count')
        else:
            raise ValueError('Required property \'source_count\' not present in Topic JSON')
        if 'sources' in _dict:
            args['sources'] = [SourcesListItem.from_dict(x) for x in _dict.get('sources')]
        else:
            raise ValueError('Required property \'sources\' not present in Topic JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in Topic JSON')
        if 'subscriptions' in _dict:
            args['subscriptions'] = [SubscriptionListItem.from_dict(x) for x in _dict.get('subscriptions')]
        else:
            raise ValueError('Required property \'subscriptions\' not present in Topic JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Topic object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'source_count') and self.source_count is not None:
            _dict['source_count'] = self.source_count
        if hasattr(self, 'sources') and self.sources is not None:
            _dict['sources'] = [x.to_dict() for x in self.sources]
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscriptions') and self.subscriptions is not None:
            _dict['subscriptions'] = [x.to_dict() for x in self.subscriptions]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Topic object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Topic') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Topic') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicList():
    """
    Topic list object.

    :attr int total_count: Number of topics.
    :attr int offset: Current offset.
    :attr int limit: limit to show subscriptions.
    :attr List[TopicsListItem] topics: List of topics.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 topics: List['TopicsListItem']) -> None:
        """
        Initialize a TopicList object.

        :param int total_count: Number of topics.
        :param int offset: Current offset.
        :param int limit: limit to show subscriptions.
        :param List[TopicsListItem] topics: List of topics.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.topics = topics

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicList':
        """Initialize a TopicList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in TopicList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in TopicList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in TopicList JSON')
        if 'topics' in _dict:
            args['topics'] = [TopicsListItem.from_dict(x) for x in _dict.get('topics')]
        else:
            raise ValueError('Required property \'topics\' not present in TopicList JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'topics') and self.topics is not None:
            _dict['topics'] = [x.to_dict() for x in self.topics]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicResponse():
    """
    Topic object.

    :attr str id: Autogenerated topic ID.
    :attr str name: Name of the topic.
    :attr str description: Description of the topic.
    :attr str created_at: Last time the topic was updated.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 created_at: str) -> None:
        """
        Initialize a TopicResponse object.

        :param str id: Autogenerated topic ID.
        :param str name: Name of the topic.
        :param str description: Description of the topic.
        :param str created_at: Last time the topic was updated.
        """
        self.id = id
        self.name = name
        self.description = description
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicResponse':
        """Initialize a TopicResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TopicResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TopicResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in TopicResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = _dict.get('created_at')
        else:
            raise ValueError('Required property \'created_at\' not present in TopicResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = self.created_at
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicUpdateSourcesItem():
    """
    TopicUpdateSourcesItem.

    :attr str id: ID of the source.
    :attr List[Rules] rules: List of rules.
    """

    def __init__(self,
                 id: str,
                 rules: List['Rules']) -> None:
        """
        Initialize a TopicUpdateSourcesItem object.

        :param str id: ID of the source.
        :param List[Rules] rules: List of rules.
        """
        self.id = id
        self.rules = rules

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicUpdateSourcesItem':
        """Initialize a TopicUpdateSourcesItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TopicUpdateSourcesItem JSON')
        if 'rules' in _dict:
            args['rules'] = [Rules.from_dict(x) for x in _dict.get('rules')]
        else:
            raise ValueError('Required property \'rules\' not present in TopicUpdateSourcesItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicUpdateSourcesItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'rules') and self.rules is not None:
            _dict['rules'] = [x.to_dict() for x in self.rules]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicUpdateSourcesItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicUpdateSourcesItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicUpdateSourcesItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicsListItem():
    """
    Topic list item object.

    :attr str id: Autogenerated topic ID.
    :attr str name: Name of the topic.
    :attr str description: Description of the topic.
    :attr int source_count: Number of sources.
    :attr List[str] sources_names: List of source names.
    :attr int subscription_count: Number of subscriptions.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 source_count: int,
                 sources_names: List[str],
                 subscription_count: int) -> None:
        """
        Initialize a TopicsListItem object.

        :param str id: Autogenerated topic ID.
        :param str name: Name of the topic.
        :param str description: Description of the topic.
        :param int source_count: Number of sources.
        :param List[str] sources_names: List of source names.
        :param int subscription_count: Number of subscriptions.
        """
        self.id = id
        self.name = name
        self.description = description
        self.source_count = source_count
        self.sources_names = sources_names
        self.subscription_count = subscription_count

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicsListItem':
        """Initialize a TopicsListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TopicsListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TopicsListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in TopicsListItem JSON')
        if 'source_count' in _dict:
            args['source_count'] = _dict.get('source_count')
        else:
            raise ValueError('Required property \'source_count\' not present in TopicsListItem JSON')
        if 'sources_names' in _dict:
            args['sources_names'] = _dict.get('sources_names')
        else:
            raise ValueError('Required property \'sources_names\' not present in TopicsListItem JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in TopicsListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicsListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'source_count') and self.source_count is not None:
            _dict['source_count'] = self.source_count
        if hasattr(self, 'sources_names') and self.sources_names is not None:
            _dict['sources_names'] = self.sources_names
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicsListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicsListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicsListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParamsChromeDestinationConfig(DestinationConfigParams):
    """
    Payload describing a Chrome destination configuration.

    :attr str api_key: FCM api_key.
    :attr str website_url: Website url.
    :attr str public_key: (optional) Chrome VAPID public key.
    """

    def __init__(self,
                 api_key: str,
                 website_url: str,
                 *,
                 public_key: str = None) -> None:
        """
        Initialize a DestinationConfigParamsChromeDestinationConfig object.

        :param str api_key: FCM api_key.
        :param str website_url: Website url.
        :param str public_key: (optional) Chrome VAPID public key.
        """
        # pylint: disable=super-init-not-called
        self.api_key = api_key
        self.website_url = website_url
        self.public_key = public_key

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigParamsChromeDestinationConfig':
        """Initialize a DestinationConfigParamsChromeDestinationConfig object from a json dictionary."""
        args = {}
        if 'api_key' in _dict:
            args['api_key'] = _dict.get('api_key')
        else:
            raise ValueError('Required property \'api_key\' not present in DestinationConfigParamsChromeDestinationConfig JSON')
        if 'website_url' in _dict:
            args['website_url'] = _dict.get('website_url')
        else:
            raise ValueError('Required property \'website_url\' not present in DestinationConfigParamsChromeDestinationConfig JSON')
        if 'public_key' in _dict:
            args['public_key'] = _dict.get('public_key')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigParamsChromeDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'api_key') and self.api_key is not None:
            _dict['api_key'] = self.api_key
        if hasattr(self, 'website_url') and self.website_url is not None:
            _dict['website_url'] = self.website_url
        if hasattr(self, 'public_key') and self.public_key is not None:
            _dict['public_key'] = self.public_key
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigParamsChromeDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigParamsChromeDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigParamsChromeDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParamsFCMDestinationConfig(DestinationConfigParams):
    """
    Payload describing a FCM destination configuration.

    :attr str server_key: FCM server_key.
    :attr str sender_id: FCM sender_id.
    """

    def __init__(self,
                 server_key: str,
                 sender_id: str) -> None:
        """
        Initialize a DestinationConfigParamsFCMDestinationConfig object.

        :param str server_key: FCM server_key.
        :param str sender_id: FCM sender_id.
        """
        # pylint: disable=super-init-not-called
        self.server_key = server_key
        self.sender_id = sender_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigParamsFCMDestinationConfig':
        """Initialize a DestinationConfigParamsFCMDestinationConfig object from a json dictionary."""
        args = {}
        if 'server_key' in _dict:
            args['server_key'] = _dict.get('server_key')
        else:
            raise ValueError('Required property \'server_key\' not present in DestinationConfigParamsFCMDestinationConfig JSON')
        if 'sender_id' in _dict:
            args['sender_id'] = _dict.get('sender_id')
        else:
            raise ValueError('Required property \'sender_id\' not present in DestinationConfigParamsFCMDestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigParamsFCMDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'server_key') and self.server_key is not None:
            _dict['server_key'] = self.server_key
        if hasattr(self, 'sender_id') and self.sender_id is not None:
            _dict['sender_id'] = self.sender_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigParamsFCMDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigParamsFCMDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigParamsFCMDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParamsFirefoxDestinationConfig(DestinationConfigParams):
    """
    Payload describing a Firefox destination configuration.

    :attr str website_url: Website url.
    :attr str public_key: (optional) Chrome VAPID public key.
    """

    def __init__(self,
                 website_url: str,
                 *,
                 public_key: str = None) -> None:
        """
        Initialize a DestinationConfigParamsFirefoxDestinationConfig object.

        :param str website_url: Website url.
        :param str public_key: (optional) Chrome VAPID public key.
        """
        # pylint: disable=super-init-not-called
        self.website_url = website_url
        self.public_key = public_key

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigParamsFirefoxDestinationConfig':
        """Initialize a DestinationConfigParamsFirefoxDestinationConfig object from a json dictionary."""
        args = {}
        if 'website_url' in _dict:
            args['website_url'] = _dict.get('website_url')
        else:
            raise ValueError('Required property \'website_url\' not present in DestinationConfigParamsFirefoxDestinationConfig JSON')
        if 'public_key' in _dict:
            args['public_key'] = _dict.get('public_key')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigParamsFirefoxDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'website_url') and self.website_url is not None:
            _dict['website_url'] = self.website_url
        if hasattr(self, 'public_key') and self.public_key is not None:
            _dict['public_key'] = self.public_key
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigParamsFirefoxDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigParamsFirefoxDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigParamsFirefoxDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParamsIOSDestinationConfig(DestinationConfigParams):
    """
    Payload describing a IOS destination configuration.

    :attr str cert_type: Authentication type (p8 or p12).
    :attr bool is_sandbox: Sandbox mode for IOS destinations.
    :attr str password: (optional) Password for certificate (Required when cert_type
          is p12).
    :attr str key_id: (optional) Key ID for token (Required when cert_type is p8).
    :attr str team_id: (optional) Team ID for token (Required when cert_type is p8).
    :attr str bundle_id: (optional) Bundle ID for token (Required when cert_type is
          p8).
    """

    def __init__(self,
                 cert_type: str,
                 is_sandbox: bool,
                 *,
                 password: str = None,
                 key_id: str = None,
                 team_id: str = None,
                 bundle_id: str = None) -> None:
        """
        Initialize a DestinationConfigParamsIOSDestinationConfig object.

        :param str cert_type: Authentication type (p8 or p12).
        :param bool is_sandbox: Sandbox mode for IOS destinations.
        :param str password: (optional) Password for certificate (Required when
               cert_type is p12).
        :param str key_id: (optional) Key ID for token (Required when cert_type is
               p8).
        :param str team_id: (optional) Team ID for token (Required when cert_type
               is p8).
        :param str bundle_id: (optional) Bundle ID for token (Required when
               cert_type is p8).
        """
        # pylint: disable=super-init-not-called
        self.cert_type = cert_type
        self.is_sandbox = is_sandbox
        self.password = password
        self.key_id = key_id
        self.team_id = team_id
        self.bundle_id = bundle_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigParamsIOSDestinationConfig':
        """Initialize a DestinationConfigParamsIOSDestinationConfig object from a json dictionary."""
        args = {}
        if 'cert_type' in _dict:
            args['cert_type'] = _dict.get('cert_type')
        else:
            raise ValueError('Required property \'cert_type\' not present in DestinationConfigParamsIOSDestinationConfig JSON')
        if 'is_sandbox' in _dict:
            args['is_sandbox'] = _dict.get('is_sandbox')
        else:
            raise ValueError('Required property \'is_sandbox\' not present in DestinationConfigParamsIOSDestinationConfig JSON')
        if 'password' in _dict:
            args['password'] = _dict.get('password')
        if 'key_id' in _dict:
            args['key_id'] = _dict.get('key_id')
        if 'team_id' in _dict:
            args['team_id'] = _dict.get('team_id')
        if 'bundle_id' in _dict:
            args['bundle_id'] = _dict.get('bundle_id')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigParamsIOSDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'cert_type') and self.cert_type is not None:
            _dict['cert_type'] = self.cert_type
        if hasattr(self, 'is_sandbox') and self.is_sandbox is not None:
            _dict['is_sandbox'] = self.is_sandbox
        if hasattr(self, 'password') and self.password is not None:
            _dict['password'] = self.password
        if hasattr(self, 'key_id') and self.key_id is not None:
            _dict['key_id'] = self.key_id
        if hasattr(self, 'team_id') and self.team_id is not None:
            _dict['team_id'] = self.team_id
        if hasattr(self, 'bundle_id') and self.bundle_id is not None:
            _dict['bundle_id'] = self.bundle_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigParamsIOSDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigParamsIOSDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigParamsIOSDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigParamsWebhookDestinationConfig(DestinationConfigParams):
    """
    Payload describing a webhook destination configuration.

    :attr str url: URL of webhook.
    :attr str verb: HTTP method of webhook.
    :attr dict custom_headers: (optional) Custom headers (Key-Value pair) for
          webhook call.
    :attr List[str] sensitive_headers: (optional) List of sensitive headers from
          custom headers.
    """

    def __init__(self,
                 url: str,
                 verb: str,
                 *,
                 custom_headers: dict = None,
                 sensitive_headers: List[str] = None) -> None:
        """
        Initialize a DestinationConfigParamsWebhookDestinationConfig object.

        :param str url: URL of webhook.
        :param str verb: HTTP method of webhook.
        :param dict custom_headers: (optional) Custom headers (Key-Value pair) for
               webhook call.
        :param List[str] sensitive_headers: (optional) List of sensitive headers
               from custom headers.
        """
        # pylint: disable=super-init-not-called
        self.url = url
        self.verb = verb
        self.custom_headers = custom_headers
        self.sensitive_headers = sensitive_headers

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigParamsWebhookDestinationConfig':
        """Initialize a DestinationConfigParamsWebhookDestinationConfig object from a json dictionary."""
        args = {}
        if 'url' in _dict:
            args['url'] = _dict.get('url')
        else:
            raise ValueError('Required property \'url\' not present in DestinationConfigParamsWebhookDestinationConfig JSON')
        if 'verb' in _dict:
            args['verb'] = _dict.get('verb')
        else:
            raise ValueError('Required property \'verb\' not present in DestinationConfigParamsWebhookDestinationConfig JSON')
        if 'custom_headers' in _dict:
            args['custom_headers'] = _dict.get('custom_headers')
        if 'sensitive_headers' in _dict:
            args['sensitive_headers'] = _dict.get('sensitive_headers')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigParamsWebhookDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        if hasattr(self, 'verb') and self.verb is not None:
            _dict['verb'] = self.verb
        if hasattr(self, 'custom_headers') and self.custom_headers is not None:
            _dict['custom_headers'] = self.custom_headers
        if hasattr(self, 'sensitive_headers') and self.sensitive_headers is not None:
            _dict['sensitive_headers'] = self.sensitive_headers
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigParamsWebhookDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigParamsWebhookDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigParamsWebhookDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class VerbEnum(str, Enum):
        """
        HTTP method of webhook.
        """
        GET = 'get'
        POST = 'post'


class SubscriptionAttributesEmailAttributesResponse(SubscriptionAttributes):
    """
    The attributes reponse for an email destination.

    """

    def __init__(self,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesEmailAttributesResponse object.

        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesEmailAttributesResponse':
        """Initialize a SubscriptionAttributesEmailAttributesResponse object from a json dictionary."""
        return cls(**_dict)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesEmailAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        return vars(self)

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesEmailAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys()]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesEmailAttributesResponse"""
        for _key in [k for k in vars(self).keys()]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesEmailAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesEmailAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesEmailAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesSMSAttributesResponse(SubscriptionAttributes):
    """
    SMS attributes object.

    """

    def __init__(self,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesSMSAttributesResponse object.

        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesSMSAttributesResponse':
        """Initialize a SubscriptionAttributesSMSAttributesResponse object from a json dictionary."""
        return cls(**_dict)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesSMSAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        return vars(self)

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesSMSAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys()]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesSMSAttributesResponse"""
        for _key in [k for k in vars(self).keys()]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesSMSAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesSMSAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesSMSAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesWebhookAttributesResponse(SubscriptionAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    :attr bool add_notification_payload: Decision for Notification Payload to be
          added.
    """

    # The set of defined properties for the class
    _properties = frozenset(['signing_enabled', 'add_notification_payload'])

    def __init__(self,
                 signing_enabled: bool,
                 add_notification_payload: bool,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesWebhookAttributesResponse object.

        :param bool signing_enabled: Signing webhook attributes.
        :param bool add_notification_payload: Decision for Notification Payload to
               be added.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled
        self.add_notification_payload = add_notification_payload
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesWebhookAttributesResponse':
        """Initialize a SubscriptionAttributesWebhookAttributesResponse object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionAttributesWebhookAttributesResponse JSON')
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionAttributesWebhookAttributesResponse JSON')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesWebhookAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesWebhookAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesWebhookAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesWebhookAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesWebhookAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesWebhookAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesWebhookAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesEmailAttributes(SubscriptionCreateAttributes):
    """
    The attributes for an email notification.

    :attr List[str] to: The email id string.
    :attr bool add_notification_payload: Whether to add the notification payload to
          the email.
    :attr str reply_to_mail: The email address to reply to.
    :attr str reply_to_name: The email name to reply to.
    :attr str from_name: The email name of From.
    """

    def __init__(self,
                 to: List[str],
                 add_notification_payload: bool,
                 reply_to_mail: str,
                 reply_to_name: str,
                 from_name: str) -> None:
        """
        Initialize a SubscriptionCreateAttributesEmailAttributes object.

        :param List[str] to: The email id string.
        :param bool add_notification_payload: Whether to add the notification
               payload to the email.
        :param str reply_to_mail: The email address to reply to.
        :param str reply_to_name: The email name to reply to.
        :param str from_name: The email name of From.
        """
        # pylint: disable=super-init-not-called
        self.to = to
        self.add_notification_payload = add_notification_payload
        self.reply_to_mail = reply_to_mail
        self.reply_to_name = reply_to_name
        self.from_name = from_name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesEmailAttributes':
        """Initialize a SubscriptionCreateAttributesEmailAttributes object from a json dictionary."""
        args = {}
        if 'to' in _dict:
            args['to'] = _dict.get('to')
        else:
            raise ValueError('Required property \'to\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'reply_to_mail' in _dict:
            args['reply_to_mail'] = _dict.get('reply_to_mail')
        else:
            raise ValueError('Required property \'reply_to_mail\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'reply_to_name' in _dict:
            args['reply_to_name'] = _dict.get('reply_to_name')
        else:
            raise ValueError('Required property \'reply_to_name\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'from_name' in _dict:
            args['from_name'] = _dict.get('from_name')
        else:
            raise ValueError('Required property \'from_name\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesEmailAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'to') and self.to is not None:
            _dict['to'] = self.to
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        if hasattr(self, 'reply_to_mail') and self.reply_to_mail is not None:
            _dict['reply_to_mail'] = self.reply_to_mail
        if hasattr(self, 'reply_to_name') and self.reply_to_name is not None:
            _dict['reply_to_name'] = self.reply_to_name
        if hasattr(self, 'from_name') and self.from_name is not None:
            _dict['from_name'] = self.from_name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesEmailAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesEmailAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesEmailAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesFCMAttributes(SubscriptionCreateAttributes):
    """
    The attributes for an FCM notification.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionCreateAttributesFCMAttributes object.

        """
        # pylint: disable=super-init-not-called

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesFCMAttributes':
        """Initialize a SubscriptionCreateAttributesFCMAttributes object from a json dictionary."""
        return cls(**_dict)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesFCMAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        return vars(self)

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesFCMAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesFCMAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesFCMAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesSMSAttributes(SubscriptionCreateAttributes):
    """
    SMS attributes object.

    :attr List[str] to: The phone number to send the SMS to.
    """

    def __init__(self,
                 to: List[str]) -> None:
        """
        Initialize a SubscriptionCreateAttributesSMSAttributes object.

        :param List[str] to: The phone number to send the SMS to.
        """
        # pylint: disable=super-init-not-called
        self.to = to

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesSMSAttributes':
        """Initialize a SubscriptionCreateAttributesSMSAttributes object from a json dictionary."""
        args = {}
        if 'to' in _dict:
            args['to'] = _dict.get('to')
        else:
            raise ValueError('Required property \'to\' not present in SubscriptionCreateAttributesSMSAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesSMSAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'to') and self.to is not None:
            _dict['to'] = self.to
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesSMSAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesWebhookAttributes(SubscriptionCreateAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    """

    def __init__(self,
                 signing_enabled: bool) -> None:
        """
        Initialize a SubscriptionCreateAttributesWebhookAttributes object.

        :param bool signing_enabled: Signing webhook attributes.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesWebhookAttributes':
        """Initialize a SubscriptionCreateAttributesWebhookAttributes object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionCreateAttributesWebhookAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesWebhookAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesWebhookAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesEmailUpdateAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for an email notification.

    :attr EmailUpdateAttributesTo to: The email ids.
    :attr bool add_notification_payload: Whether to add the notification payload to
          the email.
    :attr str reply_to_mail: The email address to reply to.
    :attr str reply_to_name: The email name to reply to.
    :attr str from_name: The email name of From.
    :attr List[str] invited: (optional) The email ids invited.
    :attr EmailUpdateAttributesUnsubscribed unsubscribed: (optional) The email ids.
    """

    def __init__(self,
                 to: 'EmailUpdateAttributesTo',
                 add_notification_payload: bool,
                 reply_to_mail: str,
                 reply_to_name: str,
                 from_name: str,
                 *,
                 invited: List[str] = None,
                 unsubscribed: 'EmailUpdateAttributesUnsubscribed' = None) -> None:
        """
        Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object.

        :param EmailUpdateAttributesTo to: The email ids.
        :param bool add_notification_payload: Whether to add the notification
               payload to the email.
        :param str reply_to_mail: The email address to reply to.
        :param str reply_to_name: The email name to reply to.
        :param str from_name: The email name of From.
        :param List[str] invited: (optional) The email ids invited.
        :param EmailUpdateAttributesUnsubscribed unsubscribed: (optional) The email
               ids.
        """
        # pylint: disable=super-init-not-called
        self.to = to
        self.add_notification_payload = add_notification_payload
        self.reply_to_mail = reply_to_mail
        self.reply_to_name = reply_to_name
        self.from_name = from_name
        self.invited = invited
        self.unsubscribed = unsubscribed

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesEmailUpdateAttributes':
        """Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object from a json dictionary."""
        args = {}
        if 'to' in _dict:
            args['to'] = EmailUpdateAttributesTo.from_dict(_dict.get('to'))
        else:
            raise ValueError('Required property \'to\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'reply_to_mail' in _dict:
            args['reply_to_mail'] = _dict.get('reply_to_mail')
        else:
            raise ValueError('Required property \'reply_to_mail\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'reply_to_name' in _dict:
            args['reply_to_name'] = _dict.get('reply_to_name')
        else:
            raise ValueError('Required property \'reply_to_name\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'from_name' in _dict:
            args['from_name'] = _dict.get('from_name')
        else:
            raise ValueError('Required property \'from_name\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'invited' in _dict:
            args['invited'] = _dict.get('invited')
        if 'unsubscribed' in _dict:
            args['unsubscribed'] = EmailUpdateAttributesUnsubscribed.from_dict(_dict.get('unsubscribed'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'to') and self.to is not None:
            _dict['to'] = self.to.to_dict()
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        if hasattr(self, 'reply_to_mail') and self.reply_to_mail is not None:
            _dict['reply_to_mail'] = self.reply_to_mail
        if hasattr(self, 'reply_to_name') and self.reply_to_name is not None:
            _dict['reply_to_name'] = self.reply_to_name
        if hasattr(self, 'from_name') and self.from_name is not None:
            _dict['from_name'] = self.from_name
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = self.invited
        if hasattr(self, 'unsubscribed') and self.unsubscribed is not None:
            _dict['unsubscribed'] = self.unsubscribed.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesEmailUpdateAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesEmailUpdateAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesEmailUpdateAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesSMSAttributes(SubscriptionUpdateAttributes):
    """
    SMS attributes object.

    :attr List[str] to: The phone number to send the SMS to.
    """

    def __init__(self,
                 to: List[str]) -> None:
        """
        Initialize a SubscriptionUpdateAttributesSMSAttributes object.

        :param List[str] to: The phone number to send the SMS to.
        """
        # pylint: disable=super-init-not-called
        self.to = to

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesSMSAttributes':
        """Initialize a SubscriptionUpdateAttributesSMSAttributes object from a json dictionary."""
        args = {}
        if 'to' in _dict:
            args['to'] = _dict.get('to')
        else:
            raise ValueError('Required property \'to\' not present in SubscriptionUpdateAttributesSMSAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesSMSAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'to') and self.to is not None:
            _dict['to'] = self.to
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesSMSAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesWebhookAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    """

    def __init__(self,
                 signing_enabled: bool) -> None:
        """
        Initialize a SubscriptionUpdateAttributesWebhookAttributes object.

        :param bool signing_enabled: Signing webhook attributes.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesWebhookAttributes':
        """Initialize a SubscriptionUpdateAttributesWebhookAttributes object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionUpdateAttributesWebhookAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesWebhookAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesWebhookAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other
