"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * Supported Authorizer types
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    /** IAM Authorizer */
    HttpAuthorizerType["IAM"] = "AWS_IAM";
    /** JSON Web Tokens */
    HttpAuthorizerType["JWT"] = "JWT";
    /** Lambda Authorizer */
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * Payload format version for lambda authorizers
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    /** Version 1.0 */
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    /** Version 2.0 */
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * An authorizer for Http Apis
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends aws_cdk_lib_1.Resource {
    /**
     * Import an existing HTTP Authorizer into this CDK app.
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpAuthorizerAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpAuthorizer);
            }
            throw error;
        }
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation if this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: props.authorizerName ?? id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: props.resultsCacheTtl?.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer", version: "2.72.0-alpha.0" };
exports.HttpAuthorizer = HttpAuthorizer;
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * Explicitly configure no authorizers on specific HTTP API routes.
 */
class HttpNoneAuthorizer {
    bind(_) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteAuthorizerBindOptions(_);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            authorizationType: 'NONE',
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer", version: "2.72.0-alpha.0" };
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
//# sourceMappingURL=data:application/json;base64,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