## CalSciPy       
[![GitHub license](https://img.shields.io/github/license/Naereen/StrapDown.js.svg)](https://github.com/darikoneil/CalSciPy/blob/master/LICENSE)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://GitHub.com/darikoneil/CalSciPy/graphs/commit-activity)
[![Documentation Status](https://readthedocs.org/projects/calscipy/badge/?version=latest)](https://calscipy.readthedocs.io/en/latest/?badge=latest)
[![PyPi](https://badgen.net/badge/icon/pypi?icon=pypi&label)](https://pypi.org/project/CalSciPy/)


This python packages contains a variety of useful methods for handling, processing, and visualizing calcium imaging data. It's intended to be a collection of useful, well-documented functions often used in boilerplate code alongside software packages such as [Caiman](https://github.com/flatironinstitute/CaImAn), [SIMA](https://github.com/losonczylab/sima), and [Suite2P](https://github.com/MouseLand/suite2p).

#### Highlights
* Assign unique colormaps to subsets of ROIs to generate rich, informative videos
* Perona-Malik diffusion for edge-preserving denoising
* GPU-parallelized multidimensional filtering
* Interactive visualization

#### Installation
`pip install CalSciPy` or `pip install CalSciPy-<subpackage>`

#### Subpackages
* Coloring
* Event Processing
* Input/Output (I/O)
* Image Processing
* Interactive Visuals
* Reorganization
* Signal Processing
* Static Visuals

#### Documentation
Hosted at [ReadtheDocs](https://calscipy.readthedocs.io/en/latest/index.html#).
Available locally as [HTML](https://github.com/darikoneil/CalSciPy/tree/master/docs/build/html), [LATEX](https://github.com/darikoneil/CalSciPy/tree/master/docs/build/latex) and [PDF](https://github.com/darikoneil/CalSciPy/blob/master/docs/build/pdf/calscipy.pdf).

