"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolEmail = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const punycode_1 = require("punycode/");
/**
  * The valid Amazon SES configuration regions
  */
const REGIONS = ['us-east-1', 'us-west-2', 'eu-west-1'];
/**
 * Configure how Cognito sends emails.
 *
 * @stability stable
 */
class UserPoolEmail {
    /**
     * Send email using Cognito.
     *
     * @stability stable
     */
    static withCognito(replyTo) {
        return new CognitoEmail(replyTo);
    }
    /**
     * Send email using SES.
     *
     * @stability stable
     */
    static withSES(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_cognito_UserPoolSESOptions(options);
        return new SESEmail(options);
    }
}
exports.UserPoolEmail = UserPoolEmail;
_a = JSII_RTTI_SYMBOL_1;
UserPoolEmail[_a] = { fqn: "@aws-cdk/aws-cognito.UserPoolEmail", version: "1.134.0" };
class CognitoEmail extends UserPoolEmail {
    constructor(replyTo) {
        super();
        this.replyTo = replyTo;
    }
    _bind(_scope) {
        return {
            replyToEmailAddress: encodeAndTest(this.replyTo),
            emailSendingAccount: 'COGNITO_DEFAULT',
        };
    }
}
class SESEmail extends UserPoolEmail {
    constructor(options) {
        super();
        this.options = options;
    }
    _bind(scope) {
        var _b;
        const region = core_1.Stack.of(scope).region;
        if (core_1.Token.isUnresolved(region) && !this.options.sesRegion) {
            throw new Error('Your stack region cannot be determined so "sesRegion" is required in SESOptions');
        }
        if (this.options.sesRegion && !REGIONS.includes(this.options.sesRegion)) {
            throw new Error(`sesRegion must be one of 'us-east-1', 'us-west-2', 'eu-west-1'. received ${this.options.sesRegion}`);
        }
        else if (!this.options.sesRegion && !REGIONS.includes(region)) {
            throw new Error(`Your stack is in ${region}, which is not a SES Region. Please provide a valid value for 'sesRegion'`);
        }
        let from = this.options.fromEmail;
        if (this.options.fromName) {
            from = `${this.options.fromName} <${this.options.fromEmail}>`;
        }
        return {
            from: encodeAndTest(from),
            replyToEmailAddress: encodeAndTest(this.options.replyTo),
            configurationSet: this.options.configurationSetName,
            emailSendingAccount: 'DEVELOPER',
            sourceArn: core_1.Stack.of(scope).formatArn({
                service: 'ses',
                resource: 'identity',
                resourceName: encodeAndTest(this.options.fromEmail),
                region: (_b = this.options.sesRegion) !== null && _b !== void 0 ? _b : region,
            }),
        };
    }
}
function encodeAndTest(input) {
    if (input) {
        const local = input.split('@')[0];
        if (!/[\p{ASCII}]+/u.test(local)) {
            throw new Error('the local part of the email address must use ASCII characters only');
        }
        return punycode_1.toASCII(input);
    }
    else {
        return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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