# A python tool box

Our python tool-box is supposed to help professionals in their day-to-day work.

Everything started when reaching blocking limitations with MS Excel, forcing us to search for alternatives. We learned Python, and started to implement reusable snippets.

As of 2021, we have a first workable snippet (yet perfectible), and we target to progressively (even-though 
slowly) enrich this tool-box, focusing on "IT project management" related stuff (as a start?).

In case you have feedbacks, ideas or suggestions, please let us know!

---

# Table of contents

* The project management toolbox
  * Predictability
    * Date
* The technicalities
  * PyPi versions
  * Install
  * Use
  * Contribute

---

# The project management toolbox

## Predictability

By definition, a good project manager is predictable, right?

But what do we mean by “being predictable”?
Let’s say that “Predictabilty” is about accurately predicting early enough the project outcomes, to enable timely corrective actions that increase the likelihood of achieving targets and reducing outcome variance.

Ok, fair enough. But how do we measure a project manager “predictable-ness”?

### Date predictability

The module `com.enovation.toolbox.predictability.dp_date_predictability` exposes several commands to deal with date predictability:

| Command                         | Description |
| :-----------------------------: | :---------- |
| `dp_compute`   | To compute the predictability for historical prediction of a date (eg. go live date, deal closure date) |
| `dp_persist` | To persist into an excel file the outputs from the command `dp_compute` |
| `dp_load` | To load the outputs from the command `dp_compute` that were persisted into an excel file |
| `dp_graph` | To visualize the outputs from the command `dp_compute` into a graph powered by [dash](https://dash.plotly.com) |
| `dp_demo` | To demonstrate some of the above command |

---

# The technicalities

## PyPi Versions

* 0.0.5: date predictability - workable version
* 0.0.15: with a revamped readme.md, and 'demo' command, before sharing with "early adopters"
* 0.0.20: dp-demo fixed
* 0.0.21: click commands to handle json, excel dashboard with vba, dash with bubbles
* 0.0.22: enriched wheel including assets and json files

## Dependencies

When installing `com-enovation`, the following packages will be deployed automatically by `pip`:
* `pandas`: to handle dataframes, series, etc
* `click`: to handle command line
* `enlighten`: to display a progress bar for lengthy steps
* `openpyxl`: to handle `xlsx` files
* `xlwt`: that is a dependency for `pandas.io.excel`
* `xlrd`: yet another dependency for `pandas.io.excel`
* `dash`: to graph
* `scipy`: to compute date predictability without resampling measures, using `special.psi` function
* `xlsxwriter`: to produce excel spreadsheet. Used in `excel_dashboard`
* `jsonschema`: to check json parameters. Used in `excel_dashboard`

## Install

* Check `Python 3` is installed on your machine
* Check `pip` is installed on your machine
* Install the `com-enovation` tool-box: `python3 -m pip install com-enovation`
  * You can test by launching a python interpreter: `python3`
  * And load the package: `>>> import com.enovation`
* Ensure the deployed script is added to your `PATH`
* Upgrade the `com-enovation` tool-box: `pip install --upgrade com-enovation`

## Use

* You can get help by executing `enov -- help` in a terminal
* You have commands that you can run like `enov load-csv --help`
* Commands have:
  * Parameters that you can provide like `enov load-csv ./the-csv-file-to-load.csv`
  * Options that you can provide like `enov load-csv ./the-csv-file-to-load.csv -c the-first-column-label-to-load -c the-second-one`
* You can call for more logs by calling `enov --verbose load-csv ./the-csv-file-to-load.csv -c the-first-column-label-to-load -c the-second-one`

## Contribute

### Generate and publish the distribution

* build the distribution files and directories: `python3 -m build`
  * Directories `build` and `dist` should be generated
  * In case you face an error `No module named build`, you need first to run `pip install build`
* publish to `pypi`: `python3 -m twine upload --repository pypi dist/*`
  * In case you face an error `No module named twine`, you need first to run `pip install twine`
  * Package viewable at [pypi](https://pypi.org/project/com-enovation)

* Commands to execute from the root directory `com.enovation`

### Pycharm configuration

* In the left pan:
  * Directory `src`: mark as `Sources Root`
  * Directory `tests`: DO NOT mark as anything...

* Unit test configuration, from menu `Run > Edit Configurations...`
  * `Configuration > Target > Script path: /Users/jsg/PycharmProjects/com.enovation/tests`
  * `Configuration > Working directory: /Users/jsg/PycharmProjects/com.enovation/`
  * `Configuration > Add content roots to PYTHONPATH: checked`
  * `Configuration > Add source roots to PYTHONPATH: checked`

### Python stuff

* Check we have latest versions:
  * pip: `python3 -m pip install --upgrade pip`
  * build to generate the distribution: `python3 -m pip install --upgrade build`
  * twine to publish to pypi: `python3 -m pip install --upgrade twine`

* Update packages using pip
  * Check all packages are fine: `pip check`
  * List all packages outdated: `pip list --outdated`
  * Update all packages outdated: `pip list --outdated --format=freeze | grep -v '^\-e' | cut -d = -f 1  | xargs -n1 pip install -U`
* A simple example package. You can use [Github-flavored Markdown](https://guides.github.com/features/mastering-markdown/) to write your content.

* To debug a running Click application: