# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['moabb',
 'moabb.analysis',
 'moabb.datasets',
 'moabb.evaluations',
 'moabb.paradigms',
 'moabb.pipelines',
 'moabb.tests']

package_data = \
{'': ['*'], 'moabb.tests': ['test_pipelines/*']}

install_requires = \
['PyYAML>=5.0.0,<6.0.0',
 'h5py>=3.0.0,<4.0.0',
 'matplotlib>=3.0.0,<4.0.0',
 'mne>=0.19',
 'numpy>=1.19.0,<2.0.0',
 'pandas>=1.0.0,<2.0.0',
 'patool>=1.12,<2.0',
 'pyriemann>=0.2.6',
 'pyunpack>=0.2.2,<0.3.0',
 'scikit-learn>=0.23,<0.24',
 'scipy>=1.5,<2.0',
 'seaborn>=0.9.0',
 'wfdb>=3.3.0,<4.0.0']

setup_kwargs = {
    'name': 'moabb',
    'version': '0.3.0',
    'description': 'Mother of All BCI Benchmarks',
    'long_description': '# Mother of all BCI Benchmarks\n\n<p align=center>\n  <img alt="banner" src="/images/M.png/">\n</p>\n<p align=center>\n  Build a comprehensive benchmark of popular BCI algorithms applied on an extensive list of freely available EEG datasets.\n</p>\n\n## Disclaimer\n\n**This is an open science project that may evolve depending on the need of the\ncommunity.**\n\n[![Build Status](https://github.com/NeuroTechX/moabb/workflows/Test/badge.svg)](https://github.com/NeuroTechX/moabb/actions?query=branch%3Amaster)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n## Welcome!\n\nFirst and foremost, Welcome! :tada: Willkommen! :confetti_ball: Bienvenue!\n:balloon::balloon::balloon:\n\nThank you for visiting the Mother of all BCI Benchmark repository.\n\nThis document is a hub to give you some information about the project. Jump straight to\none of the sections below, or just scroll down to find out more.\n\n- [What are we doing? (And why?)](#what-are-we-doing)\n- [Who are we?](#who-are-we)\n- [Get in touch](#contact-us)\n- [Installation](#installation)\n- [Running](#running)\n- [Supported datasets](#supported-datasets)\n- [Documentation](#documentation)\n- [Architecture and main concepts](#architecture-and-main-concepts)\n- [Citing MOABB and related publications](#citing-moabb-and-related-publications)\n\n## What are we doing?\n\n### The problem\n\n- Reproducible Research in BCI has a long way to go.\n- While many BCI datasets are made freely available, researchers do not publish code, and\n  reproducing results required to benchmark new algorithms turns out to be more tricky\n  than it should be.\n- Performances can be significantly impacted by parameters of the preprocessing steps,\n  toolboxes used and implementation “tricks” that are almost never reported in the\n  literature.\n\nAs a results, there is no comprehensive benchmark of BCI algorithm, and newcomers are\nspending a tremendous amount of time browsing literature to find out what algorithm works\nbest and on which dataset.\n\n### The solution\n\nThe Mother of all BCI Benchmark allows to:\n\n- Build a comprehensive benchmark of popular BCI algorithms applied on an extensive list\n  of freely available EEG datasets.\n- The code will be made available on github, serving as a reference point for the future\n  algorithmic developments.\n- Algorithms can be ranked and promoted on a website, providing a clear picture of the\n  different solutions available in the field.\n\nThis project will be successful when we read in an abstract “ … the proposed method\nobtained a score of 89% on the MOABB (Mother of All BCI Benchmarks), outperforming the\nstate of the art by 5% ...”.\n\n## Who are we?\n\nThe founders of the Mother of all BCI Benchmarks are [Alexander Barachant][link_alex_b]\nand [Vinay Jayaram][link_vinay]. This project is under the umbrella of\n[NeuroTechX][link_neurotechx], the international community for NeuroTech enthusiasts. The\nproject is currently maintained by [Sylvain Chevallier][link_sylvain].\n\n### What do we need?\n\n**You**! In whatever way you can help.\n\nWe need expertise in programming, user experience, software sustainability, documentation\nand technical writing and project management.\n\nWe\'d love your feedback along the way.\n\nOur primary goal is to build a comprehensive benchmark of popular BCI algorithms applied\non an extensive list of freely available EEG datasets, and we\'re excited to support the\nprofessional development of any and all of our contributors. If you\'re looking to learn to\ncode, try out working collaboratively, or translate you skills to the digital domain,\nwe\'re here to help.\n\n### Get involved\n\nIf you think you can help in any of the areas listed above (and we bet you can) or in any\nof the many areas that we haven\'t yet thought of (and here we\'re _sure_ you can) then\nplease check out our [contributors\' guidelines](CONTRIBUTING.md) and our\n[roadmap](ROADMAP.md).\n\nPlease note that it\'s very important to us that we maintain a positive and supportive\nenvironment for everyone who wants to participate. When you join us we ask that you follow\nour [code of conduct](CODE_OF_CONDUCT.md) in all interactions both on and offline.\n\n## Contact us\n\nIf you want to report a problem or suggest an enhancement we\'d love for you to\n[open an issue](../../issues) at this github repository because then we can get right on\nit.\n\nFor a less formal discussion or exchanging ideas, you can also reach us on the [Gitter\nchannel][link_gitter] or join our weekly office hours! This an open video meeting\nhappening every Thursday at [18:30 GMT+1](https://time.is/en/Paris), please ask the link\non the gitter channel. We are also on [NeuroTechX slack #moabb\nchannel][link_neurotechx_signup].\n\n## Thank you\n\nThank you so much (Danke schön! Merci beaucoup!) for visiting the project and we do hope\nthat you\'ll join us on this amazing journey to build a comprehensive benchmark of popular\nBCI algorithms applied on an extensive list of freely available EEG datasets.\n\n## Installation\n\nA PyPi package will be available soon. For now, you need to fork or clone the repository\nand go to the downloaded directory, then run:\n\n1. install `poetry` (only once per machine):\\\n   `curl -sSL https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python -`\\\n   or [checkout installation instruction](https://python-poetry.org/docs/#installation) or\n   use [conda forge version](https://anaconda.org/conda-forge/poetry)\n1. (Optional, skip if not sure) Disable automatical environment creation:\\\n   `poetry config virtualenvs.create false`\n1. install all dependencies in one command (have to be run in project directory):\\\n   `poetry install`\n\n### Requirements we use\n\nsee `pyproject.toml` file for full list of dependencies\n\n## Running\n\n### Verify Installation\n\nTo ensure it is running correctly, you can also run\n\n```\npython -m unittest moabb.tests\n```\n\nonce it is installed.\n\n### Use MOABB\n\nFirst, you could take a look at our [tutorials](./tutorials), that cover the most\nimportant concepts and use cases. Also, we have a several [examples](./examples/)\navailable.\n\nYou might be interested in [MOABB documentation][link_moabb_docs]\n\n## Supported datasets\n\nThe list of supported dataset can be found here :\nhttp://moabb.neurotechx.com/docs/datasets.html\n\n### Submit a new dataset\n\nyou can submit new dataset by mentioning it to this\n[issue](https://github.com/NeuroTechX/moabb/issues/1). The datasets currently on our radar\ncan be seen [here] (https://github.com/NeuroTechX/moabb/wiki/Datasets-Support)\n\n## Architecture and main concepts\n\n<p align="center">\n  <img alt="banner" src="/images/architecture.png/" width="400">\n</p>\nthere are 4 main concepts in the MOABB: the datasets, the paradigm, the evaluation, and the pipelines. In addition, we offer statistical and visualization utilities to simplify the workflow.\n\n### Datasets\n\nA dataset handle and abstract low level access to the data. the dataset will takes data\nstored locally, in the format in which they have been downloaded, and will convert them\ninto a MNE raw object. There are options to pool all the different recording sessions per\nsubject or to evaluate them separately.\n\n### Paradigm\n\nA paradigm defines how the raw data will be converted to trials ready to be processed by a\ndecoding algorithm. This is a function of the paradigm used, i.e. in motor imagery one can\nhave two-class, multi-class, or continuous paradigms; similarly, different preprocessing\nis necessary for ERP vs ERD paradigms.\n\n### Evaluations\n\nAn evaluation defines how we go from trials per subject and session to a generalization\nstatistic (AUC score, f-score, accuracy, etc) -- it can be either within-recording-session\naccuracy, across-session within-subject accuracy, across-subject accuracy, or other\ntransfer learning settings.\n\n### Pipelines\n\nPipeline defines all steps required by an algorithm to obtain predictions. Pipelines are\ntypically a chain of sklearn compatible transformers and end with an sklearn compatible\nestimator. See\n[Pipelines](http://scikit-learn.org/stable/modules/generated/sklearn.pipeline.Pipeline.html)\nfor more info.\n\n### Statistics and visualization\n\nOnce an evaluation has been run, the raw results are returned as a DataFrame. This can be\nfurther processed via the following commands to generate some basic visualization and\nstatistical comparisons:\n\n```\nfrom moabb.analysis import analyze\n\nresults = evaluation.process(pipeline_dict)\nanalyze(results)\n```\n\n## Citing MOABB and related publications\n\nTo cite MOABB, you could use the following paper:\n\n> Vinay Jayaram and Alexandre Barachant.\n> ["MOABB: trustworthy algorithm benchmarking for BCIs."](http://iopscience.iop.org/article/10.1088/1741-2552/aadea0/meta)\n> Journal of neural engineering 15.6 (2018): 066011.\n> [DOI](https://doi.org/10.1088/1741-2552/aadea0)\n\nIf you publish a paper using MOABB, please contact us on [gitter][link_gitter] or open an\nissue, and we will add you paper to the\n[dedicated wiki page](https://github.com/NeuroTechX/moabb/wiki/MOABB-bibliography).\n\n[link_alex_b]: http://alexandre.barachant.org/\n[link_vinay]: https://ei.is.tuebingen.mpg.de/~vjayaram\n[link_neurotechx]: http://neurotechx.com/\n[link_sylvain]: https://sylvchev.github.io/\n[link_neurotechx_signup]:\n  https://docs.google.com/forms/d/e/1FAIpQLSfZyzhVdOLU8_oQ4NylHL8EFoKLIVmryGXA4u7HDsZpkTryvg/viewform\n[link_gitter]: https://gitter.im/moabb_dev/community\n[link_moabb_docs]: http://moabb.neurotechx.com/docs/index.html\n[link_arxiv]: https://arxiv.org/abs/1805.06427\n[link_jne]: http://iopscience.iop.org/article/10.1088/1741-2552/aadea0/meta\n',
    'author': 'Alexandre Barachant',
    'author_email': None,
    'maintainer': 'Sylvain Chevallier',
    'maintainer_email': 'sylvain.chevallier@uvsq.fr',
    'url': 'https://github.com/NeuroTechX/moabb',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
