"""
    Cisco SD-WAN vManage API

    The vManage API exposes the functionality of operations maintaining devices and the overlay network  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: vmanage@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)


class RealTimeMonitoringInterfaceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.generate_device_interface_vpn_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/vpn',
                'operation_id': 'generate_device_interface_vpn',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface',
                'operation_id': 'get_device_interface',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_arp_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/arp_stats',
                'operation_id': 'get_device_interface_arp_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_error_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/error_stats',
                'operation_id': 'get_device_interface_error_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_ipv6_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/ipv6Stats',
                'operation_id': 'get_device_interface_ipv6_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_pkt_sizes_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/pkt_size',
                'operation_id': 'get_device_interface_pkt_sizes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_port_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/port_stats',
                'operation_id': 'get_device_interface_port_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_qos_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/qosStats',
                'operation_id': 'get_device_interface_qos_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_queue_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/queue_stats',
                'operation_id': 'get_device_interface_queue_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_interface_stats_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/stats',
                'operation_id': 'get_device_interface_stats',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_device_serial_interface_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/serial',
                'operation_id': 'get_device_serial_interface',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_synced_device_interface_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/synced',
                'operation_id': 'get_synced_device_interface',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'af_type',
                    'device_id',
                    'vpn_id',
                    'ifname',
                ],
                'required': [
                    'af_type',
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'af_type',
                    'ifname',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('af_type',): {

                        "IPV4": "ipv4",
                        "IPV6": "ipv6"
                    },
                    ('ifname',): {

                        "GE0/0": "ge0/0",
                        "GE0/1": "ge0/1",
                        "GE0/2": "ge0/2",
                        "GE0/3": "ge0/3",
                        "GE0/4": "ge0/4",
                        "GE0/5": "ge0/5",
                        "GE0/6": "ge0/6",
                        "GE0/7": "ge0/7",
                        "SYSTEM": "system",
                        "ETH0": "eth0"
                    },
                },
                'openapi_types': {
                    'af_type':
                        (str,),
                    'device_id':
                        (str,),
                    'vpn_id':
                        (str,),
                    'ifname':
                        (str,),
                },
                'attribute_map': {
                    'af_type': 'af-type',
                    'device_id': 'deviceId',
                    'vpn_id': 'vpn-id',
                    'ifname': 'ifname',
                },
                'location_map': {
                    'af_type': 'query',
                    'device_id': 'query',
                    'vpn_id': 'query',
                    'ifname': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.trustsec_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/device/interface/trustsec',
                'operation_id': 'trustsec',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'device_id',
                ],
                'required': [
                    'device_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'device_id':
                        (str,),
                },
                'attribute_map': {
                    'device_id': 'deviceId',
                },
                'location_map': {
                    'device_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def generate_device_interface_vpn(
        self,
        device_id,
        **kwargs
    ):
        """generate_device_interface_vpn  # noqa: E501

        Get device interfaces per VPN  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.generate_device_interface_vpn(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.generate_device_interface_vpn_endpoint.call_with_http_info(**kwargs)

    def get_device_interface(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface  # noqa: E501

        Get device interfaces  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_arp_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_arp_stats  # noqa: E501

        Get interface ARP statistics  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_arp_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_arp_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_error_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_error_stats  # noqa: E501

        Get interface error stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_error_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_error_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_ipv6_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_ipv6_stats  # noqa: E501

        Get interface IPv6 stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_ipv6_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_ipv6_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_pkt_sizes(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_pkt_sizes  # noqa: E501

        Get interface packet size  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_pkt_sizes(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_pkt_sizes_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_port_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_port_stats  # noqa: E501

        Get interface port stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_port_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_port_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_qos_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_qos_stats  # noqa: E501

        Get interface QOS stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_qos_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_qos_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_queue_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_queue_stats  # noqa: E501

        Get interface queue stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_queue_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_queue_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_interface_stats(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_interface_stats  # noqa: E501

        Get interface stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_interface_stats(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_interface_stats_endpoint.call_with_http_info(**kwargs)

    def get_device_serial_interface(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_device_serial_interface  # noqa: E501

        Get serial interface  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_device_serial_interface(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_device_serial_interface_endpoint.call_with_http_info(**kwargs)

    def get_synced_device_interface(
        self,
        af_type,
        device_id,
        **kwargs
    ):
        """get_synced_device_interface  # noqa: E501

        Get device interfaces synchronously  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_synced_device_interface(af_type, device_id, async_req=True)
        >>> result = thread.get()

        Args:
            af_type (str): AF Type
            device_id (str): Device Id

        Keyword Args:
            vpn_id (str): VPN Id. [optional]
            ifname (str): IF Name. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['af_type'] = \
            af_type
        kwargs['device_id'] = \
            device_id
        return self.get_synced_device_interface_endpoint.call_with_http_info(**kwargs)

    def trustsec(
        self,
        device_id,
        **kwargs
    ):
        """trustsec  # noqa: E501

        Get policy filter memory usage from device  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.trustsec(device_id, async_req=True)
        >>> result = thread.get()

        Args:
            device_id (str): Device Id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['device_id'] = \
            device_id
        return self.trustsec_endpoint.call_with_http_info(**kwargs)

