# openapi_client.ConfigurationFeatureProfileMobilityApi

All URIs are relative to *https://1.1.1.1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_basic_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_basic_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/basic | 
[**create_cellular_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_cellular_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/cellular | 
[**create_ethernet_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_ethernet_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/ethernet | 
[**create_mobility_config_profile_parcel_for_cli**](ConfigurationFeatureProfileMobilityApi.md#create_mobility_config_profile_parcel_for_cli) | **POST** /v1/feature-profile/mobility/cli/{cliId}/config | 
[**create_network_protocol_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_network_protocol_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/networkProtocol | 
[**create_security_policy_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_security_policy_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/securityPolicy | 
[**create_vpn_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_vpn_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/vpn | 
[**create_wifi_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#create_wifi_profile_parcel_for_mobility) | **POST** /v1/feature-profile/mobility/global/{profileId}/wifi | 
[**delete_a_cellular_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_a_cellular_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
[**delete_a_vpn_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_a_vpn_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
[**delete_basic_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_basic_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
[**delete_ethernet_profile_parcel_for_system**](ConfigurationFeatureProfileMobilityApi.md#delete_ethernet_profile_parcel_for_system) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
[**delete_mobility_config_profile_parcel_for_cli**](ConfigurationFeatureProfileMobilityApi.md#delete_mobility_config_profile_parcel_for_cli) | **DELETE** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
[**delete_network_protocol_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_network_protocol_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
[**delete_security_policy_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_security_policy_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
[**delete_wifi_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#delete_wifi_profile_parcel_for_mobility) | **DELETE** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
[**edit_basic_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_basic_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
[**edit_cellular_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_cellular_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
[**edit_ethernet_profile_parcel_for_system**](ConfigurationFeatureProfileMobilityApi.md#edit_ethernet_profile_parcel_for_system) | **PUT** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
[**edit_mobility_config_profile_parcel_for_cli**](ConfigurationFeatureProfileMobilityApi.md#edit_mobility_config_profile_parcel_for_cli) | **PUT** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
[**edit_network_protocol_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_network_protocol_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
[**edit_security_policy_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_security_policy_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
[**edit_vpn_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_vpn_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
[**edit_wifi_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#edit_wifi_profile_parcel_for_mobility) | **PUT** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
[**get_basic_profile_parcel_by_parcel_id_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_basic_profile_parcel_by_parcel_id_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/basic/{parcelId} | 
[**get_basic_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_basic_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/basic | 
[**get_cellular_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_cellular_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/cellular/{cellularId} | 
[**get_cellular_profile_parcel_list_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_cellular_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/cellular | 
[**get_ethernet_profile_parcel**](ConfigurationFeatureProfileMobilityApi.md#get_ethernet_profile_parcel) | **GET** /v1/feature-profile/mobility/global/{profileId}/ethernet/{ethernetId} | 
[**get_ethernet_profile_parcels**](ConfigurationFeatureProfileMobilityApi.md#get_ethernet_profile_parcels) | **GET** /v1/feature-profile/mobility/global/{profileId}/ethernet | 
[**get_mobility_config_profile_parcel_by_parcel_id_for_cli**](ConfigurationFeatureProfileMobilityApi.md#get_mobility_config_profile_parcel_by_parcel_id_for_cli) | **GET** /v1/feature-profile/mobility/cli/{cliId}/config/{configId} | 
[**get_mobility_config_profile_parcel_for_cli**](ConfigurationFeatureProfileMobilityApi.md#get_mobility_config_profile_parcel_for_cli) | **GET** /v1/feature-profile/mobility/cli/{cliId}/config | 
[**get_mobility_feature_profile_by_global_id**](ConfigurationFeatureProfileMobilityApi.md#get_mobility_feature_profile_by_global_id) | **GET** /v1/feature-profile/mobility/global/{profileId} | 
[**get_mobility_global_basic_parcel_schema_by_schema_type**](ConfigurationFeatureProfileMobilityApi.md#get_mobility_global_basic_parcel_schema_by_schema_type) | **GET** /v1/feature-profile/mobility/global/basic/schema | 
[**get_network_protocol_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_network_protocol_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/networkProtocol/{networkProtocolId} | 
[**get_network_protocol_profile_parcel_list_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_network_protocol_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/networkProtocol | 
[**get_security_policy_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_security_policy_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/securityPolicy/{securityPolicyId} | 
[**get_security_policy_profile_parcel_list_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_security_policy_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/securityPolicy | 
[**get_vpn_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_vpn_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/vpn/{vpnId} | 
[**get_vpn_profile_parcel_list_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_vpn_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/vpn | 
[**get_wifi_profile_parcel_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_wifi_profile_parcel_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/wifi/{wifiId} | 
[**get_wifi_profile_parcel_list_for_mobility**](ConfigurationFeatureProfileMobilityApi.md#get_wifi_profile_parcel_list_for_mobility) | **GET** /v1/feature-profile/mobility/global/{profileId}/wifi | 


# **create_basic_profile_parcel_for_mobility**
> str create_basic_profile_parcel_for_mobility(profile_id)



Create a Basic Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    body = "TODO" # str | Basic Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_basic_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_basic_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_basic_profile_parcel_for_mobility(profile_id, body=body)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_basic_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **body** | **str**| Basic Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_cellular_profile_parcel_for_mobility**
> str create_cellular_profile_parcel_for_mobility(profile_id)



Create an cellular Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.cellular_profile import CellularProfile
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    cellular_profile = CellularProfile(
        apn="apn_example",
        auth_method="chap",
        id=1,
        password="password_example",
        pdn_type="IPv4v6",
        user_name="user_name_example",
    ) # CellularProfile | Cellular Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_cellular_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_cellular_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_cellular_profile_parcel_for_mobility(profile_id, cellular_profile=cellular_profile)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_cellular_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **cellular_profile** | [**CellularProfile**](CellularProfile.md)| Cellular Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_ethernet_profile_parcel_for_mobility**
> str create_ethernet_profile_parcel_for_mobility(profile_id)



Create an ethernet Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.ethernet import Ethernet
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    ethernet = Ethernet() # Ethernet | Ethernet Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_ethernet_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_ethernet_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_ethernet_profile_parcel_for_mobility(profile_id, ethernet=ethernet)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_ethernet_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **ethernet** | [**Ethernet**](Ethernet.md)| Ethernet Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_mobility_config_profile_parcel_for_cli**
> str create_mobility_config_profile_parcel_for_cli(cli_id)



Create a config Profile Parcel for cli feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    cli_id = "cliId_example" # str | Feature Profile ID
    body = "refer to schema for documentation and example" # str | cli config Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_mobility_config_profile_parcel_for_cli(cli_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_mobility_config_profile_parcel_for_cli: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_mobility_config_profile_parcel_for_cli(cli_id, body=body)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_mobility_config_profile_parcel_for_cli: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cli_id** | **str**| Feature Profile ID |
 **body** | **str**| cli config Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_network_protocol_profile_parcel_for_mobility**
> str create_network_protocol_profile_parcel_for_mobility(profile_id)



Create an NetworkProtocol Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.network_protocol import NetworkProtocol
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    network_protocol = NetworkProtocol() # NetworkProtocol | NetworkProtocol Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_network_protocol_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_network_protocol_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol=network_protocol)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_network_protocol_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **network_protocol** | [**NetworkProtocol**](NetworkProtocol.md)| NetworkProtocol Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_security_policy_profile_parcel_for_mobility**
> str create_security_policy_profile_parcel_for_mobility(profile_id)



Create an SecurityPolicy Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.security_policy import SecurityPolicy
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    security_policy = SecurityPolicy() # SecurityPolicy | SecurityPolicy Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_security_policy_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_security_policy_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_security_policy_profile_parcel_for_mobility(profile_id, security_policy=security_policy)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_security_policy_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **security_policy** | [**SecurityPolicy**](SecurityPolicy.md)| SecurityPolicy Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_vpn_profile_parcel_for_mobility**
> str create_vpn_profile_parcel_for_mobility(profile_id)



Create an Vpn Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.vpn import Vpn
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    vpn = Vpn() # Vpn | Vpn Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_vpn_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_vpn_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_vpn_profile_parcel_for_mobility(profile_id, vpn=vpn)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_vpn_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **vpn** | [**Vpn**](Vpn.md)| Vpn Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_wifi_profile_parcel_for_mobility**
> str create_wifi_profile_parcel_for_mobility(profile_id)



Create an Wifi Profile Parcel for Mobility feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.wifi import Wifi
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    wifi = Wifi() # Wifi | Wifi Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.create_wifi_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_wifi_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.create_wifi_profile_parcel_for_mobility(profile_id, wifi=wifi)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->create_wifi_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **wifi** | [**Wifi**](Wifi.md)| Wifi Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_a_cellular_profile_parcel_for_mobility**
> delete_a_cellular_profile_parcel_for_mobility(profile_id, cellular_id)



Delete a Cellular Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    cellular_id = "cellularId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_a_cellular_profile_parcel_for_mobility(profile_id, cellular_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_a_cellular_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **cellular_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_a_vpn_profile_parcel_for_mobility**
> delete_a_vpn_profile_parcel_for_mobility(profile_id, vpn_id)



Delete a Vpn Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    vpn_id = "vpnId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_a_vpn_profile_parcel_for_mobility(profile_id, vpn_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_a_vpn_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **vpn_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_basic_profile_parcel_for_mobility**
> delete_basic_profile_parcel_for_mobility(profile_id, parcel_id)



Delete a Basic Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    parcel_id = "parcelId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_basic_profile_parcel_for_mobility(profile_id, parcel_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_basic_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **parcel_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_ethernet_profile_parcel_for_system**
> delete_ethernet_profile_parcel_for_system(profile_id, ethernet_id)



Delete a Ethernet Profile Parcel for feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    ethernet_id = "ethernetId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_ethernet_profile_parcel_for_system(profile_id, ethernet_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_ethernet_profile_parcel_for_system: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **ethernet_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_mobility_config_profile_parcel_for_cli**
> delete_mobility_config_profile_parcel_for_cli(cli_id, config_id)



Delete a config Profile Parcel for cli feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    cli_id = "cliId_example" # str | Feature Profile ID
    config_id = "configId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_mobility_config_profile_parcel_for_cli(cli_id, config_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_mobility_config_profile_parcel_for_cli: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cli_id** | **str**| Feature Profile ID |
 **config_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_network_protocol_profile_parcel_for_mobility**
> delete_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)



Delete a Network Protocol Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    network_protocol_id = "networkProtocolId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_network_protocol_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **network_protocol_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_security_policy_profile_parcel_for_mobility**
> delete_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)



Delete a Security Policy Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    security_policy_id = "securityPolicyId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_security_policy_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **security_policy_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_wifi_profile_parcel_for_mobility**
> delete_wifi_profile_parcel_for_mobility(profile_id, wifi_id)



Delete an Wifi Profile Parcel for Mobility feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    wifi_id = "wifiId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_instance.delete_wifi_profile_parcel_for_mobility(profile_id, wifi_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->delete_wifi_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **wifi_id** | **str**| Profile Parcel ID |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_basic_profile_parcel_for_mobility**
> str edit_basic_profile_parcel_for_mobility(profile_id, parcel_id)



Update a Basic Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    parcel_id = "parcelId_example" # str | Profile Parcel ID
    body = "TODO" # str | Basic Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.edit_basic_profile_parcel_for_mobility(profile_id, parcel_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_basic_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.edit_basic_profile_parcel_for_mobility(profile_id, parcel_id, body=body)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_basic_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **parcel_id** | **str**| Profile Parcel ID |
 **body** | **str**| Basic Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_cellular_profile_parcel_for_mobility**
> edit_cellular_profile_parcel_for_mobility(profile_id, cellular_id)



Edit an Cellular Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.cellular import Cellular
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    cellular_id = "cellularId_example" # str | Profile Parcel ID
    cellular = Cellular() # Cellular | Cellular Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_cellular_profile_parcel_for_mobility(profile_id, cellular_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_cellular_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_cellular_profile_parcel_for_mobility(profile_id, cellular_id, cellular=cellular)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_cellular_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **cellular_id** | **str**| Profile Parcel ID |
 **cellular** | [**Cellular**](Cellular.md)| Cellular Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_ethernet_profile_parcel_for_system**
> edit_ethernet_profile_parcel_for_system(profile_id, ethernet_id)



Update a Ethernet Profile Parcel for feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    ethernet_id = "ethernetId_example" # str | Profile Parcel ID
    body = "{"type":"ethernet","ethernetInterfaceList":[{"interfaceName":"GigabitEthernet0/0","wanConfiguration":"Active","portType":"WAN","ipAssignment":"static","staticIpAddress":"1.1.1.2","staticIpAddressSubnetMask":"255.255.0.0","staticRouteIp":"3.3.3.3"},{"interfaceName":"GigabitEthernet0/1","adminState":"enabled"},{"interfaceName":"GigabitEthernet0/2","adminState":"disabled"}]}" # str | Ethernet Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_ethernet_profile_parcel_for_system(profile_id, ethernet_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_ethernet_profile_parcel_for_system: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_ethernet_profile_parcel_for_system(profile_id, ethernet_id, body=body)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_ethernet_profile_parcel_for_system: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **ethernet_id** | **str**| Profile Parcel ID |
 **body** | **str**| Ethernet Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_mobility_config_profile_parcel_for_cli**
> str edit_mobility_config_profile_parcel_for_cli(cli_id, config_id)



Update a config Profile Parcel for cli feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    cli_id = "cliId_example" # str | Feature Profile ID
    config_id = "configId_example" # str | Profile Parcel ID
    body = "refer to schema for documentation and example" # str | cli config Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.edit_mobility_config_profile_parcel_for_cli(cli_id, config_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_mobility_config_profile_parcel_for_cli: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_response = api_instance.edit_mobility_config_profile_parcel_for_cli(cli_id, config_id, body=body)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_mobility_config_profile_parcel_for_cli: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cli_id** | **str**| Feature Profile ID |
 **config_id** | **str**| Profile Parcel ID |
 **body** | **str**| cli config Profile Parcel | [optional]

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_network_protocol_profile_parcel_for_mobility**
> edit_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)



Edit an Network Protocol Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.network_protocol import NetworkProtocol
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    network_protocol_id = "networkProtocolId_example" # str | Profile Parcel ID
    network_protocol = NetworkProtocol() # NetworkProtocol | Network Protocol Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_network_protocol_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id, network_protocol=network_protocol)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_network_protocol_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **network_protocol_id** | **str**| Profile Parcel ID |
 **network_protocol** | [**NetworkProtocol**](NetworkProtocol.md)| Network Protocol Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_security_policy_profile_parcel_for_mobility**
> edit_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)



Edit an Security Policy Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.security_policy import SecurityPolicy
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    security_policy_id = "securityPolicyId_example" # str | Profile Parcel ID
    security_policy = SecurityPolicy() # SecurityPolicy | Security Policy Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_security_policy_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id, security_policy=security_policy)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_security_policy_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **security_policy_id** | **str**| Profile Parcel ID |
 **security_policy** | [**SecurityPolicy**](SecurityPolicy.md)| Security Policy Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_vpn_profile_parcel_for_mobility**
> edit_vpn_profile_parcel_for_mobility(profile_id, vpn_id)



Edit an Vpn Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.vpn import Vpn
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    vpn_id = "vpnId_example" # str | Profile Parcel ID
    vpn = Vpn() # Vpn | Vpn Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_vpn_profile_parcel_for_mobility(profile_id, vpn_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_vpn_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_vpn_profile_parcel_for_mobility(profile_id, vpn_id, vpn=vpn)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_vpn_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **vpn_id** | **str**| Profile Parcel ID |
 **vpn** | [**Vpn**](Vpn.md)| Vpn Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **edit_wifi_profile_parcel_for_mobility**
> edit_wifi_profile_parcel_for_mobility(profile_id, wifi_id)



Edit an Wifi Profile Parcel for Mobility feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from openapi_client.model.wifi import Wifi
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    wifi_id = "wifiId_example" # str | Profile Parcel ID
    wifi = Wifi() # Wifi | Wifi Profile Parcel (optional)

    # example passing only required values which don't have defaults set
    try:
        api_instance.edit_wifi_profile_parcel_for_mobility(profile_id, wifi_id)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_wifi_profile_parcel_for_mobility: %s\n" % e)

    # example passing only required values which don't have defaults set
    # and optional values
    try:
        api_instance.edit_wifi_profile_parcel_for_mobility(profile_id, wifi_id, wifi=wifi)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->edit_wifi_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **wifi_id** | **str**| Profile Parcel ID |
 **wifi** | [**Wifi**](Wifi.md)| Wifi Profile Parcel | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_basic_profile_parcel_by_parcel_id_for_mobility**
> str get_basic_profile_parcel_by_parcel_id_for_mobility(profile_id, parcel_id)



Get Basic Profile Parcel by parcelId for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    parcel_id = "parcelId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_basic_profile_parcel_by_parcel_id_for_mobility(profile_id, parcel_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_basic_profile_parcel_by_parcel_id_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **parcel_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_basic_profile_parcel_for_mobility**
> str get_basic_profile_parcel_for_mobility(profile_id)



Get Basic Profile Parcels for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_basic_profile_parcel_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_basic_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_cellular_profile_parcel_for_mobility**
> str get_cellular_profile_parcel_for_mobility(profile_id, cellular_id)



Get an Mobility Cellular Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    cellular_id = "cellularId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_cellular_profile_parcel_for_mobility(profile_id, cellular_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_cellular_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **cellular_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_cellular_profile_parcel_list_for_mobility**
> str get_cellular_profile_parcel_list_for_mobility(profile_id)



Get an Mobility Cellular Profile Parcel list for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_cellular_profile_parcel_list_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_cellular_profile_parcel_list_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_ethernet_profile_parcel**
> str get_ethernet_profile_parcel(profile_id, ethernet_id)



Get Ethernet Profile Parcels for feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    ethernet_id = "ethernetId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_ethernet_profile_parcel(profile_id, ethernet_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_ethernet_profile_parcel: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **ethernet_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_ethernet_profile_parcels**
> str get_ethernet_profile_parcels(profile_id)



Get Ethernet Profile Parcels for feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_ethernet_profile_parcels(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_ethernet_profile_parcels: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_mobility_config_profile_parcel_by_parcel_id_for_cli**
> str get_mobility_config_profile_parcel_by_parcel_id_for_cli(cli_id, config_id)



Get config Profile Parcel by configId for cli feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    cli_id = "cliId_example" # str | Feature Profile ID
    config_id = "configId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_mobility_config_profile_parcel_by_parcel_id_for_cli(cli_id, config_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_mobility_config_profile_parcel_by_parcel_id_for_cli: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cli_id** | **str**| Feature Profile ID |
 **config_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_mobility_config_profile_parcel_for_cli**
> str get_mobility_config_profile_parcel_for_cli(cli_id)



Get config Profile Parcels for cli feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    cli_id = "cliId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_mobility_config_profile_parcel_for_cli(cli_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_mobility_config_profile_parcel_for_cli: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cli_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_mobility_feature_profile_by_global_id**
> {str: (bool, date, datetime, dict, float, int, list, str, none_type)} get_mobility_feature_profile_by_global_id(profile_id)



Get a Mobility Global Feature Profile by profileId

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile Id

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_mobility_feature_profile_by_global_id(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_mobility_feature_profile_by_global_id: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile Id |

### Return type

**{str: (bool, date, datetime, dict, float, int, list, str, none_type)}**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_mobility_global_basic_parcel_schema_by_schema_type**
> str get_mobility_global_basic_parcel_schema_by_schema_type(schema_type)



Get a Mobility Global Basic Parcel Schema by Schema Type

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    schema_type = "post" # str | 

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_mobility_global_basic_parcel_schema_by_schema_type(schema_type)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_mobility_global_basic_parcel_schema_by_schema_type: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **schema_type** | **str**|  |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_network_protocol_profile_parcel_for_mobility**
> str get_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)



Get an Mobility NetworkProtocol Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    network_protocol_id = "networkProtocolId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_network_protocol_profile_parcel_for_mobility(profile_id, network_protocol_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_network_protocol_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **network_protocol_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_network_protocol_profile_parcel_list_for_mobility**
> str get_network_protocol_profile_parcel_list_for_mobility(profile_id)



Get an Mobility NetworkProtocol Profile Parcel list for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_network_protocol_profile_parcel_list_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_network_protocol_profile_parcel_list_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_security_policy_profile_parcel_for_mobility**
> str get_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)



Get an Mobility SecurityPolicy Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    security_policy_id = "securityPolicyId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_security_policy_profile_parcel_for_mobility(profile_id, security_policy_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_security_policy_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **security_policy_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_security_policy_profile_parcel_list_for_mobility**
> str get_security_policy_profile_parcel_list_for_mobility(profile_id)



Get an Mobility SecurityPolicy Profile Parcel list for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_security_policy_profile_parcel_list_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_security_policy_profile_parcel_list_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_vpn_profile_parcel_for_mobility**
> str get_vpn_profile_parcel_for_mobility(profile_id, vpn_id)



Get an Mobility Vpn Profile Parcel for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    vpn_id = "vpnId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_vpn_profile_parcel_for_mobility(profile_id, vpn_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_vpn_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **vpn_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_vpn_profile_parcel_list_for_mobility**
> str get_vpn_profile_parcel_list_for_mobility(profile_id)



Get an Mobility Vpn Profile Parcel list for Mobility Global Feature Profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_vpn_profile_parcel_list_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_vpn_profile_parcel_list_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_wifi_profile_parcel_for_mobility**
> str get_wifi_profile_parcel_for_mobility(profile_id, wifi_id)



Get an Wifi Profile Parcel for Mobility feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID
    wifi_id = "wifiId_example" # str | Profile Parcel ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_wifi_profile_parcel_for_mobility(profile_id, wifi_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_wifi_profile_parcel_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |
 **wifi_id** | **str**| Profile Parcel ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_wifi_profile_parcel_list_for_mobility**
> str get_wifi_profile_parcel_list_for_mobility(profile_id)



Get Wifi Profile Parcel List for Mobility feature profile

### Example


```python
import time
import openapi_client
from openapi_client.api import configuration_feature_profile_mobility_api
from pprint import pprint
# Defining the host is optional and defaults to https://1.1.1.1
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://1.1.1.1"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient() as api_client:
    # Create an instance of the API class
    api_instance = configuration_feature_profile_mobility_api.ConfigurationFeatureProfileMobilityApi(api_client)
    profile_id = "profileId_example" # str | Feature Profile ID

    # example passing only required values which don't have defaults set
    try:
        api_response = api_instance.get_wifi_profile_parcel_list_for_mobility(profile_id)
        pprint(api_response)
    except openapi_client.ApiException as e:
        print("Exception when calling ConfigurationFeatureProfileMobilityApi->get_wifi_profile_parcel_list_for_mobility: %s\n" % e)
```


### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **profile_id** | **str**| Feature Profile ID |

### Return type

**str**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Success |  -  |
**400** | Bad Request |  -  |
**403** | Forbidden |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

