# Generated by Django 2.2.24 on 2021-08-31 15:47

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('notices', '0001_initial'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='historicalnotice',
            name='html_content',
        ),
        migrations.RemoveField(
            model_name='notice',
            name='html_content',
        ),
        migrations.CreateModel(
            name='HistoricalTranslatedNoticeContent',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('language_code', models.CharField(help_text='The IETF BCP 47 language code for this translation', max_length=10)),
                ('html_content', models.TextField(help_text='HTML content to be included in a notice prompt. Allowed tags include (a, b, em, i, span, strong)')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('notice', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='notices.Notice')),
            ],
            options={
                'verbose_name': 'historical translated notice content',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='TranslatedNoticeContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('language_code', models.CharField(help_text='The IETF BCP 47 language code for this translation', max_length=10)),
                ('html_content', models.TextField(help_text='HTML content to be included in a notice prompt. Allowed tags include (a, b, em, i, span, strong)')),
                ('notice', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='translated_notice_content', to='notices.Notice')),
            ],
            options={
                'unique_together': {('notice', 'language_code')},
            },
        ),
    ]
