"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeableMemoryMomiton = void 0;
const cdk = require("@aws-cdk/core");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// According to business needs
class FreeableMemoryMomiton {
    static setup(scope, cacheClusterId, nodeType) {
        const threshold = Math.round(nodeType.memory * 0.1);
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-FreeableMemory', {
            alarmName: `ElasticCacheFreeableMemoryAlarm[${cacheClusterId}]`,
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'FreeableMemory',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'min',
            }),
            threshold,
            period: cdk.Duration.minutes(1),
            evaluationPeriods: 1,
            alarmDescription: `The FreeableMemory value is less than ${(threshold / (1024 * 1024 * 1024)).toFixed(2)}Gb in one minute.`,
            comparisonOperator: cloudwatch.ComparisonOperator.LESS_THAN_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.FreeableMemoryMomiton = FreeableMemoryMomiton;
//# sourceMappingURL=data:application/json;base64,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