"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRouteIntegration = exports.WebSocketIntegration = exports.WebSocketIntegrationType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * WebSocket Integration Types
 */
var WebSocketIntegrationType;
(function (WebSocketIntegrationType) {
    WebSocketIntegrationType["AWS_PROXY"] = "AWS_PROXY";
})(WebSocketIntegrationType = exports.WebSocketIntegrationType || (exports.WebSocketIntegrationType = {}));
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
class WebSocketIntegration extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketIntegrationProps(props);
        const integ = new aws_apigatewayv2_1.CfnIntegration(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            integrationType: props.integrationType,
            integrationUri: props.integrationUri,
        });
        this.integrationId = integ.ref;
        this.webSocketApi = props.webSocketApi;
    }
}
exports.WebSocketIntegration = WebSocketIntegration;
_a = JSII_RTTI_SYMBOL_1;
WebSocketIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketIntegration", version: "2.6.0-alpha.0" };
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
class WebSocketRouteIntegration {
    /**
     * (experimental) Initialize an integration for a route on websocket api.
     *
     * @param id id of the underlying `WebSocketIntegration` construct.
     * @experimental
     */
    constructor(id) {
        this.id = id;
    }
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options) {
        if (this.integration && this.integration.webSocketApi.node.addr !== options.route.webSocketApi.node.addr) {
            throw new Error('A single integration cannot be associated with multiple APIs.');
        }
        if (!this.integration) {
            const config = this.bind(options);
            this.integration = new WebSocketIntegration(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                integrationType: config.type,
                integrationUri: config.uri,
            });
        }
        return { integrationId: this.integration.integrationId };
    }
}
exports.WebSocketRouteIntegration = WebSocketRouteIntegration;
_b = JSII_RTTI_SYMBOL_1;
WebSocketRouteIntegration[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRouteIntegration", version: "2.6.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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