import { Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IAuthorizer } from '../common';
import { IWebSocketApi } from './api';
import { IWebSocketRoute } from './route';
/**
 * Supported Authorizer types
 */
export declare enum WebSocketAuthorizerType {
    /**
     * (experimental) Supported Authorizer types.
     *
     * @experimental
     */
    LAMBDA = "REQUEST"
}
/**
 * (experimental) Properties to initialize an instance of `WebSocketAuthorizer`.
 *
 * @experimental
 */
export interface WebSocketAuthorizerProps {
    /**
     * (experimental) Name of the authorizer.
     *
     * @default - id of the WebSocketAuthorizer construct.
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) WebSocket Api to attach the authorizer to.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) The type of authorizer.
     *
     * @experimental
     */
    readonly type: WebSocketAuthorizerType;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     * @experimental
     */
    readonly identitySource: string[];
    /**
     * (experimental) The authorizer's Uniform Resource Identifier (URI).
     *
     * For REQUEST authorizers, this must be a well-formed Lambda function URI.
     *
     * @default - required for Request authorizer types
     * @experimental
     */
    readonly authorizerUri?: string;
}
/**
 * (experimental) An authorizer for WebSocket APIs.
 *
 * @experimental
 */
export interface IWebSocketAuthorizer extends IAuthorizer {
}
/**
 * (experimental) Reference to an WebSocket authorizer.
 *
 * @experimental
 */
export interface WebSocketAuthorizerAttributes {
    /**
     * (experimental) Id of the Authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * (experimental) Type of authorizer.
     *
     * Possible values are:
     * - CUSTOM - Lambda Authorizer
     * - NONE - No Authorization
     *
     * @experimental
     */
    readonly authorizerType: string;
}
/**
 * (experimental) An authorizer for WebSocket Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
export declare class WebSocketAuthorizer extends Resource implements IWebSocketAuthorizer {
    /**
     * (experimental) Import an existing WebSocket Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromWebSocketAuthorizerAttributes(scope: Construct, id: string, attrs: WebSocketAuthorizerAttributes): IWebSocketRouteAuthorizer;
    /**
     * (experimental) Id of the Authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WebSocketAuthorizerProps);
}
/**
 * (experimental) Input to the bind() operation, that binds an authorizer to a route.
 *
 * @experimental
 */
export interface WebSocketRouteAuthorizerBindOptions {
    /**
     * (experimental) The route to which the authorizer is being bound.
     *
     * @experimental
     */
    readonly route: IWebSocketRoute;
    /**
     * (experimental) The scope for any constructs created as part of the bind.
     *
     * @experimental
     */
    readonly scope: Construct;
}
/**
 * (experimental) Results of binding an authorizer to an WebSocket route.
 *
 * @experimental
 */
export interface WebSocketRouteAuthorizerConfig {
    /**
     * (experimental) The authorizer id.
     *
     * @default - No authorizer id (useful for AWS_IAM route authorizer)
     * @experimental
     */
    readonly authorizerId?: string;
    /**
     * (experimental) The type of authorization.
     *
     * Possible values are:
     * - CUSTOM - Lambda Authorizer
     * - NONE - No Authorization
     *
     * @experimental
     */
    readonly authorizationType: string;
}
/**
 * (experimental) An authorizer that can attach to an WebSocket Route.
 *
 * @experimental
 */
export interface IWebSocketRouteAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified WebSocket route.
     *
     * @experimental
     */
    bind(options: WebSocketRouteAuthorizerBindOptions): WebSocketRouteAuthorizerConfig;
}
/**
 * (experimental) Explicitly configure no authorizers on specific WebSocket API routes.
 *
 * @experimental
 */
export declare class WebSocketNoneAuthorizer implements IWebSocketRouteAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified WebSocket route.
     *
     * @experimental
     */
    bind(_: WebSocketRouteAuthorizerBindOptions): WebSocketRouteAuthorizerConfig;
}
