"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const route_1 = require("./route");
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketApiProps(props);
        this.webSocketApiName = (_b = props === null || props === void 0 ? void 0 : props.apiName) !== null && _b !== void 0 ? _b : id;
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            protocolType: 'WEBSOCKET',
            description: props === null || props === void 0 ? void 0 : props.description,
            routeSelectionExpression: (_c = props === null || props === void 0 ? void 0 : props.routeSelectionExpression) !== null && _c !== void 0 ? _c : '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props === null || props === void 0 ? void 0 : props.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props === null || props === void 0 ? void 0 : props.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey, options) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteOptions(options);
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantManageConnections(identity) {
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/POST/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketApi", version: "2.6.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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