"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported Authorizer types.
 *
 * @experimental
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    HttpAuthorizerType["IAM"] = "AWS_IAM";
    HttpAuthorizerType["JWT"] = "JWT";
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * (experimental) Payload format version for lambda authorizers.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 * @experimental
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * (experimental) An authorizer for Http Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerProps(props);
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation if this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: (_c = props.authorizerName) !== null && _c !== void 0 ? _c : id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: (_d = props.resultsCacheTtl) === null || _d === void 0 ? void 0 : _d.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpAuthorizerAttributes(attrs);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpAuthorizer = HttpAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer", version: "2.6.0-alpha.0" };
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 *
 * @experimental
 */
class HttpNoneAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(_) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpRouteAuthorizerBindOptions(_);
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer", version: "2.6.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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