import { Duration, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IAuthorizer } from '../common';
import { IHttpApi } from './api';
import { IHttpRoute } from './route';
/**
 * (experimental) Supported Authorizer types.
 *
 * @experimental
 */
export declare enum HttpAuthorizerType {
    /**
     * (experimental) IAM Authorizer.
     *
     * @experimental
     */
    IAM = "AWS_IAM",
    /**
     * (experimental) JSON Web Tokens.
     *
     * @experimental
     */
    JWT = "JWT",
    /**
     * (experimental) Lambda Authorizer.
     *
     * @experimental
     */
    LAMBDA = "REQUEST"
}
/**
 * (experimental) Payload format version for lambda authorizers.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 * @experimental
 */
export declare enum AuthorizerPayloadVersion {
    /**
     * (experimental) Version 1.0.
     *
     * @experimental
     */
    VERSION_1_0 = "1.0",
    /**
     * (experimental) Version 2.0.
     *
     * @experimental
     */
    VERSION_2_0 = "2.0"
}
/**
 * (experimental) Properties to initialize an instance of `HttpAuthorizer`.
 *
 * @experimental
 */
export interface HttpAuthorizerProps {
    /**
     * (experimental) Name of the authorizer.
     *
     * @default - id of the HttpAuthorizer construct.
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) HTTP Api to attach the authorizer to.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) The type of authorizer.
     *
     * @experimental
     */
    readonly type: HttpAuthorizerType;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     * @experimental
     */
    readonly identitySource: string[];
    /**
     * (experimental) A list of the intended recipients of the JWT.
     *
     * A valid JWT must provide an aud that matches at least one entry in this list.
     *
     * @default - required for JWT authorizer typess.
     * @experimental
     */
    readonly jwtAudience?: string[];
    /**
     * (experimental) The base domain of the identity provider that issues JWT.
     *
     * @default - required for JWT authorizer types.
     * @experimental
     */
    readonly jwtIssuer?: string;
    /**
     * (experimental) Specifies whether a Lambda authorizer returns a response in a simple format.
     *
     * If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
     *
     * @default - The lambda authorizer must return an IAM policy as its response
     * @experimental
     */
    readonly enableSimpleResponses?: boolean;
    /**
     * (experimental) Specifies the format of the payload sent to an HTTP API Lambda authorizer.
     *
     * @default AuthorizerPayloadVersion.VERSION_2_0 if the authorizer type is HttpAuthorizerType.LAMBDA
     * @experimental
     */
    readonly payloadFormatVersion?: AuthorizerPayloadVersion;
    /**
     * (experimental) The authorizer's Uniform Resource Identifier (URI).
     *
     * For REQUEST authorizers, this must be a well-formed Lambda function URI.
     *
     * @default - required for Request authorizer types
     * @experimental
     */
    readonly authorizerUri?: string;
    /**
     * (experimental) How long APIGateway should cache the results.
     *
     * Max 1 hour.
     *
     * @default - API Gateway will not cache authorizer responses
     * @experimental
     */
    readonly resultsCacheTtl?: Duration;
}
/**
 * (experimental) An authorizer for HTTP APIs.
 *
 * @experimental
 */
export interface IHttpAuthorizer extends IAuthorizer {
}
/**
 * (experimental) Reference to an http authorizer.
 *
 * @experimental
 */
export interface HttpAuthorizerAttributes {
    /**
     * (experimental) Id of the Authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * (experimental) Type of authorizer.
     *
     * Possible values are:
     * - JWT - JSON Web Token Authorizer
     * - CUSTOM - Lambda Authorizer
     * - NONE - No Authorization
     *
     * @experimental
     */
    readonly authorizerType: string;
}
/**
 * (experimental) An authorizer for Http Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
export declare class HttpAuthorizer extends Resource implements IHttpAuthorizer {
    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromHttpAuthorizerAttributes(scope: Construct, id: string, attrs: HttpAuthorizerAttributes): IHttpRouteAuthorizer;
    /**
     * (experimental) Id of the Authorizer.
     *
     * @experimental
     */
    readonly authorizerId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpAuthorizerProps);
}
/**
 * (experimental) Input to the bind() operation, that binds an authorizer to a route.
 *
 * @experimental
 */
export interface HttpRouteAuthorizerBindOptions {
    /**
     * (experimental) The route to which the authorizer is being bound.
     *
     * @experimental
     */
    readonly route: IHttpRoute;
    /**
     * (experimental) The scope for any constructs created as part of the bind.
     *
     * @experimental
     */
    readonly scope: Construct;
}
/**
 * (experimental) Results of binding an authorizer to an http route.
 *
 * @experimental
 */
export interface HttpRouteAuthorizerConfig {
    /**
     * (experimental) The authorizer id.
     *
     * @default - No authorizer id (useful for AWS_IAM route authorizer)
     * @experimental
     */
    readonly authorizerId?: string;
    /**
     * (experimental) The type of authorization.
     *
     * Possible values are:
     * - AWS_IAM - IAM Authorizer
     * - JWT - JSON Web Token Authorizer
     * - CUSTOM - Lambda Authorizer
     * - NONE - No Authorization
     *
     * @experimental
     */
    readonly authorizationType: string;
    /**
     * (experimental) The list of OIDC scopes to include in the authorization.
     *
     * @default - no authorization scopes
     * @experimental
     */
    readonly authorizationScopes?: string[];
}
/**
 * (experimental) An authorizer that can attach to an Http Route.
 *
 * @experimental
 */
export interface IHttpRouteAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 *
 * @experimental
 */
export declare class HttpNoneAuthorizer implements IHttpRouteAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(_: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
