"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Create a new API mapping for API Gateway API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingProps(props);
        // defaultStage is present in IHttpStage.
        // However, importing "http" or "websocket" must import "common", but creating dependencies
        // the other way will cause potential cycles.
        // So casting to 'any'
        let stage = (_b = props.stage) !== null && _b !== void 0 ? _b : props.api.defaultStage;
        if (!stage) {
            throw new Error('stage property must be specified');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new aws_apigatewayv2_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_ApiMappingAttributes(attrs);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.ApiMapping", version: "2.6.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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