---
name: Feature Request
about: Suggest an idea for this project
title: '[FEATURE] '
labels: enhancement
assignees: ''
---

## Feature Description
A clear and concise description of the feature you'd like to see.

## Problem Statement
What problem does this feature solve? Is your feature request related to a problem? Please describe.

Example: "I'm always frustrated when [...]"

## Proposed Solution
A clear and concise description of what you want to happen.

## Example Usage
```python
# How would you use this feature?
import makeparallel as mp

@mp.new_decorator  # Your proposed feature
def my_function():
    # ...
```

## Alternatives Considered
A clear and concise description of any alternative solutions or features you've considered.

## Benefits
- Who would benefit from this feature?
- What are the advantages?
- How does it improve makeParallel?

## Implementation Ideas
(Optional) If you have ideas on how this could be implemented.

## Additional Context
Add any other context, screenshots, or examples about the feature request here.

## Checklist
- [ ] I have searched existing issues to ensure this is not a duplicate
- [ ] I have considered whether this fits the scope of makeParallel
- [ ] I would be willing to help implement this feature
