---
name: Bug Report
about: Create a report to help us improve
title: '[BUG] '
labels: bug
assignees: ''
---

## Bug Description
A clear and concise description of what the bug is.

## To Reproduce
Steps to reproduce the behavior:
1. Install makeParallel version '...'
2. Run the following code '....'
3. See error

## Expected Behavior
A clear and concise description of what you expected to happen.

## Actual Behavior
What actually happened.

## Code Sample
```python
# Minimal code sample that reproduces the issue
import makeparallel as mp

@mp.parallel
def my_function():
    # ...
```

## Error Messages
```
Paste any error messages or stack traces here
```

## Environment
- **OS**: [e.g., Ubuntu 22.04, Windows 11, macOS 13]
- **Python Version**: [e.g., 3.11.5]
- **makeParallel Version**: [e.g., 0.1.0]
- **Installation Method**: [e.g., pip, source]

## Additional Context
Add any other context about the problem here (screenshots, logs, etc.).

## Possible Solution
(Optional) If you have ideas on how to fix this issue.
