# Welcome to mapwidget

<!-- [![image](https://img.shields.io/conda/vn/conda-forge/mapwidget.svg)](https://anaconda.org/conda-forge/mapwidget) -->

[![image](https://img.shields.io/pypi/v/mapwidget.svg)](https://pypi.python.org/pypi/mapwidget)
[![image](https://studiolab.sagemaker.aws/studiolab.svg)](https://studiolab.sagemaker.aws/import/github/giswqs/mapwidget/blob/master/docs/examples/maplibre.ipynb)
[![image](https://img.shields.io/badge/Open-Planetary%20Computer-black?style=flat&logo=microsoft)](https://pccompute.westeurope.cloudapp.azure.com/compute/hub/user-redirect/git-pull?repo=https://github.com/giswqs/mapwidget&urlpath=lab/tree/leafmap/docs/examples/maplibre.ipynb&branch=master)
[![image](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/giswqs/mapwidget/blob/master/docs/examples/maplibre.ipynb)

**Custom Jupyter widgets for creating interactive maps using JavaScript libraries with bidirectional communication**

The **mapwidget** package provides a set of custom map widgets for creating interactive maps in a Jupyter environment using different JavaScript mapping libraries, such as [Cesium](https://cesium.com/), [Leaflet](https://leafletjs.com/), [Mapbox](https://www.mapbox.com/), [MapLibre](https://maplibre.org/), and [OpenLayers](https://openlayers.org/). The widgets are built on top of the [anywidget](https://github.com/manzt/anywidget) Python package.

-   Free software: MIT license
-   Documentation: https://mapwidget.gishub.org

## Examples

-   [Cesium](https://mapwidget.gishub.org/examples/cesium)
-   [Leaflet](https://mapwidget.gishub.org/examples/leaflet)
-   [Mapbox](https://mapwidget.gishub.org/examples/mapbox)
-   [MapLibre](https://mapwidget.gishub.org/examples/maplibre)
-   [OpenLayers](https://mapwidget.gishub.org/examples/openlayers)

## Demos

### Cesium

![](https://i.imgur.com/6quoDtN.gif)

### Mapbox

![](https://i.imgur.com/4uIEnAJ.gif)

### MapLibre

![](https://i.imgur.com/o2ZHeTL.gif)

## Credits

This package was created with [Cookiecutter](https://github.com/cookiecutter/cookiecutter) and the [giswqs/pypackage](https://github.com/giswqs/pypackage) project template.
