import * as codedeploy from '@aws-cdk/aws-codedeploy';
import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { Code, CodeConfig } from './code';
/**
 * Construction properties for the Ec2Deployer object.
 *
 * @stability stable
 */
export interface Ec2DeployerProps {
    /**
     * The source code to be deployed.
     *
     * @stability stable
     */
    readonly code: Code;
    /**
     * The deployment group to deploy the artifact to.
     *
     * @stability stable
     */
    readonly deploymentGroup: codedeploy.IServerDeploymentGroup;
    /**
     * Whether the enclosing stack should wait for the deployment to complete.
     *
     * @default - true
     * @stability stable
     */
    readonly waitToComplete?: boolean;
    /**
     * Amount of time the stack will wait for the deployment operation to complete, for a maximum of 2 hours.
     *
     * Has no effect if waitToComplete = false.
     *
     * @default - 5 minutes
     * @stability stable
     */
    readonly deploymentTimeout?: cdk.Duration;
    /**
     * The IAM roles associated with the target instances to be deployed to.
     *
     * This is used to ensure the target instances have the appropriate permissions to download the deployment artifact from S3.
     * This prop is only required when the instance roles cannot be dynamically pulled from the supplied deploymentGroup's autoScalingGroups property,
     * for example when deploymentGroup is of type IServerDeploymentGroup or if the deploymentGroup is not associated with an ASG.
     *
     * @default - gets the instance roles from serverDeploymentGroup.autoScalingGroups[].role
     * @stability stable
     */
    readonly instanceRoles?: iam.IRole[];
}
/**
 * Represents a Deployer resource for deploying an artifact to EC2 using CodeDeploy.
 *
 * @stability stable
 */
export declare class Ec2Deployer extends cdk.Construct {
    /**
     * Maximum allowed value for deploymentTimeout prop.
     *
     * @stability stable
     */
    static readonly MAX_DEPLOYMENT_TIMEOUT: cdk.Duration;
    /**
     * The deployment group being deployed to.
     *
     * @stability stable
     */
    readonly deploymentGroup: codedeploy.IServerDeploymentGroup;
    /**
     * The source code to be deployed.
     *
     * @stability stable
     */
    readonly code: CodeConfig;
    /**
     * Whether the enclosing stack will wait for the deployment to complete.
     *
     * @stability stable
     */
    readonly waitToComplete: boolean;
    /**
     * Amount of time the stack will wait for the deployment operation to complete.
     *
     * @stability stable
     */
    readonly deploymentTimeout?: cdk.Duration;
    /**
     * The IAM roles associated with the target instances to be deployed to.
     *
     * This is used to ensure the target instances have the appropriate permissions to download the deployment artifact from S3.
     * This prop is only required when the instance roles cannot be dynamically pulled from the supplied deploymentGroup's autoScalingGroups property,
     * for example when deploymentGroup is of type IServerDeploymentGroup or if the deploymentGroup is not associated with an ASG.
     *
     * @stability stable
     */
    readonly instanceRoles?: iam.IRole[];
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: Ec2DeployerProps);
}
