"""
This type stub file was generated by pyright.
"""

from saml2.entity import Entity

"""Contains classes and functions that a SAML2.0 Identity provider (IdP)
or attribute authority (AA) may use to conclude its tasks.
"""
logger = ...
AUTHN_DICT_MAP = ...
class Server(Entity):
    """A class that does things that IdPs or AAs do"""
    def __init__(self, config_file=..., config=..., cache=..., stype=..., symkey=..., msg_cb=...) -> None:
        ...
    
    def getvalid_certificate_str(self): # -> bytes | None:
        ...
    
    def support_AssertionIDRequest(self): # -> Literal[True]:
        ...
    
    def support_AuthnQuery(self): # -> Literal[True]:
        ...
    
    def choose_session_storage(self): # -> SessionStorage | SessionStorageMDB:
        ...
    
    def init_config(self, stype=...):
        """Remaining init of the server configuration

        :param stype: The type of Server ("idp"/"aa")
        """
        ...
    
    def wants(self, sp_entity_id, index=...):
        """Returns what attributes the SP requires and which are optional
        if any such demands are registered in the Metadata.

        :param sp_entity_id: The entity id of the SP
        :param index: which of the attribute consumer services its all about
            if index == None then all attribute consumer services are clumped
            together.
        :return: 2-tuple, list of required and list of optional attributes
        """
        ...
    
    def verify_assertion_consumer_service(self, request): # -> bool:
        ...
    
    def parse_authn_request(self, enc_request, binding=..., relay_state=..., sigalg=..., signature=...): # -> None:
        """Parse a Authentication Request

        :param enc_request: The request in its transport format
        :param binding: Which binding that was used to transport the message
        :param relay_state: RelayState, when binding=redirect
        :param sigalg: Signature Algorithm, when binding=redirect
        :param signature: Signature, when binding=redirect
            to this entity.
        :return: A request instance
        """
        ...
    
    def parse_attribute_query(self, xml_string, binding): # -> None:
        """Parse an attribute query

        :param xml_string: The Attribute Query as an XML string
        :param binding: Which binding that was used for the request
        :return: A query instance
        """
        ...
    
    def parse_authz_decision_query(self, xml_string, binding): # -> None:
        """Parse an authorization decision query

        :param xml_string: The Authz decision Query as an XML string
        :param binding: Which binding that was used when receiving this query
        :return: Query instance
        """
        ...
    
    def parse_assertion_id_request(self, xml_string, binding): # -> None:
        """Parse an assertion id query

        :param xml_string: The AssertionIDRequest as an XML string
        :param binding: Which binding that was used when receiving this request
        :return: Query instance
        """
        ...
    
    def parse_authn_query(self, xml_string, binding): # -> None:
        """Parse an authn query

        :param xml_string: The AuthnQuery as an XML string
        :param binding: Which binding that was used when receiving this query
        :return: Query instance
        """
        ...
    
    def parse_name_id_mapping_request(self, xml_string, binding): # -> None:
        """Parse a nameid mapping request

        :param xml_string: The NameIDMappingRequest as an XML string
        :param binding: Which binding that was used when receiving this request
        :return: Query instance
        """
        ...
    
    @staticmethod
    def update_farg(in_response_to, consumer_url, farg=...): # -> dict[Any, Any]:
        ...
    
    def setup_assertion(self, authn, sp_entity_id, in_response_to, consumer_url, name_id, policy, _issuer, authn_statement, identity, best_effort, sign_response, farg=..., session_not_on_or_after=..., sign_alg=..., digest_alg=..., **kwargs): # -> list[str] | Assertion:
        """
        Construct and return the Assertion

        :param authn: Authentication information
        :param sp_entity_id:
        :param in_response_to: The ID of the request this is an answer to
        :param consumer_url: The recipient of the assertion
        :param name_id: The NameID of the subject
        :param policy: Assertion policies
        :param _issuer: Issuer of the statement
        :param authn_statement: An AuthnStatement instance
        :param identity: Identity information about the Subject
        :param best_effort: Even if not the SPs demands can be met send a
            response.
        :param sign_response: Sign the response, only applicable if
            ErrorResponse
        :param kwargs: Extra keyword arguments
        :return: An Assertion instance
        """
        ...
    
    def create_attribute_response(self, identity, in_response_to, destination, sp_entity_id, userid=..., name_id=..., status=..., issuer=..., sign_assertion=..., sign_response=..., attributes=..., sign_alg=..., digest_alg=..., farg=..., **kwargs):
        """Create an attribute assertion response.

        :param identity: A dictionary with attributes and values that are
            expected to be the bases for the assertion in the response.
        :param in_response_to: The session identifier of the request
        :param destination: The URL which should receive the response
        :param sp_entity_id: The entity identifier of the SP
        :param userid: A identifier of the user
        :param name_id: The identifier of the subject
        :param status: The status of the response
        :param issuer: The issuer of the response
        :param sign_assertion: Whether the assertion should be signed or not
        :param sign_response: Whether the whole response should be signed
        :param attributes:
        :param kwargs: To catch extra keyword arguments
        :return: A response instance
        """
        ...
    
    def gather_authn_response_args(self, sp_entity_id, name_id_policy, userid, **kwargs): # -> dict[Any, Any]:
        ...
    
    def create_authn_response(self, identity, in_response_to, destination, sp_entity_id, name_id_policy=..., userid=..., name_id=..., authn=..., issuer=..., sign_response=..., sign_assertion=..., encrypt_cert_advice=..., encrypt_cert_assertion=..., encrypt_assertion=..., encrypt_assertion_self_contained=..., encrypted_advice_attributes=..., pefim=..., sign_alg=..., digest_alg=..., session_not_on_or_after=..., **kwargs): # -> list[str]:
        """Constructs an AuthenticationResponse

        :param identity: Information about an user
        :param in_response_to: The identifier of the authentication request
            this response is an answer to.
        :param destination: Where the response should be sent
        :param sp_entity_id: The entity identifier of the Service Provider
        :param name_id_policy: How the NameID should be constructed
        :param userid: The subject identifier
        :param name_id: The identifier of the subject. A saml.NameID instance.
        :param authn: Dictionary with information about the authentication
            context
        :param issuer: Issuer of the response
        :param sign_assertion: Whether the assertion should be signed or not.
        :param sign_response: Whether the response should be signed or not.
        :param encrypt_assertion: True if assertions should be encrypted.
        :param encrypt_assertion_self_contained: True if all encrypted
        assertions should have alla namespaces
        selfcontained.
        :param encrypted_advice_attributes: True if assertions in the advice
        element should be encrypted.
        :param encrypt_cert_advice: Certificate to be used for encryption of
        assertions in the advice element.
        :param encrypt_cert_assertion: Certificate to be used for encryption
        of assertions.
        :param pefim: True if a response according to the PEFIM profile
        should be created.
        :return: A response instance
        """
        ...
    
    def create_authn_request_response(self, identity, in_response_to, destination, sp_entity_id, name_id_policy=..., userid=..., name_id=..., authn=..., authn_decl=..., issuer=..., sign_response=..., sign_assertion=..., session_not_on_or_after=..., sign_alg=..., digest_alg=..., **kwargs): # -> list[str]:
        ...
    
    def create_assertion_id_request_response(self, assertion_id, sign=..., sign_alg=..., digest_alg=..., **kwargs):
        ...
    
    def create_name_id_mapping_response(self, name_id=..., encrypted_id=..., in_response_to=..., issuer=..., sign_response=..., status=..., sign_alg=..., digest_alg=..., **kwargs): # -> NameIDMappingResponse:
        """
        protocol for mapping a principal's name identifier into a
        different name identifier for the same principal.
        Done over soap.

        :param name_id:
        :param encrypted_id:
        :param in_response_to:
        :param issuer:
        :param sign_response:
        :param status:
        :return:
        """
        ...
    
    def create_authn_query_response(self, subject, session_index=..., requested_context=..., in_response_to=..., issuer=..., sign_response=..., status=..., sign_alg=..., digest_alg=..., **kwargs):
        """
        A successful <Response> will contain one or more assertions containing
        authentication statements.

        :return:
        """
        ...
    
    def parse_ecp_authn_request(self): # -> None:
        ...
    
    def create_ecp_authn_request_response(self, acs_url, identity, in_response_to, destination, sp_entity_id, name_id_policy=..., userid=..., name_id=..., authn=..., issuer=..., sign_response=..., sign_assertion=..., sign_alg=..., digest_alg=..., **kwargs): # -> str:
        ...
    
    def close(self): # -> None:
        ...
    
    def clean_out_user(self, name_id): # -> Any | None:
        """
        Remove all authentication statements that belongs to a user identified
        by a NameID instance

        :param name_id: NameID instance
        :return: The local identifier for the user
        """
        ...
    


