"""
This type stub file was generated by pyright.
"""

from logging import Logger
from logging.config import _DictConfigArgs  # pyright: ignore[reportPrivateUsage]
from typing import Any, Literal, TypedDict

from saml2 import SAMLError, BINDING_HTTP_ARTIFACT, BINDING_HTTP_POST, BINDING_HTTP_REDIRECT, BINDING_SOAP, BINDING_URI
from saml2.saml import NAME_FORMAT_URI
from typing_extensions import Self, NotRequired

class ContactPerson(TypedDict):
    givenname: str
    surname: str
    company: str
    mail: str | list[str]
    type: Literal["technical", "support", "administrative", "billing", "other"]

class VirtualOrganization(TypedDict):
    nameid_format: str,
    common_identifier: str

class MetadataMDQ(TypedDict):
    url: str
    cert: NotRequired[str]
    freshness_period: NotRequired[str]
    disable_ssl_certificate_validation: NotRequired[bool]
    check_validity: NotRequired[bool]

class MetadataRemote(TypedDict):
    url: str
    cert: str

class Metadata(TypedDict):
    local: NotRequired[list[str]]
    remote: NotRequired[list[MetadataRemote]]
    mdq: NotRequired[list[MetadataMDQ]]

class PolicyUIInfoLogo(TypedDict):
    height: str
    width: str
    text: str

class PolicyUIInfoDescription(TypedDict):
    text: str
    lang: str

class PolicyUIInfoKeywords(TypedDict):
    text: str
    lang: str

class PolicyUIInfo(TypedDict):
    privacy_statement_url: NotRequired[str]
    information_url: NotRequired[str]
    logo: NotRequired[PolicyUIInfoLogo]
    display_name: NotRequired[str]
    description: NotRequired[PolicyUIInfoDescription]
    keywords: NotRequired[PolicyUIInfoKeywords]


class Policy(TypedDict):
    lifetime: NotRequired[dict[str, int]]
    attribute_restrictions: NotRequired[dict[str, Any|None]]
    name_form: NotRequired[str]
    nameid_format: NotRequired[str]
    entity_categories: NotRequired[list[str]]
    sign: NotRequired[Literal["response", "assertion", "on_demand"]]

logger: Logger = ...
__author__: str = ...
COMMON_ARGS: Literal[
    "logging",
    "debug",
    "entityid",
    "xmlsec_binary",
    "key_file",
    "cert_file",
    "encryption_keypairs",
    "additional_cert_files",
    "metadata_key_usage",
    "secret",
    "accepted_time_diff",
    "name",
    "ca_certs",
    "description",
    "valid_for",
    "verify_ssl_cert",
    "organization",
    "contact_person",
    "name_form",
    "virtual_organization",
    "only_use_keys_in_metadata",
    "disable_ssl_certificate_validation",
    "preferred_binding",
    "session_storage",
    "assurance_certification",
    "entity_attributes",
    "entity_category",
    "entity_category_support",
    "xmlsec_path",
    "extension_schemas",
    "cert_handler_extra_class",
    "generate_cert_func",
    "generate_cert_info",
    "verify_encrypt_cert_advice",
    "verify_encrypt_cert_assertion",
    "tmp_cert_file",
    "tmp_key_file",
    "validate_certificate",
    "extensions",
    "allow_unknown_attributes",
    "crypto_backend",
    "delete_tmpfiles",
    "endpoints",
    "metadata",
    "ui_info",
    "name_id_format",
    "signing_algorithm",
    "digest_algorithm",
    "http_client_timeout",
]

SP_ARGS: Literal[
    "required_attributes",
    "optional_attributes",
    "idp",
    "aa",
    "subject_data",
    "want_response_signed",
    "want_assertions_signed",
    "want_assertions_or_response_signed",
    "authn_requests_signed",
    "name_form",
    "discovery_response",
    "allow_unsolicited",
    "ecp",
    "name_id_policy_format",
    "name_id_format_allow_create",
    "logout_requests_signed",
    "logout_responses_signed",
    "requested_attribute_name_format",
    "hide_assertion_consumer_service",
    "force_authn",
    "sp_type",
    "sp_type_in_metadata",
    "requested_attributes",
    "requested_authn_context",
]

AA_IDP_ARGS: Literal[
    "sign_assertion",
    "sign_response",
    "encrypt_assertion",
    "encrypted_advice_attributes",
    "encrypt_assertion_self_contained",
    "want_authn_requests_signed",
    "want_authn_requests_only_with_valid_cert",
    "provided_attributes",
    "subject_data",
    "sp",
    "scope",
    "domain",
    "name_qualifier",
    "edu_person_targeted_id",
    "error_url",
]

PDP_ARGS: Literal["endpoints", "name_form", "name_id_format"]

AQ_ARGS: Literal["endpoints"]

AA_ARGS: Literal["attribute", "attribute_profile"]

COMPLEX_ARGS: Literal["attribute_converters", "metadata", "policy"]
ALL = set(COMMON_ARGS + SP_ARGS + AA_IDP_ARGS + PDP_ARGS + COMPLEX_ARGS + AA_ARGS)

SPEC = {
    "": COMMON_ARGS + COMPLEX_ARGS,
    "sp": COMMON_ARGS + COMPLEX_ARGS + SP_ARGS,
    "idp": COMMON_ARGS + COMPLEX_ARGS + AA_IDP_ARGS,
    "aa": COMMON_ARGS + COMPLEX_ARGS + AA_IDP_ARGS + AA_ARGS,
    "pdp": COMMON_ARGS + COMPLEX_ARGS + PDP_ARGS,
    "aq": COMMON_ARGS + COMPLEX_ARGS + AQ_ARGS,
}

_RPA = [BINDING_HTTP_REDIRECT, BINDING_HTTP_POST, BINDING_HTTP_ARTIFACT]
_PRA = [BINDING_HTTP_POST, BINDING_HTTP_REDIRECT, BINDING_HTTP_ARTIFACT]
_SRPA = [BINDING_SOAP, BINDING_HTTP_REDIRECT, BINDING_HTTP_POST, BINDING_HTTP_ARTIFACT]

PREFERRED_BINDING = {
    "single_logout_service": _SRPA,
    "manage_name_id_service": _SRPA,
    "assertion_consumer_service": _PRA,
    "single_sign_on_service": _RPA,
    "name_id_mapping_service": [BINDING_SOAP],
    "authn_query_service": [BINDING_SOAP],
    "attribute_service": [BINDING_SOAP],
    "authz_service": [BINDING_SOAP],
    "assertion_id_request_service": [BINDING_URI],
    "artifact_resolution_service": [BINDING_SOAP],
    "attribute_consuming_service": _RPA,
}
class ConfigurationError(SAMLError):
    ...


class Config:
    def_context: str = ...
    logging: _DictConfigArgs | dict[str, Any] | None = None
    _homedir: str = "."
    entityid: str | None = None
    xmlsec_binary: str | None = None
    xmlsec_path: list[str] = []
    debug: bool = False
    key_file: str | None = None
    cert_file: str | None = None
    encryption_keypairs: list[dict[str,str]] | None = None
    additional_cert_files: list[str] | None = None
    metadata_key_usage: Literal["both", "signing", "encryption"] = "both"
    secret: str | None = None
    accepted_time_diff: int | None = None
    name: str | None = None
    ca_certs: str | None = None
    verify_ssl_cert: bool = False
    description: str | None = None
    valid_for: int | None = None
    organization: dict[str, list[str | tuple[str, str]]] | None = None
    contact_person: list[ContactPerson] | None = None
    name_form: str | None = None
    name_id_format: list[str] | None = None
    name_id_policy_format: str | None = None
    name_id_format_allow_create: bool | None = None
    virtual_organization: dict[str, VirtualOrganization] | None = None
    only_use_keys_in_metadata: bool = True
    logout_requests_signed: bool | None = None
    logout_responses_signed: bool | None = None
    disable_ssl_certificate_validation: bool | None = None
    context: str = ""
    attribute_converters: Any = None
    metadata: Metadata | None = None
    policy: Policy | None = None
    serves: list[Any] = []
    vorg: dict[str, VirtualOrganization] = {}
    preferred_binding = PREFERRED_BINDING
    domain: str = ""
    name_qualifier: str = ""
    assurance_certification: list[str] = []
    entity_attributes: list[Any] = []
    entity_category: list[Any] = []
    entity_category_support: list[Any] = []
    crypto_backend: str = "xmlsec1"
    scope: NotRequired[list[str] | str] = ""
    allow_unknown_attributes: bool = False
    extension_schema: dict[Any, Any] = {}
    cert_handler_extra_class: Any | None = None
    verify_encrypt_cert_advice: Any | None = None
    verify_encrypt_cert_assertion: Any | None = None
    generate_cert_func: Any | None = None
    generate_cert_info: Any | None = None
    tmp_cert_file: Any | None = None
    tmp_key_file: Any | None = None
    validate_certificate: Any | None = None
    extensions: dict[Any, Any] = {}
    attribute: list[Any] = []
    attribute_profile: list[Any] = []
    requested_attribute_name_format = NAME_FORMAT_URI
    delete_tmpfiles: bool = True
    signing_algorithm: Any = None
    digest_algorithm: Any = None
    http_client_timeout: Any = None

    def __init__(self, homedir: str=...) -> None:
        ...
    
    def setattr(self, context, attr, val): # -> None:
        ...
    
    def getattr(self, attr, context=...): # -> Any | None:
        ...
    
    def load_special(self, cnf, typ): # -> None:
        ...
    
    def load_complex(self, cnf): # -> None:
        ...
    
    def load(self, cnf: dict[str, Any], metadata_construction: Any=...) -> Self:
        """The base load method, loads the configuration

        :param cnf: The configuration as a dictionary
        :return: The Configuration instance
        """
        ...
    
    def load_file(self, config_filename, metadata_construction=...): # -> Self:
        ...
    
    def load_metadata(self, metadata_conf): # -> MetadataStore:
        """Loads metadata into an internal structure"""
        ...
    
    def endpoint(self, service, binding=..., context=...): # -> list[Any]:
        """Goes through the list of endpoint specifications for the
        given type of service and returns a list of endpoint that matches
        the given binding. If no binding is given all endpoints available for
        that service will be returned.

        :param service: The service the endpoint should support
        :param binding: The expected binding
        :return: All the endpoints that matches the given restrictions
        """
        ...
    
    def endpoint2service(self, endpoint, context=...): # -> tuple[Any, Any] | tuple[None, None]:
        ...
    
    def do_extensions(self, extensions): # -> None:
        ...
    
    def service_per_endpoint(self, context=...): # -> dict[Any, Any]:
        """
        List all endpoint this entity publishes and which service and binding
        that are behind the endpoint

        :param context: Type of entity
        :return: Dictionary with endpoint url as key and a tuple of
            service and binding as value
        """
        ...
    


class SPConfig(Config):
    def_context = ...
    def __init__(self) -> None:
        ...
    
    def vo_conf(self, vo_name): # -> None:
        ...
    
    def ecp_endpoint(self, ipaddress): # -> Any | None:
        """
        Returns the entity ID of the IdP which the ECP client should talk to

        :param ipaddress: The IP address of the user client
        :return: IdP entity ID or None
        """
        ...
    


class IdPConfig(Config):
    def_context = ...
    def __init__(self) -> None:
        ...
    


def config_factory(_type, config): # -> SPConfig | IdPConfig | Config:
    """

    :type _type: str
    :param _type:

    :type config: str or dict
    :param config: Name of file with pysaml2 config or CONFIG dict

    :return:
    """
    ...

