"""
This type stub file was generated by pyright.
"""

logger = ...
def filter_on_attributes(ava, required=..., optional=..., acs=..., fail_on_unfulfilled_requirements=...): # -> dict[Any, Any]:
    """Filter

    :param ava: An attribute value assertion as a dictionary
    :param required: list of RequestedAttribute instances defined to be
        required
    :param optional: list of RequestedAttribute instances defined to be
        optional
    :param fail_on_unfulfilled_requirements: If required attributes
        are missing fail or fail not depending on this parameter.
    :return: The modified attribute value assertion
    """
    ...

def filter_on_demands(ava, required=..., optional=...):
    """Never return more than is needed. Filters out everything
    the server is prepared to return but the receiver doesn't ask for

    :param ava: Attribute value assertion as a dictionary
    :param required: Required attributes
    :param optional: Optional attributes
    :return: The possibly reduced assertion
    """
    ...

def filter_on_wire_representation(ava, acs, required=..., optional=...): # -> dict[Any, Any]:
    """
    :param ava: A dictionary with attributes and values
    :param acs: List of tuples (Attribute Converter name,
        Attribute Converter instance)
    :param required: A list of saml.Attributes
    :param optional: A list of saml.Attributes
    :return: Dictionary of expected/wanted attributes and values
    """
    ...

def filter_attribute_value_assertions(ava, attribute_restrictions=...):
    """Will weed out attribute values and values according to the
    rules defined in the attribute restrictions. If filtering results in
    an attribute without values, then the attribute is removed from the
    assertion.

    :param ava: The incoming attribute value assertion (dictionary)
    :param attribute_restrictions: The rules that govern which attributes
        and values that are allowed. (dictionary)
    :return: The modified attribute value assertion
    """
    ...

def restriction_from_attribute_spec(attributes): # -> dict[Any, Any]:
    ...

def compile(restrictions):
    """This is only for IdPs or AAs, and it's about limiting what
    is returned to the SP.
    In the configuration file, restrictions on which values that
    can be returned are specified with the help of regular expressions.
    This function goes through and pre-compiles the regular expressions.

    :param restrictions: policy configuration
    :return: The assertion with the string specification replaced with
        a compiled regular expression.
    """
    ...

class Policy:
    """Handles restrictions on assertions."""
    def __init__(self, restrictions=..., mds=...) -> None:
        ...
    
    def setup_restrictions(self, restrictions=...): # -> None:
        ...
    
    def get(self, attribute, sp_entity_id, default=...): # -> None:
        """

        :param attribute:
        :param sp_entity_id:
        :param default:
        :return:
        """
        ...
    
    def get_nameid_format(self, sp_entity_id): # -> None:
        """Get the NameIDFormat to used for the entity id
        :param: The SP entity ID
        :retur: The format
        """
        ...
    
    def get_name_form(self, sp_entity_id): # -> None:
        """Get the NameFormat to used for the entity id
        :param: The SP entity ID
        :retur: The format
        """
        ...
    
    def get_lifetime(self, sp_entity_id): # -> None:
        """The lifetime of the assertion
        :param sp_entity_id: The SP entity ID
        :param: lifetime as a dictionary
        """
        ...
    
    def get_attribute_restrictions(self, sp_entity_id): # -> None:
        """Return the attribute restriction for SP that want the information

        :param sp_entity_id: The SP entity ID
        :return: The restrictions
        """
        ...
    
    def get_fail_on_missing_requested(self, sp_entity_id): # -> None:
        """Return the whether the IdP should should fail if the SPs
        requested attributes could not be found.

        :param sp_entity_id: The SP entity ID
        :return: The restrictions
        """
        ...
    
    def get_sign(self, sp_entity_id): # -> None:
        """
        Possible choices
        "sign": ["response", "assertion", "on_demand"]

        :param sp_entity_id:
        :return:
        """
        ...
    
    def get_entity_categories(self, sp_entity_id, mds=..., required=...): # -> dict[Any, Any]:
        """

        :param sp_entity_id:
        :param required: required attributes
        :return: A dictionary with restrictions
        """
        ...
    
    def not_on_or_after(self, sp_entity_id):
        """When the assertion stops being valid, should not be
        used after this time.

        :param sp_entity_id: The SP entity ID
        :return: String representation of the time
        """
        ...
    
    def filter(self, ava, sp_entity_id, mdstore=..., required=..., optional=...): # -> dict[Any, Any]:
        """What attribute and attribute values returns depends on what
        the SP or the registration authority has said it wants in the request
        or in the metadata file and what the IdP/AA wants to release.
        An assumption is that what the SP or the registration authority
        asks for overrides whatever is in the metadata. But of course the
        IdP never releases anything it doesn't want to.

        :param ava: The information about the subject as a dictionary
        :param sp_entity_id: The entity ID of the SP
        :param required: Attributes that the SP requires in the assertion
        :param optional: Attributes that the SP regards as optional
        :return: A possibly modified AVA
        """
        ...
    
    def restrict(self, ava, sp_entity_id, metadata=...): # -> dict[Any, Any]:
        """Identity attribute names are expected to be expressed as FriendlyNames

        :return: A filtered ava according to the IdPs/AAs rules and
            the list of required/optional attributes according to the SP.
            If the requirements can't be met an exception is raised.
        """
        ...
    
    def conditions(self, sp_entity_id): # -> Conditions:
        """Return a saml.Condition instance

        :param sp_entity_id: The SP entity ID
        :return: A saml.Condition instance
        """
        ...
    


class EntityCategories:
    ...


def authn_statement(authn_class=..., authn_auth=..., authn_decl=..., authn_decl_ref=..., authn_instant=..., subject_locality=..., session_not_on_or_after=...): # -> AuthnStatement:
    """
    Construct the AuthnStatement
    :param authn_class: Authentication Context Class reference
    :param authn_auth: Authenticating Authority
    :param authn_decl: Authentication Context Declaration
    :param authn_decl_ref: Authentication Context Declaration reference
    :param authn_instant: When the Authentication was performed.
        Assumed to be seconds since the Epoch.
    :param subject_locality: Specifies the DNS domain name and IP address
        for the system from which the assertion subject was apparently
        authenticated.
    :return: An AuthnContext instance
    """
    ...

def do_subject_confirmation(not_on_or_after, key_info=..., **treeargs): # -> SubjectConfirmation:
    """

    :param not_on_or_after: not_on_or_after policy
    :param subject_confirmation_method: How was the subject confirmed
    :param address: The network address/location from which an attesting entity
        can present the assertion.
    :param key_info: Information of the key used to confirm the subject
    :param in_response_to: The ID of a SAML protocol message in response to
        which an attesting entity can present the assertion.
    :param recipient: A URI specifying the entity or location to which an
        attesting entity can present the assertion.
    :param not_before: A time instant before which the subject cannot be
        confirmed. The time value MUST be encoded in UTC.
    :return:
    """
    ...

def do_subject(not_on_or_after, name_id, **farg): # -> Subject:
    ...

class Assertion(dict):
    """Handles assertions about subjects"""
    def __init__(self, dic=...) -> None:
        ...
    
    def construct(self, sp_entity_id, attrconvs, policy, issuer, farg, authn_class=..., authn_auth=..., authn_decl=..., encrypt=..., sec_context=..., authn_decl_ref=..., authn_instant=..., subject_locality=..., authn_statem=..., name_id=..., session_not_on_or_after=...): # -> Assertion:
        """Construct the Assertion

        :param sp_entity_id: The entityid of the SP
        :param in_response_to: An identifier of the message, this message is
            a response to
        :param name_id: An NameID instance
        :param attrconvs: AttributeConverters
        :param policy: The policy that should be adhered to when replying
        :param issuer: Who is issuing the statement
        :param authn_class: The authentication class
        :param authn_auth: The authentication instance
        :param authn_decl: An Authentication Context declaration
        :param encrypt: Whether to encrypt parts or all of the Assertion
        :param sec_context: The security context used when encrypting
        :param authn_decl_ref: An Authentication Context declaration reference
        :param authn_instant: When the Authentication was performed
        :param subject_locality: Specifies the DNS domain name and IP address
            for the system from which the assertion subject was apparently
            authenticated.
        :param authn_statem: A AuthnStatement instance
        :return: An Assertion instance
        """
        ...
    
    def apply_policy(self, sp_entity_id, policy):
        """Apply policy to the assertion I'm representing

        :param sp_entity_id: The SP entity ID
        :param policy: The policy
        :return: The resulting AVA after the policy is applied
        """
        ...
    


