"""
This type stub file was generated by pyright.
"""

from connexion.operations.abstract import AbstractOperation

"""
This module defines an OpenAPIOperation class, a Connexion operation specific for OpenAPI 3 specs.
"""
logger = ...
class OpenAPIOperation(AbstractOperation):
    """
    A single API operation on a path.
    """
    def __init__(self, method, path, operation, resolver, path_parameters=..., app_security=..., security_schemes=..., components=..., randomize_endpoint=..., uri_parser_class=...) -> None:
        """
        This class uses the OperationID identify the module and function that will handle the operation

        From Swagger Specification:

        **OperationID**

        A friendly name for the operation. The id MUST be unique among all operations described in the API.
        Tools and libraries MAY use the operation id to uniquely identify an operation.

        :param method: HTTP method
        :type method: str
        :param path:
        :type path: str
        :param operation: swagger operation object
        :type operation: dict
        :param resolver: Callable that maps operationID to a function
        :param path_parameters: Parameters defined in the path level
        :type path_parameters: list
        :param app_security: list of security rules the application uses by default
        :type app_security: list
        :param security_schemes: `Security Definitions Object
            <https://github.com/swagger-api/swagger-spec/blob/master/versions/2.0.md#security-definitions-object>`_
        :type security_schemes: dict
        :param components: `Components Object
            <https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#componentsObject>`_
        :type components: dict
        :param randomize_endpoint: number of random characters to append to operation name
        :type randomize_endpoint: integer
        :param uri_parser_class: class to use for uri parsing
        :type uri_parser_class: AbstractURIParser
        """
        ...
    
    @classmethod
    def from_spec(cls, spec, *args, path, method, resolver, **kwargs): # -> Self:
        ...
    
    @property
    def request_body(self):
        ...
    
    @property
    def parameters(self):
        ...
    
    @property
    def consumes(self): # -> list[Any]:
        ...
    
    @property
    def produces(self): # -> list[Any]:
        ...
    
    def with_definitions(self, schema: dict): # -> dict[Any, Any]:
        ...
    
    def response_schema(self, status_code=..., content_type=...): # -> dict[Any, Any]:
        ...
    
    def example_response(self, status_code=..., content_type=...): # -> tuple[Any, int] | tuple[Any | dict[Any, Any] | list[Any], int] | tuple[None, int]:
        """
        Returns example response from spec
        """
        ...
    
    def get_path_parameter_types(self): # -> dict[Any, Any]:
        ...
    
    def body_name(self, _content_type: str) -> str:
        ...
    
    def body_schema(self, content_type: str = ...) -> dict:
        """
        The body schema definition for this operation.
        """
        ...
    
    def body_definition(self, content_type: str = ...) -> dict:
        """
        The body complete definition for this operation.

        **There can be one "body" parameter at most.**
        """
        ...
    


