"""
This type stub file was generated by pyright.
"""

import abc
import typing as t
from connexion.frameworks.abstract import Framework
from connexion.lifecycle import ConnexionRequest, WSGIRequest
from connexion.operations import AbstractOperation

"""
This module defines a decorator to convert request parameters to arguments for the view function.
"""
logger = ...
CONTEXT_NAME = ...
class BaseParameterDecorator:
    def __init__(self, *, framework: t.Type[Framework], pythonic_params: bool = ...) -> None:
        ...
    
    @abc.abstractmethod
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


class SyncParameterDecorator(BaseParameterDecorator):
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


class AsyncParameterDecorator(BaseParameterDecorator):
    def __call__(self, function: t.Callable) -> t.Callable:
        ...
    


def prep_kwargs(request: t.Union[WSGIRequest, ConnexionRequest], *, request_body: t.Any, files: t.Dict[str, t.Any], arguments: t.List[str], has_kwargs: bool, sanitize: t.Callable) -> dict:
    ...

def unwrap_decorators(function: t.Callable) -> t.Callable:
    """Unwrap decorators to return the original function."""
    ...

def snake_and_shadow(name: str) -> str:
    """
    Converts the given name into Pythonic form. Firstly it converts CamelCase names to snake_case. Secondly it looks to
    see if the name matches a known built-in and if it does it appends an underscore to the name.
    :param name: The parameter name
    """
    ...

def sanitized(name: str) -> str:
    ...

def pythonic(name: str) -> str:
    ...

def get_arguments(operation: AbstractOperation, *, path_params: dict, query_params: dict, body: t.Any, files: dict, arguments: t.List[str], has_kwargs: bool, sanitize: t.Callable, content_type: str) -> t.Dict[str, t.Any]:
    """
    get arguments for handler function
    """
    ...

