"""
This type stub file was generated by pyright.
"""

from typing import Any, ClassVar, Dict, Generic, Literal, NamedTuple, Optional, Sequence, TYPE_CHECKING, Tuple, Type, TypeVar, Union
from sqlalchemy.sql.schema import Constraint, ForeignKeyConstraint, Index, UniqueConstraint
from typing_extensions import TypeGuard
from .. import util
from ..util import sqla_compat
from alembic.autogenerate.api import AutogenContext
from alembic.ddl.impl import DefaultImpl

if TYPE_CHECKING:
    ...
CompareConstraintType = Union[Constraint, Index]
_C = TypeVar("_C", bound=CompareConstraintType)
_clsreg: Dict[str, Type[_constraint_sig]] = ...
class ComparisonResult(NamedTuple):
    status: Literal["equal", "different", "skip"]
    message: str
    @property
    def is_equal(self) -> bool:
        ...
    
    @property
    def is_different(self) -> bool:
        ...
    
    @property
    def is_skip(self) -> bool:
        ...
    
    @classmethod
    def Equal(cls) -> ComparisonResult:
        """the constraints are equal."""
        ...
    
    @classmethod
    def Different(cls, reason: Union[str, Sequence[str]]) -> ComparisonResult:
        """the constraints are different for the provided reason(s)."""
        ...
    
    @classmethod
    def Skip(cls, reason: Union[str, Sequence[str]]) -> ComparisonResult:
        """the constraint cannot be compared for the provided reason(s).

        The message is logged, but the constraints will be otherwise
        considered equal, meaning that no migration command will be
        generated.
        """
        ...
    


class _constraint_sig(Generic[_C]):
    const: _C
    _sig: Tuple[Any, ...]
    name: Optional[sqla_compat._ConstraintNameDefined]
    impl: DefaultImpl
    _is_index: ClassVar[bool] = ...
    _is_fk: ClassVar[bool] = ...
    _is_uq: ClassVar[bool] = ...
    _is_metadata: bool
    def __init_subclass__(cls) -> None:
        ...
    
    def __init__(self, is_metadata: bool, impl: DefaultImpl, const: _C) -> None:
        ...
    
    def compare_to_reflected(self, other: _constraint_sig[Any]) -> ComparisonResult:
        ...
    
    @classmethod
    def from_constraint(cls, is_metadata: bool, impl: DefaultImpl, constraint: _C) -> _constraint_sig[_C]:
        ...
    
    def md_name_to_sql_name(self, context: AutogenContext) -> Optional[str]:
        ...
    
    @util.memoized_property
    def is_named(self): # -> bool:
        ...
    
    @util.memoized_property
    def unnamed(self) -> Tuple[Any, ...]:
        ...
    
    @util.memoized_property
    def unnamed_no_options(self) -> Tuple[Any, ...]:
        ...
    
    def __eq__(self, other) -> bool:
        ...
    
    def __ne__(self, other) -> bool:
        ...
    
    def __hash__(self) -> int:
        ...
    


class _uq_constraint_sig(_constraint_sig[UniqueConstraint]):
    _is_uq = ...
    is_unique = ...
    def __init__(self, is_metadata: bool, impl: DefaultImpl, const: UniqueConstraint) -> None:
        ...
    
    @property
    def column_names(self) -> Tuple[str, ...]:
        ...
    


class _ix_constraint_sig(_constraint_sig[Index]):
    _is_index = ...
    name: sqla_compat._ConstraintName
    def __init__(self, is_metadata: bool, impl: DefaultImpl, const: Index) -> None:
        ...
    
    @util.memoized_property
    def has_expressions(self): # -> bool:
        ...
    
    @util.memoized_property
    def column_names(self) -> Tuple[str, ...]:
        ...
    
    @util.memoized_property
    def column_names_optional(self) -> Tuple[Optional[str], ...]:
        ...
    
    @util.memoized_property
    def is_named(self): # -> Literal[True]:
        ...
    
    @util.memoized_property
    def unnamed(self): # -> tuple[bool, *tuple[str | None, ...]]:
        ...
    


class _fk_constraint_sig(_constraint_sig[ForeignKeyConstraint]):
    _is_fk = ...
    def __init__(self, is_metadata: bool, impl: DefaultImpl, const: ForeignKeyConstraint) -> None:
        ...
    
    @util.memoized_property
    def unnamed_no_options(self): # -> tuple[Any, Any, tuple[Any, ...], Any, Any, tuple[Any, ...]]:
        ...
    


def is_index_sig(sig: _constraint_sig) -> TypeGuard[_ix_constraint_sig]:
    ...

def is_uq_sig(sig: _constraint_sig) -> TypeGuard[_uq_constraint_sig]:
    ...

def is_fk_sig(sig: _constraint_sig) -> TypeGuard[_fk_constraint_sig]:
    ...

