"""
This type stub file was generated by pyright.
"""

import os
from argparse import ArgumentParser, Namespace
from configparser import ConfigParser
from typing import Any, Dict, Mapping, Optional, Sequence, TextIO, Union, overload

from typing_extensions import TypedDict

from . import util

class Config:
    r"""Represent an Alembic configuration.

    Within an ``env.py`` script, this is available
    via the :attr:`.EnvironmentContext.config` attribute,
    which in turn is available at ``alembic.context``::

        from alembic import context

        some_param = context.config.get_main_option("my option")

    When invoking Alembic programmatically, a new
    :class:`.Config` can be created by passing
    the name of an .ini file to the constructor::

        from alembic.config import Config
        alembic_cfg = Config("/path/to/yourapp/alembic.ini")

    With a :class:`.Config` object, you can then
    run Alembic commands programmatically using the directives
    in :mod:`alembic.command`.

    The :class:`.Config` object can also be constructed without
    a filename.   Values can be set programmatically, and
    new sections will be created as needed::

        from alembic.config import Config
        alembic_cfg = Config()
        alembic_cfg.set_main_option("script_location", "myapp:migrations")
        alembic_cfg.set_main_option("sqlalchemy.url", "postgresql://foo/bar")
        alembic_cfg.set_section_option("mysection", "foo", "bar")

    .. warning::

       When using programmatic configuration, make sure the
       ``env.py`` file in use is compatible with the target configuration;
       including that the call to Python ``logging.fileConfig()`` is
       omitted if the programmatic configuration doesn't actually include
       logging directives.

    For passing non-string values to environments, such as connections and
    engines, use the :attr:`.Config.attributes` dictionary::

        with engine.begin() as connection:
            alembic_cfg.attributes['connection'] = connection
            command.upgrade(alembic_cfg, "head")

    :param file\_: name of the .ini file to open.
    :param ini_section: name of the main Alembic section within the
     .ini file
    :param output_buffer: optional file-like input buffer which
     will be passed to the :class:`.MigrationContext` - used to redirect
     the output of "offline generation" when using Alembic programmatically.
    :param stdout: buffer where the "print" output of commands will be sent.
     Defaults to ``sys.stdout``.

    :param config_args: A dictionary of keys and values that will be used
     for substitution in the alembic config file.  The dictionary as given
     is **copied** to a new one, stored locally as the attribute
     ``.config_args``. When the :attr:`.Config.file_config` attribute is
     first invoked, the replacement variable ``here`` will be added to this
     dictionary before the dictionary is passed to ``ConfigParser()``
     to parse the .ini file.

    :param attributes: optional dictionary of arbitrary Python keys/values,
     which will be populated into the :attr:`.Config.attributes` dictionary.

     .. seealso::

        :ref:`connection_sharing`

    """
    def __init__(self, file_: Union[str, os.PathLike[str], None] = ..., ini_section: str = ..., output_buffer: Optional[TextIO] = ..., stdout: TextIO = ..., cmd_opts: Optional[Namespace] = ..., config_args: Mapping[str, Any] = ..., attributes: Optional[Dict[str, Any]] = ...) -> None:
        """Construct a new :class:`.Config`"""
        ...
    
    cmd_opts: Optional[Namespace] = ...
    config_file_name: Union[str, os.PathLike[str], None] = ...
    config_ini_section: str = ...
    @util.memoized_property
    def attributes(self) -> Dict[str, Any]:
        """A Python dictionary for storage of additional state.


        This is a utility dictionary which can include not just strings but
        engines, connections, schema objects, or anything else.
        Use this to pass objects into an env.py script, such as passing
        a :class:`sqlalchemy.engine.base.Connection` when calling
        commands from :mod:`alembic.command` programmatically.

        .. seealso::

            :ref:`connection_sharing`

            :paramref:`.Config.attributes`

        """
        ...
    
    def print_stdout(self, text: str, *arg: Any) -> None:
        """Render a message to standard out.

        When :meth:`.Config.print_stdout` is called with additional args
        those arguments will formatted against the provided text,
        otherwise we simply output the provided text verbatim.

        This is a no-op when the``quiet`` messaging option is enabled.

        e.g.::

            >>> config.print_stdout('Some text %s', 'arg')
            Some Text arg

        """
        ...
    
    @util.memoized_property
    def file_config(self) -> ConfigParser:
        """Return the underlying ``ConfigParser`` object.

        Direct access to the .ini file is available here,
        though the :meth:`.Config.get_section` and
        :meth:`.Config.get_main_option`
        methods provide a possibly simpler interface.

        """
        ...
    
    def get_template_directory(self) -> str:
        """Return the directory where Alembic setup templates are found.

        This method is used by the alembic ``init`` and ``list_templates``
        commands.

        """
        ...
    
    @overload
    def get_section(self, name: str, default: None = ...) -> Optional[Dict[str, str]]:
        ...
    
    @overload
    def get_section(self, name: str, default: Dict[str, str]) -> Dict[str, str]:
        ...
    
    @overload
    def get_section(self, name: str, default: Mapping[str, str]) -> Union[Dict[str, str], Mapping[str, str]]:
        ...
    
    def get_section(self, name: str, default: Optional[Mapping[str, str]] = ...) -> Optional[Mapping[str, str]]:
        """Return all the configuration options from a given .ini file section
        as a dictionary.

        If the given section does not exist, the value of ``default``
        is returned, which is expected to be a dictionary or other mapping.

        """
        ...
    
    def set_main_option(self, name: str, value: str) -> None:
        """Set an option programmatically within the 'main' section.

        This overrides whatever was in the .ini file.

        :param name: name of the value

        :param value: the value.  Note that this value is passed to
         ``ConfigParser.set``, which supports variable interpolation using
         pyformat (e.g. ``%(some_value)s``).   A raw percent sign not part of
         an interpolation symbol must therefore be escaped, e.g. ``%%``.
         The given value may refer to another value already in the file
         using the interpolation format.

        """
        ...
    
    def remove_main_option(self, name: str) -> None:
        ...
    
    def set_section_option(self, section: str, name: str, value: str) -> None:
        """Set an option programmatically within the given section.

        The section is created if it doesn't exist already.
        The value here will override whatever was in the .ini
        file.

        :param section: name of the section

        :param name: name of the value

        :param value: the value.  Note that this value is passed to
         ``ConfigParser.set``, which supports variable interpolation using
         pyformat (e.g. ``%(some_value)s``).   A raw percent sign not part of
         an interpolation symbol must therefore be escaped, e.g. ``%%``.
         The given value may refer to another value already in the file
         using the interpolation format.

        """
        ...
    
    def get_section_option(self, section: str, name: str, default: Optional[str] = ...) -> Optional[str]:
        """Return an option from the given section of the .ini file."""
        ...
    
    @overload
    def get_main_option(self, name: str, default: str) -> str:
        ...
    
    @overload
    def get_main_option(self, name: str, default: Optional[str] = ...) -> Optional[str]:
        ...
    
    def get_main_option(self, name: str, default: Optional[str] = ...) -> Optional[str]:
        """Return an option from the 'main' section of the .ini file.

        This defaults to being a key from the ``[alembic]``
        section, unless the ``-n/--name`` flag were used to
        indicate a different section.

        """
        ...
    
    @util.memoized_property
    def messaging_opts(self) -> MessagingOptions:
        """The messaging options."""
        ...
    


class MessagingOptions(TypedDict, total=False):
    quiet: bool
    ...


class CommandLine:
    parser: ArgumentParser

    def __init__(self, prog: Optional[str] = ...) -> None:
        ...
    
    def run_cmd(self, config: Config, options: Namespace) -> None:
        ...
    
    def main(self, argv: Optional[Sequence[str]] = ...) -> None:
        ...
    


def main(argv: Optional[Sequence[str]] = ..., prog: Optional[str] = ..., **kwargs: Any) -> None:
    """The console runner function for Alembic."""
    ...

if __name__ == "__main__":
    ...
