"""
This type stub file was generated by cyright.
"""

from enum import Enum
from typing import Any, Callable, List, Tuple, Union

class SWMMObjects(Enum):
    """
    Enumeration of SWMM objects.

    :ivar SUBCATCH: Subcatchment object
    :type SUBCATCH: int 
    :ivar NODE: Node object
    :type NODE: int
    :ivar LINK: Link object
    :type LINK: int
    :ivar AQUIFER: Aquifer object
    :type AQUIFER: int
    :ivar SNOWPACK: Snowpack object
    :type SNOWPACK: int
    :ivar UNIT_HYDROGRAPH: Unit hydrograph object
    :type UNIT_HYDROGRAPH: int
    :ivar LID: LID object
    :type LID: int
    :ivar STREET: Street object
    :type STREET: int
    :ivar INLET: Inlet object
    :type INLET: int
    :ivar TRANSECT: Transect object
    :type TRANSECT: int
    :ivar XSECTION_SHAPE: Cross-section shape object
    :type XSECTION_SHAPE: int
    :ivar CONTROL_RULE: Control rule object
    :type CONTROL_RULE: int
    :ivar POLLUTANT: Pollutant object
    :type POLLUTANT: int
    :ivar LANDUSE: Land use object
    :type LANDUSE: int
    :ivar CURVE: Curve object
    :type CURVE: int
    :ivar TIMESERIES: Time series object
    :type TIMESERIES: int
    :ivar TIME_PATTERN: Time pattern object
    :type TIME_PATTERN: int
    :ivar SYSTEM: System object
    :type SYSTEM: int
    """
    RAIN_GAGE = ...
    SUBCATCHMENT = ...
    NODE = ...
    LINK = ...
    AQUIFER = ...
    SNOWPACK = ...
    UNIT_HYDROGRAPH = ...
    LID = ...
    STREET = ...
    INLET = ...
    TRANSECT = ...
    XSECTION_SHAPE = ...
    CONTROL_RULE = ...
    POLLUTANT = ...
    LANDUSE = ...
    CURVE = ...
    TIMESERIES = ...
    TIME_PATTERN = ...
    SYSTEM = ...


class SWMMNodeTypes(Enum):
    """
    Enumeration of SWMM node types.

    :ivar JUNCTION: Junction node
    :type JUNCTION: int
    :ivar OUTFALL: Outfall node
    :type OUTFALL: int
    :ivar STORAGE: Storage node
    :type STORAGE: int
    :ivar DIVIDER: Divider node
    :type DIVIDER: int
    """
    JUNCTION = ...
    OUTFALL = ...
    STORAGE = ...
    DIVIDER = ...


class SWMMRainGageProperties(Enum):
    """
    Enumeration of SWMM raingage properties.

    :ivar GAGE_TOTAL_PRECIPITATION: Total precipitation
    :type GAGE_TOTAL_PRECIPITATION: int
    :ivar GAGE_SNOW_DEPTH: Snow depth
    :type GAGE_SNOW_DEPTH: int
    :ivar GAGE_SNOWFALL: Snowfall
    :type GAGE_SNOWFALL: int
    """
    GAGE_TOTAL_PRECIPITATION = ...
    GAGE_RAINFALL = ...
    GAGE_SNOWFALL = ...


class SWMMSubcatchmentProperties(Enum):
    """
    Enumeration of SWMM subcatchment properties.

    :ivar AREA: Area
    :type AREA: int
    :ivar RAINGAGE: Raingage
    :type RAINGAGE: int
    :ivar RAINFALL: Rainfall
    :type RAINFALL: int
    :ivar EVAPORATION: Evaporation
    :type EVAPORATION: int
    :ivar INFILTRATION: Infiltration
    :type INFILTRATION: int
    :ivar RUNOFF: Runoff
    :type RUNOFF: int
    :ivar REPORT_FLAG: Report flag
    :type REPORT_FLAG: int
    :ivar WIDTH: Width
    :type WIDTH: int
    :ivar SLOPE: Slope
    :type SLOPE: int
    :ivar CURB_LENGTH: Curb length
    :type CURB_LENGTH: int
    :ivar API_RAINFALL: API Rainfall
    :type API_RAINFALL: int
    :ivar API_SNOWFALL: API Snowfall
    :type API_SNOWFALL: int
    :ivar POLLUTANT_BUILDUP: Pollutant buildup
    :type POLLUTANT_BUILDUP: int
    :ivar EXTERNAL_POLLUTANT_BUILDUP: External pollutant buildup
    :type EXTERNAL_POLLUTANT_BUILDUP: int
    :ivar POLLUTANT_RUNOFF_CONCENTRATION: Pollutant runoff concentration
    :type POLLUTANT_RUNOFF_CONCENTRATION: int
    :ivar POLLUTANT_PONDED_CONCENTRATION: Pollutant ponded concentration
    :type POLLUTANT_PONDED_CONCENTRATION: int
    :ivar POLLUTANT_TOTAL_LOAD: Pollutant total load
    :type POLLUTANT_TOTAL_LOAD: int
    """
    AREA = ...
    RAINGAGE = ...
    RAINFALL = ...
    EVAPORATION = ...
    INFILTRATION = ...
    RUNOFF = ...
    REPORT_FLAG = ...
    WIDTH = ...
    SLOPE = ...
    CURB_LENGTH = ...
    API_RAINFALL = ...
    API_SNOWFALL = ...
    POLLUTANT_BUILDUP = ...
    EXTERNAL_POLLUTANT_BUILDUP = ...
    POLLUTANT_RUNOFF_CONCENTRATION = ...
    POLLUTANT_PONDED_CONCENTRATION = ...
    POLLUTANT_TOTAL_LOAD = ...


class SWMMNodeProperties(Enum):
    """
    Enumeration of SWMM node properties.

    :ivar TYPE: Node type
    :type TYPE: int
    :ivar INVERT_ELEVATION: Invert elevation
    :type INVERT_ELEVATION: int
    :ivar MAX_DEPTH: Maximum depth
    :type MAX_DEPTH: int
    :ivar DEPTH: Depth
    :type DEPTH: int
    :ivar HYDRAULIC_HEAD: Hydraulic head
    :type HYDRAULIC_HEAD: int
    :ivar VOLUME: Volume
    :type VOLUME: int
    :ivar LATERAL_INFLOW: Lateral inflow
    :type LATERAL_INFLOW: int
    :ivar TOTAL_INFLOW: Total inflow
    :type TOTAL_INFLOW: int
    :ivar FLOODING: Flooding
    :type FLOODING: int
    :ivar REPORT_FLAG: Report flag
    :type REPORT_FLAG: int
    :ivar SURCHARGE_DEPTH: Surcharge depth
    :type SURCHARGE_DEPTH: int
    :ivar PONDING_AREA: Ponding area
    :type PONDING_AREA: int
    :ivar INITIAL_DEPTH: Initial depth
    :type INITIAL_DEPTH: int
    :ivar POLLUTANT_CONCENTRATION: Pollutant concentration
    :type POLLUTANT_CONCENTRATION: int
    :ivar POLLUTANT_LATERAL_MASS_FLUX: Pollutant lateral mass flux
    :type POLLUTANT_LATERAL_MASS_FLUX: int
    """
    TYPE = ...
    INVERT_ELEVATION = ...
    MAX_DEPTH = ...
    DEPTH = ...
    HYDRAULIC_HEAD = ...
    VOLUME = ...
    LATERAL_INFLOW = ...
    TOTAL_INFLOW = ...
    FLOODING = ...
    REPORT_FLAG = ...
    SURCHARGE_DEPTH = ...
    PONDING_AREA = ...
    INITIAL_DEPTH = ...
    POLLUTANT_CONCENTRATION = ...
    POLLUTANT_LATERAL_MASS_FLUX = ...


class SWMMLinkProperties(Enum):
    """
    Enumeration of SWMM link properties.

    :ivar TYPE: Link type
    :type TYPE: int
    :ivar OFFSET1: Offset 1
    :type OFFSET1: int
    :ivar OFFSET2: Offset 2
    :type OFFSET2: int
    :ivar DIAMETER: Diameter
    :type DIAMETER: int
    :ivar LENGTH: Length
    :type LENGTH: int
    :ivar ROUGHNESS: Roughness
    :type ROUGHNESS: int
    :ivar INLET_HEIGHT: Inlet height
    :type INLET_HEIGHT: int
    :ivar OUTLET_HEIGHT: Outlet height
    :type OUTLET_HEIGHT: int
    :ivar INIT_FLOW: Initial flow
    :type INIT_FLOW: int
    :ivar FLOW_LIMIT: Flow limit
    :type FLOW_LIMIT: int
    :ivar REPORT_FLAG: Report flag
    :type REPORT_FLAG: int
    """
    TYPE = ...
    START_NODE = ...
    END_NODE = ...
    LENGTH = ...
    SLOPE = ...
    FULL_DEPTH = ...
    FULL_FLOW = ...
    SETTING = ...
    TIME_OPEN = ...
    TIME_CLOSED = ...
    FLOW = ...
    DEPTH = ...
    VELOCITY = ...
    TOP_WIDTH = ...
    REPORT_FLAG = ...
    START_NODE_OFFSET = ...
    END_NODE_OFFSET = ...
    INITIAL_FLOW = ...
    FLOW_LIMIT = ...
    INLET_LOSS = ...
    OUTLET_LOSS = ...
    AVERAGE_LOSS = ...
    SEEPAGE_RATE = ...
    HAS_FLAPGATE = ...
    POLLUTANT_CONCENTRATION = ...
    POLLUTANT_LOAD = ...
    POLLUTANT_LATERAL_MASS_FLUX = ...


class SWMMLinkTypes(Enum):
    """
    Enumeration of SWMM link types.

    :ivar CONDUIT: Conduit link
    :type CONDUIT: int
    :ivar PUMP: Pump link
    :type PUMP: int
    :ivar ORIFICE: Orifice link
    :type ORIFICE: int
    :ivar WEIR: Weir link
    :type WEIR: int
    :ivar OUTLET: Outlet link
    :type OUTLET: int
    """
    CONDUIT = ...
    PUMP = ...
    ORIFICE = ...
    WEIR = ...
    OUTLET = ...


class SWMMSystemProperties(Enum):
    """
    Enumeration of SWMM system properties.

    :ivar START_DATE: Start date for the simulation
    :type START_DATE: int
    :ivar CURRENT_DATE: Current date for the simulation
    :type CURRENT_DATE: int
    :ivar ELAPSED_TIME: Elapsed time for the simulation
    :type ELAPSED_TIME: int
    :ivar ROUTING_STEP: Routing time step
    :type ROUTING_STEP: int
    :ivar MAX_ROUTING_STEP: Maximum routing time step
    :type MAX_ROUTING_STEP: int
    :ivar REPORT_STEP: Report time step
    :type REPORT_STEP: int
    :ivar TOTAL_STEPS: Total number of steps
    :type TOTAL_STEPS: int
    :ivar NO_REPORT_FLAG: No report flag
    :type NO_REPORT_FLAG: int
    :ivar FLOW_UNITS: Flow units
    :type FLOW_UNITS: int
    :ivar END_DATE: End date for the simulation
    :type END_DATE: int
    :ivar REPORT_START_DATE: Report start date
    :type REPORT_START_DATE: int
    :ivar UNIT_SYSTEM: Unit system
    :type UNIT_SYSTEM: int
    :ivar SURCHARGE_METHOD: Surcharge method
    :type SURCHARGE_METHOD: int
    :ivar ALLOW_PONDING: Allow ponding
    :type ALLOW_PONDING: int
    :ivar INTERTIAL_DAMPING: Inertial damping
    :type INTERTIAL_DAMPING: int
    :ivar NORMAL_FLOW_LIMITED: Normal flow limited
    :type NORMAL_FLOW_LIMITED: int
    :ivar SKIP_STEADY_STATE: Skip steady state
    :type SKIP_STEADY_STATE: int
    :ivar IGNORE_RAINFALL: Ignore rainfall
    :type IGNORE_RAINFALL: int
    :ivar IGNORE_RDII: Ignore RDII
    :type IGNORE_RDII: int
    :ivar IGNORE_SNOWMELT: Ignore snowmelt
    :type IGNORE_SNOWMELT: int
    :ivar IGNORE_GROUNDWATER: Ignore groundwater
    :type IGNORE_GROUNDWATER: int
    :ivar IGNORE_ROUTING: Ignore routing
    :type IGNORE_ROUTING: int
    :ivar IGNORE_QUALITY: Ignore quality
    :type IGNORE_QUALITY: int
    :ivar RULE_STEP: Rule step
    :type RULE_STEP: int
    :ivar SWEEP_START: Sweep start
    :type SWEEP_START: int
    :ivar SWEEP_END: Sweep end
    :type SWEEP_END: int
    :ivar MAX_TRIALS: Maximum trials
    :type MAX_TRIALS: int
    :ivar NUM_THREADS: Number of threads
    :type NUM_THREADS: int
    :ivar MIN_ROUTE_STEP: Minimum routing step
    :type MIN_ROUTE_STEP: int
    :ivar LENGTHENING_STEP: Lengthening step
    :type LENGTHENING_STEP: int
    :ivar START_DRY_DAYS: Start dry days
    :type START_DRY_DAYS: int
    :ivar COURANT_FACTOR: Courant factor
    :type COURANT_FACTOR: int
    :ivar MIN_SURF_AREA: Minimum surface area
    :type MIN_SURF_AREA: int
    :ivar MIN_SLOPE: Minimum slope
    :type MIN_SLOPE: int
    :ivar RUNOFF_ERROR: Runoff error
    :type RUNOFF_ERROR: int
    :ivar FLOW_ERROR: Flow error
    :type FLOW_ERROR: int
    :ivar QUAL_ERROR: Quality error
    :type QUAL_ERROR: int
    :ivar HEAD_TOL: Head tolerance
    :type HEAD_TOL: int
    :ivar SYS_FLOW_TOL: System flow tolerance
    :type SYS_FLOW_TOL: int
    :ivar LAT_FLOW_TOL: Lateral flow tolerance
    :type LAT_FLOW_TOL: int

    """
    START_DATE = ...
    CURRENT_DATE = ...
    ELAPSED_TIME = ...
    ROUTING_STEP = ...
    MAX_ROUTING_STEP = ...
    REPORT_STEP = ...
    TOTAL_STEPS = ...
    NO_REPORT_FLAG = ...
    FLOW_UNITS = ...
    END_DATE = ...
    REPORT_START_DATE = ...
    UNIT_SYSTEM = ...
    SURCHARGE_METHOD = ...
    ALLOW_PONDING = ...
    INTERTIAL_DAMPING = ...
    NORMAL_FLOW_LIMITED = ...
    SKIP_STEADY_STATE = ...
    IGNORE_RAINFALL = ...
    IGNORE_RDII = ...
    IGNORE_SNOWMELT = ...
    IGNORE_GROUNDWATER = ...
    IGNORE_ROUTING = ...
    IGNORE_QUALITY = ...
    ERROR_CODE = ...
    RULE_STEP = ...
    SWEEP_START = ...
    SWEEP_END = ...
    MAX_TRIALS = ...
    NUM_THREADS = ...
    MIN_ROUTE_STEP = ...
    LENGTHENING_STEP = ...
    START_DRY_DAYS = ...
    COURANT_FACTOR = ...
    MIN_SURF_AREA = ...
    MIN_SLOPE = ...
    RUNOFF_ERROR = ...
    FLOW_ERROR = ...
    QUAL_ERROR = ...
    HEAD_TOL = ...
    SYS_FLOW_TOL = ...
    LAT_FLOW_TOL = ...


class SWMMFlowUnits(Enum):
    """
    Enumeration of SWMM flow units.

    :ivar CFS: Cubic feet per second
    :type CFS: int
    :ivar GPM: Gallons per minute
    :type GPM: int
    :ivar MGD: Million gallons per day
    :type MGD: int
    :ivar CMS: Cubic meters per second
    :type CMS: int
    :ivar LPS: Liters per second
    :type LPS: int
    :ivar MLD: Million liters per day
    :type MLD: int
    """
    CFS = ...
    GPM = ...
    MGD = ...
    CMS = ...
    LPS = ...
    MLD = ...


class SWMMAPIErrors(Enum):
    """
    Enumeration of SWMM API errors.

    :ivar PROJECT_NOT_OPENED: Project not opened
    :type PROJECT_NOT_OPENED: int
    :ivar SIMULATION_NOT_STARTED: Simulation not started
    :type SIMULATION_NOT_STARTED: int
    :ivar SIMULATION_NOT_ENDED: Simulation not ended
    :type SIMULATION_NOT_ENDED: int    
    """
    PROJECT_NOT_OPENED = ...
    SIMULATION_NOT_STARTED = ...
    SIMULATION_NOT_ENDED = ...
    OBJECT_TYPE = ...
    OBJECT_INDEX = ...
    OBJECT_NAME = ...
    PROPERTY_TYPE = ...
    PROPERTY_VALUE = ...
    TIME_PERIOD = ...
    HOTSTART_FILE_OPEN = ...
    HOTSTART_FILE_FORMAT = ...
    SIMULATION_IS_RUNNING = ...


def run_solver(inp_file: str, rpt_file: str, out_file: str, swmm_progress_callback: Callable[[float], None] = ...) -> int:
    """
    Run a SWMM simulation with a progress callback.

    :param inp_file: Input file name
    :param rpt_file: Report file name
    :param out_file: Output file name
    :param progress_callback: Progress callback function
    :type progress_callback: callable
    :return: Error code (0 if successful)
    """
    ...

def decode_swmm_datetime(swmm_datetime: float) -> Any:
    """
    Decode a SWMM datetime into a datetime object.
    
    :param swmm_datetime: SWMM datetime float value
    :type swmm_datetime: float
    :return: datetime object
    :rtype: datetime
    """
    ...

def encode_swmm_datetime(dt: Any) -> float:
    """
    Encode a datetime object into a SWMM datetime float value.

    :param dt: datetime object
    :type dt: datetime
    :return: SWMM datetime float value
    :rtype: float
    """
    ...

def version() -> int:
    """
    Get the SWMM version.
    
    :return: SWMM version
    :rtype: str
    """
    ...

def get_error_message(error_code: int) -> str:
    """
    Get the error message for a SWMM error code.
    
    :param error_code: Error code
    :type error_code: int
    :return: Error message
    :rtype: str
    """
    ...

class SolverState(Enum):
    """
    An enumeration to represent the state of the solver.
    """
    CREATED = ...
    OPEN = ...
    STARTED = ...
    FINISHED = ...
    ENDED = ...
    REPORTED = ...
    CLOSED = ...


class CallbackType(Enum):
    """
    An enumeration to represent the type of callback.
    """
    BEFORE_INITIALIZE = ...
    BEFORE_OPEN = ...
    AFTER_OPEN = ...
    BEFORE_START = ...
    AFTER_START = ...
    BEFORE_STEP = ...
    AFTER_STEP = ...
    BEFORE_END = ...
    AFTER_END = ...
    BEFORE_REPORT = ...
    AFTER_REPORT = ...
    BEFORE_CLOSE = ...
    AFTER_CLOSE = ...


class SWMMSolverException(Exception):
    """
    Exception class for SWMM output file processing errors.
    """
    def __init__(self, message: str) -> None:
        """
        Constructor to initialize the exception message.

        :param message: Error message.
        :type message: str
        """
        ...
    


class Solver:
    """
    A class to represent a SWMM solver.
    """

    def __init__(self, inp_file: str, rpt_file: str, out_file: str) -> None:
        """
        Constructor to initialize the SWMM solver.

        :param inp_file: Input file name
        :param rpt_file: Report file name
        :param out_file: Output file name
        """
        ...

    def __enter__(self): # -> Self@Solver:
        """
        Enter method for context manager.
        """
        ...
    
    def __exit__(self, exc_type, exc_value, traceback): # -> None:
        """
        Exit method for context manager.
        """
        ...
    
    def __iter__(self): # -> Self@Solver:
        """
        Iterator method for the solver.
        """
        ...
    
    def __next__(self): # -> double:
        """
        Next method for the solver.
        """
        ...
    
    @property
    def start_datetime(self) -> Any:
        """
        Get the start date of the simulation.
        
        :return: Start date
        :rtype: datetime
        """
        ...
    
    @start_datetime.setter
    def start_datetime(self, sim_start_datetime: Any) -> None:
        """
        Initialize the solver.
        
        :param sim_start_datetime: Start date of the simulation
        :return: Error code (0 if successful)
        """
        ...
    
    @property
    def end_datetime(self) -> Any:
        """
        Get the end date of the simulation.
        
        :return: End date
        :rtype: datetime
        """
        ...
    
    @end_datetime.setter
    def end_datetime(self, sim_end_datetime: Any) -> None:
        """
        Set the end date of the simulation.
        
        :param sim_end_datetime: End date of the simulation
        :return: Error code (0 if successful)
        """
        ...
    
    @property
    def routing_step(self) -> float:
        """
        Get the routing time step of the simulation in seconds.
        
        :return: Routing time step
        :rtype: double
        """
        ...
    
    @routing_step.setter
    def routing_step(self, value: float) -> None:
        """
        Set the routing time step of the simulation in seconds.
        
        :param value: Routing time step in seconds
        :type value: float
        """
        ...
    
    @property
    def reporting_step(self) -> float:
        """
        Get the reporting time step of the simulation in seconds.
        
        :return: Reporting time step
        :rtype: double
        """
        ...
    
    @reporting_step.setter
    def reporting_step(self, value: float) -> None:
        """
        Set the reporting time step of the simulation in seconds.
        
        :param value: Reporting time step in seconds
        :type value: float
        """
        ...
    
    @property
    def report_start_datetime(self) -> Any:
        """
        Get the report start date of the simulation.
        
        :return: Report start date
        :rtype: datetime
        """
        ...
    
    @report_start_datetime.setter
    def report_start_datetime(self, report_start_datetime: Any) -> None:
        """
        Set the report start date of the simulation.
        
        :param report_start_datetime: Report start date
        :type report_start_datetime: datetime
        """
        ...
    
    @property
    def current_datetime(self) -> Any:
        """
        Get the current date of the simulation.
        
        :return: Current date
        :rtype: datetime
        """
        ...
    
    def get_object_count(self, object_type: SWMMObjects) -> int:
        """
        Get the count of a SWMM object type.
        
        :param object_type: SWMM object type
        :type object_type: SWMMObjects
        :return: Object count
        :rtype: int
        """
        ...
    
    def get_object_name(self, object_type: SWMMObjects, index: int) -> str:
        """
        Get the name of a SWMM object.
        
        :param object_type: SWMM object type
        :type object_type: SWMMObjects
        :param index: Object index
        :type index: int
        :return: Object name
        :rtype: str
        """
        ...
    
    def get_object_names(self, object_type: SWMMObjects) -> List[str]:
        """
        Get the names of all SWMM objects of a given type.
        
        :param object_type: SWMM object type
        :type object_type: SWMMObjects
        :return: Object names
        :rtype: List[str]
        """
        ...
    
    def get_object_index(self, object_type: SWMMObjects, object_name: str) -> int:
        """
        Get the index of a SWMM object.
        
        :param object_type: SWMM object type
        :type object_type: SWMMObjects
        :param object_name: Object name
        :type object_name: str
        :return: Object index
        :rtype: int
        """
        ...
    
    def set_value(self, object_type: SWMMObjects, property_type: Union[SWMMRainGageProperties, SWMMSubcatchmentProperties, SWMMNodeProperties, SWMMLinkProperties, SWMMSystemProperties], index: int, value: double, sub_index: int = ...) -> None:
        """
        Set a SWMM system property value.
        
        :param object_type: SWMM object type (e.g., SWMMObjects.NODE)
        :type object_type: SWMMObjects 
        :param property_type: SWMM system property type (e.g., SWMMSystemProperties.START_DATE)
        :type property_type: Union[SWMMRainGageProperties, SWMMSubcatchmentProperties, SWMMNodeProperties, SWMMLinkProperties, SWMMSystemProperties]
        :param index: Object index (e.g., 0)
        :type index: int
        :param value: Property value (e.g., 10.0)
        :type value: double
        :param sub_index: Sub-index (e.g., 0) for properties with sub-indexes. For example pollutant index for POLLUTANT properties.
        :type sub_index: int
        """
        ...
    
    def get_value(self, object_type: SWMMObjects, property_type: Union[SWMMRainGageProperties, SWMMSubcatchmentProperties, SWMMNodeProperties, SWMMLinkProperties, SWMMSystemProperties], index: int, sub_index: int = ...) -> double:
        """
        Get a SWMM system property value.
        
        :param object_type: SWMM object type (e.g., SWMMObjects.NODE)
        :type object_type: SWMMObjects
        :param property_type: SWMM system property type (e.g., SWMMSystemProperties.START_DATE)
        :type property_type: Union[SWMMRainGageProperties, SWMMSubcatchmentProperties, SWMMNodeProperties, SWMMLinkProperties, SWMMSystemProperties]
        :param index: Object index (e.g., 0)
        :type index: int
        :param sub_index: Sub-index (e.g., 0) for properties with sub-indexes. For example pollutant index for POLLUTANT properties.
        :type sub_index: int
        :return: Property value
        :rtype: double
        """
        ...
    
    @property
    def stride_step(self) -> int:
        """
        Get the stride step of the simulation.
        
        :return: Stride step
        :rtype: int
        """
        ...
    
    @stride_step.setter
    def stride_step(self, value: int): # -> None:
        """
        Set the stride time step of the simulation.
        
        :param value: Stride step in seconds
        :type value: int
        """
        ...
    
    @property
    def solver_state(self) -> SolverState:
        """
        Get the state of the solver.
        
        :return: Solver state
        :rtype: SolverState
        """
        ...
    
    def add_callback(self, callback_type: CallbackType, callback: Callable[[Solver], None]) -> None:
        """
        Add a callback to the solver.
        
        :param callback_type: Type of callback
        :type callback_type: CallbackType
        :param callback: Callback function
        :type callback: callable
        """
        ...
    
    def add_progress_callback(self, callback: Callable[[double], None]) -> None:
        """
        Add a progress callback to the solver.
        
        :param callback: Progress callback function
        :type callback: callable
        """
        ...
    
    def initialize(self) -> Any:
        """
        Initialize the solver.
        
        :param inp_file: Input file name
        :param rpt_file: Report file name
        :param out_file: Output file name

        """
        ...
    
    def step(self) -> float:
        """
        Step a SWMM simulation.
        
        :return: elapsed_time, current_date
        :rtype: Tuple[float, datetime]
        """
        ...
    
    def finalize(self) -> Any:
        """
        Finalize the solver.
        """
        ...
    
    def execute(self) -> Any:
        """
        Run the solver to completion.
        
        :return: Error code (0 if successful)
        """
        ...
    
    def use_hotstart(self, hotstart_file: str) -> Any:
        """
        Use a hotstart file.
        
        :param hotstart_file: Hotstart file name
        """
        ...
    
    def save_hotstart(self, hotstart_file: str) -> Any:
        """
        Save a hotstart file.
        
        :param hotstart_file: Hotstart file name
        """
        ...
    
    def get_mass_balance_error(self) -> Tuple[float, float, float]:
        """
        Get the mass balance error.
        
        :return: Mass balance error
        :rtype: Tuple[float, float, float]
        """
        ...
    


