# Ethercram

Get all transactions from Etherscan direct to a simple spreadsheet.

## Searches supported

More functionality will be added on eventually. For now it can pull.
* Ethereum transactions by address
* ERC20 transactions by address

## Getting started

The easiest way to use this tool is to download it from pip.

```
pip install ethercram
```

It requires python 3.10 or later.

To use the command line scraping tools, you must include API credentials in a config file. Edit config.json to include your Etherscan authentication token.

Need help getting your token, instructions to create an account and generate a token can be found in the [Etherscan API documentation](https://docs.etherscan.io/getting-started/creating-an-account).

## Usage

`ethercram eth -w 0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045 -p 2017-01-01 -r 2018-01-01` Scrapes the transaction history of Vitalik Buterin to an autogenerated filename in your current path for transactions during the year 2017.

`ethercram eth -w 0x0000000000000000000000000000000000000000 -b 0 -k 1000000 -o black_hole.csv` Crosses the event horizon to see the erc20s sent to the black hole address during the first million blocks to a csv called "black_hole.csv".

Remember to set the location of your config file that has your api key with the --config or -c flag! The config is a small json and you can download the tempalte [here](https://gitlab.com/GoodLuckHF/ethercram/-/blob/main/ethercram/config.json).