"""
These flags are defined in ``wgpu.flags``, but are also available from the root wgpu namespace.

Flags are bitmasks; zero or multiple fields can be set at the same time.
Flags are integer bitmasks, but can also be passed as strings, so instead of
``wgpu.BufferUsage.MAP_READ | wgpu.BufferUsage.COPY_DST``,
one can also write ``"MAP_READ|COPY_DIST"``.
"""

_use_sphinx_repr = False


class Flags:
    def __init__(self, name, **kwargs):
        self._name = name
        for key, val in kwargs.items():
            setattr(self, key, val)

    def __iter__(self):
        return iter([key for key in dir(self) if not key.startswith("_")])

    def __repr__(self):
        if _use_sphinx_repr:  # no-cover
            return ""
        values = ", ".join(self)
        return f"<wgpu.{self._name} flags with values: {values}>"


# CODE BELOW THIS POINT IS AUTOGENERATED - DO NOT EDIT


# There are 5 flags

__all__ = [
    "BufferUsage",
    "MapMode",
    "TextureUsage",
    "ShaderStage",
    "ColorWrite",
]


#: * "MAP_READ" (1)
#: * "MAP_WRITE" (2)
#: * "COPY_SRC" (4)
#: * "COPY_DST" (8)
#: * "INDEX" (16)
#: * "VERTEX" (32)
#: * "UNIFORM" (64)
#: * "STORAGE" (128)
#: * "INDIRECT" (256)
#: * "QUERY_RESOLVE" (512)
BufferUsage = Flags(
    "BufferUsage",
    MAP_READ=1,
    MAP_WRITE=2,
    COPY_SRC=4,
    COPY_DST=8,
    INDEX=16,
    VERTEX=32,
    UNIFORM=64,
    STORAGE=128,
    INDIRECT=256,
    QUERY_RESOLVE=512,
)

#: * "READ" (1)
#: * "WRITE" (2)
MapMode = Flags(
    "MapMode",
    READ=1,
    WRITE=2,
)

#: * "COPY_SRC" (1)
#: * "COPY_DST" (2)
#: * "TEXTURE_BINDING" (4)
#: * "STORAGE_BINDING" (8)
#: * "RENDER_ATTACHMENT" (16)
TextureUsage = Flags(
    "TextureUsage",
    COPY_SRC=1,
    COPY_DST=2,
    TEXTURE_BINDING=4,
    STORAGE_BINDING=8,
    RENDER_ATTACHMENT=16,
)

#: * "VERTEX" (1)
#: * "FRAGMENT" (2)
#: * "COMPUTE" (4)
ShaderStage = Flags(
    "ShaderStage",
    VERTEX=1,
    FRAGMENT=2,
    COMPUTE=4,
)

#: * "RED" (1)
#: * "GREEN" (2)
#: * "BLUE" (4)
#: * "ALPHA" (8)
#: * "ALL" (15)
ColorWrite = Flags(
    "ColorWrite",
    RED=1,
    GREEN=2,
    BLUE=4,
    ALPHA=8,
    ALL=15,
)
