import { Reference } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Represents an assertions provider. The creates a singletone
 * Lambda Function that will create a single function per stack
 * that serves as the custom resource provider for the various
 * assertion providers
 */
export declare class AssertionsProvider extends Construct {
    /**
     * The ARN of the lambda function which can be used
     * as a serviceToken to a CustomResource
     */
    readonly serviceToken: string;
    /**
     * A reference to the provider Lambda Function
     * execution Role ARN
     */
    readonly handlerRoleArn: Reference;
    private readonly policies;
    private readonly handler;
    constructor(scope: Construct, id: string);
    /**
     * Encode an object so it can be passed
     * as custom resource parameters. Custom resources will convert
     * all input parameters to strings so we encode non-strings here
     * so we can then decode them correctly in the provider function
     */
    encode(obj: any): any;
    /**
     * Create a policy statement from a specific api call
     */
    addPolicyStatementFromSdkCall(service: string, api: string, resources?: string[]): void;
}
