# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import proto  # type: ignore


__protobuf__ = proto.module(
    package="google.cloud.compute.v1",
    manifest={
        "AcceleratorConfig",
        "DeprecationStatus",
        "AcceleratorType",
        "AcceleratorTypesScopedList",
        "Data",
        "Warning",
        "AcceleratorTypeAggregatedList",
        "AcceleratorTypeList",
        "AccessConfig",
        "Address",
        "AddressesScopedList",
        "AddressAggregatedList",
        "AddressList",
        "AdvancedMachineFeatures",
        "AliasIpRange",
        "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
        "AllocationSpecificSKUAllocationReservedInstanceProperties",
        "AllocationSpecificSKUReservation",
        "CustomerEncryptionKey",
        "GuestOsFeature",
        "AttachedDiskInitializeParams",
        "InitialStateConfig",
        "AttachedDisk",
        "AuditLogConfig",
        "AuditConfig",
        "AuthorizationLoggingOptions",
        "AutoscalingPolicy",
        "ScalingScheduleStatus",
        "AutoscalerStatusDetails",
        "Autoscaler",
        "AutoscalersScopedList",
        "AutoscalerAggregatedList",
        "AutoscalerList",
        "AutoscalingPolicyCpuUtilization",
        "AutoscalingPolicyCustomMetricUtilization",
        "AutoscalingPolicyLoadBalancingUtilization",
        "AutoscalingPolicyScaleInControl",
        "AutoscalingPolicyScalingSchedule",
        "FixedOrPercent",
        "Backend",
        "BackendBucketCdnPolicy",
        "BackendBucket",
        "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
        "BackendBucketCdnPolicyNegativeCachingPolicy",
        "BackendBucketList",
        "BackendServiceCdnPolicy",
        "CircuitBreakers",
        "ConnectionDraining",
        "ConsistentHashLoadBalancerSettings",
        "BackendServiceFailoverPolicy",
        "BackendServiceIAP",
        "BackendServiceLogConfig",
        "Duration",
        "OutlierDetection",
        "SecuritySettings",
        "BackendService",
        "BackendServicesScopedList",
        "BackendServiceAggregatedList",
        "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
        "CacheKeyPolicy",
        "BackendServiceCdnPolicyNegativeCachingPolicy",
        "HealthStatus",
        "BackendServiceGroupHealth",
        "BackendServiceList",
        "BackendServiceReference",
        "Expr",
        "Binding",
        "InstanceProperties",
        "LocationPolicy",
        "BulkInsertInstanceResourcePerInstanceProperties",
        "BulkInsertInstanceResource",
        "CacheInvalidationRule",
        "LicenseResourceCommitment",
        "Reservation",
        "ResourceCommitment",
        "Commitment",
        "CommitmentsScopedList",
        "CommitmentAggregatedList",
        "CommitmentList",
        "Condition",
        "ConfidentialInstanceConfig",
        "ConsistentHashLoadBalancerSettingsHttpCookie",
        "CorsPolicy",
        "CustomerEncryptionKeyProtectedDisk",
        "Disk",
        "DisksScopedList",
        "DiskAggregatedList",
        "DiskInstantiationConfig",
        "DiskList",
        "DiskMoveRequest",
        "DiskType",
        "DiskTypesScopedList",
        "DiskTypeAggregatedList",
        "DiskTypeList",
        "DisksAddResourcePoliciesRequest",
        "DisksRemoveResourcePoliciesRequest",
        "DisksResizeRequest",
        "DisplayDevice",
        "DistributionPolicyZoneConfiguration",
        "DistributionPolicy",
        "ExchangedPeeringRoute",
        "ExchangedPeeringRoutesList",
        "ExternalVpnGatewayInterface",
        "ExternalVpnGateway",
        "ExternalVpnGatewayList",
        "FileContentBuffer",
        "Allowed",
        "Denied",
        "FirewallLogConfig",
        "Firewall",
        "FirewallList",
        "FirewallPolicyAssociation",
        "FirewallPoliciesListAssociationsResponse",
        "FirewallPolicyRule",
        "FirewallPolicy",
        "FirewallPolicyList",
        "FirewallPolicyRuleMatcher",
        "FirewallPolicyRuleMatcherLayer4Config",
        "MetadataFilter",
        "ForwardingRuleServiceDirectoryRegistration",
        "ForwardingRule",
        "ForwardingRulesScopedList",
        "ForwardingRuleAggregatedList",
        "ForwardingRuleList",
        "ForwardingRuleReference",
        "GRPCHealthCheck",
        "NetworkEndpoint",
        "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
        "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
        "Policy",
        "GlobalOrganizationSetPolicyRequest",
        "GlobalSetLabelsRequest",
        "GlobalSetPolicyRequest",
        "GuestAttributesValue",
        "GuestAttributes",
        "GuestAttributesEntry",
        "HTTP2HealthCheck",
        "HTTPHealthCheck",
        "HTTPSHealthCheck",
        "HealthCheckLogConfig",
        "SSLHealthCheck",
        "TCPHealthCheck",
        "HealthCheck",
        "HealthCheckList",
        "HealthCheckReference",
        "HealthCheckService",
        "HealthCheckServiceReference",
        "HealthCheckServicesList",
        "HealthChecksScopedList",
        "HealthChecksAggregatedList",
        "HealthStatusForNetworkEndpoint",
        "HostRule",
        "HttpFaultAbort",
        "HttpFaultDelay",
        "HttpFaultInjection",
        "HttpHeaderOption",
        "HttpHeaderAction",
        "Int64RangeMatch",
        "HttpHeaderMatch",
        "HttpQueryParameterMatch",
        "HttpRedirectAction",
        "HttpRetryPolicy",
        "RequestMirrorPolicy",
        "UrlRewrite",
        "WeightedBackendService",
        "HttpRouteAction",
        "HttpRouteRuleMatch",
        "HttpRouteRule",
        "RawDisk",
        "Image",
        "ImageList",
        "Metadata",
        "NetworkInterface",
        "ReservationAffinity",
        "Scheduling",
        "ServiceAccount",
        "ShieldedInstanceConfig",
        "ShieldedInstanceIntegrityPolicy",
        "Tags",
        "Instance",
        "InstancesScopedList",
        "InstanceAggregatedList",
        "NamedPort",
        "InstanceGroup",
        "InstanceGroupsScopedList",
        "InstanceGroupAggregatedList",
        "InstanceGroupList",
        "InstanceGroupManagerAutoHealingPolicy",
        "InstanceGroupManagerActionsSummary",
        "StatefulPolicy",
        "InstanceGroupManagerStatus",
        "InstanceGroupManagerUpdatePolicy",
        "InstanceGroupManagerVersion",
        "InstanceGroupManager",
        "InstanceGroupManagersScopedList",
        "InstanceGroupManagerAggregatedList",
        "InstanceGroupManagerList",
        "InstanceGroupManagerStatusStateful",
        "InstanceGroupManagerStatusVersionTarget",
        "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
        "InstanceGroupManagersAbandonInstancesRequest",
        "InstanceGroupManagersApplyUpdatesRequest",
        "PerInstanceConfig",
        "InstanceGroupManagersCreateInstancesRequest",
        "InstanceGroupManagersDeleteInstancesRequest",
        "InstanceGroupManagersDeletePerInstanceConfigsReq",
        "InstanceManagedByIgmError",
        "InstanceGroupManagersListErrorsResponse",
        "ManagedInstance",
        "InstanceGroupManagersListManagedInstancesResponse",
        "InstanceGroupManagersListPerInstanceConfigsResp",
        "InstanceGroupManagersPatchPerInstanceConfigsReq",
        "InstanceGroupManagersRecreateInstancesRequest",
        "InstanceGroupManagersSetInstanceTemplateRequest",
        "InstanceGroupManagersSetTargetPoolsRequest",
        "InstanceGroupManagersUpdatePerInstanceConfigsReq",
        "InstanceReference",
        "InstanceGroupsAddInstancesRequest",
        "InstanceWithNamedPorts",
        "InstanceGroupsListInstances",
        "InstanceGroupsListInstancesRequest",
        "InstanceGroupsRemoveInstancesRequest",
        "InstanceGroupsSetNamedPortsRequest",
        "InstanceList",
        "Reference",
        "InstanceListReferrers",
        "InstanceManagedByIgmErrorManagedInstanceError",
        "InstanceManagedByIgmErrorInstanceActionDetails",
        "ManagedInstanceVersion",
        "InstanceMoveRequest",
        "SourceInstanceParams",
        "InstanceTemplate",
        "InstanceTemplateList",
        "InstancesAddResourcePoliciesRequest",
        "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "InstancesGetEffectiveFirewallsResponse",
        "InstancesRemoveResourcePoliciesRequest",
        "InstancesSetLabelsRequest",
        "InstancesSetMachineResourcesRequest",
        "InstancesSetMachineTypeRequest",
        "InstancesSetMinCpuPlatformRequest",
        "InstancesSetServiceAccountRequest",
        "InstancesStartWithEncryptionKeyRequest",
        "InterconnectCircuitInfo",
        "InterconnectOutageNotification",
        "Interconnect",
        "InterconnectAttachmentPartnerMetadata",
        "InterconnectAttachmentPrivateInfo",
        "InterconnectAttachment",
        "InterconnectAttachmentsScopedList",
        "InterconnectAttachmentAggregatedList",
        "InterconnectAttachmentList",
        "InterconnectDiagnosticsARPEntry",
        "InterconnectDiagnosticsLinkStatus",
        "InterconnectDiagnostics",
        "InterconnectDiagnosticsLinkLACPStatus",
        "InterconnectDiagnosticsLinkOpticalPower",
        "InterconnectList",
        "InterconnectLocationRegionInfo",
        "InterconnectLocation",
        "InterconnectLocationList",
        "InterconnectsGetDiagnosticsResponse",
        "LicenseResourceRequirements",
        "License",
        "LicenseCodeLicenseAlias",
        "LicenseCode",
        "LicensesListResponse",
        "LocalDisk",
        "LocationPolicyLocation",
        "LogConfigCloudAuditOptions",
        "LogConfigCounterOptions",
        "LogConfigDataAccessOptions",
        "LogConfig",
        "LogConfigCounterOptionsCustomField",
        "Accelerators",
        "ScratchDisks",
        "MachineType",
        "MachineTypesScopedList",
        "MachineTypeAggregatedList",
        "MachineTypeList",
        "ManagedInstanceInstanceHealth",
        "ManagedInstanceLastAttempt",
        "PreservedState",
        "Errors",
        "Items",
        "MetadataFilterLabelMatch",
        "NetworkPeering",
        "NetworkRoutingConfig",
        "Network",
        "NetworkEndpointGroupAppEngine",
        "NetworkEndpointGroupCloudFunction",
        "NetworkEndpointGroupCloudRun",
        "NetworkEndpointGroup",
        "NetworkEndpointGroupsScopedList",
        "NetworkEndpointGroupAggregatedList",
        "NetworkEndpointGroupList",
        "NetworkEndpointGroupsAttachEndpointsRequest",
        "NetworkEndpointGroupsDetachEndpointsRequest",
        "NetworkEndpointGroupsListEndpointsRequest",
        "NetworkEndpointWithHealthStatus",
        "NetworkEndpointGroupsListNetworkEndpoints",
        "NetworkList",
        "NetworksAddPeeringRequest",
        "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "NetworksGetEffectiveFirewallsResponse",
        "NetworksRemovePeeringRequest",
        "NetworksUpdatePeeringRequest",
        "NodeGroupAutoscalingPolicy",
        "NodeGroupMaintenanceWindow",
        "NodeGroup",
        "NodeGroupsScopedList",
        "NodeGroupAggregatedList",
        "NodeGroupList",
        "ServerBinding",
        "NodeGroupNode",
        "NodeGroupsAddNodesRequest",
        "NodeGroupsDeleteNodesRequest",
        "NodeGroupsListNodes",
        "NodeGroupsSetNodeTemplateRequest",
        "NodeTemplateNodeTypeFlexibility",
        "NodeTemplate",
        "NodeTemplatesScopedList",
        "NodeTemplateAggregatedList",
        "NodeTemplateList",
        "NodeType",
        "NodeTypesScopedList",
        "NodeTypeAggregatedList",
        "NodeTypeList",
        "NotificationEndpointGrpcSettings",
        "NotificationEndpoint",
        "NotificationEndpointList",
        "Error",
        "Warnings",
        "Operation",
        "OperationsScopedList",
        "OperationAggregatedList",
        "OperationList",
        "PacketMirroringForwardingRuleInfo",
        "PacketMirroringFilter",
        "PacketMirroringMirroredResourceInfo",
        "PacketMirroringNetworkInfo",
        "PacketMirroring",
        "PacketMirroringsScopedList",
        "PacketMirroringAggregatedList",
        "PacketMirroringList",
        "PacketMirroringMirroredResourceInfoInstanceInfo",
        "PacketMirroringMirroredResourceInfoSubnetInfo",
        "PathRule",
        "PathMatcher",
        "Rule",
        "WafExpressionSet",
        "PreconfiguredWafSet",
        "PreservedStatePreservedDisk",
        "Quota",
        "UsageExportLocation",
        "Project",
        "XpnResourceId",
        "ProjectsDisableXpnResourceRequest",
        "ProjectsEnableXpnResourceRequest",
        "ProjectsGetXpnResources",
        "ProjectsListXpnHostsRequest",
        "ProjectsSetDefaultNetworkTierRequest",
        "PublicAdvertisedPrefixPublicDelegatedPrefix",
        "PublicAdvertisedPrefix",
        "PublicAdvertisedPrefixList",
        "PublicDelegatedPrefixPublicDelegatedSubPrefix",
        "PublicDelegatedPrefix",
        "PublicDelegatedPrefixesScopedList",
        "PublicDelegatedPrefixAggregatedList",
        "PublicDelegatedPrefixList",
        "Region",
        "RegionAutoscalerList",
        "RegionDiskTypeList",
        "RegionDisksAddResourcePoliciesRequest",
        "RegionDisksRemoveResourcePoliciesRequest",
        "RegionDisksResizeRequest",
        "RegionInstanceGroupList",
        "RegionInstanceGroupManagerDeleteInstanceConfigReq",
        "RegionInstanceGroupManagerList",
        "RegionInstanceGroupManagerPatchInstanceConfigReq",
        "RegionInstanceGroupManagerUpdateInstanceConfigReq",
        "RegionInstanceGroupManagersAbandonInstancesRequest",
        "RegionInstanceGroupManagersApplyUpdatesRequest",
        "RegionInstanceGroupManagersCreateInstancesRequest",
        "RegionInstanceGroupManagersDeleteInstancesRequest",
        "RegionInstanceGroupManagersListErrorsResponse",
        "RegionInstanceGroupManagersListInstanceConfigsResp",
        "RegionInstanceGroupManagersListInstancesResponse",
        "RegionInstanceGroupManagersRecreateRequest",
        "RegionInstanceGroupManagersSetTargetPoolsRequest",
        "RegionInstanceGroupManagersSetTemplateRequest",
        "RegionInstanceGroupsListInstances",
        "RegionInstanceGroupsListInstancesRequest",
        "RegionInstanceGroupsSetNamedPortsRequest",
        "RegionList",
        "RegionSetLabelsRequest",
        "RegionSetPolicyRequest",
        "RegionTargetHttpsProxiesSetSslCertificatesRequest",
        "UrlMap",
        "RegionUrlMapsValidateRequest",
        "ReservationsScopedList",
        "ReservationAggregatedList",
        "ReservationList",
        "ReservationsResizeRequest",
        "ResourceGroupReference",
        "ResourcePolicy",
        "ResourcePoliciesScopedList",
        "ResourcePolicyGroupPlacementPolicy",
        "ResourcePolicyInstanceSchedulePolicy",
        "ResourcePolicyResourceStatus",
        "ResourcePolicySnapshotSchedulePolicy",
        "ResourcePolicyAggregatedList",
        "ResourcePolicyDailyCycle",
        "ResourcePolicyHourlyCycle",
        "ResourcePolicyInstanceSchedulePolicySchedule",
        "ResourcePolicyList",
        "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
        "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
        "ResourcePolicySnapshotSchedulePolicySchedule",
        "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
        "ResourcePolicyWeeklyCycle",
        "ResourcePolicyWeeklyCycleDayOfWeek",
        "Route",
        "RouteList",
        "RouterBgp",
        "RouterBgpPeer",
        "RouterInterface",
        "RouterNat",
        "Router",
        "RouterAdvertisedIpRange",
        "RoutersScopedList",
        "RouterAggregatedList",
        "RouterList",
        "RouterNatLogConfig",
        "RouterNatSubnetworkToNat",
        "RouterStatusBgpPeerStatus",
        "RouterStatusNatStatus",
        "RouterStatus",
        "RouterStatusResponse",
        "RoutersPreviewResponse",
        "SchedulingNodeAffinity",
        "Screenshot",
        "SecurityPoliciesWafConfig",
        "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
        "SecurityPolicyRule",
        "SecurityPolicy",
        "SecurityPolicyList",
        "SecurityPolicyReference",
        "SecurityPolicyRuleMatcher",
        "SecurityPolicyRuleMatcherConfig",
        "SerialPortOutput",
        "ShieldedInstanceIdentityEntry",
        "ShieldedInstanceIdentity",
        "SignedUrlKey",
        "Snapshot",
        "SnapshotList",
        "SslCertificateManagedSslCertificate",
        "SslCertificateSelfManagedSslCertificate",
        "SslCertificate",
        "SslCertificatesScopedList",
        "SslCertificateAggregatedList",
        "SslCertificateList",
        "SslPolicy",
        "SslPoliciesList",
        "SslPoliciesListAvailableFeaturesResponse",
        "SslPolicyReference",
        "StatefulPolicyPreservedState",
        "StatefulPolicyPreservedStateDiskDevice",
        "SubnetworkLogConfig",
        "SubnetworkSecondaryRange",
        "Subnetwork",
        "SubnetworksScopedList",
        "SubnetworkAggregatedList",
        "SubnetworkList",
        "SubnetworksExpandIpCidrRangeRequest",
        "SubnetworksSetPrivateIpGoogleAccessRequest",
        "TargetGrpcProxy",
        "TargetGrpcProxyList",
        "TargetHttpProxy",
        "TargetHttpProxiesScopedList",
        "TargetHttpProxyAggregatedList",
        "TargetHttpProxyList",
        "TargetHttpsProxy",
        "TargetHttpsProxiesScopedList",
        "TargetHttpsProxiesSetQuicOverrideRequest",
        "TargetHttpsProxiesSetSslCertificatesRequest",
        "TargetHttpsProxyAggregatedList",
        "TargetHttpsProxyList",
        "TargetInstance",
        "TargetInstancesScopedList",
        "TargetInstanceAggregatedList",
        "TargetInstanceList",
        "TargetPool",
        "TargetPoolsScopedList",
        "TargetPoolAggregatedList",
        "TargetPoolInstanceHealth",
        "TargetPoolList",
        "TargetPoolsAddHealthCheckRequest",
        "TargetPoolsAddInstanceRequest",
        "TargetPoolsRemoveHealthCheckRequest",
        "TargetPoolsRemoveInstanceRequest",
        "TargetReference",
        "TargetSslProxiesSetBackendServiceRequest",
        "TargetSslProxiesSetProxyHeaderRequest",
        "TargetSslProxiesSetSslCertificatesRequest",
        "TargetSslProxy",
        "TargetSslProxyList",
        "TargetTcpProxiesSetBackendServiceRequest",
        "TargetTcpProxiesSetProxyHeaderRequest",
        "TargetTcpProxy",
        "TargetTcpProxyList",
        "TargetVpnGateway",
        "TargetVpnGatewaysScopedList",
        "TargetVpnGatewayAggregatedList",
        "TargetVpnGatewayList",
        "UrlMapTestHeader",
        "TestFailure",
        "TestPermissionsRequest",
        "TestPermissionsResponse",
        "UrlMapTest",
        "UrlMapList",
        "UrlMapReference",
        "UrlMapValidationResult",
        "UrlMapsScopedList",
        "UrlMapsAggregatedList",
        "UrlMapsValidateRequest",
        "UrlMapsValidateResponse",
        "UsableSubnetworkSecondaryRange",
        "UsableSubnetwork",
        "UsableSubnetworksAggregatedList",
        "VmEndpointNatMappingsInterfaceNatMappings",
        "VmEndpointNatMappings",
        "VmEndpointNatMappingsList",
        "VpnGatewayVpnGatewayInterface",
        "VpnGateway",
        "VpnGatewaysScopedList",
        "VpnGatewayAggregatedList",
        "VpnGatewayList",
        "VpnGatewayStatusVpnConnection",
        "VpnGatewayStatus",
        "VpnGatewayStatusHighAvailabilityRequirementState",
        "VpnGatewayStatusTunnel",
        "VpnGatewaysGetStatusResponse",
        "VpnTunnel",
        "VpnTunnelsScopedList",
        "VpnTunnelAggregatedList",
        "VpnTunnelList",
        "WafExpressionSetExpression",
        "XpnHostList",
        "Zone",
        "ZoneList",
        "ZoneSetLabelsRequest",
        "ZoneSetPolicyRequest",
        "AggregatedListAcceleratorTypesRequest",
        "GetAcceleratorTypeRequest",
        "ListAcceleratorTypesRequest",
        "AggregatedListAddressesRequest",
        "DeleteAddressRequest",
        "GetAddressRequest",
        "InsertAddressRequest",
        "ListAddressesRequest",
        "AggregatedListAutoscalersRequest",
        "DeleteAutoscalerRequest",
        "GetAutoscalerRequest",
        "InsertAutoscalerRequest",
        "ListAutoscalersRequest",
        "PatchAutoscalerRequest",
        "UpdateAutoscalerRequest",
        "AddSignedUrlKeyBackendBucketRequest",
        "DeleteBackendBucketRequest",
        "DeleteSignedUrlKeyBackendBucketRequest",
        "GetBackendBucketRequest",
        "InsertBackendBucketRequest",
        "ListBackendBucketsRequest",
        "PatchBackendBucketRequest",
        "UpdateBackendBucketRequest",
        "AddSignedUrlKeyBackendServiceRequest",
        "AggregatedListBackendServicesRequest",
        "DeleteBackendServiceRequest",
        "DeleteSignedUrlKeyBackendServiceRequest",
        "GetBackendServiceRequest",
        "GetHealthBackendServiceRequest",
        "InsertBackendServiceRequest",
        "ListBackendServicesRequest",
        "PatchBackendServiceRequest",
        "SetSecurityPolicyBackendServiceRequest",
        "UpdateBackendServiceRequest",
        "AggregatedListDiskTypesRequest",
        "GetDiskTypeRequest",
        "ListDiskTypesRequest",
        "AddResourcePoliciesDiskRequest",
        "AggregatedListDisksRequest",
        "CreateSnapshotDiskRequest",
        "DeleteDiskRequest",
        "GetDiskRequest",
        "GetIamPolicyDiskRequest",
        "InsertDiskRequest",
        "ListDisksRequest",
        "RemoveResourcePoliciesDiskRequest",
        "ResizeDiskRequest",
        "SetIamPolicyDiskRequest",
        "SetLabelsDiskRequest",
        "TestIamPermissionsDiskRequest",
        "DeleteExternalVpnGatewayRequest",
        "GetExternalVpnGatewayRequest",
        "InsertExternalVpnGatewayRequest",
        "ListExternalVpnGatewaysRequest",
        "SetLabelsExternalVpnGatewayRequest",
        "TestIamPermissionsExternalVpnGatewayRequest",
        "AddAssociationFirewallPolicyRequest",
        "AddRuleFirewallPolicyRequest",
        "CloneRulesFirewallPolicyRequest",
        "DeleteFirewallPolicyRequest",
        "GetFirewallPolicyRequest",
        "GetAssociationFirewallPolicyRequest",
        "GetIamPolicyFirewallPolicyRequest",
        "GetRuleFirewallPolicyRequest",
        "InsertFirewallPolicyRequest",
        "ListFirewallPoliciesRequest",
        "ListAssociationsFirewallPolicyRequest",
        "MoveFirewallPolicyRequest",
        "PatchFirewallPolicyRequest",
        "PatchRuleFirewallPolicyRequest",
        "RemoveAssociationFirewallPolicyRequest",
        "RemoveRuleFirewallPolicyRequest",
        "SetIamPolicyFirewallPolicyRequest",
        "TestIamPermissionsFirewallPolicyRequest",
        "DeleteFirewallRequest",
        "GetFirewallRequest",
        "InsertFirewallRequest",
        "ListFirewallsRequest",
        "PatchFirewallRequest",
        "UpdateFirewallRequest",
        "AggregatedListForwardingRulesRequest",
        "DeleteForwardingRuleRequest",
        "GetForwardingRuleRequest",
        "InsertForwardingRuleRequest",
        "ListForwardingRulesRequest",
        "PatchForwardingRuleRequest",
        "SetLabelsForwardingRuleRequest",
        "SetTargetForwardingRuleRequest",
        "DeleteGlobalAddressRequest",
        "GetGlobalAddressRequest",
        "InsertGlobalAddressRequest",
        "ListGlobalAddressesRequest",
        "DeleteGlobalForwardingRuleRequest",
        "GetGlobalForwardingRuleRequest",
        "InsertGlobalForwardingRuleRequest",
        "ListGlobalForwardingRulesRequest",
        "PatchGlobalForwardingRuleRequest",
        "SetLabelsGlobalForwardingRuleRequest",
        "SetTargetGlobalForwardingRuleRequest",
        "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "DeleteGlobalNetworkEndpointGroupRequest",
        "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "GetGlobalNetworkEndpointGroupRequest",
        "InsertGlobalNetworkEndpointGroupRequest",
        "ListGlobalNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
        "AggregatedListGlobalOperationsRequest",
        "DeleteGlobalOperationRequest",
        "DeleteGlobalOperationResponse",
        "GetGlobalOperationRequest",
        "ListGlobalOperationsRequest",
        "WaitGlobalOperationRequest",
        "DeleteGlobalOrganizationOperationRequest",
        "DeleteGlobalOrganizationOperationResponse",
        "GetGlobalOrganizationOperationRequest",
        "ListGlobalOrganizationOperationsRequest",
        "DeleteGlobalPublicDelegatedPrefixeRequest",
        "GetGlobalPublicDelegatedPrefixeRequest",
        "InsertGlobalPublicDelegatedPrefixeRequest",
        "ListGlobalPublicDelegatedPrefixesRequest",
        "PatchGlobalPublicDelegatedPrefixeRequest",
        "AggregatedListHealthChecksRequest",
        "DeleteHealthCheckRequest",
        "GetHealthCheckRequest",
        "InsertHealthCheckRequest",
        "ListHealthChecksRequest",
        "PatchHealthCheckRequest",
        "UpdateHealthCheckRequest",
        "DeleteImageRequest",
        "DeprecateImageRequest",
        "GetImageRequest",
        "GetFromFamilyImageRequest",
        "GetIamPolicyImageRequest",
        "InsertImageRequest",
        "ListImagesRequest",
        "PatchImageRequest",
        "SetIamPolicyImageRequest",
        "SetLabelsImageRequest",
        "TestIamPermissionsImageRequest",
        "AbandonInstancesInstanceGroupManagerRequest",
        "AggregatedListInstanceGroupManagersRequest",
        "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
        "CreateInstancesInstanceGroupManagerRequest",
        "DeleteInstanceGroupManagerRequest",
        "DeleteInstancesInstanceGroupManagerRequest",
        "DeletePerInstanceConfigsInstanceGroupManagerRequest",
        "GetInstanceGroupManagerRequest",
        "InsertInstanceGroupManagerRequest",
        "ListInstanceGroupManagersRequest",
        "ListErrorsInstanceGroupManagersRequest",
        "ListManagedInstancesInstanceGroupManagersRequest",
        "ListPerInstanceConfigsInstanceGroupManagersRequest",
        "PatchInstanceGroupManagerRequest",
        "PatchPerInstanceConfigsInstanceGroupManagerRequest",
        "RecreateInstancesInstanceGroupManagerRequest",
        "ResizeInstanceGroupManagerRequest",
        "SetInstanceTemplateInstanceGroupManagerRequest",
        "SetTargetPoolsInstanceGroupManagerRequest",
        "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
        "AddInstancesInstanceGroupRequest",
        "AggregatedListInstanceGroupsRequest",
        "DeleteInstanceGroupRequest",
        "GetInstanceGroupRequest",
        "InsertInstanceGroupRequest",
        "ListInstanceGroupsRequest",
        "ListInstancesInstanceGroupsRequest",
        "RemoveInstancesInstanceGroupRequest",
        "SetNamedPortsInstanceGroupRequest",
        "DeleteInstanceTemplateRequest",
        "GetInstanceTemplateRequest",
        "GetIamPolicyInstanceTemplateRequest",
        "InsertInstanceTemplateRequest",
        "ListInstanceTemplatesRequest",
        "SetIamPolicyInstanceTemplateRequest",
        "TestIamPermissionsInstanceTemplateRequest",
        "AddAccessConfigInstanceRequest",
        "AddResourcePoliciesInstanceRequest",
        "AggregatedListInstancesRequest",
        "AttachDiskInstanceRequest",
        "BulkInsertInstanceRequest",
        "DeleteInstanceRequest",
        "DeleteAccessConfigInstanceRequest",
        "DetachDiskInstanceRequest",
        "GetInstanceRequest",
        "GetEffectiveFirewallsInstanceRequest",
        "GetGuestAttributesInstanceRequest",
        "GetIamPolicyInstanceRequest",
        "GetScreenshotInstanceRequest",
        "GetSerialPortOutputInstanceRequest",
        "GetShieldedInstanceIdentityInstanceRequest",
        "InsertInstanceRequest",
        "ListInstancesRequest",
        "ListReferrersInstancesRequest",
        "RemoveResourcePoliciesInstanceRequest",
        "ResetInstanceRequest",
        "SetDeletionProtectionInstanceRequest",
        "SetDiskAutoDeleteInstanceRequest",
        "SetIamPolicyInstanceRequest",
        "SetLabelsInstanceRequest",
        "SetMachineResourcesInstanceRequest",
        "SetMachineTypeInstanceRequest",
        "SetMetadataInstanceRequest",
        "SetMinCpuPlatformInstanceRequest",
        "SetSchedulingInstanceRequest",
        "SetServiceAccountInstanceRequest",
        "SetShieldedInstanceIntegrityPolicyInstanceRequest",
        "SetTagsInstanceRequest",
        "SimulateMaintenanceEventInstanceRequest",
        "StartInstanceRequest",
        "StartWithEncryptionKeyInstanceRequest",
        "StopInstanceRequest",
        "TestIamPermissionsInstanceRequest",
        "UpdateInstanceRequest",
        "UpdateAccessConfigInstanceRequest",
        "UpdateDisplayDeviceInstanceRequest",
        "UpdateNetworkInterfaceInstanceRequest",
        "UpdateShieldedInstanceConfigInstanceRequest",
        "AggregatedListInterconnectAttachmentsRequest",
        "DeleteInterconnectAttachmentRequest",
        "GetInterconnectAttachmentRequest",
        "InsertInterconnectAttachmentRequest",
        "ListInterconnectAttachmentsRequest",
        "PatchInterconnectAttachmentRequest",
        "GetInterconnectLocationRequest",
        "ListInterconnectLocationsRequest",
        "DeleteInterconnectRequest",
        "GetInterconnectRequest",
        "GetDiagnosticsInterconnectRequest",
        "InsertInterconnectRequest",
        "ListInterconnectsRequest",
        "PatchInterconnectRequest",
        "GetLicenseCodeRequest",
        "TestIamPermissionsLicenseCodeRequest",
        "DeleteLicenseRequest",
        "GetLicenseRequest",
        "GetIamPolicyLicenseRequest",
        "InsertLicenseRequest",
        "ListLicensesRequest",
        "SetIamPolicyLicenseRequest",
        "TestIamPermissionsLicenseRequest",
        "AggregatedListMachineTypesRequest",
        "GetMachineTypeRequest",
        "ListMachineTypesRequest",
        "AggregatedListNetworkEndpointGroupsRequest",
        "AttachNetworkEndpointsNetworkEndpointGroupRequest",
        "DeleteNetworkEndpointGroupRequest",
        "DetachNetworkEndpointsNetworkEndpointGroupRequest",
        "GetNetworkEndpointGroupRequest",
        "InsertNetworkEndpointGroupRequest",
        "ListNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsNetworkEndpointGroupsRequest",
        "TestIamPermissionsNetworkEndpointGroupRequest",
        "AddPeeringNetworkRequest",
        "DeleteNetworkRequest",
        "GetNetworkRequest",
        "GetEffectiveFirewallsNetworkRequest",
        "InsertNetworkRequest",
        "ListNetworksRequest",
        "ListPeeringRoutesNetworksRequest",
        "PatchNetworkRequest",
        "RemovePeeringNetworkRequest",
        "SwitchToCustomModeNetworkRequest",
        "UpdatePeeringNetworkRequest",
        "AddNodesNodeGroupRequest",
        "AggregatedListNodeGroupsRequest",
        "DeleteNodeGroupRequest",
        "DeleteNodesNodeGroupRequest",
        "GetNodeGroupRequest",
        "GetIamPolicyNodeGroupRequest",
        "InsertNodeGroupRequest",
        "ListNodeGroupsRequest",
        "ListNodesNodeGroupsRequest",
        "PatchNodeGroupRequest",
        "SetIamPolicyNodeGroupRequest",
        "SetNodeTemplateNodeGroupRequest",
        "TestIamPermissionsNodeGroupRequest",
        "AggregatedListNodeTemplatesRequest",
        "DeleteNodeTemplateRequest",
        "GetNodeTemplateRequest",
        "GetIamPolicyNodeTemplateRequest",
        "InsertNodeTemplateRequest",
        "ListNodeTemplatesRequest",
        "SetIamPolicyNodeTemplateRequest",
        "TestIamPermissionsNodeTemplateRequest",
        "AggregatedListNodeTypesRequest",
        "GetNodeTypeRequest",
        "ListNodeTypesRequest",
        "AggregatedListPacketMirroringsRequest",
        "DeletePacketMirroringRequest",
        "GetPacketMirroringRequest",
        "InsertPacketMirroringRequest",
        "ListPacketMirroringsRequest",
        "PatchPacketMirroringRequest",
        "TestIamPermissionsPacketMirroringRequest",
        "DisableXpnHostProjectRequest",
        "DisableXpnResourceProjectRequest",
        "EnableXpnHostProjectRequest",
        "EnableXpnResourceProjectRequest",
        "GetProjectRequest",
        "GetXpnHostProjectRequest",
        "GetXpnResourcesProjectsRequest",
        "ListXpnHostsProjectsRequest",
        "MoveDiskProjectRequest",
        "MoveInstanceProjectRequest",
        "SetCommonInstanceMetadataProjectRequest",
        "SetDefaultNetworkTierProjectRequest",
        "SetUsageExportBucketProjectRequest",
        "DeletePublicAdvertisedPrefixeRequest",
        "GetPublicAdvertisedPrefixeRequest",
        "InsertPublicAdvertisedPrefixeRequest",
        "ListPublicAdvertisedPrefixesRequest",
        "PatchPublicAdvertisedPrefixeRequest",
        "AggregatedListPublicDelegatedPrefixesRequest",
        "DeletePublicDelegatedPrefixeRequest",
        "GetPublicDelegatedPrefixeRequest",
        "InsertPublicDelegatedPrefixeRequest",
        "ListPublicDelegatedPrefixesRequest",
        "PatchPublicDelegatedPrefixeRequest",
        "DeleteRegionAutoscalerRequest",
        "GetRegionAutoscalerRequest",
        "InsertRegionAutoscalerRequest",
        "ListRegionAutoscalersRequest",
        "PatchRegionAutoscalerRequest",
        "UpdateRegionAutoscalerRequest",
        "DeleteRegionBackendServiceRequest",
        "GetRegionBackendServiceRequest",
        "GetHealthRegionBackendServiceRequest",
        "InsertRegionBackendServiceRequest",
        "ListRegionBackendServicesRequest",
        "PatchRegionBackendServiceRequest",
        "UpdateRegionBackendServiceRequest",
        "AggregatedListRegionCommitmentsRequest",
        "GetRegionCommitmentRequest",
        "InsertRegionCommitmentRequest",
        "ListRegionCommitmentsRequest",
        "GetRegionDiskTypeRequest",
        "ListRegionDiskTypesRequest",
        "AddResourcePoliciesRegionDiskRequest",
        "CreateSnapshotRegionDiskRequest",
        "DeleteRegionDiskRequest",
        "GetRegionDiskRequest",
        "GetIamPolicyRegionDiskRequest",
        "InsertRegionDiskRequest",
        "ListRegionDisksRequest",
        "RemoveResourcePoliciesRegionDiskRequest",
        "ResizeRegionDiskRequest",
        "SetIamPolicyRegionDiskRequest",
        "SetLabelsRegionDiskRequest",
        "TestIamPermissionsRegionDiskRequest",
        "DeleteRegionHealthCheckServiceRequest",
        "GetRegionHealthCheckServiceRequest",
        "InsertRegionHealthCheckServiceRequest",
        "ListRegionHealthCheckServicesRequest",
        "PatchRegionHealthCheckServiceRequest",
        "DeleteRegionHealthCheckRequest",
        "GetRegionHealthCheckRequest",
        "InsertRegionHealthCheckRequest",
        "ListRegionHealthChecksRequest",
        "PatchRegionHealthCheckRequest",
        "UpdateRegionHealthCheckRequest",
        "AbandonInstancesRegionInstanceGroupManagerRequest",
        "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
        "CreateInstancesRegionInstanceGroupManagerRequest",
        "DeleteRegionInstanceGroupManagerRequest",
        "DeleteInstancesRegionInstanceGroupManagerRequest",
        "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "GetRegionInstanceGroupManagerRequest",
        "InsertRegionInstanceGroupManagerRequest",
        "ListRegionInstanceGroupManagersRequest",
        "ListErrorsRegionInstanceGroupManagersRequest",
        "ListManagedInstancesRegionInstanceGroupManagersRequest",
        "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
        "PatchRegionInstanceGroupManagerRequest",
        "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
        "RecreateInstancesRegionInstanceGroupManagerRequest",
        "ResizeRegionInstanceGroupManagerRequest",
        "SetInstanceTemplateRegionInstanceGroupManagerRequest",
        "SetTargetPoolsRegionInstanceGroupManagerRequest",
        "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "GetRegionInstanceGroupRequest",
        "ListRegionInstanceGroupsRequest",
        "ListInstancesRegionInstanceGroupsRequest",
        "SetNamedPortsRegionInstanceGroupRequest",
        "BulkInsertRegionInstanceRequest",
        "DeleteRegionNetworkEndpointGroupRequest",
        "GetRegionNetworkEndpointGroupRequest",
        "InsertRegionNetworkEndpointGroupRequest",
        "ListRegionNetworkEndpointGroupsRequest",
        "DeleteRegionNotificationEndpointRequest",
        "GetRegionNotificationEndpointRequest",
        "InsertRegionNotificationEndpointRequest",
        "ListRegionNotificationEndpointsRequest",
        "DeleteRegionOperationRequest",
        "DeleteRegionOperationResponse",
        "GetRegionOperationRequest",
        "ListRegionOperationsRequest",
        "WaitRegionOperationRequest",
        "DeleteRegionSslCertificateRequest",
        "GetRegionSslCertificateRequest",
        "InsertRegionSslCertificateRequest",
        "ListRegionSslCertificatesRequest",
        "DeleteRegionTargetHttpProxyRequest",
        "GetRegionTargetHttpProxyRequest",
        "InsertRegionTargetHttpProxyRequest",
        "ListRegionTargetHttpProxiesRequest",
        "SetUrlMapRegionTargetHttpProxyRequest",
        "DeleteRegionTargetHttpsProxyRequest",
        "GetRegionTargetHttpsProxyRequest",
        "InsertRegionTargetHttpsProxyRequest",
        "ListRegionTargetHttpsProxiesRequest",
        "SetSslCertificatesRegionTargetHttpsProxyRequest",
        "SetUrlMapRegionTargetHttpsProxyRequest",
        "DeleteRegionUrlMapRequest",
        "GetRegionUrlMapRequest",
        "InsertRegionUrlMapRequest",
        "ListRegionUrlMapsRequest",
        "PatchRegionUrlMapRequest",
        "UpdateRegionUrlMapRequest",
        "ValidateRegionUrlMapRequest",
        "GetRegionRequest",
        "ListRegionsRequest",
        "AggregatedListReservationsRequest",
        "DeleteReservationRequest",
        "GetReservationRequest",
        "GetIamPolicyReservationRequest",
        "InsertReservationRequest",
        "ListReservationsRequest",
        "ResizeReservationRequest",
        "SetIamPolicyReservationRequest",
        "TestIamPermissionsReservationRequest",
        "AggregatedListResourcePoliciesRequest",
        "DeleteResourcePolicyRequest",
        "GetResourcePolicyRequest",
        "GetIamPolicyResourcePolicyRequest",
        "InsertResourcePolicyRequest",
        "ListResourcePoliciesRequest",
        "SetIamPolicyResourcePolicyRequest",
        "TestIamPermissionsResourcePolicyRequest",
        "AggregatedListRoutersRequest",
        "DeleteRouterRequest",
        "GetRouterRequest",
        "GetNatMappingInfoRoutersRequest",
        "GetRouterStatusRouterRequest",
        "InsertRouterRequest",
        "ListRoutersRequest",
        "PatchRouterRequest",
        "PreviewRouterRequest",
        "UpdateRouterRequest",
        "DeleteRouteRequest",
        "GetRouteRequest",
        "InsertRouteRequest",
        "ListRoutesRequest",
        "AddRuleSecurityPolicyRequest",
        "DeleteSecurityPolicyRequest",
        "GetSecurityPolicyRequest",
        "GetRuleSecurityPolicyRequest",
        "InsertSecurityPolicyRequest",
        "ListSecurityPoliciesRequest",
        "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
        "PatchSecurityPolicyRequest",
        "PatchRuleSecurityPolicyRequest",
        "RemoveRuleSecurityPolicyRequest",
        "DeleteSnapshotRequest",
        "GetSnapshotRequest",
        "GetIamPolicySnapshotRequest",
        "ListSnapshotsRequest",
        "SetIamPolicySnapshotRequest",
        "SetLabelsSnapshotRequest",
        "TestIamPermissionsSnapshotRequest",
        "AggregatedListSslCertificatesRequest",
        "DeleteSslCertificateRequest",
        "GetSslCertificateRequest",
        "InsertSslCertificateRequest",
        "ListSslCertificatesRequest",
        "DeleteSslPolicyRequest",
        "GetSslPolicyRequest",
        "InsertSslPolicyRequest",
        "ListSslPoliciesRequest",
        "ListAvailableFeaturesSslPoliciesRequest",
        "PatchSslPolicyRequest",
        "AggregatedListSubnetworksRequest",
        "DeleteSubnetworkRequest",
        "ExpandIpCidrRangeSubnetworkRequest",
        "GetSubnetworkRequest",
        "GetIamPolicySubnetworkRequest",
        "InsertSubnetworkRequest",
        "ListSubnetworksRequest",
        "ListUsableSubnetworksRequest",
        "PatchSubnetworkRequest",
        "SetIamPolicySubnetworkRequest",
        "SetPrivateIpGoogleAccessSubnetworkRequest",
        "TestIamPermissionsSubnetworkRequest",
        "DeleteTargetGrpcProxyRequest",
        "GetTargetGrpcProxyRequest",
        "InsertTargetGrpcProxyRequest",
        "ListTargetGrpcProxiesRequest",
        "PatchTargetGrpcProxyRequest",
        "AggregatedListTargetHttpProxiesRequest",
        "DeleteTargetHttpProxyRequest",
        "GetTargetHttpProxyRequest",
        "InsertTargetHttpProxyRequest",
        "ListTargetHttpProxiesRequest",
        "PatchTargetHttpProxyRequest",
        "SetUrlMapTargetHttpProxyRequest",
        "AggregatedListTargetHttpsProxiesRequest",
        "DeleteTargetHttpsProxyRequest",
        "GetTargetHttpsProxyRequest",
        "InsertTargetHttpsProxyRequest",
        "ListTargetHttpsProxiesRequest",
        "PatchTargetHttpsProxyRequest",
        "SetQuicOverrideTargetHttpsProxyRequest",
        "SetSslCertificatesTargetHttpsProxyRequest",
        "SetSslPolicyTargetHttpsProxyRequest",
        "SetUrlMapTargetHttpsProxyRequest",
        "AggregatedListTargetInstancesRequest",
        "DeleteTargetInstanceRequest",
        "GetTargetInstanceRequest",
        "InsertTargetInstanceRequest",
        "ListTargetInstancesRequest",
        "AddHealthCheckTargetPoolRequest",
        "AddInstanceTargetPoolRequest",
        "AggregatedListTargetPoolsRequest",
        "DeleteTargetPoolRequest",
        "GetTargetPoolRequest",
        "GetHealthTargetPoolRequest",
        "InsertTargetPoolRequest",
        "ListTargetPoolsRequest",
        "RemoveHealthCheckTargetPoolRequest",
        "RemoveInstanceTargetPoolRequest",
        "SetBackupTargetPoolRequest",
        "DeleteTargetSslProxyRequest",
        "GetTargetSslProxyRequest",
        "InsertTargetSslProxyRequest",
        "ListTargetSslProxiesRequest",
        "SetBackendServiceTargetSslProxyRequest",
        "SetProxyHeaderTargetSslProxyRequest",
        "SetSslCertificatesTargetSslProxyRequest",
        "SetSslPolicyTargetSslProxyRequest",
        "DeleteTargetTcpProxyRequest",
        "GetTargetTcpProxyRequest",
        "InsertTargetTcpProxyRequest",
        "ListTargetTcpProxiesRequest",
        "SetBackendServiceTargetTcpProxyRequest",
        "SetProxyHeaderTargetTcpProxyRequest",
        "AggregatedListTargetVpnGatewaysRequest",
        "DeleteTargetVpnGatewayRequest",
        "GetTargetVpnGatewayRequest",
        "InsertTargetVpnGatewayRequest",
        "ListTargetVpnGatewaysRequest",
        "AggregatedListUrlMapsRequest",
        "DeleteUrlMapRequest",
        "GetUrlMapRequest",
        "InsertUrlMapRequest",
        "InvalidateCacheUrlMapRequest",
        "ListUrlMapsRequest",
        "PatchUrlMapRequest",
        "UpdateUrlMapRequest",
        "ValidateUrlMapRequest",
        "AggregatedListVpnGatewaysRequest",
        "DeleteVpnGatewayRequest",
        "GetVpnGatewayRequest",
        "GetStatusVpnGatewayRequest",
        "InsertVpnGatewayRequest",
        "ListVpnGatewaysRequest",
        "SetLabelsVpnGatewayRequest",
        "TestIamPermissionsVpnGatewayRequest",
        "AggregatedListVpnTunnelsRequest",
        "DeleteVpnTunnelRequest",
        "GetVpnTunnelRequest",
        "InsertVpnTunnelRequest",
        "ListVpnTunnelsRequest",
        "DeleteZoneOperationRequest",
        "DeleteZoneOperationResponse",
        "GetZoneOperationRequest",
        "ListZoneOperationsRequest",
        "WaitZoneOperationRequest",
        "GetZoneRequest",
        "ListZonesRequest",
    },
)


class AcceleratorConfig(proto.Message):
    r"""Messages
    A specification of the type and number of accelerator cards
    attached to the instance.

    Attributes:
        accelerator_count (int):
            The number of the guest accelerator cards
            exposed to this instance.
        accelerator_type (str):
            Full or partial URL of the accelerator type
            resource to attach to this instance. For
            example: projects/my-project/zones/us-
            central1-c/acceleratorTypes/nvidia-tesla-p100 If
            you are creating an instance template, specify
            only the accelerator name. See GPUs on Compute
            Engine for a full list of accelerator types.
    """

    accelerator_count = proto.Field(proto.INT32, number=504879675, optional=True,)
    accelerator_type = proto.Field(proto.STRING, number=138031246, optional=True,)


class DeprecationStatus(proto.Message):
    r"""Deprecation status for a public resource.
    Attributes:
        deleted (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to DELETED. This is only informational
            and the status will not change unless the client
            explicitly changes it.
        deprecated (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to DEPRECATED. This is only informational
            and the status will not change unless the client
            explicitly changes it.
        obsolete (str):
            An optional RFC3339 timestamp on or after
            which the state of this resource is intended to
            change to OBSOLETE. This is only informational
            and the status will not change unless the client
            explicitly changes it.
        replacement (str):
            The URL of the suggested replacement for a
            deprecated resource. The suggested replacement
            resource must be the same kind of resource as
            the deprecated resource.
        state (google.cloud.compute_v1.types.DeprecationStatus.State):
            The deprecation state of this resource. This
            can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED.
            Operations which communicate the end of life
            date for an image, can use ACTIVE. Operations
            which create a new resource using a DEPRECATED
            resource will return successfully, but with a
            warning indicating the deprecated resource and
            recommending its replacement. Operations which
            use OBSOLETE or DELETED resources will be
            rejected and result in an error.
    """

    class State(proto.Enum):
        r"""The deprecation state of this resource. This can be ACTIVE,
        DEPRECATED, OBSOLETE, or DELETED. Operations which communicate
        the end of life date for an image, can use ACTIVE. Operations
        which create a new resource using a DEPRECATED resource will
        return successfully, but with a warning indicating the
        deprecated resource and recommending its replacement. Operations
        which use OBSOLETE or DELETED resources will be rejected and
        result in an error.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        DELETED = 120962041
        DEPRECATED = 463360435
        OBSOLETE = 66532761

    deleted = proto.Field(proto.STRING, number=476721177, optional=True,)
    deprecated = proto.Field(proto.STRING, number=515138995, optional=True,)
    obsolete = proto.Field(proto.STRING, number=357647769, optional=True,)
    replacement = proto.Field(proto.STRING, number=430919186, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class AcceleratorType(proto.Message):
    r"""Represents an Accelerator Type resource.

    Google Cloud Platform provides graphics processing units
    (accelerators) that you can add to VM instances to improve or
    accelerate performance when working with intensive workloads. For
    more information, read GPUs on Compute Engine. (== resource_for
    {$api_version}.acceleratorTypes ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            accelerator type.
        description (str):
            [Output Only] An optional textual description of the
            resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#acceleratorType for accelerator types.
        maximum_cards_per_instance (int):
            [Output Only] Maximum number of accelerator cards allowed
            per instance.
        name (str):
            [Output Only] Name of the resource.
        self_link (str):
            [Output Only] Server-defined, fully qualified URL for this
            resource.
        zone (str):
            [Output Only] The name of the zone where the accelerator
            type resides, such as us-central1-a. You must specify this
            field as part of the HTTP request URL. It is not settable as
            a field in the request body.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    maximum_cards_per_instance = proto.Field(
        proto.INT32, number=263814482, optional=True,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class AcceleratorTypesScopedList(proto.Message):
    r"""
    Attributes:
        accelerator_types (Sequence[google.cloud.compute_v1.types.AcceleratorType]):
            [Output Only] A list of accelerator types contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            accelerator types list is empty.
    """

    accelerator_types = proto.RepeatedField(
        proto.MESSAGE, number=520872357, message="AcceleratorType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Data(proto.Message):
    r"""
    Attributes:
        key (str):
            [Output Only] A key that provides more detail on the warning
            being returned. For example, for warnings where there are no
            results in a list request for a particular zone, this key
            might be scope and the key value might be the zone name.
            Other examples might be a key indicating a deprecated
            resource and a suggested replacement, or a warning about
            invalid network settings (for example, if an instance
            attempts to perform IP forwarding but is not enabled for IP
            forwarding).
        value (str):
            [Output Only] A warning data value corresponding to the key.
    """

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class Warning(proto.Message):
    r"""[Output Only] Informational warning message.
    Attributes:
        code (google.cloud.compute_v1.types.Warning.Code):
            [Output Only] A warning code, if applicable. For example,
            Compute Engine returns NO_RESULTS_ON_PAGE if there are no
            results in the response.
        data (Sequence[google.cloud.compute_v1.types.Data]):
            [Output Only] Metadata about this warning in key: value
            format. For example: "data": [ { "key": "scope", "value":
            "zones/us-east1-d" }
        message (str):
            [Output Only] A human-readable description of the warning
            code.
    """

    class Code(proto.Enum):
        r"""[Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
        """
        UNDEFINED_CODE = 0
        CLEANUP_FAILED = 150308440
        DEPRECATED_RESOURCE_USED = 391835586
        DEPRECATED_TYPE_USED = 346526230
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 369442967
        EXPERIMENTAL_TYPE_USED = 451954443
        EXTERNAL_API_WARNING = 175546307
        FIELD_VALUE_OVERRIDEN = 329669423
        INJECTED_KERNELS_DEPRECATED = 417377419
        LARGE_DEPLOYMENT_WARNING = 481440678
        MISSING_TYPE_DEPENDENCY = 344505463
        NEXT_HOP_ADDRESS_NOT_ASSIGNED = 324964999
        NEXT_HOP_CANNOT_IP_FORWARD = 383382887
        NEXT_HOP_INSTANCE_NOT_FOUND = 464250446
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 243758146
        NEXT_HOP_NOT_RUNNING = 417081265
        NOT_CRITICAL_ERROR = 105763924
        NO_RESULTS_ON_PAGE = 30036744
        PARTIAL_SUCCESS = 39966469
        REQUIRED_TOS_AGREEMENT = 3745539
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 496728641
        RESOURCE_NOT_DELETED = 168598460
        SCHEMA_VALIDATION_IGNORED = 275245642
        SINGLE_INSTANCE_PROPERTY_TEMPLATE = 268305617
        UNDECLARED_PROPERTIES = 390513439
        UNREACHABLE = 13328052

    code = proto.Field(proto.ENUM, number=3059181, optional=True, enum=Code,)
    data = proto.RepeatedField(proto.MESSAGE, number=3076010, message="Data",)
    message = proto.Field(proto.STRING, number=418054151, optional=True,)


class AcceleratorTypeAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.AcceleratorTypeAggregatedList.ItemsEntry]):
            A list of AcceleratorTypesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeAggregatedList for aggregated lists
            of accelerator types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="AcceleratorTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AcceleratorTypeList(proto.Message):
    r"""Contains a list of accelerator types.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.AcceleratorType]):
            A list of AcceleratorType resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeList for lists of accelerator types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="AcceleratorType",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AccessConfig(proto.Message):
    r"""An access configuration attached to an instance's network
    interface. Only one access config per instance is supported.

    Attributes:
        kind (str):
            [Output Only] Type of the resource. Always
            compute#accessConfig for access configs.
        name (str):
            The name of this access configuration. The
            default and recommended name is External NAT,
            but you can use any arbitrary string, such as My
            external IP or Network Access.
        nat_i_p (str):
            An external IP address associated with this
            instance. Specify an unused static external IP
            address available to the project or leave this
            field undefined to use an IP from a shared
            ephemeral IP address pool. If you specify a
            static external IP address, it must live in the
            same region as the zone of the instance.
        network_tier (google.cloud.compute_v1.types.AccessConfig.NetworkTier):
            This signifies the networking tier used for
            configuring this access configuration and can
            only take the following values: PREMIUM,
            STANDARD.  If an AccessConfig is specified
            without a valid external IP address, an
            ephemeral IP will be created with this
            networkTier.
            If an AccessConfig with a valid external IP
            address is specified, it must match that of the
            networkTier associated with the Address resource
            owning that IP.
        public_ptr_domain_name (str):
            The DNS domain name for the public PTR record. You can set
            this field only if the ``setPublicPtr`` field is enabled.
        set_public_ptr (bool):
            Specifies whether a public DNS 'PTR' record
            should be created to map the external IP address
            of the instance to a DNS domain name.
        type_ (google.cloud.compute_v1.types.AccessConfig.Type):
            The type of configuration. The default and only option is
            ONE_TO_ONE_NAT.
    """

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        access configuration and can only take the following values:
        PREMIUM, STANDARD.  If an AccessConfig is specified without a
        valid external IP address, an ephemeral IP will be created with
        this networkTier.
        If an AccessConfig with a valid external IP address is
        specified, it must match that of the networkTier associated with
        the Address resource owning that IP.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class Type(proto.Enum):
        r"""The type of configuration. The default and only option is
        ONE_TO_ONE_NAT.
        """
        UNDEFINED_TYPE = 0
        ONE_TO_ONE_NAT = 84090205

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    nat_i_p = proto.Field(proto.STRING, number=117634556, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    public_ptr_domain_name = proto.Field(proto.STRING, number=316599167, optional=True,)
    set_public_ptr = proto.Field(proto.BOOL, number=523870229, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class Address(proto.Message):
    r"""Use global external addresses for GFE-based external HTTP(S) load
    balancers in Premium Tier.

    Use global internal addresses for reserved peering network range.

    Use regional external addresses for the following resources:

    -  External IP addresses for VM instances - Regional external
       forwarding rules - Cloud NAT external IP addresses - GFE based
       LBs in Standard Tier - Network LBs in Premium or Standard Tier -
       Cloud VPN gateways (both Classic and HA)

    Use regional internal IP addresses for subnet IP ranges (primary and
    secondary). This includes:

    -  Internal IP addresses for VM instances - Alias IP ranges of VM
       instances (/32 only) - Regional internal forwarding rules -
       Internal TCP/UDP load balancer addresses - Internal HTTP(S) load
       balancer addresses - Cloud DNS inbound forwarding IP addresses

    For more information, read reserved IP address.

    (== resource_for {$api_version}.addresses ==) (== resource_for
    {$api_version}.globalAddresses ==)

    Attributes:
        address (str):
            The static IP address represented by this
            resource.
        address_type (google.cloud.compute_v1.types.Address.AddressType):
            The type of address to reserve, either
            INTERNAL or EXTERNAL. If unspecified, defaults
            to EXTERNAL.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        ip_version (google.cloud.compute_v1.types.Address.IpVersion):
            The IP version that will be used by this
            address. Valid options are IPV4 or IPV6. This
            can only be specified for a global address.
        kind (str):
            [Output Only] Type of the resource. Always compute#address
            for addresses.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``. The first character must be
            a lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.
        network (str):
            The URL of the network in which to reserve the address. This
            field can only be used with INTERNAL type with the
            VPC_PEERING purpose.
        network_tier (google.cloud.compute_v1.types.Address.NetworkTier):
            This signifies the networking tier used for
            configuring this address and can only take the
            following values: PREMIUM or STANDARD. Global
            forwarding rules can only be Premium Tier.
            Regional forwarding rules can be either Premium
            or Standard Tier. Standard Tier addresses
            applied to regional forwarding rules can be used
            with any external load balancer. Regional
            forwarding rules in Premium Tier can only be
            used with a network load balancer.  If this
            field is not specified, it is assumed to be
            PREMIUM.
        prefix_length (int):
            The prefix length if the resource represents
            an IP range.
        purpose (google.cloud.compute_v1.types.Address.Purpose):
            The purpose of this resource, which can be one of the
            following values:

            -  ``GCE_ENDPOINT`` for addresses that are used by VM
               instances, alias IP ranges, internal load balancers, and
               similar resources.
            -  ``DNS_RESOLVER`` for a DNS resolver address in a
               subnetwork
            -  ``VPC_PEERING`` for addresses that are reserved for VPC
               peer networks.
            -  ``NAT_AUTO`` for addresses that are external IP addresses
               automatically reserved for Cloud NAT.
            -  ``IPSEC_INTERCONNECT`` for addresses created from a
               private IP range that are reserved for a VLAN attachment
               in an IPsec-encrypted Cloud Interconnect configuration.
               These addresses are regional resources.
        region (str):
            [Output Only] The URL of the region where a regional address
            resides. For regional addresses, you must specify the region
            as a path parameter in the HTTP request URL. This field is
            not applicable to global addresses.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        status (google.cloud.compute_v1.types.Address.Status):
            [Output Only] The status of the address, which can be one of
            RESERVING, RESERVED, or IN_USE. An address that is RESERVING
            is currently in the process of being reserved. A RESERVED
            address is currently reserved and available to use. An
            IN_USE address is currently being used by another resource
            and is not available.
        subnetwork (str):
            The URL of the subnetwork in which to reserve the address.
            If an IP address is specified, it must be within the
            subnetwork's IP range. This field can only be used with
            INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
        users (Sequence[str]):
            [Output Only] The URLs of the resources that are using this
            address.
    """

    class AddressType(proto.Enum):
        r"""The type of address to reserve, either INTERNAL or EXTERNAL.
        If unspecified, defaults to EXTERNAL.
        """
        UNDEFINED_ADDRESS_TYPE = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        UNSPECIFIED_TYPE = 53933922

    class IpVersion(proto.Enum):
        r"""The IP version that will be used by this address. Valid
        options are IPV4 or IPV6. This can only be specified for a
        global address.
        """
        UNDEFINED_IP_VERSION = 0
        IPV4 = 2254341
        IPV6 = 2254343
        UNSPECIFIED_VERSION = 21850000

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        address and can only take the following values: PREMIUM or
        STANDARD. Global forwarding rules can only be Premium Tier.
        Regional forwarding rules can be either Premium or Standard
        Tier. Standard Tier addresses applied to regional forwarding
        rules can be used with any external load balancer. Regional
        forwarding rules in Premium Tier can only be used with a network
        load balancer.  If this field is not specified, it is assumed to
        be PREMIUM.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class Purpose(proto.Enum):
        r"""The purpose of this resource, which can be one of the following
        values:

        -  ``GCE_ENDPOINT`` for addresses that are used by VM instances,
           alias IP ranges, internal load balancers, and similar resources.
        -  ``DNS_RESOLVER`` for a DNS resolver address in a subnetwork
        -  ``VPC_PEERING`` for addresses that are reserved for VPC peer
           networks.
        -  ``NAT_AUTO`` for addresses that are external IP addresses
           automatically reserved for Cloud NAT.
        -  ``IPSEC_INTERCONNECT`` for addresses created from a private IP
           range that are reserved for a VLAN attachment in an
           IPsec-encrypted Cloud Interconnect configuration. These addresses
           are regional resources.
        """
        UNDEFINED_PURPOSE = 0
        DNS_RESOLVER = 476114556
        GCE_ENDPOINT = 230515243
        IPSEC_INTERCONNECT = 340437251
        NAT_AUTO = 163666477
        PRIVATE_SERVICE_CONNECT = 48134724
        SHARED_LOADBALANCER_VIP = 294447572
        VPC_PEERING = 400800170

    class Status(proto.Enum):
        r"""[Output Only] The status of the address, which can be one of
        RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
        currently in the process of being reserved. A RESERVED address is
        currently reserved and available to use. An IN_USE address is
        currently being used by another resource and is not available.
        """
        UNDEFINED_STATUS = 0
        IN_USE = 17393485
        RESERVED = 432241448
        RESERVING = 514587225

    address = proto.Field(proto.STRING, number=462920692, optional=True,)
    address_type = proto.Field(
        proto.ENUM, number=264307877, optional=True, enum=AddressType,
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_version = proto.Field(
        proto.ENUM, number=294959552, optional=True, enum=IpVersion,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    prefix_length = proto.Field(proto.INT32, number=453565747, optional=True,)
    purpose = proto.Field(proto.ENUM, number=316407070, optional=True, enum=Purpose,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    users = proto.RepeatedField(proto.STRING, number=111578632,)


class AddressesScopedList(proto.Message):
    r"""
    Attributes:
        addresses (Sequence[google.cloud.compute_v1.types.Address]):
            [Output Only] A list of addresses contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of addresses when the list is empty.
    """

    addresses = proto.RepeatedField(proto.MESSAGE, number=337673122, message="Address",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AddressAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.AddressAggregatedList.ItemsEntry]):
            A list of AddressesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#addressAggregatedList for aggregated lists of
            addresses.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="AddressesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AddressList(proto.Message):
    r"""Contains a list of addresses.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Address]):
            A list of Address resources.
        kind (str):
            [Output Only] Type of resource. Always compute#addressList
            for lists of addresses.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Address",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AdvancedMachineFeatures(proto.Message):
    r"""Specifies options for controlling advanced machine features.
    Options that would traditionally be configured in a BIOS belong
    here. Features that require operating system support may have
    corresponding entries in the GuestOsFeatures of an Image (e.g.,
    whether or not the OS in the Image supports nested
    virtualization being enabled or disabled).

    Attributes:
        enable_nested_virtualization (bool):
            Whether to enable nested virtualization or
            not (default is false).
        threads_per_core (int):
            The number of threads per physical core. To
            disable simultaneous multithreading (SMT) set
            this to 1. If unset, the maximum number of
            threads supported per core by the underlying
            processor is assumed.
    """

    enable_nested_virtualization = proto.Field(
        proto.BOOL, number=16639365, optional=True,
    )
    threads_per_core = proto.Field(proto.INT32, number=352611671, optional=True,)


class AliasIpRange(proto.Message):
    r"""An alias IP range attached to an instance's network
    interface.

    Attributes:
        ip_cidr_range (str):
            The IP alias ranges to allocate for this
            interface. This IP CIDR range must belong to the
            specified subnetwork and cannot contain IP
            addresses reserved by system or used by other
            network interfaces. This range may be a single
            IP address (such as 10.2.3.4), a netmask (such
            as /24) or a CIDR-formatted string (such as
            10.1.2.0/24).
        subnetwork_range_name (str):
            The name of a subnetwork secondary IP range
            from which to allocate an IP alias range. If not
            specified, the primary range of the subnetwork
            is used.
    """

    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    subnetwork_range_name = proto.Field(proto.STRING, number=387995966, optional=True,)


class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
    proto.Message
):
    r"""
    Attributes:
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.
        interface (google.cloud.compute_v1.types.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Interface):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. The default is SCSI. For performance
            characteristics of SCSI over NVMe, see Local SSD
            performance.
    """

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. For
        performance characteristics of SCSI over NVMe, see Local SSD
        performance.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    interface = proto.Field(
        proto.ENUM, number=502623545, optional=True, enum=Interface,
    )


class AllocationSpecificSKUAllocationReservedInstanceProperties(proto.Message):
    r"""Properties of the SKU instances being reserved. Next ID: 9
    Attributes:
        guest_accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            Specifies accelerator type and count.
        local_ssds (Sequence[google.cloud.compute_v1.types.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk]):
            Specifies amount of local ssd to reserve with
            each instance. The type of disk is local-ssd.
        location_hint (str):
            An opaque location hint used to place the
            allocation close to other resources. This field
            is for use by internal tools that use the public
            API.
        machine_type (str):
            Specifies type of machine (name only) which has fixed number
            of vCPUs and fixed amount of memory. This also includes
            specifying custom machine type following
            custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        min_cpu_platform (str):
            Minimum cpu platform the reservation.
    """

    guest_accelerators = proto.RepeatedField(
        proto.MESSAGE, number=463595119, message="AcceleratorConfig",
    )
    local_ssds = proto.RepeatedField(
        proto.MESSAGE,
        number=229951299,
        message="AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    )
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    machine_type = proto.Field(proto.STRING, number=227711026, optional=True,)
    min_cpu_platform = proto.Field(proto.STRING, number=242912759, optional=True,)


class AllocationSpecificSKUReservation(proto.Message):
    r"""This reservation type allows to pre allocate specific
    instance configuration.

    Attributes:
        count (int):
            Specifies the number of resources that are
            allocated.
        in_use_count (int):
            [Output Only] Indicates how many instances are in use.
        instance_properties (google.cloud.compute_v1.types.AllocationSpecificSKUAllocationReservedInstanceProperties):
            The instance properties for the reservation.
    """

    count = proto.Field(proto.INT64, number=94851343, optional=True,)
    in_use_count = proto.Field(proto.INT64, number=493458877, optional=True,)
    instance_properties = proto.Field(
        proto.MESSAGE,
        number=215355165,
        optional=True,
        message="AllocationSpecificSKUAllocationReservedInstanceProperties",
    )


class CustomerEncryptionKey(proto.Message):
    r"""
    Attributes:
        kms_key_name (str):
            The name of the encryption key that is stored
            in Google Cloud KMS.
        kms_key_service_account (str):
            The service account being used for the
            encryption request for the given KMS key. If
            absent, the Compute Engine default service
            account is used.
        raw_key (str):
            Specifies a 256-bit customer-supplied
            encryption key, encoded in RFC 4648 base64 to
            either encrypt or decrypt this resource.
        sha256 (str):
            [Output only] The RFC 4648 base64 encoded SHA-256 hash of
            the customer-supplied encryption key that protects this
            resource.
    """

    kms_key_name = proto.Field(proto.STRING, number=484373913, optional=True,)
    kms_key_service_account = proto.Field(
        proto.STRING, number=209986261, optional=True,
    )
    raw_key = proto.Field(proto.STRING, number=449196488, optional=True,)
    sha256 = proto.Field(proto.STRING, number=170112551, optional=True,)


class GuestOsFeature(proto.Message):
    r"""Guest OS features.
    Attributes:
        type_ (google.cloud.compute_v1.types.GuestOsFeature.Type):
            The ID of a supported feature. Read  Enabling
            guest operating system features to see a list of
            available options.
    """

    class Type(proto.Enum):
        r"""The ID of a supported feature. Read  Enabling guest operating
        system features to see a list of available options.
        """
        UNDEFINED_TYPE = 0
        FEATURE_TYPE_UNSPECIFIED = 531767259
        GVNIC = 68209305
        MULTI_IP_SUBNET = 151776719
        SECURE_BOOT = 376811194
        SEV_CAPABLE = 87083793
        UEFI_COMPATIBLE = 195865408
        VIRTIO_SCSI_MULTIQUEUE = 201597069
        WINDOWS = 456863331

    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class AttachedDiskInitializeParams(proto.Message):
    r"""[Input Only] Specifies the parameters for a new disk that will be
    created alongside the new instance. Use initialization parameters to
    create boot disks or local SSDs attached to the new instance.

    This property is mutually exclusive with the source property; you
    can only define one or the other, but not both.

    Attributes:
        description (str):
            An optional description. Provide this
            property when creating the disk.
        disk_name (str):
            Specifies the disk name. If not specified,
            the default is to use the name of the instance.
            If a disk with the same name already exists in
            the given region, the existing disk is attached
            to the new instance and the new disk is not
            created.
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.
            The size must be at least 10 GB. If you specify
            a sourceImage, which is required for boot disks,
            the default size is the size of the sourceImage.
            If you do not specify a sourceImage, the default
            disk size is 500 GB.
        disk_type (str):
            Specifies the disk type to use to create the
            instance. If not specified, the default is pd-
            standard, specified using the full URL. For
            example:
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-
            standard

            Other values include pd-ssd and local-ssd. If
            you define this field, you can provide either
            the full or partial URL. For example, the
            following are valid values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
            - projects/project/zones/zone/diskTypes/diskType
            - zones/zone/diskTypes/diskType  Note that for
            InstanceTemplate, this is the name of the disk
            type, not URL.
        labels (Sequence[google.cloud.compute_v1.types.AttachedDiskInitializeParams.LabelsEntry]):
            Labels to apply to this disk. These can be
            later modified by the disks.setLabels method.
            This field is only applicable for persistent
            disks.
        on_update_action (google.cloud.compute_v1.types.AttachedDiskInitializeParams.OnUpdateAction):
            Specifies which action to take on instance
            update with this disk. Default is to use the
            existing disk.
        provisioned_iops (int):
            Indicates how many IOPS must be provisioned
            for the disk.
        resource_policies (Sequence[str]):
            Resource policies applied to this disk for
            automatic snapshot creations. Specified using
            the full or partial URL. For instance template,
            specify only the resource policy name.
        source_image (str):
            The source image to create this disk. When
            creating a new instance, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required except for local SSD.  To create a
            disk with one of the public operating system
            images, specify the image by its family name.
            For example, specify family/debian-9 to use the
            latest Debian 9 image: projects/debian-
            cloud/global/images/family/debian-9

            Alternatively, use a specific version of a
            public operating system image: projects/debian-
            cloud/global/images/debian-9-stretch-vYYYYMMDD

            To create a disk with a custom image that you
            created, specify the image name in the following
            format: global/images/my-custom-image

            You can also specify a custom image by its image
            family, which returns the latest version of the
            image in that family. Replace the image name
            with family/family-name:
            global/images/family/my-image-family

            If the source image is deleted later, this field
            will not be set.
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.
            Instance templates do not store customer-
            supplied encryption keys, so you cannot create
            disks for instances in a managed instance group
            if the source images are encrypted with your own
            keys.
        source_snapshot (str):
            The source snapshot to create this disk. When
            creating a new instance, one of
            initializeParams.sourceSnapshot or
            initializeParams.sourceImage or disks.source is
            required except for local SSD.  To create a disk
            with a snapshot that you created, specify the
            snapshot name in the following format:
            global/snapshots/my-backup

            If the source snapshot is deleted later, this
            field will not be set.
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot.
    """

    class OnUpdateAction(proto.Enum):
        r"""Specifies which action to take on instance update with this
        disk. Default is to use the existing disk.
        """
        UNDEFINED_ON_UPDATE_ACTION = 0
        RECREATE_DISK = 494767853
        RECREATE_DISK_IF_SOURCE_CHANGED = 398099712
        USE_EXISTING_DISK = 232682233

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_name = proto.Field(proto.STRING, number=92807149, optional=True,)
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    disk_type = proto.Field(proto.STRING, number=93009052, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    on_update_action = proto.Field(
        proto.ENUM, number=202451980, optional=True, enum=OnUpdateAction,
    )
    provisioned_iops = proto.Field(proto.INT64, number=186769108, optional=True,)
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )


class InitialStateConfig(proto.Message):
    r"""Initial State for shielded instance, these are public keys
    which are safe to store in public

    Attributes:
        dbs (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The Key Database (db).
        dbxs (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The forbidden key database (dbx).
        keks (Sequence[google.cloud.compute_v1.types.FileContentBuffer]):
            The Key Exchange Key (KEK).
        pk (google.cloud.compute_v1.types.FileContentBuffer):
            The Platform Key (PK).
    """

    dbs = proto.RepeatedField(proto.MESSAGE, number=99253, message="FileContentBuffer",)
    dbxs = proto.RepeatedField(
        proto.MESSAGE, number=3077113, message="FileContentBuffer",
    )
    keks = proto.RepeatedField(
        proto.MESSAGE, number=3288130, message="FileContentBuffer",
    )
    pk = proto.Field(
        proto.MESSAGE, number=3579, optional=True, message="FileContentBuffer",
    )


class AttachedDisk(proto.Message):
    r"""An instance-attached disk resource.
    Attributes:
        auto_delete (bool):
            Specifies whether the disk will be auto-
            eleted when the instance is deleted (but not
            when the disk is detached from the instance).
        boot (bool):
            Indicates that this is a boot disk. The
            virtual machine will use the first partition of
            the disk for its root filesystem.
        device_name (str):
            Specifies a unique device name of your choice that is
            reflected into the /dev/disk/by-id/google-\* tree of a Linux
            operating system running within the instance. This name can
            be used to reference the device for mounting, resizing, and
            so on, from within the instance.

            If not specified, the server chooses a default device name
            to apply to this disk, in the form persistent-disk-x, where
            x is a number assigned by Google Compute Engine. This field
            is only applicable for persistent disks.
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts or decrypts a disk using a customer-
            upplied encryption key.
            If you are creating a new disk, this field
            encrypts the new disk using an encryption key
            that you provide. If you are attaching an
            existing disk that is already encrypted, this
            field decrypts the disk using the customer-
            supplied encryption key.
            If you encrypt a disk using a customer-supplied
            key, you must provide the same key again when
            you attempt to use this resource at a later
            time. For example, you must provide the key when
            you create a snapshot or an image from the disk
            or when you attach the disk to a virtual machine
            instance.
            If you do not provide an encryption key, then
            the disk will be encrypted using an
            automatically generated key and you do not need
            to provide a key to use the disk later.
            Instance templates do not store customer-
            supplied encryption keys, so you cannot use your
            own keys to encrypt disks in a managed instance
            group.
        disk_size_gb (int):
            The size of the disk in GB.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read  Enabling guest operating system
            features to see a list of available options.
        index (int):
            [Output Only] A zero-based index to this disk, where 0 is
            reserved for the boot disk. If you have many disks attached
            to an instance, each disk would have a unique index number.
        initialize_params (google.cloud.compute_v1.types.AttachedDiskInitializeParams):
            [Input Only] Specifies the parameters for a new disk that
            will be created alongside the new instance. Use
            initialization parameters to create boot disks or local SSDs
            attached to the new instance.

            This property is mutually exclusive with the source
            property; you can only define one or the other, but not
            both.
        interface (google.cloud.compute_v1.types.AttachedDisk.Interface):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. The default is SCSI. Persistent disks must
            always use SCSI and the request will fail if you
            attempt to attach a persistent disk in any other
            format than SCSI. Local SSDs can use either NVME
            or SCSI. For performance characteristics of SCSI
            over NVMe, see Local SSD performance.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#attachedDisk for attached disks.
        licenses (Sequence[str]):
            [Output Only] Any valid publicly visible licenses.
        mode (google.cloud.compute_v1.types.AttachedDisk.Mode):
            The mode in which to attach this disk, either READ_WRITE or
            READ_ONLY. If not specified, the default is to attach the
            disk in READ_WRITE mode.
        shielded_instance_initial_state (google.cloud.compute_v1.types.InitialStateConfig):
            [Output Only] shielded vm initial state stored on disk
        source (str):
            Specifies a valid partial or full URL to an
            existing Persistent Disk resource. When creating
            a new instance, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required except for local SSD.  If desired,
            you can also attach existing non-root persistent
            disks using this property. This field is only
            applicable for persistent disks.
            Note that for InstanceTemplate, specify the disk
            name, not the URL for the disk.
        type_ (google.cloud.compute_v1.types.AttachedDisk.Type):
            Specifies the type of the disk, either
            SCRATCH or PERSISTENT. If not specified, the
            default is PERSISTENT.
    """

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. Persistent
        disks must always use SCSI and the request will fail if you
        attempt to attach a persistent disk in any other format than
        SCSI. Local SSDs can use either NVME or SCSI. For performance
        characteristics of SCSI over NVMe, see Local SSD performance.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    class Mode(proto.Enum):
        r"""The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.
        """
        UNDEFINED_MODE = 0
        READ_ONLY = 91950261
        READ_WRITE = 173607894

    class Type(proto.Enum):
        r"""Specifies the type of the disk, either SCRATCH or PERSISTENT.
        If not specified, the default is PERSISTENT.
        """
        UNDEFINED_TYPE = 0
        PERSISTENT = 460683927
        SCRATCH = 496778970

    auto_delete = proto.Field(proto.BOOL, number=464761403, optional=True,)
    boot = proto.Field(proto.BOOL, number=3029746, optional=True,)
    device_name = proto.Field(proto.STRING, number=67541716, optional=True,)
    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    index = proto.Field(proto.INT32, number=100346066, optional=True,)
    initialize_params = proto.Field(
        proto.MESSAGE,
        number=17697045,
        optional=True,
        message="AttachedDiskInitializeParams",
    )
    interface = proto.Field(
        proto.ENUM, number=502623545, optional=True, enum=Interface,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)
    shielded_instance_initial_state = proto.Field(
        proto.MESSAGE, number=192356867, optional=True, message="InitialStateConfig",
    )
    source = proto.Field(proto.STRING, number=177235995, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class AuditLogConfig(proto.Message):
    r"""Provides the configuration for logging a type of permissions.
    Example:

    { "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" } ] }

    This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
    jose@example.com from DATA_READ logging.

    Attributes:
        exempted_members (Sequence[str]):
            Specifies the identities that do not cause logging for this
            type of permission. Follows the same format of
            [Binding.members][].
        ignore_child_exemptions (bool):

        log_type (google.cloud.compute_v1.types.AuditLogConfig.LogType):
            The log type that this config enables.
    """

    class LogType(proto.Enum):
        r"""The log type that this config enables."""
        UNDEFINED_LOG_TYPE = 0
        ADMIN_READ = 128951462
        DATA_READ = 305224971
        DATA_WRITE = 340181738
        LOG_TYPE_UNSPECIFIED = 154527053

    exempted_members = proto.RepeatedField(proto.STRING, number=232615576,)
    ignore_child_exemptions = proto.Field(proto.BOOL, number=70141850, optional=True,)
    log_type = proto.Field(proto.ENUM, number=403115861, optional=True, enum=LogType,)


class AuditConfig(proto.Message):
    r"""Specifies the audit configuration for a service. The configuration
    determines which permission types are logged, and what identities,
    if any, are exempted from logging. An AuditConfig must have one or
    more AuditLogConfigs.

    If there are AuditConfigs for both ``allServices`` and a specific
    service, the union of the two AuditConfigs is used for that service:
    the log_types specified in each AuditConfig are enabled, and the
    exempted_members in each AuditLogConfig are exempted.

    Example Policy with multiple AuditConfigs:

    { "audit_configs": [ { "service": "allServices",
    "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service":
    "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
    "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
    "user:aliya@example.com" ] } ] } ] }

    For sampleservice, this policy enables DATA_READ, DATA_WRITE and
    ADMIN_READ logging. It also exempts jose@example.com from DATA_READ
    logging, and aliya@example.com from DATA_WRITE logging.

    Attributes:
        audit_log_configs (Sequence[google.cloud.compute_v1.types.AuditLogConfig]):
            The configuration for logging of each type of
            permission.
        exempted_members (Sequence[str]):

        service (str):
            Specifies a service that will be enabled for audit logging.
            For example, ``storage.googleapis.com``,
            ``cloudsql.googleapis.com``. ``allServices`` is a special
            value that covers all services.
    """

    audit_log_configs = proto.RepeatedField(
        proto.MESSAGE, number=488420626, message="AuditLogConfig",
    )
    exempted_members = proto.RepeatedField(proto.STRING, number=232615576,)
    service = proto.Field(proto.STRING, number=373540533, optional=True,)


class AuthorizationLoggingOptions(proto.Message):
    r"""Authorization-related information used by Cloud Audit
    Logging.

    Attributes:
        permission_type (google.cloud.compute_v1.types.AuthorizationLoggingOptions.PermissionType):
            The type of the permission that was checked.
    """

    class PermissionType(proto.Enum):
        r"""The type of the permission that was checked."""
        UNDEFINED_PERMISSION_TYPE = 0
        ADMIN_READ = 128951462
        ADMIN_WRITE = 244412079
        DATA_READ = 305224971
        DATA_WRITE = 340181738
        PERMISSION_TYPE_UNSPECIFIED = 440313346

    permission_type = proto.Field(
        proto.ENUM, number=525978538, optional=True, enum=PermissionType,
    )


class AutoscalingPolicy(proto.Message):
    r"""Cloud Autoscaler policy.
    Attributes:
        cool_down_period_sec (int):
            The number of seconds that the autoscaler
            waits before it starts collecting information
            from a new instance. This prevents the
            autoscaler from collecting information when the
            instance is initializing, during which the
            collected usage would not be reliable. The
            default time autoscaler waits is 60 seconds.
            Virtual machine initialization times might vary
            because of numerous factors. We recommend that
            you test how long an instance may take to
            initialize. To do this, create an instance and
            time the startup process.
        cpu_utilization (google.cloud.compute_v1.types.AutoscalingPolicyCpuUtilization):
            Defines the CPU utilization policy that
            allows the autoscaler to scale based on the
            average CPU utilization of a managed instance
            group.
        custom_metric_utilizations (Sequence[google.cloud.compute_v1.types.AutoscalingPolicyCustomMetricUtilization]):
            Configuration parameters of autoscaling based
            on a custom metric.
        load_balancing_utilization (google.cloud.compute_v1.types.AutoscalingPolicyLoadBalancingUtilization):
            Configuration parameters of autoscaling based
            on load balancer.
        max_num_replicas (int):
            The maximum number of instances that the
            autoscaler can scale out to. This is required
            when creating or updating an autoscaler. The
            maximum number of replicas must not be lower
            than minimal number of replicas.
        min_num_replicas (int):
            The minimum number of replicas that the
            autoscaler can scale in to. This cannot be less
            than 0. If not provided, autoscaler chooses a
            default value depending on maximum number of
            instances allowed.
        mode (google.cloud.compute_v1.types.AutoscalingPolicy.Mode):
            Defines operating mode for this policy.
        scale_in_control (google.cloud.compute_v1.types.AutoscalingPolicyScaleInControl):

        scaling_schedules (Sequence[google.cloud.compute_v1.types.AutoscalingPolicy.ScalingSchedulesEntry]):
            Scaling schedules defined for an autoscaler. Multiple
            schedules can be set on an autoscaler, and they can overlap.
            During overlapping periods the greatest
            min_required_replicas of all scaling schedules is applied.
            Up to 128 scaling schedules are allowed.
    """

    class Mode(proto.Enum):
        r"""Defines operating mode for this policy."""
        UNDEFINED_MODE = 0
        OFF = 78159
        ON = 2527
        ONLY_SCALE_OUT = 152713670
        ONLY_UP = 478095374

    cool_down_period_sec = proto.Field(proto.INT32, number=107692954, optional=True,)
    cpu_utilization = proto.Field(
        proto.MESSAGE,
        number=381211147,
        optional=True,
        message="AutoscalingPolicyCpuUtilization",
    )
    custom_metric_utilizations = proto.RepeatedField(
        proto.MESSAGE,
        number=131972850,
        message="AutoscalingPolicyCustomMetricUtilization",
    )
    load_balancing_utilization = proto.Field(
        proto.MESSAGE,
        number=429746403,
        optional=True,
        message="AutoscalingPolicyLoadBalancingUtilization",
    )
    max_num_replicas = proto.Field(proto.INT32, number=62327375, optional=True,)
    min_num_replicas = proto.Field(proto.INT32, number=535329825, optional=True,)
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)
    scale_in_control = proto.Field(
        proto.MESSAGE,
        number=527670872,
        optional=True,
        message="AutoscalingPolicyScaleInControl",
    )
    scaling_schedules = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=355416580,
        message="AutoscalingPolicyScalingSchedule",
    )


class ScalingScheduleStatus(proto.Message):
    r"""
    Attributes:
        last_start_time (str):
            [Output Only] The last time the scaling schedule became
            active. Note: this is a timestamp when a schedule actually
            became active, not when it was planned to do so. The
            timestamp is in RFC3339 text format.
        next_start_time (str):
            [Output Only] The next time the scaling schedule is to
            become active. Note: this is a timestamp when a schedule is
            planned to run, but the actual time might be slightly
            different. The timestamp is in RFC3339 text format.
        state (google.cloud.compute_v1.types.ScalingScheduleStatus.State):
            [Output Only] The current state of a scaling schedule.
    """

    class State(proto.Enum):
        r"""[Output Only] The current state of a scaling schedule."""
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        DISABLED = 516696700
        OBSOLETE = 66532761
        READY = 77848963

    last_start_time = proto.Field(proto.STRING, number=34545107, optional=True,)
    next_start_time = proto.Field(proto.STRING, number=97270102, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class AutoscalerStatusDetails(proto.Message):
    r"""
    Attributes:
        message (str):
            The status message.
        type_ (google.cloud.compute_v1.types.AutoscalerStatusDetails.Type):
            The type of error, warning, or notice returned. Current set
            of possible values:

            -  ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the
               instance group are unhealthy (not in RUNNING state).
            -  BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no
               backend service attached to the instance group.
            -  CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler
               recommends a size greater than maxNumReplicas.
            -  CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The
               custom metric samples are not exported often enough to be
               a credible base for autoscaling.
            -  CUSTOM_METRIC_INVALID (ERROR): The custom metric that was
               specified does not exist or does not have the necessary
               labels.
            -  MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
               maxNumReplicas. This means the autoscaler cannot add or
               remove instances from the instance group.
            -  MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The
               autoscaler did not receive any data from the custom
               metric configured for autoscaling.
            -  MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The
               autoscaler is configured to scale based on a load
               balancing signal but the instance group has not received
               any requests from the load balancer.
            -  MODE_OFF (WARNING): Autoscaling is turned off. The number
               of instances in the group won't change automatically. The
               autoscaling configuration is preserved.
            -  MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale
               only out" mode. The autoscaler can add instances but not
               remove any.
            -  MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group
               cannot be autoscaled because it has more than one backend
               service attached to it.
            -  NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient
               quota for the necessary resources, such as CPU or number
               of instances.
            -  REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional
               autoscalers: there is a resource stockout in the chosen
               region.
            -  SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be
               scaled does not exist.
            -  UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION
               (ERROR): Autoscaling does not work with an HTTP/S load
               balancer that has been configured for maxRate.
            -  ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers:
               there is a resource stockout in the chosen zone. For
               regional autoscalers: in at least one of the zones you're
               using there is a resource stockout. New values might be
               added in the future. Some of the values might not be
               available in all API versions.
    """

    class Type(proto.Enum):
        r"""The type of error, warning, or notice returned. Current set of
        possible values:

        -  ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance
           group are unhealthy (not in RUNNING state).
        -  BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend
           service attached to the instance group.
        -  CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a
           size greater than maxNumReplicas.
        -  CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
           samples are not exported often enough to be a credible base for
           autoscaling.
        -  CUSTOM_METRIC_INVALID (ERROR): The custom metric that was
           specified does not exist or does not have the necessary labels.
        -  MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
           maxNumReplicas. This means the autoscaler cannot add or remove
           instances from the instance group.
        -  MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did
           not receive any data from the custom metric configured for
           autoscaling.
        -  MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is
           configured to scale based on a load balancing signal but the
           instance group has not received any requests from the load
           balancer.
        -  MODE_OFF (WARNING): Autoscaling is turned off. The number of
           instances in the group won't change automatically. The
           autoscaling configuration is preserved.
        -  MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only
           out" mode. The autoscaler can add instances but not remove any.
        -  MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot
           be autoscaled because it has more than one backend service
           attached to it.
        -  NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota
           for the necessary resources, such as CPU or number of instances.
        -  REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional
           autoscalers: there is a resource stockout in the chosen region.
        -  SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled
           does not exist.
        -  UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
           Autoscaling does not work with an HTTP/S load balancer that has
           been configured for maxRate.
        -  ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a
           resource stockout in the chosen zone. For regional autoscalers:
           in at least one of the zones you're using there is a resource
           stockout. New values might be added in the future. Some of the
           values might not be available in all API versions.
        """
        UNDEFINED_TYPE = 0
        ALL_INSTANCES_UNHEALTHY = 404965477
        BACKEND_SERVICE_DOES_NOT_EXIST = 191417626
        CAPPED_AT_MAX_NUM_REPLICAS = 518617
        CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328964659
        CUSTOM_METRIC_INVALID = 204430550
        MIN_EQUALS_MAX = 2821361
        MISSING_CUSTOM_METRIC_DATA_POINTS = 94885086
        MISSING_LOAD_BALANCING_DATA_POINTS = 509858898
        MODE_OFF = 164169907
        MODE_ONLY_SCALE_OUT = 3840994
        MODE_ONLY_UP = 100969842
        MORE_THAN_ONE_BACKEND_SERVICE = 151922141
        NOT_ENOUGH_QUOTA_AVAILABLE = 403101631
        REGION_RESOURCE_STOCKOUT = 528622846
        SCALING_TARGET_DOES_NOT_EXIST = 122636699
        SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29275586
        SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398287669
        UNKNOWN = 433141802
        UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330845009
        ZONE_RESOURCE_STOCKOUT = 210200502

    message = proto.Field(proto.STRING, number=418054151, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class Autoscaler(proto.Message):
    r"""Represents an Autoscaler resource.

    Google Compute Engine has two Autoscaler resources:

    -  `Zonal </compute/docs/reference/rest/{$api_version}/autoscalers>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionAutoscalers>`__

    Use autoscalers to automatically add or delete instances from a
    managed instance group according to your defined autoscaling policy.
    For more information, read Autoscaling Groups of Instances.

    For zonal managed instance groups resource, use the autoscaler
    resource.

    For regional managed instance groups, use the regionAutoscalers
    resource. (== resource_for {$api_version}.autoscalers ==) (==
    resource_for {$api_version}.regionAutoscalers ==)

    Attributes:
        autoscaling_policy (google.cloud.compute_v1.types.AutoscalingPolicy):
            The configuration parameters for the
            autoscaling algorithm. You can define one or
            more signals for an autoscaler: cpuUtilization,
            customMetricUtilizations, and
            loadBalancingUtilization.  If none of these are
            specified, the default will be to autoscale
            based on cpuUtilization to 0.6 or 60%.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#autoscaler for autoscalers.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        recommended_size (int):
            [Output Only] Target recommended MIG size (number of
            instances) computed by autoscaler. Autoscaler calculates the
            recommended MIG size even when the autoscaling policy mode
            is different from ON. This field is empty when autoscaler is
            not connected to an existing managed instance group or
            autoscaler did not generate its prediction.
        region (str):
            [Output Only] URL of the region where the instance group
            resides (for autoscalers living in regional scope).
        scaling_schedule_status (Sequence[google.cloud.compute_v1.types.Autoscaler.ScalingScheduleStatusEntry]):
            [Output Only] Status information of existing scaling
            schedules.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        status (google.cloud.compute_v1.types.Autoscaler.Status):
            [Output Only] The status of the autoscaler configuration.
            Current set of possible values:

            -  PENDING: Autoscaler backend hasn't read new/updated
               configuration.
            -  DELETING: Configuration is being deleted.
            -  ACTIVE: Configuration is acknowledged to be effective.
               Some warnings might be present in the statusDetails
               field.
            -  ERROR: Configuration has errors. Actionable for users.
               Details are present in the statusDetails field. New
               values might be added in the future.
        status_details (Sequence[google.cloud.compute_v1.types.AutoscalerStatusDetails]):
            [Output Only] Human-readable details about the current state
            of the autoscaler. Read the documentation for Commonly
            returned status messages for examples of status messages you
            might encounter.
        target (str):
            URL of the managed instance group that this
            autoscaler will scale. This field is required
            when creating an autoscaler.
        zone (str):
            [Output Only] URL of the zone where the instance group
            resides (for autoscalers living in zonal scope).
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the autoscaler configuration. Current
        set of possible values:

        -  PENDING: Autoscaler backend hasn't read new/updated
           configuration.
        -  DELETING: Configuration is being deleted.
        -  ACTIVE: Configuration is acknowledged to be effective. Some
           warnings might be present in the statusDetails field.
        -  ERROR: Configuration has errors. Actionable for users. Details
           are present in the statusDetails field. New values might be added
           in the future.
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        DELETING = 528602024
        ERROR = 66247144
        PENDING = 35394935

    autoscaling_policy = proto.Field(
        proto.MESSAGE, number=221950041, optional=True, message="AutoscalingPolicy",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    recommended_size = proto.Field(proto.INT32, number=257915749, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    scaling_schedule_status = proto.MapField(
        proto.STRING, proto.MESSAGE, number=465950178, message="ScalingScheduleStatus",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_details = proto.RepeatedField(
        proto.MESSAGE, number=363353845, message="AutoscalerStatusDetails",
    )
    target = proto.Field(proto.STRING, number=192835985, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class AutoscalersScopedList(proto.Message):
    r"""
    Attributes:
        autoscalers (Sequence[google.cloud.compute_v1.types.Autoscaler]):
            [Output Only] A list of autoscalers contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of autoscalers when the list is empty.
    """

    autoscalers = proto.RepeatedField(
        proto.MESSAGE, number=465771644, message="Autoscaler",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalerAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.AutoscalerAggregatedList.ItemsEntry]):
            A list of AutoscalersScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerAggregatedList for aggregated lists of
            autoscalers.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="AutoscalersScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalerList(proto.Message):
    r"""Contains a list of Autoscaler resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Autoscaler]):
            A list of Autoscaler resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerList for lists of autoscalers.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Autoscaler",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class AutoscalingPolicyCpuUtilization(proto.Message):
    r"""CPU utilization policy.
    Attributes:
        predictive_method (google.cloud.compute_v1.types.AutoscalingPolicyCpuUtilization.PredictiveMethod):
            Indicates whether predictive autoscaling based on CPU metric
            is enabled. Valid values are:

            -  NONE (default). No predictive method is used. The
               autoscaler scales the group to meet current demand based
               on real-time metrics. \* OPTIMIZE_AVAILABILITY.
               Predictive autoscaling improves availability by
               monitoring daily and weekly load patterns and scaling out
               ahead of anticipated demand.
        utilization_target (float):
            The target CPU utilization that the autoscaler maintains.
            Must be a float value in the range (0, 1]. If not specified,
            the default is 0.6.

            If the CPU level is below the target utilization, the
            autoscaler scales in the number of instances until it
            reaches the minimum number of instances you specified or
            until the average CPU of your instances reaches the target
            utilization.

            If the average CPU is above the target utilization, the
            autoscaler scales out until it reaches the maximum number of
            instances you specified or until the average utilization
            reaches the target utilization.
    """

    class PredictiveMethod(proto.Enum):
        r"""Indicates whether predictive autoscaling based on CPU metric is
        enabled. Valid values are:

        -  NONE (default). No predictive method is used. The autoscaler
           scales the group to meet current demand based on real-time
           metrics. \* OPTIMIZE_AVAILABILITY. Predictive autoscaling
           improves availability by monitoring daily and weekly load
           patterns and scaling out ahead of anticipated demand.
        """
        UNDEFINED_PREDICTIVE_METHOD = 0
        NONE = 2402104
        OPTIMIZE_AVAILABILITY = 11629437

    predictive_method = proto.Field(
        proto.ENUM, number=390220737, optional=True, enum=PredictiveMethod,
    )
    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)


class AutoscalingPolicyCustomMetricUtilization(proto.Message):
    r"""Custom utilization metric policy.
    Attributes:
        filter (str):
            A filter string, compatible with a Stackdriver Monitoring
            filter string for TimeSeries.list API call. This filter is
            used to select a specific TimeSeries for the purpose of
            autoscaling and to determine whether the metric is exporting
            per-instance or per-group data.

            For the filter to be valid for autoscaling purposes, the
            following rules apply:

            -  You can only use the AND operator for joining selectors.
            -  You can only use direct equality comparison operator (=)
               without any functions for each selector.
            -  You can specify the metric in both the filter string and
               in the metric field. However, if specified in both
               places, the metric must be identical.
            -  The monitored resource type determines what kind of
               values are expected for the metric. If it is a
               gce_instance, the autoscaler expects the metric to
               include a separate TimeSeries for each instance in a
               group. In such a case, you cannot filter on resource
               labels. If the resource type is any other value, the
               autoscaler expects this metric to contain values that
               apply to the entire autoscaled instance group and
               resource label filtering can be performed to point
               autoscaler at the correct TimeSeries to scale upon. This
               is called a per-group metric for the purpose of
               autoscaling.

            If not specified, the type defaults to gce_instance.

            Try to provide a filter that is selective enough to pick
            just one TimeSeries for the autoscaled group or for each of
            the instances (if you are using gce_instance resource type).
            If multiple TimeSeries are returned upon the query
            execution, the autoscaler will sum their respective values
            to obtain its scaling value.
        metric (str):
            The identifier (type) of the Stackdriver
            Monitoring metric. The metric cannot have
            negative values.  The metric must have a value
            type of INT64 or DOUBLE.
        single_instance_assignment (float):
            If scaling is based on a per-group metric value that
            represents the total amount of work to be done or resource
            usage, set this value to an amount assigned for a single
            instance of the scaled group. Autoscaler keeps the number of
            instances proportional to the value of this metric. The
            metric itself does not change value due to group resizing.

            A good metric to use with the target is for example
            pubsub.googleapis.com/subscription/num_undelivered_messages
            or a custom metric exporting the total number of requests
            coming to your instances.

            A bad example would be a metric exporting an average or
            median latency, since this value can't include a chunk
            assignable to a single instance, it could be better used
            with utilization_target instead.
        utilization_target (float):
            The target value of the metric that autoscaler maintains.
            This must be a positive value. A utilization metric scales
            number of virtual machines handling requests to increase or
            decrease proportionally to the metric.

            For example, a good metric to use as a utilization_target is
            https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.
            The autoscaler works to keep this value constant for each of
            the instances.
        utilization_target_type (google.cloud.compute_v1.types.AutoscalingPolicyCustomMetricUtilization.UtilizationTargetType):
            Defines how target utilization value is expressed for a
            Stackdriver Monitoring metric. Either GAUGE,
            DELTA_PER_SECOND, or DELTA_PER_MINUTE.
    """

    class UtilizationTargetType(proto.Enum):
        r"""Defines how target utilization value is expressed for a Stackdriver
        Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
        DELTA_PER_MINUTE.
        """
        UNDEFINED_UTILIZATION_TARGET_TYPE = 0
        DELTA_PER_MINUTE = 87432861
        DELTA_PER_SECOND = 255180029
        GAUGE = 67590361

    filter = proto.Field(proto.STRING, number=336120696, optional=True,)
    metric = proto.Field(proto.STRING, number=533067184, optional=True,)
    single_instance_assignment = proto.Field(
        proto.DOUBLE, number=504768064, optional=True,
    )
    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)
    utilization_target_type = proto.Field(
        proto.ENUM, number=340169355, optional=True, enum=UtilizationTargetType,
    )


class AutoscalingPolicyLoadBalancingUtilization(proto.Message):
    r"""Configuration parameters of autoscaling based on load
    balancing.

    Attributes:
        utilization_target (float):
            Fraction of backend capacity utilization (set
            in HTTP(S) load balancing configuration) that
            the autoscaler maintains. Must be a positive
            float value. If not defined, the default is 0.8.
    """

    utilization_target = proto.Field(proto.DOUBLE, number=215905870, optional=True,)


class AutoscalingPolicyScaleInControl(proto.Message):
    r"""Configuration that allows for slower scale in so that even if
    Autoscaler recommends an abrupt scale in of a MIG, it will be
    throttled as specified by the parameters below.

    Attributes:
        max_scaled_in_replicas (google.cloud.compute_v1.types.FixedOrPercent):
            Maximum allowed number (or %) of VMs that can
            be deducted from the peak recommendation during
            the window autoscaler looks at when computing
            recommendations. Possibly all these VMs can be
            deleted at once so user service needs to be
            prepared to lose that many VMs in one step.
        time_window_sec (int):
            How far back autoscaling looks when computing
            recommendations to include directives regarding
            slower scale in, as described above.
    """

    max_scaled_in_replicas = proto.Field(
        proto.MESSAGE, number=180710123, optional=True, message="FixedOrPercent",
    )
    time_window_sec = proto.Field(proto.INT32, number=36405300, optional=True,)


class AutoscalingPolicyScalingSchedule(proto.Message):
    r"""Scaling based on user-defined schedule. The message describes
    a single scaling schedule. A scaling schedule changes the
    minimum number of VM instances an autoscaler can recommend,
    which can trigger scaling out.

    Attributes:
        description (str):
            A description of a scaling schedule.
        disabled (bool):
            A boolean value that specifies whether a
            scaling schedule can influence autoscaler
            recommendations. If set to true, then a scaling
            schedule has no effect. This field is optional,
            and its value is false by default.
        duration_sec (int):
            The duration of time intervals, in seconds,
            for which this scaling schedule is to run. The
            minimum allowed value is 300. This field is
            required.
        min_required_replicas (int):
            The minimum number of VM instances that the
            autoscaler will recommend in time intervals
            starting according to schedule. This field is
            required.
        schedule (str):
            The start timestamps of time intervals when this scaling
            schedule is to provide a scaling signal. This field uses the
            extended cron format (with an optional year field). The
            expression can describe a single timestamp if the optional
            year is set, in which case the scaling schedule runs once.
            The schedule is interpreted with respect to time_zone. This
            field is required. Note: These timestamps only describe when
            autoscaler starts providing the scaling signal. The VMs need
            additional time to become serving.
        time_zone (str):
            The time zone to use when interpreting the schedule. The
            value of this field must be a time zone name from the tz
            database: http://en.wikipedia.org/wiki/Tz_database. This
            field is assigned a default value of ?UTC? if left empty.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    duration_sec = proto.Field(proto.INT32, number=212356902, optional=True,)
    min_required_replicas = proto.Field(proto.INT32, number=365514414, optional=True,)
    schedule = proto.Field(proto.STRING, number=375820951, optional=True,)
    time_zone = proto.Field(proto.STRING, number=36848094, optional=True,)


class FixedOrPercent(proto.Message):
    r"""Encapsulates numeric value that can be either absolute or
    relative.

    Attributes:
        calculated (int):
            [Output Only] Absolute value of VM instances calculated
            based on the specific mode.

            -  If the value is fixed, then the calculated value is equal
               to the fixed value.
            -  If the value is a percent, then the calculated value is
               percent/100 \* targetSize. For example, the calculated
               value of a 80% of a managed instance group with 150
               instances would be (80/100 \* 150) = 120 VM instances. If
               there is a remainder, the number is rounded up.
        fixed (int):
            Specifies a fixed number of VM instances.
            This must be a positive integer.
        percent (int):
            Specifies a percentage of instances between 0
            to 100%, inclusive. For example, specify 80 for
            80%.
    """

    calculated = proto.Field(proto.INT32, number=472082878, optional=True,)
    fixed = proto.Field(proto.INT32, number=97445748, optional=True,)
    percent = proto.Field(proto.INT32, number=394814533, optional=True,)


class Backend(proto.Message):
    r"""Message containing information of one individual backend.
    Attributes:
        balancing_mode (google.cloud.compute_v1.types.Backend.BalancingMode):
            Specifies how to determine whether the
            backend of a load balancer can handle additional
            traffic or is fully loaded. For usage
            guidelines, see  Connection balancing mode.
        capacity_scaler (float):
            A multiplier applied to the backend's target capacity of its
            balancing mode. The default value is 1, which means the
            group serves up to 100% of its configured capacity
            (depending on balancingMode). A setting of 0 means the group
            is completely drained, offering 0% of its available
            capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot
            configure a setting larger than 0 and smaller than 0.1. You
            cannot configure a setting of 0 when there is only one
            backend attached to the backend service.

            Not supported by:

            -  Internal TCP/UDP Load Balancing - Network Load Balancing
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        failover (bool):
            This field designates whether this is a
            failover backend. More than one failover backend
            can be configured for a given BackendService.
        group (str):
            The fully-qualified URL of an instance group or network
            endpoint group (NEG) resource. The type of backend that a
            backend service supports depends on the backend service's
            loadBalancingScheme.

            -  When the loadBalancingScheme for the backend service is
               EXTERNAL (except Network Load Balancing),
               INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend
               can be either an instance group or a NEG. The backends on
               the backend service must be either all instance groups or
               all NEGs. You cannot mix instance group and NEG backends
               on the same backend service.

            -  When the loadBalancingScheme for the backend service is
               EXTERNAL for Network Load Balancing or INTERNAL for
               Internal TCP/UDP Load Balancing, the backend must be an
               instance group. NEGs are not supported.

            For regional services, the backend must be in the same
            region as the backend service.

            You must use the fully-qualified URL (starting with
            https://www.googleapis.com/) to specify the instance group
            or NEG. Partial URLs are not supported.
        max_connections (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE. Not supported by:  -
            Internal TCP/UDP Load Balancing - Network Load
            Balancing
        max_connections_per_endpoint (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode.  Not available if the backend's
            balancingMode is RATE. Not supported by:
            - Internal TCP/UDP Load Balancing - Network Load
            Balancing.
        max_connections_per_instance (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode.  Not available if the backend's
            balancingMode is RATE. Not supported by:
            - Internal TCP/UDP Load Balancing - Network Load
            Balancing.
        max_rate (int):
            Defines a maximum number of HTTP requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.
        max_rate_per_endpoint (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.
        max_rate_per_instance (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.
        max_utilization (float):

    """

    class BalancingMode(proto.Enum):
        r"""Specifies how to determine whether the backend of a load
        balancer can handle additional traffic or is fully loaded. For
        usage guidelines, see  Connection balancing mode.
        """
        UNDEFINED_BALANCING_MODE = 0
        CONNECTION = 246311646
        RATE = 2508000
        UTILIZATION = 157008386

    balancing_mode = proto.Field(
        proto.ENUM, number=430286217, optional=True, enum=BalancingMode,
    )
    capacity_scaler = proto.Field(proto.FLOAT, number=315958157, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    failover = proto.Field(proto.BOOL, number=138892530, optional=True,)
    group = proto.Field(proto.STRING, number=98629247, optional=True,)
    max_connections = proto.Field(proto.INT32, number=110652154, optional=True,)
    max_connections_per_endpoint = proto.Field(
        proto.INT32, number=216904604, optional=True,
    )
    max_connections_per_instance = proto.Field(
        proto.INT32, number=104671900, optional=True,
    )
    max_rate = proto.Field(proto.INT32, number=408035035, optional=True,)
    max_rate_per_endpoint = proto.Field(proto.FLOAT, number=129832283, optional=True,)
    max_rate_per_instance = proto.Field(proto.FLOAT, number=17599579, optional=True,)
    max_utilization = proto.Field(proto.FLOAT, number=148192199, optional=True,)


class BackendBucketCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    bucket.

    Attributes:
        bypass_cache_on_request_headers (Sequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_mode (google.cloud.compute_v1.types.BackendBucketCdnPolicy.CacheMode):
            Specifies the cache setting for all responses from this
            backend. The possible values are:

            USE_ORIGIN_HEADERS Requires the origin to set valid caching
            headers to cache content. Responses without these headers
            will not be cached at Google's edge, and will require a full
            trip to the origin on every request, potentially impacting
            performance and increasing load on the origin server.

            FORCE_CACHE_ALL Cache all content, ignoring any "private",
            "no-store" or "no-cache" directives in Cache-Control
            response headers. Warning: this may result in Cloud CDN
            caching private, per-user (user identifiable) content.

            CACHE_ALL_STATIC Automatically cache static content,
            including common image formats, media (video and audio), and
            web assets (JavaScript and CSS). Requests and responses that
            are marked as uncacheable, as well as dynamic content
            (including HTML), will not be cached.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 86400s (1 day).
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-max-age). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.
        negative_caching_policy (Sequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-max-age) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.
        signed_url_key_names (Sequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are:

        USE_ORIGIN_HEADERS Requires the origin to set valid caching headers
        to cache content. Responses without these headers will not be cached
        at Google's edge, and will require a full trip to the origin on
        every request, potentially impacting performance and increasing load
        on the origin server.

        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content.

        CACHE_ALL_STATIC Automatically cache static content, including
        common image formats, media (video and audio), and web assets
        (JavaScript and CSS). Requests and responses that are marked as
        uncacheable, as well as dynamic content (including HTML), will not
        be cached.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_mode = proto.Field(
        proto.ENUM, number=28877888, optional=True, enum=CacheMode,
    )
    client_ttl = proto.Field(proto.INT32, number=29034360, optional=True,)
    default_ttl = proto.Field(proto.INT32, number=100253422, optional=True,)
    max_ttl = proto.Field(proto.INT32, number=307578001, optional=True,)
    negative_caching = proto.Field(proto.BOOL, number=336110005, optional=True,)
    negative_caching_policy = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendBucketCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing = proto.Field(proto.BOOL, number=532808276, optional=True,)
    serve_while_stale = proto.Field(proto.INT32, number=236682203, optional=True,)
    signed_url_cache_max_age_sec = proto.Field(
        proto.INT64, number=269374534, optional=True,
    )
    signed_url_key_names = proto.RepeatedField(proto.STRING, number=371848885,)


class BackendBucket(proto.Message):
    r"""Represents a Cloud Storage Bucket resource.
    This Cloud Storage bucket resource is referenced by a URL map of
    a load balancer. For more information, read Backend Buckets.

    Attributes:
        bucket_name (str):
            Cloud Storage bucket name.
        cdn_policy (google.cloud.compute_v1.types.BackendBucketCdnPolicy):
            Cloud CDN configuration for this
            BackendBucket.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        custom_response_headers (Sequence[str]):
            Headers that the HTTP/S load balancer should
            add to proxied responses.
        description (str):
            An optional textual description of the
            resource; provided by the client when the
            resource is created.
        enable_cdn (bool):
            If true, enable Cloud CDN for this
            BackendBucket.
        id (int):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        kind (str):
            Type of the resource.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    bucket_name = proto.Field(proto.STRING, number=283610048, optional=True,)
    cdn_policy = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendBucketCdnPolicy",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    custom_response_headers = proto.RepeatedField(proto.STRING, number=387539094,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable_cdn = proto.Field(proto.BOOL, number=282942321, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class BackendBucketCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)


class BackendBucketCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.
    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.
    """

    code = proto.Field(proto.INT32, number=3059181, optional=True,)
    ttl = proto.Field(proto.INT32, number=115180, optional=True,)


class BackendBucketList(proto.Message):
    r"""Contains a list of BackendBucket resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.BackendBucket]):
            A list of BackendBucket resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="BackendBucket",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    service.

    Attributes:
        bypass_cache_on_request_headers (Sequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_key_policy (google.cloud.compute_v1.types.CacheKeyPolicy):
            The CacheKeyPolicy for this CdnPolicy.
        cache_mode (google.cloud.compute_v1.types.BackendServiceCdnPolicy.CacheMode):
            Specifies the cache setting for all responses from this
            backend. The possible values are:

            USE_ORIGIN_HEADERS Requires the origin to set valid caching
            headers to cache content. Responses without these headers
            will not be cached at Google's edge, and will require a full
            trip to the origin on every request, potentially impacting
            performance and increasing load on the origin server.

            FORCE_CACHE_ALL Cache all content, ignoring any "private",
            "no-store" or "no-cache" directives in Cache-Control
            response headers. Warning: this may result in Cloud CDN
            caching private, per-user (user identifiable) content.

            CACHE_ALL_STATIC Automatically cache static content,
            including common image formats, media (video and audio), and
            web assets (JavaScript and CSS). Requests and responses that
            are marked as uncacheable, as well as dynamic content
            (including HTML), will not be cached.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 86400s (1 day).
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-max-age). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.
        negative_caching_policy (Sequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-max-age) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.
        signed_url_key_names (Sequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are:

        USE_ORIGIN_HEADERS Requires the origin to set valid caching headers
        to cache content. Responses without these headers will not be cached
        at Google's edge, and will require a full trip to the origin on
        every request, potentially impacting performance and increasing load
        on the origin server.

        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content.

        CACHE_ALL_STATIC Automatically cache static content, including
        common image formats, media (video and audio), and web assets
        (JavaScript and CSS). Requests and responses that are marked as
        uncacheable, as well as dynamic content (including HTML), will not
        be cached.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_key_policy = proto.Field(
        proto.MESSAGE, number=159263727, optional=True, message="CacheKeyPolicy",
    )
    cache_mode = proto.Field(
        proto.ENUM, number=28877888, optional=True, enum=CacheMode,
    )
    client_ttl = proto.Field(proto.INT32, number=29034360, optional=True,)
    default_ttl = proto.Field(proto.INT32, number=100253422, optional=True,)
    max_ttl = proto.Field(proto.INT32, number=307578001, optional=True,)
    negative_caching = proto.Field(proto.BOOL, number=336110005, optional=True,)
    negative_caching_policy = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendServiceCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing = proto.Field(proto.BOOL, number=532808276, optional=True,)
    serve_while_stale = proto.Field(proto.INT32, number=236682203, optional=True,)
    signed_url_cache_max_age_sec = proto.Field(
        proto.INT64, number=269374534, optional=True,
    )
    signed_url_key_names = proto.RepeatedField(proto.STRING, number=371848885,)


class CircuitBreakers(proto.Message):
    r"""Settings controlling the volume of connections to a backend
    service.

    Attributes:
        max_connections (int):
            The maximum number of connections to the
            backend service. If not specified, there is no
            limit.
        max_pending_requests (int):
            The maximum number of pending requests
            allowed to the backend service. If not
            specified, there is no limit.
        max_requests (int):
            The maximum number of parallel requests that
            allowed to the backend service. If not
            specified, there is no limit.
        max_requests_per_connection (int):
            Maximum requests for a single connection to
            the backend service. This parameter is respected
            by both the HTTP/1.1 and HTTP/2 implementations.
            If not specified, there is no limit. Setting
            this parameter to 1 will effectively disable
            keep alive.
        max_retries (int):
            The maximum number of parallel retries
            allowed to the backend cluster. If not
            specified, the default is 1.
    """

    max_connections = proto.Field(proto.INT32, number=110652154, optional=True,)
    max_pending_requests = proto.Field(proto.INT32, number=375558887, optional=True,)
    max_requests = proto.Field(proto.INT32, number=28097599, optional=True,)
    max_requests_per_connection = proto.Field(
        proto.INT32, number=361630528, optional=True,
    )
    max_retries = proto.Field(proto.INT32, number=55546219, optional=True,)


class ConnectionDraining(proto.Message):
    r"""Message containing connection draining configuration.
    Attributes:
        draining_timeout_sec (int):
            Configures a duration timeout for existing
            requests on a removed backend instance. For
            supported load balancers and protocols, as
            described in Enabling connection draining.
    """

    draining_timeout_sec = proto.Field(proto.INT32, number=225127070, optional=True,)


class ConsistentHashLoadBalancerSettings(proto.Message):
    r"""This message defines settings for a consistent hash style
    load balancer.

    Attributes:
        http_cookie (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettingsHttpCookie):
            Hash is based on HTTP Cookie. This field describes a HTTP
            cookie that will be used as the hash key for the consistent
            hash load balancer. If the cookie is not present, it will be
            generated. This field is applicable if the sessionAffinity
            is set to HTTP_COOKIE.
        http_header_name (str):
            The hash based on the value of the specified header field.
            This field is applicable if the sessionAffinity is set to
            HEADER_FIELD.
        minimum_ring_size (int):
            The minimum number of virtual nodes to use
            for the hash ring. Defaults to 1024. Larger ring
            sizes result in more granular load
            distributions. If the number of hosts in the
            load balancing pool is larger than the ring
            size, each host will be assigned a single
            virtual node.
    """

    http_cookie = proto.Field(
        proto.MESSAGE,
        number=6673915,
        optional=True,
        message="ConsistentHashLoadBalancerSettingsHttpCookie",
    )
    http_header_name = proto.Field(proto.STRING, number=234798022, optional=True,)
    minimum_ring_size = proto.Field(proto.INT64, number=234380735, optional=True,)


class BackendServiceFailoverPolicy(proto.Message):
    r"""Applicable only to Failover for Internal TCP/UDP Load
    Balancing and Network Load Balancing. On failover or failback,
    this field indicates whether connection draining will be
    honored. GCP has a fixed connection draining timeout of 10
    minutes. A setting of true terminates existing TCP connections
    to the active pool during failover and failback, immediately
    draining traffic. A setting of false allows existing TCP
    connections to persist, even on VMs no longer in the active
    pool, for up to the duration of the connection draining timeout
    (10 minutes).

    Attributes:
        disable_connection_drain_on_failover (bool):
            This can be set to true only if the protocol
            is TCP.
            The default is false.
        drop_traffic_if_unhealthy (bool):
            Applicable only to Failover for Internal
            TCP/UDP Load Balancing and Network Load
            Balancing, If set to true, connections to the
            load balancer are dropped when all primary and
            all backup backend VMs are unhealthy.If set to
            false, connections are distributed among all
            primary VMs when all primary and all backup
            backend VMs are unhealthy. The default is false.
        failover_ratio (float):
            Applicable only to Failover for Internal TCP/UDP Load
            Balancing and Network Load Balancing. The value of the field
            must be in the range [0, 1]. If the value is 0, the load
            balancer performs a failover when the number of healthy
            primary VMs equals zero. For all other values, the load
            balancer performs a failover when the total number of
            healthy primary VMs is less than this ratio.
    """

    disable_connection_drain_on_failover = proto.Field(
        proto.BOOL, number=182150753, optional=True,
    )
    drop_traffic_if_unhealthy = proto.Field(
        proto.BOOL, number=112289428, optional=True,
    )
    failover_ratio = proto.Field(proto.FLOAT, number=212667006, optional=True,)


class BackendServiceIAP(proto.Message):
    r"""Identity-Aware Proxy
    Attributes:
        enabled (bool):
            Whether the serving infrastructure will
            authenticate and authorize all incoming
            requests. If true, the oauth2ClientId and
            oauth2ClientSecret fields must be non-empty.
        oauth2_client_id (str):
            OAuth2 client ID to use for the
            authentication flow.
        oauth2_client_secret (str):
            OAuth2 client secret to use for the
            authentication flow. For security reasons, this
            value cannot be retrieved via the API. Instead,
            the SHA-256 hash of the value is returned in the
            oauth2ClientSecretSha256 field.
        oauth2_client_secret_sha256 (str):
            [Output Only] SHA256 hash value for the field
            oauth2_client_secret above.
    """

    enabled = proto.Field(proto.BOOL, number=1018689, optional=True,)
    oauth2_client_id = proto.Field(proto.STRING, number=314017611, optional=True,)
    oauth2_client_secret = proto.Field(proto.STRING, number=50999520, optional=True,)
    oauth2_client_secret_sha256 = proto.Field(
        proto.STRING, number=112903782, optional=True,
    )


class BackendServiceLogConfig(proto.Message):
    r"""The available logging options for the load balancer traffic
    served by this backend service.

    Attributes:
        enable (bool):
            This field denotes whether to enable logging
            for the load balancer traffic served by this
            backend service.
        sample_rate (float):
            This field can only be specified if logging is enabled for
            this backend service. The value of the field must be in [0,
            1]. This configures the sampling rate of requests to the
            load balancer where 1.0 means all logged requests are
            reported and 0.0 means no logged requests are reported. The
            default value is 1.0.
    """

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    sample_rate = proto.Field(proto.FLOAT, number=153193045, optional=True,)


class Duration(proto.Message):
    r"""A Duration represents a fixed-length span of time represented
    as a count of seconds and fractions of seconds at nanosecond
    resolution. It is independent of any calendar and concepts like
    "day" or "month". Range is approximately 10,000 years.

    Attributes:
        nanos (int):
            Span of time that's a fraction of a second at nanosecond
            resolution. Durations less than one second are represented
            with a 0 ``seconds`` field and a positive ``nanos`` field.
            Must be from 0 to 999,999,999 inclusive.
        seconds (int):
            Span of time at a resolution of a second. Must be from 0 to
            315,576,000,000 inclusive. Note: these bounds are computed
            from: 60 sec/min \* 60 min/hr \* 24 hr/day \* 365.25
            days/year \* 10000 years
    """

    nanos = proto.Field(proto.INT32, number=104586303, optional=True,)
    seconds = proto.Field(proto.INT64, number=359484031, optional=True,)


class OutlierDetection(proto.Message):
    r"""Settings controlling the eviction of unhealthy hosts from the
    load balancing pool for the backend service.

    Attributes:
        base_ejection_time (google.cloud.compute_v1.types.Duration):
            The base time that a host is ejected for. The
            real ejection time is equal to the base ejection
            time multiplied by the number of times the host
            has been ejected. Defaults to 30000ms or 30s.
        consecutive_errors (int):
            Number of errors before a host is ejected
            from the connection pool. When the backend host
            is accessed over HTTP, a 5xx return code
            qualifies as an error. Defaults to 5.
        consecutive_gateway_failure (int):
            The number of consecutive gateway failures
            (502, 503, 504 status or connection errors that
            are mapped to one of those status codes) before
            a consecutive gateway failure ejection occurs.
            Defaults to 3.
        enforcing_consecutive_errors (int):
            The percentage chance that a host will be
            actually ejected when an outlier status is
            detected through consecutive 5xx. This setting
            can be used to disable ejection or to ramp it up
            slowly. Defaults to 0.
        enforcing_consecutive_gateway_failure (int):
            The percentage chance that a host will be
            actually ejected when an outlier status is
            detected through consecutive gateway failures.
            This setting can be used to disable ejection or
            to ramp it up slowly. Defaults to 100.
        enforcing_success_rate (int):
            The percentage chance that a host will be
            actually ejected when an outlier status is
            detected through success rate statistics. This
            setting can be used to disable ejection or to
            ramp it up slowly. Defaults to 100.
        interval (google.cloud.compute_v1.types.Duration):
            Time interval between ejection analysis
            sweeps. This can result in both new ejections as
            well as hosts being returned to service.
            Defaults to 1 second.
        max_ejection_percent (int):
            Maximum percentage of hosts in the load
            balancing pool for the backend service that can
            be ejected. Defaults to 50%.
        success_rate_minimum_hosts (int):
            The number of hosts in a cluster that must
            have enough request volume to detect success
            rate outliers. If the number of hosts is less
            than this setting, outlier detection via success
            rate statistics is not performed for any host in
            the cluster. Defaults to 5.
        success_rate_request_volume (int):
            The minimum number of total requests that
            must be collected in one interval (as defined by
            the interval duration above) to include this
            host in success rate based outlier detection. If
            the volume is lower than this setting, outlier
            detection via success rate statistics is not
            performed for that host. Defaults to 100.
        success_rate_stdev_factor (int):
            This factor is used to determine the ejection threshold for
            success rate outlier ejection. The ejection threshold is the
            difference between the mean success rate, and the product of
            this factor and the standard deviation of the mean success
            rate: mean - (stdev \* success_rate_stdev_factor). This
            factor is divided by a thousand to get a double. That is, if
            the desired factor is 1.9, the runtime value should be 1900.
            Defaults to 1900.
    """

    base_ejection_time = proto.Field(
        proto.MESSAGE, number=80997255, optional=True, message="Duration",
    )
    consecutive_errors = proto.Field(proto.INT32, number=387193248, optional=True,)
    consecutive_gateway_failure = proto.Field(
        proto.INT32, number=417504250, optional=True,
    )
    enforcing_consecutive_errors = proto.Field(
        proto.INT32, number=213133760, optional=True,
    )
    enforcing_consecutive_gateway_failure = proto.Field(
        proto.INT32, number=394440666, optional=True,
    )
    enforcing_success_rate = proto.Field(proto.INT32, number=194508732, optional=True,)
    interval = proto.Field(
        proto.MESSAGE, number=33547461, optional=True, message="Duration",
    )
    max_ejection_percent = proto.Field(proto.INT32, number=18436888, optional=True,)
    success_rate_minimum_hosts = proto.Field(
        proto.INT32, number=525766903, optional=True,
    )
    success_rate_request_volume = proto.Field(
        proto.INT32, number=281425357, optional=True,
    )
    success_rate_stdev_factor = proto.Field(
        proto.INT32, number=174735773, optional=True,
    )


class SecuritySettings(proto.Message):
    r"""The authentication and authorization settings for a
    BackendService.

    Attributes:
        client_tls_policy (str):
            Optional. A URL referring to a
            networksecurity.ClientTlsPolicy resource that describes how
            clients should authenticate with this service's backends.
            clientTlsPolicy only applies to a global BackendService with
            the loadBalancingScheme set to INTERNAL_SELF_MANAGED. If
            left blank, communications are not encrypted. Note: This
            field currently has no impact.
        subject_alt_names (Sequence[str]):
            Optional. A list of Subject Alternative Names (SANs) that
            the client verifies during a mutual TLS handshake with an
            server/endpoint for this BackendService. When the server
            presents its X.509 certificate to the client, the client
            inspects the certificate's subjectAltName field. If the
            field contains one of the specified values, the
            communication continues. Otherwise, it fails. This
            additional check enables the client to verify that the
            server is authorized to run the requested service. Note that
            the contents of the server certificate's subjectAltName
            field are configured by the Public Key Infrastructure which
            provisions server identities. Only applies to a global
            BackendService with loadBalancingScheme set to
            INTERNAL_SELF_MANAGED. Only applies when BackendService has
            an attached clientTlsPolicy with clientCertificate (mTLS
            mode). Note: This field currently has no impact.
    """

    client_tls_policy = proto.Field(proto.STRING, number=462325226, optional=True,)
    subject_alt_names = proto.RepeatedField(proto.STRING, number=330029535,)


class BackendService(proto.Message):
    r"""Represents a Backend Service resource.

    A backend service defines how Google Cloud load balancers distribute
    traffic. The backend service configuration contains a set of values,
    such as the protocol used to connect to backends, various
    distribution and session settings, health checks, and timeouts.
    These settings provide fine-grained control over how your load
    balancer behaves. Most of the settings have default values that
    allow for easy configuration if you need to get started quickly.

    Backend services in Google Compute Engine can be either regionally
    or globally scoped.

    -  `Global </compute/docs/reference/rest/{$api_version}/backendServices>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionBackendServices>`__

    For more information, see Backend Services.

    (== resource_for {$api_version}.backendService ==)

    Attributes:
        affinity_cookie_ttl_sec (int):
            Lifetime of cookies in seconds. Only applicable if the
            loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or
            INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the
            sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.

            If set to 0, the cookie is non-persistent and lasts only
            until the end of the browser session (or equivalent). The
            maximum allowed value is one day (86,400).

            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        backends (Sequence[google.cloud.compute_v1.types.Backend]):
            The list of backends that serve this
            BackendService.
        cdn_policy (google.cloud.compute_v1.types.BackendServiceCdnPolicy):
            Cloud CDN configuration for this
            BackendService. Only available for  external
            HTTP(S) Load Balancing.
        circuit_breakers (google.cloud.compute_v1.types.CircuitBreakers):
            Settings controlling the volume of connections to a backend
            service. If not set, this feature is considered disabled.

            This field is applicable to either:

            -  A regional backend service with the service_protocol set
               to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set
               to INTERNAL_MANAGED.
            -  A global backend service with the load_balancing_scheme
               set to INTERNAL_SELF_MANAGED.

            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        connection_draining (google.cloud.compute_v1.types.ConnectionDraining):

        consistent_hash (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettings):
            Consistent Hash-based load balancing can be used to provide
            soft session affinity based on HTTP headers, cookies or
            other properties. This load balancing policy is applicable
            only for HTTP connections. The affinity to a particular
            destination host will be lost when one or more hosts are
            added/removed from the destination service. This field
            specifies parameters that control consistent hashing. This
            field is only applicable when localityLbPolicy is set to
            MAGLEV or RING_HASH.

            This field is applicable to either:

            -  A regional backend service with the service_protocol set
               to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set
               to INTERNAL_MANAGED.
            -  A global backend service with the load_balancing_scheme
               set to INTERNAL_SELF_MANAGED.

            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        custom_request_headers (Sequence[str]):
            Headers that the HTTP/S load balancer should
            add to proxied requests.
        custom_response_headers (Sequence[str]):
            Headers that the HTTP/S load balancer should
            add to proxied responses.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        enable_c_d_n (bool):
            If true, enables Cloud CDN for the backend
            service. Only applicable if the
            loadBalancingScheme is EXTERNAL and the protocol
            is HTTP or HTTPS.
        failover_policy (google.cloud.compute_v1.types.BackendServiceFailoverPolicy):
            Applicable only to Failover for Internal
            TCP/UDP Load Balancing and Network Load
            Balancing. Requires at least one backend
            instance group to be defined as a backup
            (failover) backend.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a BackendService. An up-
            to-date fingerprint must be provided in order to
            update the BackendService, otherwise the request
            will fail with error 412 conditionNotMet.  To
            see the latest fingerprint, make a get() request
            to retrieve a BackendService.
        health_checks (Sequence[str]):
            The list of URLs to the healthChecks,
            httpHealthChecks (legacy), or httpsHealthChecks
            (legacy) resource for health checking this
            backend service. Not all backend services
            support legacy health checks. See  Load balancer
            guide. Currently, at most one health check can
            be specified for each backend service. Backend
            services with instance group or zonal NEG
            backends must have a health check. Backend
            services with internet or serverless NEG
            backends must not have a health check.
        iap (google.cloud.compute_v1.types.BackendServiceIAP):
            The configurations for Identity-Aware Proxy
            on this resource. Not available for Internal
            TCP/UDP Load Balancing and Network Load
            Balancing.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendService for backend services.
        load_balancing_scheme (google.cloud.compute_v1.types.BackendService.LoadBalancingScheme):
            Specifies the load balancer type. Choose EXTERNAL for
            external HTTP(S), SSL Proxy, TCP Proxy and Network Load
            Balancing. Choose INTERNAL for Internal TCP/UDP Load
            Balancing. Choose INTERNAL_MANAGED for Internal HTTP(S) Load
            Balancing. INTERNAL_SELF_MANAGED for Traffic Director. A
            backend service created for one type of load balancer cannot
            be used with another. For more information, refer to
            Choosing a load balancer.
        locality_lb_policy (google.cloud.compute_v1.types.BackendService.LocalityLbPolicy):
            The load balancing algorithm used within the scope of the
            locality. The possible values are:

            -  ROUND_ROBIN: This is a simple policy in which each
               healthy backend is selected in round robin order. This is
               the default.
            -  LEAST_REQUEST: An O(1) algorithm which selects two random
               healthy hosts and picks the host which has fewer active
               requests.
            -  RING_HASH: The ring/modulo hash load balancer implements
               consistent hashing to backends. The algorithm has the
               property that the addition/removal of a host from a set
               of N hosts only affects 1/N of the requests.
            -  RANDOM: The load balancer selects a random healthy host.
            -  ORIGINAL_DESTINATION: Backend host is selected based on
               the client connection metadata, i.e., connections are
               opened to the same address as the destination address of
               the incoming connection before the connection was
               redirected to the load balancer.
            -  MAGLEV: used as a drop in replacement for the ring hash
               load balancer. Maglev is not as stable as ring hash but
               has faster table lookup build times and host selection
               times. For more information about Maglev, see
               https://ai.google/research/pubs/pub44824

            This field is applicable to either:

            -  A regional backend service with the service_protocol set
               to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set
               to INTERNAL_MANAGED.
            -  A global backend service with the load_balancing_scheme
               set to INTERNAL_SELF_MANAGED.

            If sessionAffinity is not NONE, and this field is not set to
            MAGLEV or RING_HASH, session affinity settings will not take
            effect.

            Only the default ROUND_ROBIN policy is supported when the
            backend service is referenced by a URL map that is bound to
            target gRPC proxy that has validateForProxyless field set to
            true.
        log_config (google.cloud.compute_v1.types.BackendServiceLogConfig):
            This field denotes the logging options for
            the load balancer traffic served by this backend
            service. If logging is enabled, logs will be
            exported to Stackdriver.
        max_stream_duration (google.cloud.compute_v1.types.Duration):
            Specifies the default maximum duration (timeout) for streams
            to this service. Duration is computed from the beginning of
            the stream until the response has been completely processed,
            including all retries. A stream that does not complete in
            this duration is closed. If not specified, there will be no
            timeout limit, i.e. the maximum duration is infinite. This
            field is only allowed when the loadBalancingScheme of the
            backend service is INTERNAL_SELF_MANAGED.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        network (str):
            The URL of the network to which this backend
            service belongs. This field can only be
            specified when the load balancing scheme is set
            to INTERNAL.
        outlier_detection (google.cloud.compute_v1.types.OutlierDetection):
            Settings controlling the eviction of unhealthy hosts from
            the load balancing pool for the backend service. If not set,
            this feature is considered disabled.

            This field is applicable to either:

            -  A regional backend service with the service_protocol set
               to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set
               to INTERNAL_MANAGED.
            -  A global backend service with the load_balancing_scheme
               set to INTERNAL_SELF_MANAGED.

            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        port (int):
            Deprecated in favor of portName. The TCP port
            to connect on the backend. The default value is
            80.  Backend services for Internal TCP/UDP Load
            Balancing and Network Load Balancing require you
            omit port.
        port_name (str):
            A named port on a backend instance group representing the
            port for communication to the backend VMs in that group.
            Required when the loadBalancingScheme is EXTERNAL (except
            Network Load Balancing), INTERNAL_MANAGED, or
            INTERNAL_SELF_MANAGED and the backends are instance groups.
            The named port must be defined on each backend instance
            group. This parameter has no meaning if the backends are
            NEGs.

            Backend services for Internal TCP/UDP Load Balancing and
            Network Load Balancing require you omit port_name.
        protocol (google.cloud.compute_v1.types.BackendService.Protocol):
            The protocol this BackendService uses to
            communicate with backends.
            Possible values are HTTP, HTTPS, HTTP2, TCP,
            SSL, UDP or GRPC. depending on the chosen load
            balancer or Traffic Director configuration.
            Refer to the documentation for the load balancer
            or for Traffic Director for more information.
            Must be set to GRPC when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy.
        region (str):
            [Output Only] URL of the region where the regional backend
            service resides. This field is not applicable to global
            backend services. You must specify this field as part of the
            HTTP request URL. It is not settable as a field in the
            request body.
        security_policy (str):
            [Output Only] The resource URL for the security policy
            associated with this backend service.
        security_settings (google.cloud.compute_v1.types.SecuritySettings):
            This field specifies the security policy that applies to
            this backend service. This field is applicable to either:

            -  A regional backend service with the service_protocol set
               to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set
               to INTERNAL_MANAGED.
            -  A global backend service with the load_balancing_scheme
               set to INTERNAL_SELF_MANAGED.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        session_affinity (google.cloud.compute_v1.types.BackendService.SessionAffinity):
            Type of session affinity to use. The default is NONE.

            When the loadBalancingScheme is EXTERNAL: \* For Network
            Load Balancing, the possible values are NONE, CLIENT_IP,
            CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO. \* For all other
            load balancers that use loadBalancingScheme=EXTERNAL, the
            possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. \*
            You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2,
            or HTTPS.

            When the loadBalancingScheme is INTERNAL, possible values
            are NONE, CLIENT_IP, CLIENT_IP_PROTO, or
            CLIENT_IP_PORT_PROTO.

            When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or
            INTERNAL_MANAGED, possible values are NONE, CLIENT_IP,
            GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.

            Not supported when the backend service is referenced by a
            URL map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        timeout_sec (int):
            The backend service timeout has a different
            meaning depending on the type of load balancer.
            For more information see,  Backend service
            settings The default is 30 seconds. The full
            range of timeout values allowed is 1 -
            2,147,483,647 seconds.
    """

    class LoadBalancingScheme(proto.Enum):
        r"""Specifies the load balancer type. Choose EXTERNAL for external
        HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose
        INTERNAL for Internal TCP/UDP Load Balancing. Choose
        INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.
        INTERNAL_SELF_MANAGED for Traffic Director. A backend service
        created for one type of load balancer cannot be used with another.
        For more information, refer to Choosing a load balancer.
        """
        UNDEFINED_LOAD_BALANCING_SCHEME = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        INTERNAL_MANAGED = 37350397
        INTERNAL_SELF_MANAGED = 236211150
        INVALID_LOAD_BALANCING_SCHEME = 275352060

    class LocalityLbPolicy(proto.Enum):
        r"""The load balancing algorithm used within the scope of the locality.
        The possible values are:

        -  ROUND_ROBIN: This is a simple policy in which each healthy
           backend is selected in round robin order. This is the default.
        -  LEAST_REQUEST: An O(1) algorithm which selects two random healthy
           hosts and picks the host which has fewer active requests.
        -  RING_HASH: The ring/modulo hash load balancer implements
           consistent hashing to backends. The algorithm has the property
           that the addition/removal of a host from a set of N hosts only
           affects 1/N of the requests.
        -  RANDOM: The load balancer selects a random healthy host.
        -  ORIGINAL_DESTINATION: Backend host is selected based on the
           client connection metadata, i.e., connections are opened to the
           same address as the destination address of the incoming
           connection before the connection was redirected to the load
           balancer.
        -  MAGLEV: used as a drop in replacement for the ring hash load
           balancer. Maglev is not as stable as ring hash but has faster
           table lookup build times and host selection times. For more
           information about Maglev, see
           https://ai.google/research/pubs/pub44824

        This field is applicable to either:

        -  A regional backend service with the service_protocol set to HTTP,
           HTTPS, or HTTP2, and load_balancing_scheme set to
           INTERNAL_MANAGED.
        -  A global backend service with the load_balancing_scheme set to
           INTERNAL_SELF_MANAGED.

        If sessionAffinity is not NONE, and this field is not set to MAGLEV
        or RING_HASH, session affinity settings will not take effect.

        Only the default ROUND_ROBIN policy is supported when the backend
        service is referenced by a URL map that is bound to target gRPC
        proxy that has validateForProxyless field set to true.
        """
        UNDEFINED_LOCALITY_LB_POLICY = 0
        INVALID_LB_POLICY = 323318707
        LEAST_REQUEST = 46604921
        MAGLEV = 119180266
        ORIGINAL_DESTINATION = 166297216
        RANDOM = 262527171
        RING_HASH = 432795069
        ROUND_ROBIN = 153895801

    class Protocol(proto.Enum):
        r"""The protocol this BackendService uses to communicate with
        backends.
        Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC.
        depending on the chosen load balancer or Traffic Director
        configuration. Refer to the documentation for the load balancer
        or for Traffic Director for more information.
        Must be set to GRPC when the backend service is referenced by a
        URL map that is bound to target gRPC proxy.
        """
        UNDEFINED_PROTOCOL = 0
        GRPC = 2196510
        HTTP = 2228360
        HTTP2 = 69079210
        HTTPS = 69079243
        SSL = 82412
        TCP = 82881
        UDP = 83873

    class SessionAffinity(proto.Enum):
        r"""Type of session affinity to use. The default is NONE.

        When the loadBalancingScheme is EXTERNAL: \* For Network Load
        Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO,
        or CLIENT_IP_PORT_PROTO. \* For all other load balancers that use
        loadBalancingScheme=EXTERNAL, the possible values are NONE,
        CLIENT_IP, or GENERATED_COOKIE. \* You can use GENERATED_COOKIE if
        the protocol is HTTP, HTTP2, or HTTPS.

        When the loadBalancingScheme is INTERNAL, possible values are NONE,
        CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.

        When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or
        INTERNAL_MANAGED, possible values are NONE, CLIENT_IP,
        GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.

        Not supported when the backend service is referenced by a URL map
        that is bound to target gRPC proxy that has validateForProxyless
        field set to true.
        """
        UNDEFINED_SESSION_AFFINITY = 0
        CLIENT_IP = 345665051
        CLIENT_IP_NO_DESTINATION = 106122516
        CLIENT_IP_PORT_PROTO = 221722926
        CLIENT_IP_PROTO = 25322148
        GENERATED_COOKIE = 370321204
        HEADER_FIELD = 200737960
        HTTP_COOKIE = 494981627
        NONE = 2402104

    affinity_cookie_ttl_sec = proto.Field(proto.INT32, number=369996954, optional=True,)
    backends = proto.RepeatedField(proto.MESSAGE, number=510839903, message="Backend",)
    cdn_policy = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendServiceCdnPolicy",
    )
    circuit_breakers = proto.Field(
        proto.MESSAGE, number=421340061, optional=True, message="CircuitBreakers",
    )
    connection_draining = proto.Field(
        proto.MESSAGE, number=461096747, optional=True, message="ConnectionDraining",
    )
    consistent_hash = proto.Field(
        proto.MESSAGE,
        number=905883,
        optional=True,
        message="ConsistentHashLoadBalancerSettings",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    custom_request_headers = proto.RepeatedField(proto.STRING, number=27977992,)
    custom_response_headers = proto.RepeatedField(proto.STRING, number=387539094,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable_c_d_n = proto.Field(proto.BOOL, number=250733499, optional=True,)
    failover_policy = proto.Field(
        proto.MESSAGE,
        number=105658655,
        optional=True,
        message="BackendServiceFailoverPolicy",
    )
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    health_checks = proto.RepeatedField(proto.STRING, number=448370606,)
    iap = proto.Field(
        proto.MESSAGE, number=104024, optional=True, message="BackendServiceIAP",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    load_balancing_scheme = proto.Field(
        proto.ENUM, number=363890244, optional=True, enum=LoadBalancingScheme,
    )
    locality_lb_policy = proto.Field(
        proto.ENUM, number=131431487, optional=True, enum=LocalityLbPolicy,
    )
    log_config = proto.Field(
        proto.MESSAGE,
        number=351299741,
        optional=True,
        message="BackendServiceLogConfig",
    )
    max_stream_duration = proto.Field(
        proto.MESSAGE, number=61428376, optional=True, message="Duration",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    outlier_detection = proto.Field(
        proto.MESSAGE, number=354625086, optional=True, message="OutlierDetection",
    )
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    protocol = proto.Field(proto.ENUM, number=84577944, optional=True, enum=Protocol,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    security_policy = proto.Field(proto.STRING, number=171082513, optional=True,)
    security_settings = proto.Field(
        proto.MESSAGE, number=478649922, optional=True, message="SecuritySettings",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    session_affinity = proto.Field(
        proto.ENUM, number=463888561, optional=True, enum=SessionAffinity,
    )
    timeout_sec = proto.Field(proto.INT32, number=79994995, optional=True,)


class BackendServicesScopedList(proto.Message):
    r"""
    Attributes:
        backend_services (Sequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendServices contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.
    """

    backend_services = proto.RepeatedField(
        proto.MESSAGE, number=388522409, message="BackendService",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceAggregatedList(proto.Message):
    r"""Contains a list of BackendServicesScopedList.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.BackendServiceAggregatedList.ItemsEntry]):
            A list of BackendServicesScopedList
            resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="BackendServicesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)


class CacheKeyPolicy(proto.Message):
    r"""Message containing what to include in the cache key for a
    request for Cloud CDN.

    Attributes:
        include_host (bool):
            If true, requests to different hosts will be
            cached separately.
        include_protocol (bool):
            If true, http and https requests will be
            cached separately.
        include_query_string (bool):
            If true, include query string parameters in the cache key
            according to query_string_whitelist and
            query_string_blacklist. If neither is set, the entire query
            string will be included. If false, the query string will be
            excluded from the cache key entirely.
        query_string_blacklist (Sequence[str]):
            Names of query string parameters to exclude in cache keys.
            All other parameters will be included. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
        query_string_whitelist (Sequence[str]):
            Names of query string parameters to include in cache keys.
            All other parameters will be excluded. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
    """

    include_host = proto.Field(proto.BOOL, number=486867679, optional=True,)
    include_protocol = proto.Field(proto.BOOL, number=303507535, optional=True,)
    include_query_string = proto.Field(proto.BOOL, number=474036639, optional=True,)
    query_string_blacklist = proto.RepeatedField(proto.STRING, number=354964742,)
    query_string_whitelist = proto.RepeatedField(proto.STRING, number=52456496,)


class BackendServiceCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.
    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.
    """

    code = proto.Field(proto.INT32, number=3059181, optional=True,)
    ttl = proto.Field(proto.INT32, number=115180, optional=True,)


class HealthStatus(proto.Message):
    r"""
    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.HealthStatus.AnnotationsEntry]):
            Metadata defined as annotations for network
            endpoint.
        forwarding_rule (str):
            URL of the forwarding rule associated with
            the health status of the instance.
        forwarding_rule_ip (str):
            A forwarding rule IP address assigned to this
            instance.
        health_state (google.cloud.compute_v1.types.HealthStatus.HealthState):
            Health state of the instance.
        instance (str):
            URL of the instance resource.
        ip_address (str):
            For target pool based Network Load Balancing,
            it indicates the forwarding rule's IP address
            assigned to this instance. For other types of
            load balancing, the field indicates VM internal
            ip.
        port (int):
            The named port of the instance group, not
            necessarily the port that is health-checked.
        weight (str):

        weight_error (google.cloud.compute_v1.types.HealthStatus.WeightError):

    """

    class HealthState(proto.Enum):
        r"""Health state of the instance."""
        UNDEFINED_HEALTH_STATE = 0
        HEALTHY = 439801213
        UNHEALTHY = 462118084

    class WeightError(proto.Enum):
        r""""""
        UNDEFINED_WEIGHT_ERROR = 0
        INVALID_WEIGHT = 383698400
        MISSING_WEIGHT = 384027537
        UNAVAILABLE_WEIGHT = 439464295
        WEIGHT_NONE = 502428831

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    forwarding_rule = proto.Field(proto.STRING, number=269964030, optional=True,)
    forwarding_rule_ip = proto.Field(proto.STRING, number=172250632, optional=True,)
    health_state = proto.Field(
        proto.ENUM, number=324007150, optional=True, enum=HealthState,
    )
    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    weight = proto.Field(proto.STRING, number=282149496, optional=True,)
    weight_error = proto.Field(
        proto.ENUM, number=522501505, optional=True, enum=WeightError,
    )


class BackendServiceGroupHealth(proto.Message):
    r"""
    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.BackendServiceGroupHealth.AnnotationsEntry]):
            Metadata defined as annotations on the
            network endpoint group.
        health_status (Sequence[google.cloud.compute_v1.types.HealthStatus]):
            Health state of the backend instances or
            endpoints in requested instance or network
            endpoint group, determined based on configured
            health checks.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceGroupHealth for the health of backend
            services.
    """

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    health_status = proto.RepeatedField(
        proto.MESSAGE, number=380545845, message="HealthStatus",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class BackendServiceList(proto.Message):
    r"""Contains a list of BackendService resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendService resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceList for lists of backend services.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="BackendService",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class BackendServiceReference(proto.Message):
    r"""
    Attributes:
        backend_service (str):

    """

    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)


class Expr(proto.Message):
    r"""Represents a textual expression in the Common Expression Language
    (CEL) syntax. CEL is a C-like expression language. The syntax and
    semantics of CEL are documented at
    https://github.com/google/cel-spec.

    Example (Comparison):

    title: "Summary size limit" description: "Determines if a summary is
    less than 100 chars" expression: "document.summary.size() < 100"

    Example (Equality):

    title: "Requestor is owner" description: "Determines if requestor is
    the document owner" expression: "document.owner ==
    request.auth.claims.email"

    Example (Logic):

    title: "Public documents" description: "Determine whether the
    document should be publicly visible" expression: "document.type !=
    'private' && document.type != 'internal'"

    Example (Data Manipulation):

    title: "Notification string" description: "Create a notification
    string with a timestamp." expression: "'New message received at ' +
    string(document.create_time)"

    The exact variables and functions that may be referenced within an
    expression are determined by the service that evaluates it. See the
    service documentation for additional information.

    Attributes:
        description (str):
            Optional. Description of the expression. This
            is a longer text which describes the expression,
            e.g. when hovered over it in a UI.
        expression (str):
            Textual representation of an expression in
            Common Expression Language syntax.
        location (str):
            Optional. String indicating the location of
            the expression for error reporting, e.g. a file
            name and a position in the file.
        title (str):
            Optional. Title for the expression, i.e. a
            short string describing its purpose. This can be
            used e.g. in UIs which allow to enter the
            expression.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    expression = proto.Field(proto.STRING, number=352031384, optional=True,)
    location = proto.Field(proto.STRING, number=290430901, optional=True,)
    title = proto.Field(proto.STRING, number=110371416, optional=True,)


class Binding(proto.Message):
    r"""Associates ``members`` with a ``role``.
    Attributes:
        binding_id (str):

        condition (google.cloud.compute_v1.types.Expr):
            The condition that is associated with this binding.

            If the condition evaluates to ``true``, then this binding
            applies to the current request.

            If the condition evaluates to ``false``, then this binding
            does not apply to the current request. However, a different
            role binding might grant the same role to one or more of the
            members in this binding.

            To learn which resources support conditions in their IAM
            policies, see the `IAM
            documentation <https://cloud.google.com/iam/help/conditions/resource-policies>`__.
        members (Sequence[str]):
            Specifies the identities requesting access for a Cloud
            Platform resource. ``members`` can have the following
            values:

            -  ``allUsers``: A special identifier that represents anyone
               who is on the internet; with or without a Google account.

            -  ``allAuthenticatedUsers``: A special identifier that
               represents anyone who is authenticated with a Google
               account or a service account.

            -  ``user:{emailid}``: An email address that represents a
               specific Google account. For example,
               ``alice@example.com`` .

            -  ``serviceAccount:{emailid}``: An email address that
               represents a service account. For example,
               ``my-other-app@appspot.gserviceaccount.com``.

            -  ``group:{emailid}``: An email address that represents a
               Google group. For example, ``admins@example.com``.

            -  ``deleted:user:{emailid}?uid={uniqueid}``: An email
               address (plus unique identifier) representing a user that
               has been recently deleted. For example,
               ``alice@example.com?uid=123456789012345678901``. If the
               user is recovered, this value reverts to
               ``user:{emailid}`` and the recovered user retains the
               role in the binding.

            -  ``deleted:serviceAccount:{emailid}?uid={uniqueid}``: An
               email address (plus unique identifier) representing a
               service account that has been recently deleted. For
               example,
               ``my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901``.
               If the service account is undeleted, this value reverts
               to ``serviceAccount:{emailid}`` and the undeleted service
               account retains the role in the binding.

            -  ``deleted:group:{emailid}?uid={uniqueid}``: An email
               address (plus unique identifier) representing a Google
               group that has been recently deleted. For example,
               ``admins@example.com?uid=123456789012345678901``. If the
               group is recovered, this value reverts to
               ``group:{emailid}`` and the recovered group retains the
               role in the binding.

            -  ``domain:{domain}``: The G Suite domain (primary) that
               represents all the users of that domain. For example,
               ``google.com`` or ``example.com``.
        role (str):
            Role that is assigned to ``members``. For example,
            ``roles/viewer``, ``roles/editor``, or ``roles/owner``.
    """

    binding_id = proto.Field(proto.STRING, number=441088277, optional=True,)
    condition = proto.Field(
        proto.MESSAGE, number=212430107, optional=True, message="Expr",
    )
    members = proto.RepeatedField(proto.STRING, number=412010777,)
    role = proto.Field(proto.STRING, number=3506294, optional=True,)


class InstanceProperties(proto.Message):
    r"""
    Attributes:
        advanced_machine_features (google.cloud.compute_v1.types.AdvancedMachineFeatures):
            Controls for advanced machine-related
            behavior features.
        can_ip_forward (bool):
            Enables instances created based on these
            properties to send packets with source IP
            addresses other than their own and receive
            packets with destination IP addresses other than
            their own. If these instances will be used as an
            IP gateway or it will be set as the next-hop in
            a Route resource, specify true. If unsure, leave
            this set to false. See the Enable IP forwarding
            documentation for more information.
        confidential_instance_config (google.cloud.compute_v1.types.ConfidentialInstanceConfig):
            Specifies the Confidential Instance options.
        description (str):
            An optional text description for the
            instances that are created from these
            properties.
        disks (Sequence[google.cloud.compute_v1.types.AttachedDisk]):
            An array of disks that are associated with
            the instances that are created from these
            properties.
        guest_accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            A list of guest accelerator cards' type and
            count to use for instances created from these
            properties.
        labels (Sequence[google.cloud.compute_v1.types.InstanceProperties.LabelsEntry]):
            Labels to apply to instances that are created
            from these properties.
        machine_type (str):
            The machine type to use for instances that
            are created from these properties.
        metadata (google.cloud.compute_v1.types.Metadata):
            The metadata key/value pairs to assign to
            instances that are created from these
            properties. These pairs can consist of custom
            metadata or predefined keys. See Project and
            instance metadata for more information.
        min_cpu_platform (str):
            Minimum cpu/platform to be used by instances.
            The instance may be scheduled on the specified
            or newer cpu/platform. Applicable values are the
            friendly names of CPU platforms, such as
            minCpuPlatform: "Intel Haswell" or
            minCpuPlatform: "Intel Sandy Bridge". For more
            information, read Specifying a Minimum CPU
            Platform.
        network_interfaces (Sequence[google.cloud.compute_v1.types.NetworkInterface]):
            An array of network access configurations for
            this interface.
        private_ipv6_google_access (google.cloud.compute_v1.types.InstanceProperties.PrivateIpv6GoogleAccess):
            The private IPv6 google access type for VMs. If not
            specified, use INHERIT_FROM_SUBNETWORK as default.
        reservation_affinity (google.cloud.compute_v1.types.ReservationAffinity):
            Specifies the reservations that instances can
            consume from.
        resource_policies (Sequence[str]):
            Resource policies (names, not ULRs) applied
            to instances created from these properties.
        scheduling (google.cloud.compute_v1.types.Scheduling):
            Specifies the scheduling options for the
            instances that are created from these
            properties.
        service_accounts (Sequence[google.cloud.compute_v1.types.ServiceAccount]):
            A list of service accounts with specified
            scopes. Access tokens for these service accounts
            are available to the instances that are created
            from these properties. Use metadata queries to
            obtain the access tokens for these instances.
        shielded_instance_config (google.cloud.compute_v1.types.ShieldedInstanceConfig):

        tags (google.cloud.compute_v1.types.Tags):
            A list of tags to apply to the instances that
            are created from these properties. The tags
            identify valid sources or targets for network
            firewalls. The setTags method can modify this
            list of tags. Each tag within the list must
            comply with RFC1035.
    """

    class PrivateIpv6GoogleAccess(proto.Enum):
        r"""The private IPv6 google access type for VMs. If not specified, use
        INHERIT_FROM_SUBNETWORK as default.
        """
        UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0
        ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994
        ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263
        INHERIT_FROM_SUBNETWORK = 530256959

    advanced_machine_features = proto.Field(
        proto.MESSAGE,
        number=409646002,
        optional=True,
        message="AdvancedMachineFeatures",
    )
    can_ip_forward = proto.Field(proto.BOOL, number=467731324, optional=True,)
    confidential_instance_config = proto.Field(
        proto.MESSAGE,
        number=490637685,
        optional=True,
        message="ConfidentialInstanceConfig",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="AttachedDisk",)
    guest_accelerators = proto.RepeatedField(
        proto.MESSAGE, number=463595119, message="AcceleratorConfig",
    )
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    machine_type = proto.Field(proto.STRING, number=227711026, optional=True,)
    metadata = proto.Field(
        proto.MESSAGE, number=86866735, optional=True, message="Metadata",
    )
    min_cpu_platform = proto.Field(proto.STRING, number=242912759, optional=True,)
    network_interfaces = proto.RepeatedField(
        proto.MESSAGE, number=52735243, message="NetworkInterface",
    )
    private_ipv6_google_access = proto.Field(
        proto.ENUM, number=48277006, optional=True, enum=PrivateIpv6GoogleAccess,
    )
    reservation_affinity = proto.Field(
        proto.MESSAGE, number=157850683, optional=True, message="ReservationAffinity",
    )
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    scheduling = proto.Field(
        proto.MESSAGE, number=386688404, optional=True, message="Scheduling",
    )
    service_accounts = proto.RepeatedField(
        proto.MESSAGE, number=277537328, message="ServiceAccount",
    )
    shielded_instance_config = proto.Field(
        proto.MESSAGE, number=12862901, optional=True, message="ShieldedInstanceConfig",
    )
    tags = proto.Field(proto.MESSAGE, number=3552281, optional=True, message="Tags",)


class LocationPolicy(proto.Message):
    r"""Configuration for location policy among multiple possible
    locations (e.g. preferences for zone selection among zones in a
    single region).

    Attributes:
        locations (Sequence[google.cloud.compute_v1.types.LocationPolicy.LocationsEntry]):
            Location configurations mapped by location
            name. Currently only zone names are supported
            and must be represented as valid internal URLs,
            such as zones/us-central1-a.
    """

    locations = proto.MapField(
        proto.STRING, proto.MESSAGE, number=413423454, message="LocationPolicyLocation",
    )


class BulkInsertInstanceResourcePerInstanceProperties(proto.Message):
    r"""Per-instance properties to be set on individual instances. To
    be extended in the future.

    Attributes:
        name (str):
            This field is only temporary. It will be
            removed. Do not use it.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class BulkInsertInstanceResource(proto.Message):
    r"""
    Attributes:
        count (int):
            The maximum number of instances to create.
        instance_properties (google.cloud.compute_v1.types.InstanceProperties):
            The instance properties defining the VM
            instances to be created. Required if
            sourceInstanceTemplate is not provided.
        location_policy (google.cloud.compute_v1.types.LocationPolicy):
            Policy for chosing target zone.
        min_count (int):
            The minimum number of instances to create. If no min_count
            is specified then count is used as the default value. If
            min_count instances cannot be created, then no instances
            will be created and instances already created will be
            deleted.
        name_pattern (str):
            The string pattern used for the names of the VMs. Either
            name_pattern or per_instance_properties must be set. The
            pattern should contain one continuous sequence of
            placeholder hash characters (#) with each character
            corresponding to one digit of the generated instance name.
            Example: name_pattern of inst-#### will generate instance
            names such as inst-0001, inst-0002, ... . If there already
            exist instance(s) whose names match the name pattern in the
            same project and zone, then the generated instance numbers
            will start after the biggest existing number. For example,
            if there exists an instance with name inst-0050, then
            instance names generated using the pattern inst-#### will be
            inst-0051, inst-0052, etc. The name pattern placeholder
            #...# can contain up to 18 characters.
        per_instance_properties (Sequence[google.cloud.compute_v1.types.BulkInsertInstanceResource.PerInstancePropertiesEntry]):
            Per-instance properties to be set on individual instances.
            Keys of this map specify requested instance names. Can be
            empty if name_pattern is used.
        source_instance_template (str):
            Specifies the instance template from which to
            create instances. You may combine
            sourceInstanceTemplate with instanceProperties
            to override specific values from an existing
            instance template. Bulk API follows the
            semantics of JSON Merge Patch described by RFC
            7396.  It can be a full or partial URL. For
            example, the following are all valid URLs to an
            instance template: -
            https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/instanceTemplate
            -
            projects/project/global/instanceTemplates/instanceTemplate
            - global/instanceTemplates/instanceTemplate

            This field is optional.
    """

    count = proto.Field(proto.INT64, number=94851343, optional=True,)
    instance_properties = proto.Field(
        proto.MESSAGE, number=215355165, optional=True, message="InstanceProperties",
    )
    location_policy = proto.Field(
        proto.MESSAGE, number=465689852, optional=True, message="LocationPolicy",
    )
    min_count = proto.Field(proto.INT64, number=523228386, optional=True,)
    name_pattern = proto.Field(proto.STRING, number=413815260, optional=True,)
    per_instance_properties = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=108502267,
        message="BulkInsertInstanceResourcePerInstanceProperties",
    )
    source_instance_template = proto.Field(
        proto.STRING, number=332423616, optional=True,
    )


class CacheInvalidationRule(proto.Message):
    r"""
    Attributes:
        host (str):
            If set, this invalidation rule will only
            apply to requests with a Host header matching
            host.
        path (str):

    """

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    path = proto.Field(proto.STRING, number=3433509, optional=True,)


class LicenseResourceCommitment(proto.Message):
    r"""Commitment for a particular license resource.
    Attributes:
        amount (int):
            The number of licenses purchased.
        cores_per_license (str):
            Specifies the core range of the instance for
            which this license applies.
        license_ (str):
            Any applicable license URI.
    """

    amount = proto.Field(proto.INT64, number=196759640, optional=True,)
    cores_per_license = proto.Field(proto.STRING, number=32482324, optional=True,)
    license_ = proto.Field(proto.STRING, number=166757441, optional=True,)


class Reservation(proto.Message):
    r"""Represents a reservation resource. A reservation ensures that
    capacity is held in a specific zone even if the reserved VMs are not
    running. For more information, read Reserving zonal resources. (==
    resource_for {$api_version}.reservations ==)

    Attributes:
        commitment (str):
            [Output Only] Full or partial URL to a parent commitment.
            This field displays for reservations that are tied to a
            commitment.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#reservations for reservations.
        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The resource name must be
            1-63 characters long, and comply with RFC1035. Specifically,
            the name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        self_link (str):
            [Output Only] Server-defined fully-qualified URL for this
            resource.
        specific_reservation (google.cloud.compute_v1.types.AllocationSpecificSKUReservation):
            Reservation for instances with specific
            machine shapes.
        specific_reservation_required (bool):
            Indicates whether the reservation can be
            consumed by VMs with affinity for "any"
            reservation. If the field is set, then only VMs
            that target the reservation by name can consume
            from this reservation.
        status (google.cloud.compute_v1.types.Reservation.Status):
            [Output Only] The status of the reservation.
        zone (str):
            Zone in which the reservation resides. A zone
            must be provided if the reservation is created
            within a commitment.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the reservation."""
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        INVALID = 530283991
        READY = 77848963
        UPDATING = 494614342

    commitment = proto.Field(proto.STRING, number=482134805, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    specific_reservation = proto.Field(
        proto.MESSAGE,
        number=404901951,
        optional=True,
        message="AllocationSpecificSKUReservation",
    )
    specific_reservation_required = proto.Field(
        proto.BOOL, number=226550687, optional=True,
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class ResourceCommitment(proto.Message):
    r"""Commitment for a particular resource (a Commitment is
    composed of one or more of these).

    Attributes:
        accelerator_type (str):
            Name of the accelerator type resource.
            Applicable only when the type is ACCELERATOR.
        amount (int):
            The amount of the resource purchased (in a
            type-dependent unit, such as bytes). For vCPUs,
            this can just be an integer. For memory, this
            must be provided in MB. Memory must be a
            multiple of 256 MB, with up to 6.5GB of memory
            per every vCPU.
        type_ (google.cloud.compute_v1.types.ResourceCommitment.Type):
            Type of resource for which this commitment
            applies. Possible values are VCPU and MEMORY
    """

    class Type(proto.Enum):
        r"""Type of resource for which this commitment applies. Possible
        values are VCPU and MEMORY
        """
        UNDEFINED_TYPE = 0
        ACCELERATOR = 429815371
        LOCAL_SSD = 508934896
        MEMORY = 123056385
        UNSPECIFIED = 526786327
        VCPU = 2628978

    accelerator_type = proto.Field(proto.STRING, number=138031246, optional=True,)
    amount = proto.Field(proto.INT64, number=196759640, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class Commitment(proto.Message):
    r"""Represents a regional Commitment resource.

    Creating a commitment resource means that you are purchasing a
    committed use contract with an explicit start and end time. You can
    create commitments based on vCPUs and memory usage and receive
    discounted rates. For full details, read Signing Up for Committed
    Use Discounts. (== resource_for {$api_version}.regionCommitments ==)

    Attributes:
        category (google.cloud.compute_v1.types.Commitment.Category):
            The category of the commitment. Category
            MACHINE specifies commitments composed of
            machine resources such as VCPU or MEMORY, listed
            in resources. Category LICENSE specifies
            commitments composed of software licenses,
            listed in licenseResources. Note that only
            MACHINE commitments should have a Type
            specified.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        end_timestamp (str):
            [Output Only] Commitment end time in RFC3339 text format.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#commitment for commitments.
        license_resource (google.cloud.compute_v1.types.LicenseResourceCommitment):
            The license specification required as part of
            a license commitment.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        plan (google.cloud.compute_v1.types.Commitment.Plan):
            The plan for this commitment, which determines duration and
            discount rate. The currently supported plans are
            TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
        region (str):
            [Output Only] URL of the region where this commitment may be
            used.
        reservations (Sequence[google.cloud.compute_v1.types.Reservation]):
            List of reservations in this commitment.
        resources (Sequence[google.cloud.compute_v1.types.ResourceCommitment]):
            A list of commitment amounts for particular
            resources. Note that VCPU and MEMORY resource
            commitments must occur together.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        start_timestamp (str):
            [Output Only] Commitment start time in RFC3339 text format.
        status (google.cloud.compute_v1.types.Commitment.Status):
            [Output Only] Status of the commitment with regards to
            eventual expiration (each commitment has an end date
            defined). One of the following values: NOT_YET_ACTIVE,
            ACTIVE, EXPIRED.
        status_message (str):
            [Output Only] An optional, human-readable explanation of the
            status.
    """

    class Category(proto.Enum):
        r"""The category of the commitment. Category MACHINE specifies
        commitments composed of machine resources such as VCPU or
        MEMORY, listed in resources. Category LICENSE specifies
        commitments composed of software licenses, listed in
        licenseResources. Note that only MACHINE commitments should have
        a Type specified.
        """
        UNDEFINED_CATEGORY = 0
        CATEGORY_UNSPECIFIED = 509189462
        LICENSE = 347869217
        MACHINE = 469553191

    class Plan(proto.Enum):
        r"""The plan for this commitment, which determines duration and discount
        rate. The currently supported plans are TWELVE_MONTH (1 year), and
        THIRTY_SIX_MONTH (3 years).
        """
        UNDEFINED_PLAN = 0
        INVALID = 530283991
        THIRTY_SIX_MONTH = 266295942
        TWELVE_MONTH = 173083962

    class Status(proto.Enum):
        r"""[Output Only] Status of the commitment with regards to eventual
        expiration (each commitment has an end date defined). One of the
        following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        CREATING = 455564985
        EXPIRED = 482489093
        NOT_YET_ACTIVE = 20607337

    category = proto.Field(proto.ENUM, number=50511102, optional=True, enum=Category,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    end_timestamp = proto.Field(proto.STRING, number=468096690, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    license_resource = proto.Field(
        proto.MESSAGE,
        number=437955148,
        optional=True,
        message="LicenseResourceCommitment",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    plan = proto.Field(proto.ENUM, number=3443497, optional=True, enum=Plan,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    reservations = proto.RepeatedField(
        proto.MESSAGE, number=399717927, message="Reservation",
    )
    resources = proto.RepeatedField(
        proto.MESSAGE, number=164412965, message="ResourceCommitment",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    start_timestamp = proto.Field(proto.STRING, number=83645817, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_message = proto.Field(proto.STRING, number=297428154, optional=True,)


class CommitmentsScopedList(proto.Message):
    r"""
    Attributes:
        commitments (Sequence[google.cloud.compute_v1.types.Commitment]):
            [Output Only] A list of commitments contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of commitments when the list is empty.
    """

    commitments = proto.RepeatedField(
        proto.MESSAGE, number=450664446, message="Commitment",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class CommitmentAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.CommitmentAggregatedList.ItemsEntry]):
            A list of CommitmentsScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentAggregatedList for aggregated lists of
            commitments.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="CommitmentsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class CommitmentList(proto.Message):
    r"""Contains a list of Commitment resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Commitment]):
            A list of Commitment resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentList for lists of commitments.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Commitment",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Condition(proto.Message):
    r"""A condition to be met.
    Attributes:
        iam (str):
            Trusted attributes supplied by the IAM
            system.
        op (str):
            An operator to apply the subject with.
        svc (str):
            Trusted attributes discharged by the service.
        sys (str):
            Trusted attributes supplied by any service
            that owns resources and uses the IAM system for
            access control.
        values (Sequence[str]):
            The objects of the condition.
    """

    iam = proto.Field(proto.STRING, number=104021, optional=True,)
    op = proto.Field(proto.STRING, number=3553, optional=True,)
    svc = proto.Field(proto.STRING, number=114272, optional=True,)
    sys = proto.Field(proto.STRING, number=114381, optional=True,)
    values = proto.RepeatedField(proto.STRING, number=249928994,)


class ConfidentialInstanceConfig(proto.Message):
    r"""A set of Confidential Instance options.
    Attributes:
        enable_confidential_compute (bool):
            Defines whether the instance should have
            confidential compute enabled.
    """

    enable_confidential_compute = proto.Field(
        proto.BOOL, number=102135228, optional=True,
    )


class ConsistentHashLoadBalancerSettingsHttpCookie(proto.Message):
    r"""The information about the HTTP Cookie on which the hash
    function is based for load balancing policies that use a
    consistent hash.

    Attributes:
        name (str):
            Name of the cookie.
        path (str):
            Path to set for the cookie.
        ttl (google.cloud.compute_v1.types.Duration):
            Lifetime of the cookie.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    path = proto.Field(proto.STRING, number=3433509, optional=True,)
    ttl = proto.Field(proto.MESSAGE, number=115180, optional=True, message="Duration",)


class CorsPolicy(proto.Message):
    r"""The specification for allowing client side cross-origin
    requests. Please see W3C Recommendation for Cross Origin
    Resource Sharing

    Attributes:
        allow_credentials (bool):
            In response to a preflight request, setting
            this to true indicates that the actual request
            can include user credentials. This translates to
            the Access-Control-Allow-Credentials header.
            Default is false.
        allow_headers (Sequence[str]):
            Specifies the content for the Access-Control-
            llow-Headers header.
        allow_methods (Sequence[str]):
            Specifies the content for the Access-Control-
            llow-Methods header.
        allow_origin_regexes (Sequence[str]):
            Specifies the regualar expression patterns
            that match allowed origins. For regular
            expression grammar please see
            github.com/google/re2/wiki/Syntax An origin is
            allowed if it matches either an item in
            allowOrigins or an item in allowOriginRegexes.
        allow_origins (Sequence[str]):
            Specifies the list of origins that will be
            allowed to do CORS requests. An origin is
            allowed if it matches either an item in
            allowOrigins or an item in allowOriginRegexes.
        disabled (bool):
            If true, specifies the CORS policy is
            disabled. The default value of false, which
            indicates that the CORS policy is in effect.
        expose_headers (Sequence[str]):
            Specifies the content for the Access-Control-
            xpose-Headers header.
        max_age (int):
            Specifies how long results of a preflight
            request can be cached in seconds. This
            translates to the Access-Control-Max-Age header.
    """

    allow_credentials = proto.Field(proto.BOOL, number=481263366, optional=True,)
    allow_headers = proto.RepeatedField(proto.STRING, number=45179024,)
    allow_methods = proto.RepeatedField(proto.STRING, number=205405372,)
    allow_origin_regexes = proto.RepeatedField(proto.STRING, number=215385810,)
    allow_origins = proto.RepeatedField(proto.STRING, number=194914071,)
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    expose_headers = proto.RepeatedField(proto.STRING, number=247604747,)
    max_age = proto.Field(proto.INT32, number=307559332, optional=True,)


class CustomerEncryptionKeyProtectedDisk(proto.Message):
    r"""
    Attributes:
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Decrypts data associated with the disk with a
            customer-supplied encryption key.
        source (str):
            Specifies a valid partial or full URL to an
            existing Persistent Disk resource. This field is
            only applicable for persistent disks.
    """

    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    source = proto.Field(proto.STRING, number=177235995, optional=True,)


class Disk(proto.Message):
    r"""Represents a Persistent Disk resource.

    Google Compute Engine has two Disk resources:

    -  `Zonal </compute/docs/reference/rest/{$api_version}/disks>`__ \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionDisks>`__

    Persistent disks are required for running your VM instances. Create
    both boot and non-boot (data) persistent disks. For more
    information, read Persistent Disks. For more storage options, read
    Storage options.

    The disks resource represents a zonal persistent disk. For more
    information, read Zonal persistent disks.

    The regionDisks resource represents a regional persistent disk. For
    more information, read Regional resources. (== resource_for
    {$api_version}.disks ==) (== resource_for {$api_version}.regionDisks
    ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts the disk using a customer-supplied
            encryption key.
            After you encrypt a disk with a customer-
            supplied key, you must provide the same key if
            you use the disk later (e.g. to create a disk
            snapshot, to create a disk image, to create a
            machine image, or to attach the disk to a
            virtual machine).
            Customer-supplied encryption keys do not protect
            access to metadata of the disk.
            If you do not provide an encryption key when
            creating the disk, then the disk will be
            encrypted using an automatically generated key
            and you do not need to provide a key to use the
            disk later.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read  Enabling guest operating system
            features to see a list of available options.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#disk for
            disks.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this disk, which is essentially a hash of the
            labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve a disk.
        labels (Sequence[google.cloud.compute_v1.types.Disk.LabelsEntry]):
            Labels to apply to this disk. These can be
            later modified by the setLabels method.
        last_attach_timestamp (str):
            [Output Only] Last attach timestamp in RFC3339 text format.
        last_detach_timestamp (str):
            [Output Only] Last detach timestamp in RFC3339 text format.
        license_codes (Sequence[int]):
            Integer license codes indicating which
            licenses are attached to this disk.
        licenses (Sequence[str]):
            A list of publicly visible licenses. Reserved
            for Google's use.
        location_hint (str):
            An opaque location hint used to place the
            disk close to other resources. This field is for
            use by internal tools that use the public API.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        options (str):
            Internal use only.
        physical_block_size_bytes (int):
            Physical block size of the persistent disk,
            in bytes. If not present in a request, a default
            value is used. The currently supported size is
            4096, other sizes may be added in the future. If
            an unsupported value is requested, the error
            message will list the supported values for the
            caller's project.
        provisioned_iops (int):
            Indicates how many IOPS must be provisioned
            for the disk.
        region (str):
            [Output Only] URL of the region where the disk resides. Only
            applicable for regional resources. You must specify this
            field as part of the HTTP request URL. It is not settable as
            a field in the request body.
        replica_zones (Sequence[str]):
            URLs of the zones where the disk should be
            replicated to. Only applicable for regional
            resources.
        resource_policies (Sequence[str]):
            Resource policies applied to this disk for
            automatic snapshot creations.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        self_link (str):
            [Output Only] Server-defined fully-qualified URL for this
            resource.
        size_gb (int):
            Size, in GB, of the persistent disk. You can
            specify this field when creating a persistent
            disk using the sourceImage, sourceSnapshot, or
            sourceDisk parameter, or specify it alone to
            create an empty persistent disk.  If you specify
            this field along with a source, the value of
            sizeGb must not be less than the size of the
            source. Acceptable values are 1 to 65536,
            inclusive.
        source_disk (str):
            The source disk used to create this disk. You
            can provide this as a partial or full URL to the
            resource. For example, the following are valid
            values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
            -
            https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
            - projects/project/zones/zone/disks/disk
            - projects/project/regions/region/disks/disk
            - zones/zone/disks/disk
            - regions/region/disks/disk
        source_disk_id (str):
            [Output Only] The unique ID of the disk used to create this
            disk. This value identifies the exact disk that was used to
            create this persistent disk. For example, if you created the
            persistent disk from a disk that was later deleted and
            recreated under the same name, the source disk ID would
            identify the exact version of the disk that was used.
        source_image (str):
            The source image used to create this disk. If
            the source image is deleted, this field will not
            be set.  To create a disk with one of the public
            operating system images, specify the image by
            its family name. For example, specify
            family/debian-9 to use the latest Debian 9
            image: projects/debian-
            cloud/global/images/family/debian-9

            Alternatively, use a specific version of a
            public operating system image: projects/debian-
            cloud/global/images/debian-9-stretch-vYYYYMMDD

            To create a disk with a custom image that you
            created, specify the image name in the following
            format: global/images/my-custom-image

            You can also specify a custom image by its image
            family, which returns the latest version of the
            image in that family. Replace the image name
            with family/family-name:
            global/images/family/my-image-family
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.
        source_image_id (str):
            [Output Only] The ID value of the image used to create this
            disk. This value identifies the exact image that was used to
            create this persistent disk. For example, if you created the
            persistent disk from an image that was later deleted and
            recreated under the same name, the source image ID would
            identify the exact version of the image that was used.
        source_snapshot (str):
            The source snapshot used to create this disk.
            You can provide this as a partial or full URL to
            the resource. For example, the following are
            valid values: -
            https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
            - projects/project/global/snapshots/snapshot
            - global/snapshots/snapshot
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot. Required if the source snapshot
            is protected by a customer-supplied encryption
            key.
        source_snapshot_id (str):
            [Output Only] The unique ID of the snapshot used to create
            this disk. This value identifies the exact snapshot that was
            used to create this persistent disk. For example, if you
            created the persistent disk from a snapshot that was later
            deleted and recreated under the same name, the source
            snapshot ID would identify the exact version of the snapshot
            that was used.
        source_storage_object (str):
            The full Google Cloud Storage URI where the
            disk image is stored. This file must be a gzip-
            compressed tarball whose name ends in .tar.gz or
            virtual machine disk whose name ends in vmdk.
            Valid URIs may start with gs:// or
            https://storage.googleapis.com/. This flag is
            not optimized for creating multiple disks from a
            source storage object. To create many disks from
            a source storage object, use gcloud compute
            images import instead.
        status (google.cloud.compute_v1.types.Disk.Status):
            [Output Only] The status of disk creation.

            -  CREATING: Disk is provisioning.
            -  RESTORING: Source data is being copied into the disk.
            -  FAILED: Disk creation failed.
            -  READY: Disk is ready for use.
            -  DELETING: Disk is deleting.
        type_ (str):
            URL of the disk type resource describing
            which disk type to use to create the disk.
            Provide this when creating the disk. For
            example:
            projects/project/zones/zone/diskTypes/pd-
            standard  or pd-ssd
        users (Sequence[str]):
            [Output Only] Links to the users of the disk (attached
            instances) in form:
            projects/project/zones/zone/instances/instance
        zone (str):
            [Output Only] URL of the zone where the disk resides. You
            must specify this field as part of the HTTP request URL. It
            is not settable as a field in the request body.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of disk creation.

        -  CREATING: Disk is provisioning.
        -  RESTORING: Source data is being copied into the disk.
        -  FAILED: Disk creation failed.
        -  READY: Disk is ready for use.
        -  DELETING: Disk is deleting.
        """
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        FAILED = 455706685
        READY = 77848963
        RESTORING = 404263851

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_encryption_key = proto.Field(
        proto.MESSAGE, number=271660677, optional=True, message="CustomerEncryptionKey",
    )
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    last_attach_timestamp = proto.Field(proto.STRING, number=42159653, optional=True,)
    last_detach_timestamp = proto.Field(proto.STRING, number=56471027, optional=True,)
    license_codes = proto.RepeatedField(proto.INT64, number=45482664,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    options = proto.Field(proto.STRING, number=361137822, optional=True,)
    physical_block_size_bytes = proto.Field(
        proto.INT64, number=420007943, optional=True,
    )
    provisioned_iops = proto.Field(proto.INT64, number=186769108, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    replica_zones = proto.RepeatedField(proto.STRING, number=48438272,)
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    size_gb = proto.Field(proto.INT64, number=494929369, optional=True,)
    source_disk = proto.Field(proto.STRING, number=451753793, optional=True,)
    source_disk_id = proto.Field(proto.STRING, number=454190809, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_image_id = proto.Field(proto.STRING, number=55328291, optional=True,)
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot_id = proto.Field(proto.STRING, number=98962258, optional=True,)
    source_storage_object = proto.Field(proto.STRING, number=233052711, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    type_ = proto.Field(proto.STRING, number=3575610, optional=True,)
    users = proto.RepeatedField(proto.STRING, number=111578632,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class DisksScopedList(proto.Message):
    r"""
    Attributes:
        disks (Sequence[google.cloud.compute_v1.types.Disk]):
            [Output Only] A list of disks contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of disks when the list is empty.
    """

    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="Disk",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.DiskAggregatedList.ItemsEntry]):
            A list of DisksScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#diskAggregatedList for aggregated lists of
            persistent disks.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="DisksScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskInstantiationConfig(proto.Message):
    r"""A specification of the desired way to instantiate a disk in
    the instance template when its created from a source instance.

    Attributes:
        auto_delete (bool):
            Specifies whether the disk will be auto-
            eleted when the instance is deleted (but not
            when the disk is detached from the instance).
        custom_image (str):
            The custom source image to be used to restore
            this disk when instantiating this instance
            template.
        device_name (str):
            Specifies the device name of the disk to
            which the configurations apply to.
        instantiate_from (google.cloud.compute_v1.types.DiskInstantiationConfig.InstantiateFrom):
            Specifies whether to include the disk and
            what image to use. Possible values are: -
            source-image: to use the same image that was
            used to create the source instance's
            corresponding disk. Applicable to the boot disk
            and additional read-write disks. - source-image-
            family: to use the same image family that was
            used to create the source instance's
            corresponding disk. Applicable to the boot disk
            and additional read-write disks. - custom-image:
            to use a user-provided image url for disk
            creation. Applicable to the boot disk and
            additional read-write disks. - attach-read-only:
            to attach a read-only disk. Applicable to read-
            only disks. - do-not-include: to exclude a disk
            from the template. Applicable to additional
            read-write disks, local SSDs, and read-only
            disks.
    """

    class InstantiateFrom(proto.Enum):
        r"""Specifies whether to include the disk and what image to use.
        Possible values are: - source-image: to use the same image that
        was used to create the source instance's corresponding disk.
        Applicable to the boot disk and additional read-write disks. -
        source-image-family: to use the same image family that was used
        to create the source instance's corresponding disk. Applicable
        to the boot disk and additional read-write disks. - custom-
        image: to use a user-provided image url for disk creation.
        Applicable to the boot disk and additional read-write disks. -
        attach-read-only: to attach a read-only disk. Applicable to
        read-only disks. - do-not-include: to exclude a disk from the
        template. Applicable to additional read-write disks, local SSDs,
        and read-only disks.
        """
        UNDEFINED_INSTANTIATE_FROM = 0
        ATTACH_READ_ONLY = 513775419
        BLANK = 63281460
        CUSTOM_IMAGE = 196311789
        DEFAULT = 115302945
        DO_NOT_INCLUDE = 104218952
        SOURCE_IMAGE = 62631959
        SOURCE_IMAGE_FAMILY = 76850316

    auto_delete = proto.Field(proto.BOOL, number=464761403, optional=True,)
    custom_image = proto.Field(proto.STRING, number=184123149, optional=True,)
    device_name = proto.Field(proto.STRING, number=67541716, optional=True,)
    instantiate_from = proto.Field(
        proto.ENUM, number=393383903, optional=True, enum=InstantiateFrom,
    )


class DiskList(proto.Message):
    r"""A list of Disk resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Disk]):
            A list of Disk resources.
        kind (str):
            [Output Only] Type of resource. Always compute#diskList for
            lists of disks.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Disk",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskMoveRequest(proto.Message):
    r"""
    Attributes:
        destination_zone (str):
            The URL of the destination zone to move the
            disk. This can be a full or partial URL. For
            example, the following are all valid URLs to a
            zone: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            - projects/project/zones/zone
            - zones/zone
        target_disk (str):
            The URL of the target disk to move. This can
            be a full or partial URL. For example, the
            following are all valid URLs to a disk: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
            - projects/project/zones/zone/disks/disk
            - zones/zone/disks/disk
    """

    destination_zone = proto.Field(proto.STRING, number=131854653, optional=True,)
    target_disk = proto.Field(proto.STRING, number=62433163, optional=True,)


class DiskType(proto.Message):
    r"""Represents a Disk Type resource.

    Google Compute Engine has two Disk Type resources:

    -  `Regional </compute/docs/reference/rest/{$api_version}/regionDiskTypes>`__
       \*
       `Zonal </compute/docs/reference/rest/{$api_version}/diskTypes>`__

    You can choose from a variety of disk types based on your needs. For
    more information, read Storage options.

    The diskTypes resource represents disk types for a zonal persistent
    disk. For more information, read Zonal persistent disks.

    The regionDiskTypes resource represents disk types for a regional
    persistent disk. For more information, read Regional persistent
    disks. (== resource_for {$api_version}.diskTypes ==) (==
    resource_for {$api_version}.regionDiskTypes ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        default_disk_size_gb (int):
            [Output Only] Server-defined default disk size in GB.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            disk type.
        description (str):
            [Output Only] An optional description of this resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#diskType
            for disk types.
        name (str):
            [Output Only] Name of the resource.
        region (str):
            [Output Only] URL of the region where the disk type resides.
            Only applicable for regional resources. You must specify
            this field as part of the HTTP request URL. It is not
            settable as a field in the request body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        valid_disk_size (str):
            [Output Only] An optional textual description of the valid
            disk size, such as "10GB-10TB".
        zone (str):
            [Output Only] URL of the zone where the disk type resides.
            You must specify this field as part of the HTTP request URL.
            It is not settable as a field in the request body.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    default_disk_size_gb = proto.Field(proto.INT64, number=270619253, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    valid_disk_size = proto.Field(proto.STRING, number=493962464, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class DiskTypesScopedList(proto.Message):
    r"""
    Attributes:
        disk_types (Sequence[google.cloud.compute_v1.types.DiskType]):
            [Output Only] A list of disk types contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of disk types when the list is empty.
    """

    disk_types = proto.RepeatedField(
        proto.MESSAGE, number=198926167, message="DiskType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskTypeAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.DiskTypeAggregatedList.ItemsEntry]):
            A list of DiskTypesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#diskTypeAggregatedList.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="DiskTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DiskTypeList(proto.Message):
    r"""Contains a list of disk types.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.DiskType]):
            A list of DiskType resources.
        kind (str):
            [Output Only] Type of resource. Always compute#diskTypeList
            for disk types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="DiskType",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class DisksAddResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be added to this disk.
            Currently you can only specify one policy here.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class DisksRemoveResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be removed from this
            disk.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class DisksResizeRequest(proto.Message):
    r"""
    Attributes:
        size_gb (int):
            The new size of the persistent disk, which is
            specified in GB.
    """

    size_gb = proto.Field(proto.INT64, number=494929369, optional=True,)


class DisplayDevice(proto.Message):
    r"""A set of Display Device options
    Attributes:
        enable_display (bool):
            Defines whether the instance has Display
            enabled.
    """

    enable_display = proto.Field(proto.BOOL, number=14266886, optional=True,)


class DistributionPolicyZoneConfiguration(proto.Message):
    r"""
    Attributes:
        zone (str):
            The URL of the zone. The zone must exist in
            the region where the managed instance group is
            located.
    """

    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class DistributionPolicy(proto.Message):
    r"""
    Attributes:
        target_shape (google.cloud.compute_v1.types.DistributionPolicy.TargetShape):
            The distribution shape to which the group
            converges either proactively or on resize events
            (depending on the value set in
            updatePolicy.instanceRedistributionType).
        zones (Sequence[google.cloud.compute_v1.types.DistributionPolicyZoneConfiguration]):
            Zones where the regional managed instance
            group will create and manage its instances.
    """

    class TargetShape(proto.Enum):
        r"""The distribution shape to which the group converges either
        proactively or on resize events (depending on the value set in
        updatePolicy.instanceRedistributionType).
        """
        UNDEFINED_TARGET_SHAPE = 0
        ANY = 64972
        BALANCED = 468409608
        EVEN = 2140442

    target_shape = proto.Field(
        proto.ENUM, number=338621299, optional=True, enum=TargetShape,
    )
    zones = proto.RepeatedField(
        proto.MESSAGE, number=116085319, message="DistributionPolicyZoneConfiguration",
    )


class ExchangedPeeringRoute(proto.Message):
    r"""
    Attributes:
        dest_range (str):
            The destination range of the route.
        imported (bool):
            True if the peering route has been imported
            from a peer. The actual import happens if the
            field networkPeering.importCustomRoutes is true
            for this network, and
            networkPeering.exportCustomRoutes is true for
            the peer network, and the import does not result
            in a route conflict.
        next_hop_region (str):
            The region of peering route next hop, only
            applies to dynamic routes.
        priority (int):
            The priority of the peering route.
        type_ (google.cloud.compute_v1.types.ExchangedPeeringRoute.Type):
            The type of the peering route.
    """

    class Type(proto.Enum):
        r"""The type of the peering route."""
        UNDEFINED_TYPE = 0
        DYNAMIC_PEERING_ROUTE = 469794858
        STATIC_PEERING_ROUTE = 473407545
        SUBNET_PEERING_ROUTE = 465782504

    dest_range = proto.Field(proto.STRING, number=381327712, optional=True,)
    imported = proto.Field(proto.BOOL, number=114502404, optional=True,)
    next_hop_region = proto.Field(proto.STRING, number=122577014, optional=True,)
    priority = proto.Field(proto.UINT32, number=445151652, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class ExchangedPeeringRoutesList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ExchangedPeeringRoute]):
            A list of ExchangedPeeringRoute resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#exchangedPeeringRoutesList for exchanged peering
            routes lists.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ExchangedPeeringRoute",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ExternalVpnGatewayInterface(proto.Message):
    r"""The interface for the external VPN gateway.
    Attributes:
        id (int):
            The numeric ID of this interface. The allowed input values
            for this id for different redundancy types of external VPN
            gateway: SINGLE_IP_INTERNALLY_REDUNDANT - 0
            TWO_IPS_REDUNDANCY - 0, 1 FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
        ip_address (str):
            IP address of the interface in the external
            VPN gateway. Only IPv4 is supported. This IP
            address can be either from your on-premise
            gateway or another Cloud provider's VPN gateway,
            it cannot be an IP address from Google Compute
            Engine.
    """

    id = proto.Field(proto.UINT32, number=3355, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)


class ExternalVpnGateway(proto.Message):
    r"""Represents an external VPN gateway.

    External VPN gateway is the on-premises VPN gateway(s) or another
    cloud provider's VPN gateway that connects to your Google Cloud VPN
    gateway.

    To create a highly available VPN from Google Cloud Platform to your
    VPN gateway or another cloud provider's VPN gateway, you must create
    a external VPN gateway resource with information about the other
    gateway.

    For more information about using external VPN gateways, see Creating
    an HA VPN gateway and tunnel pair to a peer VPN. (== resource_for
    {$api_version}.externalVpnGateways ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        interfaces (Sequence[google.cloud.compute_v1.types.ExternalVpnGatewayInterface]):
            List of interfaces for this external VPN
            gateway.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#externalVpnGateway for externalVpnGateways.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this ExternalVpnGateway, which is essentially a
            hash of the labels set used for optimistic
            locking. The fingerprint is initially generated
            by Compute Engine and changes after every
            request to modify or update labels. You must
            always provide an up-to-date fingerprint hash in
            order to update or change labels, otherwise the
            request will fail with error 412
            conditionNotMet.  To see the latest fingerprint,
            make a get() request to retrieve an
            ExternalVpnGateway.
        labels (Sequence[google.cloud.compute_v1.types.ExternalVpnGateway.LabelsEntry]):
            Labels for this resource. These can only be
            added or modified by the setLabels method. Each
            label key/value pair must comply with RFC1035.
            Label values may be empty.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        redundancy_type (google.cloud.compute_v1.types.ExternalVpnGateway.RedundancyType):
            Indicates the user-supplied redundancy type
            of this external VPN gateway.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    class RedundancyType(proto.Enum):
        r"""Indicates the user-supplied redundancy type of this external
        VPN gateway.
        """
        UNDEFINED_REDUNDANCY_TYPE = 0
        FOUR_IPS_REDUNDANCY = 520087913
        SINGLE_IP_INTERNALLY_REDUNDANT = 133914873
        TWO_IPS_REDUNDANCY = 367049635

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    interfaces = proto.RepeatedField(
        proto.MESSAGE, number=12073562, message="ExternalVpnGatewayInterface",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    redundancy_type = proto.Field(
        proto.ENUM, number=271443740, optional=True, enum=RedundancyType,
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class ExternalVpnGatewayList(proto.Message):
    r"""Response to the list request, and contains a list of
    externalVpnGateways.

    Attributes:
        etag (str):

        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ExternalVpnGateway]):
            A list of ExternalVpnGateway resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#externalVpnGatewayList for lists of
            externalVpnGateways.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ExternalVpnGateway",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FileContentBuffer(proto.Message):
    r"""
    Attributes:
        content (str):
            The raw content in the secure keys file.
        file_type (google.cloud.compute_v1.types.FileContentBuffer.FileType):
            The file type of source file.
    """

    class FileType(proto.Enum):
        r"""The file type of source file."""
        UNDEFINED_FILE_TYPE = 0
        BIN = 65767
        UNDEFINED = 137851184
        X509 = 2674086

    content = proto.Field(proto.STRING, number=414659705, optional=True,)
    file_type = proto.Field(proto.ENUM, number=294346781, optional=True, enum=FileType,)


class Allowed(proto.Message):
    r"""
    Attributes:
        I_p_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp) or the IP
            protocol number.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for the UDP or TCP protocol. Each
            entry must be either an integer or a range. If not
            specified, this rule applies to connections through any
            port.

            Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    I_p_protocol = proto.Field(proto.STRING, number=488094525, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class Denied(proto.Message):
    r"""
    Attributes:
        I_p_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp) or the IP
            protocol number.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for the UDP or TCP protocol. Each
            entry must be either an integer or a range. If not
            specified, this rule applies to connections through any
            port.

            Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    I_p_protocol = proto.Field(proto.STRING, number=488094525, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class FirewallLogConfig(proto.Message):
    r"""The available logging options for a firewall rule.
    Attributes:
        enable (bool):
            This field denotes whether to enable logging
            for a particular firewall rule.
        metadata (google.cloud.compute_v1.types.FirewallLogConfig.Metadata):
            This field can only be specified for a
            particular firewall rule if logging is enabled
            for that rule. This field denotes whether to
            include or exclude metadata for firewall logs.
    """

    class Metadata(proto.Enum):
        r"""This field can only be specified for a particular firewall
        rule if logging is enabled for that rule. This field denotes
        whether to include or exclude metadata for firewall logs.
        """
        UNDEFINED_METADATA = 0
        EXCLUDE_ALL_METADATA = 334519954
        INCLUDE_ALL_METADATA = 164619908

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    metadata = proto.Field(proto.ENUM, number=86866735, optional=True, enum=Metadata,)


class Firewall(proto.Message):
    r"""Represents a Firewall Rule resource.
    Firewall rules allow or deny ingress traffic to, and egress
    traffic from your instances. For more information, read Firewall
    rules.

    Attributes:
        allowed (Sequence[google.cloud.compute_v1.types.Allowed]):
            The list of ALLOW rules specified by this
            firewall. Each rule specifies a protocol and
            port-range tuple that describes a permitted
            connection.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        denied (Sequence[google.cloud.compute_v1.types.Denied]):
            The list of DENY rules specified by this
            firewall. Each rule specifies a protocol and
            port-range tuple that describes a denied
            connection.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.
        destination_ranges (Sequence[str]):
            If destination ranges are specified, the
            firewall rule applies only to traffic that has
            destination IP address in these ranges. These
            ranges must be expressed in CIDR format. Only
            IPv4 is supported.
        direction (google.cloud.compute_v1.types.Firewall.Direction):
            Direction of traffic to which this firewall applies, either
            ``INGRESS`` or ``EGRESS``. The default is ``INGRESS``. For
            ``INGRESS`` traffic, you cannot specify the
            destinationRanges field, and for ``EGRESS`` traffic, you
            cannot specify the sourceRanges or sourceTags fields.
        disabled (bool):
            Denotes whether the firewall rule is
            disabled. When set to true, the firewall rule is
            not enforced and the network behaves as if it
            did not exist. If this is unspecified, the
            firewall rule will be enabled.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#firewall
            for firewall rules.
        log_config (google.cloud.compute_v1.types.FirewallLogConfig):
            This field denotes the logging options for a
            particular firewall rule. If logging is enabled,
            logs will be exported to Cloud Logging.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            \`\ `a-z <[-a-z0-9]*[a-z0-9]>`__?. The first character must
            be a lowercase letter, and all following characters (except
            for the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.
        network (str):
            URL of the network resource for this firewall
            rule. If not specified when creating a firewall
            rule, the default network is used:
            global/networks/default If you choose to specify
            this field, you can specify the network as a
            full or partial URL. For example, the following
            are all valid URLs: -
            https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-
            network - projects/myproject/global/networks/my-
            network - global/networks/default
        priority (int):
            Priority for this rule. This is an integer between ``0`` and
            ``65535``, both inclusive. The default value is ``1000``.
            Relative priorities determine which rule takes effect if
            multiple rules apply. Lower values indicate higher priority.
            For example, a rule with priority ``0`` has higher
            precedence than a rule with priority ``1``. DENY rules take
            precedence over ALLOW rules if they have equal priority.
            Note that VPC networks have implied rules with a priority of
            ``65535``. To avoid conflicts with the implied rules, use a
            priority number less than ``65535``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        source_ranges (Sequence[str]):
            If source ranges are specified, the firewall
            rule applies only to traffic that has a source
            IP address in these ranges. These ranges must be
            expressed in CIDR format. One or both of
            sourceRanges and sourceTags may be set. If both
            fields are set, the rule applies to traffic that
            has a source IP address within sourceRanges OR a
            source IP from a resource with a matching tag
            listed in the sourceTags field. The connection
            does not need to match both fields for the rule
            to apply. Only IPv4 is supported.
        source_service_accounts (Sequence[str]):
            If source service accounts are specified, the
            firewall rules apply only to traffic originating
            from an instance with a service account in this
            list. Source service accounts cannot be used to
            control traffic to an instance's external IP
            address because service accounts are associated
            with an instance, not an IP address.
            sourceRanges can be set at the same time as
            sourceServiceAccounts. If both are set, the
            firewall applies to traffic that has a source IP
            address within the sourceRanges OR a source IP
            that belongs to an instance with service account
            listed in sourceServiceAccount. The connection
            does not need to match both fields for the
            firewall to apply. sourceServiceAccounts cannot
            be used at the same time as sourceTags or
            targetTags.
        source_tags (Sequence[str]):
            If source tags are specified, the firewall
            rule applies only to traffic with source IPs
            that match the primary network interfaces of VM
            instances that have the tag and are in the same
            VPC network. Source tags cannot be used to
            control traffic to an instance's external IP
            address, it only applies to traffic between
            instances in the same virtual network. Because
            tags are associated with instances, not IP
            addresses. One or both of sourceRanges and
            sourceTags may be set. If both fields are set,
            the firewall applies to traffic that has a
            source IP address within sourceRanges OR a
            source IP from a resource with a matching tag
            listed in the sourceTags field. The connection
            does not need to match both fields for the
            firewall to apply.
        target_service_accounts (Sequence[str]):
            A list of service accounts indicating sets of instances
            located in the network that may make network connections as
            specified in allowed[]. targetServiceAccounts cannot be used
            at the same time as targetTags or sourceTags. If neither
            targetServiceAccounts nor targetTags are specified, the
            firewall rule applies to all instances on the specified
            network.
        target_tags (Sequence[str]):
            A list of tags that controls which instances
            the firewall rule applies to. If targetTags are
            specified, then the firewall rule applies only
            to instances in the VPC network that have one of
            those tags. If no targetTags are specified, the
            firewall rule applies to all instances on the
            specified network.
    """

    class Direction(proto.Enum):
        r"""Direction of traffic to which this firewall applies, either
        ``INGRESS`` or ``EGRESS``. The default is ``INGRESS``. For
        ``INGRESS`` traffic, you cannot specify the destinationRanges field,
        and for ``EGRESS`` traffic, you cannot specify the sourceRanges or
        sourceTags fields.
        """
        UNDEFINED_DIRECTION = 0
        EGRESS = 432880501
        INGRESS = 516931221

    allowed = proto.RepeatedField(proto.MESSAGE, number=162398632, message="Allowed",)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    denied = proto.RepeatedField(proto.MESSAGE, number=275217307, message="Denied",)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    destination_ranges = proto.RepeatedField(proto.STRING, number=305699879,)
    direction = proto.Field(
        proto.ENUM, number=111150975, optional=True, enum=Direction,
    )
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="FirewallLogConfig",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    source_ranges = proto.RepeatedField(proto.STRING, number=200097658,)
    source_service_accounts = proto.RepeatedField(proto.STRING, number=105100756,)
    source_tags = proto.RepeatedField(proto.STRING, number=452222397,)
    target_service_accounts = proto.RepeatedField(proto.STRING, number=457639710,)
    target_tags = proto.RepeatedField(proto.STRING, number=62901767,)


class FirewallList(proto.Message):
    r"""Contains a list of firewalls.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Firewall]):
            A list of Firewall resources.
        kind (str):
            [Output Only] Type of resource. Always compute#firewallList
            for lists of firewalls.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Firewall",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FirewallPolicyAssociation(proto.Message):
    r"""
    Attributes:
        attachment_target (str):
            The target that the firewall policy is
            attached to.
        display_name (str):
            [Output Only] Deprecated, please use short name instead. The
            display name of the firewall policy of the association.
        firewall_policy_id (str):
            [Output Only] The firewall policy ID of the association.
        name (str):
            The name for an association.
        short_name (str):
            [Output Only] The short name of the firewall policy of the
            association.
    """

    attachment_target = proto.Field(proto.STRING, number=175773741, optional=True,)
    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    firewall_policy_id = proto.Field(proto.STRING, number=357211849, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)


class FirewallPoliciesListAssociationsResponse(proto.Message):
    r"""
    Attributes:
        associations (Sequence[google.cloud.compute_v1.types.FirewallPolicyAssociation]):
            A list of associations.
        kind (str):
            [Output Only] Type of firewallPolicy associations. Always
            compute#FirewallPoliciesListAssociations for lists of
            firewallPolicy associations.
    """

    associations = proto.RepeatedField(
        proto.MESSAGE, number=508736530, message="FirewallPolicyAssociation",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class FirewallPolicyRule(proto.Message):
    r"""Represents a rule that describes one or more match conditions
    along with the action to be taken when traffic matches this
    condition (allow or deny).

    Attributes:
        action (str):
            The Action to perform when the client
            connection triggers the rule. Can currently be
            either "allow" or "deny()" where valid values
            for status are 403, 404, and 502.
        description (str):
            An optional description for this resource.
        direction (google.cloud.compute_v1.types.FirewallPolicyRule.Direction):
            The direction in which this rule applies.
        disabled (bool):
            Denotes whether the firewall policy rule is
            disabled. When set to true, the firewall policy
            rule is not enforced and traffic behaves as if
            it did not exist. If this is unspecified, the
            firewall policy rule will be enabled.
        enable_logging (bool):
            Denotes whether to enable logging for a particular rule. If
            logging is enabled, logs will be exported to the configured
            export destination in Stackdriver. Logs may be exported to
            BigQuery or Pub/Sub. Note: you cannot enable logging on
            "goto_next" rules.
        kind (str):
            [Output only] Type of the resource. Always
            compute#firewallPolicyRule for firewall policy rules
        match (google.cloud.compute_v1.types.FirewallPolicyRuleMatcher):
            A match condition that incoming traffic is
            evaluated against. If it evaluates to true, the
            corresponding 'action' is enforced.
        priority (int):
            An integer indicating the priority of a rule
            in the list. The priority must be a positive
            value between 0 and 2147483647. Rules are
            evaluated from highest to lowest priority where
            0 is the highest priority and 2147483647 is the
            lowest prority.
        rule_tuple_count (int):
            [Output Only] Calculation of the complexity of a single
            firewall policy rule.
        target_resources (Sequence[str]):
            A list of network resource URLs to which this
            rule applies. This field allows you to control
            which network's VMs get this rule. If this field
            is left blank, all VMs within the organization
            will receive the rule.
        target_service_accounts (Sequence[str]):
            A list of service accounts indicating the
            sets of instances that are applied with this
            rule.
    """

    class Direction(proto.Enum):
        r"""The direction in which this rule applies."""
        UNDEFINED_DIRECTION = 0
        EGRESS = 432880501
        INGRESS = 516931221

    action = proto.Field(proto.STRING, number=187661878, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    direction = proto.Field(
        proto.ENUM, number=111150975, optional=True, enum=Direction,
    )
    disabled = proto.Field(proto.BOOL, number=270940796, optional=True,)
    enable_logging = proto.Field(proto.BOOL, number=295396515, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    match = proto.Field(
        proto.MESSAGE,
        number=103668165,
        optional=True,
        message="FirewallPolicyRuleMatcher",
    )
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    rule_tuple_count = proto.Field(proto.INT32, number=388342037, optional=True,)
    target_resources = proto.RepeatedField(proto.STRING, number=528230647,)
    target_service_accounts = proto.RepeatedField(proto.STRING, number=457639710,)


class FirewallPolicy(proto.Message):
    r"""Represents a Firewall Policy resource. (== resource_for
    {$api_version}.firewallPolicies ==)

    Attributes:
        associations (Sequence[google.cloud.compute_v1.types.FirewallPolicyAssociation]):
            A list of associations that belong to this
            firewall policy.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        display_name (str):
            Depreacted, please use short name instead. User-provided
            name of the Organization firewall plicy. The name should be
            unique in the organization in which the firewall policy is
            created. The name must be 1-63 characters long, and comply
            with RFC1035. Specifically, the name must be 1-63 characters
            long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        fingerprint (str):
            Specifies a fingerprint for this resource,
            which is essentially a hash of the metadata's
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update metadata. You must always provide an
            up-to-date fingerprint hash in order to update
            or change metadata, otherwise the request will
            fail with error 412 conditionNotMet.  To see the
            latest fingerprint, make get() request to the
            firewall policy.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output only] Type of the resource. Always
            compute#firewallPolicyfor firewall policies
        name (str):
            [Output Only] Name of the resource. It is a numeric ID
            allocated by GCP which uniquely identifies the Firewall
            Policy.
        parent (str):
            [Output Only] The parent of the firewall policy.
        rule_tuple_count (int):
            [Output Only] Total count of all firewall policy rule
            tuples. A firewall policy can not exceed a set number of
            tuples.
        rules (Sequence[google.cloud.compute_v1.types.FirewallPolicyRule]):
            A list of rules that belong to this policy. There must
            always be a default rule (rule with priority 2147483647 and
            match "*"). If no rules are provided when creating a
            firewall policy, a default rule with action "allow" will be
            added.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        self_link_with_id (str):
            [Output Only] Server-defined URL for this resource with the
            resource id.
        short_name (str):
            User-provided name of the Organization firewall plicy. The
            name should be unique in the organization in which the
            firewall policy is created. The name must be 1-63 characters
            long, and comply with RFC1035. Specifically, the name must
            be 1-63 characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
    """

    associations = proto.RepeatedField(
        proto.MESSAGE, number=508736530, message="FirewallPolicyAssociation",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    parent = proto.Field(proto.STRING, number=78317738, optional=True,)
    rule_tuple_count = proto.Field(proto.INT32, number=388342037, optional=True,)
    rules = proto.RepeatedField(
        proto.MESSAGE, number=108873975, message="FirewallPolicyRule",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    self_link_with_id = proto.Field(proto.STRING, number=44520962, optional=True,)
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)


class FirewallPolicyList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.FirewallPolicy]):
            A list of FirewallPolicy resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#firewallPolicyList for listsof FirewallPolicies
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="FirewallPolicy",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class FirewallPolicyRuleMatcher(proto.Message):
    r"""Represents a match condition that incoming traffic is
    evaluated against. Exactly one field must be specified.

    Attributes:
        dest_ip_ranges (Sequence[str]):
            CIDR IP address range. Maximum number of
            destination CIDR IP ranges allowed is 256.
        layer4_configs (Sequence[google.cloud.compute_v1.types.FirewallPolicyRuleMatcherLayer4Config]):
            Pairs of IP protocols and ports that the rule
            should match.
        src_ip_ranges (Sequence[str]):
            CIDR IP address range. Maximum number of
            source CIDR IP ranges allowed is 256.
    """

    dest_ip_ranges = proto.RepeatedField(proto.STRING, number=337357713,)
    layer4_configs = proto.RepeatedField(
        proto.MESSAGE,
        number=373534261,
        message="FirewallPolicyRuleMatcherLayer4Config",
    )
    src_ip_ranges = proto.RepeatedField(proto.STRING, number=432128083,)


class FirewallPolicyRuleMatcherLayer4Config(proto.Message):
    r"""
    Attributes:
        ip_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp), or the IP
            protocol number.
        ports (Sequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for UDP or TCP protocol. Each entry
            must be either an integer or a range. If not specified, this
            rule applies to connections through any port.

            Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    ip_protocol = proto.Field(proto.STRING, number=475958960, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)


class MetadataFilter(proto.Message):
    r"""Opaque filter criteria used by loadbalancers to restrict routing
    configuration to a limited set of loadbalancing proxies. Proxies and
    sidecars involved in loadbalancing would typically present metadata
    to the loadbalancers which need to match criteria specified here. If
    a match takes place, the relevant configuration is made available to
    those proxies. For each metadataFilter in this list, if its
    filterMatchCriteria is set to MATCH_ANY, at least one of the
    filterLabels must match the corresponding label provided in the
    metadata. If its filterMatchCriteria is set to MATCH_ALL, then all
    of its filterLabels must match with corresponding labels provided in
    the metadata. An example for using metadataFilters would be: if
    loadbalancing involves Envoys, they will only receive routing
    configuration when values in metadataFilters match values supplied
    in <a
    href="https://www.envoyproxy.io/docs/envoy/latest/api-v2/api/v2/core/base.proto#envoy-api-msg-core-node"
    Node metadata of their XDS requests to loadbalancers.

    Attributes:
        filter_labels (Sequence[google.cloud.compute_v1.types.MetadataFilterLabelMatch]):
            The list of label value pairs that must match
            labels in the provided metadata based on
            filterMatchCriteria This list must not be empty
            and can have at the most 64 entries.
        filter_match_criteria (google.cloud.compute_v1.types.MetadataFilter.FilterMatchCriteria):
            Specifies how individual filterLabel matches within the list
            of filterLabels contribute towards the overall
            metadataFilter match. Supported values are:

            -  MATCH_ANY: At least one of the filterLabels must have a
               matching label in the provided metadata.
            -  MATCH_ALL: All filterLabels must have matching labels in
               the provided metadata.
    """

    class FilterMatchCriteria(proto.Enum):
        r"""Specifies how individual filterLabel matches within the list of
        filterLabels contribute towards the overall metadataFilter match.
        Supported values are:

        -  MATCH_ANY: At least one of the filterLabels must have a matching
           label in the provided metadata.
        -  MATCH_ALL: All filterLabels must have matching labels in the
           provided metadata.
        """
        UNDEFINED_FILTER_MATCH_CRITERIA = 0
        MATCH_ALL = 180663271
        MATCH_ANY = 180663346
        NOT_SET = 163646646

    filter_labels = proto.RepeatedField(
        proto.MESSAGE, number=307903142, message="MetadataFilterLabelMatch",
    )
    filter_match_criteria = proto.Field(
        proto.ENUM, number=239970368, optional=True, enum=FilterMatchCriteria,
    )


class ForwardingRuleServiceDirectoryRegistration(proto.Message):
    r"""Describes the auto-registration of the Forwarding Rule to
    Service Directory. The region and project of the Service
    Directory resource generated from this registration will be the
    same as this Forwarding Rule.

    Attributes:
        namespace (str):
            Service Directory namespace to register the
            forwarding rule under.
        service (str):
            Service Directory service to register the
            forwarding rule under.
        service_directory_region (str):
            [Optional] Service Directory region to register this global
            forwarding rule under. Default to "us-central1". Only used
            for PSC for Google APIs. All PSC for Google APIs Forwarding
            Rules on the same network should use the same Service
            Directory region.
    """

    namespace = proto.Field(proto.STRING, number=178476379, optional=True,)
    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    service_directory_region = proto.Field(
        proto.STRING, number=74030416, optional=True,
    )


class ForwardingRule(proto.Message):
    r"""Represents a Forwarding Rule resource.

    Forwarding rule resources in GCP can be either regional or global in
    scope:

    -  `Global </compute/docs/reference/rest/{$api_version}/globalForwardingRules>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/forwardingRules>`__

    A forwarding rule and its corresponding IP address represent the
    frontend configuration of a Google Cloud Platform load balancer.
    Forwarding rules can also reference target instances and Cloud VPN
    Classic gateways (targetVpnGateway).

    For more information, read Forwarding rule concepts and Using
    protocol forwarding.

    (== resource_for {$api_version}.forwardingRules ==) (== resource_for
    {$api_version}.globalForwardingRules ==) (== resource_for
    {$api_version}.regionForwardingRules ==)

    Attributes:
        I_p_address (str):
            IP address that this forwarding rule serves. When a client
            sends traffic to this IP address, the forwarding rule
            directs the traffic to the target that you specify in the
            forwarding rule.

            If you don't specify a reserved IP address, an ephemeral IP
            address is assigned. Methods for specifying an IP address:

            -  IPv4 dotted decimal, as in ``100.1.2.3`` \* Full URL, as
               in
               https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name
               \* Partial URL or by name, as in:

            -  projects/project_id/regions/region/addresses/address-name
            -  regions/region/addresses/address-name
            -  global/addresses/address-name
            -  address-name

            The loadBalancingScheme and the forwarding rule's target
            determine the type of IP address that you can use. For
            detailed information, refer to `IP address
            specifications </load-balancing/docs/forwarding-rule-concepts#ip_address_specifications>`__.

            Must be set to ``0.0.0.0`` when the target is
            targetGrpcProxy that has validateForProxyless field set to
            true.

            For Private Service Connect forwarding rules that forward
            traffic to Google APIs, IP address must be provided.
        I_p_protocol (google.cloud.compute_v1.types.ForwardingRule.IPProtocol):
            The IP protocol to which this rule applies.

            For protocol forwarding, valid options are TCP, UDP, ESP,
            AH, SCTP and ICMP.

            The valid IP protocols are different for different load
            balancing products:

            -  Internal TCP/UDP Load Balancing: The load balancing
               scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
            -  Traffic Director: The load balancing scheme is
               INTERNAL_SELF_MANAGED, and only TCP is valid.
            -  Internal HTTP(S) Load Balancing: The load balancing
               scheme is INTERNAL_MANAGED, and only TCP is valid.
            -  HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The
               load balancing scheme is EXTERNAL and only TCP is valid.
            -  Network Load Balancing: The load balancing scheme is
               EXTERNAL, and one of TCP or UDP is valid.
        all_ports (bool):
            This field is used along with the backend_service field for
            internal load balancing or with the target field for
            internal TargetInstance. This field cannot be used with port
            or portRange fields.

            When the load balancing scheme is INTERNAL and protocol is
            TCP/UDP, specify this field to allow packets addressed to
            any ports will be forwarded to the backends configured with
            this forwarding rule.
        allow_global_access (bool):
            This field is used along with the backend_service field for
            internal load balancing or with the target field for
            internal TargetInstance. If the field is set to TRUE,
            clients can access ILB from all regions. Otherwise only
            allows access from clients in the same region as the
            internal load balancer.
        backend_service (str):
            Identifies the backend service to which the
            forwarding rule sends traffic. Required for
            Internal TCP/UDP Load Balancing and Network Load
            Balancing; must be omitted for all other load
            balancer types.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a ForwardingRule. Include
            the fingerprint in patch request to ensure that
            you do not overwrite changes that were applied
            from another concurrent request.  To see the
            latest fingerprint, make a get() request to
            retrieve a ForwardingRule.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        ip_version (google.cloud.compute_v1.types.ForwardingRule.IpVersion):
            The IP Version that will be used by this
            forwarding rule. Valid options are IPV4 or IPV6.
            This can only be specified for an external
            global forwarding rule.
        is_mirroring_collector (bool):
            Indicates whether or not this load balancer
            can be used as a collector for packet mirroring.
            To prevent mirroring loops, instances behind
            this load balancer will not have their traffic
            mirrored even if a PacketMirroring rule applies
            to them. This can only be set to true for load
            balancers that have their loadBalancingScheme
            set to INTERNAL.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#forwardingRule for Forwarding Rule resources.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this resource, which is essentially a hash of
            the labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve a ForwardingRule.
        labels (Sequence[google.cloud.compute_v1.types.ForwardingRule.LabelsEntry]):
            Labels for this resource. These can only be
            added or modified by the setLabels method. Each
            label key/value pair must comply with RFC1035.
            Label values may be empty.
        load_balancing_scheme (google.cloud.compute_v1.types.ForwardingRule.LoadBalancingScheme):
            Specifies the forwarding rule type.

            -  EXTERNAL is used for:
            -  Classic Cloud VPN gateways
            -  Protocol forwarding to VMs from an external IP address
            -  HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
            -  INTERNAL is used for:
            -  Protocol forwarding to VMs from an internal IP address
            -  Internal TCP/UDP Load Balancing
            -  INTERNAL_MANAGED is used for:
            -  Internal HTTP(S) Load Balancing
            -  INTERNAL_SELF_MANAGED is used for:
            -  Traffic Director

            For more information about forwarding rules, refer to
            Forwarding rule concepts.
        metadata_filters (Sequence[google.cloud.compute_v1.types.MetadataFilter]):
            Opaque filter criteria used by Loadbalancer to restrict
            routing configuration to a limited set of xDS compliant
            clients. In their xDS requests to Loadbalancer, xDS clients
            present node metadata. When there is a match, the relevant
            configuration is made available to those proxies. Otherwise,
            all the resources (e.g. TargetHttpProxy, UrlMap) referenced
            by the ForwardingRule will not be visible to those proxies.
            For each metadataFilter in this list, if its
            filterMatchCriteria is set to MATCH_ANY, at least one of the
            filterLabels must match the corresponding label provided in
            the metadata. If its filterMatchCriteria is set to
            MATCH_ALL, then all of its filterLabels must match with
            corresponding labels provided in the metadata. If multiple
            metadataFilters are specified, all of them need to be
            satisfied in order to be considered a match. metadataFilters
            specified here will be applifed before those specified in
            the UrlMap that this ForwardingRule references.
            metadataFilters only applies to Loadbalancers that have
            their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        network (str):
            This field is not used for external load
            balancing.
            For Internal TCP/UDP Load Balancing, this field
            identifies the network that the load balanced IP
            should belong to for this Forwarding Rule. If
            this field is not specified, the default network
            will be used.
            For Private Service Connect forwarding rules
            that forward traffic to Google APIs, a network
            must be provided.
        network_tier (google.cloud.compute_v1.types.ForwardingRule.NetworkTier):
            This signifies the networking tier used for
            configuring this load balancer and can only take
            the following values: PREMIUM, STANDARD.  For
            regional ForwardingRule, the valid values are
            PREMIUM and STANDARD. For GlobalForwardingRule,
            the valid value is PREMIUM.
            If this field is not specified, it is assumed to
            be PREMIUM. If IPAddress is specified, this
            value must be equal to the networkTier of the
            Address.
        port_range (str):
            This field can be used only if: \* Load balancing scheme is
            one of EXTERNAL, INTERNAL_SELF_MANAGED or INTERNAL_MANAGED,
            and \* IPProtocol is one of TCP, UDP, or SCTP.

            Packets addressed to ports in the specified range will be
            forwarded to target or backend_service. You can only use one
            of ports, port_range, or allPorts. The three are mutually
            exclusive. Forwarding rules with the same [IPAddress,
            IPProtocol] pair must have disjoint port ranges.

            Some types of forwarding target have constraints on the
            acceptable ports:

            -  TargetHttpProxy: 80, 8080
            -  TargetHttpsProxy: 443
            -  TargetGrpcProxy: no constraints
            -  TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587,
               700, 993, 995, 1688, 1883, 5222
            -  TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587,
               700, 993, 995, 1688, 1883, 5222
            -  TargetVpnGateway: 500, 4500
        ports (Sequence[str]):
            The ports field is only supported when the forwarding rule
            references a backend_service directly. Supported load
            balancing products are Internal TCP/UDP Load Balancing and
            Network Load Balancing. Only packets addressed to the
            specified list of ports are forwarded to backends.

            You can only use one of ports and port_range, or allPorts.
            The three are mutually exclusive.

            You can specify a list of up to five ports, which can be
            non-contiguous.

            For Internal TCP/UDP Load Balancing, if you specify
            allPorts, you should not specify ports.

            For more information, see `Port
            specifications </load-balancing/docs/forwarding-rule-concepts#port_specifications>`__.
        psc_connection_id (int):
            [Output Only] The PSC connection id of the PSC Forwarding
            Rule.
        region (str):
            [Output Only] URL of the region where the regional
            forwarding rule resides. This field is not applicable to
            global forwarding rules. You must specify this field as part
            of the HTTP request URL. It is not settable as a field in
            the request body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        service_directory_registrations (Sequence[google.cloud.compute_v1.types.ForwardingRuleServiceDirectoryRegistration]):
            Service Directory resources to register this
            forwarding rule with. Currently, only supports a
            single Service Directory resource.  It is only
            supported for Internal TCP/UDP Load Balancing
            and Internal HTTP(S) Load Balancing.
        service_label (str):
            An optional prefix to the service name for this Forwarding
            Rule. If specified, the prefix is the first label of the
            fully qualified service name.

            The label must be 1-63 characters long, and comply with
            RFC1035. Specifically, the label must be 1-63 characters
            long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is only used for internal load balancing.
        service_name (str):
            [Output Only] The internal fully qualified service name for
            this Forwarding Rule.

            This field is only used for internal load balancing.
        subnetwork (str):
            This field is only used for internal load
            balancing.
            For internal load balancing, this field
            identifies the subnetwork that the load balanced
            IP should belong to for this Forwarding Rule.
            If the network specified is in auto subnet mode,
            this field is optional. However, if the network
            is in custom subnet mode, a subnetwork must be
            specified.
        target (str):

    """

    class IPProtocol(proto.Enum):
        r"""The IP protocol to which this rule applies.

        For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP
        and ICMP.

        The valid IP protocols are different for different load balancing
        products:

        -  Internal TCP/UDP Load Balancing: The load balancing scheme is
           INTERNAL, and one of TCP, UDP or ALL is valid.
        -  Traffic Director: The load balancing scheme is
           INTERNAL_SELF_MANAGED, and only TCP is valid.
        -  Internal HTTP(S) Load Balancing: The load balancing scheme is
           INTERNAL_MANAGED, and only TCP is valid.
        -  HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load
           balancing scheme is EXTERNAL and only TCP is valid.
        -  Network Load Balancing: The load balancing scheme is EXTERNAL,
           and one of TCP or UDP is valid.
        """
        UNDEFINED_I_P_PROTOCOL = 0
        AH = 2087
        ESP = 68962
        ICMP = 2241597
        SCTP = 2539724
        TCP = 82881
        UDP = 83873

    class IpVersion(proto.Enum):
        r"""The IP Version that will be used by this forwarding rule.
        Valid options are IPV4 or IPV6. This can only be specified for
        an external global forwarding rule.
        """
        UNDEFINED_IP_VERSION = 0
        IPV4 = 2254341
        IPV6 = 2254343
        UNSPECIFIED_VERSION = 21850000

    class LoadBalancingScheme(proto.Enum):
        r"""Specifies the forwarding rule type.

        -  EXTERNAL is used for:
        -  Classic Cloud VPN gateways
        -  Protocol forwarding to VMs from an external IP address
        -  HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
        -  INTERNAL is used for:
        -  Protocol forwarding to VMs from an internal IP address
        -  Internal TCP/UDP Load Balancing
        -  INTERNAL_MANAGED is used for:
        -  Internal HTTP(S) Load Balancing
        -  INTERNAL_SELF_MANAGED is used for:
        -  Traffic Director

        For more information about forwarding rules, refer to Forwarding
        rule concepts.
        """
        UNDEFINED_LOAD_BALANCING_SCHEME = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        INTERNAL_MANAGED = 37350397
        INTERNAL_SELF_MANAGED = 236211150
        INVALID = 530283991

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        load balancer and can only take the following values: PREMIUM,
        STANDARD.  For regional ForwardingRule, the valid values are
        PREMIUM and STANDARD. For GlobalForwardingRule, the valid value
        is PREMIUM.
        If this field is not specified, it is assumed to be PREMIUM. If
        IPAddress is specified, this value must be equal to the
        networkTier of the Address.
        """
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    I_p_address = proto.Field(proto.STRING, number=42976943, optional=True,)
    I_p_protocol = proto.Field(
        proto.ENUM, number=488094525, optional=True, enum=IPProtocol,
    )
    all_ports = proto.Field(proto.BOOL, number=445175796, optional=True,)
    allow_global_access = proto.Field(proto.BOOL, number=499409674, optional=True,)
    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_version = proto.Field(
        proto.ENUM, number=294959552, optional=True, enum=IpVersion,
    )
    is_mirroring_collector = proto.Field(proto.BOOL, number=119255164, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    load_balancing_scheme = proto.Field(
        proto.ENUM, number=363890244, optional=True, enum=LoadBalancingScheme,
    )
    metadata_filters = proto.RepeatedField(
        proto.MESSAGE, number=464725739, message="MetadataFilter",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )
    port_range = proto.Field(proto.STRING, number=217518079, optional=True,)
    ports = proto.RepeatedField(proto.STRING, number=106854418,)
    psc_connection_id = proto.Field(proto.UINT64, number=292082397, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    service_directory_registrations = proto.RepeatedField(
        proto.MESSAGE,
        number=223549694,
        message="ForwardingRuleServiceDirectoryRegistration",
    )
    service_label = proto.Field(proto.STRING, number=417008874, optional=True,)
    service_name = proto.Field(proto.STRING, number=359880149, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    target = proto.Field(proto.STRING, number=192835985, optional=True,)


class ForwardingRulesScopedList(proto.Message):
    r"""
    Attributes:
        forwarding_rules (Sequence[google.cloud.compute_v1.types.ForwardingRule]):
            A list of forwarding rules contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of forwarding rules when the list is empty.
    """

    forwarding_rules = proto.RepeatedField(
        proto.MESSAGE, number=315821365, message="ForwardingRule",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ForwardingRuleAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ForwardingRuleAggregatedList.ItemsEntry]):
            A list of ForwardingRulesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#forwardingRuleAggregatedList for lists of forwarding
            rules.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="ForwardingRulesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ForwardingRuleList(proto.Message):
    r"""Contains a list of ForwardingRule resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ForwardingRule]):
            A list of ForwardingRule resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ForwardingRule",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ForwardingRuleReference(proto.Message):
    r"""
    Attributes:
        forwarding_rule (str):

    """

    forwarding_rule = proto.Field(proto.STRING, number=269964030, optional=True,)


class GRPCHealthCheck(proto.Message):
    r"""
    Attributes:
        grpc_service_name (str):
            The gRPC service name for the health check. This field is
            optional. The value of grpc_service_name has the following
            meanings by convention:

            -  Empty service_name means the overall status of all
               services at the backend.
            -  Non-empty service_name means the health of that gRPC
               service, as defined by the owner of the service. The
               grpc_service_name can only be ASCII.
        port (int):
            The port number for the health check request. Must be
            specified if port_name and port_specification are not set or
            if port_specification is USE_FIXED_PORT. Valid values are 1
            through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
            The port_name should conform to RFC1035.
        port_specification (google.cloud.compute_v1.types.GRPCHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, gRPC health check follows behavior
            specified in port and portName fields.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, gRPC health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    grpc_service_name = proto.Field(proto.STRING, number=136533078, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )


class NetworkEndpoint(proto.Message):
    r"""The network endpoint.
    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.NetworkEndpoint.AnnotationsEntry]):
            Metadata defined as annotations on the
            network endpoint.
        fqdn (str):
            Optional fully qualified domain name of network endpoint.
            This can only be specified when
            NetworkEndpointGroup.network_endpoint_type is
            NON_GCP_FQDN_PORT.
        instance (str):
            The name for a specific VM instance that the IP address
            belongs to. This is required for network endpoints of type
            GCE_VM_IP_PORT. The instance must be in the same zone of
            network endpoint group.

            The name must be 1-63 characters long, and comply with
            RFC1035.
        ip_address (str):
            Optional IPv4 address of network endpoint.
            The IP address must belong to a VM in Compute
            Engine (either the primary IP or as part of an
            aliased IP range). If the IP address is not
            specified, then the primary IP address for the
            VM instance in the network that the network
            endpoint group belongs to will be used.
        port (int):
            Optional port number of network endpoint. If
            not specified, the defaultPort for the network
            endpoint group will be used.
    """

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    fqdn = proto.Field(proto.STRING, number=3150485, optional=True,)
    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)


class GlobalNetworkEndpointGroupsAttachEndpointsRequest(proto.Message):
    r"""
    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be attached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class GlobalNetworkEndpointGroupsDetachEndpointsRequest(proto.Message):
    r"""
    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be detached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class Policy(proto.Message):
    r"""An Identity and Access Management (IAM) policy, which specifies
    access controls for Google Cloud resources.

    A ``Policy`` is a collection of ``bindings``. A ``binding`` binds
    one or more ``members`` to a single ``role``. Members can be user
    accounts, service accounts, Google groups, and domains (such as G
    Suite). A ``role`` is a named list of permissions; each ``role`` can
    be an IAM predefined role or a user-created custom role.

    For some types of Google Cloud resources, a ``binding`` can also
    specify a ``condition``, which is a logical expression that allows
    access to a resource only if the expression evaluates to ``true``. A
    condition can add constraints based on attributes of the request,
    the resource, or both. To learn which resources support conditions
    in their IAM policies, see the `IAM
    documentation <https://cloud.google.com/iam/help/conditions/resource-policies>`__.

    **JSON example:**

    { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin",
    "members": [ "user:mike@example.com", "group:admins@example.com",
    "domain:google.com",
    "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
    "role": "roles/resourcemanager.organizationViewer", "members": [
    "user:eve@example.com" ], "condition": { "title": "expirable
    access", "description": "Does not grant access after Sep 2020",
    "expression": "request.time <
    timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
    "BwWWja0YfJA=", "version": 3 }

    **YAML example:**

    bindings: - members: - user:mike@example.com -
    group:admins@example.com - domain:google.com -
    serviceAccount:my-project-id@appspot.gserviceaccount.com role:
    roles/resourcemanager.organizationAdmin - members: -
    user:eve@example.com role: roles/resourcemanager.organizationViewer
    condition: title: expirable access description: Does not grant
    access after Sep 2020 expression: request.time <
    timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
    version: 3

    For a description of IAM and its features, see the `IAM
    documentation <https://cloud.google.com/iam/docs/>`__.

    Attributes:
        audit_configs (Sequence[google.cloud.compute_v1.types.AuditConfig]):
            Specifies cloud audit logging configuration
            for this policy.
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Associates a list of ``members`` to a ``role``. Optionally,
            may specify a ``condition`` that determines how and when the
            ``bindings`` are applied. Each of the ``bindings`` must
            contain at least one member.
        etag (str):
            ``etag`` is used for optimistic concurrency control as a way
            to help prevent simultaneous updates of a policy from
            overwriting each other. It is strongly suggested that
            systems make use of the ``etag`` in the read-modify-write
            cycle to perform policy updates in order to avoid race
            conditions: An ``etag`` is returned in the response to
            ``getIamPolicy``, and systems are expected to put that etag
            in the request to ``setIamPolicy`` to ensure that their
            change will be applied to the same version of the policy.

            **Important:** If you use IAM Conditions, you must include
            the ``etag`` field whenever you call ``setIamPolicy``. If
            you omit this field, then IAM allows you to overwrite a
            version ``3`` policy with a version ``1`` policy, and all of
            the conditions in the version ``3`` policy are lost.
        iam_owned (bool):

        rules (Sequence[google.cloud.compute_v1.types.Rule]):
            If more than one rule is specified, the rules are applied in
            the following manner: - All matching LOG rules are always
            applied. - If any DENY/DENY_WITH_LOG rule matches,
            permission is denied. Logging will be applied if one or more
            matching rule requires logging. - Otherwise, if any
            ALLOW/ALLOW_WITH_LOG rule matches, permission is granted.
            Logging will be applied if one or more matching rule
            requires logging. - Otherwise, if no rule applies,
            permission is denied.
        version (int):
            Specifies the format of the policy.

            Valid values are ``0``, ``1``, and ``3``. Requests that
            specify an invalid value are rejected.

            Any operation that affects conditional role bindings must
            specify version ``3``. This requirement applies to the
            following operations:

            -  Getting a policy that includes a conditional role binding
               \* Adding a conditional role binding to a policy \*
               Changing a conditional role binding in a policy \*
               Removing any role binding, with or without a condition,
               from a policy that includes conditions

            **Important:** If you use IAM Conditions, you must include
            the ``etag`` field whenever you call ``setIamPolicy``. If
            you omit this field, then IAM allows you to overwrite a
            version ``3`` policy with a version ``1`` policy, and all of
            the conditions in the version ``3`` policy are lost.

            If a policy does not include any conditions, operations on
            that policy may specify any valid version or leave the field
            unset.

            To learn which resources support conditions in their IAM
            policies, see the `IAM
            documentation <https://cloud.google.com/iam/help/conditions/resource-policies>`__.
    """

    audit_configs = proto.RepeatedField(
        proto.MESSAGE, number=328080653, message="AuditConfig",
    )
    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    iam_owned = proto.Field(proto.BOOL, number=450566203, optional=True,)
    rules = proto.RepeatedField(proto.MESSAGE, number=108873975, message="Rule",)
    version = proto.Field(proto.INT32, number=351608024, optional=True,)


class GlobalOrganizationSetPolicyRequest(proto.Message):
    r"""
    Attributes:
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify bindings.
        etag (str):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify the etag.
        policy (google.cloud.compute_v1.types.Policy):
            REQUIRED: The complete policy to be applied
            to the 'resource'. The size of the policy is
            limited to a few 10s of KB. An empty policy is
            in general a valid policy but certain services
            (like Projects) might reject them.
    """

    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    policy = proto.Field(
        proto.MESSAGE, number=91071794, optional=True, message="Policy",
    )


class GlobalSetLabelsRequest(proto.Message):
    r"""
    Attributes:
        label_fingerprint (str):
            The fingerprint of the previous set of labels
            for this resource, used to detect conflicts. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash when updating or
            changing labels, otherwise the request will fail
            with error 412 conditionNotMet. Make a get()
            request to the resource to get the latest
            fingerprint.
        labels (Sequence[google.cloud.compute_v1.types.GlobalSetLabelsRequest.LabelsEntry]):
            A list of labels to apply for this resource. Each label key
            & value must comply with RFC1035. Specifically, the name
            must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
            For example, "webserver-frontend": "images". A label value
            can also be empty (e.g. "my-label": "").
    """

    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)


class GlobalSetPolicyRequest(proto.Message):
    r"""
    Attributes:
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify bindings.
        etag (str):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify the etag.
        policy (google.cloud.compute_v1.types.Policy):
            REQUIRED: The complete policy to be applied
            to the 'resource'. The size of the policy is
            limited to a few 10s of KB. An empty policy is
            in general a valid policy but certain services
            (like Projects) might reject them.
    """

    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    policy = proto.Field(
        proto.MESSAGE, number=91071794, optional=True, message="Policy",
    )


class GuestAttributesValue(proto.Message):
    r"""Array of guest attribute namespace/key/value tuples.
    Attributes:
        items (Sequence[google.cloud.compute_v1.types.GuestAttributesEntry]):

    """

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="GuestAttributesEntry",
    )


class GuestAttributes(proto.Message):
    r"""A guest attributes entry.
    Attributes:
        kind (str):
            [Output Only] Type of the resource. Always
            compute#guestAttributes for guest attributes entry.
        query_path (str):
            The path to be queried. This can be the
            default namespace ('/') or a nested namespace
            ('/\/') or a specified key ('/\/\')
        query_value (google.cloud.compute_v1.types.GuestAttributesValue):
            [Output Only] The value of the requested queried path.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        variable_key (str):
            The key to search for.
        variable_value (str):
            [Output Only] The value found for the requested key.
    """

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    query_path = proto.Field(proto.STRING, number=368591164, optional=True,)
    query_value = proto.Field(
        proto.MESSAGE, number=157570874, optional=True, message="GuestAttributesValue",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    variable_key = proto.Field(proto.STRING, number=164364828, optional=True,)
    variable_value = proto.Field(proto.STRING, number=124582382, optional=True,)


class GuestAttributesEntry(proto.Message):
    r"""A guest attributes namespace/key/value entry.
    Attributes:
        key (str):
            Key for the guest attribute entry.
        namespace (str):
            Namespace for the guest attribute entry.
        value (str):
            Value for the guest attribute entry.
    """

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    namespace = proto.Field(proto.STRING, number=178476379, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class HTTP2HealthCheck(proto.Message):
    r"""
    Attributes:
        host (str):
            The value of the host header in the HTTP/2
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.
        port (int):
            The TCP port number for the health check
            request. The default value is 443. Valid values
            are 1 through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
        port_specification (google.cloud.compute_v1.types.HTTP2HealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, HTTP2 health check follows behavior
            specified in port and portName fields.
        proxy_header (google.cloud.compute_v1.types.HTTP2HealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.
        request_path (str):
            The request path of the HTTP/2 health check
            request. The default value is /.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, HTTP2 health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HTTPHealthCheck(proto.Message):
    r"""
    Attributes:
        host (str):
            The value of the host header in the HTTP
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.
        port (int):
            The TCP port number for the health check
            request. The default value is 80. Valid values
            are 1 through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
        port_specification (google.cloud.compute_v1.types.HTTPHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, HTTP health check follows behavior
            specified in port and portName fields.
        proxy_header (google.cloud.compute_v1.types.HTTPHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.
        request_path (str):
            The request path of the HTTP health check
            request. The default value is /.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, HTTP health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HTTPSHealthCheck(proto.Message):
    r"""
    Attributes:
        host (str):
            The value of the host header in the HTTPS
            health check request. If left empty (default
            value), the IP on behalf of which this health
            check is performed will be used.
        port (int):
            The TCP port number for the health check
            request. The default value is 443. Valid values
            are 1 through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
        port_specification (google.cloud.compute_v1.types.HTTPSHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, HTTPS health check follows behavior
            specified in port and portName fields.
        proxy_header (google.cloud.compute_v1.types.HTTPSHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.
        request_path (str):
            The request path of the HTTPS health check
            request. The default value is /.
        response (str):
            The string to match anywhere in the first
            1024 bytes of the response body. If left empty
            (the default value), the status code determines
            health. The response data can only be ASCII.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, HTTPS health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    host = proto.Field(proto.STRING, number=3208616, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request_path = proto.Field(proto.STRING, number=229403605, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HealthCheckLogConfig(proto.Message):
    r"""Configuration of logging on a health check. If logging is
    enabled, logs will be exported to Stackdriver.

    Attributes:
        enable (bool):
            Indicates whether or not to export logs. This
            is false by default, which means no health check
            logging will be done.
    """

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)


class SSLHealthCheck(proto.Message):
    r"""
    Attributes:
        port (int):
            The TCP port number for the health check
            request. The default value is 443. Valid values
            are 1 through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
        port_specification (google.cloud.compute_v1.types.SSLHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, SSL health check follows behavior
            specified in port and portName fields.
        proxy_header (google.cloud.compute_v1.types.SSLHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.
        request (str):
            The application data to send once the SSL
            connection has been established (default value
            is empty). If both request and response are
            empty, the connection establishment alone will
            indicate health. The request data can only be
            ASCII.
        response (str):
            The bytes to match against the beginning of
            the response data. If left empty (the default
            value), any response will indicate health. The
            response data can only be ASCII.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, SSL health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request = proto.Field(proto.STRING, number=21951119, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class TCPHealthCheck(proto.Message):
    r"""
    Attributes:
        port (int):
            The TCP port number for the health check
            request. The default value is 80. Valid values
            are 1 through 65535.
        port_name (str):
            Port name as defined in InstanceGroup#NamedPort#name. If
            both port and port_name are defined, port takes precedence.
        port_specification (google.cloud.compute_v1.types.TCPHealthCheck.PortSpecification):
            Specifies how port is selected for health checking, can be
            one of following values: USE_FIXED_PORT: The port number in
            port is used for health checking. USE_NAMED_PORT: The
            portName is used for health checking. USE_SERVING_PORT: For
            NetworkEndpointGroup, the port specified for each network
            endpoint is used for health checking. For other backends,
            the port or named port specified in the Backend Service is
            used for health checking.

            If not specified, TCP health check follows behavior
            specified in port and portName fields.
        proxy_header (google.cloud.compute_v1.types.TCPHealthCheck.ProxyHeader):
            Specifies the type of proxy header to append before sending
            data to the backend, either NONE or PROXY_V1. The default is
            NONE.
        request (str):
            The application data to send once the TCP
            connection has been established (default value
            is empty). If both request and response are
            empty, the connection establishment alone will
            indicate health. The request data can only be
            ASCII.
        response (str):
            The bytes to match against the beginning of
            the response data. If left empty (the default
            value), any response will indicate health. The
            response data can only be ASCII.
    """

    class PortSpecification(proto.Enum):
        r"""Specifies how port is selected for health checking, can be one of
        following values: USE_FIXED_PORT: The port number in port is used
        for health checking. USE_NAMED_PORT: The portName is used for health
        checking. USE_SERVING_PORT: For NetworkEndpointGroup, the port
        specified for each network endpoint is used for health checking. For
        other backends, the port or named port specified in the Backend
        Service is used for health checking.

        If not specified, TCP health check follows behavior specified in
        port and portName fields.
        """
        UNDEFINED_PORT_SPECIFICATION = 0
        USE_FIXED_PORT = 190235748
        USE_NAMED_PORT = 349300671
        USE_SERVING_PORT = 362637516

    class ProxyHeader(proto.Enum):
        r"""Specifies the type of proxy header to append before sending data to
        the backend, either NONE or PROXY_V1. The default is NONE.
        """
        UNDEFINED_PROXY_HEADER = 0
        NONE = 2402104
        PROXY_V1 = 334352940

    port = proto.Field(proto.INT32, number=3446913, optional=True,)
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)
    port_specification = proto.Field(
        proto.ENUM, number=51590597, optional=True, enum=PortSpecification,
    )
    proxy_header = proto.Field(
        proto.ENUM, number=160374142, optional=True, enum=ProxyHeader,
    )
    request = proto.Field(proto.STRING, number=21951119, optional=True,)
    response = proto.Field(proto.STRING, number=196547649, optional=True,)


class HealthCheck(proto.Message):
    r"""Represents a Health Check resource.

    Google Compute Engine has two Health Check resources:

    -  `Global </compute/docs/reference/rest/{$api_version}/healthChecks>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionHealthChecks>`__

    Internal HTTP(S) load balancers must use regional health checks
    (``compute.v1.regionHealthChecks``).

    Traffic Director must use global health checks
    (``compute.v1.HealthChecks``).

    Internal TCP/UDP load balancers can use either regional or global
    health checks (``compute.v1.regionHealthChecks`` or
    ``compute.v1.HealthChecks``).

    External HTTP(S), TCP proxy, and SSL proxy load balancers as well as
    managed instance group auto-healing must use global health checks
    (``compute.v1.HealthChecks``).

    Network load balancers must use legacy HTTP health checks
    (httpHealthChecks).

    For more information, see Health checks overview.

    Attributes:
        check_interval_sec (int):
            How often (in seconds) to send a health
            check. The default value is 5 seconds.
        creation_timestamp (str):
            [Output Only] Creation timestamp in 3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        grpc_health_check (google.cloud.compute_v1.types.GRPCHealthCheck):

        healthy_threshold (int):
            A so-far unhealthy instance will be marked
            healthy after this many consecutive successes.
            The default value is 2.
        http2_health_check (google.cloud.compute_v1.types.HTTP2HealthCheck):

        http_health_check (google.cloud.compute_v1.types.HTTPHealthCheck):

        https_health_check (google.cloud.compute_v1.types.HTTPSHealthCheck):

        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            Type of the resource.
        log_config (google.cloud.compute_v1.types.HealthCheckLogConfig):
            Configure logging on this health check.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. For example, a name that is 1-63
            characters long, matches the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``, and otherwise complies with
            RFC1035. This regular expression describes a name where the
            first character is a lowercase letter, and all following
            characters are a dash, lowercase letter, or digit, except
            the last character, which isn't a dash.
        region (str):
            [Output Only] Region where the health check resides. Not
            applicable to global health checks.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        ssl_health_check (google.cloud.compute_v1.types.SSLHealthCheck):

        tcp_health_check (google.cloud.compute_v1.types.TCPHealthCheck):

        timeout_sec (int):
            How long (in seconds) to wait before claiming
            failure. The default value is 5 seconds. It is
            invalid for timeoutSec to have greater value
            than checkIntervalSec.
        type_ (google.cloud.compute_v1.types.HealthCheck.Type):
            Specifies the type of the healthCheck, either
            TCP, SSL, HTTP, HTTPS or HTTP2. If not
            specified, the default is TCP. Exactly one of
            the protocol-specific health check field must be
            specified, which must match type field.
        unhealthy_threshold (int):
            A so-far healthy instance will be marked
            unhealthy after this many consecutive failures.
            The default value is 2.
    """

    class Type(proto.Enum):
        r"""Specifies the type of the healthCheck, either TCP, SSL, HTTP,
        HTTPS or HTTP2. If not specified, the default is TCP. Exactly
        one of the protocol-specific health check field must be
        specified, which must match type field.
        """
        UNDEFINED_TYPE = 0
        GRPC = 2196510
        HTTP = 2228360
        HTTP2 = 69079210
        HTTPS = 69079243
        INVALID = 530283991
        SSL = 82412
        TCP = 82881

    check_interval_sec = proto.Field(proto.INT32, number=345561006, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    grpc_health_check = proto.Field(
        proto.MESSAGE, number=85529574, optional=True, message="GRPCHealthCheck",
    )
    healthy_threshold = proto.Field(proto.INT32, number=403212361, optional=True,)
    http2_health_check = proto.Field(
        proto.MESSAGE, number=11360986, optional=True, message="HTTP2HealthCheck",
    )
    http_health_check = proto.Field(
        proto.MESSAGE, number=412586940, optional=True, message="HTTPHealthCheck",
    )
    https_health_check = proto.Field(
        proto.MESSAGE, number=436046905, optional=True, message="HTTPSHealthCheck",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="HealthCheckLogConfig",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    ssl_health_check = proto.Field(
        proto.MESSAGE, number=280032440, optional=True, message="SSLHealthCheck",
    )
    tcp_health_check = proto.Field(
        proto.MESSAGE, number=469980419, optional=True, message="TCPHealthCheck",
    )
    timeout_sec = proto.Field(proto.INT32, number=79994995, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)
    unhealthy_threshold = proto.Field(proto.INT32, number=227958480, optional=True,)


class HealthCheckList(proto.Message):
    r"""Contains a list of HealthCheck resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.HealthCheck]):
            A list of HealthCheck resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="HealthCheck",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthCheckReference(proto.Message):
    r"""A full or valid partial URL to a health check. For example,
    the following are valid URLs: -
    https://www.googleapis.com/compute/beta/projects/project-
    id/global/httpHealthChecks/health-check - projects/project-
    id/global/httpHealthChecks/health-check -
    global/httpHealthChecks/health-check

    Attributes:
        health_check (str):

    """

    health_check = proto.Field(proto.STRING, number=308876645, optional=True,)


class HealthCheckService(proto.Message):
    r"""Represents a Health-Check as a Service resource.

    (== resource_for {$api_version}.regionHealthCheckServices ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a HealthCheckService. An
            up-to-date fingerprint must be provided in order
            to patch/update the HealthCheckService;
            Otherwise, the request will fail with error 412
            conditionNotMet. To see the latest fingerprint,
            make a get() request to retrieve the
            HealthCheckService.
        health_checks (Sequence[str]):
            List of URLs to the HealthCheck resources. Must have at
            least one HealthCheck, and not more than 10. HealthCheck
            resources must have portSpecification=USE_SERVING_PORT. For
            regional HealthCheckService, the HealthCheck must be
            regional and in the same region. For global
            HealthCheckService, HealthCheck must be global. Mix of
            regional and global HealthChecks is not supported. Multiple
            regional HealthChecks must belong to the same region.
            Regional HealthChecks</code? must belong to the same region
            as zones of NEGs.
        health_status_aggregation_policy (google.cloud.compute_v1.types.HealthCheckService.HealthStatusAggregationPolicy):
            Optional. Policy for how the results from multiple health
            checks for the same endpoint are aggregated. Defaults to
            NO_AGGREGATION if unspecified.

            -  NO_AGGREGATION. An EndpointHealth message is returned for
               each backend in the health check service.
            -  AND. If any backend's health check reports UNHEALTHY,
               then UNHEALTHY is the HealthState of the entire health
               check service. If all backend's are healthy, the
               HealthState of the health check service is HEALTHY. .
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output only] Type of the resource. Always
            compute#healthCheckServicefor health check services.
        name (str):
            Name of the resource. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        network_endpoint_groups (Sequence[str]):
            List of URLs to the NetworkEndpointGroup
            resources. Must not have more than 100. For
            regional HealthCheckService, NEGs must be in
            zones in the region of the HealthCheckService.
        notification_endpoints (Sequence[str]):
            List of URLs to the NotificationEndpoint
            resources. Must not have more than 10. A list of
            endpoints for receiving notifications of change
            in health status. For regional
            HealthCheckService, NotificationEndpoint must be
            regional and in the same region. For global
            HealthCheckService, NotificationEndpoint must be
            global.
        region (str):
            [Output Only] URL of the region where the health check
            service resides. This field is not applicable to global
            health check services. You must specify this field as part
            of the HTTP request URL. It is not settable as a field in
            the request body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    class HealthStatusAggregationPolicy(proto.Enum):
        r"""Optional. Policy for how the results from multiple health checks for
        the same endpoint are aggregated. Defaults to NO_AGGREGATION if
        unspecified.

        -  NO_AGGREGATION. An EndpointHealth message is returned for each
           backend in the health check service.
        -  AND. If any backend's health check reports UNHEALTHY, then
           UNHEALTHY is the HealthState of the entire health check service.
           If all backend's are healthy, the HealthState of the health check
           service is HEALTHY. .
        """
        UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY = 0
        AND = 64951
        NO_AGGREGATION = 426445124

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    health_checks = proto.RepeatedField(proto.STRING, number=448370606,)
    health_status_aggregation_policy = proto.Field(
        proto.ENUM, number=253163129, optional=True, enum=HealthStatusAggregationPolicy,
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network_endpoint_groups = proto.RepeatedField(proto.STRING, number=29346733,)
    notification_endpoints = proto.RepeatedField(proto.STRING, number=406728490,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class HealthCheckServiceReference(proto.Message):
    r"""A full or valid partial URL to a health check service. For
    example, the following are valid URLs: -
    https://www.googleapis.com/compute/beta/projects/project-
    id/regions/us-west1/healthCheckServices/health-check-service -
    projects/project-id/regions/us-west1/healthCheckServices/health-
    check-service - regions/us-west1/healthCheckServices/health-
    check-service

    Attributes:
        health_check_service (str):

    """

    health_check_service = proto.Field(proto.STRING, number=408374747, optional=True,)


class HealthCheckServicesList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.HealthCheckService]):
            A list of HealthCheckService resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#healthCheckServicesList for lists of
            HealthCheckServices.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="HealthCheckService",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthChecksScopedList(proto.Message):
    r"""
    Attributes:
        health_checks (Sequence[google.cloud.compute_v1.types.HealthCheck]):
            A list of HealthChecks contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.
    """

    health_checks = proto.RepeatedField(
        proto.MESSAGE, number=448370606, message="HealthCheck",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthChecksAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.HealthChecksAggregatedList.ItemsEntry]):
            A list of HealthChecksScopedList resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="HealthChecksScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class HealthStatusForNetworkEndpoint(proto.Message):
    r"""
    Attributes:
        backend_service (google.cloud.compute_v1.types.BackendServiceReference):
            URL of the backend service associated with
            the health state of the network endpoint.
        forwarding_rule (google.cloud.compute_v1.types.ForwardingRuleReference):
            URL of the forwarding rule associated with
            the health state of the network endpoint.
        health_check (google.cloud.compute_v1.types.HealthCheckReference):
            URL of the health check associated with the
            health state of the network endpoint.
        health_check_service (google.cloud.compute_v1.types.HealthCheckServiceReference):
            URL of the health check service associated
            with the health state of the network endpoint.
        health_state (google.cloud.compute_v1.types.HealthStatusForNetworkEndpoint.HealthState):
            Health state of the network endpoint
            determined based on the health checks
            configured.
    """

    class HealthState(proto.Enum):
        r"""Health state of the network endpoint determined based on the
        health checks configured.
        """
        UNDEFINED_HEALTH_STATE = 0
        DRAINING = 480455402
        HEALTHY = 439801213
        UNHEALTHY = 462118084
        UNKNOWN = 433141802

    backend_service = proto.Field(
        proto.MESSAGE,
        number=306946058,
        optional=True,
        message="BackendServiceReference",
    )
    forwarding_rule = proto.Field(
        proto.MESSAGE,
        number=269964030,
        optional=True,
        message="ForwardingRuleReference",
    )
    health_check = proto.Field(
        proto.MESSAGE, number=308876645, optional=True, message="HealthCheckReference",
    )
    health_check_service = proto.Field(
        proto.MESSAGE,
        number=408374747,
        optional=True,
        message="HealthCheckServiceReference",
    )
    health_state = proto.Field(
        proto.ENUM, number=324007150, optional=True, enum=HealthState,
    )


class HostRule(proto.Message):
    r"""UrlMaps A host-matching rule for a URL. If matched, will use
    the named PathMatcher to select the BackendService.

    Attributes:
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        hosts (Sequence[str]):
            The list of host patterns to match. They must be valid
            hostnames with optional port numbers in the format
            host:port. \* matches any string of ([a-z0-9-.]*). In that
            case, \* must be the first character and must be followed in
            the pattern by either - or ..

            -  based matching is not supported when the URL map is bound
               to target gRPC proxy that has validateForProxyless field
               set to true.
        path_matcher (str):
            The name of the PathMatcher to use to match
            the path portion of the URL if the hostRule
            matches the URL's host portion.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    hosts = proto.RepeatedField(proto.STRING, number=99467211,)
    path_matcher = proto.Field(proto.STRING, number=337813272, optional=True,)


class HttpFaultAbort(proto.Message):
    r"""Specification for how requests are aborted as part of fault
    injection.

    Attributes:
        http_status (int):
            The HTTP status code used to abort the
            request. The value must be between 200 and 599
            inclusive.
        percentage (float):
            The percentage of traffic
            (connections/operations/requests) which will be
            aborted as part of fault injection. The value
            must be between 0.0 and 100.0 inclusive.
    """

    http_status = proto.Field(proto.UINT32, number=468949897, optional=True,)
    percentage = proto.Field(proto.DOUBLE, number=151909018, optional=True,)


class HttpFaultDelay(proto.Message):
    r"""Specifies the delay introduced by Loadbalancer before
    forwarding the request to the backend service as part of fault
    injection.

    Attributes:
        fixed_delay (google.cloud.compute_v1.types.Duration):
            Specifies the value of the fixed delay
            interval.
        percentage (float):
            The percentage of traffic
            (connections/operations/requests) on which delay
            will be introduced as part of fault injection.
            The value must be between 0.0 and 100.0
            inclusive.
    """

    fixed_delay = proto.Field(
        proto.MESSAGE, number=317037816, optional=True, message="Duration",
    )
    percentage = proto.Field(proto.DOUBLE, number=151909018, optional=True,)


class HttpFaultInjection(proto.Message):
    r"""The specification for fault injection introduced into traffic
    to test the resiliency of clients to backend service failure. As
    part of fault injection, when clients send requests to a backend
    service, delays can be introduced by Loadbalancer on a
    percentage of requests before sending those request to the
    backend service. Similarly requests from clients can be aborted
    by the Loadbalancer for a percentage of requests.

    Attributes:
        abort (google.cloud.compute_v1.types.HttpFaultAbort):
            The specification for how client requests are
            aborted as part of fault injection.
        delay (google.cloud.compute_v1.types.HttpFaultDelay):
            The specification for how client requests are
            delayed as part of fault injection, before being
            sent to a backend service.
    """

    abort = proto.Field(
        proto.MESSAGE, number=92611376, optional=True, message="HttpFaultAbort",
    )
    delay = proto.Field(
        proto.MESSAGE, number=95467907, optional=True, message="HttpFaultDelay",
    )


class HttpHeaderOption(proto.Message):
    r"""Specification determining how headers are added to requests
    or responses.

    Attributes:
        header_name (str):
            The name of the header.
        header_value (str):
            The value of the header to add.
        replace (bool):
            If false, headerValue is appended to any
            values that already exist for the header. If
            true, headerValue is set for the header,
            discarding any values that were set for that
            header. The default value is false.
    """

    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)
    header_value = proto.Field(proto.STRING, number=203094335, optional=True,)
    replace = proto.Field(proto.BOOL, number=20755124, optional=True,)


class HttpHeaderAction(proto.Message):
    r"""The request and response header transformations that take
    effect before the request is passed along to the selected
    backendService.

    Attributes:
        request_headers_to_add (Sequence[google.cloud.compute_v1.types.HttpHeaderOption]):
            Headers to add to a matching request prior to
            forwarding the request to the backendService.
        request_headers_to_remove (Sequence[str]):
            A list of header names for headers that need
            to be removed from the request prior to
            forwarding the request to the backendService.
        response_headers_to_add (Sequence[google.cloud.compute_v1.types.HttpHeaderOption]):
            Headers to add the response prior to sending
            the response back to the client.
        response_headers_to_remove (Sequence[str]):
            A list of header names for headers that need
            to be removed from the response prior to sending
            the response back to the client.
    """

    request_headers_to_add = proto.RepeatedField(
        proto.MESSAGE, number=72111974, message="HttpHeaderOption",
    )
    request_headers_to_remove = proto.RepeatedField(proto.STRING, number=218425247,)
    response_headers_to_add = proto.RepeatedField(
        proto.MESSAGE, number=32136052, message="HttpHeaderOption",
    )
    response_headers_to_remove = proto.RepeatedField(proto.STRING, number=75415761,)


class Int64RangeMatch(proto.Message):
    r"""HttpRouteRuleMatch criteria for field values that must stay
    within the specified integer range.

    Attributes:
        range_end (int):
            The end of the range (exclusive) in signed
            long integer format.
        range_start (int):
            The start of the range (inclusive) in signed
            long integer format.
    """

    range_end = proto.Field(proto.INT64, number=322439897, optional=True,)
    range_start = proto.Field(proto.INT64, number=103333600, optional=True,)


class HttpHeaderMatch(proto.Message):
    r"""matchRule criteria for request header matches.
    Attributes:
        exact_match (str):
            The value should exactly match contents of
            exactMatch. Only one of exactMatch, prefixMatch,
            suffixMatch, regexMatch, presentMatch or
            rangeMatch must be set.
        header_name (str):
            The name of the HTTP header to match. For matching against
            the HTTP request's authority, use a headerMatch with the
            header name ":authority". For matching a request's method,
            use the headerName ":method". When the URL map is bound to
            target gRPC proxy that has validateForProxyless field set to
            true, only non-binary user-specified custom metadata and the
            ``content-type`` header are supported. The following
            transport-level headers cannot be used in header matching
            rules: ``:authority``, ``:method``, ``:path``, ``:scheme``,
            ``user-agent``, ``accept-encoding``, ``content-encoding``,
            ``grpc-accept-encoding``, ``grpc-encoding``,
            ``grpc-previous-rpc-attempts``, ``grpc-tags-bin``,
            ``grpc-timeout`` and \`grpc-trace-bin.
        invert_match (bool):
            If set to false, the headerMatch is
            considered a match if the match criteria above
            are met. If set to true, the headerMatch is
            considered a match if the match criteria above
            are NOT met. The default setting is false.
        prefix_match (str):
            The value of the header must start with the
            contents of prefixMatch. Only one of exactMatch,
            prefixMatch, suffixMatch, regexMatch,
            presentMatch or rangeMatch must be set.
        present_match (bool):
            A header with the contents of headerName must
            exist. The match takes place whether or not the
            request's header has a value. Only one of
            exactMatch, prefixMatch, suffixMatch,
            regexMatch, presentMatch or rangeMatch must be
            set.
        range_match (google.cloud.compute_v1.types.Int64RangeMatch):
            The header value must be an integer and its value must be in
            the range specified in rangeMatch. If the header does not
            contain an integer, number or is empty, the match fails. For
            example for a range [-5, 0]

            -  -3 will match.
            -  0 will not match.
            -  0.25 will not match.
            -  -3someString will not match. Only one of exactMatch,
               prefixMatch, suffixMatch, regexMatch, presentMatch or
               rangeMatch must be set. Note that rangeMatch is not
               supported for Loadbalancers that have their
               loadBalancingScheme set to EXTERNAL.
        regex_match (str):
            The value of the header must match the regular expression
            specified in regexMatch. For regular expression grammar,
            please see: github.com/google/re2/wiki/Syntax For matching
            against a port specified in the HTTP request, use a
            headerMatch with headerName set to PORT and a regular
            expression that satisfies the RFC2616 Host header's port
            specifier. Only one of exactMatch, prefixMatch, suffixMatch,
            regexMatch, presentMatch or rangeMatch must be set. Note
            that regexMatch only applies to Loadbalancers that have
            their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        suffix_match (str):
            The value of the header must end with the
            contents of suffixMatch. Only one of exactMatch,
            prefixMatch, suffixMatch, regexMatch,
            presentMatch or rangeMatch must be set.
    """

    exact_match = proto.Field(proto.STRING, number=457641093, optional=True,)
    header_name = proto.Field(proto.STRING, number=110223613, optional=True,)
    invert_match = proto.Field(proto.BOOL, number=501130268, optional=True,)
    prefix_match = proto.Field(proto.STRING, number=257898968, optional=True,)
    present_match = proto.Field(proto.BOOL, number=67435841, optional=True,)
    range_match = proto.Field(
        proto.MESSAGE, number=97244227, optional=True, message="Int64RangeMatch",
    )
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)
    suffix_match = proto.Field(proto.STRING, number=426488663, optional=True,)


class HttpQueryParameterMatch(proto.Message):
    r"""HttpRouteRuleMatch criteria for a request's query parameter.
    Attributes:
        exact_match (str):
            The queryParameterMatch matches if the value
            of the parameter exactly matches the contents of
            exactMatch. Only one of presentMatch, exactMatch
            or regexMatch must be set.
        name (str):
            The name of the query parameter to match. The
            query parameter must exist in the request, in
            the absence of which the request match fails.
        present_match (bool):
            Specifies that the queryParameterMatch
            matches if the request contains the query
            parameter, irrespective of whether the parameter
            has a value or not. Only one of presentMatch,
            exactMatch or regexMatch must be set.
        regex_match (str):
            The queryParameterMatch matches if the value of the
            parameter matches the regular expression specified by
            regexMatch. For the regular expression grammar, please see
            github.com/google/re2/wiki/Syntax Only one of presentMatch,
            exactMatch or regexMatch must be set. Note that regexMatch
            only applies when the loadBalancingScheme is set to
            INTERNAL_SELF_MANAGED.
    """

    exact_match = proto.Field(proto.STRING, number=457641093, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    present_match = proto.Field(proto.BOOL, number=67435841, optional=True,)
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)


class HttpRedirectAction(proto.Message):
    r"""Specifies settings for an HTTP redirect.
    Attributes:
        host_redirect (str):
            The host that will be used in the redirect
            response instead of the one that was supplied in
            the request. The value must be between 1 and 255
            characters.
        https_redirect (bool):
            If set to true, the URL scheme in the
            redirected request is set to https. If set to
            false, the URL scheme of the redirected request
            will remain the same as that of the request.
            This must only be set for UrlMaps used in
            TargetHttpProxys. Setting this true for
            TargetHttpsProxy is not permitted. The default
            is set to false.
        path_redirect (str):
            The path that will be used in the redirect
            response instead of the one that was supplied in
            the request. pathRedirect cannot be supplied
            together with prefixRedirect. Supply one alone
            or neither. If neither is supplied, the path of
            the original request will be used for the
            redirect. The value must be between 1 and 1024
            characters.
        prefix_redirect (str):
            The prefix that replaces the prefixMatch
            specified in the HttpRouteRuleMatch, retaining
            the remaining portion of the URL before
            redirecting the request. prefixRedirect cannot
            be supplied together with pathRedirect. Supply
            one alone or neither. If neither is supplied,
            the path of the original request will be used
            for the redirect. The value must be between 1
            and 1024 characters.
        redirect_response_code (google.cloud.compute_v1.types.HttpRedirectAction.RedirectResponseCode):
            The HTTP Status code to use for this RedirectAction.
            Supported values are:

            -  MOVED_PERMANENTLY_DEFAULT, which is the default value and
               corresponds to 301.
            -  FOUND, which corresponds to 302.
            -  SEE_OTHER which corresponds to 303.
            -  TEMPORARY_REDIRECT, which corresponds to 307. In this
               case, the request method will be retained.
            -  PERMANENT_REDIRECT, which corresponds to 308. In this
               case, the request method will be retained.
        strip_query (bool):
            If set to true, any accompanying query
            portion of the original URL is removed prior to
            redirecting the request. If set to false, the
            query portion of the original URL is retained.
            The default is set to false.
    """

    class RedirectResponseCode(proto.Enum):
        r"""The HTTP Status code to use for this RedirectAction. Supported
        values are:

        -  MOVED_PERMANENTLY_DEFAULT, which is the default value and
           corresponds to 301.
        -  FOUND, which corresponds to 302.
        -  SEE_OTHER which corresponds to 303.
        -  TEMPORARY_REDIRECT, which corresponds to 307. In this case, the
           request method will be retained.
        -  PERMANENT_REDIRECT, which corresponds to 308. In this case, the
           request method will be retained.
        """
        UNDEFINED_REDIRECT_RESPONSE_CODE = 0
        FOUND = 67084130
        MOVED_PERMANENTLY_DEFAULT = 386698449
        PERMANENT_REDIRECT = 382006381
        SEE_OTHER = 445380580
        TEMPORARY_REDIRECT = 489550378

    host_redirect = proto.Field(proto.STRING, number=107417747, optional=True,)
    https_redirect = proto.Field(proto.BOOL, number=170260656, optional=True,)
    path_redirect = proto.Field(proto.STRING, number=272342710, optional=True,)
    prefix_redirect = proto.Field(proto.STRING, number=446184169, optional=True,)
    redirect_response_code = proto.Field(
        proto.ENUM, number=436710408, optional=True, enum=RedirectResponseCode,
    )
    strip_query = proto.Field(proto.BOOL, number=52284641, optional=True,)


class HttpRetryPolicy(proto.Message):
    r"""The retry policy associates with HttpRouteRule
    Attributes:
        num_retries (int):
            Specifies the allowed number retries. This
            number must be > 0. If not specified, defaults
            to 1.
        per_try_timeout (google.cloud.compute_v1.types.Duration):
            Specifies a non-zero timeout per retry
            attempt. If not specified, will use the timeout
            set in HttpRouteAction. If timeout in
            HttpRouteAction is not set, will use the largest
            timeout among all backend services associated
            with the route.
        retry_conditions (Sequence[str]):
            Specfies one or more conditions when this retry rule
            applies. Valid values are:

            -  5xx: Loadbalancer will attempt a retry if the backend
               service responds with any 5xx response code, or if the
               backend service does not respond at all, example:
               disconnects, reset, read timeout, connection failure, and
               refused streams.
            -  gateway-error: Similar to 5xx, but only applies to
               response codes 502, 503 or 504.
            -
            -  connect-failure: Loadbalancer will retry on failures
               connecting to backend services, for example due to
               connection timeouts.
            -  retriable-4xx: Loadbalancer will retry for retriable 4xx
               response codes. Currently the only retriable error
               supported is 409.
            -  refused-stream:Loadbalancer will retry if the backend
               service resets the stream with a REFUSED_STREAM error
               code. This reset type indicates that it is safe to retry.
            -  cancelledLoadbalancer will retry if the gRPC status code
               in the response header is set to cancelled
            -  deadline-exceeded: Loadbalancer will retry if the gRPC
               status code in the response header is set to
               deadline-exceeded
            -  resource-exhausted: Loadbalancer will retry if the gRPC
               status code in the response header is set to
               resource-exhausted
            -  unavailable: Loadbalancer will retry if the gRPC status
               code in the response header is set to unavailable
    """

    num_retries = proto.Field(proto.UINT32, number=251680141, optional=True,)
    per_try_timeout = proto.Field(
        proto.MESSAGE, number=280041147, optional=True, message="Duration",
    )
    retry_conditions = proto.RepeatedField(proto.STRING, number=28815535,)


class RequestMirrorPolicy(proto.Message):
    r"""A policy that specifies how requests intended for the route's
    backends are shadowed to a separate mirrored backend service.
    Loadbalancer does not wait for responses from the shadow
    service. Prior to sending traffic to the shadow service, the
    host / authority header is suffixed with -shadow.

    Attributes:
        backend_service (str):
            The full or partial URL to the BackendService
            resource being mirrored to.
    """

    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)


class UrlRewrite(proto.Message):
    r"""The spec for modifying the path before sending the request to
    the matched backend service.

    Attributes:
        host_rewrite (str):
            Prior to forwarding the request to the
            selected service, the request's host header is
            replaced with contents of hostRewrite. The value
            must be between 1 and 255 characters.
        path_prefix_rewrite (str):
            Prior to forwarding the request to the
            selected backend service, the matching portion
            of the request's path is replaced by
            pathPrefixRewrite. The value must be between 1
            and 1024 characters.
    """

    host_rewrite = proto.Field(proto.STRING, number=159819253, optional=True,)
    path_prefix_rewrite = proto.Field(proto.STRING, number=41186361, optional=True,)


class WeightedBackendService(proto.Message):
    r"""In contrast to a single BackendService in  HttpRouteAction to
    which all matching traffic is directed to,
    WeightedBackendService allows traffic to be split across
    multiple BackendServices. The volume of traffic for each
    BackendService is proportional to the weight specified in each
    WeightedBackendService

    Attributes:
        backend_service (str):
            The full or partial URL to the default
            BackendService resource. Before forwarding the
            request to backendService, the loadbalancer
            applies any relevant headerActions specified as
            part of this backendServiceWeight.
        header_action (google.cloud.compute_v1.types.HttpHeaderAction):
            Specifies changes to request and response
            headers that need to take effect for the
            selected backendService. headerAction specified
            here take effect before headerAction in the
            enclosing HttpRouteRule, PathMatcher and UrlMap.
            Note that headerAction is not supported for
            Loadbalancers that have their
            loadBalancingScheme set to EXTERNAL. Not
            supported when the URL map is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.
        weight (int):
            Specifies the fraction of traffic sent to
            backendService, computed as weight / (sum of all
            weightedBackendService weights in routeAction) .
            The selection of a backend service is determined
            only for new traffic. Once a user's request has
            been directed to a backendService, subsequent
            requests will be sent to the same backendService
            as determined by the BackendService's session
            affinity policy. The value must be between 0 and
            1000
    """

    backend_service = proto.Field(proto.STRING, number=306946058, optional=True,)
    header_action = proto.Field(
        proto.MESSAGE, number=328077352, optional=True, message="HttpHeaderAction",
    )
    weight = proto.Field(proto.UINT32, number=282149496, optional=True,)


class HttpRouteAction(proto.Message):
    r"""
    Attributes:
        cors_policy (google.cloud.compute_v1.types.CorsPolicy):
            The specification for allowing client side
            cross-origin requests. Please see W3C
            Recommendation for Cross Origin Resource Sharing
            Not supported when the URL map is bound to
            target gRPC proxy.
        fault_injection_policy (google.cloud.compute_v1.types.HttpFaultInjection):
            The specification for fault injection introduced into
            traffic to test the resiliency of clients to backend service
            failure. As part of fault injection, when clients send
            requests to a backend service, delays can be introduced by
            Loadbalancer on a percentage of requests before sending
            those request to the backend service. Similarly requests
            from clients can be aborted by the Loadbalancer for a
            percentage of requests. timeout and retry_policy will be
            ignored by clients that are configured with a
            fault_injection_policy. Not supported when the URL map is
            bound to target gRPC proxy that has validateForProxyless
            field set to true.
        max_stream_duration (google.cloud.compute_v1.types.Duration):
            Specifies the maximum duration (timeout) for streams on the
            selected route. Unlike the timeout field where the timeout
            duration starts from the time the request has been fully
            processed (i.e. end-of-stream), the duration in this field
            is computed from the beginning of the stream until the
            response has been completely processed, including all
            retries. A stream that does not complete in this duration is
            closed. If not specified, will use the largest
            maxStreamDuration among all backend services associated with
            the route. This field is only allowed if the Url map is used
            with backend services with loadBalancingScheme set to
            INTERNAL_SELF_MANAGED.
        request_mirror_policy (google.cloud.compute_v1.types.RequestMirrorPolicy):
            Specifies the policy on how requests intended
            for the route's backends are shadowed to a
            separate mirrored backend service. Loadbalancer
            does not wait for responses from the shadow
            service. Prior to sending traffic to the shadow
            service, the host / authority header is suffixed
            with -shadow. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.
        retry_policy (google.cloud.compute_v1.types.HttpRetryPolicy):
            Specifies the retry policy associated with
            this route. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.
        timeout (google.cloud.compute_v1.types.Duration):
            Specifies the timeout for the selected route.
            Timeout is computed from the time the request
            has been fully processed (i.e. end-of-stream) up
            until the response has been completely
            processed. Timeout includes all retries. If not
            specified, will use the largest timeout among
            all backend services associated with the route.
            Not supported when the URL map is bound to
            target gRPC proxy that has validateForProxyless
            field set to true.
        url_rewrite (google.cloud.compute_v1.types.UrlRewrite):
            The spec to modify the URL of the request,
            prior to forwarding the request to the matched
            service. urlRewrite is the only action supported
            in UrlMaps for external HTTP(S) load balancers.
            Not supported when the URL map is bound to
            target gRPC proxy that has validateForProxyless
            field set to true.
        weighted_backend_services (Sequence[google.cloud.compute_v1.types.WeightedBackendService]):
            A list of weighted backend services to send
            traffic to when a route match occurs. The
            weights determine the fraction of traffic that
            flows to their corresponding backend service. If
            all traffic needs to go to a single backend
            service, there must be one
            weightedBackendService with weight set to a non-
            zero number. Once a backendService is identified
            and before forwarding the request to the backend
            service, advanced routing actions such as URL
            rewrites and header transformations are applied
            depending on additional settings specified in
            this HttpRouteAction.
    """

    cors_policy = proto.Field(
        proto.MESSAGE, number=398943748, optional=True, message="CorsPolicy",
    )
    fault_injection_policy = proto.Field(
        proto.MESSAGE, number=412781079, optional=True, message="HttpFaultInjection",
    )
    max_stream_duration = proto.Field(
        proto.MESSAGE, number=61428376, optional=True, message="Duration",
    )
    request_mirror_policy = proto.Field(
        proto.MESSAGE, number=220196866, optional=True, message="RequestMirrorPolicy",
    )
    retry_policy = proto.Field(
        proto.MESSAGE, number=56799913, optional=True, message="HttpRetryPolicy",
    )
    timeout = proto.Field(
        proto.MESSAGE, number=296701281, optional=True, message="Duration",
    )
    url_rewrite = proto.Field(
        proto.MESSAGE, number=273333948, optional=True, message="UrlRewrite",
    )
    weighted_backend_services = proto.RepeatedField(
        proto.MESSAGE, number=337028049, message="WeightedBackendService",
    )


class HttpRouteRuleMatch(proto.Message):
    r"""HttpRouteRuleMatch specifies a set of criteria for matching
    requests to an HttpRouteRule. All specified criteria must be
    satisfied for a match to occur.

    Attributes:
        full_path_match (str):
            For satisfying the matchRule condition, the
            path of the request must exactly match the value
            specified in fullPathMatch after removing any
            query parameters and anchor that may be part of
            the original URL. fullPathMatch must be between
            1 and 1024 characters. Only one of prefixMatch,
            fullPathMatch or regexMatch must be specified.
        header_matches (Sequence[google.cloud.compute_v1.types.HttpHeaderMatch]):
            Specifies a list of header match criteria,
            all of which must match corresponding headers in
            the request.
        ignore_case (bool):
            Specifies that prefixMatch and fullPathMatch
            matches are case sensitive. The default value is
            false. ignoreCase must not be used with
            regexMatch.
            Not supported when the URL map is bound to
            target gRPC proxy.
        metadata_filters (Sequence[google.cloud.compute_v1.types.MetadataFilter]):
            Opaque filter criteria used by Loadbalancer to restrict
            routing configuration to a limited set of xDS compliant
            clients. In their xDS requests to Loadbalancer, xDS clients
            present node metadata. When there is a match, the relevant
            routing configuration is made available to those proxies.
            For each metadataFilter in this list, if its
            filterMatchCriteria is set to MATCH_ANY, at least one of the
            filterLabels must match the corresponding label provided in
            the metadata. If its filterMatchCriteria is set to
            MATCH_ALL, then all of its filterLabels must match with
            corresponding labels provided in the metadata. If multiple
            metadataFilters are specified, all of them need to be
            satisfied in order to be considered a match. metadataFilters
            specified here will be applied after those specified in
            ForwardingRule that refers to the UrlMap this
            HttpRouteRuleMatch belongs to. metadataFilters only applies
            to Loadbalancers that have their loadBalancingScheme set to
            INTERNAL_SELF_MANAGED. Not supported when the URL map is
            bound to target gRPC proxy that has validateForProxyless
            field set to true.
        prefix_match (str):
            For satisfying the matchRule condition, the
            request's path must begin with the specified
            prefixMatch. prefixMatch must begin with a /.
            The value must be between 1 and 1024 characters.
            Only one of prefixMatch, fullPathMatch or
            regexMatch must be specified.
        query_parameter_matches (Sequence[google.cloud.compute_v1.types.HttpQueryParameterMatch]):
            Specifies a list of query parameter match
            criteria, all of which must match corresponding
            query parameters in the request. Not supported
            when the URL map is bound to target gRPC proxy.
        regex_match (str):
            For satisfying the matchRule condition, the path of the
            request must satisfy the regular expression specified in
            regexMatch after removing any query parameters and anchor
            supplied with the original URL. For regular expression
            grammar please see github.com/google/re2/wiki/Syntax Only
            one of prefixMatch, fullPathMatch or regexMatch must be
            specified. Note that regexMatch only applies to
            Loadbalancers that have their loadBalancingScheme set to
            INTERNAL_SELF_MANAGED.
    """

    full_path_match = proto.Field(proto.STRING, number=214598875, optional=True,)
    header_matches = proto.RepeatedField(
        proto.MESSAGE, number=361903489, message="HttpHeaderMatch",
    )
    ignore_case = proto.Field(proto.BOOL, number=464324989, optional=True,)
    metadata_filters = proto.RepeatedField(
        proto.MESSAGE, number=464725739, message="MetadataFilter",
    )
    prefix_match = proto.Field(proto.STRING, number=257898968, optional=True,)
    query_parameter_matches = proto.RepeatedField(
        proto.MESSAGE, number=286231270, message="HttpQueryParameterMatch",
    )
    regex_match = proto.Field(proto.STRING, number=107387853, optional=True,)


class HttpRouteRule(proto.Message):
    r"""An HttpRouteRule specifies how to match an HTTP request and
    the corresponding routing action that load balancing proxies
    will perform.

    Attributes:
        description (str):
            The short description conveying the intent of
            this routeRule. The description can have a
            maximum length of 1024 characters.
        header_action (google.cloud.compute_v1.types.HttpHeaderAction):
            Specifies changes to request and response headers that need
            to take effect for the selected backendService. The
            headerAction specified here are applied before the matching
            pathMatchers[].headerAction and after
            pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction
            Note that headerAction is not supported for Loadbalancers
            that have their loadBalancingScheme set to EXTERNAL. Not
            supported when the URL map is bound to target gRPC proxy
            that has validateForProxyless field set to true.
        match_rules (Sequence[google.cloud.compute_v1.types.HttpRouteRuleMatch]):
            The list of criteria for matching attributes
            of a request to this routeRule. This list has OR
            semantics: the request matches this routeRule
            when any of the matchRules are satisfied.
            However predicates within a given matchRule have
            AND semantics. All predicates within a matchRule
            must match for the request to match the rule.
        priority (int):
            For routeRules within a given pathMatcher,
            priority determines the order in which load
            balancer will interpret routeRules. RouteRules
            are evaluated in order of priority, from the
            lowest to highest number. The priority of a rule
            decreases as its number increases (1, 2, 3,
            N+1). The first rule that matches the request is
            applied. You cannot configure two or more
            routeRules with the same priority. Priority for
            each rule must be set to a number between 0 and
            2147483647 inclusive. Priority numbers can have
            gaps, which enable you to add or remove rules in
            the future without affecting the rest of the
            rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is
            a valid series of priority numbers to which you
            could add rules numbered from 6 to 8, 10 to 11,
            and 13 to 15 in the future without any impact on
            existing rules.
        route_action (google.cloud.compute_v1.types.HttpRouteAction):
            In response to a matching matchRule, the load
            balancer performs advanced routing actions like
            URL rewrites, header transformations, etc. prior
            to forwarding the request to the selected
            backend. If  routeAction specifies any
            weightedBackendServices, service must not be
            set. Conversely if service is set, routeAction
            cannot contain any  weightedBackendServices.
            Only one of urlRedirect, service or
            routeAction.weightedBackendService must be set.
            UrlMaps for external HTTP(S) load balancers
            support only the urlRewrite action within a
            routeRule's routeAction.
        service (str):
            The full or partial URL of the backend
            service resource to which traffic is directed if
            this rule is matched. If routeAction is
            additionally specified, advanced routing actions
            like URL Rewrites, etc. take effect prior to
            sending the request to the backend. However, if
            service is specified, routeAction cannot contain
            any weightedBackendService s. Conversely, if
            routeAction specifies any
            weightedBackendServices, service must not be
            specified. Only one of urlRedirect, service or
            routeAction.weightedBackendService must be set.
        url_redirect (google.cloud.compute_v1.types.HttpRedirectAction):
            When this rule is matched, the request is
            redirected to a URL specified by urlRedirect. If
            urlRedirect is specified, service or routeAction
            must not be set. Not supported when the URL map
            is bound to target gRPC proxy.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    header_action = proto.Field(
        proto.MESSAGE, number=328077352, optional=True, message="HttpHeaderAction",
    )
    match_rules = proto.RepeatedField(
        proto.MESSAGE, number=376200701, message="HttpRouteRuleMatch",
    )
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)
    route_action = proto.Field(
        proto.MESSAGE, number=424563948, optional=True, message="HttpRouteAction",
    )
    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    url_redirect = proto.Field(
        proto.MESSAGE, number=405147820, optional=True, message="HttpRedirectAction",
    )


class RawDisk(proto.Message):
    r"""The parameters of the raw disk image.
    Attributes:
        container_type (google.cloud.compute_v1.types.RawDisk.ContainerType):
            The format used to encode and transmit the
            block device, which should be TAR. This is just
            a container and transmission format and not a
            runtime format. Provided by the client when the
            disk image is created.
        sha1_checksum (str):
            [Deprecated] This field is deprecated. An optional SHA1
            checksum of the disk image before unpackaging provided by
            the client when the disk image is created.
        source (str):
            The full Google Cloud Storage URL where the
            disk image is stored. You must provide either
            this property or the sourceDisk property but not
            both.
    """

    class ContainerType(proto.Enum):
        r"""The format used to encode and transmit the block device,
        which should be TAR. This is just a container and transmission
        format and not a runtime format. Provided by the client when the
        disk image is created.
        """
        UNDEFINED_CONTAINER_TYPE = 0
        TAR = 82821

    container_type = proto.Field(
        proto.ENUM, number=318809144, optional=True, enum=ContainerType,
    )
    sha1_checksum = proto.Field(proto.STRING, number=314444349, optional=True,)
    source = proto.Field(proto.STRING, number=177235995, optional=True,)


class Image(proto.Message):
    r"""Represents an Image resource.

    You can use images to create boot disks for your VM instances. For
    more information, read Images. (== resource_for
    {$api_version}.images ==)

    Attributes:
        archive_size_bytes (int):
            Size of the image tar.gz archive stored in
            Google Cloud Storage (in bytes).
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            The deprecation status associated with this
            image.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        disk_size_gb (int):
            Size of the image when restored onto a
            persistent disk (in GB).
        family (str):
            The name of the image family to which this
            image belongs. You can create disks by
            specifying an image family instead of a specific
            image name. The image family always returns its
            latest image that is not deprecated. The name of
            the image family must comply with RFC1035.
        guest_os_features (Sequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read  Enabling guest operating system
            features to see a list of available options.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts the image using a customer-supplied
            encryption key.
            After you encrypt an image with a customer-
            supplied key, you must provide the same key if
            you use the image later (e.g. to create a disk
            from the image).
            Customer-supplied encryption keys do not protect
            access to metadata of the disk.
            If you do not provide an encryption key when
            creating the image, then the disk will be
            encrypted using an automatically generated key
            and you do not need to provide a key to use the
            image later.
        kind (str):
            [Output Only] Type of the resource. Always compute#image for
            images.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this image, which is essentially a hash of the
            labels used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve an image.
        labels (Sequence[google.cloud.compute_v1.types.Image.LabelsEntry]):
            Labels to apply to this image. These can be
            later modified by the setLabels method.
        license_codes (Sequence[int]):
            Integer license codes indicating which
            licenses are attached to this image.
        licenses (Sequence[str]):
            Any applicable license URI.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        raw_disk (google.cloud.compute_v1.types.RawDisk):
            The parameters of the raw disk image.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        shielded_instance_initial_state (google.cloud.compute_v1.types.InitialStateConfig):
            Set the secure boot keys of shielded
            instance.
        source_disk (str):
            URL of the source disk used to create this
            image. This can be a full or valid partial URL.
            You must provide either this property or the
            rawDisk.source property but not both to create
            an image. For example, the following are valid
            values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
            - projects/project/zones/zone/disks/disk
            - zones/zone/disks/disk
        source_disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source disk. Required if the source disk is
            protected by a customer-supplied encryption key.
        source_disk_id (str):
            [Output Only] The ID value of the disk used to create this
            image. This value may be used to determine whether the image
            was taken from the current or a previous instance of a given
            disk name.
        source_image (str):
            URL of the source image used to create this
            image.
            In order to create an image, you must provide
            the full or partial URL of one of the following:
            - The selfLink URL
            - This property
            - The rawDisk.source URL
            - The sourceDisk URL
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.
        source_image_id (str):
            [Output Only] The ID value of the image used to create this
            image. This value may be used to determine whether the image
            was taken from the current or a previous instance of a given
            image name.
        source_snapshot (str):
            URL of the source snapshot used to create
            this image.
            In order to create an image, you must provide
            the full or partial URL of one of the following:
            - The selfLink URL
            - This property
            - The sourceImage URL
            - The rawDisk.source URL
            - The sourceDisk URL
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot. Required if the source snapshot
            is protected by a customer-supplied encryption
            key.
        source_snapshot_id (str):
            [Output Only] The ID value of the snapshot used to create
            this image. This value may be used to determine whether the
            snapshot was taken from the current or a previous instance
            of a given snapshot name.
        source_type (google.cloud.compute_v1.types.Image.SourceType):
            The type of the image used to create this
            disk. The default and only value is RAW
        status (google.cloud.compute_v1.types.Image.Status):
            [Output Only] The status of the image. An image can be used
            to create other resources, such as instances, only after the
            image has been successfully created and the status is set to
            READY. Possible values are FAILED, PENDING, or READY.
        storage_locations (Sequence[str]):
            Cloud Storage bucket storage location of the
            image (regional or multi-regional).
    """

    class SourceType(proto.Enum):
        r"""The type of the image used to create this disk. The default
        and only value is RAW
        """
        UNDEFINED_SOURCE_TYPE = 0
        RAW = 80904

    class Status(proto.Enum):
        r"""[Output Only] The status of the image. An image can be used to
        create other resources, such as instances, only after the image has
        been successfully created and the status is set to READY. Possible
        values are FAILED, PENDING, or READY.
        """
        UNDEFINED_STATUS = 0
        DELETING = 528602024
        FAILED = 455706685
        PENDING = 35394935
        READY = 77848963

    archive_size_bytes = proto.Field(proto.INT64, number=381093450, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    family = proto.Field(proto.STRING, number=328751972, optional=True,)
    guest_os_features = proto.RepeatedField(
        proto.MESSAGE, number=79294545, message="GuestOsFeature",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    image_encryption_key = proto.Field(
        proto.MESSAGE, number=379512583, optional=True, message="CustomerEncryptionKey",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    license_codes = proto.RepeatedField(proto.INT64, number=45482664,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    raw_disk = proto.Field(
        proto.MESSAGE, number=503113556, optional=True, message="RawDisk",
    )
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    shielded_instance_initial_state = proto.Field(
        proto.MESSAGE, number=192356867, optional=True, message="InitialStateConfig",
    )
    source_disk = proto.Field(proto.STRING, number=451753793, optional=True,)
    source_disk_encryption_key = proto.Field(
        proto.MESSAGE, number=531501153, optional=True, message="CustomerEncryptionKey",
    )
    source_disk_id = proto.Field(proto.STRING, number=454190809, optional=True,)
    source_image = proto.Field(proto.STRING, number=50443319, optional=True,)
    source_image_encryption_key = proto.Field(
        proto.MESSAGE, number=381503659, optional=True, message="CustomerEncryptionKey",
    )
    source_image_id = proto.Field(proto.STRING, number=55328291, optional=True,)
    source_snapshot = proto.Field(proto.STRING, number=126061928, optional=True,)
    source_snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=303679322, optional=True, message="CustomerEncryptionKey",
    )
    source_snapshot_id = proto.Field(proto.STRING, number=98962258, optional=True,)
    source_type = proto.Field(
        proto.ENUM, number=452245726, optional=True, enum=SourceType,
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    storage_locations = proto.RepeatedField(proto.STRING, number=328005274,)


class ImageList(proto.Message):
    r"""Contains a list of images.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Image]):
            A list of Image resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Image",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Metadata(proto.Message):
    r"""A metadata key/value entry.
    Attributes:
        fingerprint (str):
            Specifies a fingerprint for this request,
            which is essentially a hash of the metadata's
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update metadata. You must always provide an
            up-to-date fingerprint hash in order to update
            or change metadata, otherwise the request will
            fail with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve the resource.
        items (Sequence[google.cloud.compute_v1.types.Items]):
            Array of key/value pairs. The total size of
            all keys and values must be less than 512 KB.
        kind (str):
            [Output Only] Type of the resource. Always compute#metadata
            for metadata.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Items",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class NetworkInterface(proto.Message):
    r"""A network interface resource attached to an instance.
    Attributes:
        access_configs (Sequence[google.cloud.compute_v1.types.AccessConfig]):
            An array of configurations for this interface. Currently,
            only one access config, ONE_TO_ONE_NAT, is supported. If
            there are no accessConfigs specified, then this instance
            will have no external internet access.
        alias_ip_ranges (Sequence[google.cloud.compute_v1.types.AliasIpRange]):
            An array of alias IP ranges for this network
            interface. You can only specify this field for
            network interfaces in VPC networks.
        fingerprint (str):
            Fingerprint hash of contents stored in this
            network interface. This field will be ignored
            when inserting an Instance or adding a
            NetworkInterface. An up-to-date fingerprint must
            be provided in order to update the
            NetworkInterface. The request will fail with
            error 400 Bad Request if the fingerprint is not
            provided, or 412 Precondition Failed if the
            fingerprint is out of date.
        ipv6_address (str):
            [Output Only] An IPv6 internal network address for this
            network interface.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#networkInterface for network interfaces.
        name (str):
            [Output Only] The name of the network interface, which is
            generated by the server. For network devices, these are
            eth0, eth1, etc.
        network (str):
            URL of the network resource for this
            instance. When creating an instance, if neither
            the network nor the subnetwork is specified, the
            default network global/networks/default is used;
            if the network is not specified but the
            subnetwork is specified, the network is
            inferred.  If you specify this property, you can
            specify the network as a full or partial URL.
            For example, the following are all valid URLs: -
            https://www.googleapis.com/compute/v1/projects/project/global/networks/network
            - projects/project/global/networks/network
            - global/networks/default
        network_i_p (str):
            An IPv4 internal IP address to assign to the
            instance for this network interface. If not
            specified by the user, an unused internal IP is
            assigned by the system.
        nic_type (google.cloud.compute_v1.types.NetworkInterface.NicType):
            The type of vNIC to be used on this
            interface. This may be gVNIC or VirtioNet.
        subnetwork (str):
            The URL of the Subnetwork resource for this
            instance. If the network resource is in legacy
            mode, do not specify this field. If the network
            is in auto subnet mode, specifying the
            subnetwork is optional. If the network is in
            custom subnet mode, specifying the subnetwork is
            required. If you specify this field, you can
            specify the subnetwork as a full or partial URL.
            For example, the following are all valid URLs: -
            https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnetwork
            - regions/region/subnetworks/subnetwork
    """

    class NicType(proto.Enum):
        r"""The type of vNIC to be used on this interface. This may be
        gVNIC or VirtioNet.
        """
        UNDEFINED_NIC_TYPE = 0
        GVNIC = 68209305
        UNSPECIFIED_NIC_TYPE = 67411801
        VIRTIO_NET = 452123481

    access_configs = proto.RepeatedField(
        proto.MESSAGE, number=111058326, message="AccessConfig",
    )
    alias_ip_ranges = proto.RepeatedField(
        proto.MESSAGE, number=165085631, message="AliasIpRange",
    )
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    ipv6_address = proto.Field(proto.STRING, number=341563804, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_i_p = proto.Field(proto.STRING, number=207181961, optional=True,)
    nic_type = proto.Field(proto.ENUM, number=59810577, optional=True, enum=NicType,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)


class ReservationAffinity(proto.Message):
    r"""Specifies the reservations that this instance can consume
    from.

    Attributes:
        consume_reservation_type (google.cloud.compute_v1.types.ReservationAffinity.ConsumeReservationType):
            Specifies the type of reservation from which this instance
            can consume resources: ANY_RESERVATION (default),
            SPECIFIC_RESERVATION, or NO_RESERVATION. See Consuming
            reserved instances for examples.
        key (str):
            Corresponds to the label key of a reservation resource. To
            target a SPECIFIC_RESERVATION by name, specify
            googleapis.com/reservation-name as the key and specify the
            name of your reservation as its value.
        values (Sequence[str]):
            Corresponds to the label values of a
            reservation resource.
    """

    class ConsumeReservationType(proto.Enum):
        r"""Specifies the type of reservation from which this instance can
        consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION,
        or NO_RESERVATION. See Consuming reserved instances for examples.
        """
        UNDEFINED_CONSUME_RESERVATION_TYPE = 0
        ANY_RESERVATION = 200008121
        NO_RESERVATION = 169322030
        SPECIFIC_RESERVATION = 229889055
        UNSPECIFIED = 526786327

    consume_reservation_type = proto.Field(
        proto.ENUM, number=300736944, optional=True, enum=ConsumeReservationType,
    )
    key = proto.Field(proto.STRING, number=106079, optional=True,)
    values = proto.RepeatedField(proto.STRING, number=249928994,)


class Scheduling(proto.Message):
    r"""Sets the scheduling options for an Instance. NextID: 20
    Attributes:
        automatic_restart (bool):
            Specifies whether the instance should be
            automatically restarted if it is terminated by
            Compute Engine (not terminated by a user). You
            can only set the automatic restart option for
            standard instances. Preemptible instances cannot
            be automatically restarted.  By default, this is
            set to true so an instance is automatically
            restarted if it is terminated by Compute Engine.
        location_hint (str):
            An opaque location hint used to place the
            instance close to other resources. This field is
            for use by internal tools that use the public
            API.
        min_node_cpus (int):
            The minimum number of virtual CPUs this
            instance will consume when running on a sole-
            tenant node.
        node_affinities (Sequence[google.cloud.compute_v1.types.SchedulingNodeAffinity]):
            A set of node affinity and anti-affinity
            configurations. Refer to Configuring node
            affinity for more information. Overrides
            reservationAffinity.
        on_host_maintenance (google.cloud.compute_v1.types.Scheduling.OnHostMaintenance):
            Defines the maintenance behavior for this
            instance. For standard instances, the default
            behavior is MIGRATE. For preemptible instances,
            the default and only possible behavior is
            TERMINATE. For more information, see Setting
            Instance Scheduling Options.
        preemptible (bool):
            Defines whether the instance is preemptible. This can only
            be set during instance creation or while the instance is
            stopped and therefore, in a ``TERMINATED`` state. See
            Instance Life Cycle for more information on the possible
            instance states.
    """

    class OnHostMaintenance(proto.Enum):
        r"""Defines the maintenance behavior for this instance. For
        standard instances, the default behavior is MIGRATE. For
        preemptible instances, the default and only possible behavior is
        TERMINATE. For more information, see Setting Instance Scheduling
        Options.
        """
        UNDEFINED_ON_HOST_MAINTENANCE = 0
        MIGRATE = 165699979
        TERMINATE = 527617601

    automatic_restart = proto.Field(proto.BOOL, number=350821371, optional=True,)
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    min_node_cpus = proto.Field(proto.INT32, number=317231675, optional=True,)
    node_affinities = proto.RepeatedField(
        proto.MESSAGE, number=461799971, message="SchedulingNodeAffinity",
    )
    on_host_maintenance = proto.Field(
        proto.ENUM, number=64616796, optional=True, enum=OnHostMaintenance,
    )
    preemptible = proto.Field(proto.BOOL, number=324203169, optional=True,)


class ServiceAccount(proto.Message):
    r"""A service account.
    Attributes:
        email (str):
            Email address of the service account.
        scopes (Sequence[str]):
            The list of scopes to be made available for
            this service account.
    """

    email = proto.Field(proto.STRING, number=96619420, optional=True,)
    scopes = proto.RepeatedField(proto.STRING, number=165973151,)


class ShieldedInstanceConfig(proto.Message):
    r"""A set of Shielded Instance options.
    Attributes:
        enable_integrity_monitoring (bool):
            Defines whether the instance has integrity
            monitoring enabled. Enabled by default.
        enable_secure_boot (bool):
            Defines whether the instance has Secure Boot
            enabled. Disabled by default.
        enable_vtpm (bool):
            Defines whether the instance has the vTPM
            enabled. Enabled by default.
    """

    enable_integrity_monitoring = proto.Field(
        proto.BOOL, number=409071030, optional=True,
    )
    enable_secure_boot = proto.Field(proto.BOOL, number=123568638, optional=True,)
    enable_vtpm = proto.Field(proto.BOOL, number=181858935, optional=True,)


class ShieldedInstanceIntegrityPolicy(proto.Message):
    r"""The policy describes the baseline against which Instance boot
    integrity is measured.

    Attributes:
        update_auto_learn_policy (bool):
            Updates the integrity policy baseline using
            the measurements from the VM instance's most
            recent boot.
    """

    update_auto_learn_policy = proto.Field(proto.BOOL, number=245490215, optional=True,)


class Tags(proto.Message):
    r"""A set of instance tags.
    Attributes:
        fingerprint (str):
            Specifies a fingerprint for this request,
            which is essentially a hash of the tags'
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update tags. You must always provide an up-
            to-date fingerprint hash in order to update or
            change tags.  To see the latest fingerprint,
            make get() request to the instance.
        items (Sequence[str]):
            An array of tags. Each tag must be 1-63
            characters long, and comply with RFC1035.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    items = proto.RepeatedField(proto.STRING, number=100526016,)


class Instance(proto.Message):
    r"""Represents an Instance resource.

    An instance is a virtual machine that is hosted on Google Cloud
    Platform. For more information, read Virtual Machine Instances. (==
    resource_for {$api_version}.instances ==)

    Attributes:
        advanced_machine_features (google.cloud.compute_v1.types.AdvancedMachineFeatures):
            Controls for advanced machine-related
            behavior features.
        can_ip_forward (bool):
            Allows this instance to send and receive
            packets with non-matching destination or source
            IPs. This is required if you plan to use this
            instance to forward routes. For more
            information, see Enabling IP Forwarding.
        confidential_instance_config (google.cloud.compute_v1.types.ConfidentialInstanceConfig):

        cpu_platform (str):
            [Output Only] The CPU platform used by this instance.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deletion_protection (bool):
            Whether the resource should be protected
            against deletion.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        disks (Sequence[google.cloud.compute_v1.types.AttachedDisk]):
            Array of disks associated with this instance.
            Persistent disks must be created before you can
            assign them.
        display_device (google.cloud.compute_v1.types.DisplayDevice):
            Enables display device for the instance.
        fingerprint (str):
            Specifies a fingerprint for this resource,
            which is essentially a hash of the instance's
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update the instance. You must always provide
            an up-to-date fingerprint hash in order to
            update the instance.  To see the latest
            fingerprint, make get() request to the instance.
        guest_accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            A list of the type and count of accelerator
            cards attached to the instance.
        hostname (str):
            Specifies the hostname of the instance. The specified
            hostname must be RFC1035 compliant. If hostname is not
            specified, the default hostname is
            [INSTANCE_NAME].c.[PROJECT_ID].internal when using the
            global DNS, and
            [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using
            zonal DNS.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#instance
            for instances.
        label_fingerprint (str):
            A fingerprint for this request, which is
            essentially a hash of the label's contents and
            used for optimistic locking. The fingerprint is
            initially generated by Compute Engine and
            changes after every request to modify or update
            labels. You must always provide an up-to-date
            fingerprint hash in order to update or change
            labels.  To see the latest fingerprint, make
            get() request to the instance.
        labels (Sequence[google.cloud.compute_v1.types.Instance.LabelsEntry]):
            Labels to apply to this instance. These can
            be later modified by the setLabels method.
        last_start_timestamp (str):
            [Output Only] Last start timestamp in RFC3339 text format.
        last_stop_timestamp (str):
            [Output Only] Last stop timestamp in RFC3339 text format.
        last_suspended_timestamp (str):
            [Output Only] Last suspended timestamp in RFC3339 text
            format.
        machine_type (str):
            Full or partial URL of the machine type
            resource to use for this instance, in the
            format: zones/zone/machineTypes/machine-type.
            This is provided by the client when the instance
            is created. For example, the following is a
            valid partial url to a predefined machine type:
            zones/us-central1-f/machineTypes/n1-standard-1

            To create a custom machine type, provide a URL
            to a machine type in the following format, where
            CPUS is 1 or an even number up to 32 (2, 4, 6,
            ... 24, etc), and MEMORY is the total memory for
            this instance. Memory must be a multiple of 256
            MB and must be supplied in MB (e.g. 5 GB of
            memory is 5120 MB):
            zones/zone/machineTypes/custom-CPUS-MEMORY

            For example: zones/us-
            central1-f/machineTypes/custom-4-5120
            For a full list of restrictions, read the
            Specifications for custom machine types.
        metadata (google.cloud.compute_v1.types.Metadata):
            The metadata key/value pairs assigned to this
            instance. This includes custom metadata and
            predefined keys.
        min_cpu_platform (str):
            Specifies a minimum CPU platform for the VM
            instance. Applicable values are the friendly
            names of CPU platforms, such as minCpuPlatform:
            "Intel Haswell" or minCpuPlatform: "Intel Sandy
            Bridge".
        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The resource name must be
            1-63 characters long, and comply with RFC1035. Specifically,
            the name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        network_interfaces (Sequence[google.cloud.compute_v1.types.NetworkInterface]):
            An array of network configurations for this
            instance. These specify how interfaces are
            configured to interact with other network
            services, such as connecting to the internet.
            Multiple interfaces are supported per instance.
        private_ipv6_google_access (google.cloud.compute_v1.types.Instance.PrivateIpv6GoogleAccess):
            The private IPv6 google access type for the VM. If not
            specified, use INHERIT_FROM_SUBNETWORK as default.
        reservation_affinity (google.cloud.compute_v1.types.ReservationAffinity):
            Specifies the reservations that this instance
            can consume from.
        resource_policies (Sequence[str]):
            Resource policies applied to this instance.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        scheduling (google.cloud.compute_v1.types.Scheduling):
            Sets the scheduling options for this
            instance.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        service_accounts (Sequence[google.cloud.compute_v1.types.ServiceAccount]):
            A list of service accounts, with their
            specified scopes, authorized for this instance.
            Only one service account per VM instance is
            supported.  Service accounts generate access
            tokens that can be accessed through the metadata
            server and used to authenticate applications on
            the instance. See Service Accounts for more
            information.
        shielded_instance_config (google.cloud.compute_v1.types.ShieldedInstanceConfig):

        shielded_instance_integrity_policy (google.cloud.compute_v1.types.ShieldedInstanceIntegrityPolicy):

        start_restricted (bool):
            [Output Only] Whether a VM has been restricted for start
            because Compute Engine has detected suspicious activity.
        status (google.cloud.compute_v1.types.Instance.Status):
            [Output Only] The status of the instance. One of the
            following values: PROVISIONING, STAGING, RUNNING, STOPPING,
            SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more
            information about the status of the instance, see Instance
            life cycle.
        status_message (str):
            [Output Only] An optional, human-readable explanation of the
            status.
        tags (google.cloud.compute_v1.types.Tags):
            Tags to apply to this instance. Tags are used
            to identify valid sources or targets for network
            firewalls and are specified by the client during
            instance creation. The tags can be later
            modified by the setTags method. Each tag within
            the list must comply with RFC1035. Multiple tags
            can be specified via the 'tags.items' field.
        zone (str):
            [Output Only] URL of the zone where the instance resides.
            You must specify this field as part of the HTTP request URL.
            It is not settable as a field in the request body.
    """

    class PrivateIpv6GoogleAccess(proto.Enum):
        r"""The private IPv6 google access type for the VM. If not specified,
        use INHERIT_FROM_SUBNETWORK as default.
        """
        UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0
        ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994
        ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263
        INHERIT_FROM_SUBNETWORK = 530256959

    class Status(proto.Enum):
        r"""[Output Only] The status of the instance. One of the following
        values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING,
        SUSPENDED, REPAIRING, and TERMINATED. For more information about the
        status of the instance, see Instance life cycle.
        """
        UNDEFINED_STATUS = 0
        DEPROVISIONING = 428935662
        PROVISIONING = 290896621
        REPAIRING = 413483285
        RUNNING = 121282975
        STAGING = 431072283
        STOPPED = 444276141
        STOPPING = 350791796
        SUSPENDED = 51223995
        SUSPENDING = 514206246
        TERMINATED = 250018339

    advanced_machine_features = proto.Field(
        proto.MESSAGE,
        number=409646002,
        optional=True,
        message="AdvancedMachineFeatures",
    )
    can_ip_forward = proto.Field(proto.BOOL, number=467731324, optional=True,)
    confidential_instance_config = proto.Field(
        proto.MESSAGE,
        number=490637685,
        optional=True,
        message="ConfidentialInstanceConfig",
    )
    cpu_platform = proto.Field(proto.STRING, number=410285354, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deletion_protection = proto.Field(proto.BOOL, number=458014698, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="AttachedDisk",)
    display_device = proto.Field(
        proto.MESSAGE, number=258933875, optional=True, message="DisplayDevice",
    )
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    guest_accelerators = proto.RepeatedField(
        proto.MESSAGE, number=463595119, message="AcceleratorConfig",
    )
    hostname = proto.Field(proto.STRING, number=237067315, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    last_start_timestamp = proto.Field(proto.STRING, number=443830736, optional=True,)
    last_stop_timestamp = proto.Field(proto.STRING, number=412823010, optional=True,)
    last_suspended_timestamp = proto.Field(
        proto.STRING, number=356275337, optional=True,
    )
    machine_type = proto.Field(proto.STRING, number=227711026, optional=True,)
    metadata = proto.Field(
        proto.MESSAGE, number=86866735, optional=True, message="Metadata",
    )
    min_cpu_platform = proto.Field(proto.STRING, number=242912759, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network_interfaces = proto.RepeatedField(
        proto.MESSAGE, number=52735243, message="NetworkInterface",
    )
    private_ipv6_google_access = proto.Field(
        proto.ENUM, number=48277006, optional=True, enum=PrivateIpv6GoogleAccess,
    )
    reservation_affinity = proto.Field(
        proto.MESSAGE, number=157850683, optional=True, message="ReservationAffinity",
    )
    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    scheduling = proto.Field(
        proto.MESSAGE, number=386688404, optional=True, message="Scheduling",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    service_accounts = proto.RepeatedField(
        proto.MESSAGE, number=277537328, message="ServiceAccount",
    )
    shielded_instance_config = proto.Field(
        proto.MESSAGE, number=12862901, optional=True, message="ShieldedInstanceConfig",
    )
    shielded_instance_integrity_policy = proto.Field(
        proto.MESSAGE,
        number=163696919,
        optional=True,
        message="ShieldedInstanceIntegrityPolicy",
    )
    start_restricted = proto.Field(proto.BOOL, number=123693144, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_message = proto.Field(proto.STRING, number=297428154, optional=True,)
    tags = proto.Field(proto.MESSAGE, number=3552281, optional=True, message="Tags",)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class InstancesScopedList(proto.Message):
    r"""
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.Instance]):
            [Output Only] A list of instances contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of instances when the list is empty.
    """

    instances = proto.RepeatedField(proto.MESSAGE, number=29097598, message="Instance",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceAggregatedList.ItemsEntry]):
            An object that contains a list of instances
            scoped by zone.
        kind (str):
            [Output Only] Type of resource. Always
            compute#instanceAggregatedList for aggregated lists of
            Instance resources.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="InstancesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NamedPort(proto.Message):
    r"""The named port. For example: .
    Attributes:
        name (str):
            The name for this named port. The name must
            be 1-63 characters long, and comply with
            RFC1035.
        port (int):
            The port number, which can be a value between
            1 and 65535.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    port = proto.Field(proto.INT32, number=3446913, optional=True,)


class InstanceGroup(proto.Message):
    r"""Represents an Instance Group resource.

    Instance Groups can be used to configure a target for load
    balancing.

    Instance groups can either be managed or unmanaged.

    To create managed instance groups, use the instanceGroupManager or
    regionInstanceGroupManager resource instead.

    Use zonal unmanaged instance groups if you need to apply load
    balancing to groups of heterogeneous instances or if you need to
    manage the instances yourself. You cannot create regional unmanaged
    instance groups.

    For more information, read Instance groups.

    (== resource_for {$api_version}.instanceGroups ==) (== resource_for
    {$api_version}.regionInstanceGroups ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] The creation timestamp for this instance group
            in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            [Output Only] The fingerprint of the named ports. The system
            uses this fingerprint to detect conflicts when multiple
            users change the named ports concurrently.
        id (int):
            [Output Only] A unique identifier for this instance group,
            generated by the server.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroup for instance groups.
        name (str):
            The name of the instance group. The name must
            be 1-63 characters long, and comply with
            RFC1035.
        named_ports (Sequence[google.cloud.compute_v1.types.NamedPort]):
            Assigns a name to a port number. For example: {name: "http",
            port: 80}

            This allows the system to reference ports by the assigned
            name instead of a port number. Named ports can also contain
            multiple ports. For example: [{name: "http", port:
            80},{name: "http", port: 8080}]

            Named ports apply to all instances in this instance group.
        network (str):
            [Output Only] The URL of the network to which all instances
            in the instance group belong. If your instance has multiple
            network interfaces, then the network and subnetwork fields
            only refer to the network and subnet used by your primary
            interface (nic0).
        region (str):
            [Output Only] The URL of the region where the instance group
            is located (for regional resources).
        self_link (str):
            [Output Only] The URL for this instance group. The server
            generates this URL.
        size (int):
            [Output Only] The total number of instances in the instance
            group.
        subnetwork (str):
            [Output Only] The URL of the subnetwork to which all
            instances in the instance group belong. If your instance has
            multiple network interfaces, then the network and subnetwork
            fields only refer to the network and subnet used by your
            primary interface (nic0).
        zone (str):
            [Output Only] The URL of the zone where the instance group
            is located (for zonal resources).
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    named_ports = proto.RepeatedField(
        proto.MESSAGE, number=427598732, message="NamedPort",
    )
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    size = proto.Field(proto.INT32, number=3530753, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class InstanceGroupsScopedList(proto.Message):
    r"""
    Attributes:
        instance_groups (Sequence[google.cloud.compute_v1.types.InstanceGroup]):
            [Output Only] The list of instance groups that are contained
            in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that replaces the
            list of instance groups when the list is empty.
    """

    instance_groups = proto.RepeatedField(
        proto.MESSAGE, number=366469310, message="InstanceGroup",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroupAggregatedList.ItemsEntry]):
            A list of InstanceGroupsScopedList resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupAggregatedList for aggregated lists of
            instance groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="InstanceGroupsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupList(proto.Message):
    r"""A list of InstanceGroup resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroup]):
            A list of InstanceGroup resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupList for instance group lists.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceGroup",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupManagerAutoHealingPolicy(proto.Message):
    r"""
    Attributes:
        health_check (str):
            The URL for the health check that signals
            autohealing.
        initial_delay_sec (int):
            The number of seconds that the managed instance group waits
            before it applies autohealing policies to new instances or
            recently recreated instances. This initial delay allows
            instances to initialize and run their startup scripts before
            the instance group determines that they are UNHEALTHY. This
            prevents the managed instance group from recreating its
            instances prematurely. This value must be from range [0,
            3600].
    """

    health_check = proto.Field(proto.STRING, number=308876645, optional=True,)
    initial_delay_sec = proto.Field(proto.INT32, number=263207002, optional=True,)


class InstanceGroupManagerActionsSummary(proto.Message):
    r"""
    Attributes:
        abandoning (int):
            [Output Only] The total number of instances in the managed
            instance group that are scheduled to be abandoned.
            Abandoning an instance removes it from the managed instance
            group without deleting it.
        creating (int):
            [Output Only] The number of instances in the managed
            instance group that are scheduled to be created or are
            currently being created. If the group fails to create any of
            these instances, it tries again until it creates the
            instance successfully.

            If you have disabled creation retries, this field will not
            be populated; instead, the creatingWithoutRetries field will
            be populated.
        creating_without_retries (int):
            [Output Only] The number of instances that the managed
            instance group will attempt to create. The group attempts to
            create each instance only once. If the group fails to create
            any of these instances, it decreases the group's targetSize
            value accordingly.
        deleting (int):
            [Output Only] The number of instances in the managed
            instance group that are scheduled to be deleted or are
            currently being deleted.
        none (int):
            [Output Only] The number of instances in the managed
            instance group that are running and have no scheduled
            actions.
        recreating (int):
            [Output Only] The number of instances in the managed
            instance group that are scheduled to be recreated or are
            currently being being recreated. Recreating an instance
            deletes the existing root persistent disk and creates a new
            disk from the image that is defined in the instance
            template.
        refreshing (int):
            [Output Only] The number of instances in the managed
            instance group that are being reconfigured with properties
            that do not require a restart or a recreate action. For
            example, setting or removing target pools for the instance.
        restarting (int):
            [Output Only] The number of instances in the managed
            instance group that are scheduled to be restarted or are
            currently being restarted.
        verifying (int):
            [Output Only] The number of instances in the managed
            instance group that are being verified. See the
            managedInstances[].currentAction property in the
            listManagedInstances method documentation.
    """

    abandoning = proto.Field(proto.INT32, number=440023373, optional=True,)
    creating = proto.Field(proto.INT32, number=209809081, optional=True,)
    creating_without_retries = proto.Field(
        proto.INT32, number=369916745, optional=True,
    )
    deleting = proto.Field(proto.INT32, number=282846120, optional=True,)
    none = proto.Field(proto.INT32, number=3387192, optional=True,)
    recreating = proto.Field(proto.INT32, number=339057132, optional=True,)
    refreshing = proto.Field(proto.INT32, number=215044903, optional=True,)
    restarting = proto.Field(proto.INT32, number=372312947, optional=True,)
    verifying = proto.Field(proto.INT32, number=451612873, optional=True,)


class StatefulPolicy(proto.Message):
    r"""
    Attributes:
        preserved_state (google.cloud.compute_v1.types.StatefulPolicyPreservedState):

    """

    preserved_state = proto.Field(
        proto.MESSAGE,
        number=2634026,
        optional=True,
        message="StatefulPolicyPreservedState",
    )


class InstanceGroupManagerStatus(proto.Message):
    r"""
    Attributes:
        autoscaler (str):
            [Output Only] The URL of the Autoscaler that targets this
            instance group manager.
        is_stable (bool):
            [Output Only] A bit indicating whether the managed instance
            group is in a stable state. A stable state means that: none
            of the instances in the managed instance group is currently
            undergoing any type of change (for example, creation,
            restart, or deletion); no future changes are scheduled for
            instances in the managed instance group; and the managed
            instance group itself is not being modified.
        stateful (google.cloud.compute_v1.types.InstanceGroupManagerStatusStateful):
            [Output Only] Stateful status of the given Instance Group
            Manager.
        version_target (google.cloud.compute_v1.types.InstanceGroupManagerStatusVersionTarget):
            [Output Only] A status of consistency of Instances' versions
            with their target version specified by version field on
            Instance Group Manager.
    """

    autoscaler = proto.Field(proto.STRING, number=517258967, optional=True,)
    is_stable = proto.Field(proto.BOOL, number=108410864, optional=True,)
    stateful = proto.Field(
        proto.MESSAGE,
        number=244462412,
        optional=True,
        message="InstanceGroupManagerStatusStateful",
    )
    version_target = proto.Field(
        proto.MESSAGE,
        number=289386200,
        optional=True,
        message="InstanceGroupManagerStatusVersionTarget",
    )


class InstanceGroupManagerUpdatePolicy(proto.Message):
    r"""
    Attributes:
        instance_redistribution_type (str):
            The  instance redistribution policy for
            regional managed instance groups. Valid values
            are: - PROACTIVE (default): The group attempts
            to maintain an even distribution of VM instances
            across zones in the region. - NONE: For non-
            autoscaled groups, proactive redistribution is
            disabled.
        max_surge (google.cloud.compute_v1.types.FixedOrPercent):
            The maximum number of instances that can be
            created above the specified targetSize during
            the update process. This value can be either a
            fixed number or, if the group has 10 or more
            instances, a percentage. If you set a
            percentage, the number of instances is rounded
            up if necessary. The default value for maxSurge
            is a fixed value equal to the number of zones in
            which the managed instance group operates.  At
            least one of either maxSurge or maxUnavailable
            must be greater than 0. Learn more about
            maxSurge.
        max_unavailable (google.cloud.compute_v1.types.FixedOrPercent):
            The maximum number of instances that can be
            unavailable during the update process. An
            instance is considered available if all of the
            following conditions are satisfied:
            - The instance's status is RUNNING.
            - If there is a health check on the instance
            group, the instance's health check status must
            be HEALTHY at least once. If there is no health
            check on the group, then the instance only needs
            to have a status of RUNNING to be considered
            available.  This value can be either a fixed
            number or, if the group has 10 or more
            instances, a percentage. If you set a
            percentage, the number of instances is rounded
            up if necessary. The default value for
            maxUnavailable is a fixed value equal to the
            number of zones in which the managed instance
            group operates.
            At least one of either maxSurge or
            maxUnavailable must be greater than 0. Learn
            more about maxUnavailable.
        minimal_action (str):
            Minimal action to be taken on an instance.
            You can specify either RESTART to restart
            existing instances or REPLACE to delete and
            create new instances from the target template.
            If you specify a RESTART, the Updater will
            attempt to perform that action only. However, if
            the Updater determines that the minimal action
            you specify is not enough to perform the update,
            it might perform a more disruptive action.
        replacement_method (str):
            What action should be used to replace instances. See
            minimal_action.REPLACE
        type_ (str):
            The type of update process. You can specify
            either PROACTIVE so that the instance group
            manager proactively executes actions in order to
            bring instances to their target versions or
            OPPORTUNISTIC so that no action is proactively
            executed but the update will be performed as
            part of other actions (for example, resizes or
            recreateInstances calls).
    """

    instance_redistribution_type = proto.Field(
        proto.STRING, number=292630424, optional=True,
    )
    max_surge = proto.Field(
        proto.MESSAGE, number=302572691, optional=True, message="FixedOrPercent",
    )
    max_unavailable = proto.Field(
        proto.MESSAGE, number=404940277, optional=True, message="FixedOrPercent",
    )
    minimal_action = proto.Field(proto.STRING, number=270567060, optional=True,)
    replacement_method = proto.Field(proto.STRING, number=505931694, optional=True,)
    type_ = proto.Field(proto.STRING, number=3575610, optional=True,)


class InstanceGroupManagerVersion(proto.Message):
    r"""
    Attributes:
        instance_template (str):
            The URL of the instance template that is specified for this
            managed instance group. The group uses this template to
            create new instances in the managed instance group until the
            ``targetSize`` for this version is reached. The templates
            for existing instances in the group do not change unless you
            run recreateInstances, run applyUpdatesToInstances, or set
            the group's updatePolicy.type to PROACTIVE; in those cases,
            existing instances are updated until the ``targetSize`` for
            this version is reached.
        name (str):
            Name of the version. Unique among all
            versions in the scope of this managed instance
            group.
        target_size (google.cloud.compute_v1.types.FixedOrPercent):
            Specifies the intended number of instances to be created
            from the instanceTemplate. The final number of instances
            created from the template will be equal to:

            -  If expressed as a fixed number, the minimum of either
               targetSize.fixed or instanceGroupManager.targetSize is
               used.
            -  if expressed as a percent, the targetSize would be
               (targetSize.percent/100 \*
               InstanceGroupManager.targetSize) If there is a remainder,
               the number is rounded up. If unset, this version will
               update any remaining instances not updated by another
               version. Read Starting a canary update for more
               information.
    """

    instance_template = proto.Field(proto.STRING, number=309248228, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    target_size = proto.Field(
        proto.MESSAGE, number=62880239, optional=True, message="FixedOrPercent",
    )


class InstanceGroupManager(proto.Message):
    r"""Represents a Managed Instance Group resource.

    An instance group is a collection of VM instances that you can
    manage as a single entity. For more information, read Instance
    groups.

    For zonal Managed Instance Group, use the instanceGroupManagers
    resource.

    For regional Managed Instance Group, use the
    regionInstanceGroupManagers resource. (== resource_for
    {$api_version}.instanceGroupManagers ==) (== resource_for
    {$api_version}.regionInstanceGroupManagers ==)

    Attributes:
        auto_healing_policies (Sequence[google.cloud.compute_v1.types.InstanceGroupManagerAutoHealingPolicy]):
            The autohealing policy for this managed
            instance group. You can specify only one value.
        base_instance_name (str):
            The base instance name to use for instances
            in this group. The value must be 1-58 characters
            long. Instances are named by appending a hyphen
            and a random four-character string to the base
            instance name. The base instance name must
            comply with RFC1035.
        creation_timestamp (str):
            [Output Only] The creation timestamp for this managed
            instance group in RFC3339 text format.
        current_actions (google.cloud.compute_v1.types.InstanceGroupManagerActionsSummary):
            [Output Only] The list of instance actions and the number of
            instances in this managed instance group that are scheduled
            for each of those actions.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        distribution_policy (google.cloud.compute_v1.types.DistributionPolicy):
            Policy specifying the intended distribution
            of managed instances across zones in a regional
            managed instance group.
        fingerprint (str):
            Fingerprint of this resource. This field may
            be used in optimistic locking. It will be
            ignored when inserting an InstanceGroupManager.
            An up-to-date fingerprint must be provided in
            order to update the InstanceGroupManager,
            otherwise the request will fail with error 412
            conditionNotMet.  To see the latest fingerprint,
            make a get() request to retrieve an
            InstanceGroupManager.
        id (int):
            [Output Only] A unique identifier for this resource type.
            The server generates this identifier.
        instance_group (str):
            [Output Only] The URL of the Instance Group resource.
        instance_template (str):
            The URL of the instance template that is
            specified for this managed instance group. The
            group uses this template to create all new
            instances in the managed instance group. The
            templates for existing instances in the group do
            not change unless you run recreateInstances, run
            applyUpdatesToInstances, or set the group's
            updatePolicy.type to PROACTIVE.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupManager for managed instance groups.
        name (str):
            The name of the managed instance group. The
            name must be 1-63 characters long, and comply
            with RFC1035.
        named_ports (Sequence[google.cloud.compute_v1.types.NamedPort]):
            Named ports configured for the Instance
            Groups complementary to this Instance Group
            Manager.
        region (str):
            [Output Only] The URL of the region where the managed
            instance group resides (for regional resources).
        self_link (str):
            [Output Only] The URL for this managed instance group. The
            server defines this URL.
        stateful_policy (google.cloud.compute_v1.types.StatefulPolicy):
            Stateful configuration for this Instanced
            Group Manager
        status (google.cloud.compute_v1.types.InstanceGroupManagerStatus):
            [Output Only] The status of this managed instance group.
        target_pools (Sequence[str]):
            The URLs for all TargetPool resources to
            which instances in the instanceGroup field are
            added. The target pools automatically apply to
            all of the instances in the managed instance
            group.
        target_size (int):
            The target number of running instances for
            this managed instance group. You can reduce this
            number by using the instanceGroupManager
            deleteInstances or abandonInstances methods.
            Resizing the group also changes this number.
        update_policy (google.cloud.compute_v1.types.InstanceGroupManagerUpdatePolicy):
            The update policy for this managed instance
            group.
        versions (Sequence[google.cloud.compute_v1.types.InstanceGroupManagerVersion]):
            Specifies the instance templates used by this
            managed instance group to create instances.
            Each version is defined by an instanceTemplate
            and a name. Every version can appear at most
            once per instance group. This field overrides
            the top-level instanceTemplate field. Read more
            about the relationships between these fields.
            Exactly one version must leave the targetSize
            field unset. That version will be applied to all
            remaining instances. For more information, read
            about canary updates.
        zone (str):
            [Output Only] The URL of a zone where the managed instance
            group is located (for zonal resources).
    """

    auto_healing_policies = proto.RepeatedField(
        proto.MESSAGE,
        number=456799109,
        message="InstanceGroupManagerAutoHealingPolicy",
    )
    base_instance_name = proto.Field(proto.STRING, number=389106439, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    current_actions = proto.Field(
        proto.MESSAGE,
        number=164045879,
        optional=True,
        message="InstanceGroupManagerActionsSummary",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    distribution_policy = proto.Field(
        proto.MESSAGE, number=534558541, optional=True, message="DistributionPolicy",
    )
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    instance_group = proto.Field(proto.STRING, number=81095253, optional=True,)
    instance_template = proto.Field(proto.STRING, number=309248228, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    named_ports = proto.RepeatedField(
        proto.MESSAGE, number=427598732, message="NamedPort",
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    stateful_policy = proto.Field(
        proto.MESSAGE, number=47538565, optional=True, message="StatefulPolicy",
    )
    status = proto.Field(
        proto.MESSAGE,
        number=181260274,
        optional=True,
        message="InstanceGroupManagerStatus",
    )
    target_pools = proto.RepeatedField(proto.STRING, number=336072617,)
    target_size = proto.Field(proto.INT32, number=62880239, optional=True,)
    update_policy = proto.Field(
        proto.MESSAGE,
        number=175809896,
        optional=True,
        message="InstanceGroupManagerUpdatePolicy",
    )
    versions = proto.RepeatedField(
        proto.MESSAGE, number=162430619, message="InstanceGroupManagerVersion",
    )
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class InstanceGroupManagersScopedList(proto.Message):
    r"""
    Attributes:
        instance_group_managers (Sequence[google.cloud.compute_v1.types.InstanceGroupManager]):
            [Output Only] The list of managed instance groups that are
            contained in the specified project and zone.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] The warning that replaces the list of managed
            instance groups when the list is empty.
    """

    instance_group_managers = proto.RepeatedField(
        proto.MESSAGE, number=214072592, message="InstanceGroupManager",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupManagerAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroupManagerAggregatedList.ItemsEntry]):
            A list of InstanceGroupManagersScopedList
            resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupManagerAggregatedList for an aggregated
            list of managed instance groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="InstanceGroupManagersScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupManagerList(proto.Message):
    r"""[Output Only] A list of managed instance groups.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroupManager]):
            A list of InstanceGroupManager resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupManagerList for a list of managed
            instance groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceGroupManager",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupManagerStatusStateful(proto.Message):
    r"""
    Attributes:
        has_stateful_config (bool):
            [Output Only] A bit indicating whether the managed instance
            group has stateful configuration, that is, if you have
            configured any items in a stateful policy or in per-instance
            configs. The group might report that it has no stateful
            config even when there is still some preserved state on a
            managed instance, for example, if you have deleted all PICs
            but not yet applied those deletions.
        per_instance_configs (google.cloud.compute_v1.types.InstanceGroupManagerStatusStatefulPerInstanceConfigs):
            [Output Only] Status of per-instance configs on the
            instance.
    """

    has_stateful_config = proto.Field(proto.BOOL, number=110474224, optional=True,)
    per_instance_configs = proto.Field(
        proto.MESSAGE,
        number=526265001,
        optional=True,
        message="InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    )


class InstanceGroupManagerStatusVersionTarget(proto.Message):
    r"""
    Attributes:
        is_reached (bool):
            [Output Only] A bit indicating whether version target has
            been reached in this managed instance group, i.e. all
            instances are in their target version. Instances' target
            version are specified by version field on Instance Group
            Manager.
    """

    is_reached = proto.Field(proto.BOOL, number=433209149, optional=True,)


class InstanceGroupManagerStatusStatefulPerInstanceConfigs(proto.Message):
    r"""
    Attributes:
        all_effective (bool):
            A bit indicating if all of the group's per-
            nstance configs (listed in the output of a
            listPerInstanceConfigs API call) have status
            EFFECTIVE or there are no per-instance-configs.
    """

    all_effective = proto.Field(proto.BOOL, number=516540553, optional=True,)


class InstanceGroupManagersAbandonInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to abandon. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class InstanceGroupManagersApplyUpdatesRequest(proto.Message):
    r"""InstanceGroupManagers.applyUpdatesToInstances
    Attributes:
        all_instances (bool):
            Flag to update all instances instead of
            specified list of ?instances?. If the flag is
            set to true then the instances may not be
            specified in the request.
        instances (Sequence[str]):
            The list of URLs of one or more instances for which you want
            to apply updates. Each URL can be a full URL or a partial
            URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        minimal_action (str):
            The minimal action that you want to perform
            on each instance during the update: - REPLACE:
            At minimum, delete the instance and create it
            again. - RESTART: Stop the instance and start it
            again. - REFRESH: Do not stop the instance.
            - NONE: Do not disrupt the instance at all.  By
            default, the minimum action is NONE. If your
            update requires a more disruptive action than
            you set with this flag, the necessary action is
            performed to execute the update.
        most_disruptive_allowed_action (str):
            The most disruptive action that you want to
            perform on each instance during the update: -
            REPLACE: Delete the instance and create it
            again. - RESTART: Stop the instance and start it
            again. - REFRESH: Do not stop the instance.
            - NONE: Do not disrupt the instance at all.  By
            default, the most disruptive allowed action is
            REPLACE. If your update requires a more
            disruptive action than you set with this flag,
            the update request will fail.
    """

    all_instances = proto.Field(proto.BOOL, number=403676512, optional=True,)
    instances = proto.RepeatedField(proto.STRING, number=29097598,)
    minimal_action = proto.Field(proto.STRING, number=270567060, optional=True,)
    most_disruptive_allowed_action = proto.Field(
        proto.STRING, number=66103053, optional=True,
    )


class PerInstanceConfig(proto.Message):
    r"""
    Attributes:
        fingerprint (str):
            Fingerprint of this per-instance config. This
            field can be used in optimistic locking. It is
            ignored when inserting a per-instance config. An
            up-to-date fingerprint must be provided in order
            to update an existing per-instance config or the
            field needs to be unset.
        name (str):
            The name of a per-instance config and its
            corresponding instance. Serves as a merge key
            during UpdatePerInstanceConfigs operations, that
            is, if a per-instance config with the same name
            exists then it will be updated, otherwise a new
            one will be created for the VM instance with the
            same name. An attempt to create a per-instance
            config for a VM instance that either doesn't
            exist or is not part of the group will result in
            an error.
        preserved_state (google.cloud.compute_v1.types.PreservedState):
            The intended preserved state for the given
            instance. Does not contain preserved state
            generated from a stateful policy.
        status (google.cloud.compute_v1.types.PerInstanceConfig.Status):
            The status of applying this per-instance
            config on the corresponding managed instance.
    """

    class Status(proto.Enum):
        r"""The status of applying this per-instance config on the
        corresponding managed instance.
        """
        UNDEFINED_STATUS = 0
        APPLYING = 352003508
        DELETING = 528602024
        EFFECTIVE = 244201863
        NONE = 2402104
        UNAPPLIED = 483935140
        UNAPPLIED_DELETION = 313956873

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    preserved_state = proto.Field(
        proto.MESSAGE, number=2634026, optional=True, message="PreservedState",
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class InstanceGroupManagersCreateInstancesRequest(proto.Message):
    r"""InstanceGroupManagers.createInstances
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            [Required] List of specifications of per-instance configs.
    """

    instances = proto.RepeatedField(
        proto.MESSAGE, number=29097598, message="PerInstanceConfig",
    )


class InstanceGroupManagersDeleteInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to delete. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class InstanceGroupManagersDeletePerInstanceConfigsReq(proto.Message):
    r"""InstanceGroupManagers.deletePerInstanceConfigs
    Attributes:
        names (Sequence[str]):
            The list of instance names for which we want
            to delete per-instance configs on this managed
            instance group.
    """

    names = proto.RepeatedField(proto.STRING, number=104585032,)


class InstanceManagedByIgmError(proto.Message):
    r"""
    Attributes:
        error (google.cloud.compute_v1.types.InstanceManagedByIgmErrorManagedInstanceError):
            [Output Only] Contents of the error.
        instance_action_details (google.cloud.compute_v1.types.InstanceManagedByIgmErrorInstanceActionDetails):
            [Output Only] Details of the instance action that triggered
            this error. May be null, if the error was not caused by an
            action on an instance. This field is optional.
        timestamp (str):
            [Output Only] The time that this error occurred. This value
            is in RFC3339 text format.
    """

    error = proto.Field(
        proto.MESSAGE,
        number=96784904,
        optional=True,
        message="InstanceManagedByIgmErrorManagedInstanceError",
    )
    instance_action_details = proto.Field(
        proto.MESSAGE,
        number=292224547,
        optional=True,
        message="InstanceManagedByIgmErrorInstanceActionDetails",
    )
    timestamp = proto.Field(proto.STRING, number=55126294, optional=True,)


class InstanceGroupManagersListErrorsResponse(proto.Message):
    r"""
    Attributes:
        items (Sequence[google.cloud.compute_v1.types.InstanceManagedByIgmError]):
            [Output Only] The list of errors of the managed instance
            group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
    """

    @property
    def raw_page(self):
        return self

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceManagedByIgmError",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)


class ManagedInstance(proto.Message):
    r"""A Managed Instance resource.
    Attributes:
        current_action (google.cloud.compute_v1.types.ManagedInstance.CurrentAction):
            [Output Only] The current action that the managed instance
            group has scheduled for the instance. Possible values:

            -  NONE The instance is running, and the managed instance
               group does not have any scheduled actions for this
               instance.
            -  CREATING The managed instance group is creating this
               instance. If the group fails to create this instance, it
               will try again until it is successful.
            -  CREATING_WITHOUT_RETRIES The managed instance group is
               attempting to create this instance only once. If the
               group fails to create this instance, it does not try
               again and the group's targetSize value is decreased
               instead.
            -  RECREATING The managed instance group is recreating this
               instance.
            -  DELETING The managed instance group is permanently
               deleting this instance.
            -  ABANDONING The managed instance group is abandoning this
               instance. The instance will be removed from the instance
               group and from any target pools that are associated with
               this group.
            -  RESTARTING The managed instance group is restarting the
               instance.
            -  REFRESHING The managed instance group is applying
               configuration changes to the instance without stopping
               it. For example, the group can update the target pool
               list for an instance without stopping that instance.
            -  VERIFYING The managed instance group has created the
               instance and it is in the process of being verified.
        id (int):
            [Output only] The unique identifier for this resource. This
            field is empty when instance does not exist.
        instance (str):
            [Output Only] The URL of the instance. The URL can exist
            even if the instance has not yet been created.
        instance_health (Sequence[google.cloud.compute_v1.types.ManagedInstanceInstanceHealth]):
            [Output Only] Health state of the instance per health-check.
        instance_status (google.cloud.compute_v1.types.ManagedInstance.InstanceStatus):
            [Output Only] The status of the instance. This field is
            empty when the instance does not exist.
        last_attempt (google.cloud.compute_v1.types.ManagedInstanceLastAttempt):
            [Output Only] Information about the last attempt to create
            or delete the instance.
        preserved_state_from_config (google.cloud.compute_v1.types.PreservedState):
            [Output Only] Preserved state applied from per-instance
            config for this instance.
        preserved_state_from_policy (google.cloud.compute_v1.types.PreservedState):
            [Output Only] Preserved state generated based on stateful
            policy for this instance.
        version (google.cloud.compute_v1.types.ManagedInstanceVersion):
            [Output Only] Intended version of this instance.
    """

    class CurrentAction(proto.Enum):
        r"""[Output Only] The current action that the managed instance group has
        scheduled for the instance. Possible values:

        -  NONE The instance is running, and the managed instance group does
           not have any scheduled actions for this instance.
        -  CREATING The managed instance group is creating this instance. If
           the group fails to create this instance, it will try again until
           it is successful.
        -  CREATING_WITHOUT_RETRIES The managed instance group is attempting
           to create this instance only once. If the group fails to create
           this instance, it does not try again and the group's targetSize
           value is decreased instead.
        -  RECREATING The managed instance group is recreating this
           instance.
        -  DELETING The managed instance group is permanently deleting this
           instance.
        -  ABANDONING The managed instance group is abandoning this
           instance. The instance will be removed from the instance group
           and from any target pools that are associated with this group.
        -  RESTARTING The managed instance group is restarting the instance.
        -  REFRESHING The managed instance group is applying configuration
           changes to the instance without stopping it. For example, the
           group can update the target pool list for an instance without
           stopping that instance.
        -  VERIFYING The managed instance group has created the instance and
           it is in the process of being verified.
        """
        UNDEFINED_CURRENT_ACTION = 0
        ABANDONING = 388244813
        CREATING = 455564985
        CREATING_WITHOUT_RETRIES = 428843785
        DELETING = 528602024
        NONE = 2402104
        RECREATING = 287278572
        REFRESHING = 163266343
        RESTARTING = 320534387
        VERIFYING = 16982185

    class InstanceStatus(proto.Enum):
        r"""[Output Only] The status of the instance. This field is empty when
        the instance does not exist.
        """
        UNDEFINED_INSTANCE_STATUS = 0
        DEPROVISIONING = 428935662
        PROVISIONING = 290896621
        REPAIRING = 413483285
        RUNNING = 121282975
        STAGING = 431072283
        STOPPED = 444276141
        STOPPING = 350791796
        SUSPENDED = 51223995
        SUSPENDING = 514206246
        TERMINATED = 250018339

    current_action = proto.Field(
        proto.ENUM, number=178475964, optional=True, enum=CurrentAction,
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    instance_health = proto.RepeatedField(
        proto.MESSAGE, number=382667078, message="ManagedInstanceInstanceHealth",
    )
    instance_status = proto.Field(
        proto.ENUM, number=174577372, optional=True, enum=InstanceStatus,
    )
    last_attempt = proto.Field(
        proto.MESSAGE,
        number=434771492,
        optional=True,
        message="ManagedInstanceLastAttempt",
    )
    preserved_state_from_config = proto.Field(
        proto.MESSAGE, number=98661858, optional=True, message="PreservedState",
    )
    preserved_state_from_policy = proto.Field(
        proto.MESSAGE, number=470783954, optional=True, message="PreservedState",
    )
    version = proto.Field(
        proto.MESSAGE,
        number=351608024,
        optional=True,
        message="ManagedInstanceVersion",
    )


class InstanceGroupManagersListManagedInstancesResponse(proto.Message):
    r"""
    Attributes:
        managed_instances (Sequence[google.cloud.compute_v1.types.ManagedInstance]):
            [Output Only] The list of instances in the managed instance
            group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
    """

    @property
    def raw_page(self):
        return self

    managed_instances = proto.RepeatedField(
        proto.MESSAGE, number=336219614, message="ManagedInstance",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)


class InstanceGroupManagersListPerInstanceConfigsResp(proto.Message):
    r"""
    Attributes:
        items (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            [Output Only] The list of PerInstanceConfig.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="PerInstanceConfig",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupManagersPatchPerInstanceConfigsReq(proto.Message):
    r"""InstanceGroupManagers.patchPerInstanceConfigs
    Attributes:
        per_instance_configs (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            The list of per-instance configs to insert or
            patch on this managed instance group.
    """

    per_instance_configs = proto.RepeatedField(
        proto.MESSAGE, number=526265001, message="PerInstanceConfig",
    )


class InstanceGroupManagersRecreateInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to recreate. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class InstanceGroupManagersSetInstanceTemplateRequest(proto.Message):
    r"""
    Attributes:
        instance_template (str):
            The URL of the instance template that is
            specified for this managed instance group. The
            group uses this template to create all new
            instances in the managed instance group. The
            templates for existing instances in the group do
            not change unless you run recreateInstances, run
            applyUpdatesToInstances, or set the group's
            updatePolicy.type to PROACTIVE.
    """

    instance_template = proto.Field(proto.STRING, number=309248228, optional=True,)


class InstanceGroupManagersSetTargetPoolsRequest(proto.Message):
    r"""
    Attributes:
        fingerprint (str):
            The fingerprint of the target pools
            information. Use this optional property to
            prevent conflicts when multiple users change the
            target pools settings concurrently. Obtain the
            fingerprint with the instanceGroupManagers.get
            method. Then, include the fingerprint in your
            request to ensure that you do not overwrite
            changes that were applied from another
            concurrent request.
        target_pools (Sequence[str]):
            The list of target pool URLs that instances
            in this managed instance group belong to. The
            managed instance group applies these target
            pools to all of the instances in the group.
            Existing instances and new instances in the
            group all receive these target pool settings.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    target_pools = proto.RepeatedField(proto.STRING, number=336072617,)


class InstanceGroupManagersUpdatePerInstanceConfigsReq(proto.Message):
    r"""InstanceGroupManagers.updatePerInstanceConfigs
    Attributes:
        per_instance_configs (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            The list of per-instance configs to insert or
            patch on this managed instance group.
    """

    per_instance_configs = proto.RepeatedField(
        proto.MESSAGE, number=526265001, message="PerInstanceConfig",
    )


class InstanceReference(proto.Message):
    r"""
    Attributes:
        instance (str):
            The URL for a specific instance.
    """

    instance = proto.Field(proto.STRING, number=18257045, optional=True,)


class InstanceGroupsAddInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.InstanceReference]):
            The list of instances to add to the instance
            group.
    """

    instances = proto.RepeatedField(
        proto.MESSAGE, number=29097598, message="InstanceReference",
    )


class InstanceWithNamedPorts(proto.Message):
    r"""
    Attributes:
        instance (str):
            [Output Only] The URL of the instance.
        named_ports (Sequence[google.cloud.compute_v1.types.NamedPort]):
            [Output Only] The named ports that belong to this instance
            group.
        status (google.cloud.compute_v1.types.InstanceWithNamedPorts.Status):
            [Output Only] The status of the instance.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the instance."""
        UNDEFINED_STATUS = 0
        DEPROVISIONING = 428935662
        PROVISIONING = 290896621
        REPAIRING = 413483285
        RUNNING = 121282975
        STAGING = 431072283
        STOPPED = 444276141
        STOPPING = 350791796
        SUSPENDED = 51223995
        SUSPENDING = 514206246
        TERMINATED = 250018339

    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    named_ports = proto.RepeatedField(
        proto.MESSAGE, number=427598732, message="NamedPort",
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class InstanceGroupsListInstances(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceWithNamedPorts]):
            A list of InstanceWithNamedPorts resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupsListInstances for the list of
            instances in the specified instance group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceWithNamedPorts",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceGroupsListInstancesRequest(proto.Message):
    r"""
    Attributes:
        instance_state (google.cloud.compute_v1.types.InstanceGroupsListInstancesRequest.InstanceState):
            A filter for the state of the instances in
            the instance group. Valid options are ALL or
            RUNNING. If you do not specify this parameter
            the list includes all instances regardless of
            their state.
    """

    class InstanceState(proto.Enum):
        r"""A filter for the state of the instances in the instance
        group. Valid options are ALL or RUNNING. If you do not specify
        this parameter the list includes all instances regardless of
        their state.
        """
        UNDEFINED_INSTANCE_STATE = 0
        ALL = 64897
        RUNNING = 121282975

    instance_state = proto.Field(
        proto.ENUM, number=92223591, optional=True, enum=InstanceState,
    )


class InstanceGroupsRemoveInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.InstanceReference]):
            The list of instances to remove from the
            instance group.
    """

    instances = proto.RepeatedField(
        proto.MESSAGE, number=29097598, message="InstanceReference",
    )


class InstanceGroupsSetNamedPortsRequest(proto.Message):
    r"""
    Attributes:
        fingerprint (str):
            The fingerprint of the named ports
            information for this instance group. Use this
            optional property to prevent conflicts when
            multiple users change the named ports settings
            concurrently. Obtain the fingerprint with the
            instanceGroups.get method. Then, include the
            fingerprint in your request to ensure that you
            do not overwrite changes that were applied from
            another concurrent request. A request with an
            incorrect fingerprint will fail with error 412
            conditionNotMet.
        named_ports (Sequence[google.cloud.compute_v1.types.NamedPort]):
            The list of named ports to set for this
            instance group.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    named_ports = proto.RepeatedField(
        proto.MESSAGE, number=427598732, message="NamedPort",
    )


class InstanceList(proto.Message):
    r"""Contains a list of instances.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Instance]):
            A list of Instance resources.
        kind (str):
            [Output Only] Type of resource. Always compute#instanceList
            for lists of Instance resources.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Instance",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Reference(proto.Message):
    r"""Represents a reference to a resource.
    Attributes:
        kind (str):
            [Output Only] Type of the resource. Always compute#reference
            for references.
        reference_type (str):
            A description of the reference type with no implied
            semantics. Possible values include:

            -  MEMBER_OF
        referrer (str):
            URL of the resource which refers to the
            target.
        target (str):
            URL of the resource to which this reference
            points.
    """

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    reference_type = proto.Field(proto.STRING, number=247521198, optional=True,)
    referrer = proto.Field(proto.STRING, number=351173663, optional=True,)
    target = proto.Field(proto.STRING, number=192835985, optional=True,)


class InstanceListReferrers(proto.Message):
    r"""Contains a list of instance referrers.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Reference]):
            A list of Reference resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#instanceListReferrers for lists of Instance
            referrers.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Reference",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstanceManagedByIgmErrorManagedInstanceError(proto.Message):
    r"""
    Attributes:
        code (str):
            [Output Only] Error code.
        message (str):
            [Output Only] Error message.
    """

    code = proto.Field(proto.STRING, number=3059181, optional=True,)
    message = proto.Field(proto.STRING, number=418054151, optional=True,)


class InstanceManagedByIgmErrorInstanceActionDetails(proto.Message):
    r"""
    Attributes:
        action (google.cloud.compute_v1.types.InstanceManagedByIgmErrorInstanceActionDetails.Action):
            [Output Only] Action that managed instance group was
            executing on the instance when the error occurred. Possible
            values:
        instance (str):
            [Output Only] The URL of the instance. The URL can be set
            even if the instance has not yet been created.
        version (google.cloud.compute_v1.types.ManagedInstanceVersion):
            [Output Only] Version this instance was created from, or was
            being created from, but the creation failed. Corresponds to
            one of the versions that were set on the Instance Group
            Manager resource at the time this instance was being
            created.
    """

    class Action(proto.Enum):
        r"""[Output Only] Action that managed instance group was executing on
        the instance when the error occurred. Possible values:
        """
        UNDEFINED_ACTION = 0
        ABANDONING = 388244813
        CREATING = 455564985
        CREATING_WITHOUT_RETRIES = 428843785
        DELETING = 528602024
        NONE = 2402104
        RECREATING = 287278572
        REFRESHING = 163266343
        RESTARTING = 320534387
        VERIFYING = 16982185

    action = proto.Field(proto.ENUM, number=187661878, optional=True, enum=Action,)
    instance = proto.Field(proto.STRING, number=18257045, optional=True,)
    version = proto.Field(
        proto.MESSAGE,
        number=351608024,
        optional=True,
        message="ManagedInstanceVersion",
    )


class ManagedInstanceVersion(proto.Message):
    r"""
    Attributes:
        instance_template (str):
            [Output Only] The intended template of the instance. This
            field is empty when current_action is one of { DELETING,
            ABANDONING }.
        name (str):
            [Output Only] Name of the version.
    """

    instance_template = proto.Field(proto.STRING, number=309248228, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class InstanceMoveRequest(proto.Message):
    r"""
    Attributes:
        destination_zone (str):
            The URL of the destination zone to move the
            instance. This can be a full or partial URL. For
            example, the following are all valid URLs to a
            zone: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            - projects/project/zones/zone
            - zones/zone
        target_instance (str):
            The URL of the target instance to move. This
            can be a full or partial URL. For example, the
            following are all valid URLs to an instance: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
            - projects/project/zones/zone/instances/instance
            - zones/zone/instances/instance
    """

    destination_zone = proto.Field(proto.STRING, number=131854653, optional=True,)
    target_instance = proto.Field(proto.STRING, number=289769347, optional=True,)


class SourceInstanceParams(proto.Message):
    r"""A specification of the parameters to use when creating the
    instance template from a source instance.

    Attributes:
        disk_configs (Sequence[google.cloud.compute_v1.types.DiskInstantiationConfig]):
            Attached disks configuration. If not
            provided, defaults are applied: For boot disk
            and any other R/W disks, new custom images will
            be created from each disk. For read-only disks,
            they will be attached in read-only mode. Local
            SSD disks will be created as blank volumes.
    """

    disk_configs = proto.RepeatedField(
        proto.MESSAGE, number=235580623, message="DiskInstantiationConfig",
    )


class InstanceTemplate(proto.Message):
    r"""Represents an Instance Template resource.

    You can use instance templates to create VM instances and managed
    instance groups. For more information, read Instance Templates. (==
    resource_for {$api_version}.instanceTemplates ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] The creation timestamp for this instance
            template in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        id (int):
            [Output Only] A unique identifier for this instance
            template. The server defines this identifier.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceTemplate for instance templates.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        properties (google.cloud.compute_v1.types.InstanceProperties):
            The instance properties for this instance
            template.
        self_link (str):
            [Output Only] The URL for this instance template. The server
            defines this URL.
        source_instance (str):
            The source instance used to create the
            template. You can provide this as a partial or
            full URL to the resource. For example, the
            following are valid values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance
            - projects/project/zones/zone/instances/instance
        source_instance_params (google.cloud.compute_v1.types.SourceInstanceParams):
            The source instance params to use to create
            this instance template.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    properties = proto.Field(
        proto.MESSAGE, number=147688755, optional=True, message="InstanceProperties",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    source_instance = proto.Field(proto.STRING, number=396315705, optional=True,)
    source_instance_params = proto.Field(
        proto.MESSAGE, number=135342156, optional=True, message="SourceInstanceParams",
    )


class InstanceTemplateList(proto.Message):
    r"""A list of instance templates.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceTemplate]):
            A list of InstanceTemplate resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceTemplatesListResponse for instance template
            lists.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceTemplate",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InstancesAddResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be added to this
            instance.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy(proto.Message):
    r"""
    Attributes:
        display_name (str):
            [Output Only] Deprecated, please use short name instead. The
            display name of the firewall policy.
        name (str):
            [Output Only] The name of the firewall policy.
        rules (Sequence[google.cloud.compute_v1.types.FirewallPolicyRule]):
            The rules that apply to the network.
        short_name (str):
            [Output Only] The short name of the firewall policy.
        type_ (google.cloud.compute_v1.types.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy.Type):
            [Output Only] The type of the firewall policy.
    """

    class Type(proto.Enum):
        r"""[Output Only] The type of the firewall policy."""
        UNDEFINED_TYPE = 0
        HIERARCHY = 69902869
        UNSPECIFIED = 526786327

    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    rules = proto.RepeatedField(
        proto.MESSAGE, number=108873975, message="FirewallPolicyRule",
    )
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class InstancesGetEffectiveFirewallsResponse(proto.Message):
    r"""
    Attributes:
        firewall_policys (Sequence[google.cloud.compute_v1.types.InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy]):
            Effective firewalls from firewall policies.
        firewalls (Sequence[google.cloud.compute_v1.types.Firewall]):
            Effective firewalls on the instance.
    """

    firewall_policys = proto.RepeatedField(
        proto.MESSAGE,
        number=410985794,
        message="InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    )
    firewalls = proto.RepeatedField(
        proto.MESSAGE, number=272245619, message="Firewall",
    )


class InstancesRemoveResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be removed from this
            instance.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class InstancesSetLabelsRequest(proto.Message):
    r"""
    Attributes:
        label_fingerprint (str):
            Fingerprint of the previous set of labels for
            this resource, used to prevent conflicts.
            Provide the latest fingerprint value when making
            a request to add or change labels.
        labels (Sequence[google.cloud.compute_v1.types.InstancesSetLabelsRequest.LabelsEntry]):

    """

    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)


class InstancesSetMachineResourcesRequest(proto.Message):
    r"""
    Attributes:
        guest_accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            A list of the type and count of accelerator
            cards attached to the instance.
    """

    guest_accelerators = proto.RepeatedField(
        proto.MESSAGE, number=463595119, message="AcceleratorConfig",
    )


class InstancesSetMachineTypeRequest(proto.Message):
    r"""
    Attributes:
        machine_type (str):
            Full or partial URL of the machine type
            resource. See Machine Types for a full list of
            machine types. For example: zones/us-
            central1-f/machineTypes/n1-standard-1
    """

    machine_type = proto.Field(proto.STRING, number=227711026, optional=True,)


class InstancesSetMinCpuPlatformRequest(proto.Message):
    r"""
    Attributes:
        min_cpu_platform (str):
            Minimum cpu/platform this instance should be
            started at.
    """

    min_cpu_platform = proto.Field(proto.STRING, number=242912759, optional=True,)


class InstancesSetServiceAccountRequest(proto.Message):
    r"""
    Attributes:
        email (str):
            Email address of the service account.
        scopes (Sequence[str]):
            The list of scopes to be made available for
            this service account.
    """

    email = proto.Field(proto.STRING, number=96619420, optional=True,)
    scopes = proto.RepeatedField(proto.STRING, number=165973151,)


class InstancesStartWithEncryptionKeyRequest(proto.Message):
    r"""
    Attributes:
        disks (Sequence[google.cloud.compute_v1.types.CustomerEncryptionKeyProtectedDisk]):
            Array of disks associated with this instance
            that are protected with a customer-supplied
            encryption key.  In order to start the instance,
            the disk url and its corresponding key must be
            provided.
            If the disk is not protected with a customer-
            supplied encryption key it should not be
            specified.
    """

    disks = proto.RepeatedField(
        proto.MESSAGE, number=95594102, message="CustomerEncryptionKeyProtectedDisk",
    )


class InterconnectCircuitInfo(proto.Message):
    r"""Describes a single physical circuit between the Customer and
    Google. CircuitInfo objects are created by Google, so all fields
    are output only.

    Attributes:
        customer_demarc_id (str):
            Customer-side demarc ID for this circuit.
        google_circuit_id (str):
            Google-assigned unique ID for this circuit.
            Assigned at circuit turn-up.
        google_demarc_id (str):
            Google-side demarc ID for this circuit.
            Assigned at circuit turn-up and provided by
            Google to the customer in the LOA.
    """

    customer_demarc_id = proto.Field(proto.STRING, number=28771859, optional=True,)
    google_circuit_id = proto.Field(proto.STRING, number=262014711, optional=True,)
    google_demarc_id = proto.Field(proto.STRING, number=448196270, optional=True,)


class InterconnectOutageNotification(proto.Message):
    r"""Description of a planned outage on this Interconnect.
    Attributes:
        affected_circuits (Sequence[str]):
            If issue_type is IT_PARTIAL_OUTAGE, a list of the
            Google-side circuit IDs that will be affected.
        description (str):
            A description about the purpose of the
            outage.
        end_time (int):
            Scheduled end time for the outage
            (milliseconds since Unix epoch).
        issue_type (google.cloud.compute_v1.types.InterconnectOutageNotification.IssueType):
            Form this outage is expected to take, which can take one of
            the following values:

            -  OUTAGE: The Interconnect may be completely out of service
               for some or all of the specified window.
            -  PARTIAL_OUTAGE: Some circuits comprising the Interconnect
               as a whole should remain up, but with reduced bandwidth.
               Note that the versions of this enum prefixed with "IT_"
               have been deprecated in favor of the unprefixed values.
        name (str):
            Unique identifier for this outage
            notification.
        source (google.cloud.compute_v1.types.InterconnectOutageNotification.Source):
            The party that generated this notification, which can take
            the following value:

            -  GOOGLE: this notification as generated by Google. Note
               that the value of NSRC_GOOGLE has been deprecated in
               favor of GOOGLE.
        start_time (int):
            Scheduled start time for the outage
            (milliseconds since Unix epoch).
        state (google.cloud.compute_v1.types.InterconnectOutageNotification.State):
            State of this notification, which can take one of the
            following values:

            -  ACTIVE: This outage notification is active. The event
               could be in the past, present, or future. See start_time
               and end_time for scheduling.
            -  CANCELLED: The outage associated with this notification
               was cancelled before the outage was due to start. Note
               that the versions of this enum prefixed with "NS_" have
               been deprecated in favor of the unprefixed values.
    """

    class IssueType(proto.Enum):
        r"""Form this outage is expected to take, which can take one of the
        following values:

        -  OUTAGE: The Interconnect may be completely out of service for
           some or all of the specified window.
        -  PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a
           whole should remain up, but with reduced bandwidth. Note that the
           versions of this enum prefixed with "IT_" have been deprecated in
           favor of the unprefixed values.
        """
        UNDEFINED_ISSUE_TYPE = 0
        IT_OUTAGE = 175779973
        IT_PARTIAL_OUTAGE = 92103971
        OUTAGE = 195285745
        PARTIAL_OUTAGE = 147053455

    class Source(proto.Enum):
        r"""The party that generated this notification, which can take the
        following value:

        -  GOOGLE: this notification as generated by Google. Note that the
           value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
        """
        UNDEFINED_SOURCE = 0
        GOOGLE = 497439289
        NSRC_GOOGLE = 510574562

    class State(proto.Enum):
        r"""State of this notification, which can take one of the following
        values:

        -  ACTIVE: This outage notification is active. The event could be in
           the past, present, or future. See start_time and end_time for
           scheduling.
        -  CANCELLED: The outage associated with this notification was
           cancelled before the outage was due to start. Note that the
           versions of this enum prefixed with "NS_" have been deprecated in
           favor of the unprefixed values.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        CANCELLED = 41957681
        COMPLETED = 309921323
        NS_ACTIVE = 252563136
        NS_CANCELED = 506579411

    affected_circuits = proto.RepeatedField(proto.STRING, number=177717013,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    end_time = proto.Field(proto.INT64, number=114938801, optional=True,)
    issue_type = proto.Field(
        proto.ENUM, number=369639136, optional=True, enum=IssueType,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    source = proto.Field(proto.ENUM, number=177235995, optional=True, enum=Source,)
    start_time = proto.Field(proto.INT64, number=37467274, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class Interconnect(proto.Message):
    r"""Represents an Interconnect resource.

    An Interconnect resource is a dedicated connection between the GCP
    network and your on-premises network. For more information, read the
    Dedicated Interconnect Overview. (== resource_for
    {$api_version}.interconnects ==)

    Attributes:
        admin_enabled (bool):
            Administrative status of the interconnect.
            When this is set to true, the Interconnect is
            functional and can carry traffic. When set to
            false, no packets can be carried over the
            interconnect and no BGP routes are exchanged
            over it. By default, the status is set to true.
        circuit_infos (Sequence[google.cloud.compute_v1.types.InterconnectCircuitInfo]):
            [Output Only] A list of CircuitInfo objects, that describe
            the individual circuits in this LAG.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        customer_name (str):
            Customer name, to put in the Letter of
            Authorization as the party authorized to request
            a crossconnect.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        expected_outages (Sequence[google.cloud.compute_v1.types.InterconnectOutageNotification]):
            [Output Only] A list of outages expected for this
            Interconnect.
        google_ip_address (str):
            [Output Only] IP address configured on the Google side of
            the Interconnect link. This can be used only for ping tests.
        google_reference_id (str):
            [Output Only] Google reference ID to be used when raising
            support tickets with Google or otherwise to debug backend
            connectivity issues.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        interconnect_attachments (Sequence[str]):
            [Output Only] A list of the URLs of all
            InterconnectAttachments configured to use this Interconnect.
        interconnect_type (google.cloud.compute_v1.types.Interconnect.InterconnectType):
            Type of interconnect, which can take one of the following
            values:

            -  PARTNER: A partner-managed interconnection shared between
               customers though a partner.
            -  DEDICATED: A dedicated physical interconnection with the
               customer. Note that a value IT_PRIVATE has been
               deprecated in favor of DEDICATED.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#interconnect for interconnects.
        link_type (google.cloud.compute_v1.types.Interconnect.LinkType):
            Type of link requested, which can take one of the following
            values:

            -  LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
            -  LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR
               optics. Note that this field indicates the speed of each
               of the links in the bundle, not the speed of the entire
               bundle.
        location (str):
            URL of the InterconnectLocation object that
            represents where this connection is to be
            provisioned.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        noc_contact_email (str):
            Email address to contact the customer NOC for
            operations and maintenance notifications
            regarding this Interconnect. If specified, this
            will be used for notifications in addition to
            all other forms described, such as Stackdriver
            logs alerting and Cloud Notifications.
        operational_status (google.cloud.compute_v1.types.Interconnect.OperationalStatus):
            [Output Only] The current status of this Interconnect's
            functionality, which can take one of the following values:

            -  OS_ACTIVE: A valid Interconnect, which is turned up and
               is ready to use. Attachments may be provisioned on this
               Interconnect.
            -  OS_UNPROVISIONED: An Interconnect that has not completed
               turnup. No attachments may be provisioned on this
               Interconnect.
            -  OS_UNDER_MAINTENANCE: An Interconnect that is undergoing
               internal maintenance. No attachments may be provisioned
               or updated on this Interconnect.
        peer_ip_address (str):
            [Output Only] IP address configured on the customer side of
            the Interconnect link. The customer should configure this IP
            address during turnup when prompted by Google NOC. This can
            be used only for ping tests.
        provisioned_link_count (int):
            [Output Only] Number of links actually provisioned in this
            interconnect.
        requested_link_count (int):
            Target number of physical links in the link
            bundle, as requested by the customer.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        state (google.cloud.compute_v1.types.Interconnect.State):
            [Output Only] The current state of Interconnect
            functionality, which can take one of the following values:

            -  ACTIVE: The Interconnect is valid, turned up and ready to
               use. Attachments may be provisioned on this Interconnect.
            -  UNPROVISIONED: The Interconnect has not completed turnup.
               No attachments may be provisioned on this Interconnect.
            -  UNDER_MAINTENANCE: The Interconnect is undergoing
               internal maintenance. No attachments may be provisioned
               or updated on this Interconnect.
    """

    class InterconnectType(proto.Enum):
        r"""Type of interconnect, which can take one of the following values:

        -  PARTNER: A partner-managed interconnection shared between
           customers though a partner.
        -  DEDICATED: A dedicated physical interconnection with the
           customer. Note that a value IT_PRIVATE has been deprecated in
           favor of DEDICATED.
        """
        UNDEFINED_INTERCONNECT_TYPE = 0
        DEDICATED = 258411983
        IT_PRIVATE = 335677007
        PARTNER = 461924520

    class LinkType(proto.Enum):
        r"""Type of link requested, which can take one of the following values:

        -  LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
        -  LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note
           that this field indicates the speed of each of the links in the
           bundle, not the speed of the entire bundle.
        """
        UNDEFINED_LINK_TYPE = 0
        LINK_TYPE_ETHERNET_100G_LR = 337672551
        LINK_TYPE_ETHERNET_10G_LR = 236739749

    class OperationalStatus(proto.Enum):
        r"""[Output Only] The current status of this Interconnect's
        functionality, which can take one of the following values:

        -  OS_ACTIVE: A valid Interconnect, which is turned up and is ready
           to use. Attachments may be provisioned on this Interconnect.
        -  OS_UNPROVISIONED: An Interconnect that has not completed turnup.
           No attachments may be provisioned on this Interconnect.
        -  OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal
           maintenance. No attachments may be provisioned or updated on this
           Interconnect.
        """
        UNDEFINED_OPERATIONAL_STATUS = 0
        OS_ACTIVE = 55721409
        OS_UNPROVISIONED = 239771840

    class State(proto.Enum):
        r"""[Output Only] The current state of Interconnect functionality, which
        can take one of the following values:

        -  ACTIVE: The Interconnect is valid, turned up and ready to use.
           Attachments may be provisioned on this Interconnect.
        -  UNPROVISIONED: The Interconnect has not completed turnup. No
           attachments may be provisioned on this Interconnect.
        -  UNDER_MAINTENANCE: The Interconnect is undergoing internal
           maintenance. No attachments may be provisioned or updated on this
           Interconnect.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        UNPROVISIONED = 517333979

    admin_enabled = proto.Field(proto.BOOL, number=445675089, optional=True,)
    circuit_infos = proto.RepeatedField(
        proto.MESSAGE, number=164839855, message="InterconnectCircuitInfo",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    customer_name = proto.Field(proto.STRING, number=3665484, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    expected_outages = proto.RepeatedField(
        proto.MESSAGE, number=264484123, message="InterconnectOutageNotification",
    )
    google_ip_address = proto.Field(proto.STRING, number=443105954, optional=True,)
    google_reference_id = proto.Field(proto.STRING, number=534944469, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    interconnect_attachments = proto.RepeatedField(proto.STRING, number=425388415,)
    interconnect_type = proto.Field(
        proto.ENUM, number=515165259, optional=True, enum=InterconnectType,
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    link_type = proto.Field(proto.ENUM, number=523207775, optional=True, enum=LinkType,)
    location = proto.Field(proto.STRING, number=290430901, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    noc_contact_email = proto.Field(proto.STRING, number=14072832, optional=True,)
    operational_status = proto.Field(
        proto.ENUM, number=201070847, optional=True, enum=OperationalStatus,
    )
    peer_ip_address = proto.Field(proto.STRING, number=207735769, optional=True,)
    provisioned_link_count = proto.Field(proto.INT32, number=410888565, optional=True,)
    requested_link_count = proto.Field(proto.INT32, number=45051387, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class InterconnectAttachmentPartnerMetadata(proto.Message):
    r"""Informational metadata about Partner attachments from Partners to
    display to customers. These fields are propagated from
    PARTNER_PROVIDER attachments to their corresponding PARTNER
    attachments.

    Attributes:
        interconnect_name (str):
            Plain text name of the Interconnect this
            attachment is connected to, as displayed in the
            Partner's portal. For instance "Chicago 1". This
            value may be validated to match approved Partner
            values.
        partner_name (str):
            Plain text name of the Partner providing this
            attachment. This value may be validated to match
            approved Partner values.
        portal_url (str):
            URL of the Partner's portal for this
            Attachment. Partners may customise this to be a
            deep link to the specific resource on the
            Partner portal. This value may be validated to
            match approved Partner values.
    """

    interconnect_name = proto.Field(proto.STRING, number=514963356, optional=True,)
    partner_name = proto.Field(proto.STRING, number=161747874, optional=True,)
    portal_url = proto.Field(proto.STRING, number=269182748, optional=True,)


class InterconnectAttachmentPrivateInfo(proto.Message):
    r"""Information for an interconnect attachment when this belongs
    to an interconnect of type DEDICATED.

    Attributes:
        tag8021q (int):
            [Output Only] 802.1q encapsulation tag to be used for
            traffic between Google and the customer, going to and from
            this network and region.
    """

    tag8021q = proto.Field(proto.UINT32, number=271820992, optional=True,)


class InterconnectAttachment(proto.Message):
    r"""Represents an Interconnect Attachment (VLAN) resource.

    You can use Interconnect attachments (VLANS) to connect your Virtual
    Private Cloud networks to your on-premises networks through an
    Interconnect. For more information, read Creating VLAN Attachments.
    (== resource_for {$api_version}.interconnectAttachments ==)

    Attributes:
        admin_enabled (bool):
            Determines whether this Attachment will carry packets. Not
            present for PARTNER_PROVIDER.
        bandwidth (google.cloud.compute_v1.types.InterconnectAttachment.Bandwidth):
            Provisioned bandwidth capacity for the interconnect
            attachment. For attachments of type DEDICATED, the user can
            set the bandwidth. For attachments of type PARTNER, the
            Google Partner that is operating the interconnect must set
            the bandwidth. Output only for PARTNER type, mutable for
            PARTNER_PROVIDER and DEDICATED, and can take one of the
            following values:

            -  BPS_50M: 50 Mbit/s
            -  BPS_100M: 100 Mbit/s
            -  BPS_200M: 200 Mbit/s
            -  BPS_300M: 300 Mbit/s
            -  BPS_400M: 400 Mbit/s
            -  BPS_500M: 500 Mbit/s
            -  BPS_1G: 1 Gbit/s
            -  BPS_2G: 2 Gbit/s
            -  BPS_5G: 5 Gbit/s
            -  BPS_10G: 10 Gbit/s
            -  BPS_20G: 20 Gbit/s
            -  BPS_50G: 50 Gbit/s
        candidate_subnets (Sequence[str]):
            Up to 16 candidate prefixes that can be used
            to restrict the allocation of
            cloudRouterIpAddress and customerRouterIpAddress
            for this attachment. All prefixes must be within
            link-local address space (169.254.0.0/16) and
            must be /29 or shorter (/28, /27, etc). Google
            will attempt to select an unused /29 from the
            supplied candidate prefix(es). The request will
            fail if all possible /29s are in use on Google's
            edge. If not supplied, Google will randomly
            select an unused /29 from all of link-local
            space.
        cloud_router_ip_address (str):
            [Output Only] IPv4 address + prefix length to be configured
            on Cloud Router Interface for this interconnect attachment.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        customer_router_ip_address (str):
            [Output Only] IPv4 address + prefix length to be configured
            on the customer router subinterface for this interconnect
            attachment.
        dataplane_version (int):
            [Output Only] Dataplane version for this
            InterconnectAttachment.
        description (str):
            An optional description of this resource.
        edge_availability_domain (google.cloud.compute_v1.types.InterconnectAttachment.EdgeAvailabilityDomain):
            Desired availability domain for the attachment. Only
            available for type PARTNER, at creation time, and can take
            one of the following values:

            -  AVAILABILITY_DOMAIN_ANY
            -  AVAILABILITY_DOMAIN_1
            -  AVAILABILITY_DOMAIN_2 For improved reliability, customers
               should configure a pair of attachments, one per
               availability domain. The selected availability domain
               will be provided to the Partner via the pairing key, so
               that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to
               AVAILABILITY_DOMAIN_ANY.
        encryption (google.cloud.compute_v1.types.InterconnectAttachment.Encryption):
            Indicates the user-supplied encryption option
            of this interconnect attachment: - NONE is the
            default value, which means that the attachment
            carries unencrypted traffic. VMs can send
            traffic to, or receive traffic from, this type
            of attachment. - IPSEC indicates that the
            attachment carries only traffic encrypted by an
            IPsec device such as an HA VPN gateway. VMs
            cannot directly send traffic to, or receive
            traffic from, such an attachment. To use IPsec-
            encrypted Cloud Interconnect, create the
            attachment using this option. Not currently
            available in all Interconnect locations.
        google_reference_id (str):
            [Output Only] Google reference ID, to be used when raising
            support tickets with Google or otherwise to debug backend
            connectivity issues. [Deprecated] This field is not used.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        interconnect (str):
            URL of the underlying Interconnect object
            that this attachment's traffic will traverse
            through.
        ipsec_internal_addresses (Sequence[str]):
            URL of addresses that have been reserved for
            the interconnect attachment, Used only for
            interconnect attachment that has the encryption
            option as IPSEC. The addresses must be RFC 1918
            IP address ranges. When creating HA VPN gateway
            over the interconnect attachment, if the
            attachment is configured to use an RFC 1918 IP
            address, then the VPN gateway's IP address will
            be allocated from the IP address range specified
            here. For example, if the HA VPN gateway's
            interface 0 is paired to this interconnect
            attachment, then an RFC 1918 IP address for the
            VPN gateway interface 0 will be allocated from
            the IP address specified for this interconnect
            attachment. If this field is not specified for
            interconnect attachment that has encryption
            option as IPSEC, later on when creating HA VPN
            gateway on this interconnect attachment, the HA
            VPN gateway's IP address will be allocated from
            regional external IP address pool. Not currently
            available in all Interconnect locations.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#interconnectAttachment for interconnect attachments.
        mtu (int):
            Maximum Transmission Unit (MTU), in bytes, of
            packets passing through this interconnect
            attachment. Only 1440 and 1500 are allowed. If
            not specified, the value will default to 1440.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        operational_status (google.cloud.compute_v1.types.InterconnectAttachment.OperationalStatus):
            [Output Only] The current status of whether or not this
            interconnect attachment is functional, which can take one of
            the following values:

            -  OS_ACTIVE: The attachment has been turned up and is ready
               to use.
            -  OS_UNPROVISIONED: The attachment is not ready to use yet,
               because turnup is not complete.
        pairing_key (str):
            [Output only for type PARTNER. Input only for
            PARTNER_PROVIDER. Not present for DEDICATED]. The opaque
            identifier of an PARTNER attachment used to initiate
            provisioning with a selected partner. Of the form
            "XXXXX/region/domain".
        partner_asn (int):
            Optional BGP ASN for the router supplied by a Layer 3
            Partner if they configured BGP on behalf of the customer.
            Output only for PARTNER type, input only for
            PARTNER_PROVIDER, not available for DEDICATED.
        partner_metadata (google.cloud.compute_v1.types.InterconnectAttachmentPartnerMetadata):
            Informational metadata about Partner attachments from
            Partners to display to customers. Output only for for
            PARTNER type, mutable for PARTNER_PROVIDER, not available
            for DEDICATED.
        private_interconnect_info (google.cloud.compute_v1.types.InterconnectAttachmentPrivateInfo):
            [Output Only] Information specific to an
            InterconnectAttachment. This property is populated if the
            interconnect that this is attached to is of type DEDICATED.
        region (str):
            [Output Only] URL of the region where the regional
            interconnect attachment resides. You must specify this field
            as part of the HTTP request URL. It is not settable as a
            field in the request body.
        router (str):
            URL of the Cloud Router to be used for
            dynamic routing. This router must be in the same
            region as this InterconnectAttachment. The
            InterconnectAttachment will automatically
            connect the Interconnect to the network & region
            within which the Cloud Router is configured.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        state (google.cloud.compute_v1.types.InterconnectAttachment.State):
            [Output Only] The current state of this attachment's
            functionality. Enum values ACTIVE and UNPROVISIONED are
            shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER
            interconnect attachments, while enum values PENDING_PARTNER,
            PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for
            only PARTNER and PARTNER_PROVIDER interconnect attachments.
            This state can take one of the following values:

            -  ACTIVE: The attachment has been turned up and is ready to
               use.
            -  UNPROVISIONED: The attachment is not ready to use yet,
               because turnup is not complete.
            -  PENDING_PARTNER: A newly-created PARTNER attachment that
               has not yet been configured on the Partner side.
            -  PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the
               process of provisioning after a PARTNER_PROVIDER
               attachment was created that references it.
            -  PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER
               attachment that is waiting for a customer to activate it.
            -  DEFUNCT: The attachment was deleted externally and is no
               longer functional. This could be because the associated
               Interconnect was removed, or because the other side of a
               Partner attachment was deleted.
        type_ (google.cloud.compute_v1.types.InterconnectAttachment.Type):
            The type of interconnect attachment this is, which can take
            one of the following values:

            -  DEDICATED: an attachment to a Dedicated Interconnect.
            -  PARTNER: an attachment to a Partner Interconnect, created
               by the customer.
            -  PARTNER_PROVIDER: an attachment to a Partner
               Interconnect, created by the partner.
        vlan_tag8021q (int):
            The IEEE 802.1Q VLAN tag for this attachment,
            in the range 2-4094. Only specified at creation
            time.
    """

    class Bandwidth(proto.Enum):
        r"""Provisioned bandwidth capacity for the interconnect attachment. For
        attachments of type DEDICATED, the user can set the bandwidth. For
        attachments of type PARTNER, the Google Partner that is operating
        the interconnect must set the bandwidth. Output only for PARTNER
        type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one
        of the following values:

        -  BPS_50M: 50 Mbit/s
        -  BPS_100M: 100 Mbit/s
        -  BPS_200M: 200 Mbit/s
        -  BPS_300M: 300 Mbit/s
        -  BPS_400M: 400 Mbit/s
        -  BPS_500M: 500 Mbit/s
        -  BPS_1G: 1 Gbit/s
        -  BPS_2G: 2 Gbit/s
        -  BPS_5G: 5 Gbit/s
        -  BPS_10G: 10 Gbit/s
        -  BPS_20G: 20 Gbit/s
        -  BPS_50G: 50 Gbit/s
        """
        UNDEFINED_BANDWIDTH = 0
        BPS_100M = 49547958
        BPS_10G = 278693006
        BPS_1G = 355358448
        BPS_200M = 49577749
        BPS_20G = 278693967
        BPS_2G = 355358479
        BPS_300M = 49607540
        BPS_400M = 49637331
        BPS_500M = 49667122
        BPS_50G = 278696850
        BPS_50M = 278696856
        BPS_5G = 355358572

    class EdgeAvailabilityDomain(proto.Enum):
        r"""Desired availability domain for the attachment. Only available for
        type PARTNER, at creation time, and can take one of the following
        values:

        -  AVAILABILITY_DOMAIN_ANY
        -  AVAILABILITY_DOMAIN_1
        -  AVAILABILITY_DOMAIN_2 For improved reliability, customers should
           configure a pair of attachments, one per availability domain. The
           selected availability domain will be provided to the Partner via
           the pairing key, so that the provisioned circuit will lie in the
           specified domain. If not specified, the value will default to
           AVAILABILITY_DOMAIN_ANY.
        """
        UNDEFINED_EDGE_AVAILABILITY_DOMAIN = 0
        AVAILABILITY_DOMAIN_1 = 349552090
        AVAILABILITY_DOMAIN_2 = 349552091
        AVAILABILITY_DOMAIN_ANY = 375256373

    class Encryption(proto.Enum):
        r"""Indicates the user-supplied encryption option of this
        interconnect attachment: - NONE is the default value, which
        means that the attachment carries unencrypted traffic. VMs can
        send traffic to, or receive traffic from, this type of
        attachment. - IPSEC indicates that the attachment carries only
        traffic encrypted by an IPsec device such as an HA VPN gateway.
        VMs cannot directly send traffic to, or receive traffic from,
        such an attachment. To use IPsec-encrypted Cloud Interconnect,
        create the attachment using this option. Not currently available
        in all Interconnect locations.
        """
        UNDEFINED_ENCRYPTION = 0
        IPSEC = 69882282
        NONE = 2402104

    class OperationalStatus(proto.Enum):
        r"""[Output Only] The current status of whether or not this interconnect
        attachment is functional, which can take one of the following
        values:

        -  OS_ACTIVE: The attachment has been turned up and is ready to use.
        -  OS_UNPROVISIONED: The attachment is not ready to use yet, because
           turnup is not complete.
        """
        UNDEFINED_OPERATIONAL_STATUS = 0
        OS_ACTIVE = 55721409
        OS_UNPROVISIONED = 239771840

    class State(proto.Enum):
        r"""[Output Only] The current state of this attachment's functionality.
        Enum values ACTIVE and UNPROVISIONED are shared by
        DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect
        attachments, while enum values PENDING_PARTNER,
        PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only
        PARTNER and PARTNER_PROVIDER interconnect attachments. This state
        can take one of the following values:

        -  ACTIVE: The attachment has been turned up and is ready to use.
        -  UNPROVISIONED: The attachment is not ready to use yet, because
           turnup is not complete.
        -  PENDING_PARTNER: A newly-created PARTNER attachment that has not
           yet been configured on the Partner side.
        -  PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process
           of provisioning after a PARTNER_PROVIDER attachment was created
           that references it.
        -  PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that
           is waiting for a customer to activate it.
        -  DEFUNCT: The attachment was deleted externally and is no longer
           functional. This could be because the associated Interconnect was
           removed, or because the other side of a Partner attachment was
           deleted.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        DEFUNCT = 115891759
        PARTNER_REQUEST_RECEIVED = 513587304
        PENDING_CUSTOMER = 167494054
        PENDING_PARTNER = 387890656
        STATE_UNSPECIFIED = 470755401
        UNPROVISIONED = 517333979

    class Type(proto.Enum):
        r"""The type of interconnect attachment this is, which can take one of
        the following values:

        -  DEDICATED: an attachment to a Dedicated Interconnect.
        -  PARTNER: an attachment to a Partner Interconnect, created by the
           customer.
        -  PARTNER_PROVIDER: an attachment to a Partner Interconnect,
           created by the partner.
        """
        UNDEFINED_TYPE = 0
        DEDICATED = 258411983
        PARTNER = 461924520
        PARTNER_PROVIDER = 483261352

    admin_enabled = proto.Field(proto.BOOL, number=445675089, optional=True,)
    bandwidth = proto.Field(
        proto.ENUM, number=181715121, optional=True, enum=Bandwidth,
    )
    candidate_subnets = proto.RepeatedField(proto.STRING, number=237842938,)
    cloud_router_ip_address = proto.Field(
        proto.STRING, number=287392776, optional=True,
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    customer_router_ip_address = proto.Field(
        proto.STRING, number=332475761, optional=True,
    )
    dataplane_version = proto.Field(proto.INT32, number=34920075, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    edge_availability_domain = proto.Field(
        proto.ENUM, number=71289510, optional=True, enum=EdgeAvailabilityDomain,
    )
    encryption = proto.Field(
        proto.ENUM, number=97980291, optional=True, enum=Encryption,
    )
    google_reference_id = proto.Field(proto.STRING, number=534944469, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    interconnect = proto.Field(proto.STRING, number=224601230, optional=True,)
    ipsec_internal_addresses = proto.RepeatedField(proto.STRING, number=407648565,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    mtu = proto.Field(proto.INT32, number=108462, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    operational_status = proto.Field(
        proto.ENUM, number=201070847, optional=True, enum=OperationalStatus,
    )
    pairing_key = proto.Field(proto.STRING, number=439695464, optional=True,)
    partner_asn = proto.Field(proto.INT64, number=438166149, optional=True,)
    partner_metadata = proto.Field(
        proto.MESSAGE,
        number=65908934,
        optional=True,
        message="InterconnectAttachmentPartnerMetadata",
    )
    private_interconnect_info = proto.Field(
        proto.MESSAGE,
        number=237270531,
        optional=True,
        message="InterconnectAttachmentPrivateInfo",
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    router = proto.Field(proto.STRING, number=148608841, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)
    vlan_tag8021q = proto.Field(proto.INT32, number=119927836, optional=True,)


class InterconnectAttachmentsScopedList(proto.Message):
    r"""
    Attributes:
        interconnect_attachments (Sequence[google.cloud.compute_v1.types.InterconnectAttachment]):
            A list of interconnect attachments contained
            in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of addresses when the list is empty.
    """

    interconnect_attachments = proto.RepeatedField(
        proto.MESSAGE, number=425388415, message="InterconnectAttachment",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InterconnectAttachmentAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InterconnectAttachmentAggregatedList.ItemsEntry]):
            A list of InterconnectAttachmentsScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#interconnectAttachmentAggregatedList for aggregated
            lists of interconnect attachments.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="InterconnectAttachmentsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InterconnectAttachmentList(proto.Message):
    r"""Response to the list request, and contains a list of
    interconnect attachments.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InterconnectAttachment]):
            A list of InterconnectAttachment resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#interconnectAttachmentList for lists of interconnect
            attachments.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InterconnectAttachment",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InterconnectDiagnosticsARPEntry(proto.Message):
    r"""Describing the ARP neighbor entries seen on this link
    Attributes:
        ip_address (str):
            The IP address of this ARP neighbor.
        mac_address (str):
            The MAC address of this ARP neighbor.
    """

    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    mac_address = proto.Field(proto.STRING, number=332540164, optional=True,)


class InterconnectDiagnosticsLinkStatus(proto.Message):
    r"""
    Attributes:
        arp_caches (Sequence[google.cloud.compute_v1.types.InterconnectDiagnosticsARPEntry]):
            A list of InterconnectDiagnostics.ARPEntry
            objects, describing the ARP neighbor entries
            seen on this link. This will be empty if the
            link is bundled
        circuit_id (str):
            The unique ID for this link assigned during
            turn up by Google.
        google_demarc (str):
            The Demarc address assigned by Google and
            provided in the LoA.
        lacp_status (google.cloud.compute_v1.types.InterconnectDiagnosticsLinkLACPStatus):

        receiving_optical_power (google.cloud.compute_v1.types.InterconnectDiagnosticsLinkOpticalPower):
            An InterconnectDiagnostics.LinkOpticalPower
            object, describing the current value and status
            of the received light level.
        transmitting_optical_power (google.cloud.compute_v1.types.InterconnectDiagnosticsLinkOpticalPower):
            An InterconnectDiagnostics.LinkOpticalPower
            object, describing the current value and status
            of the transmitted light level.
    """

    arp_caches = proto.RepeatedField(
        proto.MESSAGE, number=414591761, message="InterconnectDiagnosticsARPEntry",
    )
    circuit_id = proto.Field(proto.STRING, number=225180977, optional=True,)
    google_demarc = proto.Field(proto.STRING, number=51084, optional=True,)
    lacp_status = proto.Field(
        proto.MESSAGE,
        number=361210415,
        optional=True,
        message="InterconnectDiagnosticsLinkLACPStatus",
    )
    receiving_optical_power = proto.Field(
        proto.MESSAGE,
        number=244717279,
        optional=True,
        message="InterconnectDiagnosticsLinkOpticalPower",
    )
    transmitting_optical_power = proto.Field(
        proto.MESSAGE,
        number=459431197,
        optional=True,
        message="InterconnectDiagnosticsLinkOpticalPower",
    )


class InterconnectDiagnostics(proto.Message):
    r"""Diagnostics information about interconnect, contains detailed
    and current technical information about Google's side of the
    connection.

    Attributes:
        arp_caches (Sequence[google.cloud.compute_v1.types.InterconnectDiagnosticsARPEntry]):
            A list of InterconnectDiagnostics.ARPEntry
            objects, describing individual neighbors
            currently seen by the Google router in the ARP
            cache for the Interconnect. This will be empty
            when the Interconnect is not bundled.
        links (Sequence[google.cloud.compute_v1.types.InterconnectDiagnosticsLinkStatus]):
            A list of InterconnectDiagnostics.LinkStatus
            objects, describing the status for each link on
            the Interconnect.
        mac_address (str):
            The MAC address of the Interconnect's bundle
            interface.
    """

    arp_caches = proto.RepeatedField(
        proto.MESSAGE, number=414591761, message="InterconnectDiagnosticsARPEntry",
    )
    links = proto.RepeatedField(
        proto.MESSAGE, number=102977465, message="InterconnectDiagnosticsLinkStatus",
    )
    mac_address = proto.Field(proto.STRING, number=332540164, optional=True,)


class InterconnectDiagnosticsLinkLACPStatus(proto.Message):
    r"""
    Attributes:
        google_system_id (str):
            System ID of the port on Google's side of the
            LACP exchange.
        neighbor_system_id (str):
            System ID of the port on the neighbor's side
            of the LACP exchange.
        state (google.cloud.compute_v1.types.InterconnectDiagnosticsLinkLACPStatus.State):
            The state of a LACP link, which can take one
            of the following values: - ACTIVE: The link is
            configured and active within the bundle. -
            DETACHED: The link is not configured within the
            bundle. This means that the rest of the object
            should be empty.
    """

    class State(proto.Enum):
        r"""The state of a LACP link, which can take one of the following
        values: - ACTIVE: The link is configured and active within the
        bundle. - DETACHED: The link is not configured within the
        bundle. This means that the rest of the object should be empty.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        DETACHED = 216562546

    google_system_id = proto.Field(proto.STRING, number=91210405, optional=True,)
    neighbor_system_id = proto.Field(proto.STRING, number=343821342, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class InterconnectDiagnosticsLinkOpticalPower(proto.Message):
    r"""
    Attributes:
        state (google.cloud.compute_v1.types.InterconnectDiagnosticsLinkOpticalPower.State):
            The status of the current value when compared to the warning
            and alarm levels for the receiving or transmitting
            transceiver. Possible states include:

            -  OK: The value has not crossed a warning threshold.
            -  LOW_WARNING: The value has crossed below the low warning
               threshold.
            -  HIGH_WARNING: The value has crossed above the high
               warning threshold.
            -  LOW_ALARM: The value has crossed below the low alarm
               threshold.
            -  HIGH_ALARM: The value has crossed above the high alarm
               threshold.
        value (float):
            Value of the current receiving or
            transmitting optical power, read in dBm. Take a
            known good optical value, give it a 10% margin
            and trigger warnings relative to that value. In
            general, a -7dBm warning and a -11dBm alarm are
            good optical value estimates for most links.
    """

    class State(proto.Enum):
        r"""The status of the current value when compared to the warning and
        alarm levels for the receiving or transmitting transceiver. Possible
        states include:

        -  OK: The value has not crossed a warning threshold.
        -  LOW_WARNING: The value has crossed below the low warning
           threshold.
        -  HIGH_WARNING: The value has crossed above the high warning
           threshold.
        -  LOW_ALARM: The value has crossed below the low alarm threshold.
        -  HIGH_ALARM: The value has crossed above the high alarm threshold.
        """
        UNDEFINED_STATE = 0
        HIGH_ALARM = 305363284
        HIGH_WARNING = 220984799
        LOW_ALARM = 316659046
        LOW_WARNING = 338793841
        OK = 2524

    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)
    value = proto.Field(proto.FLOAT, number=111972721, optional=True,)


class InterconnectList(proto.Message):
    r"""Response to the list request, and contains a list of
    interconnects.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Interconnect]):
            A list of Interconnect resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#interconnectList for lists of interconnects.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="Interconnect",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InterconnectLocationRegionInfo(proto.Message):
    r"""Information about any potential InterconnectAttachments
    between an Interconnect at a specific InterconnectLocation, and
    a specific Cloud Region.

    Attributes:
        expected_rtt_ms (int):
            Expected round-trip time in milliseconds,
            from this InterconnectLocation to a VM in this
            region.
        location_presence (google.cloud.compute_v1.types.InterconnectLocationRegionInfo.LocationPresence):
            Identifies the network presence of this
            location.
        region (str):
            URL for the region of this location.
    """

    class LocationPresence(proto.Enum):
        r"""Identifies the network presence of this location."""
        UNDEFINED_LOCATION_PRESENCE = 0
        GLOBAL = 494663587
        LOCAL_REGION = 403535464
        LP_GLOBAL = 429584062
        LP_LOCAL_REGION = 488598851

    expected_rtt_ms = proto.Field(proto.INT64, number=422543866, optional=True,)
    location_presence = proto.Field(
        proto.ENUM, number=101517893, optional=True, enum=LocationPresence,
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)


class InterconnectLocation(proto.Message):
    r"""Represents an Interconnect Attachment (VLAN) Location
    resource.
    You can use this resource to find location details about an
    Interconnect attachment (VLAN). For more information about
    interconnect attachments, read  Creating VLAN Attachments.

    Attributes:
        address (str):
            [Output Only] The postal address of the Point of Presence,
            each line in the address is separated by a newline
            character.
        availability_zone (str):
            [Output Only] Availability zone for this
            InterconnectLocation. Within a metropolitan area (metro),
            maintenance will not be simultaneously scheduled in more
            than one availability zone. Example: "zone1" or "zone2".
        city (str):
            [Output Only] Metropolitan area designator that indicates
            which city an interconnect is located. For example:
            "Chicago, IL", "Amsterdam, Netherlands".
        continent (google.cloud.compute_v1.types.InterconnectLocation.Continent):
            [Output Only] Continent for this location, which can take
            one of the following values:

            -  AFRICA
            -  ASIA_PAC
            -  EUROPE
            -  NORTH_AMERICA
            -  SOUTH_AMERICA
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            [Output Only] An optional description of the resource.
        facility_provider (str):
            [Output Only] The name of the provider for this facility
            (e.g., EQUINIX).
        facility_provider_facility_id (str):
            [Output Only] A provider-assigned Identifier for this
            facility (e.g., Ashburn-DC1).
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#interconnectLocation for interconnect locations.
        name (str):
            [Output Only] Name of the resource.
        peeringdb_facility_id (str):
            [Output Only] The peeringdb identifier for this facility
            (corresponding with a netfac type in peeringdb).
        region_infos (Sequence[google.cloud.compute_v1.types.InterconnectLocationRegionInfo]):
            [Output Only] A list of InterconnectLocation.RegionInfo
            objects, that describe parameters pertaining to the relation
            between this InterconnectLocation and various Google Cloud
            regions.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        status (google.cloud.compute_v1.types.InterconnectLocation.Status):
            [Output Only] The status of this InterconnectLocation, which
            can take one of the following values:

            -  CLOSED: The InterconnectLocation is closed and is
               unavailable for provisioning new Interconnects.
            -  AVAILABLE: The InterconnectLocation is available for
               provisioning new Interconnects.
    """

    class Continent(proto.Enum):
        r"""[Output Only] Continent for this location, which can take one of the
        following values:

        -  AFRICA
        -  ASIA_PAC
        -  EUROPE
        -  NORTH_AMERICA
        -  SOUTH_AMERICA
        """
        UNDEFINED_CONTINENT = 0
        AFRICA = 317443706
        ASIA_PAC = 119782269
        C_AFRICA = 71993846
        C_ASIA_PAC = 465668089
        C_EUROPE = 200369438
        C_NORTH_AMERICA = 275697048
        C_SOUTH_AMERICA = 397149792
        EUROPE = 445819298
        NORTH_AMERICA = 448015508
        SOUTH_AMERICA = 32597340

    class Status(proto.Enum):
        r"""[Output Only] The status of this InterconnectLocation, which can
        take one of the following values:

        -  CLOSED: The InterconnectLocation is closed and is unavailable for
           provisioning new Interconnects.
        -  AVAILABLE: The InterconnectLocation is available for provisioning
           new Interconnects.
        """
        UNDEFINED_STATUS = 0
        AVAILABLE = 442079913
        CLOSED = 380163436

    address = proto.Field(proto.STRING, number=462920692, optional=True,)
    availability_zone = proto.Field(proto.STRING, number=158459920, optional=True,)
    city = proto.Field(proto.STRING, number=3053931, optional=True,)
    continent = proto.Field(
        proto.ENUM, number=133442996, optional=True, enum=Continent,
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    facility_provider = proto.Field(proto.STRING, number=533303309, optional=True,)
    facility_provider_facility_id = proto.Field(
        proto.STRING, number=87269125, optional=True,
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    peeringdb_facility_id = proto.Field(proto.STRING, number=536567094, optional=True,)
    region_infos = proto.RepeatedField(
        proto.MESSAGE, number=312194170, message="InterconnectLocationRegionInfo",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class InterconnectLocationList(proto.Message):
    r"""Response to the list request, and contains a list of
    interconnect locations.

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InterconnectLocation]):
            A list of InterconnectLocation resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#interconnectLocationList for lists of interconnect
            locations.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InterconnectLocation",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class InterconnectsGetDiagnosticsResponse(proto.Message):
    r"""Response for the InterconnectsGetDiagnosticsRequest.
    Attributes:
        result (google.cloud.compute_v1.types.InterconnectDiagnostics):

    """

    result = proto.Field(
        proto.MESSAGE,
        number=139315229,
        optional=True,
        message="InterconnectDiagnostics",
    )


class LicenseResourceRequirements(proto.Message):
    r"""
    Attributes:
        min_guest_cpu_count (int):
            Minimum number of guest cpus required to use
            the Instance. Enforced at Instance creation and
            Instance start.
        min_memory_mb (int):
            Minimum memory required to use the Instance.
            Enforced at Instance creation and Instance
            start.
    """

    min_guest_cpu_count = proto.Field(proto.INT32, number=477964836, optional=True,)
    min_memory_mb = proto.Field(proto.INT32, number=504785894, optional=True,)


class License(proto.Message):
    r"""Represents a License resource.

    A License represents billing and aggregate usage data for public and
    marketplace images. Caution This resource is intended for use only
    by third-party partners who are creating Cloud Marketplace images.
    (== resource_for {$api_version}.licenses ==)

    Attributes:
        charges_use_fee (bool):
            [Output Only] Deprecated. This field no longer reflects
            whether a license charges a usage fee.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional textual description of the
            resource; provided by the client when the
            resource is created.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of resource. Always compute#license for
            licenses.
        license_code (int):
            [Output Only] The unique code used to attach this license to
            images, snapshots, and disks.
        name (str):
            Name of the resource. The name must be 1-63
            characters long and comply with RFC1035.
        resource_requirements (google.cloud.compute_v1.types.LicenseResourceRequirements):

        self_link (str):
            [Output Only] Server-defined URL for the resource.
        transferable (bool):
            If false, licenses will not be copied from
            the source resource when creating an image from
            a disk, disk from snapshot, or snapshot from
            disk.
    """

    charges_use_fee = proto.Field(proto.BOOL, number=372412622, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    license_code = proto.Field(proto.UINT64, number=1467179, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    resource_requirements = proto.Field(
        proto.MESSAGE,
        number=214292769,
        optional=True,
        message="LicenseResourceRequirements",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    transferable = proto.Field(proto.BOOL, number=4349893, optional=True,)


class LicenseCodeLicenseAlias(proto.Message):
    r"""
    Attributes:
        description (str):
            [Output Only] Description of this License Code.
        self_link (str):
            [Output Only] URL of license corresponding to this License
            Code.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class LicenseCode(proto.Message):
    r"""Represents a License Code resource.

    A License Code is a unique identifier used to represent a license
    resource. Caution This resource is intended for use only by
    third-party partners who are creating Cloud Marketplace images. (==
    resource_for {$api_version}.licenseCodes ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            [Output Only] Description of this License Code.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of resource. Always compute#licenseCode
            for licenses.
        license_alias (Sequence[google.cloud.compute_v1.types.LicenseCodeLicenseAlias]):
            [Output Only] URL and description aliases of Licenses with
            the same License Code.
        name (str):
            [Output Only] Name of the resource. The name is 1-20
            characters long and must be a valid 64 bit integer.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        state (google.cloud.compute_v1.types.LicenseCode.State):
            [Output Only] Current state of this License Code.
        transferable (bool):
            [Output Only] If true, the license will remain attached when
            creating images or snapshots from disks. Otherwise, the
            license is not transferred.
    """

    class State(proto.Enum):
        r"""[Output Only] Current state of this License Code."""
        UNDEFINED_STATE = 0
        DISABLED = 516696700
        ENABLED = 182130465
        RESTRICTED = 261551195
        STATE_UNSPECIFIED = 470755401
        TERMINATED = 250018339

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    license_alias = proto.RepeatedField(
        proto.MESSAGE, number=43550930, message="LicenseCodeLicenseAlias",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)
    transferable = proto.Field(proto.BOOL, number=4349893, optional=True,)


class LicensesListResponse(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.License]):
            A list of License resources.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="License",)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class LocalDisk(proto.Message):
    r"""
    Attributes:
        disk_count (int):
            Specifies the number of such disks.
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.
        disk_type (str):
            Specifies the desired disk type on the node.
            This disk type must be a local storage type
            (e.g.: local-ssd). Note that for nodeTemplates,
            this should be the name of the disk type and not
            its URL.
    """

    disk_count = proto.Field(proto.INT32, number=182933485, optional=True,)
    disk_size_gb = proto.Field(proto.INT32, number=316263735, optional=True,)
    disk_type = proto.Field(proto.STRING, number=93009052, optional=True,)


class LocationPolicyLocation(proto.Message):
    r"""
    Attributes:
        preference (google.cloud.compute_v1.types.LocationPolicyLocation.Preference):
            Preference for a given locaction: ALLOW or
            DENY.
    """

    class Preference(proto.Enum):
        r"""Preference for a given locaction: ALLOW or DENY."""
        UNDEFINED_PREFERENCE = 0
        ALLOW = 62368553
        DENY = 2094604
        PREFERENCE_UNSPECIFIED = 496219571

    preference = proto.Field(
        proto.ENUM, number=150781147, optional=True, enum=Preference,
    )


class LogConfigCloudAuditOptions(proto.Message):
    r"""Write a Cloud Audit log
    Attributes:
        authorization_logging_options (google.cloud.compute_v1.types.AuthorizationLoggingOptions):
            Information used by the Cloud Audit Logging
            pipeline.
        log_name (google.cloud.compute_v1.types.LogConfigCloudAuditOptions.LogName):
            The log_name to populate in the Cloud Audit Record.
    """

    class LogName(proto.Enum):
        r"""The log_name to populate in the Cloud Audit Record."""
        UNDEFINED_LOG_NAME = 0
        ADMIN_ACTIVITY = 427503135
        DATA_ACCESS = 238070681
        UNSPECIFIED_LOG_NAME = 410515182

    authorization_logging_options = proto.Field(
        proto.MESSAGE,
        number=217861624,
        optional=True,
        message="AuthorizationLoggingOptions",
    )
    log_name = proto.Field(proto.ENUM, number=402913958, optional=True, enum=LogName,)


class LogConfigCounterOptions(proto.Message):
    r"""Increment a streamz counter with the specified metric and field
    names.

    Metric names should start with a '/', generally be lowercase-only,
    and end in "_count". Field names should not contain an initial
    slash. The actual exported metric names will have "/iam/policy"
    prepended.

    Field names correspond to IAM request parameters and field values
    are their respective values.

    Supported field names: - "authority", which is "[token]" if
    IAMContext.token is present, otherwise the value of
    IAMContext.authority_selector if present, and otherwise a
    representation of IAMContext.principal; or - "iam_principal", a
    representation of IAMContext.principal even if a token or authority
    selector is present; or - "" (empty string), resulting in a counter
    with no fields.

    Examples: counter { metric: "/debug_access_count" field:
    "iam_principal" } ==> increment counter
    /iam/policy/debug_access_count {iam_principal=[value of
    IAMContext.principal]}

    Attributes:
        custom_fields (Sequence[google.cloud.compute_v1.types.LogConfigCounterOptionsCustomField]):
            Custom fields.
        field (str):
            The field value to attribute.
        metric (str):
            The metric to update.
    """

    custom_fields = proto.RepeatedField(
        proto.MESSAGE, number=249651015, message="LogConfigCounterOptionsCustomField",
    )
    field = proto.Field(proto.STRING, number=97427706, optional=True,)
    metric = proto.Field(proto.STRING, number=533067184, optional=True,)


class LogConfigDataAccessOptions(proto.Message):
    r"""Write a Data Access (Gin) log
    Attributes:
        log_mode (google.cloud.compute_v1.types.LogConfigDataAccessOptions.LogMode):

    """

    class LogMode(proto.Enum):
        r""""""
        UNDEFINED_LOG_MODE = 0
        LOG_FAIL_CLOSED = 360469778
        LOG_MODE_UNSPECIFIED = 88160822

    log_mode = proto.Field(proto.ENUM, number=402897342, optional=True, enum=LogMode,)


class LogConfig(proto.Message):
    r"""Specifies what kind of log the caller must write
    Attributes:
        cloud_audit (google.cloud.compute_v1.types.LogConfigCloudAuditOptions):
            Cloud audit options.
        counter (google.cloud.compute_v1.types.LogConfigCounterOptions):
            Counter options.
        data_access (google.cloud.compute_v1.types.LogConfigDataAccessOptions):
            Data access options.
    """

    cloud_audit = proto.Field(
        proto.MESSAGE,
        number=412852561,
        optional=True,
        message="LogConfigCloudAuditOptions",
    )
    counter = proto.Field(
        proto.MESSAGE,
        number=420959740,
        optional=True,
        message="LogConfigCounterOptions",
    )
    data_access = proto.Field(
        proto.MESSAGE,
        number=286633881,
        optional=True,
        message="LogConfigDataAccessOptions",
    )


class LogConfigCounterOptionsCustomField(proto.Message):
    r"""Custom fields. These can be used to create a counter with
    arbitrary field/value pairs. See: go/rpcsp-custom-fields.

    Attributes:
        name (str):
            Name is the field name.
        value (str):
            Value is the field value. It is important
            that in contrast to the CounterOptions.field,
            the value here is a constant that is not derived
            from the IAMContext.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class Accelerators(proto.Message):
    r"""
    Attributes:
        guest_accelerator_count (int):
            Number of accelerator cards exposed to the
            guest.
        guest_accelerator_type (str):
            The accelerator type resource name, not a
            full URL, e.g. 'nvidia-tesla-k80'.
    """

    guest_accelerator_count = proto.Field(proto.INT32, number=479079316, optional=True,)
    guest_accelerator_type = proto.Field(proto.STRING, number=293064725, optional=True,)


class ScratchDisks(proto.Message):
    r"""
    Attributes:
        disk_gb (int):
            Size of the scratch disk, defined in GB.
    """

    disk_gb = proto.Field(proto.INT32, number=60990141, optional=True,)


class MachineType(proto.Message):
    r"""Represents a Machine Type resource.

    You can use specific machine types for your VM instances based on
    performance and pricing requirements. For more information, read
    Machine Types. (== resource_for {$api_version}.machineTypes ==)

    Attributes:
        accelerators (Sequence[google.cloud.compute_v1.types.Accelerators]):
            [Output Only] A list of accelerator configurations assigned
            to this machine type.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            machine type. Only applicable if the machine type is
            unavailable.
        description (str):
            [Output Only] An optional textual description of the
            resource.
        guest_cpus (int):
            [Output Only] The number of virtual CPUs that are available
            to the instance.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        image_space_gb (int):
            [Deprecated] This property is deprecated and will never be
            populated with any relevant values.
        is_shared_cpu (bool):
            [Output Only] Whether this machine type has a shared CPU.
            See Shared-core machine types for more information.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#machineType for machine types.
        maximum_persistent_disks (int):
            [Output Only] Maximum persistent disks allowed.
        maximum_persistent_disks_size_gb (int):
            [Output Only] Maximum total persistent disks size (GB)
            allowed.
        memory_mb (int):
            [Output Only] The amount of physical memory available to the
            instance, defined in MB.
        name (str):
            [Output Only] Name of the resource.
        scratch_disks (Sequence[google.cloud.compute_v1.types.ScratchDisks]):
            [Output Only] A list of extended scratch disks assigned to
            the instance.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        zone (str):
            [Output Only] The name of the zone where the machine type
            resides, such as us-central1-a.
    """

    accelerators = proto.RepeatedField(
        proto.MESSAGE, number=269577064, message="Accelerators",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    guest_cpus = proto.Field(proto.INT32, number=393356754, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    image_space_gb = proto.Field(proto.INT32, number=75331864, optional=True,)
    is_shared_cpu = proto.Field(proto.BOOL, number=521399555, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    maximum_persistent_disks = proto.Field(
        proto.INT32, number=496220941, optional=True,
    )
    maximum_persistent_disks_size_gb = proto.Field(
        proto.INT64, number=154274471, optional=True,
    )
    memory_mb = proto.Field(proto.INT32, number=116001171, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    scratch_disks = proto.RepeatedField(
        proto.MESSAGE, number=480778481, message="ScratchDisks",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class MachineTypesScopedList(proto.Message):
    r"""
    Attributes:
        machine_types (Sequence[google.cloud.compute_v1.types.MachineType]):
            [Output Only] A list of machine types contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            machine types list is empty.
    """

    machine_types = proto.RepeatedField(
        proto.MESSAGE, number=79720065, message="MachineType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class MachineTypeAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.MachineTypeAggregatedList.ItemsEntry]):
            A list of MachineTypesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#machineTypeAggregatedList for aggregated lists of
            machine types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="MachineTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class MachineTypeList(proto.Message):
    r"""Contains a list of machine types.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.MachineType]):
            A list of MachineType resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#machineTypeList for lists of machine types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="MachineType",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ManagedInstanceInstanceHealth(proto.Message):
    r"""
    Attributes:
        detailed_health_state (google.cloud.compute_v1.types.ManagedInstanceInstanceHealth.DetailedHealthState):
            [Output Only] The current detailed instance health state.
        health_check (str):
            [Output Only] The URL for the health check that verifies
            whether the instance is healthy.
    """

    class DetailedHealthState(proto.Enum):
        r"""[Output Only] The current detailed instance health state."""
        UNDEFINED_DETAILED_HEALTH_STATE = 0
        DRAINING = 480455402
        HEALTHY = 439801213
        TIMEOUT = 477813057
        UNHEALTHY = 462118084
        UNKNOWN = 433141802

    detailed_health_state = proto.Field(
        proto.ENUM, number=510470173, optional=True, enum=DetailedHealthState,
    )
    health_check = proto.Field(proto.STRING, number=308876645, optional=True,)


class ManagedInstanceLastAttempt(proto.Message):
    r"""
    Attributes:
        errors (google.cloud.compute_v1.types.Errors):
            [Output Only] Encountered errors during the last attempt to
            create or delete the instance.
    """

    errors = proto.Field(
        proto.MESSAGE, number=315977579, optional=True, message="Errors",
    )


class PreservedState(proto.Message):
    r"""Preserved state for a given instance.
    Attributes:
        disks (Sequence[google.cloud.compute_v1.types.PreservedState.DisksEntry]):
            Preserved disks defined for this instance.
            This map is keyed with the device names of the
            disks.
        metadata (Sequence[google.cloud.compute_v1.types.PreservedState.MetadataEntry]):
            Preserved metadata defined for this instance.
    """

    disks = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=95594102,
        message="PreservedStatePreservedDisk",
    )
    metadata = proto.MapField(proto.STRING, proto.STRING, number=86866735,)


class Errors(proto.Message):
    r"""
    Attributes:
        code (str):
            [Output Only] The error type identifier for this error.
        location (str):
            [Output Only] Indicates the field in the request that caused
            the error. This property is optional.
        message (str):
            [Output Only] An optional, human-readable error message.
    """

    code = proto.Field(proto.STRING, number=3059181, optional=True,)
    location = proto.Field(proto.STRING, number=290430901, optional=True,)
    message = proto.Field(proto.STRING, number=418054151, optional=True,)


class Items(proto.Message):
    r"""
    Attributes:
        key (str):
            Key for the metadata entry. Keys must conform to the
            following regexp: [a-zA-Z0-9-_]+, and be less than 128 bytes
            in length. This is reflected as part of a URL in the
            metadata server. Additionally, to avoid ambiguity, keys must
            not conflict with any other metadata keys for the project.
        value (str):
            Value for the metadata entry. These are free-
            orm strings, and only have meaning as
            interpreted by the image running in the
            instance. The only restriction placed on values
            is that their size must be less than or equal to
            262144 bytes (256 KiB).
    """

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class MetadataFilterLabelMatch(proto.Message):
    r"""MetadataFilter label name value pairs that are expected to
    match corresponding labels presented as metadata to the
    loadbalancer.

    Attributes:
        name (str):
            Name of metadata label.
            The name can have a maximum length of 1024
            characters and must be at least 1 character
            long.
        value (str):
            The value of the label must match the
            specified value. value can have a maximum length
            of 1024 characters.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    value = proto.Field(proto.STRING, number=111972721, optional=True,)


class NetworkPeering(proto.Message):
    r"""A network peering attached to a network resource. The message
    includes the peering name, peer network, peering state, and a
    flag indicating whether Google Compute Engine should
    automatically create routes for the peering.

    Attributes:
        auto_create_routes (bool):
            This field will be deprecated soon. Use the
            exchange_subnet_routes field instead. Indicates whether full
            mesh connectivity is created and managed automatically
            between peered networks. Currently this field should always
            be true since Google Compute Engine will automatically
            create and manage subnetwork routes between two networks
            when peering state is ACTIVE.
        exchange_subnet_routes (bool):
            Indicates whether full mesh connectivity is
            created and managed automatically between peered
            networks. Currently this field should always be
            true since Google Compute Engine will
            automatically create and manage subnetwork
            routes between two networks when peering state
            is ACTIVE.
        export_custom_routes (bool):
            Whether to export the custom routes to peer
            network.
        export_subnet_routes_with_public_ip (bool):
            Whether subnet routes with public IP range are exported. The
            default value is true, all subnet routes are exported. The
            IPv4 special-use ranges
            (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are
            always exported to peers and are not controlled by this
            field.
        import_custom_routes (bool):
            Whether to import the custom routes from peer
            network.
        import_subnet_routes_with_public_ip (bool):
            Whether subnet routes with public IP range are imported. The
            default value is false. The IPv4 special-use ranges
            (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are
            always imported from peers and are not controlled by this
            field.
        name (str):
            Name of this peering. Provided by the client when the
            peering is created. The name must comply with RFC1035.
            Specifically, the name must be 1-63 characters long and
            match regular expression ``[a-z]([-a-z0-9]*[a-z0-9])?``. The
            first character must be a lowercase letter, and all the
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        network (str):
            The URL of the peer network. It can be either
            full URL or partial URL. The peer network may
            belong to a different project. If the partial
            URL does not contain project, it is assumed that
            the peer network is in the same project as the
            current network.
        peer_mtu (int):
            Maximum Transmission Unit in bytes.
        state (google.cloud.compute_v1.types.NetworkPeering.State):
            [Output Only] State for the peering, either ``ACTIVE`` or
            ``INACTIVE``. The peering is ``ACTIVE`` when there's a
            matching configuration in the peer network.
        state_details (str):
            [Output Only] Details about the current state of the
            peering.
    """

    class State(proto.Enum):
        r"""[Output Only] State for the peering, either ``ACTIVE`` or
        ``INACTIVE``. The peering is ``ACTIVE`` when there's a matching
        configuration in the peer network.
        """
        UNDEFINED_STATE = 0
        ACTIVE = 314733318
        INACTIVE = 270421099

    auto_create_routes = proto.Field(proto.BOOL, number=57454941, optional=True,)
    exchange_subnet_routes = proto.Field(proto.BOOL, number=26322256, optional=True,)
    export_custom_routes = proto.Field(proto.BOOL, number=60281485, optional=True,)
    export_subnet_routes_with_public_ip = proto.Field(
        proto.BOOL, number=97940834, optional=True,
    )
    import_custom_routes = proto.Field(proto.BOOL, number=197982398, optional=True,)
    import_subnet_routes_with_public_ip = proto.Field(
        proto.BOOL, number=14419729, optional=True,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    peer_mtu = proto.Field(proto.INT32, number=69584721, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)
    state_details = proto.Field(proto.STRING, number=95566996, optional=True,)


class NetworkRoutingConfig(proto.Message):
    r"""A routing configuration attached to a network resource. The
    message includes the list of routers associated with the
    network, and a flag indicating the type of routing behavior to
    enforce network-wide.

    Attributes:
        routing_mode (google.cloud.compute_v1.types.NetworkRoutingConfig.RoutingMode):
            The network-wide routing mode to use. If set
            to REGIONAL, this network's Cloud Routers will
            only advertise routes with subnets of this
            network in the same region as the router. If set
            to GLOBAL, this network's Cloud Routers will
            advertise routes with all subnets of this
            network, across regions.
    """

    class RoutingMode(proto.Enum):
        r"""The network-wide routing mode to use. If set to REGIONAL,
        this network's Cloud Routers will only advertise routes with
        subnets of this network in the same region as the router. If set
        to GLOBAL, this network's Cloud Routers will advertise routes
        with all subnets of this network, across regions.
        """
        UNDEFINED_ROUTING_MODE = 0
        GLOBAL = 494663587
        REGIONAL = 92288543

    routing_mode = proto.Field(
        proto.ENUM, number=475143548, optional=True, enum=RoutingMode,
    )


class Network(proto.Message):
    r"""Represents a VPC Network resource.

    Networks connect resources to each other and to the internet. For
    more information, read Virtual Private Cloud (VPC) Network. (==
    resource_for {$api_version}.networks ==)

    Attributes:
        I_pv4_range (str):
            Deprecated in favor of subnet mode networks.
            The range of internal addresses that are legal
            on this network. This range is a CIDR
            specification, for example: 192.168.0.0/16.
            Provided by the client when the network is
            created.
        auto_create_subnetworks (bool):
            Must be set to create a VPC network. If not
            set, a legacy network is created.
            When set to true, the VPC network is created in
            auto mode. When set to false, the VPC network is
            created in custom mode.
            An auto mode VPC network starts with one subnet
            per region. Each subnet has a predetermined
            range as described in Auto mode VPC network IP
            ranges.
            For custom mode VPC networks, you can add
            subnets using the subnetworks insert method.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.
        gateway_i_pv4 (str):
            [Output Only] The gateway address for default routing out of
            the network, selected by GCP.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#network
            for networks.
        mtu (int):
            Maximum Transmission Unit in bytes. The
            minimum value for this field is 1460 and the
            maximum value is 1500 bytes.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``. The first character must be
            a lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.
        peerings (Sequence[google.cloud.compute_v1.types.NetworkPeering]):
            [Output Only] A list of network peerings for the resource.
        routing_config (google.cloud.compute_v1.types.NetworkRoutingConfig):
            The network-level routing configuration for
            this network. Used by Cloud Router to determine
            what type of network-wide routing behavior to
            enforce.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        subnetworks (Sequence[str]):
            [Output Only] Server-defined fully-qualified URLs for all
            subnetworks in this VPC network.
    """

    I_pv4_range = proto.Field(proto.STRING, number=59234358, optional=True,)
    auto_create_subnetworks = proto.Field(proto.BOOL, number=256156690, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    gateway_i_pv4 = proto.Field(proto.STRING, number=178678877, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    mtu = proto.Field(proto.INT32, number=108462, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    peerings = proto.RepeatedField(
        proto.MESSAGE, number=69883187, message="NetworkPeering",
    )
    routing_config = proto.Field(
        proto.MESSAGE, number=523556059, optional=True, message="NetworkRoutingConfig",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    subnetworks = proto.RepeatedField(proto.STRING, number=415853125,)


class NetworkEndpointGroupAppEngine(proto.Message):
    r"""Configuration for an App Engine network endpoint group (NEG).
    The service is optional, may be provided explicitly or in the
    URL mask. The version is optional and can only be provided
    explicitly or in the URL mask when service is present.  Note:
    App Engine service must be in the same project and located in
    the same region as the Serverless NEG.

    Attributes:
        service (str):
            Optional serving service.
            The service name is case-sensitive and must be
            1-63 characters long.
            Example value: "default", "my-service".
        url_mask (str):
            A template to parse service and version
            fields from a request URL. URL mask allows for
            routing to multiple App Engine services without
            having to create multiple Network Endpoint
            Groups and backend services.  For example, the
            request URLs "foo1-dot-appname.appspot.com/v1"
            and "foo1-dot-appname.appspot.com/v2" can be
            backed by the same Serverless NEG with URL mask
            "-dot-appname.appspot.com/". The URL mask will
            parse them to { service = "foo1", version = "v1"
            } and { service = "foo1", version = "v2" }
            respectively.
        version (str):
            Optional serving version.
            The version name is case-sensitive and must be
            1-100 characters long.
            Example value: "v1", "v2".
    """

    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    url_mask = proto.Field(proto.STRING, number=103352252, optional=True,)
    version = proto.Field(proto.STRING, number=351608024, optional=True,)


class NetworkEndpointGroupCloudFunction(proto.Message):
    r"""Configuration for a Cloud Function network endpoint group
    (NEG). The function must be provided explicitly or in the URL
    mask.  Note: Cloud Function must be in the same project and
    located in the same region as the Serverless NEG.

    Attributes:
        function (str):
            A user-defined name of the Cloud Function.
            The function name is case-sensitive and must be
            1-63 characters long.
            Example value: "func1".
        url_mask (str):
            A template to parse function field from a
            request URL. URL mask allows for routing to
            multiple Cloud Functions without having to
            create multiple Network Endpoint Groups and
            backend services.  For example, request URLs
            "mydomain.com/function1" and
            "mydomain.com/function2" can be backed by the
            same Serverless NEG with URL mask "/". The URL
            mask will parse them to { function = "function1"
            } and { function = "function2" } respectively.
    """

    function = proto.Field(proto.STRING, number=307196888, optional=True,)
    url_mask = proto.Field(proto.STRING, number=103352252, optional=True,)


class NetworkEndpointGroupCloudRun(proto.Message):
    r"""Configuration for a Cloud Run network endpoint group (NEG).
    The service must be provided explicitly or in the URL mask. The
    tag is optional, may be provided explicitly or in the URL mask.
    Note: Cloud Run service must be in the same project and located
    in the same region as the Serverless NEG.

    Attributes:
        service (str):
            Cloud Run service is the main resource of
            Cloud Run.
            The service must be 1-63 characters long, and
            comply with RFC1035.
            Example value: "run-service".
        tag (str):
            Optional Cloud Run tag represents the "named-
            evision" to provide additional fine-grained
            traffic routing information.  The tag must be
            1-63 characters long, and comply with RFC1035.
            Example value: "revision-0010".
        url_mask (str):
            A template to parse service and tag fields
            from a request URL. URL mask allows for routing
            to multiple Run services without having to
            create multiple network endpoint groups and
            backend services.  For example, request URLs
            "foo1.domain.com/bar1" and
            "foo1.domain.com/bar2" can be backed by the same
            Serverless Network Endpoint Group (NEG) with URL
            mask ".domain.com/". The URL mask will parse
            them to { service="bar1", tag="foo1" } and {
            service="bar2", tag="foo2" } respectively.
    """

    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    tag = proto.Field(proto.STRING, number=114586, optional=True,)
    url_mask = proto.Field(proto.STRING, number=103352252, optional=True,)


class NetworkEndpointGroup(proto.Message):
    r"""Represents a collection of network endpoints.

    A network endpoint group (NEG) defines how a set of endpoints should
    be reached, whether they are reachable, and where they are located.
    For more information about using NEGs, see Setting up external
    HTTP(S) Load Balancing with internet NEGs, Setting up zonal NEGs, or
    Setting up external HTTP(S) Load Balancing with serverless NEGs. (==
    resource_for {$api_version}.networkEndpointGroups ==) (==
    resource_for {$api_version}.globalNetworkEndpointGroups ==) (==
    resource_for {$api_version}.regionNetworkEndpointGroups ==)

    Attributes:
        annotations (Sequence[google.cloud.compute_v1.types.NetworkEndpointGroup.AnnotationsEntry]):
            Metadata defined as annotations on the
            network endpoint group.
        app_engine (google.cloud.compute_v1.types.NetworkEndpointGroupAppEngine):
            Only valid when networkEndpointType is
            "SERVERLESS". Only one of cloudRun, appEngine or
            cloudFunction may be set.
        cloud_function (google.cloud.compute_v1.types.NetworkEndpointGroupCloudFunction):
            Only valid when networkEndpointType is
            "SERVERLESS". Only one of cloudRun, appEngine or
            cloudFunction may be set.
        cloud_run (google.cloud.compute_v1.types.NetworkEndpointGroupCloudRun):
            Only valid when networkEndpointType is
            "SERVERLESS". Only one of cloudRun, appEngine or
            cloudFunction may be set.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        default_port (int):
            The default port used if the port number is
            not specified in the network endpoint.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#networkEndpointGroup for network endpoint group.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        network (str):
            The URL of the network to which all network
            endpoints in the NEG belong. Uses "default"
            project network if unspecified.
        network_endpoint_type (google.cloud.compute_v1.types.NetworkEndpointGroup.NetworkEndpointType):
            Type of network endpoints in this network endpoint group.
            Can be one of GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT,
            INTERNET_FQDN_PORT, INTERNET_IP_PORT, or SERVERLESS.
        region (str):
            [Output Only] The URL of the region where the network
            endpoint group is located.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        size (int):
            [Output only] Number of network endpoints in the network
            endpoint group.
        subnetwork (str):
            Optional URL of the subnetwork to which all
            network endpoints in the NEG belong.
        zone (str):
            [Output Only] The URL of the zone where the network endpoint
            group is located.
    """

    class NetworkEndpointType(proto.Enum):
        r"""Type of network endpoints in this network endpoint group. Can be one
        of GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT,
        INTERNET_IP_PORT, or SERVERLESS.
        """
        UNDEFINED_NETWORK_ENDPOINT_TYPE = 0
        GCE_VM_IP = 401880793
        GCE_VM_IP_PORT = 501838375
        INTERNET_FQDN_PORT = 404154477
        INTERNET_IP_PORT = 477719963
        NON_GCP_PRIVATE_IP_PORT = 336447968
        SERVERLESS = 270492508

    annotations = proto.MapField(proto.STRING, proto.STRING, number=112032548,)
    app_engine = proto.Field(
        proto.MESSAGE,
        number=340788768,
        optional=True,
        message="NetworkEndpointGroupAppEngine",
    )
    cloud_function = proto.Field(
        proto.MESSAGE,
        number=519893666,
        optional=True,
        message="NetworkEndpointGroupCloudFunction",
    )
    cloud_run = proto.Field(
        proto.MESSAGE,
        number=111060353,
        optional=True,
        message="NetworkEndpointGroupCloudRun",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    default_port = proto.Field(proto.INT32, number=423377855, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    network_endpoint_type = proto.Field(
        proto.ENUM, number=118301523, optional=True, enum=NetworkEndpointType,
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    size = proto.Field(proto.INT32, number=3530753, optional=True,)
    subnetwork = proto.Field(proto.STRING, number=307827694, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class NetworkEndpointGroupsScopedList(proto.Message):
    r"""
    Attributes:
        network_endpoint_groups (Sequence[google.cloud.compute_v1.types.NetworkEndpointGroup]):
            [Output Only] The list of network endpoint groups that are
            contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that replaces the
            list of network endpoint groups when the list is empty.
    """

    network_endpoint_groups = proto.RepeatedField(
        proto.MESSAGE, number=29346733, message="NetworkEndpointGroup",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NetworkEndpointGroupAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NetworkEndpointGroupAggregatedList.ItemsEntry]):
            A list of NetworkEndpointGroupsScopedList
            resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#networkEndpointGroupAggregatedList for aggregated
            lists of network endpoint groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="NetworkEndpointGroupsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NetworkEndpointGroupList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NetworkEndpointGroup]):
            A list of NetworkEndpointGroup resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#networkEndpointGroupList for network endpoint group
            lists.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="NetworkEndpointGroup",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NetworkEndpointGroupsAttachEndpointsRequest(proto.Message):
    r"""
    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be attached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class NetworkEndpointGroupsDetachEndpointsRequest(proto.Message):
    r"""
    Attributes:
        network_endpoints (Sequence[google.cloud.compute_v1.types.NetworkEndpoint]):
            The list of network endpoints to be detached.
    """

    network_endpoints = proto.RepeatedField(
        proto.MESSAGE, number=149850285, message="NetworkEndpoint",
    )


class NetworkEndpointGroupsListEndpointsRequest(proto.Message):
    r"""
    Attributes:
        health_status (google.cloud.compute_v1.types.NetworkEndpointGroupsListEndpointsRequest.HealthStatus):
            Optional query parameter for showing the
            health status of each network endpoint. Valid
            options are SKIP or SHOW. If you don't specify
            this parameter, the health status of network
            endpoints will not be provided.
    """

    class HealthStatus(proto.Enum):
        r"""Optional query parameter for showing the health status of
        each network endpoint. Valid options are SKIP or SHOW. If you
        don't specify this parameter, the health status of network
        endpoints will not be provided.
        """
        UNDEFINED_HEALTH_STATUS = 0
        SHOW = 2544381
        SKIP = 2547071

    health_status = proto.Field(
        proto.ENUM, number=380545845, optional=True, enum=HealthStatus,
    )


class NetworkEndpointWithHealthStatus(proto.Message):
    r"""
    Attributes:
        healths (Sequence[google.cloud.compute_v1.types.HealthStatusForNetworkEndpoint]):
            [Output only] The health status of network endpoint;
        network_endpoint (google.cloud.compute_v1.types.NetworkEndpoint):
            [Output only] The network endpoint;
    """

    healths = proto.RepeatedField(
        proto.MESSAGE, number=258689431, message="HealthStatusForNetworkEndpoint",
    )
    network_endpoint = proto.Field(
        proto.MESSAGE, number=56789126, optional=True, message="NetworkEndpoint",
    )


class NetworkEndpointGroupsListNetworkEndpoints(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NetworkEndpointWithHealthStatus]):
            A list of NetworkEndpointWithHealthStatus
            resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#networkEndpointGroupsListNetworkEndpoints for the
            list of network endpoints in the specified network endpoint
            group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="NetworkEndpointWithHealthStatus",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NetworkList(proto.Message):
    r"""Contains a list of networks.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Network]):
            A list of Network resources.
        kind (str):
            [Output Only] Type of resource. Always compute#networkList
            for lists of networks.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Network",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NetworksAddPeeringRequest(proto.Message):
    r"""
    Attributes:
        auto_create_routes (bool):
            This field will be deprecated soon. Use
            exchange_subnet_routes in network_peering instead. Indicates
            whether full mesh connectivity is created and managed
            automatically between peered networks. Currently this field
            should always be true since Google Compute Engine will
            automatically create and manage subnetwork routes between
            two networks when peering state is ACTIVE.
        name (str):
            Name of the peering, which should conform to
            RFC1035.
        network_peering (google.cloud.compute_v1.types.NetworkPeering):
            Network peering parameters. In order to specify route
            policies for peering using import and export custom routes,
            you must specify all peering related parameters (name, peer
            network, exchange_subnet_routes) in the network_peering
            field. The corresponding fields in NetworksAddPeeringRequest
            will be deprecated soon.
        peer_network (str):
            URL of the peer network. It can be either
            full URL or partial URL. The peer network may
            belong to a different project. If the partial
            URL does not contain project, it is assumed that
            the peer network is in the same project as the
            current network.
    """

    auto_create_routes = proto.Field(proto.BOOL, number=57454941, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network_peering = proto.Field(
        proto.MESSAGE, number=328926767, optional=True, message="NetworkPeering",
    )
    peer_network = proto.Field(proto.STRING, number=500625489, optional=True,)


class NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy(proto.Message):
    r"""
    Attributes:
        display_name (str):
            [Output Only] Deprecated, please use short name instead. The
            display name of the firewall policy.
        name (str):
            [Output Only] The name of the firewall policy.
        rules (Sequence[google.cloud.compute_v1.types.FirewallPolicyRule]):
            The rules that apply to the network.
        short_name (str):
            [Output Only] The short name of the firewall policy.
        type_ (google.cloud.compute_v1.types.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy.Type):
            [Output Only] The type of the firewall policy.
    """

    class Type(proto.Enum):
        r"""[Output Only] The type of the firewall policy."""
        UNDEFINED_TYPE = 0
        HIERARCHY = 69902869
        NETWORK = 413984270
        UNSPECIFIED = 526786327

    display_name = proto.Field(proto.STRING, number=4473832, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    rules = proto.RepeatedField(
        proto.MESSAGE, number=108873975, message="FirewallPolicyRule",
    )
    short_name = proto.Field(proto.STRING, number=492051566, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class NetworksGetEffectiveFirewallsResponse(proto.Message):
    r"""
    Attributes:
        firewall_policys (Sequence[google.cloud.compute_v1.types.NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy]):
            Effective firewalls from firewall policy.
        firewalls (Sequence[google.cloud.compute_v1.types.Firewall]):
            Effective firewalls on the network.
    """

    firewall_policys = proto.RepeatedField(
        proto.MESSAGE,
        number=410985794,
        message="NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    )
    firewalls = proto.RepeatedField(
        proto.MESSAGE, number=272245619, message="Firewall",
    )


class NetworksRemovePeeringRequest(proto.Message):
    r"""
    Attributes:
        name (str):
            Name of the peering, which should conform to
            RFC1035.
    """

    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class NetworksUpdatePeeringRequest(proto.Message):
    r"""
    Attributes:
        network_peering (google.cloud.compute_v1.types.NetworkPeering):

    """

    network_peering = proto.Field(
        proto.MESSAGE, number=328926767, optional=True, message="NetworkPeering",
    )


class NodeGroupAutoscalingPolicy(proto.Message):
    r"""
    Attributes:
        max_nodes (int):
            The maximum number of nodes that the group
            should have. Must be set if autoscaling is
            enabled. Maximum value allowed is 100.
        min_nodes (int):
            The minimum number of nodes that the group
            should have.
        mode (google.cloud.compute_v1.types.NodeGroupAutoscalingPolicy.Mode):
            The autoscaling mode. Set to one of: ON, OFF, or
            ONLY_SCALE_OUT. For more information, see Autoscaler modes.
    """

    class Mode(proto.Enum):
        r"""The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For
        more information, see Autoscaler modes.
        """
        UNDEFINED_MODE = 0
        MODE_UNSPECIFIED = 371348091
        OFF = 78159
        ON = 2527
        ONLY_SCALE_OUT = 152713670

    max_nodes = proto.Field(proto.INT32, number=297762838, optional=True,)
    min_nodes = proto.Field(proto.INT32, number=533370500, optional=True,)
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)


class NodeGroupMaintenanceWindow(proto.Message):
    r"""Time window specified for daily maintenance operations. GCE's
    internal maintenance will be performed within this window.

    Attributes:
        maintenance_duration (google.cloud.compute_v1.types.Duration):
            [Output only] A predetermined duration for the window,
            automatically chosen to be the smallest possible in the
            given scenario.
        start_time (str):
            Start time of the window. This must be in UTC
            format that resolves to one of 00:00, 04:00,
            08:00, 12:00, 16:00, or 20:00. For example, both
            13:00-5 and 08:00 are valid.
    """

    maintenance_duration = proto.Field(
        proto.MESSAGE, number=525291840, optional=True, message="Duration",
    )
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)


class NodeGroup(proto.Message):
    r"""Represent a sole-tenant Node Group resource.

    A sole-tenant node is a physical server that is dedicated to hosting
    VM instances only for your specific project. Use sole-tenant nodes
    to keep your instances physically separated from instances in other
    projects, or to group your instances together on the same host
    hardware. For more information, read Sole-tenant nodes. (==
    resource_for {$api_version}.nodeGroups ==)

    Attributes:
        autoscaling_policy (google.cloud.compute_v1.types.NodeGroupAutoscalingPolicy):
            Specifies how autoscaling should behave.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):

        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#nodeGroup for node group.
        location_hint (str):
            An opaque location hint used to place the Node close to
            other resources. This field is for use by internal tools
            that use the public API. The location hint here on the
            NodeGroup overrides any location_hint present in the
            NodeTemplate.
        maintenance_policy (google.cloud.compute_v1.types.NodeGroup.MaintenancePolicy):
            Specifies how to handle instances when a node in the group
            undergoes maintenance. Set to one of: DEFAULT,
            RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default
            value is DEFAULT. For more information, see Maintenance
            policies.
        maintenance_window (google.cloud.compute_v1.types.NodeGroupMaintenanceWindow):

        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The resource name must be
            1-63 characters long, and comply with RFC1035. Specifically,
            the name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        node_template (str):
            URL of the node template to create the node
            group from.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        size (int):
            [Output Only] The total number of nodes in the node group.
        status (google.cloud.compute_v1.types.NodeGroup.Status):

        zone (str):
            [Output Only] The name of the zone where the node group
            resides, such as us-central1-a.
    """

    class MaintenancePolicy(proto.Enum):
        r"""Specifies how to handle instances when a node in the group undergoes
        maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or
        MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more
        information, see Maintenance policies.
        """
        UNDEFINED_MAINTENANCE_POLICY = 0
        DEFAULT = 115302945
        MAINTENANCE_POLICY_UNSPECIFIED = 72964182
        MIGRATE_WITHIN_NODE_GROUP = 153483394
        RESTART_IN_PLACE = 228647325

    class Status(proto.Enum):
        r""""""
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        INVALID = 530283991
        READY = 77848963

    autoscaling_policy = proto.Field(
        proto.MESSAGE,
        number=221950041,
        optional=True,
        message="NodeGroupAutoscalingPolicy",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    maintenance_policy = proto.Field(
        proto.ENUM, number=528327646, optional=True, enum=MaintenancePolicy,
    )
    maintenance_window = proto.Field(
        proto.MESSAGE,
        number=186374812,
        optional=True,
        message="NodeGroupMaintenanceWindow",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    node_template = proto.Field(proto.STRING, number=323154455, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    size = proto.Field(proto.INT32, number=3530753, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class NodeGroupsScopedList(proto.Message):
    r"""
    Attributes:
        node_groups (Sequence[google.cloud.compute_v1.types.NodeGroup]):
            [Output Only] A list of node groups contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            nodeGroup list is empty.
    """

    node_groups = proto.RepeatedField(
        proto.MESSAGE, number=73188017, message="NodeGroup",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeGroupAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeGroupAggregatedList.ItemsEntry]):
            A list of NodeGroupsScopedList resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#nodeGroupAggregatedList for aggregated lists of node
            groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="NodeGroupsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeGroupList(proto.Message):
    r"""Contains a list of nodeGroups.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeGroup]):
            A list of NodeGroup resources.
        kind (str):
            [Output Only] Type of resource.Always compute#nodeGroupList
            for lists of node groups.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="NodeGroup",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ServerBinding(proto.Message):
    r"""
    Attributes:
        type_ (google.cloud.compute_v1.types.ServerBinding.Type):

    """

    class Type(proto.Enum):
        r""""""
        UNDEFINED_TYPE = 0
        RESTART_NODE_ON_ANY_SERVER = 502950985
        RESTART_NODE_ON_MINIMAL_SERVERS = 204166495
        SERVER_BINDING_TYPE_UNSPECIFIED = 180825512

    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class NodeGroupNode(proto.Message):
    r"""
    Attributes:
        accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            Accelerators for this node.
        cpu_overcommit_type (google.cloud.compute_v1.types.NodeGroupNode.CpuOvercommitType):
            CPU overcommit.
        disks (Sequence[google.cloud.compute_v1.types.LocalDisk]):
            Local disk configurations.
        instances (Sequence[str]):
            Instances scheduled on this node.
        name (str):
            The name of the node.
        node_type (str):
            The type of this node.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        server_binding (google.cloud.compute_v1.types.ServerBinding):
            Binding properties for the physical server.
        server_id (str):
            Server ID associated with this node.
        status (google.cloud.compute_v1.types.NodeGroupNode.Status):

    """

    class CpuOvercommitType(proto.Enum):
        r"""CPU overcommit."""
        UNDEFINED_CPU_OVERCOMMIT_TYPE = 0
        CPU_OVERCOMMIT_TYPE_UNSPECIFIED = 520665615
        ENABLED = 182130465
        NONE = 2402104

    class Status(proto.Enum):
        r""""""
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        INVALID = 530283991
        READY = 77848963
        REPAIRING = 413483285

    accelerators = proto.RepeatedField(
        proto.MESSAGE, number=269577064, message="AcceleratorConfig",
    )
    cpu_overcommit_type = proto.Field(
        proto.ENUM, number=247727959, optional=True, enum=CpuOvercommitType,
    )
    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="LocalDisk",)
    instances = proto.RepeatedField(proto.STRING, number=29097598,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    node_type = proto.Field(proto.STRING, number=465832791, optional=True,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    server_binding = proto.Field(
        proto.MESSAGE, number=208179593, optional=True, message="ServerBinding",
    )
    server_id = proto.Field(proto.STRING, number=339433367, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class NodeGroupsAddNodesRequest(proto.Message):
    r"""
    Attributes:
        additional_node_count (int):
            Count of additional nodes to be added to the
            node group.
    """

    additional_node_count = proto.Field(proto.INT32, number=134997930, optional=True,)


class NodeGroupsDeleteNodesRequest(proto.Message):
    r"""
    Attributes:
        nodes (Sequence[str]):
            Names of the nodes to delete.
    """

    nodes = proto.RepeatedField(proto.STRING, number=104993457,)


class NodeGroupsListNodes(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeGroupNode]):
            A list of Node resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute.nodeGroupsListNodes for the list of nodes in the
            specified node group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="NodeGroupNode",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeGroupsSetNodeTemplateRequest(proto.Message):
    r"""
    Attributes:
        node_template (str):
            Full or partial URL of the node template
            resource to be updated for this node group.
    """

    node_template = proto.Field(proto.STRING, number=323154455, optional=True,)


class NodeTemplateNodeTypeFlexibility(proto.Message):
    r"""
    Attributes:
        cpus (str):

        local_ssd (str):

        memory (str):

    """

    cpus = proto.Field(proto.STRING, number=3060683, optional=True,)
    local_ssd = proto.Field(proto.STRING, number=405741360, optional=True,)
    memory = proto.Field(proto.STRING, number=532856065, optional=True,)


class NodeTemplate(proto.Message):
    r"""Represent a sole-tenant Node Template resource.

    You can use a template to define properties for nodes in a node
    group. For more information, read Creating node groups and
    instances. (== resource_for {$api_version}.nodeTemplates ==)

    Attributes:
        accelerators (Sequence[google.cloud.compute_v1.types.AcceleratorConfig]):

        cpu_overcommit_type (google.cloud.compute_v1.types.NodeTemplate.CpuOvercommitType):
            CPU overcommit.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        disks (Sequence[google.cloud.compute_v1.types.LocalDisk]):

        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#nodeTemplate for node templates.
        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The resource name must be
            1-63 characters long, and comply with RFC1035. Specifically,
            the name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        node_affinity_labels (Sequence[google.cloud.compute_v1.types.NodeTemplate.NodeAffinityLabelsEntry]):
            Labels to use for node affinity, which will
            be used in instance scheduling.
        node_type (str):
            The node type to use for nodes group that are
            created from this template.
        node_type_flexibility (google.cloud.compute_v1.types.NodeTemplateNodeTypeFlexibility):
            The flexible properties of the desired node type. Node
            groups that use this node template will create nodes of a
            type that matches these properties.

            This field is mutually exclusive with the node_type
            property; you can only define one or the other, but not
            both.
        region (str):
            [Output Only] The name of the region where the node template
            resides, such as us-central1.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        server_binding (google.cloud.compute_v1.types.ServerBinding):
            Sets the binding properties for the physical server. Valid
            values include:

            -  [Default] RESTART_NODE_ON_ANY_SERVER: Restarts VMs on any
               available physical server
            -  RESTART_NODE_ON_MINIMAL_SERVER: Restarts VMs on the same
               physical server whenever possible

            See Sole-tenant node options for more information.
        status (google.cloud.compute_v1.types.NodeTemplate.Status):
            [Output Only] The status of the node template. One of the
            following values: CREATING, READY, and DELETING.
        status_message (str):
            [Output Only] An optional, human-readable explanation of the
            status.
    """

    class CpuOvercommitType(proto.Enum):
        r"""CPU overcommit."""
        UNDEFINED_CPU_OVERCOMMIT_TYPE = 0
        CPU_OVERCOMMIT_TYPE_UNSPECIFIED = 520665615
        ENABLED = 182130465
        NONE = 2402104

    class Status(proto.Enum):
        r"""[Output Only] The status of the node template. One of the following
        values: CREATING, READY, and DELETING.
        """
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        INVALID = 530283991
        READY = 77848963

    accelerators = proto.RepeatedField(
        proto.MESSAGE, number=269577064, message="AcceleratorConfig",
    )
    cpu_overcommit_type = proto.Field(
        proto.ENUM, number=247727959, optional=True, enum=CpuOvercommitType,
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disks = proto.RepeatedField(proto.MESSAGE, number=95594102, message="LocalDisk",)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    node_affinity_labels = proto.MapField(proto.STRING, proto.STRING, number=339007161,)
    node_type = proto.Field(proto.STRING, number=465832791, optional=True,)
    node_type_flexibility = proto.Field(
        proto.MESSAGE,
        number=315257905,
        optional=True,
        message="NodeTemplateNodeTypeFlexibility",
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    server_binding = proto.Field(
        proto.MESSAGE, number=208179593, optional=True, message="ServerBinding",
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_message = proto.Field(proto.STRING, number=297428154, optional=True,)


class NodeTemplatesScopedList(proto.Message):
    r"""
    Attributes:
        node_templates (Sequence[google.cloud.compute_v1.types.NodeTemplate]):
            [Output Only] A list of node templates contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            node templates list is empty.
    """

    node_templates = proto.RepeatedField(
        proto.MESSAGE, number=354111804, message="NodeTemplate",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeTemplateAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeTemplateAggregatedList.ItemsEntry]):
            A list of NodeTemplatesScopedList resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#nodeTemplateAggregatedList for aggregated lists of
            node templates.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="NodeTemplatesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeTemplateList(proto.Message):
    r"""Contains a list of node templates.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeTemplate]):
            A list of NodeTemplate resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#nodeTemplateList for lists of node templates.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="NodeTemplate",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeType(proto.Message):
    r"""Represent a sole-tenant Node Type resource.

    Each node within a node group must have a node type. A node type
    specifies the total amount of cores and memory for that node.
    Currently, the only available node type is n1-node-96-624 node type
    that has 96 vCPUs and 624 GB of memory, available in multiple zones.
    For more information read Node types. (== resource_for
    {$api_version}.nodeTypes ==)

    Attributes:
        cpu_platform (str):
            [Output Only] The CPU platform used by this node type.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            node type.
        description (str):
            [Output Only] An optional textual description of the
            resource.
        guest_cpus (int):
            [Output Only] The number of virtual CPUs that are available
            to the node type.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#nodeType for node types.
        local_ssd_gb (int):
            [Output Only] Local SSD available to the node type, defined
            in GB.
        memory_mb (int):
            [Output Only] The amount of physical memory available to the
            node type, defined in MB.
        name (str):
            [Output Only] Name of the resource.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        zone (str):
            [Output Only] The name of the zone where the node type
            resides, such as us-central1-a.
    """

    cpu_platform = proto.Field(proto.STRING, number=410285354, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    guest_cpus = proto.Field(proto.INT32, number=393356754, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    local_ssd_gb = proto.Field(proto.INT32, number=329237578, optional=True,)
    memory_mb = proto.Field(proto.INT32, number=116001171, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class NodeTypesScopedList(proto.Message):
    r"""
    Attributes:
        node_types (Sequence[google.cloud.compute_v1.types.NodeType]):
            [Output Only] A list of node types contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            node types list is empty.
    """

    node_types = proto.RepeatedField(
        proto.MESSAGE, number=482172924, message="NodeType",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeTypeAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeTypeAggregatedList.ItemsEntry]):
            A list of NodeTypesScopedList resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#nodeTypeAggregatedList for aggregated lists of node
            types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="NodeTypesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NodeTypeList(proto.Message):
    r"""Contains a list of node types.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NodeType]):
            A list of NodeType resources.
        kind (str):
            [Output Only] Type of resource.Always compute#nodeTypeList
            for lists of node types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="NodeType",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class NotificationEndpointGrpcSettings(proto.Message):
    r"""Represents a gRPC setting that describes one gRPC
    notification endpoint and the retry duration attempting to send
    notification to this endpoint.

    Attributes:
        authority (str):
            Optional. If specified, this field is used to
            set the authority header by the sender of
            notifications. See
            https://tools.ietf.org/html/rfc7540#section-8.1.2.3
        endpoint (str):
            Endpoint to which gRPC notifications are
            sent. This must be a valid gRPCLB DNS name.
        payload_name (str):
            Optional. If specified, this field is used to
            populate the "name" field in gRPC requests.
        resend_interval (google.cloud.compute_v1.types.Duration):
            Optional. This field is used to configure how
            often to send a full update of all non-healthy
            backends. If unspecified, full updates are not
            sent. If specified, must be in the range between
            600 seconds to 3600 seconds. Nanos are
            disallowed.
        retry_duration_sec (int):
            How much time (in seconds) is spent
            attempting notification retries until a
            successful response is received. Default is 30s.
            Limit is 20m (1200s). Must be a positive number.
    """

    authority = proto.Field(proto.STRING, number=401868611, optional=True,)
    endpoint = proto.Field(proto.STRING, number=130489749, optional=True,)
    payload_name = proto.Field(proto.STRING, number=300358300, optional=True,)
    resend_interval = proto.Field(
        proto.MESSAGE, number=478288969, optional=True, message="Duration",
    )
    retry_duration_sec = proto.Field(proto.UINT32, number=115681117, optional=True,)


class NotificationEndpoint(proto.Message):
    r"""Represents a notification endpoint.

    A notification endpoint resource defines an endpoint to receive
    notifications when there are status changes detected by the
    associated health check service.

    For more information, see Health checks overview. (== resource_for
    {$api_version}.notificationEndpoint ==) (== resource_for
    {$api_version}.regionNotificationEndpoints ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        grpc_settings (google.cloud.compute_v1.types.NotificationEndpointGrpcSettings):
            Settings of the gRPC notification endpoint
            including the endpoint URL and the retry
            duration.
        id (int):
            [Output Only] A unique identifier for this resource type.
            The server generates this identifier.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#notificationEndpoint for notification endpoints.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        region (str):
            [Output Only] URL of the region where the notification
            endpoint resides. This field applies only to the regional
            resource. You must specify this field as part of the HTTP
            request URL. It is not settable as a field in the request
            body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    grpc_settings = proto.Field(
        proto.MESSAGE,
        number=456139556,
        optional=True,
        message="NotificationEndpointGrpcSettings",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class NotificationEndpointList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.NotificationEndpoint]):
            A list of NotificationEndpoint resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#notificationEndpoint for notification endpoints.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="NotificationEndpoint",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Error(proto.Message):
    r"""[Output Only] If errors are generated during processing of the
    operation, this field will be populated.

    Attributes:
        errors (Sequence[google.cloud.compute_v1.types.Errors]):
            [Output Only] The array of errors encountered while
            processing this operation.
    """

    errors = proto.RepeatedField(proto.MESSAGE, number=315977579, message="Errors",)


class Warnings(proto.Message):
    r"""
    Attributes:
        code (google.cloud.compute_v1.types.Warnings.Code):
            [Output Only] A warning code, if applicable. For example,
            Compute Engine returns NO_RESULTS_ON_PAGE if there are no
            results in the response.
        data (Sequence[google.cloud.compute_v1.types.Data]):
            [Output Only] Metadata about this warning in key: value
            format. For example: "data": [ { "key": "scope", "value":
            "zones/us-east1-d" }
        message (str):
            [Output Only] A human-readable description of the warning
            code.
    """

    class Code(proto.Enum):
        r"""[Output Only] A warning code, if applicable. For example, Compute
        Engine returns NO_RESULTS_ON_PAGE if there are no results in the
        response.
        """
        UNDEFINED_CODE = 0
        CLEANUP_FAILED = 150308440
        DEPRECATED_RESOURCE_USED = 391835586
        DEPRECATED_TYPE_USED = 346526230
        DISK_SIZE_LARGER_THAN_IMAGE_SIZE = 369442967
        EXPERIMENTAL_TYPE_USED = 451954443
        EXTERNAL_API_WARNING = 175546307
        FIELD_VALUE_OVERRIDEN = 329669423
        INJECTED_KERNELS_DEPRECATED = 417377419
        LARGE_DEPLOYMENT_WARNING = 481440678
        MISSING_TYPE_DEPENDENCY = 344505463
        NEXT_HOP_ADDRESS_NOT_ASSIGNED = 324964999
        NEXT_HOP_CANNOT_IP_FORWARD = 383382887
        NEXT_HOP_INSTANCE_NOT_FOUND = 464250446
        NEXT_HOP_INSTANCE_NOT_ON_NETWORK = 243758146
        NEXT_HOP_NOT_RUNNING = 417081265
        NOT_CRITICAL_ERROR = 105763924
        NO_RESULTS_ON_PAGE = 30036744
        PARTIAL_SUCCESS = 39966469
        REQUIRED_TOS_AGREEMENT = 3745539
        RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING = 496728641
        RESOURCE_NOT_DELETED = 168598460
        SCHEMA_VALIDATION_IGNORED = 275245642
        SINGLE_INSTANCE_PROPERTY_TEMPLATE = 268305617
        UNDECLARED_PROPERTIES = 390513439
        UNREACHABLE = 13328052

    code = proto.Field(proto.ENUM, number=3059181, optional=True, enum=Code,)
    data = proto.RepeatedField(proto.MESSAGE, number=3076010, message="Data",)
    message = proto.Field(proto.STRING, number=418054151, optional=True,)


class Operation(proto.Message):
    r"""Represents an Operation resource.

    Google Compute Engine has three Operation resources:

    -  `Global </compute/docs/reference/rest/{$api_version}/globalOperations>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionOperations>`__
       \*
       `Zonal </compute/docs/reference/rest/{$api_version}/zoneOperations>`__

    You can use an operation resource to manage asynchronous API
    requests. For more information, read Handling API responses.

    Operations can be global, regional or zonal.

    -  For global operations, use the ``globalOperations`` resource.
    -  For regional operations, use the ``regionOperations`` resource.
    -  For zonal operations, use the ``zonalOperations`` resource.

    For more information, read Global, Regional, and Zonal Resources.
    (== resource_for {$api_version}.globalOperations ==) (==
    resource_for {$api_version}.regionOperations ==) (== resource_for
    {$api_version}.zoneOperations ==)

    Attributes:
        client_operation_id (str):
            [Output Only] The value of ``requestId`` if you provided it
            in the request. Not present otherwise.
        creation_timestamp (str):
            [Deprecated] This field is deprecated.
        description (str):
            [Output Only] A textual description of the operation, which
            is set when the operation is created.
        end_time (str):
            [Output Only] The time that this operation was completed.
            This value is in RFC3339 text format.
        error (google.cloud.compute_v1.types.Error):
            [Output Only] If errors are generated during processing of
            the operation, this field will be populated.
        http_error_message (str):
            [Output Only] If the operation fails, this field contains
            the HTTP error message that was returned, such as
            ``NOT FOUND``.
        http_error_status_code (int):
            [Output Only] If the operation fails, this field contains
            the HTTP error status code that was returned. For example, a
            ``404`` means the resource was not found.
        id (int):
            [Output Only] The unique identifier for the operation. This
            identifier is defined by the server.
        insert_time (str):
            [Output Only] The time that this operation was requested.
            This value is in RFC3339 text format.
        kind (str):
            [Output Only] Type of the resource. Always
            ``compute#operation`` for Operation resources.
        name (str):
            [Output Only] Name of the operation.
        operation_group_id (str):
            [Output Only] An ID that represents a group of operations,
            such as when a group of operations results from a
            ``bulkInsert`` API request.
        operation_type (str):
            [Output Only] The type of operation, such as ``insert``,
            ``update``, or ``delete``, and so on.
        progress (int):
            [Output Only] An optional progress indicator that ranges
            from 0 to 100. There is no requirement that this be linear
            or support any granularity of operations. This should not be
            used to guess when the operation will be complete. This
            number should monotonically increase as the operation
            progresses.
        region (str):
            [Output Only] The URL of the region where the operation
            resides. Only applicable when performing regional
            operations.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        start_time (str):
            [Output Only] The time that this operation was started by
            the server. This value is in RFC3339 text format.
        status (google.cloud.compute_v1.types.Operation.Status):
            [Output Only] The status of the operation, which can be one
            of the following: ``PENDING``, ``RUNNING``, or ``DONE``.
        status_message (str):
            [Output Only] An optional textual description of the current
            status of the operation.
        target_id (int):
            [Output Only] The unique target ID, which identifies a
            specific incarnation of the target resource.
        target_link (str):
            [Output Only] The URL of the resource that the operation
            modifies. For operations related to creating a snapshot,
            this points to the persistent disk that the snapshot was
            created from.
        user (str):
            [Output Only] User who requested the operation, for example:
            ``user@example.com``.
        warnings (Sequence[google.cloud.compute_v1.types.Warnings]):
            [Output Only] If warning messages are generated during
            processing of the operation, this field will be populated.
        zone (str):
            [Output Only] The URL of the zone where the operation
            resides. Only applicable when performing per-zone
            operations.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the operation, which can be one of the
        following: ``PENDING``, ``RUNNING``, or ``DONE``.
        """
        UNDEFINED_STATUS = 0
        DONE = 2104194
        PENDING = 35394935
        RUNNING = 121282975

    client_operation_id = proto.Field(proto.STRING, number=297240295, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    end_time = proto.Field(proto.STRING, number=114938801, optional=True,)
    error = proto.Field(proto.MESSAGE, number=96784904, optional=True, message="Error",)
    http_error_message = proto.Field(proto.STRING, number=202521945, optional=True,)
    http_error_status_code = proto.Field(proto.INT32, number=312345196, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    insert_time = proto.Field(proto.STRING, number=433722515, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    operation_group_id = proto.Field(proto.STRING, number=40171187, optional=True,)
    operation_type = proto.Field(proto.STRING, number=177650450, optional=True,)
    progress = proto.Field(proto.INT32, number=72663597, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    status_message = proto.Field(proto.STRING, number=297428154, optional=True,)
    target_id = proto.Field(proto.UINT64, number=258165385, optional=True,)
    target_link = proto.Field(proto.STRING, number=62671336, optional=True,)
    user = proto.Field(proto.STRING, number=3599307, optional=True,)
    warnings = proto.RepeatedField(proto.MESSAGE, number=498091095, message="Warnings",)
    zone = proto.Field(proto.STRING, number=3744684, optional=True,)


class OperationsScopedList(proto.Message):
    r"""
    Attributes:
        operations (Sequence[google.cloud.compute_v1.types.Operation]):
            [Output Only] A list of operations contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of operations when the list is empty.
    """

    operations = proto.RepeatedField(
        proto.MESSAGE, number=4184044, message="Operation",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class OperationAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        items (Sequence[google.cloud.compute_v1.types.OperationAggregatedList.ItemsEntry]):
            [Output Only] A map of scoped operation lists.
        kind (str):
            [Output Only] Type of resource. Always
            ``compute#operationAggregatedList`` for aggregated lists of
            operations.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than ``maxResults``, use the ``nextPageToken`` as a
            value for the query parameter ``pageToken`` in the next list
            request. Subsequent list requests will have their own
            ``nextPageToken`` to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="OperationsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class OperationList(proto.Message):
    r"""Contains a list of Operation resources.
    Attributes:
        id (str):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        items (Sequence[google.cloud.compute_v1.types.Operation]):
            [Output Only] A list of Operation resources.
        kind (str):
            [Output Only] Type of resource. Always
            ``compute#operations`` for Operations resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than ``maxResults``, use the ``nextPageToken`` as a
            value for the query parameter ``pageToken`` in the next list
            request. Subsequent list requests will have their own
            ``nextPageToken`` to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Operation",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PacketMirroringForwardingRuleInfo(proto.Message):
    r"""
    Attributes:
        canonical_url (str):
            [Output Only] Unique identifier for the forwarding rule;
            defined by the server.
        url (str):
            Resource URL to the forwarding rule
            representing the ILB configured as destination
            of the mirrored traffic.
    """

    canonical_url = proto.Field(proto.STRING, number=512294820, optional=True,)
    url = proto.Field(proto.STRING, number=116079, optional=True,)


class PacketMirroringFilter(proto.Message):
    r"""
    Attributes:
        I_p_protocols (Sequence[str]):
            Protocols that apply as filter on mirrored
            traffic. If no protocols are specified, all
            traffic that matches the specified CIDR ranges
            is mirrored. If neither cidrRanges nor
            IPProtocols is specified, all traffic is
            mirrored.
        cidr_ranges (Sequence[str]):
            IP CIDR ranges that apply as filter on the
            source (ingress) or destination (egress) IP in
            the IP header. Only IPv4 is supported. If no
            ranges are specified, all traffic that matches
            the specified IPProtocols is mirrored. If
            neither cidrRanges nor IPProtocols is specified,
            all traffic is mirrored.
        direction (google.cloud.compute_v1.types.PacketMirroringFilter.Direction):
            Direction of traffic to mirror, either
            INGRESS, EGRESS, or BOTH. The default is BOTH.
    """

    class Direction(proto.Enum):
        r"""Direction of traffic to mirror, either INGRESS, EGRESS, or
        BOTH. The default is BOTH.
        """
        UNDEFINED_DIRECTION = 0
        BOTH = 2044801
        EGRESS = 432880501
        INGRESS = 516931221

    I_p_protocols = proto.RepeatedField(proto.STRING, number=98544854,)
    cidr_ranges = proto.RepeatedField(proto.STRING, number=487901697,)
    direction = proto.Field(
        proto.ENUM, number=111150975, optional=True, enum=Direction,
    )


class PacketMirroringMirroredResourceInfo(proto.Message):
    r"""
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.PacketMirroringMirroredResourceInfoInstanceInfo]):
            A set of virtual machine instances that are
            being mirrored. They must live in zones
            contained in the same region as this
            packetMirroring.  Note that this config will
            apply only to those network interfaces of the
            Instances that belong to the network specified
            in this packetMirroring.
            You may specify a maximum of 50 Instances.
        subnetworks (Sequence[google.cloud.compute_v1.types.PacketMirroringMirroredResourceInfoSubnetInfo]):
            A set of subnetworks for which traffic
            from/to all VM instances will be mirrored. They
            must live in the same region as this
            packetMirroring.  You may specify a maximum of 5
            subnetworks.
        tags (Sequence[str]):
            A set of mirrored tags. Traffic from/to all
            VM instances that have one or more of these tags
            will be mirrored.
    """

    instances = proto.RepeatedField(
        proto.MESSAGE,
        number=29097598,
        message="PacketMirroringMirroredResourceInfoInstanceInfo",
    )
    subnetworks = proto.RepeatedField(
        proto.MESSAGE,
        number=415853125,
        message="PacketMirroringMirroredResourceInfoSubnetInfo",
    )
    tags = proto.RepeatedField(proto.STRING, number=3552281,)


class PacketMirroringNetworkInfo(proto.Message):
    r"""
    Attributes:
        canonical_url (str):
            [Output Only] Unique identifier for the network; defined by
            the server.
        url (str):
            URL of the network resource.
    """

    canonical_url = proto.Field(proto.STRING, number=512294820, optional=True,)
    url = proto.Field(proto.STRING, number=116079, optional=True,)


class PacketMirroring(proto.Message):
    r"""Represents a Packet Mirroring resource.

    Packet Mirroring clones the traffic of specified instances in your
    Virtual Private Cloud (VPC) network and forwards it to a collector
    destination, such as an instance group of an internal TCP/UDP load
    balancer, for analysis or examination. For more information about
    setting up Packet Mirroring, see Using Packet Mirroring. (==
    resource_for {$api_version}.packetMirrorings ==)

    Attributes:
        collector_ilb (google.cloud.compute_v1.types.PacketMirroringForwardingRuleInfo):
            The Forwarding Rule resource of type
            loadBalancingScheme=INTERNAL that will be used
            as collector for mirrored traffic. The specified
            forwarding rule must have isMirroringCollector
            set to true.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        enable (google.cloud.compute_v1.types.PacketMirroring.Enable):
            Indicates whether or not this packet
            mirroring takes effect. If set to FALSE, this
            packet mirroring policy will not be enforced on
            the network.  The default is TRUE.
        filter (google.cloud.compute_v1.types.PacketMirroringFilter):
            Filter for mirrored traffic. If unspecified,
            all traffic is mirrored.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#packetMirroring for packet mirrorings.
        mirrored_resources (google.cloud.compute_v1.types.PacketMirroringMirroredResourceInfo):
            PacketMirroring mirroredResourceInfos.
            MirroredResourceInfo specifies a set of mirrored
            VM instances, subnetworks and/or tags for which
            traffic from/to all VM instances will be
            mirrored.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        network (google.cloud.compute_v1.types.PacketMirroringNetworkInfo):
            Specifies the mirrored VPC network. Only
            packets in this network will be mirrored. All
            mirrored VMs should have a NIC in the given
            network. All mirrored subnetworks should belong
            to the given network.
        priority (int):
            The priority of applying this configuration.
            Priority is used to break ties in cases where
            there is more than one matching rule. In the
            case of two rules that apply for a given
            Instance, the one with the lowest-numbered
            priority value wins.  Default value is 1000.
            Valid range is 0 through 65535.
        region (str):
            [Output Only] URI of the region where the packetMirroring
            resides.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    class Enable(proto.Enum):
        r"""Indicates whether or not this packet mirroring takes effect.
        If set to FALSE, this packet mirroring policy will not be
        enforced on the network.  The default is TRUE.
        """
        UNDEFINED_ENABLE = 0
        FALSE = 66658563
        TRUE = 2583950

    collector_ilb = proto.Field(
        proto.MESSAGE,
        number=426607853,
        optional=True,
        message="PacketMirroringForwardingRuleInfo",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable = proto.Field(proto.ENUM, number=311764355, optional=True, enum=Enable,)
    filter = proto.Field(
        proto.MESSAGE, number=336120696, optional=True, message="PacketMirroringFilter",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    mirrored_resources = proto.Field(
        proto.MESSAGE,
        number=124817348,
        optional=True,
        message="PacketMirroringMirroredResourceInfo",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(
        proto.MESSAGE,
        number=232872494,
        optional=True,
        message="PacketMirroringNetworkInfo",
    )
    priority = proto.Field(proto.UINT32, number=445151652, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class PacketMirroringsScopedList(proto.Message):
    r"""
    Attributes:
        packet_mirrorings (Sequence[google.cloud.compute_v1.types.PacketMirroring]):
            A list of packetMirrorings contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of packetMirrorings when the list is empty.
    """

    packet_mirrorings = proto.RepeatedField(
        proto.MESSAGE, number=154615079, message="PacketMirroring",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PacketMirroringAggregatedList(proto.Message):
    r"""Contains a list of packetMirrorings.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.PacketMirroringAggregatedList.ItemsEntry]):
            A list of PacketMirroring resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="PacketMirroringsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PacketMirroringList(proto.Message):
    r"""Contains a list of PacketMirroring resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.PacketMirroring]):
            A list of PacketMirroring resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#packetMirroring for packetMirrorings.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="PacketMirroring",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PacketMirroringMirroredResourceInfoInstanceInfo(proto.Message):
    r"""
    Attributes:
        canonical_url (str):
            [Output Only] Unique identifier for the instance; defined by
            the server.
        url (str):
            Resource URL to the virtual machine instance
            which is being mirrored.
    """

    canonical_url = proto.Field(proto.STRING, number=512294820, optional=True,)
    url = proto.Field(proto.STRING, number=116079, optional=True,)


class PacketMirroringMirroredResourceInfoSubnetInfo(proto.Message):
    r"""
    Attributes:
        canonical_url (str):
            [Output Only] Unique identifier for the subnetwork; defined
            by the server.
        url (str):
            Resource URL to the subnetwork for which
            traffic from/to all VM instances will be
            mirrored.
    """

    canonical_url = proto.Field(proto.STRING, number=512294820, optional=True,)
    url = proto.Field(proto.STRING, number=116079, optional=True,)


class PathRule(proto.Message):
    r"""A path-matching rule for a URL. If matched, will use the
    specified BackendService to handle the traffic arriving at this
    URL.

    Attributes:
        paths (Sequence[str]):
            The list of path patterns to match. Each must start with /
            and the only place a \* is allowed is at the end following a
            /. The string fed to the path matcher does not include any
            text after the first ? or #, and those chars are not allowed
            here.
        route_action (google.cloud.compute_v1.types.HttpRouteAction):
            In response to a matching path, the load
            balancer performs advanced routing actions like
            URL rewrites, header transformations, etc. prior
            to forwarding the request to the selected
            backend. If routeAction specifies any
            weightedBackendServices, service must not be
            set. Conversely if service is set, routeAction
            cannot contain any  weightedBackendServices.
            Only one of routeAction or urlRedirect must be
            set. UrlMaps for external HTTP(S) load balancers
            support only the urlRewrite action within a
            pathRule's routeAction.
        service (str):
            The full or partial URL of the backend
            service resource to which traffic is directed if
            this rule is matched. If routeAction is
            additionally specified, advanced routing actions
            like URL Rewrites, etc. take effect prior to
            sending the request to the backend. However, if
            service is specified, routeAction cannot contain
            any weightedBackendService s. Conversely, if
            routeAction specifies any
            weightedBackendServices, service must not be
            specified. Only one of urlRedirect, service or
            routeAction.weightedBackendService must be set.
        url_redirect (google.cloud.compute_v1.types.HttpRedirectAction):
            When a path pattern is matched, the request
            is redirected to a URL specified by urlRedirect.
            If urlRedirect is specified, service or
            routeAction must not be set. Not supported when
            the URL map is bound to target gRPC proxy.
    """

    paths = proto.RepeatedField(proto.STRING, number=106438894,)
    route_action = proto.Field(
        proto.MESSAGE, number=424563948, optional=True, message="HttpRouteAction",
    )
    service = proto.Field(proto.STRING, number=373540533, optional=True,)
    url_redirect = proto.Field(
        proto.MESSAGE, number=405147820, optional=True, message="HttpRedirectAction",
    )


class PathMatcher(proto.Message):
    r"""A matcher for the path portion of the URL. The BackendService
    from the longest-matched rule will serve the URL. If no rule was
    matched, the default service will be used.

    Attributes:
        default_route_action (google.cloud.compute_v1.types.HttpRouteAction):
            defaultRouteAction takes effect when none of
            the  pathRules or routeRules match. The load
            balancer performs advanced routing actions like
            URL rewrites, header transformations, etc. prior
            to forwarding the request to the selected
            backend. If defaultRouteAction specifies any
            weightedBackendServices, defaultService must not
            be set. Conversely if defaultService is set,
            defaultRouteAction cannot contain any
            weightedBackendServices. Only one of
            defaultRouteAction or defaultUrlRedirect must be
            set. UrlMaps for external HTTP(S) load balancers
            support only the urlRewrite action within a
            pathMatcher's defaultRouteAction.
        default_service (str):
            The full or partial URL to the BackendService resource. This
            will be used if none of the pathRules or routeRules defined
            by this PathMatcher are matched. For example, the following
            are all valid URLs to a BackendService resource:

            -  https://www.googleapis.com/compute/v1/projects/project/global/backendServices/backendService
            -  compute/v1/projects/project/global/backendServices/backendService
            -  global/backendServices/backendService If
               defaultRouteAction is additionally specified, advanced
               routing actions like URL Rewrites, etc. take effect prior
               to sending the request to the backend. However, if
               defaultService is specified, defaultRouteAction cannot
               contain any weightedBackendServices. Conversely, if
               defaultRouteAction specifies any weightedBackendServices,
               defaultService must not be specified. Only one of
               defaultService, defaultUrlRedirect or
               defaultRouteAction.weightedBackendService must be set.
               Authorization requires one or more of the following
               Google IAM permissions on the specified resource
               default_service:
            -  compute.backendBuckets.use
            -  compute.backendServices.use
        default_url_redirect (google.cloud.compute_v1.types.HttpRedirectAction):
            When none of the specified pathRules or
            routeRules match, the request is redirected to a
            URL specified by defaultUrlRedirect. If
            defaultUrlRedirect is specified, defaultService
            or defaultRouteAction must not be set. Not
            supported when the URL map is bound to target
            gRPC proxy.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        header_action (google.cloud.compute_v1.types.HttpHeaderAction):
            Specifies changes to request and response
            headers that need to take effect for the
            selected backendService. HeaderAction specified
            here are applied after the matching
            HttpRouteRule HeaderAction and before the
            HeaderAction in the UrlMap Note that
            headerAction is not supported for Loadbalancers
            that have their loadBalancingScheme set to
            EXTERNAL. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.
        name (str):
            The name to which this PathMatcher is
            referred by the HostRule.
        path_rules (Sequence[google.cloud.compute_v1.types.PathRule]):
            The list of path rules. Use this list instead of routeRules
            when routing based on simple path matching is all that's
            required. The order by which path rules are specified does
            not matter. Matches are always done on the
            longest-path-first basis. For example: a pathRule with a
            path /a/b/c/\* will match before /a/b/\* irrespective of the
            order in which those paths appear in this list. Within a
            given pathMatcher, only one of pathRules or routeRules must
            be set.
        route_rules (Sequence[google.cloud.compute_v1.types.HttpRouteRule]):
            The list of HTTP route rules. Use this list
            instead of pathRules when advanced route
            matching and routing actions are desired.
            routeRules are evaluated in order of priority,
            from the lowest to highest number. Within a
            given pathMatcher, you can set only one of
            pathRules or routeRules.
    """

    default_route_action = proto.Field(
        proto.MESSAGE, number=378919466, optional=True, message="HttpRouteAction",
    )
    default_service = proto.Field(proto.STRING, number=370242231, optional=True,)
    default_url_redirect = proto.Field(
        proto.MESSAGE, number=359503338, optional=True, message="HttpRedirectAction",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    header_action = proto.Field(
        proto.MESSAGE, number=328077352, optional=True, message="HttpHeaderAction",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    path_rules = proto.RepeatedField(
        proto.MESSAGE, number=104439901, message="PathRule",
    )
    route_rules = proto.RepeatedField(
        proto.MESSAGE, number=376292225, message="HttpRouteRule",
    )


class Rule(proto.Message):
    r"""A rule to be applied in a Policy.
    Attributes:
        action (google.cloud.compute_v1.types.Rule.Action):
            Required
        conditions (Sequence[google.cloud.compute_v1.types.Condition]):
            Additional restrictions that must be met. All
            conditions must pass for the rule to match.
        description (str):
            Human-readable description of the rule.
        ins (Sequence[str]):
            If one or more 'in' clauses are specified, the rule matches
            if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of
            these entries.
        log_configs (Sequence[google.cloud.compute_v1.types.LogConfig]):
            The config returned to callers of
            tech.iam.IAM.CheckPolicy for any entries that
            match the LOG action.
        not_ins (Sequence[str]):
            If one or more 'not_in' clauses are specified, the rule
            matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of
            the entries.
        permissions (Sequence[str]):
            A permission is a string of form '..' (e.g.,
            'storage.buckets.list'). A value of '*' matches all
            permissions, and a verb part of '*' (e.g.,
            'storage.buckets.*') matches all verbs.
    """

    class Action(proto.Enum):
        r"""Required"""
        UNDEFINED_ACTION = 0
        ALLOW = 62368553
        ALLOW_WITH_LOG = 76034177
        DENY = 2094604
        DENY_WITH_LOG = 351433982
        LOG = 75556
        NO_ACTION = 260643444

    action = proto.Field(proto.ENUM, number=187661878, optional=True, enum=Action,)
    conditions = proto.RepeatedField(
        proto.MESSAGE, number=142882488, message="Condition",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    ins = proto.RepeatedField(proto.STRING, number=104430,)
    log_configs = proto.RepeatedField(
        proto.MESSAGE, number=152873846, message="LogConfig",
    )
    not_ins = proto.RepeatedField(proto.STRING, number=518443138,)
    permissions = proto.RepeatedField(proto.STRING, number=59962500,)


class WafExpressionSet(proto.Message):
    r"""
    Attributes:
        aliases (Sequence[str]):
            A list of alternate IDs. The format should
            be: - E.g. XSS-stable Generic suffix like
            "stable" is particularly useful if a policy
            likes to avail newer set of expressions without
            having to change the policy. A given alias name
            can't be used for more than one entity set.
        expressions (Sequence[google.cloud.compute_v1.types.WafExpressionSetExpression]):
            List of available expressions.
        id (str):
            Google specified expression set ID. The
            format should be: - E.g. XSS-20170329
    """

    aliases = proto.RepeatedField(proto.STRING, number=159207166,)
    expressions = proto.RepeatedField(
        proto.MESSAGE, number=175554779, message="WafExpressionSetExpression",
    )
    id = proto.Field(proto.STRING, number=3355, optional=True,)


class PreconfiguredWafSet(proto.Message):
    r"""
    Attributes:
        expression_sets (Sequence[google.cloud.compute_v1.types.WafExpressionSet]):
            List of entities that are currently supported
            for WAF rules.
    """

    expression_sets = proto.RepeatedField(
        proto.MESSAGE, number=474011032, message="WafExpressionSet",
    )


class PreservedStatePreservedDisk(proto.Message):
    r"""
    Attributes:
        auto_delete (google.cloud.compute_v1.types.PreservedStatePreservedDisk.AutoDelete):
            These stateful disks will never be deleted during
            autohealing, update, instance recreate operations. This flag
            is used to configure if the disk should be deleted after it
            is no longer used by the group, e.g. when the given instance
            or the whole MIG is deleted. Note: disks attached in
            READ_ONLY mode cannot be auto-deleted.
        mode (google.cloud.compute_v1.types.PreservedStatePreservedDisk.Mode):
            The mode in which to attach this disk, either READ_WRITE or
            READ_ONLY. If not specified, the default is to attach the
            disk in READ_WRITE mode.
        source (str):
            The URL of the disk resource that is stateful
            and should be attached to the VM instance.
    """

    class AutoDelete(proto.Enum):
        r"""These stateful disks will never be deleted during autohealing,
        update, instance recreate operations. This flag is used to configure
        if the disk should be deleted after it is no longer used by the
        group, e.g. when the given instance or the whole MIG is deleted.
        Note: disks attached in READ_ONLY mode cannot be auto-deleted.
        """
        UNDEFINED_AUTO_DELETE = 0
        NEVER = 74175084
        ON_PERMANENT_INSTANCE_DELETION = 95727719

    class Mode(proto.Enum):
        r"""The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.
        """
        UNDEFINED_MODE = 0
        READ_ONLY = 91950261
        READ_WRITE = 173607894

    auto_delete = proto.Field(
        proto.ENUM, number=464761403, optional=True, enum=AutoDelete,
    )
    mode = proto.Field(proto.ENUM, number=3357091, optional=True, enum=Mode,)
    source = proto.Field(proto.STRING, number=177235995, optional=True,)


class Quota(proto.Message):
    r"""A quotas entry.
    Attributes:
        limit (float):
            [Output Only] Quota limit for this metric.
        metric (google.cloud.compute_v1.types.Quota.Metric):
            [Output Only] Name of the quota metric.
        owner (str):
            [Output Only] Owning resource. This is the resource on which
            this quota is applied.
        usage (float):
            [Output Only] Current usage of this metric.
    """

    class Metric(proto.Enum):
        r"""[Output Only] Name of the quota metric."""
        UNDEFINED_METRIC = 0
        A2_CPUS = 153206585
        AFFINITY_GROUPS = 108303563
        AUTOSCALERS = 471248988
        BACKEND_BUCKETS = 137626846
        BACKEND_SERVICES = 269623753
        C2D_CPUS = 508182517
        C2_CPUS = 317601211
        COMMITMENTS = 456141790
        COMMITTED_A2_CPUS = 59330902
        COMMITTED_C2D_CPUS = 282390904
        COMMITTED_C2_CPUS = 223725528
        COMMITTED_CPUS = 292394702
        COMMITTED_E2_CPUS = 388120154
        COMMITTED_LICENSES = 357606869
        COMMITTED_LOCAL_SSD_TOTAL_GB = 308393480
        COMMITTED_MEMORY_OPTIMIZED_CPUS = 489057886
        COMMITTED_N2A_CPUS = 40064304
        COMMITTED_N2D_CPUS = 125951757
        COMMITTED_N2_CPUS = 322589603
        COMMITTED_NVIDIA_A100_GPUS = 375799445
        COMMITTED_NVIDIA_K80_GPUS = 3857188
        COMMITTED_NVIDIA_P100_GPUS = 107528100
        COMMITTED_NVIDIA_P4_GPUS = 347952897
        COMMITTED_NVIDIA_T4_GPUS = 139871237
        COMMITTED_NVIDIA_V100_GPUS = 219562
        CPUS = 2075595
        CPUS_ALL_REGIONS = 470911149
        DISKS_TOTAL_GB = 353520543
        E2_CPUS = 481995837
        EXTERNAL_NETWORK_LB_FORWARDING_RULES = 374298265
        EXTERNAL_PROTOCOL_FORWARDING_RULES = 63478888
        EXTERNAL_VPN_GATEWAYS = 272457134
        FIREWALLS = 374485843
        FORWARDING_RULES = 432668949
        GLOBAL_INTERNAL_ADDRESSES = 42738332
        GPUS_ALL_REGIONS = 39387177
        HEALTH_CHECKS = 289347502
        IMAGES = 15562360
        INSTANCES = 131337822
        INSTANCE_GROUPS = 355919038
        INSTANCE_GROUP_MANAGERS = 101798192
        INSTANCE_TEMPLATES = 226188271
        INTERCONNECTS = 415204741
        INTERCONNECT_ATTACHMENTS_PER_REGION = 159968086
        INTERCONNECT_ATTACHMENTS_TOTAL_MBPS = 425090419
        INTERCONNECT_TOTAL_GBPS = 285341866
        INTERNAL_ADDRESSES = 197899392
        INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES = 266433668
        IN_PLACE_SNAPSHOTS = 151359133
        IN_USE_ADDRESSES = 402125072
        IN_USE_BACKUP_SCHEDULES = 32786705
        IN_USE_SNAPSHOT_SCHEDULES = 462104083
        LOCAL_SSD_TOTAL_GB = 330878021
        M1_CPUS = 37203366
        M2_CPUS = 65832517
        MACHINE_IMAGES = 446986640
        N2A_CPUS = 265855917
        N2D_CPUS = 351743370
        N2_CPUS = 416465286
        NETWORKS = 485481477
        NETWORK_ENDPOINT_GROUPS = 102144909
        NETWORK_FIREWALL_POLICIES = 101117374
        NODE_GROUPS = 24624817
        NODE_TEMPLATES = 474896668
        NVIDIA_A100_GPUS = 504872978
        NVIDIA_K80_GPUS = 163886599
        NVIDIA_P100_GPUS = 236601633
        NVIDIA_P100_VWS_GPUS = 213970574
        NVIDIA_P4_GPUS = 283841470
        NVIDIA_P4_VWS_GPUS = 528296619
        NVIDIA_T4_GPUS = 75759810
        NVIDIA_T4_VWS_GPUS = 319813039
        NVIDIA_V100_GPUS = 129293095
        PACKET_MIRRORINGS = 15578407
        PD_EXTREME_TOTAL_PROVISIONED_IOPS = 69593965
        PREEMPTIBLE_CPUS = 251184841
        PREEMPTIBLE_LOCAL_SSD_GB = 260819336
        PREEMPTIBLE_NVIDIA_A100_GPUS = 68832784
        PREEMPTIBLE_NVIDIA_K80_GPUS = 374960201
        PREEMPTIBLE_NVIDIA_P100_GPUS = 337432351
        PREEMPTIBLE_NVIDIA_P100_VWS_GPUS = 313544076
        PREEMPTIBLE_NVIDIA_P4_GPUS = 429197628
        PREEMPTIBLE_NVIDIA_P4_VWS_GPUS = 252981545
        PREEMPTIBLE_NVIDIA_T4_GPUS = 221115968
        PREEMPTIBLE_NVIDIA_T4_VWS_GPUS = 44497965
        PREEMPTIBLE_NVIDIA_V100_GPUS = 230123813
        PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK = 231164291
        PUBLIC_ADVERTISED_PREFIXES = 471371980
        PUBLIC_DELEGATED_PREFIXES = 532465974
        REGIONAL_AUTOSCALERS = 29363772
        REGIONAL_INSTANCE_GROUP_MANAGERS = 37543696
        RESERVATIONS = 32644647
        RESOURCE_POLICIES = 83955297
        ROUTERS = 493018666
        ROUTES = 275680074
        SECURITY_POLICIES = 189518703
        SECURITY_POLICY_CEVAL_RULES = 470815689
        SECURITY_POLICY_RULES = 203549225
        SNAPSHOTS = 343405327
        SSD_TOTAL_GB = 161732561
        SSL_CERTIFICATES = 378372399
        STATIC_ADDRESSES = 93624049
        STATIC_BYOIP_ADDRESSES = 275809649
        SUBNETWORKS = 421330469
        TARGET_HTTPS_PROXIES = 219522506
        TARGET_HTTP_PROXIES = 164117155
        TARGET_INSTANCES = 284519728
        TARGET_POOLS = 348261257
        TARGET_SSL_PROXIES = 159216235
        TARGET_TCP_PROXIES = 182243136
        TARGET_VPN_GATEWAYS = 75029928
        URL_MAPS = 378660743
        VPN_GATEWAYS = 35620282
        VPN_TUNNELS = 104327296
        XPN_SERVICE_PROJECTS = 95191981

    limit = proto.Field(proto.DOUBLE, number=102976443, optional=True,)
    metric = proto.Field(proto.ENUM, number=533067184, optional=True, enum=Metric,)
    owner = proto.Field(proto.STRING, number=106164915, optional=True,)
    usage = proto.Field(proto.DOUBLE, number=111574433, optional=True,)


class UsageExportLocation(proto.Message):
    r"""The location in Cloud Storage and naming method of the daily usage
    report. Contains bucket_name and report_name prefix.

    Attributes:
        bucket_name (str):
            The name of an existing bucket in Cloud
            Storage where the usage report object is stored.
            The Google Service Account is granted write
            access to this bucket. This can either be the
            bucket name by itself, such as example-bucket,
            or the bucket name with gs:// or
            https://storage.googleapis.com/ in front of it,
            such as gs://example-bucket.
        report_name_prefix (str):
            An optional prefix for the name of the usage report object
            stored in bucketName. If not supplied, defaults to usage.
            The report is stored as a CSV file named
            report_name_prefix_gce_YYYYMMDD.csv where YYYYMMDD is the
            day of the usage according to Pacific Time. If you supply a
            prefix, it should conform to Cloud Storage object naming
            conventions.
    """

    bucket_name = proto.Field(proto.STRING, number=283610048, optional=True,)
    report_name_prefix = proto.Field(proto.STRING, number=320198715, optional=True,)


class Project(proto.Message):
    r"""Represents a Project resource.

    A project is used to organize resources in a Google Cloud Platform
    environment. For more information, read about the Resource
    Hierarchy. (== resource_for {$api_version}.projects ==)

    Attributes:
        common_instance_metadata (google.cloud.compute_v1.types.Metadata):
            Metadata key/value pairs available to all
            instances contained in this project. See Custom
            metadata for more information.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        default_network_tier (google.cloud.compute_v1.types.Project.DefaultNetworkTier):
            This signifies the default network tier used
            for configuring resources of the project and can
            only take the following values: PREMIUM,
            STANDARD. Initially the default network tier is
            PREMIUM.
        default_service_account (str):
            [Output Only] Default service account used by VMs running in
            this project.
        description (str):
            An optional textual description of the
            resource.
        enabled_features (Sequence[str]):
            Restricted features enabled for use on this
            project.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server. This is not the project
            ID, and is just a unique ID used by Compute Engine to
            identify resources.
        kind (str):
            [Output Only] Type of the resource. Always compute#project
            for projects.
        name (str):
            The project ID. For example: my-example-
            roject. Use the project ID to make requests to
            Compute Engine.
        quotas (Sequence[google.cloud.compute_v1.types.Quota]):
            [Output Only] Quotas assigned to this project.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        usage_export_location (google.cloud.compute_v1.types.UsageExportLocation):
            The naming prefix for daily usage reports and
            the Google Cloud Storage bucket where they are
            stored.
        xpn_project_status (google.cloud.compute_v1.types.Project.XpnProjectStatus):
            [Output Only] The role this project has in a shared VPC
            configuration. Currently, only projects with the host role,
            which is specified by the value HOST, are differentiated.
    """

    class DefaultNetworkTier(proto.Enum):
        r"""This signifies the default network tier used for configuring
        resources of the project and can only take the following values:
        PREMIUM, STANDARD. Initially the default network tier is
        PREMIUM.
        """
        UNDEFINED_DEFAULT_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    class XpnProjectStatus(proto.Enum):
        r"""[Output Only] The role this project has in a shared VPC
        configuration. Currently, only projects with the host role, which is
        specified by the value HOST, are differentiated.
        """
        UNDEFINED_XPN_PROJECT_STATUS = 0
        HOST = 2223528
        UNSPECIFIED_XPN_PROJECT_STATUS = 340393257

    common_instance_metadata = proto.Field(
        proto.MESSAGE, number=185794117, optional=True, message="Metadata",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    default_network_tier = proto.Field(
        proto.ENUM, number=471753361, optional=True, enum=DefaultNetworkTier,
    )
    default_service_account = proto.Field(
        proto.STRING, number=298712229, optional=True,
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enabled_features = proto.RepeatedField(proto.STRING, number=469017467,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    quotas = proto.RepeatedField(proto.MESSAGE, number=125341947, message="Quota",)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    usage_export_location = proto.Field(
        proto.MESSAGE, number=347543874, optional=True, message="UsageExportLocation",
    )
    xpn_project_status = proto.Field(
        proto.ENUM, number=228419265, optional=True, enum=XpnProjectStatus,
    )


class XpnResourceId(proto.Message):
    r"""Service resource (a.k.a service project) ID.
    Attributes:
        id (str):
            The ID of the service resource. In the case
            of projects, this field supports project id
            (e.g., my-project-123) and project number (e.g.
            12345678).
        type_ (google.cloud.compute_v1.types.XpnResourceId.Type):
            The type of the service resource.
    """

    class Type(proto.Enum):
        r"""The type of the service resource."""
        UNDEFINED_TYPE = 0
        PROJECT = 408671993
        XPN_RESOURCE_TYPE_UNSPECIFIED = 151607034

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class ProjectsDisableXpnResourceRequest(proto.Message):
    r"""
    Attributes:
        xpn_resource (google.cloud.compute_v1.types.XpnResourceId):
            Service resource (a.k.a service project) ID.
    """

    xpn_resource = proto.Field(
        proto.MESSAGE, number=133384631, optional=True, message="XpnResourceId",
    )


class ProjectsEnableXpnResourceRequest(proto.Message):
    r"""
    Attributes:
        xpn_resource (google.cloud.compute_v1.types.XpnResourceId):
            Service resource (a.k.a service project) ID.
    """

    xpn_resource = proto.Field(
        proto.MESSAGE, number=133384631, optional=True, message="XpnResourceId",
    )


class ProjectsGetXpnResources(proto.Message):
    r"""
    Attributes:
        kind (str):
            [Output Only] Type of resource. Always
            compute#projectsGetXpnResources for lists of service
            resources (a.k.a service projects)
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        resources (Sequence[google.cloud.compute_v1.types.XpnResourceId]):
            Service resources (a.k.a service projects)
            attached to this project as their shared VPC
            host.
    """

    @property
    def raw_page(self):
        return self

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    resources = proto.RepeatedField(
        proto.MESSAGE, number=164412965, message="XpnResourceId",
    )


class ProjectsListXpnHostsRequest(proto.Message):
    r"""
    Attributes:
        organization (str):
            Optional organization ID managed by Cloud
            Resource Manager, for which to list shared VPC
            host projects. If not specified, the
            organization will be inferred from the project.
    """

    organization = proto.Field(proto.STRING, number=105180467, optional=True,)


class ProjectsSetDefaultNetworkTierRequest(proto.Message):
    r"""
    Attributes:
        network_tier (google.cloud.compute_v1.types.ProjectsSetDefaultNetworkTierRequest.NetworkTier):
            Default network tier to be set.
    """

    class NetworkTier(proto.Enum):
        r"""Default network tier to be set."""
        UNDEFINED_NETWORK_TIER = 0
        PREMIUM = 399530551
        STANDARD = 484642493

    network_tier = proto.Field(
        proto.ENUM, number=517397843, optional=True, enum=NetworkTier,
    )


class PublicAdvertisedPrefixPublicDelegatedPrefix(proto.Message):
    r"""Represents a CIDR range which can be used to assign
    addresses.

    Attributes:
        ip_range (str):
            The IP address range of the public delegated
            prefix
        name (str):
            The name of the public delegated prefix
        project (str):
            The project number of the public delegated
            prefix
        region (str):
            The region of the public delegated prefix if
            it is regional. If absent, the prefix is global.
        status (str):
            The status of the public delegated prefix.
            Possible values are: INITIALIZING: The public
            delegated prefix is being initialized and
            addresses cannot be created yet. ANNOUNCED: The
            public delegated prefix is active.
    """

    ip_range = proto.Field(proto.STRING, number=145092645, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    project = proto.Field(proto.STRING, number=227560217, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    status = proto.Field(proto.STRING, number=181260274, optional=True,)


class PublicAdvertisedPrefix(proto.Message):
    r"""A public advertised prefix represents an aggregated IP prefix
    or netblock which customers bring to cloud. The IP prefix is a
    single unit of route advertisement and is announced globally to
    the internet.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        dns_verification_ip (str):
            The IPv4 address to be used for reverse DNS
            verification.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a new
            PublicAdvertisedPrefix. An up-to-date
            fingerprint must be provided in order to update
            the PublicAdvertisedPrefix, otherwise the
            request will fail with error 412
            conditionNotMet.  To see the latest fingerprint,
            make a get() request to retrieve a
            PublicAdvertisedPrefix.
        id (int):
            [Output Only] The unique identifier for the resource type.
            The server generates this identifier.
        ip_cidr_range (str):
            The IPv4 address range, in CIDR format,
            represented by this public advertised prefix.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#publicAdvertisedPrefix for public advertised
            prefixes.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        public_delegated_prefixs (Sequence[google.cloud.compute_v1.types.PublicAdvertisedPrefixPublicDelegatedPrefix]):
            [Output Only] The list of public delegated prefixes that
            exist for this public advertised prefix.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        shared_secret (str):
            [Output Only] The shared secret to be used for reverse DNS
            verification.
        status (google.cloud.compute_v1.types.PublicAdvertisedPrefix.Status):
            The status of the public advertised prefix.
    """

    class Status(proto.Enum):
        r"""The status of the public advertised prefix."""
        UNDEFINED_STATUS = 0
        INITIAL = 518841124
        PREFIX_CONFIGURATION_COMPLETE = 480889551
        PREFIX_CONFIGURATION_IN_PROGRESS = 378550961
        PREFIX_REMOVAL_IN_PROGRESS = 284375783
        PTR_CONFIGURED = 513497167
        REVERSE_DNS_LOOKUP_FAILED = 295755183
        VALIDATED = 66197998

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    dns_verification_ip = proto.Field(proto.STRING, number=241011381, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    public_delegated_prefixs = proto.RepeatedField(
        proto.MESSAGE,
        number=425811723,
        message="PublicAdvertisedPrefixPublicDelegatedPrefix",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    shared_secret = proto.Field(proto.STRING, number=381932490, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class PublicAdvertisedPrefixList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.PublicAdvertisedPrefix]):
            A list of PublicAdvertisedPrefix resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#publicAdvertisedPrefix for public advertised
            prefixes.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="PublicAdvertisedPrefix",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PublicDelegatedPrefixPublicDelegatedSubPrefix(proto.Message):
    r"""Represents a sub PublicDelegatedPrefix.
    Attributes:
        delegatee_project (str):
            Name of the project scoping this
            PublicDelegatedSubPrefix.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        ip_cidr_range (str):
            The IPv4 address range, in CIDR format,
            represented by this sub public delegated prefix.
        is_address (bool):
            Whether the sub prefix is delegated to create
            Address resources in the delegatee project.
        name (str):
            The name of the sub public delegated prefix.
        region (str):
            [Output Only] The region of the sub public delegated prefix
            if it is regional. If absent, the sub prefix is global.
        status (google.cloud.compute_v1.types.PublicDelegatedPrefixPublicDelegatedSubPrefix.Status):
            [Output Only] The status of the sub public delegated prefix.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the sub public delegated prefix."""
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        INACTIVE = 270421099

    delegatee_project = proto.Field(proto.STRING, number=414860634, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    is_address = proto.Field(proto.BOOL, number=352617951, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class PublicDelegatedPrefix(proto.Message):
    r"""A PublicDelegatedPrefix resource represents an IP block
    within a PublicAdvertisedPrefix that is configured within a
    single cloud scope (global or region). IPs in the block can be
    allocated to resources within that scope. Public delegated
    prefixes may be further broken up into smaller IP blocks in the
    same scope as the parent block.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a new
            PublicDelegatedPrefix. An up-to-date fingerprint
            must be provided in order to update the
            PublicDelegatedPrefix, otherwise the request
            will fail with error 412 conditionNotMet.  To
            see the latest fingerprint, make a get() request
            to retrieve a PublicDelegatedPrefix.
        id (int):
            [Output Only] The unique identifier for the resource type.
            The server generates this identifier.
        ip_cidr_range (str):
            The IPv4 address range, in CIDR format,
            represented by this public delegated prefix.
        is_live_migration (bool):
            If true, the prefix will be live migrated.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#publicDelegatedPrefix for public delegated prefixes.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        parent_prefix (str):
            The URL of parent prefix. Either
            PublicAdvertisedPrefix or PublicDelegatedPrefix.
        public_delegated_sub_prefixs (Sequence[google.cloud.compute_v1.types.PublicDelegatedPrefixPublicDelegatedSubPrefix]):
            The list of sub public delegated prefixes
            that exist for this public delegated prefix.
        region (str):
            [Output Only] URL of the region where the public delegated
            prefix resides. This field applies only to the region
            resource. You must specify this field as part of the HTTP
            request URL. It is not settable as a field in the request
            body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        status (google.cloud.compute_v1.types.PublicDelegatedPrefix.Status):
            [Output Only] The status of the public delegated prefix.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the public delegated prefix."""
        UNDEFINED_STATUS = 0
        ANNOUNCED = 365103355
        DELETING = 528602024
        INITIALIZING = 306588749

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    is_live_migration = proto.Field(proto.BOOL, number=511823856, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    parent_prefix = proto.Field(proto.STRING, number=15233991, optional=True,)
    public_delegated_sub_prefixs = proto.RepeatedField(
        proto.MESSAGE,
        number=188940044,
        message="PublicDelegatedPrefixPublicDelegatedSubPrefix",
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class PublicDelegatedPrefixesScopedList(proto.Message):
    r"""
    Attributes:
        public_delegated_prefixes (Sequence[google.cloud.compute_v1.types.PublicDelegatedPrefix]):
            [Output Only] A list of PublicDelegatedPrefixes contained in
            this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of public delegated prefixes when the list is empty.
    """

    public_delegated_prefixes = proto.RepeatedField(
        proto.MESSAGE, number=315261206, message="PublicDelegatedPrefix",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PublicDelegatedPrefixAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.PublicDelegatedPrefixAggregatedList.ItemsEntry]):
            A list of PublicDelegatedPrefixesScopedList
            resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#publicDelegatedPrefixAggregatedList for aggregated
            lists of public delegated prefixes.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="PublicDelegatedPrefixesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class PublicDelegatedPrefixList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.PublicDelegatedPrefix]):
            A list of PublicDelegatedPrefix resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#publicDelegatedPrefixList for public delegated
            prefixes.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="PublicDelegatedPrefix",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class Region(proto.Message):
    r"""Represents a Region resource.

    A region is a geographical area where a resource is located. For
    more information, read Regions and Zones. (== resource_for
    {$api_version}.regions ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            region.
        description (str):
            [Output Only] Textual description of the resource.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#region
            for regions.
        name (str):
            [Output Only] Name of the resource.
        quotas (Sequence[google.cloud.compute_v1.types.Quota]):
            [Output Only] Quotas assigned to this region.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        status (google.cloud.compute_v1.types.Region.Status):
            [Output Only] Status of the region, either UP or DOWN.
        supports_pzs (bool):
            [Output Only] Reserved for future use.
        zones (Sequence[str]):
            [Output Only] A list of zones available in this region, in
            the form of resource URLs.
    """

    class Status(proto.Enum):
        r"""[Output Only] Status of the region, either UP or DOWN."""
        UNDEFINED_STATUS = 0
        DOWN = 2104482
        UP = 2715

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    deprecated = proto.Field(
        proto.MESSAGE, number=515138995, optional=True, message="DeprecationStatus",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    quotas = proto.RepeatedField(proto.MESSAGE, number=125341947, message="Quota",)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    supports_pzs = proto.Field(proto.BOOL, number=83983214, optional=True,)
    zones = proto.RepeatedField(proto.STRING, number=116085319,)


class RegionAutoscalerList(proto.Message):
    r"""Contains a list of autoscalers.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Autoscaler]):
            A list of Autoscaler resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Autoscaler",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionDiskTypeList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.DiskType]):
            A list of DiskType resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#regionDiskTypeList for region disk types.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="DiskType",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionDisksAddResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be added to this disk.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class RegionDisksRemoveResourcePoliciesRequest(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[str]):
            Resource policies to be removed from this
            disk.
    """

    resource_policies = proto.RepeatedField(proto.STRING, number=22220385,)


class RegionDisksResizeRequest(proto.Message):
    r"""
    Attributes:
        size_gb (int):
            The new size of the regional persistent disk,
            which is specified in GB.
    """

    size_gb = proto.Field(proto.INT64, number=494929369, optional=True,)


class RegionInstanceGroupList(proto.Message):
    r"""Contains a list of InstanceGroup resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroup]):
            A list of InstanceGroup resources.
        kind (str):
            The resource type.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceGroup",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionInstanceGroupManagerDeleteInstanceConfigReq(proto.Message):
    r"""RegionInstanceGroupManagers.deletePerInstanceConfigs
    Attributes:
        names (Sequence[str]):
            The list of instance names for which we want
            to delete per-instance configs on this managed
            instance group.
    """

    names = proto.RepeatedField(proto.STRING, number=104585032,)


class RegionInstanceGroupManagerList(proto.Message):
    r"""Contains a list of managed instance groups.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceGroupManager]):
            A list of InstanceGroupManager resources.
        kind (str):
            [Output Only] The resource type, which is always
            compute#instanceGroupManagerList for a list of managed
            instance groups that exist in th regional scope.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceGroupManager",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionInstanceGroupManagerPatchInstanceConfigReq(proto.Message):
    r"""RegionInstanceGroupManagers.patchPerInstanceConfigs
    Attributes:
        per_instance_configs (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            The list of per-instance configs to insert or
            patch on this managed instance group.
    """

    per_instance_configs = proto.RepeatedField(
        proto.MESSAGE, number=526265001, message="PerInstanceConfig",
    )


class RegionInstanceGroupManagerUpdateInstanceConfigReq(proto.Message):
    r"""RegionInstanceGroupManagers.updatePerInstanceConfigs
    Attributes:
        per_instance_configs (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            The list of per-instance configs to insert or
            patch on this managed instance group.
    """

    per_instance_configs = proto.RepeatedField(
        proto.MESSAGE, number=526265001, message="PerInstanceConfig",
    )


class RegionInstanceGroupManagersAbandonInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to abandon. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class RegionInstanceGroupManagersApplyUpdatesRequest(proto.Message):
    r"""RegionInstanceGroupManagers.applyUpdatesToInstances
    Attributes:
        all_instances (bool):
            Flag to update all instances instead of
            specified list of ?instances?. If the flag is
            set to true then the instances may not be
            specified in the request.
        instances (Sequence[str]):
            The list of URLs of one or more instances for which you want
            to apply updates. Each URL can be a full URL or a partial
            URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        minimal_action (str):
            The minimal action that you want to perform
            on each instance during the update: - REPLACE:
            At minimum, delete the instance and create it
            again. - RESTART: Stop the instance and start it
            again. - REFRESH: Do not stop the instance.
            - NONE: Do not disrupt the instance at all.  By
            default, the minimum action is NONE. If your
            update requires a more disruptive action than
            you set with this flag, the necessary action is
            performed to execute the update.
        most_disruptive_allowed_action (str):
            The most disruptive action that you want to
            perform on each instance during the update: -
            REPLACE: Delete the instance and create it
            again. - RESTART: Stop the instance and start it
            again. - REFRESH: Do not stop the instance.
            - NONE: Do not disrupt the instance at all.  By
            default, the most disruptive allowed action is
            REPLACE. If your update requires a more
            disruptive action than you set with this flag,
            the update request will fail.
    """

    all_instances = proto.Field(proto.BOOL, number=403676512, optional=True,)
    instances = proto.RepeatedField(proto.STRING, number=29097598,)
    minimal_action = proto.Field(proto.STRING, number=270567060, optional=True,)
    most_disruptive_allowed_action = proto.Field(
        proto.STRING, number=66103053, optional=True,
    )


class RegionInstanceGroupManagersCreateInstancesRequest(proto.Message):
    r"""RegionInstanceGroupManagers.createInstances
    Attributes:
        instances (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            [Required] List of specifications of per-instance configs.
    """

    instances = proto.RepeatedField(
        proto.MESSAGE, number=29097598, message="PerInstanceConfig",
    )


class RegionInstanceGroupManagersDeleteInstancesRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to delete. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class RegionInstanceGroupManagersListErrorsResponse(proto.Message):
    r"""
    Attributes:
        items (Sequence[google.cloud.compute_v1.types.InstanceManagedByIgmError]):
            [Output Only] The list of errors of the managed instance
            group.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
    """

    @property
    def raw_page(self):
        return self

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceManagedByIgmError",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)


class RegionInstanceGroupManagersListInstanceConfigsResp(proto.Message):
    r"""
    Attributes:
        items (Sequence[google.cloud.compute_v1.types.PerInstanceConfig]):
            [Output Only] The list of PerInstanceConfig.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="PerInstanceConfig",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionInstanceGroupManagersListInstancesResponse(proto.Message):
    r"""
    Attributes:
        managed_instances (Sequence[google.cloud.compute_v1.types.ManagedInstance]):
            A list of managed instances.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
    """

    @property
    def raw_page(self):
        return self

    managed_instances = proto.RepeatedField(
        proto.MESSAGE, number=336219614, message="ManagedInstance",
    )
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)


class RegionInstanceGroupManagersRecreateRequest(proto.Message):
    r"""
    Attributes:
        instances (Sequence[str]):
            The URLs of one or more instances to recreate. This can be a
            full URL or a partial URL, such as
            zones/[ZONE]/instances/[INSTANCE_NAME].
    """

    instances = proto.RepeatedField(proto.STRING, number=29097598,)


class RegionInstanceGroupManagersSetTargetPoolsRequest(proto.Message):
    r"""
    Attributes:
        fingerprint (str):
            Fingerprint of the target pools information,
            which is a hash of the contents. This field is
            used for optimistic locking when you update the
            target pool entries. This field is optional.
        target_pools (Sequence[str]):
            The URL of all TargetPool resources to which
            instances in the instanceGroup field are added.
            The target pools automatically apply to all of
            the instances in the managed instance group.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    target_pools = proto.RepeatedField(proto.STRING, number=336072617,)


class RegionInstanceGroupManagersSetTemplateRequest(proto.Message):
    r"""
    Attributes:
        instance_template (str):
            URL of the InstanceTemplate resource from
            which all new instances will be created.
    """

    instance_template = proto.Field(proto.STRING, number=309248228, optional=True,)


class RegionInstanceGroupsListInstances(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.InstanceWithNamedPorts]):
            A list of InstanceWithNamedPorts resources.
        kind (str):
            The resource type.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="InstanceWithNamedPorts",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionInstanceGroupsListInstancesRequest(proto.Message):
    r"""
    Attributes:
        instance_state (google.cloud.compute_v1.types.RegionInstanceGroupsListInstancesRequest.InstanceState):
            Instances in which state should be returned.
            Valid options are: 'ALL', 'RUNNING'. By default,
            it lists all instances.
        port_name (str):
            Name of port user is interested in. It is
            optional. If it is set, only information about
            this ports will be returned. If it is not set,
            all the named ports will be returned. Always
            lists all instances.
    """

    class InstanceState(proto.Enum):
        r"""Instances in which state should be returned. Valid options
        are: 'ALL', 'RUNNING'. By default, it lists all instances.
        """
        UNDEFINED_INSTANCE_STATE = 0
        ALL = 64897
        RUNNING = 121282975

    instance_state = proto.Field(
        proto.ENUM, number=92223591, optional=True, enum=InstanceState,
    )
    port_name = proto.Field(proto.STRING, number=41534345, optional=True,)


class RegionInstanceGroupsSetNamedPortsRequest(proto.Message):
    r"""
    Attributes:
        fingerprint (str):
            The fingerprint of the named ports
            information for this instance group. Use this
            optional property to prevent conflicts when
            multiple users change the named ports settings
            concurrently. Obtain the fingerprint with the
            instanceGroups.get method. Then, include the
            fingerprint in your request to ensure that you
            do not overwrite changes that were applied from
            another concurrent request.
        named_ports (Sequence[google.cloud.compute_v1.types.NamedPort]):
            The list of named ports to set for this
            instance group.
    """

    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    named_ports = proto.RepeatedField(
        proto.MESSAGE, number=427598732, message="NamedPort",
    )


class RegionList(proto.Message):
    r"""Contains a list of region resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Region]):
            A list of Region resources.
        kind (str):
            [Output Only] Type of resource. Always compute#regionList
            for lists of regions.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Region",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RegionSetLabelsRequest(proto.Message):
    r"""
    Attributes:
        label_fingerprint (str):
            The fingerprint of the previous set of labels
            for this resource, used to detect conflicts. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels. Make a get() request to the
            resource to get the latest fingerprint.
        labels (Sequence[google.cloud.compute_v1.types.RegionSetLabelsRequest.LabelsEntry]):
            The labels to set for this resource.
    """

    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)


class RegionSetPolicyRequest(proto.Message):
    r"""
    Attributes:
        bindings (Sequence[google.cloud.compute_v1.types.Binding]):
            Flatten Policy to create a backwacd
            compatible wire-format. Deprecated. Use 'policy'
            to specify bindings.
        etag (str):
            Flatten Policy to create a backward
            compatible wire-format. Deprecated. Use 'policy'
            to specify the etag.
        policy (google.cloud.compute_v1.types.Policy):
            REQUIRED: The complete policy to be applied
            to the 'resource'. The size of the policy is
            limited to a few 10s of KB. An empty policy is
            in general a valid policy but certain services
            (like Projects) might reject them.
    """

    bindings = proto.RepeatedField(proto.MESSAGE, number=403251854, message="Binding",)
    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    policy = proto.Field(
        proto.MESSAGE, number=91071794, optional=True, message="Policy",
    )


class RegionTargetHttpsProxiesSetSslCertificatesRequest(proto.Message):
    r"""
    Attributes:
        ssl_certificates (Sequence[str]):
            New set of SslCertificate resources to
            associate with this TargetHttpsProxy resource.
            Currently exactly one SslCertificate resource
            must be specified.
    """

    ssl_certificates = proto.RepeatedField(proto.STRING, number=366006543,)


class UrlMap(proto.Message):
    r"""Represents a URL Map resource.

    Google Compute Engine has two URL Map resources:

    -  `Global </compute/docs/reference/rest/{$api_version}/urlMaps>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionUrlMaps>`__

    A URL map resource is a component of certain types of GCP load
    balancers and Traffic Director.

    -  urlMaps are used by external HTTP(S) load balancers and Traffic
       Director. \* regionUrlMaps are used by internal HTTP(S) load
       balancers.

    For a list of supported URL map features by load balancer type, see
    the Load balancing features: Routing and traffic management table.

    For a list of supported URL map features for Traffic Director, see
    the Traffic Director features: Routing and traffic management table.

    This resource defines mappings from host names and URL paths to
    either a backend service or a backend bucket.

    To use the global urlMaps resource, the backend service must have a
    loadBalancingScheme of either EXTERNAL or INTERNAL_SELF_MANAGED. To
    use the regionUrlMaps resource, the backend service must have a
    loadBalancingScheme of INTERNAL_MANAGED. For more information, read
    URL Map Concepts.

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        default_route_action (google.cloud.compute_v1.types.HttpRouteAction):
            defaultRouteAction takes effect when none of
            the  hostRules match. The load balancer performs
            advanced routing actions like URL rewrites,
            header transformations, etc. prior to forwarding
            the request to the selected backend. If
            defaultRouteAction specifies any
            weightedBackendServices, defaultService must not
            be set. Conversely if defaultService is set,
            defaultRouteAction cannot contain any
            weightedBackendServices. Only one of
            defaultRouteAction or defaultUrlRedirect must be
            set. UrlMaps for external HTTP(S) load balancers
            support only the urlRewrite action within
            defaultRouteAction. defaultRouteAction has no
            effect when the URL map is bound to target gRPC
            proxy that has validateForProxyless field set to
            true.
        default_service (str):
            The full or partial URL of the defaultService
            resource to which traffic is directed if none of
            the hostRules match. If defaultRouteAction is
            additionally specified, advanced routing actions
            like URL Rewrites, etc. take effect prior to
            sending the request to the backend. However, if
            defaultService is specified, defaultRouteAction
            cannot contain any weightedBackendServices.
            Conversely, if routeAction specifies any
            weightedBackendServices, service must not be
            specified. Only one of defaultService,
            defaultUrlRedirect  or
            defaultRouteAction.weightedBackendService must
            be set. defaultService has no effect when the
            URL map is bound to target gRPC proxy that has
            validateForProxyless field set to true.
        default_url_redirect (google.cloud.compute_v1.types.HttpRedirectAction):
            When none of the specified hostRules match,
            the request is redirected to a URL specified by
            defaultUrlRedirect. If defaultUrlRedirect is
            specified, defaultService or defaultRouteAction
            must not be set. Not supported when the URL map
            is bound to target gRPC proxy.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a UrlMap. An up-to-date
            fingerprint must be provided in order to update
            the UrlMap, otherwise the request will fail with
            error 412 conditionNotMet.  To see the latest
            fingerprint, make a get() request to retrieve a
            UrlMap.
        header_action (google.cloud.compute_v1.types.HttpHeaderAction):
            Specifies changes to request and response
            headers that need to take effect for the
            selected backendService. The headerAction
            specified here take effect after headerAction
            specified under pathMatcher. Note that
            headerAction is not supported for Loadbalancers
            that have their loadBalancingScheme set to
            EXTERNAL. Not supported when the URL map is
            bound to target gRPC proxy that has
            validateForProxyless field set to true.
        host_rules (Sequence[google.cloud.compute_v1.types.HostRule]):
            The list of HostRules to use against the URL.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#urlMaps
            for url maps.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        path_matchers (Sequence[google.cloud.compute_v1.types.PathMatcher]):
            The list of named PathMatchers to use against
            the URL.
        region (str):
            [Output Only] URL of the region where the regional URL map
            resides. This field is not applicable to global URL maps.
            You must specify this field as part of the HTTP request URL.
            It is not settable as a field in the request body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        tests (Sequence[google.cloud.compute_v1.types.UrlMapTest]):
            The list of expected URL mapping tests.
            Request to update this UrlMap will succeed only
            if all of the test cases pass. You can specify a
            maximum of 100 tests per UrlMap. Not supported
            when the URL map is bound to target gRPC proxy
            that has validateForProxyless field set to true.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    default_route_action = proto.Field(
        proto.MESSAGE, number=378919466, optional=True, message="HttpRouteAction",
    )
    default_service = proto.Field(proto.STRING, number=370242231, optional=True,)
    default_url_redirect = proto.Field(
        proto.MESSAGE, number=359503338, optional=True, message="HttpRedirectAction",
    )
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    header_action = proto.Field(
        proto.MESSAGE, number=328077352, optional=True, message="HttpHeaderAction",
    )
    host_rules = proto.RepeatedField(
        proto.MESSAGE, number=311804832, message="HostRule",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    path_matchers = proto.RepeatedField(
        proto.MESSAGE, number=271664219, message="PathMatcher",
    )
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    tests = proto.RepeatedField(proto.MESSAGE, number=110251553, message="UrlMapTest",)


class RegionUrlMapsValidateRequest(proto.Message):
    r"""
    Attributes:
        resource (google.cloud.compute_v1.types.UrlMap):
            Content of the UrlMap to be validated.
    """

    resource = proto.Field(
        proto.MESSAGE, number=195806222, optional=True, message="UrlMap",
    )


class ReservationsScopedList(proto.Message):
    r"""
    Attributes:
        reservations (Sequence[google.cloud.compute_v1.types.Reservation]):
            A list of reservations contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of reservations when the list is empty.
    """

    reservations = proto.RepeatedField(
        proto.MESSAGE, number=399717927, message="Reservation",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ReservationAggregatedList(proto.Message):
    r"""Contains a list of reservations.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ReservationAggregatedList.ItemsEntry]):
            A list of Allocation resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="ReservationsScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ReservationList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        items (Sequence[google.cloud.compute_v1.types.Reservation]):
            [Output Only] A list of Allocation resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#reservationsList for listsof reservations
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Reservation",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ReservationsResizeRequest(proto.Message):
    r"""
    Attributes:
        specific_sku_count (int):
            Number of allocated resources can be resized
            with minimum = 1 and maximum = 1000.
    """

    specific_sku_count = proto.Field(proto.INT64, number=13890720, optional=True,)


class ResourceGroupReference(proto.Message):
    r"""
    Attributes:
        group (str):
            A URI referencing one of the instance groups
            or network endpoint groups listed in the backend
            service.
    """

    group = proto.Field(proto.STRING, number=98629247, optional=True,)


class ResourcePolicy(proto.Message):
    r"""Represents a Resource Policy resource. You can use resource policies
    to schedule actions for some Compute Engine resources. For example,
    you can use them to schedule persistent disk snapshots.

    (== resource_for {$api_version}.resourcePolicies ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):

        group_placement_policy (google.cloud.compute_v1.types.ResourcePolicyGroupPlacementPolicy):
            Resource policy for instances for placement
            configuration.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        instance_schedule_policy (google.cloud.compute_v1.types.ResourcePolicyInstanceSchedulePolicy):
            Resource policy for scheduling instance
            operations.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#resource_policies for resource policies.
        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The resource name must be
            1-63 characters long, and comply with RFC1035. Specifically,
            the name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        region (str):

        resource_status (google.cloud.compute_v1.types.ResourcePolicyResourceStatus):
            [Output Only] The system status of the resource policy.
        self_link (str):
            [Output Only] Server-defined fully-qualified URL for this
            resource.
        snapshot_schedule_policy (google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicy):
            Resource policy for persistent disks for
            creating snapshots.
        status (google.cloud.compute_v1.types.ResourcePolicy.Status):
            [Output Only] The status of resource policy creation.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of resource policy creation."""
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        EXPIRED = 482489093
        INVALID = 530283991
        READY = 77848963

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    group_placement_policy = proto.Field(
        proto.MESSAGE,
        number=10931596,
        optional=True,
        message="ResourcePolicyGroupPlacementPolicy",
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    instance_schedule_policy = proto.Field(
        proto.MESSAGE,
        number=344877104,
        optional=True,
        message="ResourcePolicyInstanceSchedulePolicy",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    resource_status = proto.Field(
        proto.MESSAGE,
        number=249429315,
        optional=True,
        message="ResourcePolicyResourceStatus",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    snapshot_schedule_policy = proto.Field(
        proto.MESSAGE,
        number=218131295,
        optional=True,
        message="ResourcePolicySnapshotSchedulePolicy",
    )
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class ResourcePoliciesScopedList(proto.Message):
    r"""
    Attributes:
        resource_policies (Sequence[google.cloud.compute_v1.types.ResourcePolicy]):
            A list of resourcePolicies contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of resourcePolicies when the list is empty.
    """

    resource_policies = proto.RepeatedField(
        proto.MESSAGE, number=22220385, message="ResourcePolicy",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ResourcePolicyGroupPlacementPolicy(proto.Message):
    r"""A GroupPlacementPolicy specifies resource placement
    configuration. It specifies the failure bucket separation as
    well as network locality

    Attributes:
        availability_domain_count (int):
            The number of availability domains instances
            will be spread across. If two instances are in
            different availability domain, they will not be
            put in the same low latency network
        collocation (google.cloud.compute_v1.types.ResourcePolicyGroupPlacementPolicy.Collocation):
            Specifies network collocation
        vm_count (int):
            Number of vms in this placement group
    """

    class Collocation(proto.Enum):
        r"""Specifies network collocation"""
        UNDEFINED_COLLOCATION = 0
        COLLOCATED = 103257554
        UNSPECIFIED_COLLOCATION = 464308205

    availability_domain_count = proto.Field(
        proto.INT32, number=12453432, optional=True,
    )
    collocation = proto.Field(
        proto.ENUM, number=511156533, optional=True, enum=Collocation,
    )
    vm_count = proto.Field(proto.INT32, number=261463431, optional=True,)


class ResourcePolicyInstanceSchedulePolicy(proto.Message):
    r"""An InstanceSchedulePolicy specifies when and how frequent
    certain operations are performed on the instance.

    Attributes:
        expiration_time (str):
            The expiration time of the schedule. The
            timestamp is an RFC3339 string.
        start_time (str):
            The start time of the schedule. The timestamp
            is an RFC3339 string.
        time_zone (str):
            Specifies the time zone to be used in interpreting
            Schedule.schedule. The value of this field must be a time
            zone name from the tz database:
            http://en.wikipedia.org/wiki/Tz_database.
        vm_start_schedule (google.cloud.compute_v1.types.ResourcePolicyInstanceSchedulePolicySchedule):
            Specifies the schedule for starting
            instances.
        vm_stop_schedule (google.cloud.compute_v1.types.ResourcePolicyInstanceSchedulePolicySchedule):
            Specifies the schedule for stopping
            instances.
    """

    expiration_time = proto.Field(proto.STRING, number=230299229, optional=True,)
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)
    time_zone = proto.Field(proto.STRING, number=36848094, optional=True,)
    vm_start_schedule = proto.Field(
        proto.MESSAGE,
        number=17762396,
        optional=True,
        message="ResourcePolicyInstanceSchedulePolicySchedule",
    )
    vm_stop_schedule = proto.Field(
        proto.MESSAGE,
        number=426242732,
        optional=True,
        message="ResourcePolicyInstanceSchedulePolicySchedule",
    )


class ResourcePolicyResourceStatus(proto.Message):
    r"""Contains output only fields. Use this sub-message for all
    output fields set on ResourcePolicy. The internal structure of
    this "status" field should mimic the structure of ResourcePolicy
    proto specification.

    Attributes:
        instance_schedule_policy (google.cloud.compute_v1.types.ResourcePolicyResourceStatusInstanceSchedulePolicyStatus):
            [Output Only] Specifies a set of output values reffering to
            the instance_schedule_policy system status. This field
            should have the same name as corresponding policy field.
    """

    instance_schedule_policy = proto.Field(
        proto.MESSAGE,
        number=344877104,
        optional=True,
        message="ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
    )


class ResourcePolicySnapshotSchedulePolicy(proto.Message):
    r"""A snapshot schedule policy specifies when and how frequently
    snapshots are to be created for the target disk. Also specifies
    how many and how long these scheduled snapshots should be
    retained.

    Attributes:
        retention_policy (google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicyRetentionPolicy):
            Retention policy applied to snapshots created
            by this resource policy.
        schedule (google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicySchedule):
            A Vm Maintenance Policy specifies what kind
            of infrastructure maintenance we are allowed to
            perform on this VM and when. Schedule that is
            applied to disks covered by this policy.
        snapshot_properties (google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicySnapshotProperties):
            Properties with which snapshots are created
            such as labels, encryption keys.
    """

    retention_policy = proto.Field(
        proto.MESSAGE,
        number=68625779,
        optional=True,
        message="ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    )
    schedule = proto.Field(
        proto.MESSAGE,
        number=375820951,
        optional=True,
        message="ResourcePolicySnapshotSchedulePolicySchedule",
    )
    snapshot_properties = proto.Field(
        proto.MESSAGE,
        number=185371278,
        optional=True,
        message="ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    )


class ResourcePolicyAggregatedList(proto.Message):
    r"""Contains a list of resourcePolicies.
    Attributes:
        etag (str):

        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.ResourcePolicyAggregatedList.ItemsEntry]):
            A list of ResourcePolicy resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="ResourcePoliciesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ResourcePolicyDailyCycle(proto.Message):
    r"""Time window specified for daily operations.
    Attributes:
        days_in_cycle (int):
            Defines a schedule with units measured in
            months. The value determines how many months
            pass between the start of each cycle.
        duration (str):
            [Output only] A predetermined duration for the window,
            automatically chosen to be the smallest possible in the
            given scenario.
        start_time (str):
            Start time of the window. This must be in UTC
            format that resolves to one of 00:00, 04:00,
            08:00, 12:00, 16:00, or 20:00. For example, both
            13:00-5 and 08:00 are valid.
    """

    days_in_cycle = proto.Field(proto.INT32, number=369790004, optional=True,)
    duration = proto.Field(proto.STRING, number=155471252, optional=True,)
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)


class ResourcePolicyHourlyCycle(proto.Message):
    r"""Time window specified for hourly operations.
    Attributes:
        duration (str):
            [Output only] Duration of the time window, automatically
            chosen to be smallest possible in the given scenario.
        hours_in_cycle (int):
            Defines a schedule with units measured in
            hours. The value determines how many hours pass
            between the start of each cycle.
        start_time (str):
            Time within the window to start the operations. It must be
            in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
    """

    duration = proto.Field(proto.STRING, number=155471252, optional=True,)
    hours_in_cycle = proto.Field(proto.INT32, number=526763132, optional=True,)
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)


class ResourcePolicyInstanceSchedulePolicySchedule(proto.Message):
    r"""Schedule for an instance operation.
    Attributes:
        schedule (str):
            Specifies the frequency for the operation,
            using the unix-cron format.
    """

    schedule = proto.Field(proto.STRING, number=375820951, optional=True,)


class ResourcePolicyList(proto.Message):
    r"""
    Attributes:
        etag (str):

        id (str):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        items (Sequence[google.cloud.compute_v1.types.ResourcePolicy]):
            [Output Only] A list of ResourcePolicy resources.
        kind (str):
            [Output Only] Type of resource.Always
            compute#resourcePoliciesList for listsof resourcePolicies
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    etag = proto.Field(proto.STRING, number=3123477, optional=True,)
    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="ResourcePolicy",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class ResourcePolicyResourceStatusInstanceSchedulePolicyStatus(proto.Message):
    r"""
    Attributes:
        last_run_start_time (str):
            [Output Only] The last time the schedule successfully ran.
            The timestamp is an RFC3339 string.
        next_run_start_time (str):
            [Output Only] The next time the schedule is planned to run.
            The actual time might be slightly different. The timestamp
            is an RFC3339 string.
    """

    last_run_start_time = proto.Field(proto.STRING, number=303069063, optional=True,)
    next_run_start_time = proto.Field(proto.STRING, number=318642570, optional=True,)


class ResourcePolicySnapshotSchedulePolicyRetentionPolicy(proto.Message):
    r"""Policy for retention of scheduled snapshots.
    Attributes:
        max_retention_days (int):
            Maximum age of the snapshot that is allowed
            to be kept.
        on_source_disk_delete (google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicyRetentionPolicy.OnSourceDiskDelete):
            Specifies the behavior to apply to scheduled
            snapshots when the source disk is deleted.
    """

    class OnSourceDiskDelete(proto.Enum):
        r"""Specifies the behavior to apply to scheduled snapshots when
        the source disk is deleted.
        """
        UNDEFINED_ON_SOURCE_DISK_DELETE = 0
        APPLY_RETENTION_POLICY = 535071332
        KEEP_AUTO_SNAPSHOTS = 258925689
        UNSPECIFIED_ON_SOURCE_DISK_DELETE = 239140769

    max_retention_days = proto.Field(proto.INT32, number=324296979, optional=True,)
    on_source_disk_delete = proto.Field(
        proto.ENUM, number=321955529, optional=True, enum=OnSourceDiskDelete,
    )


class ResourcePolicySnapshotSchedulePolicySchedule(proto.Message):
    r"""A schedule for disks where the schedueled operations are
    performed.

    Attributes:
        daily_schedule (google.cloud.compute_v1.types.ResourcePolicyDailyCycle):

        hourly_schedule (google.cloud.compute_v1.types.ResourcePolicyHourlyCycle):

        weekly_schedule (google.cloud.compute_v1.types.ResourcePolicyWeeklyCycle):

    """

    daily_schedule = proto.Field(
        proto.MESSAGE,
        number=86159869,
        optional=True,
        message="ResourcePolicyDailyCycle",
    )
    hourly_schedule = proto.Field(
        proto.MESSAGE,
        number=38328485,
        optional=True,
        message="ResourcePolicyHourlyCycle",
    )
    weekly_schedule = proto.Field(
        proto.MESSAGE,
        number=359548053,
        optional=True,
        message="ResourcePolicyWeeklyCycle",
    )


class ResourcePolicySnapshotSchedulePolicySnapshotProperties(proto.Message):
    r"""Specified snapshot properties for scheduled snapshots created
    by this policy.

    Attributes:
        chain_name (str):
            Chain name that the snapshot is created in.
        guest_flush (bool):
            Indication to perform a 'guest aware'
            snapshot.
        labels (Sequence[google.cloud.compute_v1.types.ResourcePolicySnapshotSchedulePolicySnapshotProperties.LabelsEntry]):
            Labels to apply to scheduled snapshots. These
            can be later modified by the setLabels method.
            Label values may be empty.
        storage_locations (Sequence[str]):
            Cloud Storage bucket storage location of the
            auto snapshot (regional or multi-regional).
    """

    chain_name = proto.Field(proto.STRING, number=68644169, optional=True,)
    guest_flush = proto.Field(proto.BOOL, number=385550813, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    storage_locations = proto.RepeatedField(proto.STRING, number=328005274,)


class ResourcePolicyWeeklyCycle(proto.Message):
    r"""Time window specified for weekly operations.
    Attributes:
        day_of_weeks (Sequence[google.cloud.compute_v1.types.ResourcePolicyWeeklyCycleDayOfWeek]):
            Up to 7 intervals/windows, one for each day
            of the week.
    """

    day_of_weeks = proto.RepeatedField(
        proto.MESSAGE, number=257871834, message="ResourcePolicyWeeklyCycleDayOfWeek",
    )


class ResourcePolicyWeeklyCycleDayOfWeek(proto.Message):
    r"""
    Attributes:
        day (google.cloud.compute_v1.types.ResourcePolicyWeeklyCycleDayOfWeek.Day):
            Defines a schedule that runs on specific days
            of the week. Specify one or more days. The
            following options are available: MONDAY,
            TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY,
            SUNDAY.
        duration (str):
            [Output only] Duration of the time window, automatically
            chosen to be smallest possible in the given scenario.
        start_time (str):
            Time within the window to start the operations. It must be
            in format "HH:MM", where HH : [00-23] and MM : [00-00] GMT.
    """

    class Day(proto.Enum):
        r"""Defines a schedule that runs on specific days of the week.
        Specify one or more days. The following options are available:
        MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
        """
        UNDEFINED_DAY = 0
        FRIDAY = 471398751
        INVALID = 530283991
        MONDAY = 132310288
        SATURDAY = 279037881
        SUNDAY = 309626320
        THURSDAY = 207198682
        TUESDAY = 277509677
        WEDNESDAY = 422029110

    day = proto.Field(proto.ENUM, number=99228, optional=True, enum=Day,)
    duration = proto.Field(proto.STRING, number=155471252, optional=True,)
    start_time = proto.Field(proto.STRING, number=37467274, optional=True,)


class Route(proto.Message):
    r"""Represents a Route resource.

    A route defines a path from VM instances in the VPC network to a
    specific destination. This destination can be inside or outside the
    VPC network. For more information, read the Routes overview. (==
    resource_for {$api_version}.routes ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.
        dest_range (str):
            The destination range of outgoing packets
            that this route applies to. Both IPv4 and IPv6
            are supported.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of this resource. Always compute#routes
            for Route resources.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``. The first character must be
            a lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.
        network (str):
            Fully-qualified URL of the network that this
            route applies to.
        next_hop_gateway (str):
            The URL to a gateway that should handle
            matching packets. You can only specify the
            internet gateway using a full or partial valid
            URL:  projects/project/global/gateways/default-
            internet-gateway
        next_hop_ilb (str):
            The URL to a forwarding rule of type
            loadBalancingScheme=INTERNAL that should handle
            matching packets or the IP address of the
            forwarding Rule. For example, the following are
            all valid URLs: - 10.128.0.56 -
            https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
            - regions/region/forwardingRules/forwardingRule
        next_hop_instance (str):
            The URL to an instance that should handle
            matching packets. You can specify this as a full
            or partial URL. For example:
            https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/
        next_hop_ip (str):
            The network IP address of an instance that
            should handle matching packets. Only IPv4 is
            supported.
        next_hop_network (str):
            The URL of the local network if it should
            handle matching packets.
        next_hop_peering (str):
            [Output Only] The network peering name that should handle
            matching packets, which should conform to RFC1035.
        next_hop_vpn_tunnel (str):
            The URL to a VpnTunnel that should handle
            matching packets.
        priority (int):
            The priority of this route. Priority is used to break ties
            in cases where there is more than one matching route of
            equal prefix length. In cases where multiple routes have
            equal prefix length, the one with the lowest-numbered
            priority value wins. The default value is ``1000``. The
            priority value must be from ``0`` to ``65535``, inclusive.
        self_link (str):
            [Output Only] Server-defined fully-qualified URL for this
            resource.
        tags (Sequence[str]):
            A list of instance tags to which this route
            applies.
        warnings (Sequence[google.cloud.compute_v1.types.Warnings]):
            [Output Only] If potential misconfigurations are detected
            for this route, this field will be populated with warning
            messages.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    dest_range = proto.Field(proto.STRING, number=381327712, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    next_hop_gateway = proto.Field(proto.STRING, number=377175298, optional=True,)
    next_hop_ilb = proto.Field(proto.STRING, number=198679901, optional=True,)
    next_hop_instance = proto.Field(proto.STRING, number=393508247, optional=True,)
    next_hop_ip = proto.Field(proto.STRING, number=110319529, optional=True,)
    next_hop_network = proto.Field(proto.STRING, number=262295788, optional=True,)
    next_hop_peering = proto.Field(proto.STRING, number=412682750, optional=True,)
    next_hop_vpn_tunnel = proto.Field(proto.STRING, number=519844501, optional=True,)
    priority = proto.Field(proto.UINT32, number=445151652, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    tags = proto.RepeatedField(proto.STRING, number=3552281,)
    warnings = proto.RepeatedField(proto.MESSAGE, number=498091095, message="Warnings",)


class RouteList(proto.Message):
    r"""Contains a list of Route resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Route]):
            A list of Route resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Route",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RouterBgp(proto.Message):
    r"""
    Attributes:
        advertise_mode (google.cloud.compute_v1.types.RouterBgp.AdvertiseMode):
            User-specified flag to indicate which mode to
            use for advertisement. The options are DEFAULT
            or CUSTOM.
        advertised_groups (Sequence[google.cloud.compute_v1.types.RouterBgp.AdvertisedGroups]):
            User-specified list of prefix groups to advertise in custom
            mode. This field can only be populated if advertise_mode is
            CUSTOM and is advertised to all peers of the router. These
            groups will be advertised in addition to any specified
            prefixes. Leave this field blank to advertise no custom
            groups.
        advertised_ip_ranges (Sequence[google.cloud.compute_v1.types.RouterAdvertisedIpRange]):
            User-specified list of individual IP ranges to advertise in
            custom mode. This field can only be populated if
            advertise_mode is CUSTOM and is advertised to all peers of
            the router. These IP ranges will be advertised in addition
            to any specified groups. Leave this field blank to advertise
            no custom IP ranges.
        asn (int):
            Local BGP Autonomous System Number (ASN).
            Must be an RFC6996 private ASN, either 16-bit or
            32-bit. The value will be fixed for this router
            resource. All VPN tunnels that link to this
            router will have the same local ASN.
    """

    class AdvertiseMode(proto.Enum):
        r"""User-specified flag to indicate which mode to use for
        advertisement. The options are DEFAULT or CUSTOM.
        """
        UNDEFINED_ADVERTISE_MODE = 0
        CUSTOM = 388595569
        DEFAULT = 115302945

    class AdvertisedGroups(proto.Enum):
        r""""""
        UNDEFINED_ADVERTISED_GROUPS = 0
        ALL_SUBNETS = 3622872

    advertise_mode = proto.Field(
        proto.ENUM, number=312134331, optional=True, enum=AdvertiseMode,
    )
    advertised_groups = proto.RepeatedField(
        proto.ENUM, number=21065526, enum=AdvertisedGroups,
    )
    advertised_ip_ranges = proto.RepeatedField(
        proto.MESSAGE, number=35449932, message="RouterAdvertisedIpRange",
    )
    asn = proto.Field(proto.UINT32, number=96892, optional=True,)


class RouterBgpPeer(proto.Message):
    r"""
    Attributes:
        advertise_mode (google.cloud.compute_v1.types.RouterBgpPeer.AdvertiseMode):
            User-specified flag to indicate which mode to
            use for advertisement.
        advertised_groups (Sequence[google.cloud.compute_v1.types.RouterBgpPeer.AdvertisedGroups]):
            User-specified list of prefix groups to advertise in custom
            mode, which can take one of the following options:

            -  ALL_SUBNETS: Advertises all available subnets, including
               peer VPC subnets.
            -  ALL_VPC_SUBNETS: Advertises the router's own VPC subnets.
               Note that this field can only be populated if
               advertise_mode is CUSTOM and overrides the list defined
               for the router (in the "bgp" message). These groups are
               advertised in addition to any specified prefixes. Leave
               this field blank to advertise no custom groups.
        advertised_ip_ranges (Sequence[google.cloud.compute_v1.types.RouterAdvertisedIpRange]):
            User-specified list of individual IP ranges to advertise in
            custom mode. This field can only be populated if
            advertise_mode is CUSTOM and overrides the list defined for
            the router (in the "bgp" message). These IP ranges are
            advertised in addition to any specified groups. Leave this
            field blank to advertise no custom IP ranges.
        advertised_route_priority (int):
            The priority of routes advertised to this BGP
            peer. Where there is more than one matching
            route of maximum length, the routes with the
            lowest priority value win.
        interface_name (str):
            Name of the interface the BGP peer is
            associated with.
        ip_address (str):
            IP address of the interface inside Google
            Cloud Platform. Only IPv4 is supported.
        management_type (google.cloud.compute_v1.types.RouterBgpPeer.ManagementType):
            [Output Only] The resource that configures and manages this
            BGP peer.

            -  MANAGED_BY_USER is the default value and can be managed
               by you or other users
            -  MANAGED_BY_ATTACHMENT is a BGP peer that is configured
               and managed by Cloud Interconnect, specifically by an
               InterconnectAttachment of type PARTNER. Google
               automatically creates, updates, and deletes this type of
               BGP peer when the PARTNER InterconnectAttachment is
               created, updated, or deleted.
        name (str):
            Name of this BGP peer. The name must be 1-63 characters
            long, and comply with RFC1035. Specifically, the name must
            be 1-63 characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        peer_asn (int):
            Peer BGP Autonomous System Number (ASN). Each
            BGP interface may use a different value.
        peer_ip_address (str):
            IP address of the BGP interface outside
            Google Cloud Platform. Only IPv4 is supported.
    """

    class AdvertiseMode(proto.Enum):
        r"""User-specified flag to indicate which mode to use for
        advertisement.
        """
        UNDEFINED_ADVERTISE_MODE = 0
        CUSTOM = 388595569
        DEFAULT = 115302945

    class AdvertisedGroups(proto.Enum):
        r""""""
        UNDEFINED_ADVERTISED_GROUPS = 0
        ALL_SUBNETS = 3622872

    class ManagementType(proto.Enum):
        r"""[Output Only] The resource that configures and manages this BGP
        peer.

        -  MANAGED_BY_USER is the default value and can be managed by you or
           other users
        -  MANAGED_BY_ATTACHMENT is a BGP peer that is configured and
           managed by Cloud Interconnect, specifically by an
           InterconnectAttachment of type PARTNER. Google automatically
           creates, updates, and deletes this type of BGP peer when the
           PARTNER InterconnectAttachment is created, updated, or deleted.
        """
        UNDEFINED_MANAGEMENT_TYPE = 0
        MANAGED_BY_ATTACHMENT = 458926411
        MANAGED_BY_USER = 317294067

    advertise_mode = proto.Field(
        proto.ENUM, number=312134331, optional=True, enum=AdvertiseMode,
    )
    advertised_groups = proto.RepeatedField(
        proto.ENUM, number=21065526, enum=AdvertisedGroups,
    )
    advertised_ip_ranges = proto.RepeatedField(
        proto.MESSAGE, number=35449932, message="RouterAdvertisedIpRange",
    )
    advertised_route_priority = proto.Field(
        proto.UINT32, number=186486332, optional=True,
    )
    interface_name = proto.Field(proto.STRING, number=437854673, optional=True,)
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    management_type = proto.Field(
        proto.ENUM, number=173703606, optional=True, enum=ManagementType,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    peer_asn = proto.Field(proto.UINT32, number=69573151, optional=True,)
    peer_ip_address = proto.Field(proto.STRING, number=207735769, optional=True,)


class RouterInterface(proto.Message):
    r"""
    Attributes:
        ip_range (str):
            IP address and range of the interface. The IP
            range must be in the RFC3927 link-local IP
            address space. The value must be a CIDR-
            formatted string, for example: 169.254.0.1/30.
            NOTE: Do not truncate the address as it
            represents the IP address of the interface.
        linked_interconnect_attachment (str):
            URI of the linked Interconnect attachment. It
            must be in the same region as the router. Each
            interface can have one linked resource, which
            can be a VPN tunnel, an Interconnect attachment,
            or a virtual machine instance.
        linked_vpn_tunnel (str):
            URI of the linked VPN tunnel, which must be
            in the same region as the router. Each interface
            can have one linked resource, which can be a VPN
            tunnel, an Interconnect attachment, or a virtual
            machine instance.
        management_type (google.cloud.compute_v1.types.RouterInterface.ManagementType):
            [Output Only] The resource that configures and manages this
            interface.

            -  MANAGED_BY_USER is the default value and can be managed
               directly by users.
            -  MANAGED_BY_ATTACHMENT is an interface that is configured
               and managed by Cloud Interconnect, specifically, by an
               InterconnectAttachment of type PARTNER. Google
               automatically creates, updates, and deletes this type of
               interface when the PARTNER InterconnectAttachment is
               created, updated, or deleted.
        name (str):
            Name of this interface entry. The name must be 1-63
            characters long, and comply with RFC1035. Specifically, the
            name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
    """

    class ManagementType(proto.Enum):
        r"""[Output Only] The resource that configures and manages this
        interface.

        -  MANAGED_BY_USER is the default value and can be managed directly
           by users.
        -  MANAGED_BY_ATTACHMENT is an interface that is configured and
           managed by Cloud Interconnect, specifically, by an
           InterconnectAttachment of type PARTNER. Google automatically
           creates, updates, and deletes this type of interface when the
           PARTNER InterconnectAttachment is created, updated, or deleted.
        """
        UNDEFINED_MANAGEMENT_TYPE = 0
        MANAGED_BY_ATTACHMENT = 458926411
        MANAGED_BY_USER = 317294067

    ip_range = proto.Field(proto.STRING, number=145092645, optional=True,)
    linked_interconnect_attachment = proto.Field(
        proto.STRING, number=501085518, optional=True,
    )
    linked_vpn_tunnel = proto.Field(proto.STRING, number=352296953, optional=True,)
    management_type = proto.Field(
        proto.ENUM, number=173703606, optional=True, enum=ManagementType,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)


class RouterNat(proto.Message):
    r"""Represents a Nat resource. It enables the VMs within the
    specified subnetworks to access Internet without external IP
    addresses. It specifies a list of subnetworks (and the ranges
    within) that want to use NAT. Customers can also provide the
    external IPs that would be used for NAT. GCP would auto-allocate
    ephemeral IPs if no external IPs are provided.

    Attributes:
        drain_nat_ips (Sequence[str]):
            A list of URLs of the IP resources to be
            drained. These IPs must be valid static external
            IPs that have been assigned to the NAT. These
            IPs should be used for updating/patching a NAT
            only.
        enable_endpoint_independent_mapping (bool):

        icmp_idle_timeout_sec (int):
            Timeout (in seconds) for ICMP connections.
            Defaults to 30s if not set.
        log_config (google.cloud.compute_v1.types.RouterNatLogConfig):
            Configure logging on this NAT.
        min_ports_per_vm (int):
            Minimum number of ports allocated to a VM
            from this NAT config. If not set, a default
            number of ports is allocated to a VM. This is
            rounded up to the nearest power of 2. For
            example, if the value of this field is 50, at
            least 64 ports are allocated to a VM.
        name (str):
            Unique name of this Nat service. The name
            must be 1-63 characters long and comply with
            RFC1035.
        nat_ip_allocate_option (google.cloud.compute_v1.types.RouterNat.NatIpAllocateOption):
            Specify the NatIpAllocateOption, which can take one of the
            following values:

            -  MANUAL_ONLY: Uses only Nat IP addresses provided by
               customers. When there are not enough specified Nat IPs,
               the Nat service fails for new VMs.
            -  AUTO_ONLY: Nat IPs are allocated by Google Cloud
               Platform; customers can't specify any Nat IPs. When
               choosing AUTO_ONLY, then nat_ip should be empty.
        nat_ips (Sequence[str]):
            A list of URLs of the IP resources used for
            this Nat service. These IP addresses must be
            valid static external IP addresses assigned to
            the project.
        source_subnetwork_ip_ranges_to_nat (google.cloud.compute_v1.types.RouterNat.SourceSubnetworkIpRangesToNat):
            Specify the Nat option, which can take one of the following
            values:

            -  ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in
               every Subnetwork are allowed to Nat.
            -  ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary
               IP ranges in every Subnetwork are allowed to Nat.
            -  LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to
               Nat (specified in the field subnetwork below) The default
               is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note
               that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES
               or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there
               should not be any other Router.Nat section in any Router
               for this network in this region.
        subnetworks (Sequence[google.cloud.compute_v1.types.RouterNatSubnetworkToNat]):
            A list of Subnetwork resources whose traffic should be
            translated by NAT Gateway. It is used only when
            LIST_OF_SUBNETWORKS is selected for the
            SubnetworkIpRangeToNatOption above.
        tcp_established_idle_timeout_sec (int):
            Timeout (in seconds) for TCP established
            connections. Defaults to 1200s if not set.
        tcp_transitory_idle_timeout_sec (int):
            Timeout (in seconds) for TCP transitory
            connections. Defaults to 30s if not set.
        udp_idle_timeout_sec (int):
            Timeout (in seconds) for UDP connections.
            Defaults to 30s if not set.
    """

    class NatIpAllocateOption(proto.Enum):
        r"""Specify the NatIpAllocateOption, which can take one of the following
        values:

        -  MANUAL_ONLY: Uses only Nat IP addresses provided by customers.
           When there are not enough specified Nat IPs, the Nat service
           fails for new VMs.
        -  AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform;
           customers can't specify any Nat IPs. When choosing AUTO_ONLY,
           then nat_ip should be empty.
        """
        UNDEFINED_NAT_IP_ALLOCATE_OPTION = 0
        AUTO_ONLY = 182333500
        MANUAL_ONLY = 261251205

    class SourceSubnetworkIpRangesToNat(proto.Enum):
        r"""Specify the Nat option, which can take one of the following values:

        -  ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every
           Subnetwork are allowed to Nat.
        -  ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP
           ranges in every Subnetwork are allowed to Nat.
        -  LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat
           (specified in the field subnetwork below) The default is
           SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this
           field contains ALL_SUBNETWORKS_ALL_IP_RANGES or
           ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be
           any other Router.Nat section in any Router for this network in
           this region.
        """
        UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT = 0
        ALL_SUBNETWORKS_ALL_IP_RANGES = 179964376
        ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES = 185573819
        LIST_OF_SUBNETWORKS = 517542270

    drain_nat_ips = proto.RepeatedField(proto.STRING, number=504078535,)
    enable_endpoint_independent_mapping = proto.Field(
        proto.BOOL, number=259441819, optional=True,
    )
    icmp_idle_timeout_sec = proto.Field(proto.INT32, number=3647562, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="RouterNatLogConfig",
    )
    min_ports_per_vm = proto.Field(proto.INT32, number=186193587, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    nat_ip_allocate_option = proto.Field(
        proto.ENUM, number=429726845, optional=True, enum=NatIpAllocateOption,
    )
    nat_ips = proto.RepeatedField(proto.STRING, number=117635086,)
    source_subnetwork_ip_ranges_to_nat = proto.Field(
        proto.ENUM, number=252213211, optional=True, enum=SourceSubnetworkIpRangesToNat,
    )
    subnetworks = proto.RepeatedField(
        proto.MESSAGE, number=415853125, message="RouterNatSubnetworkToNat",
    )
    tcp_established_idle_timeout_sec = proto.Field(
        proto.INT32, number=223098349, optional=True,
    )
    tcp_transitory_idle_timeout_sec = proto.Field(
        proto.INT32, number=205028774, optional=True,
    )
    udp_idle_timeout_sec = proto.Field(proto.INT32, number=64919878, optional=True,)


class Router(proto.Message):
    r"""Represents a Cloud Router resource.
    For more information about Cloud Router, read the Cloud Router
    overview.

    Attributes:
        bgp (google.cloud.compute_v1.types.RouterBgp):
            BGP information specific to this router.
        bgp_peers (Sequence[google.cloud.compute_v1.types.RouterBgpPeer]):
            BGP information that must be configured into
            the routing stack to establish BGP peering. This
            information must specify the peer ASN and either
            the interface name, IP address, or peer IP
            address. Please refer to RFC4273.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        encrypted_interconnect_router (bool):
            Field to indicate if a router is dedicated to
            use with encrypted Interconnect Attachment
            (IPsec-encrypted Cloud Interconnect feature).
            Not currently available in all Interconnect
            locations.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        interfaces (Sequence[google.cloud.compute_v1.types.RouterInterface]):
            Router interfaces. Each interface requires
            either one linked resource, (for example,
            linkedVpnTunnel), or IP address and IP address
            range (for example, ipRange), or both.
        kind (str):
            [Output Only] Type of resource. Always compute#router for
            routers.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        nats (Sequence[google.cloud.compute_v1.types.RouterNat]):
            A list of NAT services created in this
            router.
        network (str):
            URI of the network to which this router
            belongs.
        region (str):
            [Output Only] URI of the region where the router resides.
            You must specify this field as part of the HTTP request URL.
            It is not settable as a field in the request body.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    bgp = proto.Field(proto.MESSAGE, number=97483, optional=True, message="RouterBgp",)
    bgp_peers = proto.RepeatedField(
        proto.MESSAGE, number=452695773, message="RouterBgpPeer",
    )
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    encrypted_interconnect_router = proto.Field(
        proto.BOOL, number=297996575, optional=True,
    )
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    interfaces = proto.RepeatedField(
        proto.MESSAGE, number=12073562, message="RouterInterface",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    nats = proto.RepeatedField(proto.MESSAGE, number=3373938, message="RouterNat",)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class RouterAdvertisedIpRange(proto.Message):
    r"""Description-tagged IP ranges for the router to advertise.
    Attributes:
        description (str):
            User-specified description for the IP range.
        range_ (str):
            The IP range to advertise. The value must be
            a CIDR-formatted string.
    """

    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    range_ = proto.Field(proto.STRING, number=108280125, optional=True,)


class RoutersScopedList(proto.Message):
    r"""
    Attributes:
        routers (Sequence[google.cloud.compute_v1.types.Router]):
            A list of routers contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of routers when the list is empty.
    """

    routers = proto.RepeatedField(proto.MESSAGE, number=311906890, message="Router",)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RouterAggregatedList(proto.Message):
    r"""Contains a list of routers.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.RouterAggregatedList.ItemsEntry]):
            A list of Router resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="RoutersScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RouterList(proto.Message):
    r"""Contains a list of Router resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Router]):
            A list of Router resources.
        kind (str):
            [Output Only] Type of resource. Always compute#router for
            routers.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Router",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class RouterNatLogConfig(proto.Message):
    r"""Configuration of logging on a NAT.
    Attributes:
        enable (bool):
            Indicates whether or not to export logs. This
            is false by default.
        filter (google.cloud.compute_v1.types.RouterNatLogConfig.Filter):
            Specify the desired filtering of logs on this NAT. If
            unspecified, logs are exported for all connections handled
            by this NAT. This option can take one of the following
            values:

            -  ERRORS_ONLY: Export logs only for connection failures.
            -  TRANSLATIONS_ONLY: Export logs only for successful
               connections.
            -  ALL: Export logs for all connections, successful and
               unsuccessful.
    """

    class Filter(proto.Enum):
        r"""Specify the desired filtering of logs on this NAT. If unspecified,
        logs are exported for all connections handled by this NAT. This
        option can take one of the following values:

        -  ERRORS_ONLY: Export logs only for connection failures.
        -  TRANSLATIONS_ONLY: Export logs only for successful connections.
        -  ALL: Export logs for all connections, successful and
           unsuccessful.
        """
        UNDEFINED_FILTER = 0
        ALL = 64897
        ERRORS_ONLY = 307484672
        TRANSLATIONS_ONLY = 357212649

    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    filter = proto.Field(proto.ENUM, number=336120696, optional=True, enum=Filter,)


class RouterNatSubnetworkToNat(proto.Message):
    r"""Defines the IP ranges that want to use NAT for a subnetwork.
    Attributes:
        name (str):
            URL for the subnetwork resource that will use
            NAT.
        secondary_ip_range_names (Sequence[str]):
            A list of the secondary ranges of the Subnetwork that are
            allowed to use NAT. This can be populated only if
            "LIST_OF_SECONDARY_IP_RANGES" is one of the values in
            source_ip_ranges_to_nat.
        source_ip_ranges_to_nat (Sequence[google.cloud.compute_v1.types.RouterNatSubnetworkToNat.SourceIpRangesToNat]):
            Specify the options for NAT ranges in the Subnetwork. All
            options of a single value are valid except
            NAT_IP_RANGE_OPTION_UNSPECIFIED. The only valid option with
            multiple values is: ["PRIMARY_IP_RANGE",
            "LIST_OF_SECONDARY_IP_RANGES"] Default: [ALL_IP_RANGES]
    """

    class SourceIpRangesToNat(proto.Enum):
        r""""""
        UNDEFINED_SOURCE_IP_RANGES_TO_NAT = 0
        ALL_IP_RANGES = 35608496
        LIST_OF_SECONDARY_IP_RANGES = 192289308
        PRIMARY_IP_RANGE = 297109954

    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    secondary_ip_range_names = proto.RepeatedField(proto.STRING, number=264315097,)
    source_ip_ranges_to_nat = proto.RepeatedField(
        proto.ENUM, number=388310386, enum=SourceIpRangesToNat,
    )


class RouterStatusBgpPeerStatus(proto.Message):
    r"""
    Attributes:
        advertised_routes (Sequence[google.cloud.compute_v1.types.Route]):
            Routes that were advertised to the remote BGP
            peer
        ip_address (str):
            IP address of the local BGP interface.
        linked_vpn_tunnel (str):
            URL of the VPN tunnel that this BGP peer
            controls.
        name (str):
            Name of this BGP peer. Unique within the
            Routers resource.
        num_learned_routes (int):
            Number of routes learned from the remote BGP
            Peer.
        peer_ip_address (str):
            IP address of the remote BGP interface.
        state (str):
            BGP state as specified in RFC1771.
        status (google.cloud.compute_v1.types.RouterStatusBgpPeerStatus.Status):
            Status of the BGP peer: {UP, DOWN}
        uptime (str):
            Time this session has been up. Format: 14
            years, 51 weeks, 6 days, 23 hours, 59 minutes,
            59 seconds
        uptime_seconds (str):
            Time this session has been up, in seconds.
            Format: 145
    """

    class Status(proto.Enum):
        r"""Status of the BGP peer: {UP, DOWN}"""
        UNDEFINED_STATUS = 0
        DOWN = 2104482
        UNKNOWN = 433141802
        UP = 2715

    advertised_routes = proto.RepeatedField(
        proto.MESSAGE, number=333393068, message="Route",
    )
    ip_address = proto.Field(proto.STRING, number=406272220, optional=True,)
    linked_vpn_tunnel = proto.Field(proto.STRING, number=352296953, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    num_learned_routes = proto.Field(proto.UINT32, number=135457535, optional=True,)
    peer_ip_address = proto.Field(proto.STRING, number=207735769, optional=True,)
    state = proto.Field(proto.STRING, number=109757585, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    uptime = proto.Field(proto.STRING, number=235379688, optional=True,)
    uptime_seconds = proto.Field(proto.STRING, number=104736040, optional=True,)


class RouterStatusNatStatus(proto.Message):
    r"""Status of a NAT contained in this router.
    Attributes:
        auto_allocated_nat_ips (Sequence[str]):
            A list of IPs auto-allocated for NAT. Example: ["1.1.1.1",
            "129.2.16.89"]
        drain_auto_allocated_nat_ips (Sequence[str]):
            A list of IPs auto-allocated for NAT that are in drain mode.
            Example: ["1.1.1.1", "179.12.26.133"].
        drain_user_allocated_nat_ips (Sequence[str]):
            A list of IPs user-allocated for NAT that are in drain mode.
            Example: ["1.1.1.1", "179.12.26.133"].
        min_extra_nat_ips_needed (int):
            The number of extra IPs to allocate. This will be greater
            than 0 only if user-specified IPs are NOT enough to allow
            all configured VMs to use NAT. This value is meaningful only
            when auto-allocation of NAT IPs is *not* used.
        name (str):
            Unique name of this NAT.
        num_vm_endpoints_with_nat_mappings (int):
            Number of VM endpoints (i.e., Nics) that can
            use NAT.
        user_allocated_nat_ip_resources (Sequence[str]):
            A list of fully qualified URLs of reserved IP
            address resources.
        user_allocated_nat_ips (Sequence[str]):
            A list of IPs user-allocated for NAT. They
            will be raw IP strings like "179.12.26.133".
    """

    auto_allocated_nat_ips = proto.RepeatedField(proto.STRING, number=510794246,)
    drain_auto_allocated_nat_ips = proto.RepeatedField(proto.STRING, number=309184557,)
    drain_user_allocated_nat_ips = proto.RepeatedField(proto.STRING, number=305268553,)
    min_extra_nat_ips_needed = proto.Field(
        proto.INT32, number=365786338, optional=True,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    num_vm_endpoints_with_nat_mappings = proto.Field(
        proto.INT32, number=512367468, optional=True,
    )
    user_allocated_nat_ip_resources = proto.RepeatedField(
        proto.STRING, number=212776151,
    )
    user_allocated_nat_ips = proto.RepeatedField(proto.STRING, number=506878242,)


class RouterStatus(proto.Message):
    r"""
    Attributes:
        best_routes (Sequence[google.cloud.compute_v1.types.Route]):
            Best routes for this router's network.
        best_routes_for_router (Sequence[google.cloud.compute_v1.types.Route]):
            Best routes learned by this router.
        bgp_peer_status (Sequence[google.cloud.compute_v1.types.RouterStatusBgpPeerStatus]):

        nat_status (Sequence[google.cloud.compute_v1.types.RouterStatusNatStatus]):

        network (str):
            URI of the network to which this router
            belongs.
    """

    best_routes = proto.RepeatedField(proto.MESSAGE, number=395826693, message="Route",)
    best_routes_for_router = proto.RepeatedField(
        proto.MESSAGE, number=119389689, message="Route",
    )
    bgp_peer_status = proto.RepeatedField(
        proto.MESSAGE, number=218459131, message="RouterStatusBgpPeerStatus",
    )
    nat_status = proto.RepeatedField(
        proto.MESSAGE, number=63098064, message="RouterStatusNatStatus",
    )
    network = proto.Field(proto.STRING, number=232872494, optional=True,)


class RouterStatusResponse(proto.Message):
    r"""
    Attributes:
        kind (str):
            Type of resource.
        result (google.cloud.compute_v1.types.RouterStatus):

    """

    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    result = proto.Field(
        proto.MESSAGE, number=139315229, optional=True, message="RouterStatus",
    )


class RoutersPreviewResponse(proto.Message):
    r"""
    Attributes:
        resource (google.cloud.compute_v1.types.Router):
            Preview of given router.
    """

    resource = proto.Field(
        proto.MESSAGE, number=195806222, optional=True, message="Router",
    )


class SchedulingNodeAffinity(proto.Message):
    r"""Node Affinity: the configuration of desired nodes onto which
    this Instance could be scheduled.

    Attributes:
        key (str):
            Corresponds to the label key of Node
            resource.
        operator (google.cloud.compute_v1.types.SchedulingNodeAffinity.Operator):
            Defines the operation of node selection. Valid operators are
            IN for affinity and NOT_IN for anti-affinity.
        values (Sequence[str]):
            Corresponds to the label values of Node
            resource.
    """

    class Operator(proto.Enum):
        r"""Defines the operation of node selection. Valid operators are IN for
        affinity and NOT_IN for anti-affinity.
        """
        UNDEFINED_OPERATOR = 0
        IN = 2341
        NOT_IN = 161144369
        OPERATOR_UNSPECIFIED = 128892924

    key = proto.Field(proto.STRING, number=106079, optional=True,)
    operator = proto.Field(proto.ENUM, number=36317348, optional=True, enum=Operator,)
    values = proto.RepeatedField(proto.STRING, number=249928994,)


class Screenshot(proto.Message):
    r"""An instance's screenshot.
    Attributes:
        contents (str):
            [Output Only] The Base64-encoded screenshot data.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#screenshot for the screenshots.
    """

    contents = proto.Field(proto.STRING, number=506419994, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)


class SecurityPoliciesWafConfig(proto.Message):
    r"""
    Attributes:
        waf_rules (google.cloud.compute_v1.types.PreconfiguredWafSet):

    """

    waf_rules = proto.Field(
        proto.MESSAGE, number=74899924, optional=True, message="PreconfiguredWafSet",
    )


class SecurityPoliciesListPreconfiguredExpressionSetsResponse(proto.Message):
    r"""
    Attributes:
        preconfigured_expression_sets (google.cloud.compute_v1.types.SecurityPoliciesWafConfig):

    """

    preconfigured_expression_sets = proto.Field(
        proto.MESSAGE,
        number=536200826,
        optional=True,
        message="SecurityPoliciesWafConfig",
    )


class SecurityPolicyRule(proto.Message):
    r"""Represents a rule that describes one or more match conditions
    along with the action to be taken when traffic matches this
    condition (allow or deny).

    Attributes:
        action (str):
            The Action to perform when the client
            connection triggers the rule. Can currently be
            either "allow" or "deny()" where valid values
            for status are 403, 404, and 502.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        kind (str):
            [Output only] Type of the resource. Always
            compute#securityPolicyRule for security policy rules
        match (google.cloud.compute_v1.types.SecurityPolicyRuleMatcher):
            A match condition that incoming traffic is
            evaluated against. If it evaluates to true, the
            corresponding 'action' is enforced.
        preview (bool):
            If set to true, the specified action is not
            enforced.
        priority (int):
            An integer indicating the priority of a rule
            in the list. The priority must be a positive
            value between 0 and 2147483647. Rules are
            evaluated from highest to lowest priority where
            0 is the highest priority and 2147483647 is the
            lowest priority.
    """

    action = proto.Field(proto.STRING, number=187661878, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    match = proto.Field(
        proto.MESSAGE,
        number=103668165,
        optional=True,
        message="SecurityPolicyRuleMatcher",
    )
    preview = proto.Field(proto.BOOL, number=218686408, optional=True,)
    priority = proto.Field(proto.INT32, number=445151652, optional=True,)


class SecurityPolicy(proto.Message):
    r"""Represents a Google Cloud Armor security policy resource.

    Only external backend services that use load balancers can reference
    a security policy. For more information, see Google Cloud Armor
    security policy overview. (== resource_for
    {$api_version}.securityPolicies ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Specifies a fingerprint for this resource,
            which is essentially a hash of the metadata's
            contents and used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update metadata. You must always provide an
            up-to-date fingerprint hash in order to update
            or change metadata, otherwise the request will
            fail with error 412 conditionNotMet.  To see the
            latest fingerprint, make get() request to the
            security policy.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output only] Type of the resource. Always
            compute#securityPolicyfor security policies
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        rules (Sequence[google.cloud.compute_v1.types.SecurityPolicyRule]):
            A list of rules that belong to this policy. There must
            always be a default rule (rule with priority 2147483647 and
            match "*"). If no rules are provided when creating a
            security policy, a default rule with action "allow" will be
            added.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
    """

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    rules = proto.RepeatedField(
        proto.MESSAGE, number=108873975, message="SecurityPolicyRule",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)


class SecurityPolicyList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.SecurityPolicy]):
            A list of SecurityPolicy resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#securityPolicyList for listsof securityPolicies
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="SecurityPolicy",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SecurityPolicyReference(proto.Message):
    r"""
    Attributes:
        security_policy (str):

    """

    security_policy = proto.Field(proto.STRING, number=171082513, optional=True,)


class SecurityPolicyRuleMatcher(proto.Message):
    r"""Represents a match condition that incoming traffic is
    evaluated against. Exactly one field must be specified.

    Attributes:
        config (google.cloud.compute_v1.types.SecurityPolicyRuleMatcherConfig):
            The configuration options available when specifying
            versioned_expr. This field must be specified if
            versioned_expr is specified and cannot be specified if
            versioned_expr is not specified.
        expr (google.cloud.compute_v1.types.Expr):
            User defined CEVAL expression. A CEVAL expression is used to
            specify match criteria such as origin.ip, source.region_code
            and contents in the request header.
        versioned_expr (google.cloud.compute_v1.types.SecurityPolicyRuleMatcher.VersionedExpr):
            Preconfigured versioned expression. If this field is
            specified, config must also be specified. Available
            preconfigured expressions along with their requirements are:
            SRC_IPS_V1 - must specify the corresponding src_ip_range
            field in config.
    """

    class VersionedExpr(proto.Enum):
        r"""Preconfigured versioned expression. If this field is specified,
        config must also be specified. Available preconfigured expressions
        along with their requirements are: SRC_IPS_V1 - must specify the
        corresponding src_ip_range field in config.
        """
        UNDEFINED_VERSIONED_EXPR = 0
        SRC_IPS_V1 = 70925961

    config = proto.Field(
        proto.MESSAGE,
        number=255820610,
        optional=True,
        message="SecurityPolicyRuleMatcherConfig",
    )
    expr = proto.Field(proto.MESSAGE, number=3127797, optional=True, message="Expr",)
    versioned_expr = proto.Field(
        proto.ENUM, number=322286013, optional=True, enum=VersionedExpr,
    )


class SecurityPolicyRuleMatcherConfig(proto.Message):
    r"""
    Attributes:
        src_ip_ranges (Sequence[str]):
            CIDR IP address range. Maximum number of src_ip_ranges
            allowed is 10.
    """

    src_ip_ranges = proto.RepeatedField(proto.STRING, number=432128083,)


class SerialPortOutput(proto.Message):
    r"""An instance's serial console output.
    Attributes:
        contents (str):
            [Output Only] The contents of the console output.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#serialPortOutput for serial port output.
        next_ (int):
            [Output Only] The position of the next byte of content,
            regardless of whether the content exists, following the
            output returned in the ``contents`` property. Use this value
            in the next request as the start parameter.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        start (int):
            The starting byte position of the output that was returned.
            This should match the start parameter sent with the request.
            If the serial console output exceeds the size of the buffer
            (1 MB), older output is overwritten by newer content. The
            output start value will indicate the byte position of the
            output that was returned, which might be different than the
            ``start`` value that was specified in the request.
    """

    contents = proto.Field(proto.STRING, number=506419994, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_ = proto.Field(proto.INT64, number=3377907, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    start = proto.Field(proto.INT64, number=109757538, optional=True,)


class ShieldedInstanceIdentityEntry(proto.Message):
    r"""A Shielded Instance Identity Entry.
    Attributes:
        ek_cert (str):
            A PEM-encoded X.509 certificate. This field
            can be empty.
        ek_pub (str):
            A PEM-encoded public key.
    """

    ek_cert = proto.Field(proto.STRING, number=450178589, optional=True,)
    ek_pub = proto.Field(proto.STRING, number=308947940, optional=True,)


class ShieldedInstanceIdentity(proto.Message):
    r"""A shielded Instance identity entry.
    Attributes:
        encryption_key (google.cloud.compute_v1.types.ShieldedInstanceIdentityEntry):
            An Endorsement Key (EK) made by the RSA 2048
            algorithm issued to the Shielded Instance's
            vTPM.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#shieldedInstanceIdentity for shielded Instance
            identity entry.
        signing_key (google.cloud.compute_v1.types.ShieldedInstanceIdentityEntry):
            An Attestation Key (AK) made by the RSA 2048
            algorithm issued to the Shielded Instance's
            vTPM.
    """

    encryption_key = proto.Field(
        proto.MESSAGE,
        number=488268707,
        optional=True,
        message="ShieldedInstanceIdentityEntry",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    signing_key = proto.Field(
        proto.MESSAGE,
        number=320948261,
        optional=True,
        message="ShieldedInstanceIdentityEntry",
    )


class SignedUrlKey(proto.Message):
    r"""Represents a customer-supplied Signing Key used by Cloud CDN
    Signed URLs

    Attributes:
        key_name (str):
            Name of the key. The name must be 1-63 characters long, and
            comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        key_value (str):
            128-bit key value used for signing the URL.
            The key value must be a valid RFC 4648 Section 5
            base64url encoded string.
    """

    key_name = proto.Field(proto.STRING, number=500938859, optional=True,)
    key_value = proto.Field(proto.STRING, number=504106897, optional=True,)


class Snapshot(proto.Message):
    r"""Represents a Persistent Disk Snapshot resource.

    You can use snapshots to back up data on a regular interval. For
    more information, read Creating persistent disk snapshots. (==
    resource_for {$api_version}.snapshots ==)

    Attributes:
        auto_created (bool):
            [Output Only] Set to true if snapshots are automatically
            created by applying resource policy on the target disk.
        chain_name (str):
            Creates the new snapshot in the snapshot
            chain labeled with the specified name. The chain
            name must be 1-63 characters long and comply
            with RFC1035. This is an uncommon option only
            for advanced service owners who needs to create
            separate snapshot chains, for example, for
            chargeback tracking. When you describe your
            snapshot resource, this field is visible only if
            it has a non-empty value.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        disk_size_gb (int):
            [Output Only] Size of the source disk, specified in GB.
        download_bytes (int):
            [Output Only] Number of bytes downloaded to restore a
            snapshot to a disk.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always compute#snapshot
            for Snapshot resources.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this snapshot, which is essentially a hash of
            the labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an up-
            to-date fingerprint hash in order to update or
            change labels, otherwise the request will fail
            with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve a snapshot.
        labels (Sequence[google.cloud.compute_v1.types.Snapshot.LabelsEntry]):
            Labels to apply to this snapshot. These can
            be later modified by the setLabels method. Label
            values may be empty.
        license_codes (Sequence[int]):
            [Output Only] Integer license codes indicating which
            licenses are attached to this snapshot.
        licenses (Sequence[str]):
            [Output Only] A list of public visible licenses that apply
            to this snapshot. This can be because the original image had
            licenses attached (such as a Windows image).
        location_hint (str):
            An opaque location hint used to place the
            snapshot close to other resources. This field is
            for use by internal tools that use the public
            API.
        name (str):
            Name of the resource; provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        satisfies_pzs (bool):
            [Output Only] Reserved for future use.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts the snapshot using a customer-
            upplied encryption key.
            After you encrypt a snapshot using a customer-
            supplied key, you must provide the same key if
            you use the snapshot later. For example, you
            must provide the encryption key when you create
            a disk from the encrypted snapshot in a future
            request.
            Customer-supplied encryption keys do not protect
            access to metadata of the snapshot.
            If you do not provide an encryption key when
            creating the snapshot, then the snapshot will be
            encrypted using an automatically generated key
            and you do not need to provide a key to use the
            snapshot later.
        source_disk (str):
            The source disk used to create this snapshot.
        source_disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source disk. Required if the source disk is
            protected by a customer-supplied encryption key.
        source_disk_id (str):
            [Output Only] The ID value of the disk used to create this
            snapshot. This value may be used to determine whether the
            snapshot was taken from the current or a previous instance
            of a given disk name.
        status (google.cloud.compute_v1.types.Snapshot.Status):
            [Output Only] The status of the snapshot. This can be
            CREATING, DELETING, FAILED, READY, or UPLOADING.
        storage_bytes (int):
            [Output Only] A size of the storage used by the snapshot. As
            snapshots share storage, this number is expected to change
            with snapshot creation/deletion.
        storage_bytes_status (google.cloud.compute_v1.types.Snapshot.StorageBytesStatus):
            [Output Only] An indicator whether storageBytes is in a
            stable state or it is being adjusted as a result of shared
            storage reallocation. This status can either be UPDATING,
            meaning the size of the snapshot is being updated, or
            UP_TO_DATE, meaning the size of the snapshot is up-to-date.
        storage_locations (Sequence[str]):
            Cloud Storage bucket storage location of the
            snapshot (regional or multi-regional).
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the snapshot. This can be CREATING,
        DELETING, FAILED, READY, or UPLOADING.
        """
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DELETING = 528602024
        FAILED = 455706685
        READY = 77848963
        UPLOADING = 267603489

    class StorageBytesStatus(proto.Enum):
        r"""[Output Only] An indicator whether storageBytes is in a stable state
        or it is being adjusted as a result of shared storage reallocation.
        This status can either be UPDATING, meaning the size of the snapshot
        is being updated, or UP_TO_DATE, meaning the size of the snapshot is
        up-to-date.
        """
        UNDEFINED_STORAGE_BYTES_STATUS = 0
        UPDATING = 494614342
        UP_TO_DATE = 101306702

    auto_created = proto.Field(proto.BOOL, number=463922264, optional=True,)
    chain_name = proto.Field(proto.STRING, number=68644169, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    disk_size_gb = proto.Field(proto.INT64, number=316263735, optional=True,)
    download_bytes = proto.Field(proto.INT64, number=435054068, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    label_fingerprint = proto.Field(proto.STRING, number=178124825, optional=True,)
    labels = proto.MapField(proto.STRING, proto.STRING, number=500195327,)
    license_codes = proto.RepeatedField(proto.INT64, number=45482664,)
    licenses = proto.RepeatedField(proto.STRING, number=337642578,)
    location_hint = proto.Field(proto.STRING, number=350519505, optional=True,)
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    satisfies_pzs = proto.Field(proto.BOOL, number=480964267, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    snapshot_encryption_key = proto.Field(
        proto.MESSAGE, number=43334526, optional=True, message="CustomerEncryptionKey",
    )
    source_disk = proto.Field(proto.STRING, number=451753793, optional=True,)
    source_disk_encryption_key = proto.Field(
        proto.MESSAGE, number=531501153, optional=True, message="CustomerEncryptionKey",
    )
    source_disk_id = proto.Field(proto.STRING, number=454190809, optional=True,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)
    storage_bytes = proto.Field(proto.INT64, number=424631719, optional=True,)
    storage_bytes_status = proto.Field(
        proto.ENUM, number=490739082, optional=True, enum=StorageBytesStatus,
    )
    storage_locations = proto.RepeatedField(proto.STRING, number=328005274,)


class SnapshotList(proto.Message):
    r"""Contains a list of Snapshot resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Snapshot]):
            A list of Snapshot resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Snapshot",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SslCertificateManagedSslCertificate(proto.Message):
    r"""Configuration and status of a managed SSL certificate.
    Attributes:
        domain_status (Sequence[google.cloud.compute_v1.types.SslCertificateManagedSslCertificate.DomainStatusEntry]):
            [Output only] Detailed statuses of the domains specified for
            managed certificate resource.
        domains (Sequence[str]):
            The domains for which a managed SSL certificate will be
            generated. Each Google-managed SSL certificate supports up
            to the `maximum number of domains per Google-managed SSL
            certificate </load-balancing/docs/quotas#ssl_certificates>`__.
        status (google.cloud.compute_v1.types.SslCertificateManagedSslCertificate.Status):
            [Output only] Status of the managed certificate resource.
    """

    class Status(proto.Enum):
        r"""[Output only] Status of the managed certificate resource."""
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        MANAGED_CERTIFICATE_STATUS_UNSPECIFIED = 474800850
        PROVISIONING = 290896621
        PROVISIONING_FAILED = 76813775
        PROVISIONING_FAILED_PERMANENTLY = 275036203
        RENEWAL_FAILED = 434659076

    domain_status = proto.MapField(proto.STRING, proto.STRING, number=360305613,)
    domains = proto.RepeatedField(proto.STRING, number=226935855,)
    status = proto.Field(proto.ENUM, number=181260274, optional=True, enum=Status,)


class SslCertificateSelfManagedSslCertificate(proto.Message):
    r"""Configuration and status of a self-managed SSL certificate.
    Attributes:
        certificate (str):
            A local certificate file. The certificate
            must be in PEM format. The certificate chain
            must be no greater than 5 certs long. The chain
            must include at least one intermediate cert.
        private_key (str):
            A write-only private key in PEM format. Only
            insert requests will include this field.
    """

    certificate = proto.Field(proto.STRING, number=341787031, optional=True,)
    private_key = proto.Field(proto.STRING, number=361331107, optional=True,)


class SslCertificate(proto.Message):
    r"""Represents an SSL Certificate resource.

    Google Compute Engine has two SSL Certificate resources:

    -  `Global </compute/docs/reference/rest/{$api_version}/sslCertificates>`__
       \*
       `Regional </compute/docs/reference/rest/{$api_version}/regionSslCertificates>`__

    The sslCertificates are used by:

    -  external HTTPS load balancers
    -  SSL proxy load balancers

    The regionSslCertificates are used by internal HTTPS load balancers.

    Optionally, certificate file contents that you upload can contain a
    set of up to five PEM-encoded certificates. The API call creates an
    object (sslCertificate) that holds this data. You can use SSL keys
    and certificates to secure connections to a load balancer. For more
    information, read Creating and using SSL certificates, SSL
    certificates quotas and limits, and Troubleshooting SSL
    certificates. (== resource_for {$api_version}.sslCertificates ==)
    (== resource_for {$api_version}.regionSslCertificates ==)

    Attributes:
        certificate (str):
            A value read into memory from a certificate
            file. The certificate file must be in PEM
            format. The certificate chain must be no greater
            than 5 certs long. The chain must include at
            least one intermediate cert.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        expire_time (str):
            [Output Only] Expire time of the certificate. RFC3339
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#sslCertificate for SSL certificates.
        managed (google.cloud.compute_v1.types.SslCertificateManagedSslCertificate):
            Configuration and status of a managed SSL
            certificate.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        private_key (str):
            A value read into memory from a write-only
            private key file. The private key file must be
            in PEM format. For security, only insert
            requests include this field.
        region (str):
            [Output Only] URL of the region where the regional SSL
            Certificate resides. This field is not applicable to global
            SSL Certificate.
        self_link (str):
            [Output only] Server-defined URL for the resource.
        self_managed (google.cloud.compute_v1.types.SslCertificateSelfManagedSslCertificate):
            Configuration and status of a self-managed
            SSL certificate.
        subject_alternative_names (Sequence[str]):
            [Output Only] Domains associated with the certificate via
            Subject Alternative Name.
        type_ (google.cloud.compute_v1.types.SslCertificate.Type):
            (Optional) Specifies the type of SSL certificate, either
            "SELF_MANAGED" or "MANAGED". If not specified, the
            certificate is self-managed and the fields certificate and
            private_key are used.
    """

    class Type(proto.Enum):
        r"""(Optional) Specifies the type of SSL certificate, either
        "SELF_MANAGED" or "MANAGED". If not specified, the certificate is
        self-managed and the fields certificate and private_key are used.
        """
        UNDEFINED_TYPE = 0
        MANAGED = 479501183
        SELF_MANAGED = 434437516
        TYPE_UNSPECIFIED = 437714322

    certificate = proto.Field(proto.STRING, number=341787031, optional=True,)
    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    expire_time = proto.Field(proto.STRING, number=440691181, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    managed = proto.Field(
        proto.MESSAGE,
        number=298389407,
        optional=True,
        message="SslCertificateManagedSslCertificate",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    private_key = proto.Field(proto.STRING, number=361331107, optional=True,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    self_managed = proto.Field(
        proto.MESSAGE,
        number=329284012,
        optional=True,
        message="SslCertificateSelfManagedSslCertificate",
    )
    subject_alternative_names = proto.RepeatedField(proto.STRING, number=528807907,)
    type_ = proto.Field(proto.ENUM, number=3575610, optional=True, enum=Type,)


class SslCertificatesScopedList(proto.Message):
    r"""
    Attributes:
        ssl_certificates (Sequence[google.cloud.compute_v1.types.SslCertificate]):
            List of SslCertificates contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.
    """

    ssl_certificates = proto.RepeatedField(
        proto.MESSAGE, number=366006543, message="SslCertificate",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SslCertificateAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.SslCertificateAggregatedList.ItemsEntry]):
            A list of SslCertificatesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#sslCertificateAggregatedList for lists of SSL
            Certificates.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="SslCertificatesScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SslCertificateList(proto.Message):
    r"""Contains a list of SslCertificate resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.SslCertificate]):
            A list of SslCertificate resources.
        kind (str):
            Type of resource.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(
        proto.MESSAGE, number=100526016, message="SslCertificate",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SslPolicy(proto.Message):
    r"""Represents an SSL Policy resource.

    Use SSL policies to control the SSL features, such as versions and
    cipher suites, offered by an HTTPS or SSL Proxy load balancer. For
    more information, read SSL Policy Concepts. (== resource_for
    {$api_version}.sslPolicies ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        custom_features (Sequence[str]):
            A list of features enabled when the selected
            profile is CUSTOM. The - method returns the set
            of features that can be specified in this list.
            This field must be empty if the profile is not
            CUSTOM.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        enabled_features (Sequence[str]):
            [Output Only] The list of features enabled in the SSL
            policy.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a SslPolicy. An up-to-
            date fingerprint must be provided in order to
            update the SslPolicy, otherwise the request will
            fail with error 412 conditionNotMet.  To see the
            latest fingerprint, make a get() request to
            retrieve an SslPolicy.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        kind (str):
            [Output only] Type of the resource. Always
            compute#sslPolicyfor SSL policies.
        min_tls_version (google.cloud.compute_v1.types.SslPolicy.MinTlsVersion):
            The minimum version of SSL protocol that can be used by the
            clients to establish a connection with the load balancer.
            This can be one of TLS_1_0, TLS_1_1, TLS_1_2.
        name (str):
            Name of the resource. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        profile (google.cloud.compute_v1.types.SslPolicy.Profile):
            Profile specifies the set of SSL features
            that can be used by the load balancer when
            negotiating SSL with clients. This can be one of
            COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If
            using CUSTOM, the set of SSL features to enable
            must be specified in the customFeatures field.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        warnings (Sequence[google.cloud.compute_v1.types.Warnings]):
            [Output Only] If potential misconfigurations are detected
            for this SSL policy, this field will be populated with
            warning messages.
    """

    class MinTlsVersion(proto.Enum):
        r"""The minimum version of SSL protocol that can be used by the clients
        to establish a connection with the load balancer. This can be one of
        TLS_1_0, TLS_1_1, TLS_1_2.
        """
        UNDEFINED_MIN_TLS_VERSION = 0
        TLS_1_0 = 33116734
        TLS_1_1 = 33116735
        TLS_1_2 = 33116736

    class Profile(proto.Enum):
        r"""Profile specifies the set of SSL features that can be used by
        the load balancer when negotiating SSL with clients. This can be
        one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using
        CUSTOM, the set of SSL features to enable must be specified in
        the customFeatures field.
        """
        UNDEFINED_PROFILE = 0
        COMPATIBLE = 179357396
        CUSTOM = 388595569
        MODERN = 132013855
        RESTRICTED = 261551195

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    custom_features = proto.RepeatedField(proto.STRING, number=34789707,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enabled_features = proto.RepeatedField(proto.STRING, number=469017467,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    min_tls_version = proto.Field(
        proto.ENUM, number=8155943, optional=True, enum=MinTlsVersion,
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    profile = proto.Field(proto.ENUM, number=227445161, optional=True, enum=Profile,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warnings = proto.RepeatedField(proto.MESSAGE, number=498091095, message="Warnings",)


class SslPoliciesList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.SslPolicy]):
            A list of SslPolicy resources.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#sslPoliciesList for lists of sslPolicies.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="SslPolicy",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SslPoliciesListAvailableFeaturesResponse(proto.Message):
    r"""
    Attributes:
        features (Sequence[str]):

    """

    features = proto.RepeatedField(proto.STRING, number=246211645,)


class SslPolicyReference(proto.Message):
    r"""
    Attributes:
        ssl_policy (str):
            URL of the SSL policy resource. Set this to
            empty string to clear any existing SSL policy
            associated with the target proxy resource.
    """

    ssl_policy = proto.Field(proto.STRING, number=295190213, optional=True,)


class StatefulPolicyPreservedState(proto.Message):
    r"""Configuration of preserved resources.
    Attributes:
        disks (Sequence[google.cloud.compute_v1.types.StatefulPolicyPreservedState.DisksEntry]):
            Disks created on the instances that will be
            preserved on instance delete, update, etc. This
            map is keyed with the device names of the disks.
    """

    disks = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=95594102,
        message="StatefulPolicyPreservedStateDiskDevice",
    )


class StatefulPolicyPreservedStateDiskDevice(proto.Message):
    r"""
    Attributes:
        auto_delete (google.cloud.compute_v1.types.StatefulPolicyPreservedStateDiskDevice.AutoDelete):
            These stateful disks will never be deleted during
            autohealing, update or VM instance recreate operations. This
            flag is used to configure if the disk should be deleted
            after it is no longer used by the group, e.g. when the given
            instance or the whole group is deleted. Note: disks attached
            in READ_ONLY mode cannot be auto-deleted.
    """

    class AutoDelete(proto.Enum):
        r"""These stateful disks will never be deleted during autohealing,
        update or VM instance recreate operations. This flag is used to
        configure if the disk should be deleted after it is no longer used
        by the group, e.g. when the given instance or the whole group is
        deleted. Note: disks attached in READ_ONLY mode cannot be
        auto-deleted.
        """
        UNDEFINED_AUTO_DELETE = 0
        NEVER = 74175084
        ON_PERMANENT_INSTANCE_DELETION = 95727719

    auto_delete = proto.Field(
        proto.ENUM, number=464761403, optional=True, enum=AutoDelete,
    )


class SubnetworkLogConfig(proto.Message):
    r"""The available logging options for this subnetwork.
    Attributes:
        aggregation_interval (google.cloud.compute_v1.types.SubnetworkLogConfig.AggregationInterval):
            Can only be specified if VPC flow logging for
            this subnetwork is enabled. Toggles the
            aggregation interval for collecting flow logs.
            Increasing the interval time will reduce the
            amount of generated flow logs for long lasting
            connections. Default is an interval of 5 seconds
            per connection.
        enable (bool):
            Whether to enable flow logging for this
            subnetwork. If this field is not explicitly set,
            it will not appear in get listings. If not set
            the default behavior is to disable flow logging.
        filter_expr (str):
            Can only be specified if VPC flow logs for
            this subnetwork is enabled. Export filter used
            to define which VPC flow logs should be logged.
        flow_sampling (float):
            Can only be specified if VPC flow logging for this
            subnetwork is enabled. The value of the field must be in [0,
            1]. Set the sampling rate of VPC flow logs within the
            subnetwork where 1.0 means all collected logs are reported
            and 0.0 means no logs are reported. Default is 0.5, which
            means half of all collected logs are reported.
        metadata (google.cloud.compute_v1.types.SubnetworkLogConfig.Metadata):
            Can only be specified if VPC flow logs for this subnetwork
            is enabled. Configures whether all, none or a subset of
            metadata fields should be added to the reported VPC flow
            logs. Default is EXCLUDE_ALL_METADATA.
        metadata_fields (Sequence[str]):
            Can only be specified if VPC flow logs for this subnetwork
            is enabled and "metadata" was set to CUSTOM_METADATA.
    """

    class AggregationInterval(proto.Enum):
        r"""Can only be specified if VPC flow logging for this subnetwork
        is enabled. Toggles the aggregation interval for collecting flow
        logs. Increasing the interval time will reduce the amount of
        generated flow logs for long lasting connections. Default is an
        interval of 5 seconds per connection.
        """
        UNDEFINED_AGGREGATION_INTERVAL = 0
        INTERVAL_10_MIN = 487155916
        INTERVAL_15_MIN = 491773521
        INTERVAL_1_MIN = 69052714
        INTERVAL_30_SEC = 7548937
        INTERVAL_5_MIN = 72746798
        INTERVAL_5_SEC = 72752429

    class Metadata(proto.Enum):
        r"""Can only be specified if VPC flow logs for this subnetwork is
        enabled. Configures whether all, none or a subset of metadata fields
        should be added to the reported VPC flow logs. Default is
        EXCLUDE_ALL_METADATA.
        """
        UNDEFINED_METADATA = 0
        CUSTOM_METADATA = 62450749
        EXCLUDE_ALL_METADATA = 334519954
        INCLUDE_ALL_METADATA = 164619908

    aggregation_interval = proto.Field(
        proto.ENUM, number=174919042, optional=True, enum=AggregationInterval,
    )
    enable = proto.Field(proto.BOOL, number=311764355, optional=True,)
    filter_expr = proto.Field(proto.STRING, number=183374428, optional=True,)
    flow_sampling = proto.Field(proto.FLOAT, number=530150360, optional=True,)
    metadata = proto.Field(proto.ENUM, number=86866735, optional=True, enum=Metadata,)
    metadata_fields = proto.RepeatedField(proto.STRING, number=378461641,)


class SubnetworkSecondaryRange(proto.Message):
    r"""Represents a secondary IP range of a subnetwork.
    Attributes:
        ip_cidr_range (str):
            The range of IP addresses belonging to this
            subnetwork secondary range. Provide this
            property when you create the subnetwork. Ranges
            must be unique and non-overlapping with all
            primary and secondary IP ranges within a
            network. Only IPv4 is supported. The range can
            be any range listed in the Valid ranges list.
        range_name (str):
            The name associated with this subnetwork
            secondary range, used when adding an alias IP
            range to a VM instance. The name must be 1-63
            characters long, and comply with RFC1035. The
            name must be unique within the subnetwork.
    """

    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    range_name = proto.Field(proto.STRING, number=332216397, optional=True,)


class Subnetwork(proto.Message):
    r"""Represents a Subnetwork resource.

    A subnetwork (also known as a subnet) is a logical partition of a
    Virtual Private Cloud network with one primary IP range and zero or
    more secondary IP ranges. For more information, read Virtual Private
    Cloud (VPC) Network. (== resource_for {$api_version}.subnetworks ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource. This field can be set only at resource
            creation time.
        enable_flow_logs (bool):
            Whether to enable flow logging for this subnetwork. If this
            field is not explicitly set, it will not appear in get
            listings. If not set the default behavior is to disable flow
            logging. This field isn't supported with the purpose field
            set to INTERNAL_HTTPS_LOAD_BALANCER.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a Subnetwork. An up-to-
            date fingerprint must be provided in order to
            update the Subnetwork, otherwise the request
            will fail with error 412 conditionNotMet.  To
            see the latest fingerprint, make a get() request
            to retrieve a Subnetwork.
        gateway_address (str):
            [Output Only] The gateway address for default routes to
            reach destination addresses outside this subnetwork.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.
        ip_cidr_range (str):
            The range of internal addresses that are
            owned by this subnetwork. Provide this property
            when you create the subnetwork. For example,
            10.0.0.0/8 or 100.64.0.0/10. Ranges must be
            unique and non-overlapping within a network.
            Only IPv4 is supported. This field is set at
            resource creation time. The range can be any
            range listed in the Valid ranges list. The range
            can be expanded after creation using
            expandIpCidrRange.
        ipv6_cidr_range (str):
            [Output Only] The range of internal IPv6 addresses that are
            owned by this subnetwork.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#subnetwork for Subnetwork resources.
        log_config (google.cloud.compute_v1.types.SubnetworkLogConfig):
            This field denotes the VPC flow logging
            options for this subnetwork. If logging is
            enabled, logs are exported to Cloud Logging.
        name (str):
            The name of the resource, provided by the client when
            initially creating the resource. The name must be 1-63
            characters long, and comply with RFC1035. Specifically, the
            name must be 1-63 characters long and match the regular
            expression ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the
            first character must be a lowercase letter, and all
            following characters must be a dash, lowercase letter, or
            digit, except the last character, which cannot be a dash.
        network (str):
            The URL of the network to which this
            subnetwork belongs, provided by the client when
            initially creating the subnetwork. Only networks
            that are in the distributed mode can have
            subnetworks. This field can be set only at
            resource creation time.
        private_ip_google_access (bool):
            Whether the VMs in this subnet can access
            Google services without assigned external IP
            addresses. This field can be both set at
            resource creation time and updated using
            setPrivateIpGoogleAccess.
        private_ipv6_google_access (google.cloud.compute_v1.types.Subnetwork.PrivateIpv6GoogleAccess):
            The private IPv6 google access type for the
            VMs in this subnet. This is an expanded field of
            enablePrivateV6Access. If both fields are set,
            privateIpv6GoogleAccess will take priority.
            This field can be both set at resource creation
            time and updated using patch.
        purpose (google.cloud.compute_v1.types.Subnetwork.Purpose):
            The purpose of the resource. This field can be either
            PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A
            subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER
            is a user-created subnetwork that is reserved for Internal
            HTTP(S) Load Balancing. If unspecified, the purpose defaults
            to PRIVATE_RFC_1918. The enableFlowLogs field isn't
            supported with the purpose field set to
            INTERNAL_HTTPS_LOAD_BALANCER.
        region (str):
            URL of the region where the Subnetwork
            resides. This field can be set only at resource
            creation time.
        role (google.cloud.compute_v1.types.Subnetwork.Role):
            The role of subnetwork. Currently, this field is only used
            when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can
            be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that
            is currently being used for Internal HTTP(S) Load Balancing.
            A BACKUP subnetwork is one that is ready to be promoted to
            ACTIVE or is currently draining. This field can be updated
            with a patch request.
        secondary_ip_ranges (Sequence[google.cloud.compute_v1.types.SubnetworkSecondaryRange]):
            An array of configurations for secondary IP
            ranges for VM instances contained in this
            subnetwork. The primary IP of such VM must
            belong to the primary ipCidrRange of the
            subnetwork. The alias IPs may belong to either
            primary or secondary ranges. This field can be
            updated with a patch request.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        state (google.cloud.compute_v1.types.Subnetwork.State):
            [Output Only] The state of the subnetwork, which can be one
            of the following values: READY: Subnetwork is created and
            ready to use DRAINING: only applicable to subnetworks that
            have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and
            indicates that connections to the load balancer are being
            drained. A subnetwork that is draining cannot be used or
            modified until it reaches a status of READY
    """

    class PrivateIpv6GoogleAccess(proto.Enum):
        r"""The private IPv6 google access type for the VMs in this
        subnet. This is an expanded field of enablePrivateV6Access. If
        both fields are set, privateIpv6GoogleAccess will take priority.
        This field can be both set at resource creation time and updated
        using patch.
        """
        UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0
        DISABLE_GOOGLE_ACCESS = 450958579
        ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994
        ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263

    class Purpose(proto.Enum):
        r"""The purpose of the resource. This field can be either
        PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with
        purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created
        subnetwork that is reserved for Internal HTTP(S) Load Balancing. If
        unspecified, the purpose defaults to PRIVATE_RFC_1918. The
        enableFlowLogs field isn't supported with the purpose field set to
        INTERNAL_HTTPS_LOAD_BALANCER.
        """
        UNDEFINED_PURPOSE = 0
        INTERNAL_HTTPS_LOAD_BALANCER = 248748889
        PRIVATE = 403485027
        PRIVATE_RFC_1918 = 254902107

    class Role(proto.Enum):
        r"""The role of subnetwork. Currently, this field is only used when
        purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to
        ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently
        being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork
        is one that is ready to be promoted to ACTIVE or is currently
        draining. This field can be updated with a patch request.
        """
        UNDEFINED_ROLE = 0
        ACTIVE = 314733318
        BACKUP = 341010882

    class State(proto.Enum):
        r"""[Output Only] The state of the subnetwork, which can be one of the
        following values: READY: Subnetwork is created and ready to use
        DRAINING: only applicable to subnetworks that have the purpose set
        to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to
        the load balancer are being drained. A subnetwork that is draining
        cannot be used or modified until it reaches a status of READY
        """
        UNDEFINED_STATE = 0
        DRAINING = 480455402
        READY = 77848963

    creation_timestamp = proto.Field(proto.STRING, number=30525366, optional=True,)
    description = proto.Field(proto.STRING, number=422937596, optional=True,)
    enable_flow_logs = proto.Field(proto.BOOL, number=151544420, optional=True,)
    fingerprint = proto.Field(proto.STRING, number=234678500, optional=True,)
    gateway_address = proto.Field(proto.STRING, number=459867385, optional=True,)
    id = proto.Field(proto.UINT64, number=3355, optional=True,)
    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)
    ipv6_cidr_range = proto.Field(proto.STRING, number=273141258, optional=True,)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    log_config = proto.Field(
        proto.MESSAGE, number=351299741, optional=True, message="SubnetworkLogConfig",
    )
    name = proto.Field(proto.STRING, number=3373707, optional=True,)
    network = proto.Field(proto.STRING, number=232872494, optional=True,)
    private_ip_google_access = proto.Field(proto.BOOL, number=421491790, optional=True,)
    private_ipv6_google_access = proto.Field(
        proto.ENUM, number=48277006, optional=True, enum=PrivateIpv6GoogleAccess,
    )
    purpose = proto.Field(proto.ENUM, number=316407070, optional=True, enum=Purpose,)
    region = proto.Field(proto.STRING, number=138946292, optional=True,)
    role = proto.Field(proto.ENUM, number=3506294, optional=True, enum=Role,)
    secondary_ip_ranges = proto.RepeatedField(
        proto.MESSAGE, number=136658915, message="SubnetworkSecondaryRange",
    )
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    state = proto.Field(proto.ENUM, number=109757585, optional=True, enum=State,)


class SubnetworksScopedList(proto.Message):
    r"""
    Attributes:
        subnetworks (Sequence[google.cloud.compute_v1.types.Subnetwork]):
            A list of subnetworks contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            An informational warning that appears when
            the list of addresses is empty.
    """

    subnetworks = proto.RepeatedField(
        proto.MESSAGE, number=415853125, message="Subnetwork",
    )
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SubnetworkAggregatedList(proto.Message):
    r"""
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.SubnetworkAggregatedList.ItemsEntry]):
            A list of SubnetworksScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#subnetworkAggregatedList for aggregated lists of
            subnetworks.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        unreachables (Sequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.MapField(
        proto.STRING, proto.MESSAGE, number=100526016, message="SubnetworksScopedList",
    )
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    unreachables = proto.RepeatedField(proto.STRING, number=243372063,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SubnetworkList(proto.Message):
    r"""Contains a list of Subnetwork resources.
    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.
        items (Sequence[google.cloud.compute_v1.types.Subnetwork]):
            A list of Subnetwork resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#subnetworkList for lists of subnetworks.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.
        self_link (str):
            [Output Only] Server-defined URL for this resource.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.
    """

    @property
    def raw_page(self):
        return self

    id = proto.Field(proto.STRING, number=3355, optional=True,)
    items = proto.RepeatedField(proto.MESSAGE, number=100526016, message="Subnetwork",)
    kind = proto.Field(proto.STRING, number=3292052, optional=True,)
    next_page_token = proto.Field(proto.STRING, number=79797525, optional=True,)
    self_link = proto.Field(proto.STRING, number=456214797, optional=True,)
    warning = proto.Field(
        proto.MESSAGE, number=50704284, optional=True, message="Warning",
    )


class SubnetworksExpandIpCidrRangeRequest(proto.Message):
    r"""
    Attributes:
        ip_cidr_range (str):
            The IP (in CIDR format or netmask) of
            internal addresses that are legal on this
            Subnetwork. This range should be disjoint from
            other subnetworks within this network. This
            range can only be larger than (i.e. a superset
            of) the range previously defined before the
            update.
    """

    ip_cidr_range = proto.Field(proto.STRING, number=98117322, optional=True,)


class SubnetworksSetPrivateIpGoogleAccessRequest(proto.Message):
    r"""
    Attributes:
        private_ip_google_access (bool):

    """

    private_ip_google_access = proto.Field(proto.BOOL, number=421491790, optional=True,)


class TargetGrpcProxy(proto.Message):
    r"""Represents a Target gRPC Proxy resource.

    A target gRPC proxy is a component of load balancers intended for
    load balancing gRPC traffic. Only global forwarding rules with load
    balancing scheme INTERNAL_SELF_MANAGED can reference a target gRPC
    proxy. The target gRPC Proxy references a URL map that specifies how
    traffic is routed to gRPC backend services. (== resource_for
    {$api_version}.targetGrpcProxies ==)

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a TargetGrpcProxy. An up-
            to-date fingerprint must be provided in order to
            patch/update the TargetGrpcProxy; otherwise, the
            request will fail with error 412
            conditionNotMet. To see the latest fingerprint,
            make a get() request to retrieve the
            TargetGrpcProxy.
        id (int):
            [Output Only] The unique identifier for the resource type.
            The server generates this identifier.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#targetGrpcProxy for target grpc proxies.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.
        self_link (str):
            [Output Only] Server-defined URL for the resource.
        self_link_with_id (str):
            [Output Only] Server-define