<h1 align="center">Lemon-CLI</h1>

<div align="center">

[![Status](https://img.shields.io/badge/status-active-success.svg)]()
[![GitHub Issues](https://img.shields.io/github/issues/Sas2k/Lemon-CLI.svg)](https://github.com/Sas2k/Lemon-CLI/issues)
[![GitHub Pull Requests](https://img.shields.io/github/issues-pr/Sas2k/Lemon.svg)](https://github.com/Sas2k/Lemon-CLI/pulls)
[![License](https://img.shields.io/badge/license-MIT-blue.svg)](/LICENSE)

</div>

---

<p align="center"> Component Generator for <a href="https://github.com/Sas2k/Lemon">Lemon 🍋</a>
    <br> 
</p>

## 📝 Table of Contents

- [📝 Table of Contents](#-table-of-contents)
- [🧐 About <a name = "about"></a>](#-about-)
- [🏁 Getting Started <a name = "getting_started"></a>](#-getting-started-)
  - [Installing](#installing)
- [🎈 Usage <a name="usage"></a>](#-usage-)
  - [Components Implemented](#components-implemented)
- [⛏️ Built Using <a name = "built_using"></a>](#️-built-using-)
- [✍️ Authors <a name = "authors"></a>](#️-authors-)
- [🎉 Acknowledgements <a name = "acknowledgement"></a>](#-acknowledgements-)

## 🧐 About <a name = "about"></a>

This project is to make your lives easier with lemon, this is also my **Hacktoberfest** project.

Lemon 🍋 : https://github.com/Sas2k/Lemon

## 🏁 Getting Started <a name = "getting_started"></a>

### Installing

**With PIP**
```
pip install Lemon-CLI
```

## 🎈 Usage <a name="usage"></a>

generating a component

```
Lemon-CLI component <component>
```

will create

```
components/
  - <component>.py
```

### Components Implemented

> For the ones, that aren't implemented open an issue and describe it or implement it yourself and PR this.
> (Change the README and related stuff accordingly, Make sure to describe the PR changes well.)

- #### App
  
  A [Base App](Lemon-CLI/components/BaseApp.py) in Lemon.

- #### Form
  
  A [Basic Form](Lemon-CLI/components/Form/Form.py).

- #### EmailPassword

  A [Form](Lemon-CLI/components/Form/email.py) asking for Email and Password.

- #### NavBar

  A simple [Navigation Bar](Lemon-CLI/components/Heading/Navbar.py).

- #### Page Heading

  A simple [Page Heading](Lemon-CLI/components/Heading/PageHeading.py).

- #### Article

  Simple [Article Container](Lemon-CLI/components/Page/Article.py).

- #### Footer

  Conditionally rendered [Footer](Lemon-CLI/components/Page/Footer.py) with author, email, and copyright fields.


## ⛏️ Built Using <a name = "built_using"></a>

- [Python](https://www.python.org)
- [Lemon](https://github.com/Sas2k/Lemon)

## ✍️ Authors <a name = "authors"></a>

<a href="https://github.com/Sas2k/Lemon-CLI/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Sas2k/Lemon-CLI" />
</a>

See also the list of [contributors](https://github.com/Sas2k/Lemon-CLI/contributors) who participated in this project.

## 🎉 Acknowledgements <a name = "acknowledgement"></a>

- Hacktoberfest
