"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const nodeunit_shim_1 = require("nodeunit-shim");
// eslint-disable-next-line max-len
const lib_1 = require("../lib");
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
nodeunit_shim_1.nodeunitShim({
    'test vpc endpoint service': {
        'create endpoint service with no principals'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            new lib_1.Vpc(stack, 'MyVPC');
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).notTo(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: [],
            }));
            test.done();
        },
        'create endpoint service with a principal'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
        'with acceptance requried'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: true,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: true,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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