"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
class VpcEndpointServiceStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const nlbNoPrincipals = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
        const service1 = new ec2.VpcEndpointService(this, 'MyVpcEndpointServiceWithNoPrincipals', {
            vpcEndpointServiceLoadBalancers: [nlbNoPrincipals],
            acceptanceRequired: false,
            whitelistedPrincipals: [],
        });
        const nlbWithPrincipals = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/1jd81k39sa421ffs');
        const principalArn = new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root');
        const service2 = new ec2.VpcEndpointService(this, 'MyVpcEndpointServiceWithPrincipals', {
            vpcEndpointServiceLoadBalancers: [nlbWithPrincipals],
            acceptanceRequired: false,
            whitelistedPrincipals: [principalArn],
        });
        new cdk.CfnOutput(this, 'MyVpcEndpointServiceWithNoPrincipalsServiceName', {
            exportName: 'ServiceName',
            value: service1.vpcEndpointServiceName,
            description: 'Give this to service consumers so they can connect via VPC Endpoint',
        });
        new cdk.CfnOutput(this, 'MyVpcEndpointServiceWithPrincipalsEndpointServiceId', {
            exportName: 'EndpointServiceId',
            value: service2.vpcEndpointServiceId,
            description: 'Reference this service from other stacks',
        });
    }
}
new VpcEndpointServiceStack(app, 'aws-cdk-ec2-vpc-endpoint-service');
app.synth();
//# sourceMappingURL=data:application/json;base64,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