"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerInstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib/core");
/**
 * Supported instance types for SageMaker instance-based production variants.
 */
class SageMakerInstanceType {
    /**
     * Builds an InstanceType from a given string or token (such as a CfnParameter).
     * @param instanceType An instance type as string
     * @returns A strongly typed InstanceType
     */
    static of(instanceType) {
        return new SageMakerInstanceType(instanceType);
    }
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('ml.')) {
            this.instanceTypeIdentifier = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${instanceType})`);
        }
    }
    /**
     * Return the instance type as a string
     * @returns The instance type as a string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.SageMakerInstanceType = SageMakerInstanceType;
_a = JSII_RTTI_SYMBOL_1;
SageMakerInstanceType[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.SageMakerInstanceType", version: "0.1.34" };
/**
 * ml.c4.2xlarge
 */
SageMakerInstanceType.ML_C4_2XLARGE = SageMakerInstanceType.of('ml.c4.2xlarge');
/**
 * ml.c4.4xlarge
 */
SageMakerInstanceType.ML_C4_4XLARGE = SageMakerInstanceType.of('ml.c4.4xlarge');
/**
 * ml.c4.8xlarge
 */
SageMakerInstanceType.ML_C4_8XLARGE = SageMakerInstanceType.of('ml.c4.8xlarge');
/**
 * ml.c4.large
 */
SageMakerInstanceType.ML_C4_LARGE = SageMakerInstanceType.of('ml.c4.large');
/**
 * ml.c4.xlarge
 */
SageMakerInstanceType.ML_C4_XLARGE = SageMakerInstanceType.of('ml.c4.xlarge');
/**
 * ml.c5.18xlarge
 */
SageMakerInstanceType.ML_C5_18XLARGE = SageMakerInstanceType.of('ml.c5.18xlarge');
/**
 * ml.c5.2xlarge
 */
SageMakerInstanceType.ML_C5_2XLARGE = SageMakerInstanceType.of('ml.c5.2xlarge');
/**
 * ml.c5.4xlarge
 */
SageMakerInstanceType.ML_C5_4XLARGE = SageMakerInstanceType.of('ml.c5.4xlarge');
/**
 * ml.c5.9xlarge
 */
SageMakerInstanceType.ML_C5_9XLARGE = SageMakerInstanceType.of('ml.c5.9xlarge');
/**
 * ml.c5.large
 */
SageMakerInstanceType.ML_C5_LARGE = SageMakerInstanceType.of('ml.c5.large');
/**
 * ml.c5.xlarge
 */
SageMakerInstanceType.ML_C5_XLARGE = SageMakerInstanceType.of('ml.c5.xlarge');
/**
 * ml.c5d.18xlarge
 */
SageMakerInstanceType.ML_C5D_18XLARGE = SageMakerInstanceType.of('ml.c5d.18xlarge');
/**
 * ml.c5d.2xlarge
 */
SageMakerInstanceType.ML_C5D_2XLARGE = SageMakerInstanceType.of('ml.c5d.2xlarge');
/**
 * ml.c5d.4xlarge
 */
SageMakerInstanceType.ML_C5D_4XLARGE = SageMakerInstanceType.of('ml.c5d.4xlarge');
/**
 * ml.c5d.9xlarge
 */
SageMakerInstanceType.ML_C5D_9XLARGE = SageMakerInstanceType.of('ml.c5d.9xlarge');
/**
 * ml.c5d.large
 */
SageMakerInstanceType.ML_C5D_LARGE = SageMakerInstanceType.of('ml.c5d.large');
/**
 * ml.c5d.xlarge
 */
SageMakerInstanceType.ML_C5D_XLARGE = SageMakerInstanceType.of('ml.c5d.xlarge');
/**
 * ml.c6i.12xlarge
 */
SageMakerInstanceType.ML_C6I_12XLARGE = SageMakerInstanceType.of('ml.c6i.12xlarge');
/**
 * ml.c6i.16xlarge
 */
SageMakerInstanceType.ML_C6I_16XLARGE = SageMakerInstanceType.of('ml.c6i.16xlarge');
/**
 * ml.c6i.24xlarge
 */
SageMakerInstanceType.ML_C6I_24XLARGE = SageMakerInstanceType.of('ml.c6i.24xlarge');
/**
 * ml.c6i.2xlarge
 */
SageMakerInstanceType.ML_C6I_2XLARGE = SageMakerInstanceType.of('ml.c6i.2xlarge');
/**
 * ml.c6i.32xlarge
 */
SageMakerInstanceType.ML_C6I_32XLARGE = SageMakerInstanceType.of('ml.c6i.32xlarge');
/**
 * ml.c6i.4xlarge
 */
SageMakerInstanceType.ML_C6I_4XLARGE = SageMakerInstanceType.of('ml.c6i.4xlarge');
/**
 * ml.c6i.8xlarge
 */
SageMakerInstanceType.ML_C6I_8XLARGE = SageMakerInstanceType.of('ml.c6i.8xlarge');
/**
 * ml.c6i.large
 */
SageMakerInstanceType.ML_C6I_LARGE = SageMakerInstanceType.of('ml.c6i.large');
/**
 * ml.c6i.xlarge
 */
SageMakerInstanceType.ML_C6I_XLARGE = SageMakerInstanceType.of('ml.c6i.xlarge');
/**
 * ml.g4dn.12xlarge
 */
SageMakerInstanceType.ML_G4DN_12XLARGE = SageMakerInstanceType.of('ml.g4dn.12xlarge');
/**
 * ml.g4dn.16xlarge
 */
SageMakerInstanceType.ML_G4DN_16XLARGE = SageMakerInstanceType.of('ml.g4dn.16xlarge');
/**
 * ml.g4dn.2xlarge
 */
SageMakerInstanceType.ML_G4DN_2XLARGE = SageMakerInstanceType.of('ml.g4dn.2xlarge');
/**
 * ml.g4dn.4xlarge
 */
SageMakerInstanceType.ML_G4DN_4XLARGE = SageMakerInstanceType.of('ml.g4dn.4xlarge');
/**
 * ml.g4dn.8xlarge
 */
SageMakerInstanceType.ML_G4DN_8XLARGE = SageMakerInstanceType.of('ml.g4dn.8xlarge');
/**
 * ml.g4dn.xlarge
 */
SageMakerInstanceType.ML_G4DN_XLARGE = SageMakerInstanceType.of('ml.g4dn.xlarge');
/**
 * ml.g5.12xlarge
 */
SageMakerInstanceType.ML_G5_12XLARGE = SageMakerInstanceType.of('ml.g5.12xlarge');
/**
 * ml.g5.16xlarge
 */
SageMakerInstanceType.ML_G5_16XLARGE = SageMakerInstanceType.of('ml.g5.16xlarge');
/**
 * ml.g5.24xlarge
 */
SageMakerInstanceType.ML_G5_24XLARGE = SageMakerInstanceType.of('ml.g5.24xlarge');
/**
 * ml.g5.2xlarge
 */
SageMakerInstanceType.ML_G5_2XLARGE = SageMakerInstanceType.of('ml.g5.2xlarge');
/**
 * ml.g5.48xlarge
 */
SageMakerInstanceType.ML_G5_48XLARGE = SageMakerInstanceType.of('ml.g5.48xlarge');
/**
 * ml.g5.4xlarge
 */
SageMakerInstanceType.ML_G5_4XLARGE = SageMakerInstanceType.of('ml.g5.4xlarge');
/**
 * ml.g5.8xlarge
 */
SageMakerInstanceType.ML_G5_8XLARGE = SageMakerInstanceType.of('ml.g5.8xlarge');
/**
 * ml.g5.xlarge
 */
SageMakerInstanceType.ML_G5_XLARGE = SageMakerInstanceType.of('ml.g5.xlarge');
/**
 * ml.inf1.24xlarge
 */
SageMakerInstanceType.ML_INF1_24XLARGE = SageMakerInstanceType.of('ml.inf1.24xlarge');
/**
 * ml.inf1.2xlarge
 */
SageMakerInstanceType.ML_INF1_2XLARGE = SageMakerInstanceType.of('ml.inf1.2xlarge');
/**
 * ml.inf1.6xlarge
 */
SageMakerInstanceType.ML_INF1_6XLARGE = SageMakerInstanceType.of('ml.inf1.6xlarge');
/**
 * ml.inf1.xlarge
 */
SageMakerInstanceType.ML_INF1_XLARGE = SageMakerInstanceType.of('ml.inf1.xlarge');
/**
 * ml.inf2.xlarge
 */
SageMakerInstanceType.ML_INF2_XLARGE = SageMakerInstanceType.of('ml.inf2.xlarge');
/**
 * ml.inf2.8xlarge
 */
SageMakerInstanceType.ML_INF2_8XLARGE = SageMakerInstanceType.of('ml.inf2.8xlarge');
/**
 * ml.inf2.24xlarge
 */
SageMakerInstanceType.ML_INF2_24XLARGE = SageMakerInstanceType.of('ml.inf2.24xlarge');
/**
 * ml.inf2.48xlarge
 */
SageMakerInstanceType.ML_INF2_48XLARGE = SageMakerInstanceType.of('ml.inf2.48xlarge');
/**
 * ml.m4.10xlarge
 */
SageMakerInstanceType.ML_M4_10XLARGE = SageMakerInstanceType.of('ml.m4.10xlarge');
/**
 * ml.m4.16xlarge
 */
SageMakerInstanceType.ML_M4_16XLARGE = SageMakerInstanceType.of('ml.m4.16xlarge');
/**
 * ml.m4.2xlarge
 */
SageMakerInstanceType.ML_M4_2XLARGE = SageMakerInstanceType.of('ml.m4.2xlarge');
/**
 * ml.m4.4xlarge
 */
SageMakerInstanceType.ML_M4_4XLARGE = SageMakerInstanceType.of('ml.m4.4xlarge');
/**
 * ml.m4.xlarge
 */
SageMakerInstanceType.ML_M4_XLARGE = SageMakerInstanceType.of('ml.m4.xlarge');
/**
 * ml.m5.12xlarge
 */
SageMakerInstanceType.ML_M5_12XLARGE = SageMakerInstanceType.of('ml.m5.12xlarge');
/**
 * ml.m5.24xlarge
 */
SageMakerInstanceType.ML_M5_24XLARGE = SageMakerInstanceType.of('ml.m5.24xlarge');
/**
 * ml.m5.2xlarge
 */
SageMakerInstanceType.ML_M5_2XLARGE = SageMakerInstanceType.of('ml.m5.2xlarge');
/**
 * ml.m5.4xlarge
 */
SageMakerInstanceType.ML_M5_4XLARGE = SageMakerInstanceType.of('ml.m5.4xlarge');
/**
 * ml.m5.large
 */
SageMakerInstanceType.ML_M5_LARGE = SageMakerInstanceType.of('ml.m5.large');
/**
 * ml.m5.xlarge
 */
SageMakerInstanceType.ML_M5_XLARGE = SageMakerInstanceType.of('ml.m5.xlarge');
/**
 * ml.m5d.12xlarge
 */
SageMakerInstanceType.ML_M5D_12XLARGE = SageMakerInstanceType.of('ml.m5d.12xlarge');
/**
 * ml.m5d.24xlarge
 */
SageMakerInstanceType.ML_M5D_24XLARGE = SageMakerInstanceType.of('ml.m5d.24xlarge');
/**
 * ml.m5d.2xlarge
 */
SageMakerInstanceType.ML_M5D_2XLARGE = SageMakerInstanceType.of('ml.m5d.2xlarge');
/**
 * ml.m5d.4xlarge
 */
SageMakerInstanceType.ML_M5D_4XLARGE = SageMakerInstanceType.of('ml.m5d.4xlarge');
/**
 * ml.m5d.large
 */
SageMakerInstanceType.ML_M5D_LARGE = SageMakerInstanceType.of('ml.m5d.large');
/**
 * ml.m5d.xlarge
 */
SageMakerInstanceType.ML_M5D_XLARGE = SageMakerInstanceType.of('ml.m5d.xlarge');
/**
 * ml.p2.16xlarge
 */
SageMakerInstanceType.ML_P2_16XLARGE = SageMakerInstanceType.of('ml.p2.16xlarge');
/**
 * ml.p2.8xlarge
 */
SageMakerInstanceType.ML_P2_8XLARGE = SageMakerInstanceType.of('ml.p2.8xlarge');
/**
 * ml.p2.xlarge
 */
SageMakerInstanceType.ML_P2_XLARGE = SageMakerInstanceType.of('ml.p2.xlarge');
/**
 * ml.p3.16xlarge
 */
SageMakerInstanceType.ML_P3_16XLARGE = SageMakerInstanceType.of('ml.p3.16xlarge');
/**
 * ml.p3.2xlarge
 */
SageMakerInstanceType.ML_P3_2XLARGE = SageMakerInstanceType.of('ml.p3.2xlarge');
/**
 * ml.p3.8xlarge
 */
SageMakerInstanceType.ML_P3_8XLARGE = SageMakerInstanceType.of('ml.p3.8xlarge');
/**
 * ml.p4d.24xlarge
 */
SageMakerInstanceType.ML_P4D_24XLARGE = SageMakerInstanceType.of('ml.p4d.24xlarge');
/**
 * ml.r5.12xlarge
 */
SageMakerInstanceType.ML_R5_12XLARGE = SageMakerInstanceType.of('ml.r5.12xlarge');
/**
 * ml.r5.24xlarge
 */
SageMakerInstanceType.ML_R5_24XLARGE = SageMakerInstanceType.of('ml.r5.24xlarge');
/**
 * ml.r5.2xlarge
 */
SageMakerInstanceType.ML_R5_2XLARGE = SageMakerInstanceType.of('ml.r5.2xlarge');
/**
 * ml.r5.4xlarge
 */
SageMakerInstanceType.ML_R5_4XLARGE = SageMakerInstanceType.of('ml.r5.4xlarge');
/**
 * ml.r5.large
 */
SageMakerInstanceType.ML_R5_LARGE = SageMakerInstanceType.of('ml.r5.large');
/**
 * ml.r5.xlarge
 */
SageMakerInstanceType.ML_R5_XLARGE = SageMakerInstanceType.of('ml.r5.xlarge');
/**
 * ml.r5d.12xlarge
 */
SageMakerInstanceType.ML_R5D_12XLARGE = SageMakerInstanceType.of('ml.r5d.12xlarge');
/**
 * ml.r5d.24xlarge
 */
SageMakerInstanceType.ML_R5D_24XLARGE = SageMakerInstanceType.of('ml.r5d.24xlarge');
/**
 * ml.r5d.2xlarge
 */
SageMakerInstanceType.ML_R5D_2XLARGE = SageMakerInstanceType.of('ml.r5d.2xlarge');
/**
 * ml.r5d.4xlarge
 */
SageMakerInstanceType.ML_R5D_4XLARGE = SageMakerInstanceType.of('ml.r5d.4xlarge');
/**
 * ml.r5d.large
 */
SageMakerInstanceType.ML_R5D_LARGE = SageMakerInstanceType.of('ml.r5d.large');
/**
 * ml.r5d.xlarge
 */
SageMakerInstanceType.ML_R5D_XLARGE = SageMakerInstanceType.of('ml.r5d.xlarge');
/**
 * ml.t2.2xlarge
 */
SageMakerInstanceType.ML_T2_2XLARGE = SageMakerInstanceType.of('ml.t2.2xlarge');
/**
 * ml.t2.large
 */
SageMakerInstanceType.ML_T2_LARGE = SageMakerInstanceType.of('ml.t2.large');
/**
 * ml.t2.medium
 */
SageMakerInstanceType.ML_T2_MEDIUM = SageMakerInstanceType.of('ml.t2.medium');
/**
 * ml.t2.xlarge
 */
SageMakerInstanceType.ML_T2_XLARGE = SageMakerInstanceType.of('ml.t2.xlarge');
//# sourceMappingURL=data:application/json;base64,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