"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const assets = require("aws-cdk-lib/aws-ecr-assets");
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
/**
 *
 * https://github.com/aws/deep-learning-containers/blob/master/available_images.md
 */
class ContainerImage {
    static fromEcrRepository(repository, tag = 'latest') {
        return new EcrImage(repository, tag);
    }
    static fromAsset(directory, options = {}) {
        return new AssetImage(directory, options);
    }
}
exports.ContainerImage = ContainerImage;
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.ContainerImage", version: "0.1.34" };
class EcrImage extends ContainerImage {
    constructor(repository, tag) {
        super();
        this.repository = repository;
        this.tag = tag;
    }
    bind(_scope, grantable) {
        this.repository.grantPull(grantable);
        return {
            imageName: this.repository.repositoryUriForTag(this.tag),
        };
    }
}
class AssetImage extends ContainerImage {
    constructor(directory, options = {}) {
        super();
        this.directory = directory;
        this.options = options;
    }
    bind(scope, grantable) {
        // Retain the first instantiation of this asset
        if (!this.asset) {
            this.asset = new assets.DockerImageAsset(scope, `ModelImage${(0, helpers_internal_1.md5hash)(this.directory)}`, {
                directory: this.directory,
                ...this.options,
            });
        }
        this.asset.repository.grantPull(grantable);
        return {
            imageName: this.asset.imageUri,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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