/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as fs from 'fs';
import * as https from 'https';
export declare abstract class GenerateUtils {
    static replaceAll(str: string, find: string, replace: string): string;
    static replaceAllBatch(str: string, find: string[], replace: string): string;
    static writeFileSyncWithDirs(filePath: string, data: string | NodeJS.ArrayBufferView, options?: fs.WriteFileOptions | undefined): void;
    static downloadJSON(options: string | URL | https.RequestOptions): Promise<any>;
}
