"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LangchainCommonLayer = exports.LangchainCommonDepsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const python_lambda_layer_helper_1 = require("../../../common/helpers/python-lambda-layer-helper");
/**
   * @summary The LangchainCommonDepsLayer class.
   */
class LangchainCommonDepsLayer extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the LangchainCommonDepsLayer class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        const layer = new python_lambda_layer_helper_1.Layer(this, 'langchaincommonlayer', {
            runtime: props.runtime,
            architecture: props.architecture,
            path: path.join(__dirname, '../../../../layers/langchain-common-deps'),
            description: 'Dependencies to build gen ai applications with the langchain client',
            autoUpgrade: props.autoUpgrade,
            local: props.local,
        });
        this.layer = layer.layer;
    }
}
exports.LangchainCommonDepsLayer = LangchainCommonDepsLayer;
_a = JSII_RTTI_SYMBOL_1;
LangchainCommonDepsLayer[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.LangchainCommonDepsLayer", version: "0.1.34" };
/**
   * @summary The LangchainCommonLayer class.
   */
class LangchainCommonLayer extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the LangchainCommonLayer class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        const layer = new lambda.LayerVersion(this, 'langchaincommonlayer', {
            compatibleRuntimes: [props.runtime],
            compatibleArchitectures: [props.architecture],
            code: lambda.Code.fromAsset(path.join(__dirname, '../../../../layers/langchain-common-layer')),
            description: 'Utilities to build gen ai applications with the langchain client',
        });
        this.layer = layer;
    }
}
exports.LangchainCommonLayer = LangchainCommonLayer;
_b = JSII_RTTI_SYMBOL_1;
LangchainCommonLayer[_b] = { fqn: "@cdklabs/generative-ai-cdk-constructs.LangchainCommonLayer", version: "0.1.34" };
//# sourceMappingURL=data:application/json;base64,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