import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
/**
 * The properties for the LangchainLayerProps class.
 */
export interface LangchainLayerProps {
    /**
     * Required. Lambda function runtime compatible with this Layer.
     *
     * @default - none
     */
    readonly runtime: lambda.Runtime;
    /**
     * Required. Lambda function architecture compatible with this Layer.
     *
     * @default - none
     */
    readonly architecture: lambda.Architecture;
    /**
     * Optional: Add '--upgrade' to pip install requirements.txt
     * In case of a LangchainCommonLayer, this parameter is not used.
     *
     * @default - false
     */
    readonly autoUpgrade?: boolean;
    /**
     * Optional: Local compute will be used when installing requirements.txt.
     * By default, a docker container will be spun up to install requirements. To override this behavior, use the python alias string of `python` or `python3`
     * The string value will be the python alias used to install requirements.
     *
     * @default - none
     */
    readonly local?: 'python' | 'python3';
}
/**
   * @summary The LangchainCommonDepsLayer class.
   */
export declare class LangchainCommonDepsLayer extends Construct {
    /**
     * Returns the instance of lambda.LayerVersion created by the construct
     */
    readonly layer: lambda.LayerVersion;
    /**
       * @summary Constructs a new instance of the LangchainCommonDepsLayer class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: LangchainLayerProps);
}
/**
   * @summary The LangchainCommonLayer class.
   */
export declare class LangchainCommonLayer extends Construct {
    /**
     * Returns the instance of lambda.LayerVersion created by the construct
     */
    readonly layer: lambda.LayerVersion;
    /**
       * @summary Constructs a new instance of the LangchainCommonLayer class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {LangchainLayerProps} props - user provided props for the construct.
       * @since 0.0.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: LangchainLayerProps);
}
