import { IConstruct } from 'constructs';
/**
 * The version of this package
 */
export declare const version: any;
/**
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 *
 * @summary Creates a physical resource name in the style of the CDK (string+hash) - this value incorporates Stack ID or
 * the Stack Name, so it will remain static in multiple updates of a single stack, but will be different in a separate
 * stack instance.
 * @param {string} prefix - the prefix to use for the name
 * @param {string[]} parts - the various string components of the name (eg - stackName, solutions construct ID, L2 construct ID)
 * @param {number} maxLength - the longest string that can be returned
 * @param {boolean} lower - whether to return the name in lowercase or mixed case
 * @param {IConstruct} resource - the resource that is calling this function (used to extract the stack Name and Node ID)
 * @returns {string} - a string with concatenated parts (truncated if necessary) + a hash of the full concatenated parts
 *
 */
export declare function generatePhysicalName(prefix: string, parts: string[], maxLength: number, lower?: boolean, resource?: IConstruct): string;
export declare const maximumLambdaMemorySizeContextItem = "maximumLambdaMemorySize";
export declare const recommendedMaximumLambdaMemorySize = 7076;
export declare function lambdaMemorySizeLimiter(construct: IConstruct, requestedMemorySizeInMegabytes: number): number;
