"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckS3Props = void 0;
function CheckS3Props(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if ((propsObject.existingBucketObj || propsObject.existingBucketInterface) && propsObject.bucketProps) {
        errorMessages += 'Error - Either provide bucketProps or existingBucketObj, but not both.\n';
        errorFound = true;
    }
    if (propsObject.existingLoggingBucketObj && propsObject.loggingBucketProps) {
        errorMessages += 'Error - Either provide existingLoggingBucketObj or loggingBucketProps, but not both.\n';
        errorFound = true;
    }
    if ((propsObject?.logS3AccessLogs === false) && (propsObject.loggingBucketProps || propsObject.existingLoggingBucketObj)) {
        errorMessages += 'Error - If logS3AccessLogs is false, supplying loggingBucketProps or existingLoggingBucketObj is invalid.\n';
        errorFound = true;
    }
    if (propsObject.existingBucketObj && (propsObject.loggingBucketProps || propsObject.logS3AccessLogs)) {
        errorMessages += 'Error - If existingBucketObj is provided, supplying loggingBucketProps or logS3AccessLogs is an error.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckS3Props = CheckS3Props;
//# sourceMappingURL=data:application/json;base64,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