"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckEventBridgeProps = exports.buildEventBus = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const events = require("aws-cdk-lib/aws-events");
function buildEventBus(scope, props) {
    if (props.existingEventBusInterface) {
        return props.existingEventBusInterface;
    }
    else {
        const eventBusName = props.eventBusProps?.eventBusName || 'customEventBus';
        return new events.EventBus(scope, eventBusName, props.eventBusProps);
    }
}
exports.buildEventBus = buildEventBus;
function CheckEventBridgeProps(propsObject) {
    let errorMessages = '';
    let errorFound = false;
    if (propsObject.existingEventBusInterface && propsObject.eventBusProps) {
        errorMessages += 'Error - Either provide existingEventBusInterface or eventBusProps, but not both.\n';
        errorFound = true;
    }
    if (errorFound) {
        throw new Error(errorMessages);
    }
}
exports.CheckEventBridgeProps = CheckEventBridgeProps;
//# sourceMappingURL=data:application/json;base64,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