CRAIGSLIST = {
    "africa": {
        "selector": "region",
        "title": "Africa",
        "child": {
            "egypt": {
                "selector": "country",
                "title": "Egypt",
                "child": {"cairo": {"selector": "site", "title": "Egypt", "child": {},}},
            },
            "ethiopia": {
                "selector": "country",
                "title": "Ethiopia",
                "child": {"addisababa": {"selector": "site", "title": "Ethiopia", "child": {},}},
            },
            "ghana": {
                "selector": "country",
                "title": "Ghana",
                "child": {"accra": {"selector": "site", "title": "Ghana", "child": {},}},
            },
            "kenya": {
                "selector": "country",
                "title": "Kenya",
                "child": {"kenya": {"selector": "site", "title": "Kenya", "child": {},}},
            },
            "morocco": {
                "selector": "country",
                "title": "Morocco",
                "child": {"casablanca": {"selector": "site", "title": "Morocco", "child": {},}},
            },
            "south_africa": {
                "selector": "country",
                "title": "South Africa",
                "child": {
                    "capetown": {"selector": "site", "title": "Cape Town", "child": {},},
                    "durban": {"selector": "site", "title": "Durban", "child": {},},
                    "johannesburg": {"selector": "site", "title": "Johannesburg", "child": {},},
                    "pretoria": {"selector": "site", "title": "Pretoria", "child": {},},
                },
            },
            "tunisia": {
                "selector": "country",
                "title": "Tunisia",
                "child": {"tunis": {"selector": "site", "title": "Tunisia", "child": {},}},
            },
        },
    },
    "americas": {
        "selector": "region",
        "title": "Americas",
        "child": {
            "argentina": {
                "selector": "country",
                "title": "Argentina",
                "child": {
                    "buenosaires": {"selector": "site", "title": "Buenos Aires", "child": {},}
                },
            },
            "bolivia": {
                "selector": "country",
                "title": "Bolivia",
                "child": {"lapaz": {"selector": "site", "title": "Bolivia", "child": {},}},
            },
            "brazil": {
                "selector": "country",
                "title": "Brazil",
                "child": {
                    "belohorizonte": {"selector": "site", "title": "Belo Horizonte", "child": {},},
                    "brasilia": {"selector": "site", "title": "Bras\u00edlia", "child": {},},
                    "curitiba": {"selector": "site", "title": "Curitiba", "child": {},},
                    "fortaleza": {"selector": "site", "title": "Fortaleza", "child": {},},
                    "portoalegre": {"selector": "site", "title": "Porto Alegre", "child": {},},
                    "recife": {"selector": "site", "title": "Recife", "child": {},},
                    "rio": {"selector": "site", "title": "Rio De Janeiro", "child": {},},
                    "salvador": {"selector": "site", "title": "Salvador, Bahia", "child": {},},
                    "saopaulo": {"selector": "site", "title": "S\u00e3o Paulo", "child": {},},
                },
            },
            "canada": {
                "selector": "country",
                "title": "Canada",
                "child": {
                    "abbotsford": {"selector": "site", "title": "Fraser Valley, BC", "child": {},},
                    "barrie": {"selector": "site", "title": "Barrie, ON", "child": {},},
                    "belleville": {"selector": "site", "title": "Belleville, ON", "child": {},},
                    "brantford": {"selector": "site", "title": "Brantford-Woodstock", "child": {},},
                    "calgary": {"selector": "site", "title": "Calgary, AB", "child": {},},
                    "cariboo": {"selector": "site", "title": "Cariboo, BC", "child": {},},
                    "chatham": {"selector": "site", "title": "Chatham-Kent, ON", "child": {},},
                    "comoxvalley": {"selector": "site", "title": "Comox Valley, BC", "child": {},},
                    "cornwall": {"selector": "site", "title": "Cornwall, ON", "child": {},},
                    "edmonton": {"selector": "site", "title": "Edmonton, AB", "child": {},},
                    "ftmcmurray": {"selector": "site", "title": "Ft Mcmurray, AB", "child": {},},
                    "guelph": {"selector": "site", "title": "Guelph, ON", "child": {},},
                    "halifax": {"selector": "site", "title": "Halifax, NS", "child": {},},
                    "hamilton": {"selector": "site", "title": "Hamilton-Burlington", "child": {},},
                    "hat": {"selector": "site", "title": "Medicine Hat, AB", "child": {},},
                    "kamloops": {"selector": "site", "title": "Kamloops, BC", "child": {},},
                    "kelowna": {"selector": "site", "title": "Kelowna / Okanagan", "child": {},},
                    "kingston": {"selector": "site", "title": "Kingston, ON", "child": {},},
                    "kitchener": {
                        "selector": "site",
                        "title": "Kitchener-Waterloo-Cambridge",
                        "child": {},
                    },
                    "kootenays": {"selector": "site", "title": "Kootenays, BC", "child": {},},
                    "lethbridge": {"selector": "site", "title": "Lethbridge, AB", "child": {},},
                    "londonon": {"selector": "site", "title": "London, ON", "child": {},},
                    "montreal": {"selector": "site", "title": "Montreal, QC", "child": {},},
                    "nanaimo": {"selector": "site", "title": "Nanaimo, BC", "child": {},},
                    "newbrunswick": {"selector": "site", "title": "New Brunswick", "child": {},},
                    "newfoundland": {"selector": "site", "title": "St John'S, NL", "child": {},},
                    "niagara": {"selector": "site", "title": "Niagara Region", "child": {},},
                    "ottawa": {"selector": "site", "title": "Ottawa-Hull-Gatineau", "child": {},},
                    "owensound": {"selector": "site", "title": "Owen Sound, ON", "child": {},},
                    "peace": {"selector": "site", "title": "Peace River Country", "child": {},},
                    "pei": {"selector": "site", "title": "Prince Edward Island", "child": {},},
                    "peterborough": {"selector": "site", "title": "Peterborough, ON", "child": {},},
                    "princegeorge": {
                        "selector": "site",
                        "title": "Prince George, BC",
                        "child": {},
                    },
                    "quebec": {"selector": "site", "title": "Qu\u00e9bec (Ville)", "child": {},},
                    "reddeer": {"selector": "site", "title": "Red Deer, AB", "child": {},},
                    "regina": {"selector": "site", "title": "Regina, SK", "child": {},},
                    "saguenay": {"selector": "site", "title": "Saguenay, QC", "child": {},},
                    "sarnia": {"selector": "site", "title": "Sarnia, ON", "child": {},},
                    "saskatoon": {"selector": "site", "title": "Saskatoon, SK", "child": {},},
                    "sherbrooke": {"selector": "site", "title": "Sherbrooke, QC", "child": {},},
                    "skeena": {"selector": "site", "title": "Skeena-Bulkley", "child": {},},
                    "soo": {"selector": "site", "title": "Sault Ste Marie, ON", "child": {},},
                    "sudbury": {"selector": "site", "title": "Sudbury, ON", "child": {},},
                    "sunshine": {"selector": "site", "title": "Sunshine Coast, BC", "child": {},},
                    "territories": {"selector": "site", "title": "Territories", "child": {},},
                    "thunderbay": {"selector": "site", "title": "Thunder Bay, ON", "child": {},},
                    "toronto": {
                        "selector": "site",
                        "title": "Toronto",
                        "child": {
                            "bra": {"selector": "area", "title": "Brampton-Caledon", "child": {},},
                            "drh": {"selector": "area", "title": "Durham Region", "child": {},},
                            "mss": {"selector": "area", "title": "Mississauga", "child": {},},
                            "oak": {"selector": "area", "title": "Oakville-Milton", "child": {},},
                            "tor": {"selector": "area", "title": "City of Toronto", "child": {},},
                            "yrk": {"selector": "area", "title": "York Region", "child": {},},
                        },
                    },
                    "troisrivieres": {
                        "selector": "site",
                        "title": "Trois-Rivieres, QC",
                        "child": {},
                    },
                    "vancouver": {
                        "selector": "site",
                        "title": "Vancouver, BC",
                        "child": {
                            "bnc": {"selector": "area", "title": "Burnaby/Newwest", "child": {},},
                            "nvn": {"selector": "area", "title": "North Shore", "child": {},},
                            "pml": {
                                "selector": "area",
                                "title": "Tricities/Pitt/Maple",
                                "child": {},
                            },
                            "rch": {"selector": "area", "title": "Richmond", "child": {},},
                            "rds": {
                                "selector": "area",
                                "title": "Delta/Surrey/Langley",
                                "child": {},
                            },
                            "van": {"selector": "area", "title": "City of Vancouver", "child": {},},
                        },
                    },
                    "whistler": {"selector": "site", "title": "Whistler / Squamish", "child": {},},
                    "whitehorse": {"selector": "site", "title": "Whitehorse, YT", "child": {},},
                    "winnipeg": {"selector": "site", "title": "Winnipeg, MB", "child": {},},
                    "yellowknife": {"selector": "site", "title": "Yellowknife, NT", "child": {},},
                },
            },
            "chile": {
                "selector": "country",
                "title": "Chile",
                "child": {"santiago": {"selector": "site", "title": "Chile", "child": {},}},
            },
            "colombia": {
                "selector": "country",
                "title": "Colombia",
                "child": {"colombia": {"selector": "site", "title": "Colombia", "child": {},}},
            },
            "costa_rica": {
                "selector": "country",
                "title": "Costa Rica",
                "child": {"costarica": {"selector": "site", "title": "Costa Rica", "child": {},}},
            },
            "dominican_republic": {
                "selector": "country",
                "title": "Dominican Republic",
                "child": {
                    "santodomingo": {
                        "selector": "site",
                        "title": "Rep\u00fablica Dominicana",
                        "child": {},
                    }
                },
            },
            "ecuador": {
                "selector": "country",
                "title": "Ecuador",
                "child": {"quito": {"selector": "site", "title": "Ecuador", "child": {},}},
            },
            "el_salvador": {
                "selector": "country",
                "title": "El Salvador",
                "child": {"elsalvador": {"selector": "site", "title": "El Salvador", "child": {},}},
            },
            "guatemala": {
                "selector": "country",
                "title": "Guatemala",
                "child": {"guatemala": {"selector": "site", "title": "Guatemala", "child": {},}},
            },
            "mexico": {
                "selector": "country",
                "title": "Mexico",
                "child": {
                    "acapulco": {"selector": "site", "title": "Acapulco", "child": {},},
                    "bajasur": {"selector": "site", "title": "Baja California Sur", "child": {},},
                    "chihuahua": {"selector": "site", "title": "Chihuahua", "child": {},},
                    "guadalajara": {"selector": "site", "title": "Guadalajara, MX", "child": {},},
                    "guanajuato": {"selector": "site", "title": "Guanajuato", "child": {},},
                    "hermosillo": {"selector": "site", "title": "Hermosillo", "child": {},},
                    "juarez": {"selector": "site", "title": "Ciudad Ju\u00e1rez", "child": {},},
                    "mazatlan": {"selector": "site", "title": "Mazatl\u00e1n", "child": {},},
                    "mexicocity": {
                        "selector": "site",
                        "title": "Ciudad De M\u00e9xico",
                        "child": {},
                    },
                    "monterrey": {"selector": "site", "title": "Monterrey", "child": {},},
                    "oaxaca": {"selector": "site", "title": "Oaxaca", "child": {},},
                    "puebla": {"selector": "site", "title": "Puebla, MX", "child": {},},
                    "pv": {"selector": "site", "title": "Puerto Vallarta", "child": {},},
                    "tijuana": {"selector": "site", "title": "Tijuana, MX", "child": {},},
                    "veracruz": {"selector": "site", "title": "Veracruz", "child": {},},
                    "yucatan": {"selector": "site", "title": "Yucat\u00e1n", "child": {},},
                },
            },
            "nicaragua": {
                "selector": "country",
                "title": "Nicaragua",
                "child": {"managua": {"selector": "site", "title": "Nicaragua", "child": {},}},
            },
            "panama": {
                "selector": "country",
                "title": "Panama",
                "child": {"panama": {"selector": "site", "title": "Panama", "child": {},}},
            },
            "peru": {
                "selector": "country",
                "title": "Peru",
                "child": {"lima": {"selector": "site", "title": "Peru", "child": {},}},
            },
            "puerto_rico": {
                "selector": "country",
                "title": "Puerto Rico",
                "child": {"puertorico": {"selector": "site", "title": "Puerto Rico", "child": {},}},
            },
            "united_states": {
                "selector": "country",
                "title": "United States",
                "child": {
                    "abilene": {"selector": "site", "title": "Abilene, TX", "child": {},},
                    "akroncanton": {"selector": "site", "title": "Akron / Canton", "child": {},},
                    "albany": {"selector": "site", "title": "Albany, NY", "child": {},},
                    "albanyga": {"selector": "site", "title": "Albany, GA", "child": {},},
                    "albuquerque": {"selector": "site", "title": "Albuquerque", "child": {},},
                    "allentown": {"selector": "site", "title": "Lehigh Valley", "child": {},},
                    "altoona": {"selector": "site", "title": "Altoona-Johnstown", "child": {},},
                    "amarillo": {"selector": "site", "title": "Amarillo, TX", "child": {},},
                    "ames": {"selector": "site", "title": "Ames, IA", "child": {},},
                    "anchorage": {"selector": "site", "title": "Anchorage / Mat-Su", "child": {},},
                    "annapolis": {"selector": "site", "title": "Annapolis, MD", "child": {},},
                    "annarbor": {"selector": "site", "title": "Ann Arbor, MI", "child": {},},
                    "appleton": {"selector": "site", "title": "Appleton-Oshkosh-Fdl", "child": {},},
                    "asheville": {"selector": "site", "title": "Asheville, NC", "child": {},},
                    "ashtabula": {"selector": "site", "title": "Ashtabula, OH", "child": {},},
                    "athensga": {"selector": "site", "title": "Athens, GA", "child": {},},
                    "athensohio": {"selector": "site", "title": "Athens, OH", "child": {},},
                    "atlanta": {
                        "selector": "site",
                        "title": "Atlanta, GA",
                        "child": {
                            "atl": {"selector": "area", "title": "City of Atlanta", "child": {},},
                            "eat": {"selector": "area", "title": "Otp East", "child": {},},
                            "nat": {"selector": "area", "title": "Otp North", "child": {},},
                            "sat": {"selector": "area", "title": "Otp South", "child": {},},
                            "wat": {"selector": "area", "title": "Otp West", "child": {},},
                        },
                    },
                    "auburn": {"selector": "site", "title": "Auburn, AL", "child": {},},
                    "austin": {"selector": "site", "title": "Austin, TX", "child": {},},
                    "bakersfield": {"selector": "site", "title": "Bakersfield, CA", "child": {},},
                    "baltimore": {"selector": "site", "title": "Baltimore, MD", "child": {},},
                    "batonrouge": {"selector": "site", "title": "Baton Rouge", "child": {},},
                    "battlecreek": {"selector": "site", "title": "Battle Creek, MI", "child": {},},
                    "beaumont": {
                        "selector": "site",
                        "title": "Beaumont / Port Arthur",
                        "child": {},
                    },
                    "bellingham": {"selector": "site", "title": "Bellingham, WA", "child": {},},
                    "bemidji": {"selector": "site", "title": "Bemidji, MN", "child": {},},
                    "bend": {"selector": "site", "title": "Bend, OR", "child": {},},
                    "bgky": {"selector": "site", "title": "Bowling Green, KY", "child": {},},
                    "bham": {"selector": "site", "title": "Birmingham, AL", "child": {},},
                    "bigbend": {"selector": "site", "title": "Southwest Tx", "child": {},},
                    "billings": {"selector": "site", "title": "Billings, MT", "child": {},},
                    "binghamton": {"selector": "site", "title": "Binghamton, NY", "child": {},},
                    "bismarck": {"selector": "site", "title": "Bismarck, ND", "child": {},},
                    "blacksburg": {"selector": "site", "title": "New River Valley", "child": {},},
                    "bloomington": {"selector": "site", "title": "Bloomington, IN", "child": {},},
                    "bn": {"selector": "site", "title": "Bloomington-Normal", "child": {},},
                    "boise": {"selector": "site", "title": "Boise, ID", "child": {},},
                    "boone": {"selector": "site", "title": "Boone, NC", "child": {},},
                    "boston": {
                        "selector": "site",
                        "title": "Boston",
                        "child": {
                            "bmw": {"selector": "area", "title": "Metro West", "child": {},},
                            "gbs": {
                                "selector": "area",
                                "title": "Boston/Cambridge/Brookline",
                                "child": {},
                            },
                            "nos": {"selector": "area", "title": "North Shore", "child": {},},
                            "nwb": {
                                "selector": "area",
                                "title": "Northwest/Merrimack",
                                "child": {},
                            },
                            "sob": {"selector": "area", "title": "South Shore", "child": {},},
                        },
                    },
                    "boulder": {"selector": "site", "title": "Boulder, CO", "child": {},},
                    "bozeman": {"selector": "site", "title": "Bozeman, MT", "child": {},},
                    "brainerd": {"selector": "site", "title": "Brainerd, MN", "child": {},},
                    "brownsville": {"selector": "site", "title": "Brownsville, TX", "child": {},},
                    "brunswick": {"selector": "site", "title": "Brunswick, GA", "child": {},},
                    "buffalo": {"selector": "site", "title": "Buffalo, NY", "child": {},},
                    "butte": {"selector": "site", "title": "Butte, MT", "child": {},},
                    "carbondale": {"selector": "site", "title": "Southern Illinois", "child": {},},
                    "catskills": {"selector": "site", "title": "Catskills", "child": {},},
                    "cedarrapids": {"selector": "site", "title": "Cedar Rapids, IA", "child": {},},
                    "cenla": {"selector": "site", "title": "Central Louisiana", "child": {},},
                    "centralmich": {"selector": "site", "title": "Central Michigan", "child": {},},
                    "cfl": {"selector": "site", "title": "Heartland Florida", "child": {},},
                    "chambana": {"selector": "site", "title": "Champaign Urbana", "child": {},},
                    "chambersburg": {
                        "selector": "site",
                        "title": "Cumberland Valley",
                        "child": {},
                    },
                    "charleston": {"selector": "site", "title": "Charleston, SC", "child": {},},
                    "charlestonwv": {"selector": "site", "title": "Charleston, WV", "child": {},},
                    "charlotte": {"selector": "site", "title": "Charlotte, NC", "child": {},},
                    "charlottesville": {
                        "selector": "site",
                        "title": "Charlottesville, VA",
                        "child": {},
                    },
                    "chattanooga": {"selector": "site", "title": "Chattanooga, TN", "child": {},},
                    "chautauqua": {"selector": "site", "title": "Chautauqua, NY", "child": {},},
                    "chicago": {
                        "selector": "site",
                        "title": "Chicago",
                        "child": {
                            "chc": {"selector": "area", "title": "City of Chicago", "child": {},},
                            "nch": {"selector": "area", "title": "North Chicagoland", "child": {},},
                            "nwc": {"selector": "area", "title": "Northwest Suburbs", "child": {},},
                            "nwi": {"selector": "area", "title": "Northwest Indiana", "child": {},},
                            "sox": {"selector": "area", "title": "South Chicagoland", "child": {},},
                            "wcl": {"selector": "area", "title": "West Chicagoland", "child": {},},
                        },
                    },
                    "chico": {"selector": "site", "title": "Chico, CA", "child": {},},
                    "chillicothe": {"selector": "site", "title": "Chillicothe, OH", "child": {},},
                    "cincinnati": {"selector": "site", "title": "Cincinnati, OH", "child": {},},
                    "clarksville": {"selector": "site", "title": "Clarksville, TN", "child": {},},
                    "cleveland": {"selector": "site", "title": "Cleveland, OH", "child": {},},
                    "clovis": {"selector": "site", "title": "Clovis / Portales", "child": {},},
                    "cnj": {"selector": "site", "title": "Central Nj", "child": {},},
                    "collegestation": {
                        "selector": "site",
                        "title": "College Station, TX",
                        "child": {},
                    },
                    "columbia": {"selector": "site", "title": "Columbia, SC", "child": {},},
                    "columbiamo": {
                        "selector": "site",
                        "title": "Columbia / Jeff City",
                        "child": {},
                    },
                    "columbus": {"selector": "site", "title": "Columbus, OH", "child": {},},
                    "columbusga": {"selector": "site", "title": "Columbus, GA", "child": {},},
                    "cookeville": {"selector": "site", "title": "Cookeville, TN", "child": {},},
                    "corpuschristi": {
                        "selector": "site",
                        "title": "Corpus Christi, TX",
                        "child": {},
                    },
                    "corvallis": {"selector": "site", "title": "Corvallis/Albany", "child": {},},
                    "cosprings": {"selector": "site", "title": "Colorado Springs", "child": {},},
                    "csd": {"selector": "site", "title": "Pierre / Central Sd", "child": {},},
                    "dallas": {
                        "selector": "site",
                        "title": "Dallas / Fort Worth",
                        "child": {
                            "dal": {"selector": "area", "title": "Dallas", "child": {},},
                            "ftw": {"selector": "area", "title": "Fort Worth", "child": {},},
                            "mdf": {"selector": "area", "title": "Mid Cities", "child": {},},
                            "ndf": {"selector": "area", "title": "North Dfw", "child": {},},
                            "sdf": {"selector": "area", "title": "South Dfw", "child": {},},
                        },
                    },
                    "danville": {"selector": "site", "title": "Danville", "child": {},},
                    "dayton": {"selector": "site", "title": "Dayton / Springfield", "child": {},},
                    "daytona": {"selector": "site", "title": "Daytona Beach", "child": {},},
                    "delaware": {"selector": "site", "title": "Delaware", "child": {},},
                    "denver": {"selector": "site", "title": "Denver, CO", "child": {},},
                    "desmoines": {"selector": "site", "title": "Des Moines, IA", "child": {},},
                    "detroit": {
                        "selector": "site",
                        "title": "Detroit Metro",
                        "child": {
                            "mcb": {"selector": "area", "title": "Macomb County", "child": {},},
                            "okl": {"selector": "area", "title": "Oakland County", "child": {},},
                            "wyn": {"selector": "area", "title": "Wayne County", "child": {},},
                        },
                    },
                    "dothan": {"selector": "site", "title": "Dothan, AL", "child": {},},
                    "dubuque": {"selector": "site", "title": "Dubuque", "child": {},},
                    "duluth": {"selector": "site", "title": "Duluth / Superior", "child": {},},
                    "eastco": {"selector": "site", "title": "Eastern Co", "child": {},},
                    "easternshore": {"selector": "site", "title": "Eastern Shore", "child": {},},
                    "eastidaho": {"selector": "site", "title": "East Idaho", "child": {},},
                    "eastky": {"selector": "site", "title": "Eastern Kentucky", "child": {},},
                    "eastnc": {"selector": "site", "title": "Eastern Nc", "child": {},},
                    "eastoregon": {"selector": "site", "title": "East Oregon", "child": {},},
                    "easttexas": {"selector": "site", "title": "Tyler / East Tx", "child": {},},
                    "eauclaire": {"selector": "site", "title": "Eau Claire, WI", "child": {},},
                    "elko": {"selector": "site", "title": "Elko, NV", "child": {},},
                    "elmira": {"selector": "site", "title": "Elmira-Corning", "child": {},},
                    "elpaso": {"selector": "site", "title": "El Paso, TX", "child": {},},
                    "enid": {"selector": "site", "title": "Northwest Ok", "child": {},},
                    "erie": {"selector": "site", "title": "Erie, PA", "child": {},},
                    "eugene": {"selector": "site", "title": "Eugene, OR", "child": {},},
                    "evansville": {"selector": "site", "title": "Evansville, IN", "child": {},},
                    "fairbanks": {"selector": "site", "title": "Fairbanks, AK", "child": {},},
                    "fargo": {"selector": "site", "title": "Fargo / Moorhead", "child": {},},
                    "farmington": {"selector": "site", "title": "Farmington, NM", "child": {},},
                    "fayar": {"selector": "site", "title": "Fayetteville, AR", "child": {},},
                    "fayetteville": {"selector": "site", "title": "Fayetteville, NC", "child": {},},
                    "fingerlakes": {"selector": "site", "title": "Finger Lakes, NY", "child": {},},
                    "flagstaff": {"selector": "site", "title": "Flagstaff / Sedona", "child": {},},
                    "florencesc": {"selector": "site", "title": "Florence, SC", "child": {},},
                    "fortcollins": {
                        "selector": "site",
                        "title": "Fort Collins / North Co",
                        "child": {},
                    },
                    "fortdodge": {"selector": "site", "title": "Fort Dodge, IA", "child": {},},
                    "fortlauderdale": {
                        "selector": "site",
                        "title": "South Florida",
                        "child": {
                            "brw": {"selector": "area", "title": "Broward County", "child": {},},
                            "mdc": {
                                "selector": "area",
                                "title": "Miami / Dade County",
                                "child": {},
                            },
                            "pbc": {"selector": "area", "title": "Palm Beach County", "child": {},},
                        },
                    },
                    "fortmyers": {
                        "selector": "site",
                        "title": "Ft Myers / Sw Florida",
                        "child": {
                            "chl": {"selector": "area", "title": "Charlotte County", "child": {},},
                            "col": {"selector": "area", "title": "Collier County", "child": {},},
                            "lee": {"selector": "area", "title": "Lee County", "child": {},},
                        },
                    },
                    "fortsmith": {"selector": "site", "title": "Fort Smith, AR", "child": {},},
                    "fortwayne": {"selector": "site", "title": "Fort Wayne, IN", "child": {},},
                    "frederick": {"selector": "site", "title": "Frederick, MD", "child": {},},
                    "fredericksburg": {
                        "selector": "site",
                        "title": "Fredericksburg, VA",
                        "child": {},
                    },
                    "fresno": {"selector": "site", "title": "Fresno / Madera", "child": {},},
                    "gadsden": {"selector": "site", "title": "Gadsden-Anniston", "child": {},},
                    "galveston": {"selector": "site", "title": "Galveston, TX", "child": {},},
                    "glensfalls": {"selector": "site", "title": "Glens Falls, NY", "child": {},},
                    "goldcountry": {"selector": "site", "title": "Gold Country", "child": {},},
                    "grandforks": {"selector": "site", "title": "Grand Forks", "child": {},},
                    "grandisland": {"selector": "site", "title": "Grand Island, NE", "child": {},},
                    "grandrapids": {"selector": "site", "title": "Grand Rapids, MI", "child": {},},
                    "greatfalls": {"selector": "site", "title": "Great Falls, MT", "child": {},},
                    "greenbay": {"selector": "site", "title": "Green Bay, WI", "child": {},},
                    "greensboro": {"selector": "site", "title": "Greensboro, NC", "child": {},},
                    "greenville": {
                        "selector": "site",
                        "title": "Greenville / Upstate",
                        "child": {},
                    },
                    "gulfport": {"selector": "site", "title": "Gulfport / Biloxi", "child": {},},
                    "hanford": {"selector": "site", "title": "Hanford-Corcoran", "child": {},},
                    "harrisburg": {"selector": "site", "title": "Harrisburg, PA", "child": {},},
                    "harrisonburg": {"selector": "site", "title": "Harrisonburg, VA", "child": {},},
                    "hartford": {"selector": "site", "title": "Hartford, CT", "child": {},},
                    "hattiesburg": {"selector": "site", "title": "Hattiesburg, MS", "child": {},},
                    "helena": {"selector": "site", "title": "Helena, MT", "child": {},},
                    "hickory": {"selector": "site", "title": "Hickory / Lenoir", "child": {},},
                    "hiltonhead": {"selector": "site", "title": "Hilton Head", "child": {},},
                    "holland": {"selector": "site", "title": "Holland, MI", "child": {},},
                    "honolulu": {"selector": "site", "title": "Hawaii", "child": {},},
                    "houma": {"selector": "site", "title": "Houma, LA", "child": {},},
                    "houston": {"selector": "site", "title": "Houston, TX", "child": {},},
                    "hudsonvalley": {
                        "selector": "site",
                        "title": "Hudson Valley, NY",
                        "child": {},
                    },
                    "humboldt": {"selector": "site", "title": "Humboldt County", "child": {},},
                    "huntington": {"selector": "site", "title": "Huntington-Ashland", "child": {},},
                    "huntsville": {
                        "selector": "site",
                        "title": "Huntsville / Decatur",
                        "child": {},
                    },
                    "imperial": {"selector": "site", "title": "Imperial County", "child": {},},
                    "indianapolis": {"selector": "site", "title": "Indianapolis", "child": {},},
                    "inlandempire": {
                        "selector": "site",
                        "title": "Inland Empire, CA",
                        "child": {},
                    },
                    "iowacity": {"selector": "site", "title": "Iowa City, IA", "child": {},},
                    "ithaca": {"selector": "site", "title": "Ithaca, NY", "child": {},},
                    "jackson": {"selector": "site", "title": "Jackson, MS", "child": {},},
                    "jacksontn": {"selector": "site", "title": "Jackson, TN", "child": {},},
                    "jacksonville": {"selector": "site", "title": "Jacksonville, FL", "child": {},},
                    "janesville": {"selector": "site", "title": "Janesville, WI", "child": {},},
                    "jerseyshore": {"selector": "site", "title": "Jersey Shore", "child": {},},
                    "jonesboro": {"selector": "site", "title": "Jonesboro, AR", "child": {},},
                    "joplin": {"selector": "site", "title": "Joplin, MO", "child": {},},
                    "juneau": {"selector": "site", "title": "Southeast Alaska", "child": {},},
                    "jxn": {"selector": "site", "title": "Jackson, MI", "child": {},},
                    "kalamazoo": {"selector": "site", "title": "Kalamazoo, MI", "child": {},},
                    "kalispell": {"selector": "site", "title": "Kalispell, MT", "child": {},},
                    "kansascity": {"selector": "site", "title": "Kansas City, MO", "child": {},},
                    "kenai": {"selector": "site", "title": "Kenai Peninsula", "child": {},},
                    "keys": {"selector": "site", "title": "Florida Keys", "child": {},},
                    "killeen": {
                        "selector": "site",
                        "title": "Killeen / Temple / Ft Hood",
                        "child": {},
                    },
                    "kirksville": {"selector": "site", "title": "Kirksville, MO", "child": {},},
                    "klamath": {"selector": "site", "title": "Klamath Falls, OR", "child": {},},
                    "knoxville": {"selector": "site", "title": "Knoxville, TN", "child": {},},
                    "kokomo": {"selector": "site", "title": "Kokomo, IN", "child": {},},
                    "kpr": {"selector": "site", "title": "Kennewick-Pasco-Richland", "child": {},},
                    "ksu": {"selector": "site", "title": "Manhattan, KS", "child": {},},
                    "lacrosse": {"selector": "site", "title": "La Crosse, WI", "child": {},},
                    "lafayette": {"selector": "site", "title": "Lafayette, LA", "child": {},},
                    "lakecharles": {"selector": "site", "title": "Lake Charles, LA", "child": {},},
                    "lakecity": {"selector": "site", "title": "North Central Fl", "child": {},},
                    "lakeland": {"selector": "site", "title": "Lakeland, FL", "child": {},},
                    "lancaster": {"selector": "site", "title": "Lancaster, PA", "child": {},},
                    "lansing": {"selector": "site", "title": "Lansing, MI", "child": {},},
                    "laredo": {"selector": "site", "title": "Laredo, TX", "child": {},},
                    "lasalle": {"selector": "site", "title": "La Salle Co", "child": {},},
                    "lascruces": {"selector": "site", "title": "Las Cruces, NM", "child": {},},
                    "lasvegas": {"selector": "site", "title": "Las Vegas", "child": {},},
                    "lawrence": {"selector": "site", "title": "Lawrence, KS", "child": {},},
                    "lawton": {"selector": "site", "title": "Lawton, OK", "child": {},},
                    "lewiston": {"selector": "site", "title": "Lewiston / Clarkston", "child": {},},
                    "lexington": {"selector": "site", "title": "Lexington, KY", "child": {},},
                    "limaohio": {"selector": "site", "title": "Lima / Findlay", "child": {},},
                    "lincoln": {"selector": "site", "title": "Lincoln, NE", "child": {},},
                    "littlerock": {"selector": "site", "title": "Little Rock", "child": {},},
                    "logan": {"selector": "site", "title": "Logan, UT", "child": {},},
                    "longisland": {"selector": "site", "title": "Long Island, NY", "child": {},},
                    "losangeles": {
                        "selector": "site",
                        "title": "Los Angeles",
                        "child": {
                            "ant": {"selector": "area", "title": "Antelope Valley", "child": {},},
                            "lac": {
                                "selector": "area",
                                "title": "Central La 213/323",
                                "child": {},
                            },
                            "lgb": {"selector": "area", "title": "Long Beach / 562", "child": {},},
                            "sfv": {
                                "selector": "area",
                                "title": "San Fernando Valley",
                                "child": {},
                            },
                            "sgv": {
                                "selector": "area",
                                "title": "San Gabriel Valley",
                                "child": {},
                            },
                            "wst": {
                                "selector": "area",
                                "title": "Westside-Southbay-310",
                                "child": {},
                            },
                        },
                    },
                    "louisville": {"selector": "site", "title": "Louisville, KY", "child": {},},
                    "loz": {"selector": "site", "title": "Lake of The Ozarks", "child": {},},
                    "lubbock": {"selector": "site", "title": "Lubbock, TX", "child": {},},
                    "lynchburg": {"selector": "site", "title": "Lynchburg, VA", "child": {},},
                    "macon": {"selector": "site", "title": "Macon / Warner Robins", "child": {},},
                    "madison": {"selector": "site", "title": "Madison, WI", "child": {},},
                    "maine": {"selector": "site", "title": "Maine", "child": {},},
                    "mankato": {"selector": "site", "title": "Mankato, MN", "child": {},},
                    "mansfield": {"selector": "site", "title": "Mansfield, OH", "child": {},},
                    "marshall": {"selector": "site", "title": "Southwest Mn", "child": {},},
                    "martinsburg": {"selector": "site", "title": "Eastern Panhandle", "child": {},},
                    "masoncity": {"selector": "site", "title": "Mason City, IA", "child": {},},
                    "mattoon": {"selector": "site", "title": "Mattoon-Charleston", "child": {},},
                    "mcallen": {"selector": "site", "title": "Mcallen / Edinburg", "child": {},},
                    "meadville": {"selector": "site", "title": "Meadville, PA", "child": {},},
                    "medford": {"selector": "site", "title": "Medford-Ashland", "child": {},},
                    "memphis": {"selector": "site", "title": "Memphis, TN", "child": {},},
                    "merced": {"selector": "site", "title": "Merced, CA", "child": {},},
                    "meridian": {"selector": "site", "title": "Meridian, MS", "child": {},},
                    "miami": {
                        "selector": "site",
                        "title": "South Florida",
                        "child": {
                            "brw": {"selector": "area", "title": "Broward County", "child": {},},
                            "mdc": {
                                "selector": "area",
                                "title": "Miami / Dade County",
                                "child": {},
                            },
                        },
                    },
                    "milwaukee": {"selector": "site", "title": "Milwaukee, WI", "child": {},},
                    "minneapolis": {
                        "selector": "site",
                        "title": "Minneapolis / St Paul",
                        "child": {
                            "ank": {
                                "selector": "area",
                                "title": "Anoka/Chisago/Isanti",
                                "child": {},
                            },
                            "csw": {
                                "selector": "area",
                                "title": "Carver/Sherburne/Wright",
                                "child": {},
                            },
                            "dak": {"selector": "area", "title": "Dakota / Scott", "child": {},},
                            "hnp": {"selector": "area", "title": "Hennepin County", "child": {},},
                            "ram": {"selector": "area", "title": "Ramsey County", "child": {},},
                            "wsh": {
                                "selector": "area",
                                "title": "Washington Co / Wi",
                                "child": {},
                            },
                        },
                    },
                    "missoula": {"selector": "site", "title": "Missoula, MT", "child": {},},
                    "mobile": {"selector": "site", "title": "Mobile, AL", "child": {},},
                    "modesto": {"selector": "site", "title": "Modesto, CA", "child": {},},
                    "mohave": {"selector": "site", "title": "Mohave County", "child": {},},
                    "monroe": {"selector": "site", "title": "Monroe, LA", "child": {},},
                    "monroemi": {"selector": "site", "title": "Monroe, MI", "child": {},},
                    "montana": {"selector": "site", "title": "Eastern Montana", "child": {},},
                    "monterey": {"selector": "site", "title": "Monterey Bay", "child": {},},
                    "montgomery": {"selector": "site", "title": "Montgomery, AL", "child": {},},
                    "morgantown": {"selector": "site", "title": "Morgantown, WV", "child": {},},
                    "moseslake": {"selector": "site", "title": "Moses Lake, WA", "child": {},},
                    "muncie": {"selector": "site", "title": "Muncie / Anderson", "child": {},},
                    "muskegon": {"selector": "site", "title": "Muskegon, MI", "child": {},},
                    "myrtlebeach": {"selector": "site", "title": "Myrtle Beach, SC", "child": {},},
                    "nacogdoches": {"selector": "site", "title": "Deep East Texas", "child": {},},
                    "nashville": {"selector": "site", "title": "Nashville, TN", "child": {},},
                    "natchez": {"selector": "site", "title": "Southwest Ms", "child": {},},
                    "nd": {"selector": "site", "title": "North Dakota", "child": {},},
                    "nesd": {"selector": "site", "title": "Northeast Sd", "child": {},},
                    "newhaven": {"selector": "site", "title": "New Haven, CT", "child": {},},
                    "newjersey": {"selector": "site", "title": "North Jersey", "child": {},},
                    "newlondon": {"selector": "site", "title": "Eastern Ct", "child": {},},
                    "neworleans": {"selector": "site", "title": "New Orleans", "child": {},},
                    "newyork": {
                        "selector": "site",
                        "title": "New York City",
                        "child": {
                            "brk": {"selector": "area", "title": "Brooklyn", "child": {},},
                            "brx": {"selector": "area", "title": "Bronx", "child": {},},
                            "fct": {"selector": "area", "title": "Fairfield Co, CT", "child": {},},
                            "jsy": {"selector": "area", "title": "New Jersey", "child": {},},
                            "lgi": {"selector": "area", "title": "Long Island", "child": {},},
                            "mnh": {"selector": "area", "title": "Manhattan", "child": {},},
                            "que": {"selector": "area", "title": "Queens", "child": {},},
                            "stn": {"selector": "area", "title": "Staten Island", "child": {},},
                            "wch": {"selector": "area", "title": "Westchester", "child": {},},
                        },
                    },
                    "nh": {"selector": "site", "title": "New Hampshire", "child": {},},
                    "nmi": {"selector": "site", "title": "Northern Michigan", "child": {},},
                    "norfolk": {
                        "selector": "site",
                        "title": "Norfolk / Hampton Roads",
                        "child": {},
                    },
                    "northernwi": {"selector": "site", "title": "Northern Wi", "child": {},},
                    "northmiss": {"selector": "site", "title": "North Mississippi", "child": {},},
                    "northplatte": {"selector": "site", "title": "North Platte, NE", "child": {},},
                    "nwct": {"selector": "site", "title": "Northwest Ct", "child": {},},
                    "nwga": {"selector": "site", "title": "Northwest Ga", "child": {},},
                    "nwks": {"selector": "site", "title": "Northwest Ks", "child": {},},
                    "odessa": {"selector": "site", "title": "Odessa / Midland", "child": {},},
                    "ogden": {"selector": "site", "title": "Ogden-Clearfield", "child": {},},
                    "okaloosa": {"selector": "site", "title": "Okaloosa / Walton", "child": {},},
                    "oklahomacity": {"selector": "site", "title": "Oklahoma City", "child": {},},
                    "olympic": {"selector": "site", "title": "Olympic Peninsula", "child": {},},
                    "omaha": {"selector": "site", "title": "Omaha / Council Bluffs", "child": {},},
                    "onslow": {"selector": "site", "title": "Jacksonville, NC", "child": {},},
                    "orangecounty": {
                        "selector": "site",
                        "title": "Orange County, CA",
                        "child": {},
                    },
                    "oregoncoast": {"selector": "site", "title": "Oregon Coast", "child": {},},
                    "orlando": {"selector": "site", "title": "Orlando, FL", "child": {},},
                    "ottumwa": {"selector": "site", "title": "Southeast Ia", "child": {},},
                    "outerbanks": {"selector": "site", "title": "Outer Banks", "child": {},},
                    "owensboro": {"selector": "site", "title": "Owensboro, KY", "child": {},},
                    "palmsprings": {"selector": "site", "title": "Palm Springs, CA", "child": {},},
                    "panamacity": {"selector": "site", "title": "Panama City, FL", "child": {},},
                    "parkersburg": {
                        "selector": "site",
                        "title": "Parkersburg-Marietta",
                        "child": {},
                    },
                    "pennstate": {"selector": "site", "title": "State College, PA", "child": {},},
                    "pensacola": {"selector": "site", "title": "Pensacola, FL", "child": {},},
                    "peoria": {"selector": "site", "title": "Peoria, IL", "child": {},},
                    "philadelphia": {"selector": "site", "title": "Philadelphia", "child": {},},
                    "phoenix": {
                        "selector": "site",
                        "title": "Phoenix, AZ",
                        "child": {
                            "cph": {"selector": "area", "title": "Central/South Phx", "child": {},},
                            "evl": {"selector": "area", "title": "East Valley", "child": {},},
                            "nph": {"selector": "area", "title": "Phx North", "child": {},},
                            "wvl": {"selector": "area", "title": "West Valley", "child": {},},
                        },
                    },
                    "pittsburgh": {"selector": "site", "title": "Pittsburgh, PA", "child": {},},
                    "plattsburgh": {
                        "selector": "site",
                        "title": "Plattsburgh-Adirondacks",
                        "child": {},
                    },
                    "poconos": {"selector": "site", "title": "Poconos", "child": {},},
                    "porthuron": {"selector": "site", "title": "Port Huron, MI", "child": {},},
                    "portland": {
                        "selector": "site",
                        "title": "Portland, OR",
                        "child": {
                            "clc": {"selector": "area", "title": "Clackamas County", "child": {},},
                            "clk": {"selector": "area", "title": "Clark/Cowlitz, WA", "child": {},},
                            "grg": {"selector": "area", "title": "Columbia Gorge", "child": {},},
                            "mlt": {"selector": "area", "title": "Multnomah County", "child": {},},
                            "nco": {"selector": "area", "title": "North Coast", "child": {},},
                            "wsc": {"selector": "area", "title": "Washington County", "child": {},},
                            "yam": {"selector": "area", "title": "Yamhill Co", "child": {},},
                        },
                    },
                    "potsdam": {
                        "selector": "site",
                        "title": "Potsdam-Canton-Massena",
                        "child": {},
                    },
                    "providence": {"selector": "site", "title": "Rhode Island", "child": {},},
                    "provo": {"selector": "site", "title": "Provo / Orem", "child": {},},
                    "pueblo": {"selector": "site", "title": "Pueblo, CO", "child": {},},
                    "pullman": {"selector": "site", "title": "Pullman / Moscow", "child": {},},
                    "quadcities": {"selector": "site", "title": "Quad Cities, Ia/Il", "child": {},},
                    "quincy": {"selector": "site", "title": "Western Il", "child": {},},
                    "racine": {"selector": "site", "title": "Kenosha-Racine", "child": {},},
                    "raleigh": {"selector": "site", "title": "Raleigh / Durham / Ch", "child": {},},
                    "rapidcity": {
                        "selector": "site",
                        "title": "Rapid City / West Sd",
                        "child": {},
                    },
                    "reading": {"selector": "site", "title": "Reading, PA", "child": {},},
                    "redding": {"selector": "site", "title": "Redding, CA", "child": {},},
                    "reno": {"selector": "site", "title": "Reno / Tahoe", "child": {},},
                    "richmond": {"selector": "site", "title": "Richmond, VA", "child": {},},
                    "richmondin": {"selector": "site", "title": "Richmond, IN", "child": {},},
                    "roanoke": {"selector": "site", "title": "Roanoke, VA", "child": {},},
                    "rochester": {"selector": "site", "title": "Rochester, NY", "child": {},},
                    "rockford": {"selector": "site", "title": "Rockford, IL", "child": {},},
                    "rockies": {"selector": "site", "title": "High Rockies", "child": {},},
                    "roswell": {"selector": "site", "title": "Roswell / Carlsbad", "child": {},},
                    "sacramento": {"selector": "site", "title": "Sacramento", "child": {},},
                    "saginaw": {
                        "selector": "site",
                        "title": "Saginaw-Midland-Baycity",
                        "child": {},
                    },
                    "salem": {"selector": "site", "title": "Salem, OR", "child": {},},
                    "salina": {"selector": "site", "title": "Salina, KS", "child": {},},
                    "saltlakecity": {"selector": "site", "title": "Salt Lake City", "child": {},},
                    "sanangelo": {"selector": "site", "title": "San Angelo, TX", "child": {},},
                    "sanantonio": {"selector": "site", "title": "San Antonio", "child": {},},
                    "sandiego": {
                        "selector": "site",
                        "title": "San Diego",
                        "child": {
                            "csd": {"selector": "area", "title": "City of San Diego", "child": {},},
                            "esd": {
                                "selector": "area",
                                "title": "East San Diego County",
                                "child": {},
                            },
                            "nsd": {
                                "selector": "area",
                                "title": "North San Diego County",
                                "child": {},
                            },
                            "ssd": {
                                "selector": "area",
                                "title": "South San Diego County",
                                "child": {},
                            },
                        },
                    },
                    "sandusky": {"selector": "site", "title": "Sandusky, OH", "child": {},},
                    "sanmarcos": {"selector": "site", "title": "San Marcos, TX", "child": {},},
                    "santafe": {"selector": "site", "title": "Santa Fe / Taos", "child": {},},
                    "santamaria": {"selector": "site", "title": "Santa Maria, CA", "child": {},},
                    "sarasota": {"selector": "site", "title": "Sarasota-Bradenton", "child": {},},
                    "savannah": {
                        "selector": "site",
                        "title": "Savannah / Hinesville",
                        "child": {},
                    },
                    "scottsbluff": {
                        "selector": "site",
                        "title": "Scottsbluff / Panhandle",
                        "child": {},
                    },
                    "scranton": {
                        "selector": "site",
                        "title": "Scranton / Wilkes-Barre",
                        "child": {},
                    },
                    "sd": {"selector": "site", "title": "South Dakota", "child": {},},
                    "seattle": {
                        "selector": "site",
                        "title": "Seattle-Tacoma",
                        "child": {
                            "est": {"selector": "area", "title": "Eastside", "child": {},},
                            "kit": {
                                "selector": "area",
                                "title": "Kitsap / West Puget",
                                "child": {},
                            },
                            "oly": {
                                "selector": "area",
                                "title": "Olympia / Thurston",
                                "child": {},
                            },
                            "see": {"selector": "area", "title": "Seattle", "child": {},},
                            "skc": {"selector": "area", "title": "South King Co", "child": {},},
                            "sno": {"selector": "area", "title": "Snohomish County", "child": {},},
                            "tac": {"selector": "area", "title": "Tacoma / Pierce", "child": {},},
                        },
                    },
                    "seks": {"selector": "site", "title": "Southeast Ks", "child": {},},
                    "semo": {"selector": "site", "title": "Southeast Missouri", "child": {},},
                    "sfbay": {
                        "selector": "site",
                        "title": "Sf Bay Area",
                        "child": {
                            "eby": {"selector": "area", "title": "East Bay Area", "child": {},},
                            "nby": {"selector": "area", "title": "North Bay / Marin", "child": {},},
                            "pen": {"selector": "area", "title": "Peninsula", "child": {},},
                            "sby": {"selector": "area", "title": "South Bay Area", "child": {},},
                            "scz": {"selector": "area", "title": "Santa Cruz Co", "child": {},},
                            "sfc": {
                                "selector": "area",
                                "title": "City of San Francisco",
                                "child": {},
                            },
                        },
                    },
                    "sheboygan": {"selector": "site", "title": "Sheboygan, WI", "child": {},},
                    "shoals": {
                        "selector": "site",
                        "title": "Florence / Muscle Shoals",
                        "child": {},
                    },
                    "showlow": {"selector": "site", "title": "Show Low, AZ", "child": {},},
                    "shreveport": {"selector": "site", "title": "Shreveport, LA", "child": {},},
                    "sierravista": {"selector": "site", "title": "Sierra Vista, AZ", "child": {},},
                    "siouxcity": {"selector": "site", "title": "Sioux City, IA", "child": {},},
                    "siouxfalls": {
                        "selector": "site",
                        "title": "Sioux Falls / Se Sd",
                        "child": {},
                    },
                    "slo": {"selector": "site", "title": "San Luis Obispo", "child": {},},
                    "smd": {"selector": "site", "title": "Southern Maryland", "child": {},},
                    "southbend": {
                        "selector": "site",
                        "title": "South Bend / Michiana",
                        "child": {},
                    },
                    "southcoast": {"selector": "site", "title": "South Coast, MA", "child": {},},
                    "southjersey": {"selector": "site", "title": "South Jersey", "child": {},},
                    "spacecoast": {"selector": "site", "title": "Space Coast, FL", "child": {},},
                    "spokane": {
                        "selector": "site",
                        "title": "Spokane / Coeur D'Alene",
                        "child": {},
                    },
                    "springfield": {"selector": "site", "title": "Springfield, MO", "child": {},},
                    "springfieldil": {"selector": "site", "title": "Springfield, IL", "child": {},},
                    "statesboro": {"selector": "site", "title": "Statesboro, GA", "child": {},},
                    "staugustine": {"selector": "site", "title": "St Augustine, FL", "child": {},},
                    "stcloud": {"selector": "site", "title": "St Cloud, MN", "child": {},},
                    "stgeorge": {"selector": "site", "title": "St George, UT", "child": {},},
                    "stillwater": {"selector": "site", "title": "Stillwater, OK", "child": {},},
                    "stjoseph": {"selector": "site", "title": "St Joseph", "child": {},},
                    "stlouis": {"selector": "site", "title": "St Louis, MO", "child": {},},
                    "stockton": {"selector": "site", "title": "Stockton, CA", "child": {},},
                    "susanville": {"selector": "site", "title": "Susanville, CA", "child": {},},
                    "swks": {"selector": "site", "title": "Southwest Ks", "child": {},},
                    "swmi": {"selector": "site", "title": "Southwest Michigan", "child": {},},
                    "swv": {"selector": "site", "title": "Southern Wv", "child": {},},
                    "swva": {"selector": "site", "title": "Southwest Va", "child": {},},
                    "syracuse": {"selector": "site", "title": "Syracuse, NY", "child": {},},
                    "tallahassee": {"selector": "site", "title": "Tallahassee", "child": {},},
                    "tampa": {
                        "selector": "site",
                        "title": "Tampa Bay Area",
                        "child": {
                            "hdo": {"selector": "area", "title": "Hernando Co", "child": {},},
                            "hil": {"selector": "area", "title": "Hillsborough Co", "child": {},},
                            "pnl": {"selector": "area", "title": "Pinellas Co", "child": {},},
                            "psc": {"selector": "area", "title": "Pasco Co", "child": {},},
                        },
                    },
                    "terrehaute": {"selector": "site", "title": "Terre Haute, IN", "child": {},},
                    "texarkana": {"selector": "site", "title": "Texarkana", "child": {},},
                    "texoma": {"selector": "site", "title": "Texoma", "child": {},},
                    "thumb": {"selector": "site", "title": "The Thumb, MI", "child": {},},
                    "tippecanoe": {
                        "selector": "site",
                        "title": "Lafayette / West Lafayette",
                        "child": {},
                    },
                    "toledo": {"selector": "site", "title": "Toledo, OH", "child": {},},
                    "topeka": {"selector": "site", "title": "Topeka, KS", "child": {},},
                    "tricities": {"selector": "site", "title": "Tri-Cities, TN", "child": {},},
                    "tucson": {"selector": "site", "title": "Tucson, AZ", "child": {},},
                    "tulsa": {"selector": "site", "title": "Tulsa, OK", "child": {},},
                    "tuscaloosa": {"selector": "site", "title": "Tuscaloosa", "child": {},},
                    "tuscarawas": {"selector": "site", "title": "Tuscarawas Co", "child": {},},
                    "twinfalls": {"selector": "site", "title": "Twin Falls, ID", "child": {},},
                    "twintiers": {"selector": "site", "title": "Twin Tiers Ny/Pa", "child": {},},
                    "up": {"selector": "site", "title": "Upper Peninsula, MI", "child": {},},
                    "utica": {"selector": "site", "title": "Utica-Rome-Oneida", "child": {},},
                    "valdosta": {"selector": "site", "title": "Valdosta, GA", "child": {},},
                    "ventura": {"selector": "site", "title": "Ventura County", "child": {},},
                    "vermont": {"selector": "site", "title": "Vermont", "child": {},},
                    "victoriatx": {"selector": "site", "title": "Victoria, TX", "child": {},},
                    "visalia": {"selector": "site", "title": "Visalia-Tulare", "child": {},},
                    "waco": {"selector": "site", "title": "Waco, TX", "child": {},},
                    "washingtondc": {"selector": "site", "title": "Washington, DC", "child": {},},
                    "waterloo": {
                        "selector": "site",
                        "title": "Waterloo / Cedar Falls",
                        "child": {},
                    },
                    "watertown": {"selector": "site", "title": "Watertown, NY", "child": {},},
                    "wausau": {"selector": "site", "title": "Wausau, WI", "child": {},},
                    "wenatchee": {"selector": "site", "title": "Wenatchee, WA", "child": {},},
                    "westernmass": {
                        "selector": "site",
                        "title": "Western Massachusetts",
                        "child": {},
                    },
                    "westky": {"selector": "site", "title": "Western Ky", "child": {},},
                    "westmd": {"selector": "site", "title": "Western Maryland", "child": {},},
                    "westslope": {"selector": "site", "title": "Western Slope", "child": {},},
                    "wheeling": {"selector": "site", "title": "Northern Panhandle", "child": {},},
                    "wichita": {"selector": "site", "title": "Wichita, KS", "child": {},},
                    "wichitafalls": {
                        "selector": "site",
                        "title": "Wichita Falls, TX",
                        "child": {},
                    },
                    "williamsport": {"selector": "site", "title": "Williamsport, PA", "child": {},},
                    "wilmington": {"selector": "site", "title": "Wilmington, NC", "child": {},},
                    "winchester": {"selector": "site", "title": "Winchester, VA", "child": {},},
                    "winstonsalem": {
                        "selector": "site",
                        "title": "Winston-Salem, NC",
                        "child": {},
                    },
                    "worcester": {
                        "selector": "site",
                        "title": "Worcester / Central Ma",
                        "child": {},
                    },
                    "wv": {"selector": "site", "title": "West Virginia (Old)", "child": {},},
                    "wyoming": {"selector": "site", "title": "Wyoming", "child": {},},
                    "yakima": {"selector": "site", "title": "Yakima, WA", "child": {},},
                    "york": {"selector": "site", "title": "York, PA", "child": {},},
                    "youngstown": {"selector": "site", "title": "Youngstown, OH", "child": {},},
                    "yubasutter": {"selector": "site", "title": "Yuba-Sutter, CA", "child": {},},
                    "yuma": {"selector": "site", "title": "Yuma, AZ", "child": {},},
                    "zanesville": {
                        "selector": "site",
                        "title": "Zanesville / Cambridge",
                        "child": {},
                    },
                },
            },
            "uruguay": {
                "selector": "country",
                "title": "Uruguay",
                "child": {"montevideo": {"selector": "site", "title": "Montevideo", "child": {},}},
            },
            "virgin": {
                "selector": "country",
                "title": "Virgin Islands",
                "child": {"virgin": {"selector": "site", "title": "Virgin Islands", "child": {},}},
            },
            "venezuela": {
                "selector": "country",
                "title": "Venezuela",
                "child": {"caracas": {"selector": "site", "title": "Venezuela", "child": {},}},
            },
        },
    },
    "asia": {
        "selector": "region",
        "title": "Asia",
        "child": {
            "bangladesh": {
                "selector": "country",
                "title": "Bangladesh",
                "child": {"bangladesh": {"selector": "site", "title": "Bangladesh", "child": {},}},
            },
            "china": {
                "selector": "country",
                "title": "China",
                "child": {
                    "beijing": {"selector": "site", "title": "\u5317\u4eac", "child": {},},
                    "chengdu": {"selector": "site", "title": "\u6210\u90fd", "child": {},},
                    "chongqing": {"selector": "site", "title": "\u91cd\u5e86", "child": {},},
                    "dalian": {"selector": "site", "title": "\u5927\u8fde", "child": {},},
                    "guangzhou": {"selector": "site", "title": "\u5e7f\u5dde", "child": {},},
                    "hangzhou": {"selector": "site", "title": "\u676d\u5dde", "child": {},},
                    "nanjing": {"selector": "site", "title": "\u5357\u4eac", "child": {},},
                    "shanghai": {"selector": "site", "title": "\u4e0a\u6d77", "child": {},},
                    "shenyang": {"selector": "site", "title": "\u6c88\u9633", "child": {},},
                    "shenzhen": {"selector": "site", "title": "\u6df1\u5733", "child": {},},
                    "wuhan": {"selector": "site", "title": "\u6b66\u6c49", "child": {},},
                    "xian": {"selector": "site", "title": "\u897f\u5b89", "child": {},},
                },
            },
            "hong_kong": {
                "selector": "country",
                "title": "Hong Kong",
                "child": {"hongkong": {"selector": "site", "title": "Hong Kong", "child": {},}},
            },
            "india": {
                "selector": "country",
                "title": "India",
                "child": {
                    "ahmedabad": {"selector": "site", "title": "Ahmedabad", "child": {},},
                    "bangalore": {"selector": "site", "title": "Bangalore", "child": {},},
                    "bhubaneswar": {"selector": "site", "title": "Bhubaneswar", "child": {},},
                    "chandigarh": {"selector": "site", "title": "Chandigarh", "child": {},},
                    "chennai": {"selector": "site", "title": "Chennai (Madras)", "child": {},},
                    "delhi": {"selector": "site", "title": "Delhi", "child": {},},
                    "goa": {"selector": "site", "title": "Goa", "child": {},},
                    "hyderabad": {"selector": "site", "title": "Hyderabad", "child": {},},
                    "indore": {"selector": "site", "title": "Indore", "child": {},},
                    "jaipur": {"selector": "site", "title": "Jaipur", "child": {},},
                    "kerala": {"selector": "site", "title": "Kerala", "child": {},},
                    "kolkata": {"selector": "site", "title": "Kolkata (Calcutta)", "child": {},},
                    "lucknow": {"selector": "site", "title": "Lucknow", "child": {},},
                    "mumbai": {"selector": "site", "title": "Mumbai", "child": {},},
                    "pune": {"selector": "site", "title": "Pune", "child": {},},
                    "surat": {"selector": "site", "title": "Surat Surat", "child": {},},
                },
            },
            "indonesia": {
                "selector": "country",
                "title": "Indonesia",
                "child": {"jakarta": {"selector": "site", "title": "Indonesia", "child": {},}},
            },
            "iran": {
                "selector": "country",
                "title": "Iran",
                "child": {"tehran": {"selector": "site", "title": "Iran", "child": {},}},
            },
            "iraq": {
                "selector": "country",
                "title": "Iraq",
                "child": {"baghdad": {"selector": "site", "title": "Iraq", "child": {},}},
            },
            "israel_and_palestine": {
                "selector": "country",
                "title": "Israel and Palestine",
                "child": {
                    "haifa": {"selector": "site", "title": "Haifa", "child": {},},
                    "jerusalem": {"selector": "site", "title": "Jerusalem", "child": {},},
                    "ramallah": {"selector": "site", "title": "West Bank", "child": {},},
                    "telaviv": {"selector": "site", "title": "Tel Aviv", "child": {},},
                },
            },
            "japan": {
                "selector": "country",
                "title": "Japan",
                "child": {
                    "fukuoka": {"selector": "site", "title": "\u798f\u5ca1", "child": {},},
                    "hiroshima": {"selector": "site", "title": "\u5e83\u5cf6", "child": {},},
                    "nagoya": {"selector": "site", "title": "\u540d\u53e4\u5c4b", "child": {},},
                    "okinawa": {"selector": "site", "title": "\u6c96\u7e04", "child": {},},
                    "osaka": {
                        "selector": "site",
                        "title": "\u5927\u962a\u30fb\u795e\u6238\u30fb\u4eac\u90fd",
                        "child": {},
                    },
                    "sapporo": {"selector": "site", "title": "\u672d\u5e4c", "child": {},},
                    "sendai": {"selector": "site", "title": "\u4ed9\u53f0", "child": {},},
                    "tokyo": {"selector": "site", "title": "\u6771\u4eac", "child": {},},
                },
            },
            "kuwait": {
                "selector": "country",
                "title": "Kuwait",
                "child": {"kuwait": {"selector": "site", "title": "Kuwait", "child": {},}},
            },
            "lebanon": {
                "selector": "country",
                "title": "Lebanon",
                "child": {"beirut": {"selector": "site", "title": "Beirut, Lebanon", "child": {},}},
            },
            "malaysia": {
                "selector": "country",
                "title": "Malaysia",
                "child": {"malaysia": {"selector": "site", "title": "Malaysia", "child": {},}},
            },
            "pakistan": {
                "selector": "country",
                "title": "Pakistan",
                "child": {"pakistan": {"selector": "site", "title": "Pakistan", "child": {},}},
            },
            "philippines": {
                "selector": "country",
                "title": "Philippines",
                "child": {
                    "bacolod": {"selector": "site", "title": "Bacolod", "child": {},},
                    "cdo": {"selector": "site", "title": "Cagayan De Oro", "child": {},},
                    "cebu": {"selector": "site", "title": "Cebu", "child": {},},
                    "davaocity": {"selector": "site", "title": "Davao City", "child": {},},
                    "iloilo": {"selector": "site", "title": "Iloilo", "child": {},},
                    "manila": {"selector": "site", "title": "Manila", "child": {},},
                    "naga": {"selector": "site", "title": "Bicol Region", "child": {},},
                    "pampanga": {"selector": "site", "title": "Pampanga", "child": {},},
                    "zamboanga": {"selector": "site", "title": "Zamboanga", "child": {},},
                },
            },
            "russia": {
                "selector": "country",
                "title": "Russia",
                "child": {
                    "moscow": {
                        "selector": "site",
                        "title": "\u041c\u043e\u0441\u043a\u0432\u0430",
                        "child": {},
                    },
                    "stpetersburg": {
                        "selector": "site",
                        "title": "\u0421. \u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433, Ru",
                        "child": {},
                    },
                },
            },
            "singapore": {
                "selector": "country",
                "title": "Singapore",
                "child": {"singapore": {"selector": "site", "title": "Singapore", "child": {},}},
            },
            "korea": {
                "selector": "country",
                "title": "Korea",
                "child": {"seoul": {"selector": "site", "title": "Seoul", "child": {},}},
            },
            "taiwan": {
                "selector": "country",
                "title": "Taiwan",
                "child": {"taipei": {"selector": "site", "title": "Taiwan", "child": {},}},
            },
            "thailand": {
                "selector": "country",
                "title": "Thailand",
                "child": {"bangkok": {"selector": "site", "title": "Thailand", "child": {},}},
            },
            "turkey": {
                "selector": "country",
                "title": "Turkey",
                "child": {"istanbul": {"selector": "site", "title": "T\u00fcrkiye", "child": {},}},
            },
            "united_arab_emirates": {
                "selector": "country",
                "title": "United Arab Emirates",
                "child": {
                    "dubai": {"selector": "site", "title": "United Arab Emirates", "child": {},}
                },
            },
            "vietnam": {
                "selector": "country",
                "title": "Vietnam",
                "child": {"vietnam": {"selector": "site", "title": "Vietnam", "child": {},}},
            },
            "ramallah": {
                "selector": "country",
                "title": "West Bank",
                "child": {"ramallah": {"selector": "site", "title": "West Bank", "child": {},}},
            },
        },
    },
    "europe": {
        "selector": "region",
        "title": "Europe",
        "child": {
            "austria": {
                "selector": "country",
                "title": "Austria",
                "child": {"vienna": {"selector": "site", "title": "Wien", "child": {},}},
            },
            "belgium": {
                "selector": "country",
                "title": "Blegium",
                "child": {"brussels": {"selector": "site", "title": "Belgium", "child": {},}},
            },
            "bulgaria": {
                "selector": "country",
                "title": "Bulgaria",
                "child": {"bulgaria": {"selector": "site", "title": "Bulgaria", "child": {},}},
            },
            "croatia": {
                "selector": "country",
                "title": "Croatia",
                "child": {"zagreb": {"selector": "site", "title": "Croatia", "child": {},}},
            },
            "czech_republic": {
                "selector": "country",
                "title": "Czech Republic",
                "child": {"prague": {"selector": "site", "title": "Prague", "child": {},}},
            },
            "denmark": {
                "selector": "country",
                "title": "Denmark",
                "child": {
                    "copenhagen": {"selector": "site", "title": "K\u00f8benhavn", "child": {},}
                },
            },
            "finland": {
                "selector": "country",
                "title": "Finland",
                "child": {
                    "helsinki": {
                        "selector": "site",
                        "title": "Suomi Ty\u00f6paikkoja,",
                        "child": {},
                    }
                },
            },
            "france": {
                "selector": "country",
                "title": "France",
                "child": {
                    "bordeaux": {"selector": "site", "title": "Bordeaux", "child": {},},
                    "cotedazur": {
                        "selector": "site",
                        "title": "Nice / C\u00f4te D'Azur",
                        "child": {},
                    },
                    "grenoble": {"selector": "site", "title": "Grenoble", "child": {},},
                    "lille": {"selector": "site", "title": "Lille", "child": {},},
                    "loire": {"selector": "site", "title": "Loire (Vall\u00e9e)", "child": {},},
                    "lyon": {"selector": "site", "title": "Lyon", "child": {},},
                    "marseilles": {"selector": "site", "title": "Marseille", "child": {},},
                    "montpellier": {"selector": "site", "title": "Montpellier", "child": {},},
                    "paris": {"selector": "site", "title": "Paris, FR", "child": {},},
                    "rennes": {"selector": "site", "title": "Bretagne", "child": {},},
                    "rouen": {"selector": "site", "title": "Normandie", "child": {},},
                    "strasbourg": {"selector": "site", "title": "Strasbourg", "child": {},},
                    "toulouse": {"selector": "site", "title": "Toulouse", "child": {},},
                },
            },
            "germany": {
                "selector": "country",
                "title": "Germany",
                "child": {
                    "berlin": {"selector": "site", "title": "Berlin", "child": {},},
                    "bremen": {"selector": "site", "title": "Bremen", "child": {},},
                    "cologne": {"selector": "site", "title": "K\u00f6ln", "child": {},},
                    "dresden": {"selector": "site", "title": "Dresden", "child": {},},
                    "dusseldorf": {"selector": "site", "title": "D\u00fcsseldorf", "child": {},},
                    "essen": {"selector": "site", "title": "Essen / Ruhr", "child": {},},
                    "frankfurt": {"selector": "site", "title": "Frankfurt", "child": {},},
                    "hamburg": {"selector": "site", "title": "Hamburg", "child": {},},
                    "hannover": {"selector": "site", "title": "Hannover", "child": {},},
                    "heidelberg": {"selector": "site", "title": "Heidelberg", "child": {},},
                    "kaiserslautern": {"selector": "site", "title": "Kaiserslautern", "child": {},},
                    "leipzig": {"selector": "site", "title": "Leipzig", "child": {},},
                    "munich": {"selector": "site", "title": "M\u00fcnchen", "child": {},},
                    "nuremberg": {"selector": "site", "title": "N\u00fcrnberg", "child": {},},
                    "stuttgart": {"selector": "site", "title": "Stuttgart", "child": {},},
                },
            },
            "greece": {
                "selector": "country",
                "title": "Greece",
                "child": {"athens": {"selector": "site", "title": "Greece", "child": {},}},
            },
            "hungary": {
                "selector": "country",
                "title": "Hungary",
                "child": {"budapest": {"selector": "site", "title": "Budapest", "child": {},}},
            },
            "iceland": {
                "selector": "country",
                "title": "Iceland",
                "child": {"reykjavik": {"selector": "site", "title": "Reykjavik", "child": {},}},
            },
            "ireland": {
                "selector": "country",
                "title": "Ireland",
                "child": {"dublin": {"selector": "site", "title": "Dublin, IE", "child": {},}},
            },
            "italy": {
                "selector": "country",
                "title": "Italy",
                "child": {
                    "bologna": {"selector": "site", "title": "Bologna", "child": {},},
                    "florence": {"selector": "site", "title": "Firenze / Toscana", "child": {},},
                    "genoa": {"selector": "site", "title": "Genova", "child": {},},
                    "milan": {"selector": "site", "title": "Milano", "child": {},},
                    "naples": {"selector": "site", "title": "Napoli / Campania", "child": {},},
                    "perugia": {"selector": "site", "title": "Perugia", "child": {},},
                    "rome": {"selector": "site", "title": "Roma", "child": {},},
                    "sardinia": {"selector": "site", "title": "Sardegna", "child": {},},
                    "sicily": {"selector": "site", "title": "Sicilia", "child": {},},
                    "torino": {"selector": "site", "title": "Torino", "child": {},},
                    "venice": {"selector": "site", "title": "Venezia / Veneto", "child": {},},
                },
            },
            "luxembourg": {
                "selector": "country",
                "title": "Luxembourg",
                "child": {"luxembourg": {"selector": "site", "title": "Luxembourg", "child": {},}},
            },
            "netherlands": {
                "selector": "country",
                "title": "Netherlands",
                "child": {
                    "amsterdam": {"selector": "site", "title": "Amsterdam / Randstad", "child": {},}
                },
            },
            "norway": {
                "selector": "country",
                "title": "Norway",
                "child": {"oslo": {"selector": "site", "title": "Norway", "child": {},}},
            },
            "poland": {
                "selector": "country",
                "title": "Poland",
                "child": {"warsaw": {"selector": "site", "title": "Poland", "child": {},}},
            },
            "portugal": {
                "selector": "country",
                "title": "Portugal",
                "child": {
                    "faro": {"selector": "site", "title": "Faro / Algarve", "child": {},},
                    "lisbon": {"selector": "site", "title": "Lisboa", "child": {},},
                    "porto": {"selector": "site", "title": "Porto", "child": {},},
                },
            },
            "romania": {
                "selector": "country",
                "title": "Romania",
                "child": {"bucharest": {"selector": "site", "title": "Romania", "child": {},}},
            },
            "russia": {
                "selector": "country",
                "title": "Russia",
                "child": {
                    "moscow": {
                        "selector": "site",
                        "title": "\u041c\u043e\u0441\u043a\u0432\u0430",
                        "child": {},
                    },
                    "stpetersburg": {
                        "selector": "site",
                        "title": "\u0421. \u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433, Ru",
                        "child": {},
                    },
                },
            },
            "spain": {
                "selector": "country",
                "title": "Spain",
                "child": {
                    "alicante": {"selector": "site", "title": "Alicante", "child": {},},
                    "baleares": {"selector": "site", "title": "Baleares", "child": {},},
                    "barcelona": {"selector": "site", "title": "Barcelona", "child": {},},
                    "bilbao": {"selector": "site", "title": "Bilbao", "child": {},},
                    "cadiz": {"selector": "site", "title": "C\u00e1diz", "child": {},},
                    "canarias": {"selector": "site", "title": "Canarias", "child": {},},
                    "granada": {"selector": "site", "title": "Granada", "child": {},},
                    "madrid": {"selector": "site", "title": "Madrid", "child": {},},
                    "malaga": {"selector": "site", "title": "M\u00e1laga", "child": {},},
                    "sevilla": {"selector": "site", "title": "Sevilla", "child": {},},
                    "valencia": {"selector": "site", "title": "Valencia", "child": {},},
                },
            },
            "sweden": {
                "selector": "country",
                "title": "Sweden",
                "child": {"stockholm": {"selector": "site", "title": "Sverige", "child": {},}},
            },
            "switzerland": {
                "selector": "country",
                "title": "Switzerland",
                "child": {
                    "basel": {"selector": "site", "title": "Basel", "child": {},},
                    "bern": {"selector": "site", "title": "Bern", "child": {},},
                    "geneva": {"selector": "site", "title": "Gen\u00e8ve", "child": {},},
                    "lausanne": {"selector": "site", "title": "Lausanne", "child": {},},
                    "zurich": {"selector": "site", "title": "Z\u00fcrich", "child": {},},
                },
            },
            "turkey": {
                "selector": "country",
                "title": "Turkey",
                "child": {"istanbul": {"selector": "site", "title": "T\u00fcrkiye", "child": {},}},
            },
            "ukraine": {
                "selector": "country",
                "title": "Ukraine",
                "child": {"ukraine": {"selector": "site", "title": "Ukraine", "child": {},}},
            },
            "united_kingdom": {
                "selector": "country",
                "title": "United Kingdom",
                "child": {
                    "aberdeen": {"selector": "site", "title": "Aberdeen", "child": {},},
                    "bath": {"selector": "site", "title": "Bath, UK", "child": {},},
                    "belfast": {"selector": "site", "title": "Belfast", "child": {},},
                    "birmingham": {
                        "selector": "site",
                        "title": "Birmingham / West Mids",
                        "child": {},
                    },
                    "brighton": {"selector": "site", "title": "Brighton", "child": {},},
                    "bristol": {"selector": "site", "title": "Bristol", "child": {},},
                    "cambridge": {"selector": "site", "title": "Cambridge, UK", "child": {},},
                    "cardiff": {"selector": "site", "title": "Cardiff / Wales", "child": {},},
                    "coventry": {"selector": "site", "title": "Coventry, UK", "child": {},},
                    "derby": {"selector": "site", "title": "Derby, UK", "child": {},},
                    "devon": {"selector": "site", "title": "Devon & Cornwall", "child": {},},
                    "dundee": {"selector": "site", "title": "Dundee", "child": {},},
                    "eastmids": {"selector": "site", "title": "East Midlands", "child": {},},
                    "edinburgh": {"selector": "site", "title": "Edinburgh", "child": {},},
                    "essex": {"selector": "site", "title": "Essex, UK", "child": {},},
                    "glasgow": {"selector": "site", "title": "Glasgow", "child": {},},
                    "hampshire": {"selector": "site", "title": "Hampshire", "child": {},},
                    "kent": {"selector": "site", "title": "Kent, UK", "child": {},},
                    "leeds": {"selector": "site", "title": "Leeds", "child": {},},
                    "liverpool": {"selector": "site", "title": "Liverpool", "child": {},},
                    "london": {"selector": "site", "title": "London, UK", "child": {},},
                    "manchester": {"selector": "site", "title": "Manchester, UK", "child": {},},
                    "newcastle": {
                        "selector": "site",
                        "title": "Newcastle / Ne England",
                        "child": {},
                    },
                    "norwich": {"selector": "site", "title": "East Anglia", "child": {},},
                    "nottingham": {"selector": "site", "title": "Nottingham, UK", "child": {},},
                    "oxford": {"selector": "site", "title": "Oxford, UK", "child": {},},
                    "sheffield": {"selector": "site", "title": "Sheffield", "child": {},},
                },
            },
        },
    },
    "middle east": {
        "selector": "region",
        "title": "Middle East",
        "child": {
            "egypt": {
                "selector": "country",
                "title": "Egypt",
                "child": {"cairo": {"selector": "site", "title": "Egypt", "child": {},}},
            },
            "iraq": {
                "selector": "country",
                "title": "Iraq",
                "child": {"baghdad": {"selector": "site", "title": "Iraq", "child": {},}},
            },
            "israel_and_palestine": {
                "selector": "country",
                "title": "Israel and Palestine",
                "child": {
                    "haifa": {"selector": "site", "title": "Haifa", "child": {},},
                    "jerusalem": {"selector": "site", "title": "Jerusalem", "child": {},},
                    "ramallah": {"selector": "site", "title": "West Bank", "child": {},},
                    "telaviv": {"selector": "site", "title": "Tel Aviv", "child": {},},
                },
            },
            "kuwait": {
                "selector": "country",
                "title": "Kuwait",
                "child": {"kuwait": {"selector": "site", "title": "Kuwait", "child": {},}},
            },
            "lebanon": {
                "selector": "country",
                "title": "Lebanon",
                "child": {"beirut": {"selector": "site", "title": "Beirut, Lebanon", "child": {},}},
            },
            "turkey": {
                "selector": "country",
                "title": "Turkey",
                "child": {"istanbul": {"selector": "site", "title": "T\u00fcrkiye", "child": {},}},
            },
            "united_arab_emirates": {
                "selector": "country",
                "title": "United Arab Emirates",
                "child": {
                    "dubai": {"selector": "site", "title": "United Arab Emirates", "child": {},}
                },
            },
            "ramallah": {
                "selector": "country",
                "title": "West Bank",
                "child": {"ramallah": {"selector": "site", "title": "West Bank", "child": {},}},
            },
        },
    },
    "oceania": {
        "selector": "region",
        "title": "Oceania",
        "child": {
            "australia": {
                "selector": "country",
                "title": "Australia",
                "child": {
                    "adelaide": {"selector": "site", "title": "Adelaide, SA", "child": {},},
                    "brisbane": {"selector": "site", "title": "Brisbane, QLD", "child": {},},
                    "cairns": {"selector": "site", "title": "Cairns, QLD", "child": {},},
                    "canberra": {"selector": "site", "title": "Canberra, ACT", "child": {},},
                    "darwin": {"selector": "site", "title": "Darwin, NT", "child": {},},
                    "goldcoast": {"selector": "site", "title": "Gold Coast", "child": {},},
                    "hobart": {"selector": "site", "title": "Tasmania", "child": {},},
                    "melbourne": {"selector": "site", "title": "Melbourne, VIC", "child": {},},
                    "ntl": {"selector": "site", "title": "Newcastle, NSW", "child": {},},
                    "perth": {"selector": "site", "title": "Perth, WA", "child": {},},
                    "sydney": {"selector": "site", "title": "Sydney, NSW", "child": {},},
                    "wollongong": {"selector": "site", "title": "Wollongong, NSW", "child": {},},
                },
            },
            "guam_micronesia": {
                "selector": "country",
                "title": "Guam Micronesia",
                "child": {
                    "micronesia": {"selector": "site", "title": "Guam-Micronesia", "child": {},}
                },
            },
            "new_zealand": {
                "selector": "country",
                "title": "New Zealand",
                "child": {
                    "auckland": {"selector": "site", "title": "Auckland, NZ", "child": {},},
                    "christchurch": {"selector": "site", "title": "Christchurch", "child": {},},
                    "dunedin": {"selector": "site", "title": "Dunedin, NZ", "child": {},},
                    "wellington": {"selector": "site", "title": "Wellington", "child": {},},
                },
            },
            "philippines": {
                "selector": "country",
                "title": "Philippines",
                "child": {
                    "bacolod": {"selector": "site", "title": "Bacolod", "child": {},},
                    "cdo": {"selector": "site", "title": "Cagayan De Oro", "child": {},},
                    "cebu": {"selector": "site", "title": "Cebu", "child": {},},
                    "davaocity": {"selector": "site", "title": "Davao City", "child": {},},
                    "iloilo": {"selector": "site", "title": "Iloilo", "child": {},},
                    "manila": {"selector": "site", "title": "Manila", "child": {},},
                    "naga": {"selector": "site", "title": "Bicol Region", "child": {},},
                    "pampanga": {"selector": "site", "title": "Pampanga", "child": {},},
                    "zamboanga": {"selector": "site", "title": "Zamboanga", "child": {},},
                },
            },
        },
    },
}
REGIONS = {
    "africa",
    "americas",
    "asia",
    "europe",
    "middle east",
    "oceania",
}
COUNTRIES = {
    "egypt",
    "ethiopia",
    "ghana",
    "kenya",
    "morocco",
    "south_africa",
    "tunisia",
    "argentina",
    "bolivia",
    "brazil",
    "canada",
    "chile",
    "colombia",
    "costa_rica",
    "dominican_republic",
    "ecuador",
    "el_salvador",
    "guatemala",
    "mexico",
    "nicaragua",
    "panama",
    "peru",
    "puerto_rico",
    "united_states",
    "uruguay",
    "virgin",
    "venezuela",
    "bangladesh",
    "china",
    "hong_kong",
    "india",
    "indonesia",
    "iran",
    "iraq",
    "israel_and_palestine",
    "japan",
    "kuwait",
    "lebanon",
    "malaysia",
    "pakistan",
    "philippines",
    "russia",
    "singapore",
    "korea",
    "taiwan",
    "thailand",
    "turkey",
    "united_arab_emirates",
    "vietnam",
    "ramallah",
    "austria",
    "belgium",
    "bulgaria",
    "croatia",
    "czech_republic",
    "denmark",
    "finland",
    "france",
    "germany",
    "greece",
    "hungary",
    "iceland",
    "ireland",
    "italy",
    "luxembourg",
    "netherlands",
    "norway",
    "poland",
    "portugal",
    "romania",
    "russia",
    "spain",
    "sweden",
    "switzerland",
    "turkey",
    "ukraine",
    "united_kingdom",
    "egypt",
    "iraq",
    "israel_and_palestine",
    "kuwait",
    "lebanon",
    "turkey",
    "united_arab_emirates",
    "ramallah",
    "australia",
    "guam_micronesia",
    "new_zealand",
    "philippines",
}
SITES = {
    "cairo",
    "addisababa",
    "accra",
    "kenya",
    "casablanca",
    "capetown",
    "durban",
    "johannesburg",
    "pretoria",
    "tunis",
    "buenosaires",
    "lapaz",
    "belohorizonte",
    "brasilia",
    "curitiba",
    "fortaleza",
    "portoalegre",
    "recife",
    "rio",
    "salvador",
    "saopaulo",
    "abbotsford",
    "barrie",
    "belleville",
    "brantford",
    "calgary",
    "cariboo",
    "chatham",
    "comoxvalley",
    "cornwall",
    "edmonton",
    "ftmcmurray",
    "guelph",
    "halifax",
    "hamilton",
    "hat",
    "kamloops",
    "kelowna",
    "kingston",
    "kitchener",
    "kootenays",
    "lethbridge",
    "londonon",
    "montreal",
    "nanaimo",
    "newbrunswick",
    "newfoundland",
    "niagara",
    "ottawa",
    "owensound",
    "peace",
    "pei",
    "peterborough",
    "princegeorge",
    "quebec",
    "reddeer",
    "regina",
    "saguenay",
    "sarnia",
    "saskatoon",
    "sherbrooke",
    "skeena",
    "soo",
    "sudbury",
    "sunshine",
    "territories",
    "thunderbay",
    "toronto",
    "troisrivieres",
    "vancouver",
    "whistler",
    "whitehorse",
    "winnipeg",
    "yellowknife",
    "santiago",
    "colombia",
    "costarica",
    "santodomingo",
    "quito",
    "elsalvador",
    "guatemala",
    "acapulco",
    "bajasur",
    "chihuahua",
    "guadalajara",
    "guanajuato",
    "hermosillo",
    "juarez",
    "mazatlan",
    "mexicocity",
    "monterrey",
    "oaxaca",
    "puebla",
    "pv",
    "tijuana",
    "veracruz",
    "yucatan",
    "managua",
    "panama",
    "lima",
    "puertorico",
    "abilene",
    "akroncanton",
    "albany",
    "albanyga",
    "albuquerque",
    "allentown",
    "altoona",
    "amarillo",
    "ames",
    "anchorage",
    "annapolis",
    "annarbor",
    "appleton",
    "asheville",
    "ashtabula",
    "athensga",
    "athensohio",
    "atlanta",
    "auburn",
    "austin",
    "bakersfield",
    "baltimore",
    "batonrouge",
    "battlecreek",
    "beaumont",
    "bellingham",
    "bemidji",
    "bend",
    "bgky",
    "bham",
    "bigbend",
    "billings",
    "binghamton",
    "bismarck",
    "blacksburg",
    "bloomington",
    "bn",
    "boise",
    "boone",
    "boston",
    "boulder",
    "bozeman",
    "brainerd",
    "brownsville",
    "brunswick",
    "buffalo",
    "butte",
    "carbondale",
    "catskills",
    "cedarrapids",
    "cenla",
    "centralmich",
    "cfl",
    "chambana",
    "chambersburg",
    "charleston",
    "charlestonwv",
    "charlotte",
    "charlottesville",
    "chattanooga",
    "chautauqua",
    "chicago",
    "chico",
    "chillicothe",
    "cincinnati",
    "clarksville",
    "cleveland",
    "clovis",
    "cnj",
    "collegestation",
    "columbia",
    "columbiamo",
    "columbus",
    "columbusga",
    "cookeville",
    "corpuschristi",
    "corvallis",
    "cosprings",
    "csd",
    "dallas",
    "danville",
    "dayton",
    "daytona",
    "delaware",
    "denver",
    "desmoines",
    "detroit",
    "dothan",
    "dubuque",
    "duluth",
    "eastco",
    "easternshore",
    "eastidaho",
    "eastky",
    "eastnc",
    "eastoregon",
    "easttexas",
    "eauclaire",
    "elko",
    "elmira",
    "elpaso",
    "enid",
    "erie",
    "eugene",
    "evansville",
    "fairbanks",
    "fargo",
    "farmington",
    "fayar",
    "fayetteville",
    "fingerlakes",
    "flagstaff",
    "florencesc",
    "fortcollins",
    "fortdodge",
    "fortlauderdale",
    "fortmyers",
    "fortsmith",
    "fortwayne",
    "frederick",
    "fredericksburg",
    "fresno",
    "gadsden",
    "galveston",
    "glensfalls",
    "goldcountry",
    "grandforks",
    "grandisland",
    "grandrapids",
    "greatfalls",
    "greenbay",
    "greensboro",
    "greenville",
    "gulfport",
    "hanford",
    "harrisburg",
    "harrisonburg",
    "hartford",
    "hattiesburg",
    "helena",
    "hickory",
    "hiltonhead",
    "holland",
    "honolulu",
    "houma",
    "houston",
    "hudsonvalley",
    "humboldt",
    "huntington",
    "huntsville",
    "imperial",
    "indianapolis",
    "inlandempire",
    "iowacity",
    "ithaca",
    "jackson",
    "jacksontn",
    "jacksonville",
    "janesville",
    "jerseyshore",
    "jonesboro",
    "joplin",
    "juneau",
    "jxn",
    "kalamazoo",
    "kalispell",
    "kansascity",
    "kenai",
    "keys",
    "killeen",
    "kirksville",
    "klamath",
    "knoxville",
    "kokomo",
    "kpr",
    "ksu",
    "lacrosse",
    "lafayette",
    "lakecharles",
    "lakecity",
    "lakeland",
    "lancaster",
    "lansing",
    "laredo",
    "lasalle",
    "lascruces",
    "lasvegas",
    "lawrence",
    "lawton",
    "lewiston",
    "lexington",
    "limaohio",
    "lincoln",
    "littlerock",
    "logan",
    "longisland",
    "losangeles",
    "louisville",
    "loz",
    "lubbock",
    "lynchburg",
    "macon",
    "madison",
    "maine",
    "mankato",
    "mansfield",
    "marshall",
    "martinsburg",
    "masoncity",
    "mattoon",
    "mcallen",
    "meadville",
    "medford",
    "memphis",
    "merced",
    "meridian",
    "miami",
    "milwaukee",
    "minneapolis",
    "missoula",
    "mobile",
    "modesto",
    "mohave",
    "monroe",
    "monroemi",
    "montana",
    "monterey",
    "montgomery",
    "morgantown",
    "moseslake",
    "muncie",
    "muskegon",
    "myrtlebeach",
    "nacogdoches",
    "nashville",
    "natchez",
    "nd",
    "nesd",
    "newhaven",
    "newjersey",
    "newlondon",
    "neworleans",
    "newyork",
    "nh",
    "nmi",
    "norfolk",
    "northernwi",
    "northmiss",
    "northplatte",
    "nwct",
    "nwga",
    "nwks",
    "odessa",
    "ogden",
    "okaloosa",
    "oklahomacity",
    "olympic",
    "omaha",
    "onslow",
    "orangecounty",
    "oregoncoast",
    "orlando",
    "ottumwa",
    "outerbanks",
    "owensboro",
    "palmsprings",
    "panamacity",
    "parkersburg",
    "pennstate",
    "pensacola",
    "peoria",
    "philadelphia",
    "phoenix",
    "pittsburgh",
    "plattsburgh",
    "poconos",
    "porthuron",
    "portland",
    "potsdam",
    "providence",
    "provo",
    "pueblo",
    "pullman",
    "quadcities",
    "quincy",
    "racine",
    "raleigh",
    "rapidcity",
    "reading",
    "redding",
    "reno",
    "richmond",
    "richmondin",
    "roanoke",
    "rochester",
    "rockford",
    "rockies",
    "roswell",
    "sacramento",
    "saginaw",
    "salem",
    "salina",
    "saltlakecity",
    "sanangelo",
    "sanantonio",
    "sandiego",
    "sandusky",
    "sanmarcos",
    "santafe",
    "santamaria",
    "sarasota",
    "savannah",
    "scottsbluff",
    "scranton",
    "sd",
    "seattle",
    "seks",
    "semo",
    "sfbay",
    "sheboygan",
    "shoals",
    "showlow",
    "shreveport",
    "sierravista",
    "siouxcity",
    "siouxfalls",
    "slo",
    "smd",
    "southbend",
    "southcoast",
    "southjersey",
    "spacecoast",
    "spokane",
    "springfield",
    "springfieldil",
    "statesboro",
    "staugustine",
    "stcloud",
    "stgeorge",
    "stillwater",
    "stjoseph",
    "stlouis",
    "stockton",
    "susanville",
    "swks",
    "swmi",
    "swv",
    "swva",
    "syracuse",
    "tallahassee",
    "tampa",
    "terrehaute",
    "texarkana",
    "texoma",
    "thumb",
    "tippecanoe",
    "toledo",
    "topeka",
    "tricities",
    "tucson",
    "tulsa",
    "tuscaloosa",
    "tuscarawas",
    "twinfalls",
    "twintiers",
    "up",
    "utica",
    "valdosta",
    "ventura",
    "vermont",
    "victoriatx",
    "visalia",
    "waco",
    "washingtondc",
    "waterloo",
    "watertown",
    "wausau",
    "wenatchee",
    "westernmass",
    "westky",
    "westmd",
    "westslope",
    "wheeling",
    "wichita",
    "wichitafalls",
    "williamsport",
    "wilmington",
    "winchester",
    "winstonsalem",
    "worcester",
    "wv",
    "wyoming",
    "yakima",
    "york",
    "youngstown",
    "yubasutter",
    "yuma",
    "zanesville",
    "montevideo",
    "virgin",
    "caracas",
    "bangladesh",
    "beijing",
    "chengdu",
    "chongqing",
    "dalian",
    "guangzhou",
    "hangzhou",
    "nanjing",
    "shanghai",
    "shenyang",
    "shenzhen",
    "wuhan",
    "xian",
    "hongkong",
    "ahmedabad",
    "bangalore",
    "bhubaneswar",
    "chandigarh",
    "chennai",
    "delhi",
    "goa",
    "hyderabad",
    "indore",
    "jaipur",
    "kerala",
    "kolkata",
    "lucknow",
    "mumbai",
    "pune",
    "surat",
    "jakarta",
    "tehran",
    "baghdad",
    "haifa",
    "jerusalem",
    "ramallah",
    "telaviv",
    "fukuoka",
    "hiroshima",
    "nagoya",
    "okinawa",
    "osaka",
    "sapporo",
    "sendai",
    "tokyo",
    "kuwait",
    "beirut",
    "malaysia",
    "pakistan",
    "bacolod",
    "cdo",
    "cebu",
    "davaocity",
    "iloilo",
    "manila",
    "naga",
    "pampanga",
    "zamboanga",
    "moscow",
    "stpetersburg",
    "singapore",
    "seoul",
    "taipei",
    "bangkok",
    "istanbul",
    "dubai",
    "vietnam",
    "ramallah",
    "vienna",
    "brussels",
    "bulgaria",
    "zagreb",
    "prague",
    "copenhagen",
    "helsinki",
    "bordeaux",
    "cotedazur",
    "grenoble",
    "lille",
    "loire",
    "lyon",
    "marseilles",
    "montpellier",
    "paris",
    "rennes",
    "rouen",
    "strasbourg",
    "toulouse",
    "berlin",
    "bremen",
    "cologne",
    "dresden",
    "dusseldorf",
    "essen",
    "frankfurt",
    "hamburg",
    "hannover",
    "heidelberg",
    "kaiserslautern",
    "leipzig",
    "munich",
    "nuremberg",
    "stuttgart",
    "athens",
    "budapest",
    "reykjavik",
    "dublin",
    "bologna",
    "florence",
    "genoa",
    "milan",
    "naples",
    "perugia",
    "rome",
    "sardinia",
    "sicily",
    "torino",
    "venice",
    "luxembourg",
    "amsterdam",
    "oslo",
    "warsaw",
    "faro",
    "lisbon",
    "porto",
    "bucharest",
    "moscow",
    "stpetersburg",
    "alicante",
    "baleares",
    "barcelona",
    "bilbao",
    "cadiz",
    "canarias",
    "granada",
    "madrid",
    "malaga",
    "sevilla",
    "valencia",
    "stockholm",
    "basel",
    "bern",
    "geneva",
    "lausanne",
    "zurich",
    "istanbul",
    "ukraine",
    "aberdeen",
    "bath",
    "belfast",
    "birmingham",
    "brighton",
    "bristol",
    "cambridge",
    "cardiff",
    "coventry",
    "derby",
    "devon",
    "dundee",
    "eastmids",
    "edinburgh",
    "essex",
    "glasgow",
    "hampshire",
    "kent",
    "leeds",
    "liverpool",
    "london",
    "manchester",
    "newcastle",
    "norwich",
    "nottingham",
    "oxford",
    "sheffield",
    "cairo",
    "baghdad",
    "haifa",
    "jerusalem",
    "ramallah",
    "telaviv",
    "kuwait",
    "beirut",
    "istanbul",
    "dubai",
    "ramallah",
    "adelaide",
    "brisbane",
    "cairns",
    "canberra",
    "darwin",
    "goldcoast",
    "hobart",
    "melbourne",
    "ntl",
    "perth",
    "sydney",
    "wollongong",
    "micronesia",
    "auckland",
    "christchurch",
    "dunedin",
    "wellington",
    "bacolod",
    "cdo",
    "cebu",
    "davaocity",
    "iloilo",
    "manila",
    "naga",
    "pampanga",
    "zamboanga",
}
AREAS = {
    "bra",
    "drh",
    "mss",
    "oak",
    "tor",
    "yrk",
    "bnc",
    "nvn",
    "pml",
    "rch",
    "rds",
    "van",
    "atl",
    "eat",
    "nat",
    "sat",
    "wat",
    "bmw",
    "gbs",
    "nos",
    "nwb",
    "sob",
    "chc",
    "nch",
    "nwc",
    "nwi",
    "sox",
    "wcl",
    "dal",
    "ftw",
    "mdf",
    "ndf",
    "sdf",
    "mcb",
    "okl",
    "wyn",
    "brw",
    "mdc",
    "pbc",
    "chl",
    "col",
    "lee",
    "ant",
    "lac",
    "lgb",
    "sfv",
    "sgv",
    "wst",
    "brw",
    "mdc",
    "ank",
    "csw",
    "dak",
    "hnp",
    "ram",
    "wsh",
    "brk",
    "brx",
    "fct",
    "jsy",
    "lgi",
    "mnh",
    "que",
    "stn",
    "wch",
    "cph",
    "evl",
    "nph",
    "wvl",
    "clc",
    "clk",
    "grg",
    "mlt",
    "nco",
    "wsc",
    "yam",
    "csd",
    "esd",
    "nsd",
    "ssd",
    "est",
    "kit",
    "oly",
    "see",
    "skc",
    "sno",
    "tac",
    "eby",
    "nby",
    "pen",
    "sby",
    "scz",
    "sfc",
    "hdo",
    "hil",
    "pnl",
    "psc",
}
