"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolClientRedirects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class UserPoolClientRedirects extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'updateUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                    AllowedOAuthFlows: ['code'],
                    AllowedOAuthFlowsUserPoolClient: true,
                    SupportedIdentityProviders: props.identityProviders.map((provider) => provider.name),
                    AllowedOAuthScopes: props.oauthScopes.map((scope) => scope.scopeName),
                    CallbackURLs: props.callbackUrls,
                    LogoutURLs: props.logoutUrls,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-updated-client`),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
    }
}
exports.UserPoolClientRedirects = UserPoolClientRedirects;
_a = JSII_RTTI_SYMBOL_1;
UserPoolClientRedirects[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.UserPoolClientRedirects", version: "1.51.0" };
//# sourceMappingURL=data:application/json;base64,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