"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthFlow = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
class AuthFlow extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const edgeRole = new cdk_lambda_at_edge_pattern_1.EdgeRole(this, 'EdgeRole');
        const configuration = {
            logLevel: props.logLevel,
            httpHeaders: props.httpHeaders,
            redirectPathSignIn: props.redirectPaths.signIn,
            redirectPathAuthRefresh: props.redirectPaths.authRefresh,
            redirectPathSignOut: props.redirectPaths.signOut,
            userPoolId: props.userPool.userPoolId,
            clientId: props.userPoolClient.userPoolClientId,
            oauthScopes: props.oauthScopes.map((scope) => scope.scopeName),
            cognitoAuthDomain: props.cognitoAuthDomain,
            cookieSettings: props.cookieSettings,
            nonceSigningSecret: props.nonceSigningSecret,
            clientSecret: props.clientSecret,
        };
        this.checkAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'CheckAuth', {
            name: 'check-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'check-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.parseAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'ParseAuth', {
            name: 'parse-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'parse-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.refreshAuth = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'RefreshAuth', {
            name: 'refresh-auth',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'refresh-auth')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.signOut = new cdk_lambda_at_edge_pattern_1.EdgeFunction(this, 'SignOut', {
            name: 'sign-out',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'sign-out')),
            edgeRole,
            configuration,
            eventType: aws_cloudfront_1.LambdaEdgeEventType.VIEWER_REQUEST,
        });
        this.httpHeaders = new cdk_lambda_at_edge_pattern_1.HttpHeaders(this, 'HttpHeaders', {
            httpHeaders: props.httpHeaders,
            edgeRole,
        });
    }
}
exports.AuthFlow = AuthFlow;
_a = JSII_RTTI_SYMBOL_1;
AuthFlow[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.AuthFlow", version: "1.51.0" };
//# sourceMappingURL=data:application/json;base64,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