import torch
from torchassistant.utils import pad_sequences
from examples.language_translation.datasets import normalize_string


class InputConverter:
    def __call__(self, x):
        return normalize_string(x)


class InputAdapter:
    def __init__(self, hidden_size, num_classes):
        self.hidden_size = hidden_size
        self.num_classes = num_classes

    def __call__(self, batch: dict) -> dict:
        french_batch = batch["input_1"]
        english_batch = batch["input_2"]

        padded, _ = pad_sequences(english_batch, english_batch[0][-1])
        english_input = torch.LongTensor(padded)[:, :-1]

        hidden = torch.zeros(1, len(french_batch), self.hidden_size, device="cpu")

        return {
            "encoder_model": {
                "x": french_batch,
                "h": hidden
            },
            "decoder_model": {
                "y_shifted": english_input
            }
        }


def build_input_adapter(session, *args, **kwargs):
    p = session.preprocessors["autogenerated_preprocessor_2"]
    kwargs['num_classes'] = p.num_classes
    return InputAdapter(**kwargs)


class NullAdapter:
    def __call__(self, batch):
        return batch


class OutputAdapter:
    def __call__(self, batch):
        english_batch = batch["input_2"]

        batch["input_2"] = [seq[1:] for seq in english_batch]
        return batch


class BatchInferenceAdapter:
    def __init__(self, hidden_size):
        self.hidden_size = hidden_size

    def __call__(self, batch: dict):
        french_batch = batch["input_1"]
        hidden = torch.zeros(1, 1, self.hidden_size, device="cpu")

        return {
            "encoder_model": {
                "x": french_batch,
                "h": hidden
            },
            "decoder_model": {
                "sos": torch.LongTensor([[0]])
            }
        }
