# bselib

Python library for extracting real-time data from Bombay Stock Exchange, MarketMojo and Screeners

## Introduction

bselib is a library for collecting real-time data from Bombay Stock Exchange (India) and historical data from some other sites. It can be used in various types of projects which require getting live quotes, historical data at some extent, corporate news and their actions, ratios, financial statements, credit reports and analysis for projects like portfolio management, stocks simulator and basic data analysis. 

The data is as accurate as provided on the [BSE website](m.bseindia.com).


## Usage

> **Please do not use this application for production usage. It is best used for learning and building application for your own use. For commercial application you better buy a data service.**
>
> **This library uses MIT license hence liability lies with the user and not the author of the application.**

## Features:

* Getting live quotes using companies script codes.
* Getting script codes by search.
* Getting list of top gainers and losers.
* Getting quotes for all the stocks listed on BSE.
* Getting historical summary of corporate's quarterly results, balance sheets, profit-loss and cash-flow statements.
* Getting analysis of finacial statements, quarterly and  annual results. 
* Getting information about corporate's board meetings, dividends, bonus, splits, and rights issued.
* Getting links of credit reports from ICRA and CARE rating agencies.
* Getting corporate's shareholding information.
* Getting corporate's and it's peer's comparisons.
* Getting links of histoarical annual results.
* Getting news related to corporate.
* Getting different financial ratios of corporate.
* Getting analysis regarding corporates performance and valuation. 
* Getting corporates basic business information.

##

## Dependencies

* [BeautifulSoup 4](https://www.crummy.com/software/BeautifulSoup/bs4/doc/)
* [Requests](http://docs.python-requests.org/en/master/)
* [Pandas](https://pandas.pydata.org/docs/)
* [Html5lib](https://html5lib.readthedocs.io/en/latest/)
* [JSON](https://docs.python.org/3/library/json.html)
* A working internet connection

<!-- ## Usage

Refer the documentation at https:// -->

## Contributing
Pull requests are welcome, please open an issue first to discuss what you would like to change.

## Acknowledgements
* Eknath Salvi Sir

## License
This project is licensed under the MIT License